/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.ConfigAdminManager$;
import kafka.server.ConfigHandler;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u4AAC\u0006\u0001%!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0011!I\u0004A!A!\u0002\u0013Q\u0004\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b1\u0003A\u0011A'\t\u000bQ\u0003A\u0011I+\t\u000bY\u0003A\u0011I,\t\u000bY\u0003A\u0011\u00018\t\u000bE\u0004A\u0011\u0001:\u0003-\u0011Kh.Y7jG\u000e{gNZ5h!V\u0014G.[:iKJT!\u0001D\u0007\u0002\u00115,G/\u00193bi\u0006T!AD\b\u0002\rM,'O^3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0005\u0001MIr\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035ui\u0011a\u0007\u0006\u00039=\tQ!\u001e;jYNL!AH\u000e\u0003\u000f1{wmZ5oOB\u0011\u0001EK\u0007\u0002C)\u0011!eI\u0001\naV\u0014G.[:iKJT!\u0001J\u0013\u0002\u000b%l\u0017mZ3\u000b\u0005A1#BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001eL!aK\u0011\u0003#5+G/\u00193bi\u0006\u0004VO\u00197jg\",'/\u0001\u0003d_:4\u0007C\u0001\u00180\u001b\u0005i\u0011B\u0001\u0019\u000e\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0019\u0019\fW\u000f\u001c;IC:$G.\u001a:\u0011\u0005M:T\"\u0001\u001b\u000b\u0005U2\u0014!\u00024bk2$(B\u0001\b&\u0013\tADG\u0001\u0007GCVdG\u000fS1oI2,'/A\u000bes:\fW.[2D_:4\u0017n\u001a%b]\u0012dWM]:\u0011\tm\u0012U\t\u0013\b\u0003y\u0001\u0003\"!P\u000b\u000e\u0003yR!aP\t\u0002\rq\u0012xn\u001c;?\u0013\t\tU#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u00131!T1q\u0015\t\tU\u0003\u0005\u0002<\r&\u0011q\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u0011\u00059J\u0015B\u0001&\u000e\u00055\u0019uN\u001c4jO\"\u000bg\u000e\u001a7fe\u0006Aan\u001c3f)f\u0004X-\u0001\u0004=S:LGO\u0010\u000b\u0006\u001dB\u000b&k\u0015\t\u0003\u001f\u0002i\u0011a\u0003\u0005\u0006Y\u0015\u0001\r!\f\u0005\u0006c\u0015\u0001\rA\r\u0005\u0006s\u0015\u0001\rA\u000f\u0005\u0006\u0017\u0016\u0001\r!R\u0001\u0005]\u0006lW\rF\u0001F\u0003Ayg.T3uC\u0012\fG/Y+qI\u0006$X\r\u0006\u0003Y7\u00064\u0007C\u0001\u000bZ\u0013\tQVC\u0001\u0003V]&$\b\"\u0002/\b\u0001\u0004i\u0016!\u00023fYR\f\u0007C\u00010`\u001b\u0005\u0019\u0013B\u00011$\u00055iU\r^1eCR\fG)\u001a7uC\")!m\u0002a\u0001G\u0006Aa.Z<J[\u0006<W\r\u0005\u0002_I&\u0011Qm\t\u0002\u000e\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\t\u000b\u001d<\u0001\u0019\u00015\u0002\u00115\fg.\u001b4fgR\u0004\"!\u001b7\u000e\u0003)T!a[\u0012\u0002\r1|\u0017\rZ3s\u0013\ti'N\u0001\bM_\u0006$WM]'b]&4Wm\u001d;\u0015\u0007a{\u0007\u000fC\u0003]\u0011\u0001\u0007Q\fC\u0003c\u0011\u0001\u00071-A\u0013sK2|\u0017\rZ+qI\u0006$X\r\u001a$jY\u0016\u001cx+\u001b;i_V$8i\u001c8gS\u001e\u001c\u0005.\u00198hKR\u0011\u0001l\u001d\u0005\u0006i&\u0001\r!^\u0001\u0006aJ|\u0007o\u001d\t\u0003mnl\u0011a\u001e\u0006\u0003qf\fA!\u001e;jY*\t!0\u0001\u0003kCZ\f\u0017B\u0001?x\u0005)\u0001&o\u001c9feRLWm\u001d")
public class DynamicConfigPublisher
implements Logging,
MetadataPublisher {
    private final KafkaConfig conf;
    private final FaultHandler faultHandler;
    private final Map<String, ConfigHandler> dynamicConfigHandlers;
    private final String nodeType;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    public void close() throws Exception {
        super.close();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return new StringBuilder(27).append("DynamicConfigPublisher ").append(this.nodeType).append(" id=").append(this.conf.nodeId()).toString();
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        this.onMetadataUpdate(delta, newImage);
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage) {
        String deltaName = new StringBuilder(20).append("MetadataDelta up to ").append(newImage.highestOffsetAndEpoch().offset()).toString();
        try {
            Option$.MODULE$.apply((Object)delta.configsDelta()).foreach((Function1 & Serializable & scala.Serializable)configsDelta -> {
                DynamicConfigPublisher.$anonfun$onMetadataUpdate$1(this, newImage, deltaName, configsDelta);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (Throwable t) {
            this.faultHandler.handleFault(new StringBuilder(71).append("Uncaught exception while ").append("publishing dynamic configuration changes from ").append(deltaName).toString(), t);
            return;
        }
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.conf.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$1(DynamicConfigPublisher $this, MetadataImage newImage$1, String deltaName$1, ConfigurationsDelta configsDelta) {
        configsDelta.changes().keySet().forEach(resource -> {
            Properties props = newImage$1.configs().configProperties(resource);
            ConfigResource.Type type = resource.type();
            if (ConfigResource.Type.TOPIC.equals(type)) {
                $this.dynamicConfigHandlers.get((Object)"topics").foreach((Function1 & Serializable & scala.Serializable)topicConfigHandler -> {
                    try {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Updating topic ").append(resource.name()).append(" with new configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                        topicConfigHandler.processConfigChanges(resource.name(), props);
                        return BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        return $this.faultHandler.handleFault(new StringBuilder(50).append("Error updating topic ").append(resource.name()).append(" with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                    }
                });
                return;
            }
            if (ConfigResource.Type.BROKER.equals(type)) {
                $this.dynamicConfigHandlers.get((Object)"brokers").foreach((Function1 & Serializable & scala.Serializable)nodeConfigHandler -> {
                    if (resource.name().isEmpty()) {
                        try {
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Updating cluster configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                            nodeConfigHandler.processConfigChanges("<default>", props);
                            return BoxedUnit.UNIT;
                        }
                        catch (Throwable t) {
                            return $this.faultHandler.handleFault(new StringBuilder(51).append("Error updating ").append("cluster with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                        }
                    }
                    String string = resource.name();
                    String string2 = Integer.toString($this.conf.nodeId());
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        try {
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Updating node ").append($this.conf.nodeId()).append(" with new configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                            nodeConfigHandler.processConfigChanges(resource.name(), props);
                            $this.reloadUpdatedFilesWithoutConfigChange(props);
                            return BoxedUnit.UNIT;
                        }
                        catch (Throwable t) {
                            return $this.faultHandler.handleFault(new StringBuilder(48).append("Error updating ").append("node with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                        }
                    }
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (ConfigResource.Type.CLIENT_METRICS.equals(type)) {
                $this.dynamicConfigHandlers.get((Object)"client-metrics").foreach((Function1 & Serializable & scala.Serializable)metricsConfigHandler -> {
                    try {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Updating client metrics ").append(resource.name()).append(" with new configuration : ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).toString());
                        metricsConfigHandler.processConfigChanges(resource.name(), props);
                        return BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        return $this.faultHandler.handleFault(new StringBuilder(58).append("Error updating client metrics").append(resource.name()).append(" with new configuration: ").append(ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",")).append(" ").append("in ").append(deltaName$1).toString(), t);
                    }
                });
                return;
            }
        });
    }

    public DynamicConfigPublisher(KafkaConfig conf, FaultHandler faultHandler, Map<String, ConfigHandler> dynamicConfigHandlers, String nodeType) {
        this.conf = conf;
        this.faultHandler = faultHandler;
        this.dynamicConfigHandlers = dynamicConfigHandlers;
        this.nodeType = nodeType;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(3).append("[").append(this.name()).append("] ").toString());
    }
}

