/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.controller.ReplicaAssignment;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBQ\u0001\u000e\u0001\u0005BUBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004>\u0001\u0001\u0006IA\u000e\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0011\u0019A\u0005\u0001)A\u0005\u0001\"9\u0011\n\u0001b\u0001\n\u0003Q\u0005BB-\u0001A\u0003%1\nC\u0004[\u0001\t\u0007I\u0011A \t\rm\u0003\u0001\u0015!\u0003A\u0011\u001da\u0006A1A\u0005\u0002)Ca!\u0018\u0001!\u0002\u0013Y\u0005b\u00020\u0001\u0005\u0004%\ta\u0010\u0005\u0007?\u0002\u0001\u000b\u0011\u0002!\t\u000f\u0001\u0004!\u0019!C\u0001\u0015\"1\u0011\r\u0001Q\u0001\n-CqA\u0019\u0001C\u0002\u0013\u0005q\b\u0003\u0004d\u0001\u0001\u0006I\u0001\u0011\u0005\bI\u0002\u0011\r\u0011\"\u0001K\u0011\u0019)\u0007\u0001)A\u0005\u0017\"9a\r\u0001b\u0001\n\u0003y\u0004BB4\u0001A\u0003%\u0001\tC\u0004i\u0001\t\u0007I\u0011\u0001&\t\r%\u0004\u0001\u0015!\u0003L\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015A\b\u0001\"\u0001l\u0011\u0015i\b\u0001\"\u0001l\u0011\u0015y\b\u0001\"\u0001l\u0011\u0019\t\u0019\u0001\u0001C\u0001W\"1\u0011q\u0001\u0001\u0005\u0002-Da!a\u0003\u0001\t\u0003Y\u0007bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003O\u0002A\u0011BA5\u0011%\t\u0019\nAI\u0001\n\u0013\t)JA\tBI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+fgRT!!\n\u0014\u0002\u000b\u0005$W.\u001b8\u000b\u0003\u001d\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001UA\u00111FL\u0007\u0002Y)\u0011QFJ\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005=b#a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0011\u0004CA\u001a\u0001\u001b\u0005!\u0013a\u00032s_.,'oQ8v]R,\u0012A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0004\u0013:$\u0018a\u00039beRLG/[8o\u0013\u0012\fA\u0002]1si&$\u0018n\u001c8JI\u0002\na\u0001^8qS\u000e\fT#\u0001!\u0011\u0005\u00053U\"\u0001\"\u000b\u0005\r#\u0015\u0001\u00027b]\u001eT\u0011!R\u0001\u0005U\u00064\u0018-\u0003\u0002H\u0005\n11\u000b\u001e:j]\u001e\fq\u0001^8qS\u000e\f\u0004%\u0001\tu_BL7-M!tg&<g.\\3oiV\t1\n\u0005\u0003M#Z\u001aV\"A'\u000b\u00059{\u0015!C5n[V$\u0018M\u00197f\u0015\t\u0001\u0006(\u0001\u0006d_2dWm\u0019;j_:L!AU'\u0003\u00075\u000b\u0007\u000f\u0005\u0002U/6\tQK\u0003\u0002WM\u0005Q1m\u001c8ue>dG.\u001a:\n\u0005a+&!\u0005*fa2L7-Y!tg&<g.\\3oi\u0006\tBo\u001c9jGF\n5o]5h]6,g\u000e\u001e\u0011\u0002\rQ|\u0007/[23\u0003\u001d!x\u000e]5de\u0001\n\u0001\u0003^8qS\u000e\u0014\u0014i]:jO:lWM\u001c;\u0002#Q|\u0007/[23\u0003N\u001c\u0018n\u001a8nK:$\b%\u0001\u0004u_BL7mM\u0001\bi>\u0004\u0018nY\u001a!\u0003A!x\u000e]5dg\u0005\u001b8/[4o[\u0016tG/A\tu_BL7mM!tg&<g.\\3oi\u0002\na\u0001^8qS\u000e$\u0014a\u0002;pa&\u001cG\u0007I\u0001\u0011i>\u0004\u0018n\u0019\u001bBgNLwM\\7f]R\f\u0011\u0003^8qS\u000e$\u0014i]:jO:lWM\u001c;!\u0003\u0019!x\u000e]5dk\u00059Ao\u001c9jGV\u0002\u0013\u0001\u0005;pa&\u001cW'Q:tS\u001etW.\u001a8u\u0003E!x\u000e]5dk\u0005\u001b8/[4o[\u0016tG\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002YB\u0011q'\\\u0005\u0003]b\u0012A!\u00168ji\"\u0012\u0011\u0004\u001d\t\u0003cZl\u0011A\u001d\u0006\u0003gR\fQA[;oSRT\u0011!^\u0001\u0004_J<\u0017BA<s\u0005\u0019\u0011UMZ8sK\u0006)B/Z:u/J|gn\u001a*fa2L7-Y\"pk:$\bF\u0001\u000e{!\t\t80\u0003\u0002}e\n!A+Z:u\u0003U!Xm\u001d;NSN\u001c\u0018N\\4QCJ$\u0018\u000e^5p]BB#a\u0007>\u0002/Q,7\u000f^%oGJ,W.\u001a8u!\u0006\u0014H/\u001b;j_:\u001c\bF\u0001\u000f{\u0003y!Xm\u001d;NC:,\u0018\r\\!tg&<g.\\3oi>3'+\u001a9mS\u000e\f7\u000f\u000b\u0002\u001eu\u0006qB/Z:u%\u0016\u0004H.[2b!2\f7-Z7f]R\fE\u000e\\*feZ,'o\u001d\u0015\u0003=i\f!\u0005^3tiJ+\u0007\u000f\\5dCBc\u0017mY3nK:$\b+\u0019:uS\u0006d7+\u001a:wKJ\u001c\bFA\u0010{\u0003e1\u0018\r\\5eCR,G*Z1eKJ\fe\u000e\u001a*fa2L7-Y:\u0015\u00131\f\u0019\"!\u0014\u0002P\u0005M\u0003bBA\u000bA\u0001\u0007\u0011qC\u0001\t[\u0016$\u0018\rZ1uCB!\u0011\u0011DA$\u001d\u0011\tY\"!\u0011\u000f\t\u0005u\u00111\b\b\u0005\u0003?\t)D\u0004\u0003\u0002\"\u0005Eb\u0002BA\u0012\u0003[qA!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003SA\u0013A\u0002\u001fs_>$h(C\u0001v\u0013\r\ty\u0003^\u0001\u0007CB\f7\r[3\n\u0007\u001d\n\u0019DC\u0002\u00020QLA!a\u000e\u0002:\u000511m\\7n_:T1aJA\u001a\u0013\u0011\ti$a\u0010\u0002\u0011I,\u0017/^3tiNTA!a\u000e\u0002:%!\u00111IA#\u0003AiU\r^1eCR\f'+Z:q_:\u001cXM\u0003\u0003\u0002>\u0005}\u0012\u0002BA%\u0003\u0017\u0012Q\u0002V8qS\u000elU\r^1eCR\f'\u0002BA\"\u0003\u000bBQ\u0001\u0010\u0011A\u0002YBa!!\u0015!\u0001\u00041\u0014\u0001E3ya\u0016\u001cG/\u001a3MK\u0006$WM]%e\u0011\u001d\t)\u0006\ta\u0001\u0003/\n\u0001#\u001a=qK\u000e$X\r\u001a*fa2L7-Y:\u0011\u000b\u0005e\u0013\u0011\r\u001c\u000f\t\u0005m\u0013Q\f\t\u0004\u0003KA\u0014bAA0q\u00051\u0001K]3eK\u001aLA!a\u0019\u0002f\t\u00191+\u001a;\u000b\u0007\u0005}\u0003(A\ntK:$W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000f\u0006\u0004\u0002l\u0005M\u0014Q\u0010\t\u0005\u0003[\ny'\u0004\u0002\u0002F%!\u0011\u0011OA#\u0005AiU\r^1eCR\f'+Z:q_:\u001cX\rC\u0004\u0002v\u0005\u0002\r!a\u001e\u0002\u000fI,\u0017/^3tiB!\u0011QNA=\u0013\u0011\tY(!\u0012\u0003\u001f5+G/\u00193bi\u0006\u0014V-];fgRD\u0011\"a \"!\u0003\u0005\r!!!\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\t\u0006o\u0005\r\u0015qQ\u0005\u0004\u0003\u000bC$AB(qi&|g\u000e\u0005\u0003\u0002\n\u0006=UBAAF\u0015\r\tiIJ\u0001\b]\u0016$xo\u001c:l\u0013\u0011\t\t*a#\u0003\u0019M{7m[3u'\u0016\u0014h/\u001a:\u0002;M,g\u000eZ'fi\u0006$\u0017\r^1SKF,Xm\u001d;%I\u00164\u0017-\u001e7uII*\"!a&+\t\u0005\u0005\u0015\u0011T\u0016\u0003\u00037\u0003B!!(\u0002(6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0015\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0006}%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class AddPartitionsTest
extends BaseRequestTest {
    private final int partitionId;
    private final String topic1;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment;
    private final String topic2;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment;
    private final String topic3;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment;
    private final String topic4;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment;
    private final String topic5;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment;

    @Override
    public int brokerCount() {
        return 4;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic1Assignment() {
        return this.topic1Assignment;
    }

    public String topic2() {
        return this.topic2;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic2Assignment() {
        return this.topic2Assignment;
    }

    public String topic3() {
        return this.topic3;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic3Assignment() {
        return this.topic3Assignment;
    }

    public String topic4() {
        return this.topic4;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic4Assignment() {
        return this.topic4Assignment;
    }

    public String topic5() {
        return this.topic5;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> topic5Assignment() {
        return this.topic5Assignment;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic1(), (Map<Object, Seq<Object>>)this.topic1Assignment().mapValues((Function1 & Serializable & scala.Serializable)x$1 -> x$1.replicas()).toMap(Predef$.MODULE$.$conforms()));
        this.createTopic(this.topic2(), (Map<Object, Seq<Object>>)this.topic2Assignment().mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.replicas()).toMap(Predef$.MODULE$.$conforms()));
        this.createTopic(this.topic3(), (Map<Object, Seq<Object>>)this.topic3Assignment().mapValues((Function1 & Serializable & scala.Serializable)x$3 -> x$3.replicas()).toMap(Predef$.MODULE$.$conforms()));
        this.createTopic(this.topic4(), (Map<Object, Seq<Object>>)this.topic4Assignment().mapValues((Function1 & Serializable & scala.Serializable)x$4 -> x$4.replicas()).toMap(Predef$.MODULE$.$conforms()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWrongReplicaCount() {
        try {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            AdminZkClient qual$1 = this.adminZkClient();
            String x$3 = this.topic1();
            scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic1Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
            Option x$2 = qual$2.getBrokerMetadatas$default$2();
            Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
            int x$6 = 2;
            Tuple2[] tuple2Array = new Tuple2[2];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
            boolean x$8 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$8);
            Assert.fail((String)"Add partitions should fail");
            return;
        }
        catch (InvalidReplicaAssignmentException invalidReplicaAssignmentException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMissingPartition0() {
        try {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            AdminZkClient qual$1 = this.adminZkClient();
            String x$3 = this.topic5();
            scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic5Assignment();
            AdminZkClient qual$2 = this.adminZkClient();
            RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
            Option x$2 = qual$2.getBrokerMetadatas$default$2();
            Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
            int x$6 = 2;
            Tuple2[] tuple2Array = new Tuple2[2];
            GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
            boolean x$8 = qual$1.addPartitions$default$6();
            qual$1.addPartitions(x$3, x$4, x$5, x$6, (Option)x$7, x$8);
            Assert.fail((String)"Add partitions should fail");
            return;
        }
        catch (AdminOperationException adminOperationException) {
            Assert.assertTrue((boolean)adminOperationException.getMessage().contains("Unexpected existing replica assignment for topic 'new-topic5', partition id 0 is missing"));
            return;
        }
    }

    @Test
    public void testIncrementPartitions() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic1();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic1Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$52 = qual$2.getBrokerMetadatas(x$1, x$2);
        int x$6 = 3;
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$52, x$6, x$7, x$8);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic1(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        Buffer partitions = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)partitions.size(), (long)3L);
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitions.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitions.apply(1)).replicas();
        Assert.assertEquals((long)replicas.size(), (long)2L);
        Assert.assertTrue((boolean)replicas.contains(((MetadataResponse.PartitionMetadata)partitions.apply(1)).leader()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testManualAssignmentOfReplicas() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic2();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic2Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
        int x$62 = 3;
        Tuple2[] tuple2Array = new Tuple2[3];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        GenTraversable genTraversable3 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$62, (Option)x$7, x$8);
        int leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 1)).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic2(), 2)).get());
        Assert.assertEquals((long)leader1, (long)leader1FromZk);
        Assert.assertEquals((long)leader2, (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        Buffer partitionMetadata = (Buffer)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.partition()), (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)3L, (long)topicMetadata.partitionMetadata().size());
        Assert.assertEquals((long)0L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(0)).partition());
        Assert.assertEquals((long)1L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).partition());
        Assert.assertEquals((long)2L, (long)((MetadataResponse.PartitionMetadata)partitionMetadata.apply(2)).partition());
        List replicas = ((MetadataResponse.PartitionMetadata)partitionMetadata.apply(1)).replicas();
        Assert.assertEquals((long)2L, (long)replicas.size());
        Assert.assertTrue((((Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).head()).id() == 0 || ((Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).head()).id() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Node)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).apply(1)).id() == 0 || ((Node)((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).apply(1)).id() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReplicaPlacementAllServers() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic3();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic3Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
        int x$6 = 7;
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, x$7, x$8);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 3, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 4, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 5, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic3(), 6, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic3()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 3, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(topicMetadata, 4, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(topicMetadata, 5, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 6, 0, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @Test
    public void testReplicaPlacementPartialServers() {
        AdminZkClient qual$1 = this.adminZkClient();
        String x$3 = this.topic2();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.topic2Assignment();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$1 = qual$2.getBrokerMetadatas$default$1();
        Option x$2 = qual$2.getBrokerMetadatas$default$2();
        Seq x$5 = qual$2.getBrokerMetadatas(x$1, x$2);
        int x$6 = 3;
        Option x$7 = qual$1.addPartitions$default$5();
        boolean x$8 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$3, x$4, x$5, x$6, x$7, x$8);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        MetadataResponse response = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()}))).asJava(), false).build(), this.sendMetadataRequest$default$2());
        Assert.assertEquals((long)1L, (long)response.topicMetadata().size());
        MetadataResponse.TopicMetadata topicMetadata = (MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head();
        this.validateLeaderAndReplicas(topicMetadata, 0, 1, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 1, 2, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(topicMetadata, 2, 3, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(MetadataResponse.TopicMetadata metadata, int partitionId, int expectedLeaderId, Set<Object> expectedReplicas) {
        Option partitionOpt = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.partitionMetadata()).asScala()).find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AddPartitionsTest.$anonfun$validateLeaderAndReplicas$1(partitionId, x$7)));
        Assert.assertTrue((String)new StringBuilder(23).append("Partition ").append(partitionId).append(" should exist").toString(), (boolean)partitionOpt.isDefined());
        MetadataResponse.PartitionMetadata partition = (MetadataResponse.PartitionMetadata)partitionOpt.get();
        Assert.assertNotNull((String)"Partition leader should exist", (Object)partition.leader());
        Assert.assertEquals((String)"Partition leader id should match", (long)expectedLeaderId, (long)partition.leaderId());
        Assert.assertEquals((String)"Replica set should match", expectedReplicas, (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()), Buffer$.MODULE$.canBuildFrom())).toSet());
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        if (destination == null) {
            throw null;
        }
        Object object = destination.isEmpty() ? this.anySocketServer() : destination.get();
        return MetadataResponse.parse((ByteBuffer)this.connectAndSend((AbstractRequest)request, ApiKeys.METADATA, (SocketServer)object, this.connectAndSend$default$4(), this.connectAndSend$default$5()), (short)request.version());
    }

    private Option<SocketServer> sendMetadataRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$validateLeaderAndReplicas$1(int partitionId$1, MetadataResponse.PartitionMetadata x$7) {
        return x$7.partition() == partitionId$1;
    }

    /*
     * WARNING - void declaration
     */
    public AddPartitionsTest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        Tuple2[] tuple2Array = new Tuple2[1];
        ReplicaAssignment replicaAssignment = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        this.topic1Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.topic2 = "new-topic2";
        Tuple2[] tuple2Array2 = new Tuple2[1];
        ReplicaAssignment replicaAssignment2 = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        this.topic2Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        this.topic3 = "new-topic3";
        Tuple2[] tuple2Array3 = new Tuple2[1];
        ReplicaAssignment replicaAssignment3 = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        this.topic3Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3));
        this.topic4 = "new-topic4";
        Tuple2[] tuple2Array4 = new Tuple2[1];
        ReplicaAssignment replicaAssignment4 = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        this.topic4Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4));
        this.topic5 = "new-topic5";
        Tuple2[] tuple2Array5 = new Tuple2[1];
        ReplicaAssignment replicaAssignment5 = new ReplicaAssignment((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.topic5Assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5));
    }
}

