/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.PartitionStateStore;
import kafka.cluster.Replica;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.Defaults$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r5a\u0001\u0002(P\u0001QCQa\u0017\u0001\u0005\u0002qCqa\u0018\u0001C\u0002\u0013\u0005\u0001\r\u0003\u0004e\u0001\u0001\u0006I!\u0019\u0005\bK\u0002\u0011\r\u0011\"\u0001g\u0011\u0019\u0011\b\u0001)A\u0005O\"91\u000f\u0001b\u0001\n\u0003!\bBB>\u0001A\u0003%Q\u000fC\u0005}\u0001\u0001\u0007\t\u0019!C\u0001{\"Y\u0011Q\u0002\u0001A\u0002\u0003\u0007I\u0011AA\b\u0011)\tY\u0002\u0001a\u0001\u0002\u0003\u0006KA \u0005\u000b\u0003;\u0001\u0001\u0019!a\u0001\n\u0003i\bbCA\u0010\u0001\u0001\u0007\t\u0019!C\u0001\u0003CA!\"!\n\u0001\u0001\u0004\u0005\t\u0015)\u0003\u007f\u0011)\t9\u0003\u0001a\u0001\u0002\u0004%\t! \u0005\f\u0003S\u0001\u0001\u0019!a\u0001\n\u0003\tY\u0003\u0003\u0006\u00020\u0001\u0001\r\u0011!Q!\nyD1\"!\r\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00024!Y\u0011\u0011\t\u0001A\u0002\u0003\u0007I\u0011AA\"\u0011-\t9\u0005\u0001a\u0001\u0002\u0003\u0006K!!\u000e\t\u0017\u0005%\u0003\u00011AA\u0002\u0013\u0005\u00111\n\u0005\f\u0003'\u0002\u0001\u0019!a\u0001\n\u0003\t)\u0006C\u0006\u0002Z\u0001\u0001\r\u0011!Q!\n\u00055\u0003\"CA.\u0001\t\u0007I\u0011AA/\u0011!\t)\u0007\u0001Q\u0001\n\u0005}\u0003\"CA4\u0001\t\u0007I\u0011AA5\u0011!\t\t\b\u0001Q\u0001\n\u0005-\u0004\"CA:\u0001\t\u0007I\u0011AA;\u0011!\t\u0019\t\u0001Q\u0001\n\u0005]\u0004\"CAC\u0001\t\u0007I\u0011AAD\u0011!\t)\n\u0001Q\u0001\n\u0005%\u0005bCAL\u0001\u0001\u0007\t\u0019!C\u0001\u00033C1\"!)\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002$\"Y\u0011q\u0015\u0001A\u0002\u0003\u0005\u000b\u0015BAN\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!a/\u0001\t\u0013\ti\fC\u0004\u0002l\u0002!\t!a+\t\u000f\u0005U\b\u0001\"\u0001\u0002,\"9\u0011q \u0001\u0005\u0002\u0005-\u0006b\u0002B\u0002\u0001\u0011\u0005\u00111\u0016\u0005\b\u0005\u000f\u0001A\u0011AAV\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003WCqAa\u0004\u0001\t\u0003\tY\u000bC\u0004\u0003\u0014\u0001!\t!a+\t\u000f\t]\u0001\u0001\"\u0001\u0002,\"9!1\u0004\u0001\u0005\u0002\u0005-\u0006b\u0002B\u0010\u0001\u0011\u0005\u00111\u0016\u0005\b\u0005G\u0001A\u0011AAV\u0011\u001d\u00119\u0003\u0001C\u0001\u0003WCqAa\u000b\u0001\t\u0003\tY\u000bC\u0004\u00030\u0001!\t!a+\t\u000f\tM\u0002\u0001\"\u0003\u00036!I!Q\n\u0001\u0012\u0002\u0013%!q\n\u0005\b\u0005K\u0002A\u0011AAV\u0011\u001d\u0011I\u0007\u0001C\u0001\u0003WCqA!\u001c\u0001\t\u0003\tY\u000bC\u0004\u0003r\u0001!\t!a+\t\u000f\tU\u0004\u0001\"\u0001\u0002,\"9!\u0011\u0010\u0001\u0005\u0002\u0005-\u0006b\u0002B?\u0001\u0011\u0005\u00111\u0016\u0005\b\u0005\u0003\u0003A\u0011\u0001BB\u0011%\u0011Y\fAI\u0001\n\u0003\u0011i\fC\u0004\u0003B\u0002!\tAa1\t\u0013\t-\u0007!%A\u0005\u0002\tu\u0006b\u0002Bg\u0001\u0011\u0005\u00111\u0016\u0005\b\u0005#\u0004A\u0011AAV\u0011\u001d\u0011)\u000e\u0001C\u0001\u0003WCqA!7\u0001\t\u0003\tY\u000bC\u0004\u0003^\u0002!\t!a+\t\u000f\t\u0005\b\u0001\"\u0001\u0002,\"9!Q\u001d\u0001\u0005\u0002\u0005-\u0006b\u0002Bu\u0001\u0011\u0005\u00111\u0016\u0005\b\u0005[\u0004A\u0011AAV\u0011\u001d\u0011\t\u0010\u0001C\u0001\u0003WCqA!>\u0001\t\u0003\tY\u000bC\u0004\u0003z\u0002!\t!a+\t\u000f\tu\b\u0001\"\u0001\u0002,\"91\u0011\u0001\u0001\u0005\n\r\r!!\u0004)beRLG/[8o)\u0016\u001cHO\u0003\u0002Q#\u000691\r\\;ti\u0016\u0014(\"\u0001*\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00021\u0006)1oY1mC&\u0011!l\u0016\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0006C\u00010\u0001\u001b\u0005y\u0015\u0001\u00032s_.,'/\u00133\u0016\u0003\u0005\u0004\"A\u00162\n\u0005\r<&aA%oi\u0006I!M]8lKJLE\rI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u00059\u0007C\u00015q\u001b\u0005I'B\u00016l\u0003\u0019\u0019w.\\7p]*\u0011!\u000b\u001c\u0006\u0003[:\fa!\u00199bG\",'\"A8\u0002\u0007=\u0014x-\u0003\u0002rS\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\tQLW.Z\u000b\u0002kB\u0011a/_\u0007\u0002o*\u0011\u00010U\u0001\u0006kRLGn]\u0005\u0003u^\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0007i6\u0004H)\u001b:\u0016\u0003y\u00042a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011AA5p\u0015\t\t9!\u0001\u0003kCZ\f\u0017\u0002BA\u0006\u0003\u0003\u0011AAR5mK\u0006QA/\u001c9ESJ|F%Z9\u0015\t\u0005E\u0011q\u0003\t\u0004-\u0006M\u0011bAA\u000b/\n!QK\\5u\u0011!\tI\"CA\u0001\u0002\u0004q\u0018a\u0001=%c\u00059A/\u001c9ESJ\u0004\u0013a\u00027pO\u0012K'/M\u0001\fY><G)\u001b:2?\u0012*\u0017\u000f\u0006\u0003\u0002\u0012\u0005\r\u0002\u0002CA\r\u0019\u0005\u0005\t\u0019\u0001@\u0002\u00111|w\rR5sc\u0001\nq\u0001\\8h\t&\u0014('A\u0006m_\u001e$\u0015N\u001d\u001a`I\u0015\fH\u0003BA\t\u0003[A\u0001\"!\u0007\u0010\u0003\u0003\u0005\rA`\u0001\tY><G)\u001b:3A\u0005QAn\\4NC:\fw-\u001a:\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003{i!!!\u000f\u000b\u0007\u0005m\u0012+A\u0002m_\u001eLA!a\u0010\u0002:\tQAj\\4NC:\fw-\u001a:\u0002\u001d1|w-T1oC\u001e,'o\u0018\u0013fcR!\u0011\u0011CA#\u0011%\tIBEA\u0001\u0002\u0004\t)$A\u0006m_\u001el\u0015M\\1hKJ\u0004\u0013!\u00037pO\u000e{gNZ5h+\t\ti\u0005\u0005\u0003\u00028\u0005=\u0013\u0002BA)\u0003s\u0011\u0011\u0002T8h\u0007>tg-[4\u0002\u001b1|wmQ8oM&<w\fJ3r)\u0011\t\t\"a\u0016\t\u0013\u0005eQ#!AA\u0002\u00055\u0013A\u00037pO\u000e{gNZ5hA\u0005Q1\u000f^1uKN#xN]3\u0016\u0005\u0005}\u0003c\u00010\u0002b%\u0019\u00111M(\u0003'A\u000b'\u000f^5uS>t7\u000b^1uKN#xN]3\u0002\u0017M$\u0018\r^3Ti>\u0014X\rI\u0001\u0012I\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u001cXCAA6!\rq\u0016QN\u0005\u0004\u0003_z%!\u0005#fY\u0006LX\rZ(qKJ\fG/[8og\u0006\u0011B-\u001a7bs\u0016$w\n]3sCRLwN\\:!\u00035iW\r^1eCR\f7)Y2iKV\u0011\u0011q\u000f\t\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011QP)\u0002\rM,'O^3s\u0013\u0011\t\t)a\u001f\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u00039iW\r^1eCR\f7)Y2iK\u0002\n\u0011c\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;t+\t\tI\t\u0005\u0003\u0002\f\u0006EUBAAG\u0015\u0011\ty)a\u001f\u0002\u0017\rDWmY6q_&tGo]\u0005\u0005\u0003'\u000biIA\tPM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oiN\f!c\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;tA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0003\u00037\u00032AXAO\u0013\r\tyj\u0014\u0002\n!\u0006\u0014H/\u001b;j_:\fQ\u0002]1si&$\u0018n\u001c8`I\u0015\fH\u0003BA\t\u0003KC\u0011\"!\u0007!\u0003\u0003\u0005\r!a'\u0002\u0015A\f'\u000f^5uS>t\u0007%A\u0003tKR,\b\u000f\u0006\u0002\u0002\u0012!\u001a!%a,\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gS1!!.o\u0003\u0015QWO\\5u\u0013\u0011\tI,a-\u0003\r\t+gm\u001c:f\u0003M\u0019'/Z1uK2{w\r\u0015:pa\u0016\u0014H/[3t)\u0011\ty,a3\u0011\t\u0005\u0005\u0017qY\u0007\u0003\u0003\u0007TA!!2\u0002\u0006\u0005!Q\u000f^5m\u0013\u0011\tI-a1\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0002N\u000e\u0002\r!a4\u0002\u0013=4XM\u001d:jI\u0016\u001c\b\u0003CAi\u0003?\f)/!:\u000f\t\u0005M\u00171\u001c\t\u0004\u0003+<VBAAl\u0015\r\tInU\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005uw+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\f\u0019OA\u0002NCBT1!!8X!\u0011\t\t.a:\n\t\u0005%\u00181\u001d\u0002\u0007'R\u0014\u0018N\\4\u0002\u0011Q,\u0017M\u001d#po:D3\u0001JAx!\u0011\t\t,!=\n\t\u0005M\u00181\u0017\u0002\u0006\u0003\u001a$XM]\u0001 i\u0016\u001cH/T1lK2+\u0017\rZ3s+B$\u0017\r^3t\u000bB|7\r[\"bG\",\u0007fA\u0013\u0002zB!\u0011\u0011WA~\u0013\u0011\ti0a-\u0003\tQ+7\u000f^\u00013i\u0016\u001cH/T1lK2+\u0017\rZ3s\t>,7OT8u+B$\u0017\r^3Fa>\u001c\u0007nQ1dQ\u00164uN](mI\u001a{'/\\1ug\"\u001aa%!?\u0002QQ,7\u000f^'bs\n,'+\u001a9mC\u000e,7)\u001e:sK:$x+\u001b;i\rV$XO]3SKBd\u0017nY1)\u0007\u001d\nI0\u0001\u001fuKN$X*Y=cKJ+\u0007\u000f\\1dK\u000e+(O]3oi^KG\u000f\u001b$viV\u0014XMU3qY&\u001c\u0017\rR5gM\u0016\u0014XM\u001c;CCN,wJ\u001a4tKR\u001c\bf\u0001\u0015\u0002z\u0006yC/Z:u\r\u0016$8\r[(gMN,Go\u00158baNDw\u000e^#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_JdU-\u00193fe\"\u001a\u0011&!?\u0002cQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u001cf.\u00199tQ>$X\t]8dQZ\u000bG.\u001b3bi&|gNR8s\r>dGn\\<fe\"\u001a!&!?\u0002WQ,7\u000f^(gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014H*Z1eKJD3aKA}\u00035\"Xm\u001d;PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'OR8mY><XM\u001d\u0015\u0004Y\u0005e\u0018A\n;fgR\u0014V-\u00193SK\u000e|'\u000fZ#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_JdU-\u00193fe\"\u001aQ&!?\u0002QQ,7\u000f\u001e*fC\u0012\u0014VmY8sI\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d$pY2|w/\u001a:)\u00079\nI0A\u001auKN$h)\u001a;dQ>3gm]3u\r>\u0014H+[7fgR\fW\u000e]#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_JdU-\u00193fe\"\u001aq&!?\u0002kQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR4uN\u001d+j[\u0016\u001cH/Y7q\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'OR8mY><XM\u001d\u0015\u0004a\u0005e\u0018\u0001\u000b;fgR4U\r^2i\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r^%oG2,H-Z:MK\u0006$WM]#q_\u000eD\u0007fA\u0019\u0002z\u0006)C/Z:u\u001b>tw\u000e^8oS\u000e|eMZ:fiN\fe\r^3s\u0019\u0016\fG-\u001a:DQ\u0006tw-\u001a\u0015\u0004e\u0005e\u0018aF:fiV\u0004\b+\u0019:uSRLwN\\,ji\"lunY6t)!\tYJa\u000e\u0003<\t\u0015\u0003B\u0002B\u001dg\u0001\u0007\u0011-A\u0006mK\u0006$WM]#q_\u000eD\u0007b\u0002B\u001fg\u0001\u0007!qH\u0001\tSNdU-\u00193feB\u0019aK!\u0011\n\u0007\t\rsKA\u0004C_>dW-\u00198\t\u0013\u0005m2\u0007%AA\u0002\t\u001d\u0003\u0003BA\u001c\u0005\u0013JAAa\u0013\u0002:\t\u0019Aj\\4\u0002CM,G/\u001e9QCJ$\u0018\u000e^5p]^KG\u000f['pG.\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tE#\u0006\u0002B$\u0005'Z#A!\u0016\u0011\t\t]#\u0011M\u0007\u0003\u00053RAAa\u0017\u0003^\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005?:\u0016AC1o]>$\u0018\r^5p]&!!1\rB-\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001/i\u0016\u001cH/\u00119qK:$'+Z2pe\u0012\u001c\u0018i\u001d$pY2|w/\u001a:CK2|w\u000fT8h'R\f'\u000f^(gMN,G\u000fK\u00026\u0003s\fQ\u0004^3ti2K7\u000f^(gMN,G/S:pY\u0006$\u0018n\u001c8MKZ,Gn\u001d\u0015\u0004m\u0005e\u0018A\u0004;fgR<U\r\u001e*fa2L7-\u0019\u0015\u0004o\u0005e\u0018a\u000e;fgR\f\u0005\u000f]3oIJ+7m\u001c:egR{gi\u001c7m_^,'oV5uQ:{'+\u001a9mS\u000e\fG\u000b\u001b:poN,\u0005pY3qi&|g\u000eK\u00029\u0003s\fA\u0005^3ti6\u000b7.\u001a$pY2|w/\u001a:XSRDgj\u001c'fC\u0012,'/\u00133DQ\u0006tw-\u001a\u0015\u0004s\u0005e\u0018a\u0012;fgR4u\u000e\u001c7po\u0016\u0014Hi\\3t\u001d>$(j\\5o\u0013N\u0013VK\u001c;jY\u000e\u000bWo\u001a5u+B$vn\u00144gg\u0016$x+\u001b;iS:\u001cUO\u001d:f]RdU-\u00193fe\u0016\u0003xn\u00195)\u0007i\nI0\u0001\u0012uKN$H)\u001a7bs\u0016$g)\u001a;dQ\u00063G/\u001a:BaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0015\u0004w\u0005e\u0018!D2sK\u0006$XMU3d_J$7\u000f\u0006\u0005\u0003\u0006\nE%Q\u0016B\\!\u0011\u00119I!$\u000e\u0005\t%%b\u0001BFS\u00061!/Z2pe\u0012LAAa$\u0003\n\niQ*Z7pef\u0014VmY8sINDqAa%=\u0001\u0004\u0011)*A\u0004sK\u000e|'\u000fZ:\u0011\r\t]%\u0011\u0015BT\u001d\u0011\u0011IJ!(\u000f\t\u0005U'1T\u0005\u00021&\u0019!qT,\u0002\u000fA\f7m[1hK&!!1\u0015BS\u0005!IE/\u001a:bE2,'b\u0001BP/B!!q\u0011BU\u0013\u0011\u0011YK!#\u0003\u0019MKW\u000e\u001d7f%\u0016\u001cwN\u001d3\t\u000f\t=F\b1\u0001\u00032\u0006Q!-Y:f\u001f\u001a47/\u001a;\u0011\u0007Y\u0013\u0019,C\u0002\u00036^\u0013A\u0001T8oO\"A!\u0011\u0018\u001f\u0011\u0002\u0003\u0007\u0011-\u0001\u000bqCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000bB|7\r[\u0001\u0018GJ,\u0017\r^3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*\"Aa0+\u0007\u0005\u0014\u0019&\u0001\u000ede\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fGNU3d_J$7\u000f\u0006\u0005\u0003\u0006\n\u0015'q\u0019Be\u0011\u001d\u0011\u0019J\u0010a\u0001\u0005+CqAa,?\u0001\u0004\u0011\t\f\u0003\u0005\u0003:z\u0002\n\u00111\u0001b\u0003\u0011\u001a'/Z1uKR\u0013\u0018M\\:bGRLwN\\1m%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\u0004;fgR\fE/T5o\u0013N\u0014\bf\u0001!\u0002z\u0006aB/Z:u+B$\u0017\r^3G_2dwn^3s\r\u0016$8\r[*uCR,\u0007fA!\u0002z\u0006\u0001B/Z:u\u0013N\u0014X\t\u001f9b]NLwN\u001c\u0015\u0004\u0005\u0006e\u0018a\b;fgRL5O\u001d(pi\u0016C\b/\u00198eK\u0012Le-\u00169eCR,g)Y5mg\"\u001a1)!?\u0002%Q,7\u000f^'bs\n,7\u000b\u001b:j].L5O\u001d\u0015\u0004\t\u0006e\u0018a\f;fgR\u001c\u0006n\\;mI:{Go\u00155sS:\\\u0017j\u001d:JMB\u0013XM^5pkN4U\r^2i\u0013N\u001c\u0015-^4iiV\u0003\bfA#\u0002z\u0006\u0001D/Z:u'\"|W\u000f\u001c3O_R\u001c\u0006N]5oW&\u001b(/\u00134G_2dwn^3s\u0007\u0006,x\r\u001b;VaR{Gj\\4F]\u0012D3ARA}\u0003u!Xm\u001d;JgJtu\u000e^*ieVt7.\u00134Va\u0012\fG/\u001a$bS2\u001c\bfA$\u0002z\u0006QC/Z:u+N,7\t[3dWB|\u0017N\u001c;U_&s\u0017\u000e^5bY&TX\rS5hQ^\u000bG/\u001a:nCJ\\\u0007f\u0001%\u0002z\u00069B/Z:u\u0003\u0012$\u0017I\u001c3SK6|g/Z'fiJL7m\u001d\u0015\u0004\u0013\u0006e\u0018!\u0006;fgRdunZ\"p]\u001aLwMT8u\t&\u0014H/\u001f\u0015\u0004\u0015\u0006e\u0018\u0001\t;fgRdunZ\"p]\u001aLw\rR5sif\f5\u000fV8qS\u000e,\u0006\u000fZ1uK\u0012D3aSA}\u0003\u0005\"Xm\u001d;M_\u001e\u001cuN\u001c4jO\u0012K'\u000f^=Bg\n\u0013xn[3s+B$\u0017\r^3eQ\ra\u0015\u0011`\u0001\fg\u0016,G\rT8h\t\u0006$\u0018\r\u0006\u0005\u0002\u0012\r\u00151qAB\u0006\u0011\u001d\tY$\u0014a\u0001\u0005\u000fBaa!\u0003N\u0001\u0004\t\u0017A\u00038v[J+7m\u001c:eg\"1!\u0011H'A\u0002\u0005\u0004")
public class PartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private LogManager logManager;
    private LogConfig logConfig;
    private final PartitionStateStore stateStore = (PartitionStateStore)Mockito.mock(PartitionStateStore.class);
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public PartitionStateStore stateStore() {
        return this.stateStore;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @Before
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9), this.time()));
        this.logManager().startup();
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), this.logManager()));
        Mockito.when((Object)this.stateStore().fetchTopicConfig()).thenReturn((Object)this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    @After
    public void tearDown() {
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir());
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        log.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(5), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())}), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Option option = partition.leaderLogIfLocal();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((Log)map_this.get()).logEndOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)object);
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)leaderEpoch, (long)epochEndOffset.leaderEpoch());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMakeLeaderDoesNotUpdateEpochCacheForOldFormats() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        int leaderEpoch = 8;
        Tuple2[] tuple2Array = new Tuple2[1];
        String string = KAFKA_0_10_2_IV0$.MODULE$.shortVersion();
        Object object = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        LogConfig logConfig = new LogConfig((Map)this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)))), LogConfig$.MODULE$.apply$default$2());
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, logConfig, x$3, x$4);
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v4".getBytes()), (List)Nil$.MODULE$)), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assert.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, log);
        Option option = partition.leaderLogIfLocal();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((Log)map_this.get()).logEndOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)object2);
        Assert.assertEquals((Object)None$.MODULE$, (Object)log.latestEpoch());
        EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assert.assertEquals((long)-1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)-1L, (long)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(this.brokerId(), true, false, this.offsetCheckpoints());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Thread thread1 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                Partition qual$1 = this.$outer.partition();
                boolean x$1 = qual$1.removeFutureLocalReplica$default$1();
                qual$1.removeFutureLocalReplica(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread thread2 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                this.$outer.partition().maybeReplaceCurrentWithFutureReplica();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.partition().futureLog());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplicaDifferentBaseOffsets() {
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(this.brokerId(), true, false, this.offsetCheckpoints());
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Log currentLog = (Log)this.partition().log().get();
        currentLog.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k1".getBytes(), "v2".getBytes()), new SimpleRecord("k1".getBytes(), "v3".getBytes()), new SimpleRecord("k2".getBytes(), "v4".getBytes()), new SimpleRecord("k2".getBytes(), "v5".getBytes()), new SimpleRecord("k2".getBytes(), "v6".getBytes())}), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4());
        currentLog.roll(currentLog.roll$default$1());
        currentLog.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v7".getBytes()), new SimpleRecord("k4".getBytes(), "v8".getBytes())}), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (long)-1L, (int)0);
        builder.appendWithOffset(2L, new SimpleRecord("k1".getBytes(), "v3".getBytes()));
        builder.appendWithOffset(5L, new SimpleRecord("k2".getBytes(), "v6".getBytes()));
        builder.appendWithOffset(6L, new SimpleRecord("k3".getBytes(), "v7".getBytes()));
        builder.appendWithOffset(7L, new SimpleRecord("k4".getBytes(), "v8".getBytes()));
        this.partition().futureLocalLogOrException().appendAsFollower(builder.build());
        Assert.assertTrue((boolean)this.partition().maybeReplaceCurrentWithFutureReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false, this.setupPartitionWithMocks$default$3());
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.empty(), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_FOR_PARTITION, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchLatestOffsetIncludesLeaderEpoch() {
        int leaderEpoch = 5;
        Option timestampAndOffsetOpt = this.setupPartitionWithMocks(leaderEpoch, true, this.setupPartitionWithMocks$default$3()).fetchOffsetForTimestamp(-1L, (Option)None$.MODULE$, Optional.empty(), true);
        Assert.assertTrue((boolean)timestampAndOffsetOpt.isDefined());
        FileRecords.TimestampAndOffset timestampAndOffset = (FileRecords.TimestampAndOffset)timestampAndOffsetOpt.get();
        Assert.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)timestampAndOffset.leaderEpoch);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Test
    public void testMonotonicOffsetsAfterLeaderChange() {
        block67: {
            block69: {
                block68: {
                    block66: {
                        block63: {
                            block65: {
                                block64: {
                                    block62: {
                                        controllerEpoch = 3;
                                        leader = this.brokerId();
                                        follower1 = this.brokerId() + 1;
                                        follower2 = this.brokerId() + 2;
                                        controllerId = this.brokerId() + 3;
                                        replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader, follower1, follower2}));
                                        isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$))).asJava();
                                        leaderEpoch = 8;
                                        batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(20L, "k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(21L, "k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        v0 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
                                        var75_11 = List$.MODULE$.canBuildFrom();
                                        var74_12 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)();
                                        if (replicas == null) {
                                            throw null;
                                        }
                                        if (map_bf == List$.MODULE$.ReusableCBF()) {
                                            if (replicas == Nil$.MODULE$) {
                                                var80_13 /* !! */  = Nil$.MODULE$;
                                            } else {
                                                map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$1(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                                                for (map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                                    map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$1(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                                                    map_t.tl_$eq((List)map_nx);
                                                    map_t = map_nx;
                                                }
                                                var80_13 /* !! */  = map_h;
                                            }
                                        } else {
                                            var80_13 /* !! */  = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
                                        }
                                        leaderState = v0.setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)var80_13 /* !! */ ).asJava()).setIsNew(true);
                                        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)this.partition().makeLeader(controllerId, leaderState, 0, this.offsetCheckpoints()));
                                        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)this.partition().getLeaderEpoch());
                                        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().inSyncReplicaIds());
                                        qual$1 = this.partition();
                                        x$2 = true;
                                        x$3 = qual$1.appendRecordsToLeader$default$3();
                                        qual$1.appendRecordsToLeader(batch1, x$2, x$3);
                                        qual$2 = this.partition();
                                        x$5 = true;
                                        x$6 = qual$2.appendRecordsToLeader$default$3();
                                        qual$2.appendRecordsToLeader(batch2, x$5, x$6);
                                        Assert.assertEquals((String)"Expected leader's HW not move", (long)this.partition().localLogOrException().logStartOffset(), (long)this.partition().localLogOrException().highWatermark());
                                        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, new LeaderAndIsr(leader, leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader, follower2, follower1})), 1))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        Assert.assertEquals((long)2L, (long)this.partition().localLogOrException().highWatermark());
                                        var18_25 = false;
                                        var19_26 = null;
                                        var20_27 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                                        if (!(var20_27 instanceof Right)) ** GOTO lbl-1000
                                        var18_25 = true;
                                        var19_26 = (Right)var20_27;
                                        var21_28 = (Option)var19_26.value();
                                        if (var21_28 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var21_28).value();
                                            Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                                        } else if (var18_25 && None$.MODULE$.equals(var23_30 = (Option)var19_26.value())) {
                                            Assert.fail((String)"Should have seen some offsets");
                                        } else if (var20_27 instanceof Left) {
                                            Assert.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var20_27);
                                        }
                                        var24_31 = false;
                                        var25_32 = null;
                                        var26_33 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var26_33 instanceof Right)) ** GOTO lbl-1000
                                        var24_31 = true;
                                        var25_32 = (Right)var26_33;
                                        var27_34 = (Option)var25_32.value();
                                        if (var27_34 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var27_34).value();
                                            Assert.assertEquals((long)2L, (long)offsetAndTimestamp.offset);
                                        } else if (var24_31 && None$.MODULE$.equals(var29_36 = (Option)var25_32.value())) {
                                            Assert.fail((String)"Should have seen some offsets");
                                        } else if (var26_33 instanceof Left) {
                                            Assert.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var26_33);
                                        }
                                        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(30L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
                                        v1 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(4);
                                        var82_37 = List$.MODULE$.canBuildFrom();
                                        map_f = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)();
                                        if (map_bf == List$.MODULE$.ReusableCBF()) {
                                            if (replicas == Nil$.MODULE$) {
                                                var87_39 /* !! */  = Nil$.MODULE$;
                                            } else {
                                                map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$2(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                                                for (map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                                    map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$2(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                                                    map_t.tl_$eq((List)map_nx);
                                                    map_t = map_nx;
                                                }
                                                var87_39 /* !! */  = map_h;
                                            }
                                        } else {
                                            var87_39 /* !! */  = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
                                        }
                                        followerState = v1.setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)var87_39 /* !! */ ).asJava()).setIsNew(false);
                                        Assert.assertTrue((boolean)this.partition().makeFollower(controllerId, followerState, 1, this.offsetCheckpoints()));
                                        v2 = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(5);
                                        var89_45 = List$.MODULE$.canBuildFrom();
                                        map_f = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)();
                                        if (map_bf == List$.MODULE$.ReusableCBF()) {
                                            if (replicas == Nil$.MODULE$) {
                                                var94_47 /* !! */  = Nil$.MODULE$;
                                            } else {
                                                map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$3(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                                                for (map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                                                    map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$3(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                                                    map_t.tl_$eq((List)map_nx);
                                                    map_t = map_nx;
                                                }
                                                var94_47 /* !! */  = map_h;
                                            }
                                        } else {
                                            var94_47 /* !! */  = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
                                        }
                                        newLeaderState = v2.setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)var94_47 /* !! */ ).asJava()).setIsNew(false);
                                        Assert.assertTrue((boolean)this.partition().makeLeader(controllerId, newLeaderState, 2, this.offsetCheckpoints()));
                                        var32_53 = false;
                                        var33_54 = null;
                                        var34_55 = false;
                                        var35_56 = null;
                                        var36_57 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var36_57 instanceof Right)) break block62;
                                        var32_53 = true;
                                        var33_54 = (Right)var36_57;
                                        if (!((Option)var33_54.value() instanceof Some)) break block62;
                                        Assert.fail((String)"Should have failed with OffsetNotAvailable");
                                        break block63;
                                    }
                                    if (!var32_53 || !None$.MODULE$.equals(var37_58 = (Option)var33_54.value())) break block64;
                                    Assert.fail((String)"Should have seen an error");
                                    break block63;
                                }
                                if (!(var36_57 instanceof Left)) break block65;
                                var34_55 = true;
                                var35_56 = (Left)var36_57;
                                if ((ApiException)var35_56.value() instanceof OffsetNotAvailableException) break block63;
                            }
                            if (var34_55 && (e = (ApiException)var35_56.value()) != null) {
                                Assert.fail((String)new StringBuilder(42).append("Expected OffsetNotAvailableException, got ").append(e).toString());
                            } else {
                                throw new MatchError((Object)var36_57);
                            }
                        }
                        var39_60 = false;
                        var40_61 = null;
                        var41_62 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                        if (!(var41_62 instanceof Right)) ** GOTO lbl-1000
                        var39_60 = true;
                        var40_61 = (Right)var41_62;
                        var42_63 = (Option)var40_61.value();
                        if (var42_63 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var42_63).value();
                            Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                        } else if (var39_60 && None$.MODULE$.equals(var44_65 = (Option)var40_61.value())) {
                            Assert.fail((String)"Should have seen some offsets");
                        } else if (var41_62 instanceof Left && (e = (ApiException)((Left)var41_62).value()) != null) {
                            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var41_62);
                        }
                        var46_67 = false;
                        var47_68 = null;
                        var48_69 = this.fetchOffsetsForTimestamp$1(-2L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var48_69 instanceof Right)) ** GOTO lbl-1000
                        var46_67 = true;
                        var47_68 = (Right)var48_69;
                        var49_70 = (Option)var47_68.value();
                        if (var49_70 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var49_70).value();
                            Assert.assertEquals((long)0L, (long)offsetAndTimestamp.offset);
                        } else if (var46_67 && None$.MODULE$.equals(var51_72 = (Option)var47_68.value())) {
                            Assert.fail((String)"Should have seen some offsets");
                        } else if (var48_69 instanceof Left && (e = (ApiException)((Left)var48_69).value()) != null) {
                            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var48_69);
                        }
                        var53_74 = false;
                        var54_75 = null;
                        var55_76 = this.fetchOffsetsForTimestamp$1(11L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var55_76 instanceof Right)) ** GOTO lbl-1000
                        var53_74 = true;
                        var54_75 = (Right)var55_76;
                        var56_77 = (Option)var54_75.value();
                        if (var56_77 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var56_77).value();
                            Assert.assertEquals((long)1L, (long)offsetAndTimestamp.offset);
                            Assert.assertEquals((long)11L, (long)offsetAndTimestamp.timestamp);
                        } else if (var53_74 && None$.MODULE$.equals(var58_79 = (Option)var54_75.value())) {
                            Assert.fail((String)"Should have seen some offsets");
                        } else if (var55_76 instanceof Left && (e = (ApiException)((Left)var55_76).value()) != null) {
                            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var55_76);
                        }
                        var60_81 = false;
                        var61_82 = null;
                        var62_83 = false;
                        var63_84 = null;
                        var64_85 = this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var64_85 instanceof Right)) break block66;
                        var60_81 = true;
                        var61_82 = (Right)var64_85;
                        if (!((Option)var61_82.value() instanceof Some)) break block66;
                        Assert.fail((String)"Should have failed");
                        break block67;
                    }
                    if (!var60_81 || !None$.MODULE$.equals(var65_86 = (Option)var61_82.value())) break block68;
                    Assert.fail((String)"Should have failed");
                    break block67;
                }
                if (!(var64_85 instanceof Left)) break block69;
                var62_83 = true;
                var63_84 = (Left)var64_85;
                if ((ApiException)var63_84.value() instanceof OffsetNotAvailableException) break block67;
            }
            if (var62_83 && (e = (ApiException)var63_84.value()) != null) {
                Assert.fail((String)new StringBuilder(50).append("Should have seen OffsetNotAvailableException, saw ").append(e).toString());
            } else {
                throw new MatchError((Object)var64_85);
            }
        }
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, new LeaderAndIsr(leader, leaderEpoch + 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader, follower2, follower1})), 5))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        var67_88 = false;
        var68_89 = null;
        var69_90 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
        if (!(var69_90 instanceof Right)) ** GOTO lbl-1000
        var67_88 = true;
        var68_89 = (Right)var69_90;
        var70_91 = (Option)var68_89.value();
        if (var70_91 instanceof Some) {
            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var70_91).value();
            Assert.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
        } else if (var67_88 && None$.MODULE$.equals(var72_93 = (Option)var68_89.value())) {
            Assert.fail((String)"Should have seen some offsets");
        } else if (var69_90 instanceof Left && (e = (ApiException)((Left)var69_90).value()) != null) {
            Assert.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
        } else {
            throw new MatchError((Object)var69_90);
        }
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
    }

    private Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader, Log log) {
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        int controllerId = 0;
        int controllerEpoch = 0;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), 0, this.offsetCheckpoints()));
            Assert.assertEquals((long)leaderEpoch, (long)this.partition().getLeaderEpoch());
        } else {
            Assert.assertTrue((String)"Expected become follower transition to succeed", (boolean)this.partition().makeFollower(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId() + 1).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), 0, this.offsetCheckpoints()));
            Assert.assertEquals((long)leaderEpoch, (long)this.partition().getLeaderEpoch());
            Assert.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }

    private Log setupPartitionWithMocks$default$3() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        return qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Log log = this.partition().localLogOrException();
        long initialLogStartOffset = 5L;
        this.partition().truncateFullyAndStartAt(initialLogStartOffset, false);
        Assert.assertEquals((String)new StringBuilder(50).append("Log end offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString(), (long)initialLogStartOffset, (long)log.logEndOffset());
        Assert.assertEquals((String)new StringBuilder(52).append("Log start offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString(), (long)initialLogStartOffset, (long)log.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 3L, this.createRecords$default$3()), false), ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
        Assert.assertEquals((String)"Log end offset should not change after failure to append", (long)initialLogStartOffset, (long)log.logEndOffset());
        long newLogStartOffset = 4L;
        MemoryRecords records = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), newLogStartOffset, this.createRecords$default$3());
        this.partition().appendRecordsToFollowerOrFutureReplica(records, false);
        Assert.assertEquals((String)new StringBuilder(59).append("Log end offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString(), (long)7L, (long)log.logEndOffset());
        Assert.assertEquals((String)new StringBuilder(61).append("Log start offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString(), (long)newLogStartOffset, (long)log.logStartOffset());
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 7L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)"Log end offset after append of 1 record at offset 7:", (long)8L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Log start offset not expected to change:", (long)newLogStartOffset, (long)log.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> {
            MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), 3L, this.createRecords$default$3());
            return this.partition().appendRecordsToFollowerOrFutureReplica(records2, false);
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
        Assert.assertEquals((String)"Log end offset should not change after failure to append", (long)8L, (long)log.logEndOffset());
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 8L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)"Log end offset after append of 1 record at offset 8:", (long)9L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Log start offset not expected to change:", (long)newLogStartOffset, (long)log.logStartOffset());
    }

    @Test
    public void testListOffsetIsolationLevels() {
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((long)leaderEpoch, (long)this.partition().getLeaderEpoch());
        MemoryRecords records = this.createTransactionalRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), 0L, this.createTransactionalRecords$default$3());
        Partition qual$1 = this.partition();
        boolean x$2 = true;
        int x$3 = qual$1.appendRecordsToLeader$default$3();
        qual$1.appendRecordsToLeader(records, x$2, x$3);
        Assert.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        ((Log)this.partition().log().get()).updateHighWatermark(1L);
        Assert.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assert.assertEquals((long)1L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assert.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)None$.MODULE$).offset);
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assert.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
    }

    @Test
    public void testGetReplica() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.partition().log());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.partition().localLogOrException(), ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 797));
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 0L, this.createRecords$default$3()), false), ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 804));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setIsNew(false);
        this.partition().makeFollower(0, partitionState, 0, this.offsetCheckpoints());
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setIsNew(false);
        Assert.assertTrue((boolean)this.partition().makeFollower(0, partitionState, 2, this.offsetCheckpoints()));
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava());
        Assert.assertFalse((boolean)this.partition().makeFollower(0, partitionState, 2, this.offsetCheckpoints()));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int controllerId = this.brokerId() + 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        Assert.assertTrue((String)"Expected first makeLeader() to return 'leader changed'", (boolean)this.partition().makeLeader(controllerId, leaderState, 0, this.offsetCheckpoints()));
        Assert.assertEquals((String)"Current leader epoch", (long)leaderEpoch, (long)this.partition().getLeaderEpoch());
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().inSyncReplicaIds());
        Partition qual$1 = this.partition();
        boolean x$2 = true;
        int x$3 = qual$1.appendRecordsToLeader$default$3();
        long lastOffsetOfFirstBatch = qual$1.appendRecordsToLeader(batch1, x$2, x$3).lastOffset();
        Partition qual$2 = this.partition();
        boolean x$5 = true;
        int x$6 = qual$2.appendRecordsToLeader$default$3();
        qual$2.appendRecordsToLeader(batch2, x$5, x$6);
        Assert.assertEquals((String)"Expected leader's HW not move", (long)this.partition().localLogOrException().logStartOffset(), (long)((Log)this.partition().log().get()).highWatermark());
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Expected leader's HW", (long)lastOffsetOfFirstBatch, (long)((Log)this.partition().log().get()).highWatermark());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeFollower(controllerId, followerState, 1, this.offsetCheckpoints());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        Assert.assertTrue((String)"Expected makeLeader() to return 'leader changed' after makeFollower()", (boolean)this.partition().makeLeader(controllerEpoch, newLeaderState, 2, this.offsetCheckpoints()));
        long currentLeaderEpochStartOffset = this.partition().localLogOrException().logEndOffset();
        Partition qual$3 = this.partition();
        boolean x$8 = true;
        int x$9 = qual$3.appendRecordsToLeader$default$3();
        qual$3.appendRecordsToLeader(batch3, x$8, x$9);
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().inSyncReplicaIds());
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, new LeaderAndIsr(leader, leaderEpoch + 2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader, follower2, follower1})), 1))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(currentLeaderEpochStartOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"ISR", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().inSyncReplicaIds());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDelayedFetchAfterAppendRecords() {
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List replicaIds = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq topicPartitions = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, 5).map((Function1 & Serializable & scala.Serializable)i -> PartitionTest.$anonfun$testDelayedFetchAfterAppendRecords$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq logs = (IndexedSeq)topicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> {
            LogManager qual$1 = this.logManager();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            return qual$1.getOrCreateLog(tp, logConfig, x$3, x$4);
        }, IndexedSeq$.MODULE$.canBuildFrom());
        ListBuffer partitions = (ListBuffer)ListBuffer$.MODULE$.empty();
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            TopicPartition tp = log.topicPartition();
            DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
            Partition partition = new Partition(tp, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), delayedOperations, this.metadataCache(), this.logManager());
            delayedOperations.checkAndCompleteFetch();
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer((Answer)new Answer<BoxedUnit>(null, tp, topicPartitions, partitions, leaderEpoch){
                private final TopicPartition tp$1;
                private final IndexedSeq topicPartitions$1;
                private final ListBuffer partitions$1;
                private final int leaderEpoch$1;

                public void answer(InvocationOnMock invocation) {
                    int anotherPartition = (this.tp$1.partition() + 1) % this.topicPartitions$1.size();
                    ((Partition)this.partitions$1.apply(anotherPartition)).fetchOffsetSnapshot(Optional.of(Predef$.MODULE$.int2Integer(this.leaderEpoch$1)), true);
                }
                {
                    this.tp$1 = tp$1;
                    this.topicPartitions$1 = topicPartitions$1;
                    this.partitions$1 = partitions$1;
                    this.leaderEpoch$1 = leaderEpoch$1;
                }
            });
            partition.setLog(log, false);
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicaIds).setZkVersion(1).setReplicas(replicaIds).setIsNew(true);
            partition.makeLeader(controllerId, leaderState, 0, this.offsetCheckpoints());
            return partitions.$plus$eq((Object)partition);
        });
        AtomicBoolean done = new AtomicBoolean();
        ExecutorService executor = Executors.newFixedThreadPool(topicPartitions.size() + 1);
        try {
            try {
                void foreach_f;
                void map_bf;
                void map_f;
                void runnable_fun;
                JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    while (!done.get()) {
                        void foreach_f;
                        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$3 -> {
                            x$3.maybeShrinkIsr(10000L);
                            return BoxedUnit.UNIT;
                        };
                        if (partitions == null) {
                            throw null;
                        }
                        partitions.underlying().foreach((Function1)foreach_f);
                    }
                };
                if (CoreUtils$.MODULE$ == null) {
                    throw null;
                }
                executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                CanBuildFrom canBuildFrom = ListBuffer$.MODULE$.canBuildFrom();
                Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)partition -> {
                    void runnable_fun;
                    JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        int n = 1;
                        if (Predef$.MODULE$ == null) {
                            throw null;
                        }
                        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 10000);
                        if (inclusive == null) {
                            throw null;
                        }
                        Range.Inclusive foreach_this = inclusive;
                        if (!foreach_this.isEmpty()) {
                            int foreach_i = foreach_this.start();
                            while (true) {
                                partition.appendRecordsToLeader(this.createRecords$1(0L), true, partition.appendRecordsToLeader$default$3());
                                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                                foreach_i += foreach_this.step();
                            }
                        }
                    };
                    if (CoreUtils$.MODULE$ == null) {
                        throw null;
                    }
                    return executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                };
                if (partitions == null) {
                    throw null;
                }
                ListBuffer futures = (ListBuffer)TraversableLike.map$((TraversableLike)partitions, (Function1)map_f, (CanBuildFrom)map_bf);
                Function1 & Serializable & scala.Serializable intersect3 = (Function1 & Serializable & scala.Serializable)x$5 -> x$5.get(15L, TimeUnit.SECONDS);
                if (futures == null) {
                    throw null;
                }
                futures.underlying().foreach((Function1)foreach_f);
                done.set(true);
            }
            catch (TimeoutException e) {
                String allThreads = TestUtils$.MODULE$.allThreadStackTraces();
                Assert.fail((String)new StringBuilder(53).append("Test timed out with exception ").append(e).append(", thread stack traces: ").append(allThreads).toString());
            }
        }
        finally {
            executor.shutdownNow();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    public MemoryRecords createRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records).asJava()))), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)partitionLeaderEpoch);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records).asJava()))), (CompressionType)CompressionType.NONE, (long)baseOffset, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.append(x$1));
        return builder.build();
    }

    public int createTransactionalRecords$default$3() {
        return 0;
    }

    @Test
    public void testAtMinIsr() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int controllerId = this.brokerId() + 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)Nil$.MODULE$)).asJava();
        int leaderEpoch = 8;
        Assert.assertFalse((boolean)this.partition().isAtMinIsr());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        this.partition().makeLeader(controllerId, leaderState, 0, this.offsetCheckpoints());
        Assert.assertTrue((boolean)this.partition().isAtMinIsr());
    }

    @Test
    public void testUpdateFollowerFetchState() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        this.seedLogData(log, 6, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        long initializeTimeMs = this.time().milliseconds();
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), 0, this.offsetCheckpoints()));
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(6L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)this.time().milliseconds(), (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)6L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsrExpansion() {
        Object object;
        void map_bf;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$)).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Partition partition = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
        CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x -> PartitionTest.$anonfun$testIsrExpansion$1(BoxesRunTime.unboxToInt((Object)x));
        if (replicas == null) {
            throw null;
        }
        if (map_bf == List$.MODULE$.ReusableCBF()) {
            if (replicas == Nil$.MODULE$) {
                object = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testIsrExpansion$1(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                for (List map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testIsrExpansion$1(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object = map_h;
            }
        } else {
            void map_f;
            object = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
        }
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, leaderAndIsrPartitionState.setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava()).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        LeaderAndIsr updatedLeaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), 1);
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, updatedLeaderAndIsr)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    @Test
    public void testIsrNotExpandedIfUpdateFails() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$)).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        LeaderAndIsr updatedLeaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), 1);
        Mockito.when((Object)this.stateStore().expandIsr(controllerEpoch, updatedLeaderAndIsr)).thenReturn((Object)None$.MODULE$);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 10L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaybeShrinkIsr() {
        Object object;
        void map_bf;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Partition partition = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
        CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x -> PartitionTest.$anonfun$testMaybeShrinkIsr$1(BoxesRunTime.unboxToInt((Object)x));
        if (replicas == null) {
            throw null;
        }
        if (map_bf == List$.MODULE$.ReusableCBF()) {
            if (replicas == Nil$.MODULE$) {
                object = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testMaybeShrinkIsr$1(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                for (List map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testMaybeShrinkIsr$1(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object = map_h;
            }
        } else {
            void map_f;
            object = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
        }
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, leaderAndIsrPartitionState.setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava()).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr(10000L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        this.time().sleep(10001L);
        LeaderAndIsr updatedLeaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), 1);
        Mockito.when((Object)this.stateStore().shrinkIsr(controllerEpoch, updatedLeaderAndIsr)).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        this.partition().maybeShrinkIsr(10000L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp() {
        Object object;
        void map_bf;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Partition partition = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
        CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x -> PartitionTest.$anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$1(BoxesRunTime.unboxToInt((Object)x));
        if (replicas == null) {
            throw null;
        }
        if (map_bf == List$.MODULE$.ReusableCBF()) {
            if (replicas == Nil$.MODULE$) {
                object = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$1(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                for (List map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$1(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object = map_h;
            }
        } else {
            void map_f;
            object = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
        }
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, leaderAndIsrPartitionState.setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava()).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(5000L);
        long firstFetchTimeMs = this.time().milliseconds();
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, firstFetchTimeMs, 10L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)5L, (long)this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)5L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(5001L);
        this.seedLogData(log, 5, leaderEpoch);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 15L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)firstFetchTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr(10000L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd() {
        Object object;
        void map_bf;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Partition partition = this.partition();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1);
        CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x -> PartitionTest.$anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$1(BoxesRunTime.unboxToInt((Object)x));
        if (replicas == null) {
            throw null;
        }
        if (map_bf == List$.MODULE$.ReusableCBF()) {
            if (replicas == Nil$.MODULE$) {
                object = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                .colon.colon map_t = map_h = new .colon.colon((Object)PartitionTest.$anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$1(BoxesRunTime.unboxToInt((Object)replicas.head())), (List)Nil$.MODULE$);
                for (List map_rest = (List)replicas.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    .colon.colon map_nx = new .colon.colon((Object)PartitionTest.$anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$1(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object = map_h;
            }
        } else {
            void map_f;
            object = TraversableLike.map$((TraversableLike)replicas, (Function1)map_f, (CanBuildFrom)map_bf);
        }
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, leaderAndIsrPartitionState.setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava()).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 10L, this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assert.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(10001L);
        this.partition().maybeShrinkIsr(10000L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
    }

    @Test
    public void testIsrNotShrunkIfUpdateFails() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        this.seedLogData(log, 10, 4);
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        java.util.List isr = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteFetch();
        long initializeTimeMs = this.time().milliseconds();
        this.partition().createLogIfNotExists(this.brokerId(), false, false, this.offsetCheckpoints());
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)this.partition().makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), 0, this.offsetCheckpoints()));
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assert.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assert.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assert.assertEquals((long)Log$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(10001L);
        LeaderAndIsr updatedLeaderAndIsr = new LeaderAndIsr(this.brokerId(), leaderEpoch, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), 1);
        Mockito.when((Object)this.stateStore().shrinkIsr(controllerEpoch, updatedLeaderAndIsr)).thenReturn((Object)None$.MODULE$);
        this.partition().maybeShrinkIsr(10000L);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assert.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testUseCheckpointToInitializeHighWatermark() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        LogConfig x$2 = this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, x$2, x$3, x$4);
        this.seedLogData(log, 6, 5);
        Mockito.when((Object)this.offsetCheckpoints().fetch(this.logDir1().getAbsolutePath(), this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)4L)));
        int controllerId = 0;
        int controllerEpoch = 3;
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(controllerId, leaderState, 0, this.offsetCheckpoints());
        Assert.assertEquals((long)4L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testAddAndRemoveMetrics() {
        boolean bl;
        block2: {
            .colon.colon forall_these = new .colon.colon((Object)"UnderReplicated", (List)new .colon.colon((Object)"UnderMinIsr", (List)new .colon.colon((Object)"InSyncReplicasCount", (List)new .colon.colon((Object)"ReplicasCount", (List)new .colon.colon((Object)"LastStableOffsetLag", (List)new .colon.colon((Object)"AtMinIsr", (List)Nil$.MODULE$))))));
            while (!forall_these.isEmpty()) {
                if (!PartitionTest.$anonfun$testAddAndRemoveMetrics$3((String)forall_these.head())) {
                    bl = false;
                    break block2;
                }
                forall_these = (LinearSeqOptimized)forall_these.tail();
            }
            bl = true;
        }
        Assert.assertTrue((boolean)bl);
        Partition$.MODULE$.removeMetrics(this.topicPartition());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).keySet().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$4(x$8))));
    }

    @Test
    public void testLogConfigNotDirty() {
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), spyLogManager).createLog(this.brokerId(), true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any());
        ((PartitionStateStore)Mockito.verify((Object)this.stateStore())).fetchTopicConfig();
    }

    @Test
    public void testLogConfigDirtyAsTopicUpdated() {
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer((Answer)new Answer<BoxedUnit>(this){
            private final /* synthetic */ PartitionTest $outer;

            public void answer(InvocationOnMock invocation) {
                this.$outer.logManager().initializingLog(this.$outer.topicPartition());
                this.$outer.logManager().topicConfigUpdated(this.$outer.topicPartition().topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), spyLogManager).createLog(this.brokerId(), true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any());
        ((PartitionStateStore)Mockito.verify((Object)this.stateStore(), (VerificationMode)Mockito.times((int)2))).fetchTopicConfig();
    }

    @Test
    public void testLogConfigDirtyAsBrokerUpdated() {
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer((Answer)new Answer<BoxedUnit>(this){
            private final /* synthetic */ PartitionTest $outer;

            public void answer(InvocationOnMock invocation) {
                this.$outer.logManager().initializingLog(this.$outer.topicPartition());
                this.$outer.logManager().brokerConfigUpdated();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), this.stateStore(), this.delayedOperations(), this.metadataCache(), spyLogManager).createLog(this.brokerId(), true, false, this.offsetCheckpoints());
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any(), (Function0)ArgumentMatchers.any());
        ((PartitionStateStore)Mockito.verify((Object)this.stateStore(), (VerificationMode)Mockito.times((int)2))).fetchTopicConfig();
    }

    private void seedLogData(Log log, int numRecords, int leaderEpoch) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numRecords);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                PartitionTest.$anonfun$seedLogData$1(leaderEpoch, log, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
    }

    private static final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$1) {
        try {
            partition$1.fetchOffsetSnapshot(currentLeaderEpoch, true);
            Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assert.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$2) {
        try {
            partition$2.fetchOffsetSnapshot(currentLeaderEpoch, fetchOnlyLeader);
            Assert.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assert.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$3) {
        EpochEndOffset endOffset = partition$3.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private static final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$4) {
        EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assert.assertEquals((Object)error, (Object)endOffset.error());
    }

    private static final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$5) {
        try {
            partition$5.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$6) {
        try {
            partition$6.readRecords(0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyLeader, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$7) {
        try {
            partition$7.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assert.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final void updateFollowerFetchState$1(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset(), this.partition().localLogOrException().highWatermark());
    }

    private final Either fetchOffsetsForTimestamp$1(long timestamp, Option isolation) {
        try {
            return package$.MODULE$.Right().apply((Object)this.partition().fetchOffsetForTimestamp(timestamp, isolation, Optional.of(Predef$.MODULE$.int2Integer(this.partition().getLeaderEpoch())), true));
        }
        catch (ApiException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final FileRecords.TimestampAndOffset fetchLatestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final FileRecords.TimestampAndOffset fetchEarliestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
        Assert.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final void updateFollowerFetchState$2(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset(), this.partition().localLogOrException().highWatermark());
    }

    public static final /* synthetic */ TopicPartition $anonfun$testDelayedFetchAfterAppendRecords$1(int i) {
        return new TopicPartition("test-topic", i);
    }

    private final MemoryRecords createRecords$1(long baseOffset) {
        .colon.colon records = new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)records).asJava()))), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)0);
        .colon.colon foreach_these = records;
        while (!foreach_these.isEmpty()) {
            SimpleRecord simpleRecord = (SimpleRecord)foreach_these.head();
            builder.append(simpleRecord);
            foreach_these = (List)foreach_these.tail();
        }
        return builder.build();
    }

    public static final /* synthetic */ Integer $anonfun$testIsrExpansion$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testMaybeShrinkIsr$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$1(String metric$1, MetricName metricName) {
        String string = metricName.getName();
        if (!(string != null ? !string.equals(metric$1) : metric$1 != null)) {
            String string2 = metricName.getType();
            String string3 = "Partition";
            if (string2 != null && string2.equals(string3)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ Metric $anonfun$testAddAndRemoveMetrics$2(Tuple2 x$6) {
        return (Metric)x$6._2();
    }

    private static final Option getMetric$1(String metric) {
        Option option = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$1(metric, metricName))).headOption();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)PartitionTest.$anonfun$testAddAndRemoveMetrics$2((Tuple2)map_this.get()));
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$3(String x$7) {
        return PartitionTest.getMetric$1(x$7).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$4(MetricName x$8) {
        String string = x$8.getType();
        String string2 = "Partition";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$seedLogData$1(int leaderEpoch$2, Log log$1, int i) {
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(leaderEpoch$2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(1).append("k").append(i).toString().getBytes(), new StringBuilder(1).append("v").append(i).toString().getBytes())});
        return log$1.appendAsLeader(records, leaderEpoch$2, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
    }

    public PartitionTest() {
        this.brokerId = 101;
    }

    public static final /* synthetic */ Object $anonfun$testMakeLeaderUpdatesEpochCache$1$adapted(Log x$1) {
        return BoxesRunTime.boxToLong((long)x$1.logEndOffset());
    }

    public static final /* synthetic */ Object $anonfun$testMakeLeaderDoesNotUpdateEpochCacheForOldFormats$1$adapted(Log x$2) {
        return BoxesRunTime.boxToLong((long)x$2.logEndOffset());
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$1(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$2(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$3(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Object $anonfun$testAddAndRemoveMetrics$3$adapted(String x$7) {
        return BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$3(x$7));
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$seedLogData$1$adapted(int leaderEpoch$2, Log log$1, Object i) {
        return PartitionTest.$anonfun$seedLogData$1(leaderEpoch$2, log$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testDelayedFetchAfterAppendRecords$9$adapted(PartitionTest $this, Partition partition$9, Object x$4) {
        return partition$9.appendRecordsToLeader($this.createRecords$1(0L), true, partition$9.appendRecordsToLeader$default$3());
    }
}

