/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import kafka.common.NotificationHandler;
import kafka.common.ZkNodeChangeNotificationListener;
import kafka.common.ZkNodeChangeNotificationListener$;
import kafka.security.auth.Group$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.utils.TestUtils$;
import kafka.zk.LiteralAclChangeStore$;
import kafka.zk.LiteralAclStore$;
import kafka.zk.ZkAclChangeStore$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.resource.PatternType;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001\u0002\r\u001a\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013%!\u0006\u0003\u00042\u0001\u0001\u0006Ia\u000b\u0005\ne\u0001\u0001\r\u00111A\u0005\nMB\u0011b\u000e\u0001A\u0002\u0003\u0007I\u0011\u0002\u001d\t\u0013y\u0002\u0001\u0019!A!B\u0013!\u0004\"C \u0001\u0001\u0004\u0005\r\u0011\"\u0003A\u0011-\t\t\u0001\u0001a\u0001\u0002\u0004%I!a\u0001\t\u0015\u0005\u001d\u0001\u00011A\u0001B\u0003&\u0011\tC\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\f!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0001bBA\u001a\u0001\u0011\u0005\u00111\u0002\u0004\u0005\u0007\u0002!A\tC\u0003&\u001d\u0011\u00051\nC\u0004M\u001d\t\u0007I\u0011B'\t\rys\u0001\u0015!\u0003O\u0011\u001dyf\u00021A\u0005\n\u0001Dq\u0001\u001a\bA\u0002\u0013%Q\r\u0003\u0004h\u001d\u0001\u0006K!\u0019\u0005\u0006Y:!\t%\u001c\u0005\u0006m:!\ta\u001e\u0005\u0006y:!\t! \u0002%5.tu\u000eZ3DQ\u0006tw-\u001a(pi&4\u0017nY1uS>tG*[:uK:,'\u000fV3ti*\u0011!dG\u0001\u0007G>lWn\u001c8\u000b\u0003q\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001?A\u0011\u0001eI\u0007\u0002C)\u0011!eG\u0001\u0003u.L!\u0001J\u0011\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002)\u00015\t\u0011$\u0001\ndQ\u0006tw-Z#ya&\u0014\u0018\r^5p]6\u001bX#A\u0016\u0011\u00051zS\"A\u0017\u000b\u00039\nQa]2bY\u0006L!\u0001M\u0017\u0003\u0007%sG/A\ndQ\u0006tw-Z#ya&\u0014\u0018\r^5p]6\u001b\b%\u0001\u000bo_RLg-[2bi&|g\u000eT5ti\u0016tWM]\u000b\u0002iA\u0011\u0001&N\u0005\u0003me\u0011\u0001EW6O_\u0012,7\t[1oO\u0016tu\u000e^5gS\u000e\fG/[8o\u0019&\u001cH/\u001a8fe\u0006Abn\u001c;jM&\u001c\u0017\r^5p]2K7\u000f^3oKJ|F%Z9\u0015\u0005eb\u0004C\u0001\u0017;\u0013\tYTF\u0001\u0003V]&$\bbB\u001f\u0006\u0003\u0003\u0005\r\u0001N\u0001\u0004q\u0012\n\u0014!\u00068pi&4\u0017nY1uS>tG*[:uK:,'\u000fI\u0001\u0014]>$\u0018NZ5dCRLwN\u001c%b]\u0012dWM]\u000b\u0002\u0003B\u0011!ID\u0007\u0002\u0001\t9B+Z:u\u001d>$\u0018NZ5dCRLwN\u001c%b]\u0012dWM]\n\u0004\u001d\u0015C\u0005C\u0001\u0017G\u0013\t9UF\u0001\u0004B]f\u0014VM\u001a\t\u0003Q%K!AS\r\u0003'9{G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u0015\u0003\u0005\u000b\u0001\"\\3tg\u0006<Wm]\u000b\u0002\u001dB\u0019q\n\u0016,\u000e\u0003AS!!\u0015*\u0002\u000f5,H/\u00192mK*\u00111+L\u0001\u000bG>dG.Z2uS>t\u0017BA+Q\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016\u0001B1vi\"T!aW\u000e\u0002\u0011M,7-\u001e:jifL!!\u0018-\u0003\u0011I+7o\\;sG\u0016\f\u0011\"\\3tg\u0006<Wm\u001d\u0011\u0002\u0013QD'o\\<TSj,W#A1\u0011\u00071\u00127&\u0003\u0002d[\t1q\n\u001d;j_:\fQ\u0002\u001e5s_^\u001c\u0016N_3`I\u0015\fHCA\u001dg\u0011\u001di4#!AA\u0002\u0005\f!\u0002\u001e5s_^\u001c\u0016N_3!Q\t!\u0012\u000e\u0005\u0002-U&\u00111.\f\u0002\tm>d\u0017\r^5mK\u0006\u0019\u0002O]8dKN\u001chj\u001c;jM&\u001c\u0017\r^5p]R\u0011\u0011H\u001c\u0005\u0006_V\u0001\r\u0001]\u0001\u0014]>$\u0018NZ5dCRLwN\\'fgN\fw-\u001a\t\u0004YE\u001c\u0018B\u0001:.\u0005\u0015\t%O]1z!\taC/\u0003\u0002v[\t!!)\u001f;f\u0003!\u0011XmY3jm\u0016$G#\u0001=\u0011\u0007eTh+D\u0001S\u0013\tY(KA\u0002TKF\fAb]3u)\"\u0014xn^*ju\u0016$\"!\u000f@\t\u000b}<\u0002\u0019A\u0016\u0002\u000b%tG-\u001a=\u0002/9|G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:`I\u0015\fHcA\u001d\u0002\u0006!9Q\bCA\u0001\u0002\u0004\t\u0015\u0001\u00068pi&4\u0017nY1uS>t\u0007*\u00198eY\u0016\u0014\b%A\u0003tKR,\u0006\u000fF\u0001:Q\rQ\u0011q\u0002\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0015QWO\\5u\u0015\t\tI\"A\u0002pe\u001eLA!!\b\u0002\u0014\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004\u0017\u0005\r\u0002\u0003BA\t\u0003KIA!a\n\u0002\u0014\t)\u0011I\u001a;fe\u00069B/Z:u!J|7-Z:t\u001d>$\u0018NZ5dCRLwN\u001c\u0015\u0004\u0019\u00055\u0002\u0003BA\t\u0003_IA!!\r\u0002\u0014\t!A+Z:u\u0003y!Xm\u001d;To\u0006dGn\\<t!J|7-Z:t_J,\u0005pY3qi&|g\u000eK\u0002\u000e\u0003[\u0001")
public class ZkNodeChangeNotificationListenerTest
extends ZooKeeperTestHarness {
    private final int changeExpirationMs;
    private ZkNodeChangeNotificationListener notificationListener;
    private TestNotificationHandler notificationHandler;

    private int changeExpirationMs() {
        return this.changeExpirationMs;
    }

    private ZkNodeChangeNotificationListener notificationListener() {
        return this.notificationListener;
    }

    private void notificationListener_$eq(ZkNodeChangeNotificationListener x$1) {
        this.notificationListener = x$1;
    }

    private TestNotificationHandler notificationHandler() {
        return this.notificationHandler;
    }

    private void notificationHandler_$eq(TestNotificationHandler x$1) {
        this.notificationHandler = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.zkClient().createAclPaths();
        this.notificationHandler_$eq(new TestNotificationHandler());
    }

    @Override
    @After
    public void tearDown() {
        if (this.notificationListener() != null) {
            this.notificationListener().close();
        }
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProcessNotification() {
        Resource notificationMessage1 = new Resource((ResourceType)Group$.MODULE$, "messageA", PatternType.LITERAL);
        Resource notificationMessage2 = new Resource((ResourceType)Group$.MODULE$, "messageB", PatternType.LITERAL);
        this.notificationListener_$eq(new ZkNodeChangeNotificationListener(this.zkClient(), LiteralAclChangeStore$.MODULE$.aclChangePath(), ZkAclChangeStore$.MODULE$.SequenceNumberPrefix(), (NotificationHandler)this.notificationHandler(), (long)this.changeExpirationMs(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$6()));
        this.notificationListener().init();
        this.zkClient().createAclChangeNotification(notificationMessage1);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZkNodeChangeNotificationListenerTest.$anonfun$testProcessNotification$1(this, notificationMessage1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ZkNodeChangeNotificationListenerTest.$anonfun$testProcessNotification$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        this.zkClient().createAclChangeNotification(notificationMessage2);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ZkNodeChangeNotificationListenerTest.$anonfun$testProcessNotification$3(this, notificationMessage2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ZkNodeChangeNotificationListenerTest.$anonfun$testProcessNotification$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        int n = 3;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 10);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach$mVc$sp_this = inclusive;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                ZkNodeChangeNotificationListenerTest.$anonfun$testProcessNotification$5(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ZkNodeChangeNotificationListenerTest.$anonfun$testProcessNotification$6(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ZkNodeChangeNotificationListenerTest.$anonfun$testProcessNotification$7(this), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSwallowsProcessorException() {
        this.notificationHandler().setThrowSize(2);
        this.notificationListener_$eq(new ZkNodeChangeNotificationListener(this.zkClient(), LiteralAclChangeStore$.MODULE$.aclChangePath(), ZkAclChangeStore$.MODULE$.SequenceNumberPrefix(), (NotificationHandler)this.notificationHandler(), (long)this.changeExpirationMs(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$6()));
        this.notificationListener().init();
        this.zkClient().createAclChangeNotification(new Resource((ResourceType)Group$.MODULE$, "messageA", PatternType.LITERAL));
        this.zkClient().createAclChangeNotification(new Resource((ResourceType)Group$.MODULE$, "messageB", PatternType.LITERAL));
        this.zkClient().createAclChangeNotification(new Resource((ResourceType)Group$.MODULE$, "messageC", PatternType.LITERAL));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ZkNodeChangeNotificationListenerTest.$anonfun$testSwallowsProcessorException$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ZkNodeChangeNotificationListenerTest.$anonfun$testSwallowsProcessorException$2(this), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testProcessNotification$1(ZkNodeChangeNotificationListenerTest $this, Resource notificationMessage1$1) {
        if ($this.notificationHandler().received().size() == 1) {
            Object object = $this.notificationHandler().received().last();
            if (!(object != null ? !object.equals(notificationMessage1$1) : notificationMessage1$1 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testProcessNotification$2() {
        return "Failed to send/process notification message in the timeout period.";
    }

    public static final /* synthetic */ boolean $anonfun$testProcessNotification$3(ZkNodeChangeNotificationListenerTest $this, Resource notificationMessage2$1) {
        if ($this.notificationHandler().received().size() == 2) {
            Object object = $this.notificationHandler().received().last();
            if (!(object != null ? !object.equals(notificationMessage2$1) : notificationMessage2$1 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testProcessNotification$4() {
        return "Failed to send/process notification message in the timeout period.";
    }

    public static final /* synthetic */ void $anonfun$testProcessNotification$5(ZkNodeChangeNotificationListenerTest $this, int i) {
        $this.zkClient().createAclChangeNotification(new Resource((ResourceType)Group$.MODULE$, new StringBuilder(7).append("message").append(i).toString(), PatternType.LITERAL));
    }

    public static final /* synthetic */ boolean $anonfun$testProcessNotification$6(ZkNodeChangeNotificationListenerTest $this) {
        return $this.notificationHandler().received().size() == 10;
    }

    public static final /* synthetic */ String $anonfun$testProcessNotification$7(ZkNodeChangeNotificationListenerTest $this) {
        return new StringBuilder(64).append("Expected 10 invocations of processNotifications, but there were ").append($this.notificationHandler().received()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testSwallowsProcessorException$1(ZkNodeChangeNotificationListenerTest $this) {
        return $this.notificationHandler().received().size() == 3;
    }

    public static final /* synthetic */ String $anonfun$testSwallowsProcessorException$2(ZkNodeChangeNotificationListenerTest $this) {
        return new StringBuilder(63).append("Expected 2 invocations of processNotifications, but there were ").append($this.notificationHandler().received()).toString();
    }

    public ZkNodeChangeNotificationListenerTest() {
        this.changeExpirationMs = 1000;
    }

    public class TestNotificationHandler
    implements NotificationHandler {
        private final ArrayBuffer<Resource> messages;
        private volatile Option<Object> throwSize;

        private ArrayBuffer<Resource> messages() {
            return this.messages;
        }

        private Option<Object> throwSize() {
            return this.throwSize;
        }

        private void throwSize_$eq(Option<Object> x$1) {
            this.throwSize = x$1;
        }

        public void processNotification(byte[] notificationMessage) {
            this.messages().$plus$eq((Object)LiteralAclStore$.MODULE$.changeStore().decode(notificationMessage));
            if (this.throwSize().contains((Object)BoxesRunTime.boxToInteger((int)this.messages().size()))) {
                throw new RuntimeException("Oh no, my processing failed!");
            }
        }

        public Seq<Resource> received() {
            return this.messages();
        }

        public void setThrowSize(int index) {
            this.throwSize_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)index)));
        }

        public /* synthetic */ ZkNodeChangeNotificationListenerTest kafka$common$ZkNodeChangeNotificationListenerTest$TestNotificationHandler$$$outer() {
            return ZkNodeChangeNotificationListenerTest.this;
        }

        public TestNotificationHandler() {
            if (ZkNodeChangeNotificationListenerTest.this == null) {
                throw null;
            }
            this.messages = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            this.throwSize = Option$.MODULE$.empty();
        }
    }
}

