/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.common.StateChangeFailedException;
import kafka.controller.ControlledShutdownPartitionLeaderElectionStrategy$;
import kafka.controller.ControllerContext;
import kafka.controller.Election$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflinePartitionLeaderElectionStrategy;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderElectionStrategy;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine;
import kafka.controller.PreferredReplicaPartitionLeaderElectionStrategy$;
import kafka.controller.ReassignPartitionLeaderElectionStrategy$;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u00114AAB\u0004\u0001\u0019!A\u0011\u0003\u0001B\u0001B\u0003%!\u0003\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0011\u0015\t\u0003\u0001\"\u0011#\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0005eiunY6QCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3\u000b\u0005!I\u0011AC2p]R\u0014x\u000e\u001c7fe*\t!\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0001C\u0001\b\u0010\u001b\u00059\u0011B\u0001\t\b\u0005U\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016\f\u0011cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=u!\tq1#\u0003\u0002\u0015\u000f\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u00029Ut7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\u0016s\u0017M\u00197fIB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\bF\u0002\u001f?\u0001\u0002\"A\u0004\u0001\t\u000bE\u0019\u0001\u0019\u0001\n\t\u000bU\u0019\u0001\u0019\u0001\f\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\u0005G-\u001b\u0006\f\u0005\u0003%W9JdBA\u0013*!\t1\u0003$D\u0001(\u0015\tA3\"\u0001\u0004=e>|GOP\u0005\u0003Ua\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\ri\u0015\r\u001d\u0006\u0003Ua\u0001\"aL\u001c\u000e\u0003AR!!\r\u001a\u0002\r\r|W.\\8o\u0015\tQ1G\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<\u0017B\u0001\u001d1\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004BAO C\u000b:\u00111(\u0010\b\u0003MqJ\u0011!G\u0005\u0003}a\tq\u0001]1dW\u0006<W-\u0003\u0002A\u0003\n1Q)\u001b;iKJT!A\u0010\r\u0011\u0005i\u001a\u0015B\u0001#B\u0005%!\u0006N]8xC\ndW\r\u0005\u0002G\u00136\tqI\u0003\u0002I\u0013\u0005\u0019\u0011\r]5\n\u0005);%\u0001\u0004'fC\u0012,'/\u00118e\u0013N\u0014\b\"\u0002'\u0005\u0001\u0004i\u0015A\u00039beRLG/[8ogB\u0019a*\u0015\u0018\u000e\u0003=S!\u0001\u0015\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002S\u001f\n\u00191+Z9\t\u000bQ#\u0001\u0019A+\u0002\u0017Q\f'oZ3u'R\fG/\u001a\t\u0003\u001dYK!aV\u0004\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK\")\u0011\f\u0002a\u00015\u00061B.Z1eKJ,E.Z2uS>t7\u000b\u001e:bi\u0016<\u0017\u0010E\u0002\u00187vK!\u0001\u0018\r\u0003\r=\u0003H/[8o!\tqa,\u0003\u0002`\u000f\ty\u0002+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\*ue\u0006$XmZ=\u0002#\u0011|G*Z1eKJ,E.Z2uS>t7\u000fF\u0002$E\u000eDQ\u0001T\u0003A\u00025CQ!W\u0003A\u0002u\u0003")
public class MockPartitionStateMachine
extends PartitionStateMachine {
    private final ControllerContext controllerContext;
    private final boolean uncleanLeaderElectionEnabled;

    /*
     * WARNING - void declaration
     */
    public Map<TopicPartition, Either<Throwable, LeaderAndIsr>> handleStateChanges(Seq<TopicPartition> partitions, PartitionState targetState, Option<PartitionLeaderElectionStrategy> leaderElectionStrategy) {
        void var6_6;
        void var5_5;
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.controllerContext.putPartitionStateIfNotExists(partition, (PartitionState)NonExistentPartition$.MODULE$);
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = this.controllerContext.checkValidPartitionStateChange(partitions, targetState);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq validPartitions = (Seq)tuple2._1();
        Seq invalidPartitions = (Seq)tuple2._2();
        void validPartitions2 = var5_5;
        void invalidPartitions2 = var6_6;
        if (invalidPartitions2.nonEmpty()) {
            Seq currentStates = (Seq)invalidPartitions2.map((Function1 & Serializable & scala.Serializable)p -> $this.controllerContext.partitionStates().get(p), Seq$.MODULE$.canBuildFrom());
            throw new IllegalStateException(new StringBuilder(44).append("Invalid state transition to ").append(targetState).append(" for partitions ").append(currentStates).toString());
        }
        PartitionState partitionState = targetState;
        OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
        if (!(partitionState != null ? !partitionState.equals(onlinePartition$) : onlinePartition$ != null)) {
            Seq uninitializedPartitions = (Seq)validPartitions2.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)MockPartitionStateMachine.$anonfun$handleStateChanges$3(this, partition)));
            Seq partitionsToElectLeader = (Seq)partitions.filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)MockPartitionStateMachine.$anonfun$handleStateChanges$4(this, partition)));
            uninitializedPartitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                this.controllerContext.putPartitionState(partition, targetState);
                return BoxedUnit.UNIT;
            });
            Map<TopicPartition, Either<Throwable, LeaderAndIsr>> electionResults = this.doLeaderElections((Seq<TopicPartition>)partitionsToElectLeader, (PartitionLeaderElectionStrategy)leaderElectionStrategy.get());
            electionResults.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                MockPartitionStateMachine.$anonfun$handleStateChanges$6(this, targetState, x0$1);
                return BoxedUnit.UNIT;
            });
            return electionResults;
        }
        validPartitions2.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            this.controllerContext.putPartitionState(partition, targetState);
            return BoxedUnit.UNIT;
        });
        return Predef$.MODULE$.Map().empty();
    }

    private Map<TopicPartition, Either<Throwable, LeaderAndIsr>> doLeaderElections(Seq<TopicPartition> partitions, PartitionLeaderElectionStrategy leaderElectionStrategy) {
        Seq seq;
        scala.collection.mutable.Map failedElections = Map$.MODULE$.empty();
        Buffer validLeaderAndIsrs = (Buffer)Buffer$.MODULE$.empty();
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)$this.controllerContext.partitionLeadershipInfo().apply(partition);
            if (leaderIsrAndControllerEpoch.controllerEpoch() > $this.controllerContext.epoch()) {
                String failMsg = new StringBuilder(233).append("Aborted leader election for partition ").append(partition).append(" since the LeaderAndIsr path was ").append("already written by another controller. This probably means that the current controller went through ").append("a soft failure and another controller was elected with epoch ").append(leaderIsrAndControllerEpoch.controllerEpoch()).append(".").toString();
                return failedElections.put(partition, (Object)package$.MODULE$.Left().apply((Object)new StateChangeFailedException(failMsg)));
            }
            validLeaderAndIsrs.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2(partition, (Object)leaderIsrAndControllerEpoch.leaderAndIsr())}));
            return BoxedUnit.UNIT;
        });
        if (leaderElectionStrategy instanceof OfflinePartitionLeaderElectionStrategy) {
            boolean isUnclean = ((OfflinePartitionLeaderElectionStrategy)leaderElectionStrategy).allowUnclean();
            Buffer partitionsWithUncleanLeaderElectionState = (Buffer)validLeaderAndIsrs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition partition = (TopicPartition)x0$1._1();
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)x0$1._2();
                Tuple3 tuple3 = new Tuple3((Object)partition, (Object)new Some((Object)leaderAndIsr), (Object)BoxesRunTime.boxToBoolean((isUnclean || $this.uncleanLeaderElectionEnabled ? 1 : 0) != 0));
                return tuple3;
            }, Buffer$.MODULE$.canBuildFrom());
            seq = Election$.MODULE$.leaderForOffline(this.controllerContext, (Seq)partitionsWithUncleanLeaderElectionState);
        } else if (ReassignPartitionLeaderElectionStrategy$.MODULE$.equals(leaderElectionStrategy)) {
            seq = Election$.MODULE$.leaderForReassign(this.controllerContext, (Seq)validLeaderAndIsrs);
        } else if (PreferredReplicaPartitionLeaderElectionStrategy$.MODULE$.equals(leaderElectionStrategy)) {
            seq = Election$.MODULE$.leaderForPreferredReplica(this.controllerContext, (Seq)validLeaderAndIsrs);
        } else if (ControlledShutdownPartitionLeaderElectionStrategy$.MODULE$.equals(leaderElectionStrategy)) {
            seq = Election$.MODULE$.leaderForControlledShutdown(this.controllerContext, (Seq)validLeaderAndIsrs);
        } else {
            throw new MatchError((Object)leaderElectionStrategy);
        }
        return ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)electionResult -> {
            void $minus$greater$extension_$this;
            Left left;
            TopicPartition partition = electionResult.topicPartition();
            Option option = electionResult.leaderAndIsr();
            if (None$.MODULE$.equals(option)) {
                String failMsg = new StringBuilder(53).append("Failed to elect leader for partition ").append(partition).append(" under strategy ").append(leaderElectionStrategy).toString();
                left = package$.MODULE$.Left().apply((Object)new StateChangeFailedException(failMsg));
            } else if (option instanceof Some) {
                LeaderAndIsr leaderAndIsr = (LeaderAndIsr)((Some)option).value();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, $this.controllerContext.epoch());
                $this.controllerContext.partitionLeadershipInfo().put((Object)partition, (Object)leaderIsrAndControllerEpoch);
                left = package$.MODULE$.Right().apply((Object)leaderAndIsr);
            } else {
                throw new MatchError((Object)option);
            }
            Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)left);
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)failedElections);
    }

    public static final /* synthetic */ boolean $anonfun$handleStateChanges$3(MockPartitionStateMachine $this, TopicPartition partition) {
        PartitionState partitionState = $this.controllerContext.partitionState(partition);
        NewPartition$ newPartition$ = NewPartition$.MODULE$;
        return !(partitionState != null ? !partitionState.equals(newPartition$) : newPartition$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$handleStateChanges$4(MockPartitionStateMachine $this, TopicPartition partition) {
        block3: {
            block2: {
                PartitionState currentState;
                PartitionState partitionState = currentState = $this.controllerContext.partitionState(partition);
                OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                if (!(partitionState == null ? offlinePartition$ != null : !partitionState.equals(offlinePartition$))) break block2;
                PartitionState partitionState2 = currentState;
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                if (partitionState2 != null ? !partitionState2.equals(onlinePartition$) : onlinePartition$ != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$handleStateChanges$6(MockPartitionStateMachine $this, PartitionState targetState$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition partition = (TopicPartition)x0$1._1();
            if ((Either)x0$1._2() instanceof Right) {
                $this.controllerContext.putPartitionState(partition, targetState$1);
                return;
            }
        }
        if (x0$1 != null && (Either)x0$1._2() instanceof Left) {
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public MockPartitionStateMachine(ControllerContext controllerContext, boolean uncleanLeaderElectionEnabled) {
        this.controllerContext = controllerContext;
        this.uncleanLeaderElectionEnabled = uncleanLeaderElectionEnabled;
        super(controllerContext);
    }
}

