/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.controller.ControllerContext;
import kafka.controller.ControllerStats;
import kafka.controller.PartitionLeaderElectionAlgorithms$;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3Aa\u0005\u000b\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001a\u0001\n\u0013)\u0003bB\u0015\u0001\u0001\u0004%IA\u000b\u0005\u0007a\u0001\u0001\u000b\u0015\u0002\u0014\t\u000bE\u0002A\u0011\u0001\u001a\t\u000bq\u0002A\u0011\u0001\u001a\t\u000b\u0005\u0003A\u0011\u0001\u001a\t\u000b\r\u0003A\u0011\u0001\u001a\t\u000b\u0015\u0003A\u0011\u0001\u001a\t\u000b\u001d\u0003A\u0011\u0001\u001a\t\u000b%\u0003A\u0011\u0001\u001a\t\u000b-\u0003A\u0011\u0001\u001a\t\u000b5\u0003A\u0011\u0001\u001a\t\u000b=\u0003A\u0011\u0001\u001a\t\u000bE\u0003A\u0011\u0001\u001a\t\u000bM\u0003A\u0011\u0001\u001a\t\u000bU\u0003A\u0011\u0001\u001a\t\u000b]\u0003A\u0011\u0001\u001a\u0003KA\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0017\t\\4pe&$\b.\\:UKN$(BA\u000b\u0017\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002/\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011\u0001F\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#\u0001\u0014\u0011\u0005\r:\u0013B\u0001\u0015\u0015\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\u0016G>tGO]8mY\u0016\u00148i\u001c8uKb$x\fJ3r)\tYc\u0006\u0005\u0002\u001cY%\u0011Q\u0006\b\u0002\u0005+:LG\u000fC\u00040\u0007\u0005\u0005\t\u0019\u0001\u0014\u0002\u0007a$\u0013'\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0013!B:fiV\u0003H#A\u0016)\u0005\u0015!\u0004CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0015QWO\\5u\u0015\u0005I\u0014aA8sO&\u00111H\u000e\u0002\u0007\u0005\u00164wN]3\u0002EQ,7\u000f^(gM2Lg.\u001a)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8oQ\t1a\b\u0005\u00026\u007f%\u0011\u0001I\u000e\u0002\u0005)\u0016\u001cH/A'uKN$xJ\u001a4mS:,\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c'bgRL5O](gM2Lg.Z+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c#jg\u0006\u0014G.\u001a3)\u0005\u001dq\u0014\u0001\u0014;fgR|eM\u001a7j]\u0016\u0004\u0016M\u001d;ji&|g\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eT1ti&\u001b(o\u00144gY&tW-\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g.\u00128bE2,G\r\u000b\u0002\t}\u0005\u0019C/Z:u%\u0016\f7o]5h]B\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0007FA\u0005?\u0003A\"Xm\u001d;SK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016cWm\u0019;j_:<\u0016\u000e\u001e5O_2Kg/Z%te\"\u0012!BP\u00010i\u0016\u001cHOU3bgNLwM\u001c)beRLG/[8o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o/&$\b.R7qifL5O\u001d\u0015\u0003\u0017y\n1\u0006^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0003\u0019y\nq\t^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c)sK\u001a,'O]3e%\u0016\u0004H.[2b\u0013:L5O\u001d(pi2Kg/\u001a\u0015\u0003\u001by\nq\t^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c)sK\u001a,'O]3e%\u0016\u0004H.[2b\u001d>$\u0018J\\%te2Kg/\u001a\u0015\u0003\u001dy\n!\n^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c)sK\u001a,'O]3e%\u0016\u0004H.[2b\u001d>$\u0018J\\%te:{G\u000fT5wK\"\u0012qBP\u0001.i\u0016\u001cHoQ8oiJ|G\u000e\\3e'\",H\u000fZ8x]B\u000b'\u000f^5uS>tG*Z1eKJ,E.Z2uS>t\u0007F\u0001\t?\u0003\u0001#Xm\u001d;D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\u001c'bgRL5O]*ikR$\u0018N\\4E_^t\u0007FA\t?\u0003%#Xm\u001d;D_:$(o\u001c7mK\u0012\u001c\u0006.\u001e;e_^t\u0007+\u0019:uSRLwN\u001c'fC\u0012,'/\u00127fGRLwN\\!mY&\u001b(oU5nk2$\u0018M\\3pkNd\u0017p\u00155vi\u0012|wO\u001c\u0015\u0003%y\u0002")
public class PartitionLeaderElectionAlgorithmsTest {
    private ControllerContext controllerContext = null;

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    @Before
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        ControllerStats qual$1 = this.controllerContext().stats();
        String x$1 = "UncleanLeaderElectionsPerSec";
        Map x$2 = qual$1.removeMetric$default$2();
        qual$1.removeMetric(x$1, x$2);
    }

    @Test
    public void testOfflinePartitionLeaderElection() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, isr, liveReplicas, false, this.controllerContext());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionDisabled() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, isr, liveReplicas, false, this.controllerContext());
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
        Assert.assertEquals((long)0L, (long)this.controllerContext().stats().uncleanLeaderElectionRate().count());
    }

    @Test
    public void testOfflinePartitionLeaderElectionLastIsrOfflineUncleanLeaderElectionEnabled() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.offlinePartitionLeaderElection(assignment, isr, liveReplicas, true, this.controllerContext());
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
        Assert.assertEquals((long)1L, (long)this.controllerContext().stats().uncleanLeaderElectionRate().count());
    }

    @Test
    public void testReassignPartitionLeaderElection() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithNoLiveIsr() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testReassignPartitionLeaderElectionWithEmptyIsr() {
        Seq reassignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.empty();
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.reassignPartitionLeaderElection(reassignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElection() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)2)), (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaInIsrNotLive() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrLive() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testPreferredReplicaPartitionLeaderElectionPreferredReplicaNotInIsrNotLive() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.empty();
        Set liveReplicas = Predef$.MODULE$.Set().empty();
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.preferredReplicaPartitionLeaderElection(assignment, isr, liveReplicas);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElection() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)4)), (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionLastIsrShuttingDown() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }

    @Test
    public void testControlledShutdownPartitionLeaderElectionAllIsrSimultaneouslyShutdown() {
        Seq assignment = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set liveReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Set shuttingDownBrokers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4}));
        Option leaderOpt = PartitionLeaderElectionAlgorithms$.MODULE$.controlledShutdownPartitionLeaderElection(assignment, isr, liveReplicas, shuttingDownBrokers);
        Assert.assertEquals((Object)None$.MODULE$, (Object)leaderOpt);
    }
}

