/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001A3AAC\u0006\u0001%!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0003q\u0002B\u0002\u0012\u0001A\u0003%q\u0004C\u0004$\u0001\t\u0007I\u0011\u0001\u0013\t\r!\u0002\u0001\u0015!\u0003&\u0011\u001dI\u0003A1A\u0005\u0002)Ba!\u0011\u0001!\u0002\u0013Y\u0003\"\u0002\"\u0001\t\u0003\u0019\u0005\"\u0002(\u0001\t\u0003\u0019%A\u0005+sC:\u001c\u0018m\u0019;j_:dun\u001a+fgRT!\u0001D\u0007\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u001d=\t1bY8pe\u0012Lg.\u0019;pe*\t\u0001#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0017\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\u0012a\b\t\u0003)\u0001J!!I\u000b\u0003\u000bMCwN\u001d;\u0002\u001dA\u0014x\u000eZ;dKJ,\u0005o\\2iA\u0005!BO]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN,\u0012!\n\t\u0003)\u0019J!aJ\u000b\u0003\u0007%sG/A\u000bue\u0006t7/Y2uS>tG+[7f_V$Xj\u001d\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012a\u000b\t\u0004YM2dBA\u00172!\tqS#D\u00010\u0015\t\u0001\u0014#\u0001\u0004=e>|GOP\u0005\u0003eU\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001b6\u0005\r\u0019V\r\u001e\u0006\u0003eU\u0001\"aN \u000e\u0003aR!!\u000f\u001e\u0002\r\r|W.\\8o\u0015\t\u00012H\u0003\u0002={\u00051\u0011\r]1dQ\u0016T\u0011AP\u0001\u0004_J<\u0017B\u0001!9\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002GMDw.\u001e7e)\"\u0014xn^#yG\u0016\u0004H/[8o/JLG/Z%om\u0006d\u0017\u000e\u001a+y]R\tA\t\u0005\u0002\u0015\u000b&\u0011a)\u0006\u0002\u0005+:LG\u000f\u000b\u0002\t\u0011B\u0011\u0011\nT\u0007\u0002\u0015*\u00111*P\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u001b*\u0013A\u0001V3ti\u000692\u000f[8vY\u0012\u0014V-\u00193Xe&$X-T3tg\u0006<Wm\u001d\u0015\u0003\u0013!\u0003")
public class TransactionLogTest {
    private final short producerEpoch;
    private final int transactionTimeoutMs;
    private final Set<TopicPartition> topicPartitions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1), new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)}));

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    @Test
    public void shouldThrowExceptionWriteInvalidTxn() {
        String transactionalId = "transactionalId";
        long producerId = 23423L;
        TransactionMetadata txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId, this.producerEpoch(), this.transactionTimeoutMs(), 0L);
        txnMetadata.addPartitions(this.topicPartitions());
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TransactionLogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldReadWriteMessages() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this9;
        void $minus$greater$extension_y10;
        void $minus$greater$extension_$this10;
        void $minus$greater$extension_y11;
        void $minus$greater$extension_$this11;
        void $minus$greater$extension_y12;
        void $minus$greater$extension_$this12;
        Tuple2[] tuple2Array = new Tuple2[6];
        Long l = BoxesRunTime.boxToLong((long)0L);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"zero");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y12);
        Long l2 = BoxesRunTime.boxToLong((long)1L);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"one");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y11);
        Long l3 = BoxesRunTime.boxToLong((long)2L);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"two");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y10);
        Long l4 = BoxesRunTime.boxToLong((long)3L);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)"three");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
        Long l5 = BoxesRunTime.boxToLong((long)4L);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)"four");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        Long l6 = BoxesRunTime.boxToLong((long)5L);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)"five");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[5] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        Map pidMappings = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        Tuple2[] tuple2Array2 = new Tuple2[6];
        Empty$ empty$ = Empty$.MODULE$;
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)0L));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        Ongoing$ ongoing$ = Ongoing$.MODULE$;
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)1L));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)2L));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[2] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        CompleteCommit$ completeCommit$ = CompleteCommit$.MODULE$;
        Object object10 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)3L));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[3] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
        Object object11 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)4L));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[4] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        CompleteAbort$ completeAbort$ = CompleteAbort$.MODULE$;
        Object object12 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)5L));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[5] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map transactionStates = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        Seq txnRecords = ((TraversableOnce)pidMappings.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionMetadata txnMetadata;
            String transactionalId;
            if (x0$1 != null) {
                long producerId;
                transactionalId = (String)x0$1._1();
                txnMetadata = TransactionMetadata$.MODULE$.apply(transactionalId, producerId = x0$1._2$mcJ$sp(), this.producerEpoch(), this.transactionTimeoutMs(), (TransactionState)transactionStates.apply((Object)BoxesRunTime.boxToLong((long)producerId)), 0L);
                if (!txnMetadata.state().equals(Empty$.MODULE$)) {
                    txnMetadata.addPartitions(this.topicPartitions());
                }
            } else {
                throw new MatchError(null);
            }
            byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
            byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit());
            SimpleRecord simpleRecord = new SimpleRecord(keyBytes, valueBytes);
            return simpleRecord;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])txnRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        IntRef count = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionLogTest.$anonfun$shouldReadWriteMessages$2(this, pidMappings, transactionStates, count, record);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)pidMappings.size(), (long)count.elem);
    }

    public static final /* synthetic */ void $anonfun$shouldReadWriteMessages$2(TransactionLogTest $this, Map pidMappings$1, Map transactionStates$1, IntRef count$1, Record record) {
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)pidMappings$1.apply((Object)transactionalId)), (long)txnMetadata.producerId());
        Assert.assertEquals((long)$this.producerEpoch(), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)$this.transactionTimeoutMs(), (long)txnMetadata.txnTimeoutMs());
        Assert.assertEquals((Object)transactionStates$1.apply((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId())), (Object)txnMetadata.state());
        if (txnMetadata.state().equals(Empty$.MODULE$)) {
            Assert.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)txnMetadata.topicPartitions());
        } else {
            Assert.assertEquals($this.topicPartitions(), (Object)txnMetadata.topicPartitions());
        }
        ++count$1.elem;
    }

    public TransactionLogTest() {
        this.producerEpoch = 0;
        this.transactionTimeoutMs = 1000;
    }
}

