/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleanerManagerTest;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tee\u0001\u0002\u001d:\u0001yBQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004Z\u0001\u0001\u0006I!\u0015\u0005\b5\u0002\u0011\r\u0011\"\u0001Q\u0011\u0019Y\u0006\u0001)A\u0005#\"9A\f\u0001b\u0001\n\u0003i\u0006BB5\u0001A\u0003%a\fC\u0004k\u0001\t\u0007I\u0011A6\t\rI\u0004\u0001\u0015!\u0003m\u0011\u001d\u0019\bA1A\u0005\u0002QDa\u0001\u001f\u0001!\u0002\u0013)\bbB=\u0001\u0005\u0004%\tA\u001f\u0005\u0007}\u0002\u0001\u000b\u0011B>\t\u0011}\u0004!\u0019!C\u0001\u0003\u0003A\u0001\"!\u0007\u0001A\u0003%\u00111\u0001\u0004\u0007\u00037\u0001\u0001!!\b\t\u0019\u0005\u0015\u0002C!A!\u0002\u0013\t9#a\u0010\t\u0019\u0005\u0005\u0003C!A!\u0002\u0013\t\u0019%a\u0014\t\u0019\u0005E\u0003C!A!\u0002\u0013\t\u0019&a\u0018\t\r-\u0003B\u0011AA1\u0011\u001d\ti\u0007\u0005C!\u0003_Bq!a \u0001\t\u0003\t\t\tC\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005=\u0006\u0001\"\u0001\u0002\u0002\"9\u0011\u0011\u0018\u0001\u0005\u0002\u0005\u0005\u0005bBA_\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003\u0003\u0004A\u0011AAA\u0011\u001d\t)\r\u0001C\u0001\u0003\u0003Cq!!3\u0001\t\u0003\t\t\tC\u0004\u0002N\u0002!\t!!!\t\u000f\u0005E\u0007\u0001\"\u0001\u0002\u0002\"9\u0011Q\u001b\u0001\u0005\u0002\u0005\u0005\u0005bBAm\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003;\u0004A\u0011AAA\u0011\u001d\t\t\u000f\u0001C\u0001\u0003\u0003Cq!!:\u0001\t\u0003\t\t\tC\u0004\u0002j\u0002!\t!!!\t\u000f\u00055\b\u0001\"\u0001\u0002\u0002\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005\u0005\u0005bBA{\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003s\u0004A\u0011AAA\u0011\u001d\ti\u0010\u0001C\u0001\u0003\u0003CqA!\u0001\u0001\t\u0003\t\t\tC\u0004\u0003\u0006\u0001!\t!!!\t\u000f\t%\u0001\u0001\"\u0001\u0002\u0002\"9!Q\u0002\u0001\u0005\n\t=\u0001b\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011%\u0011y\u0003AI\u0001\n\u0013\u0011\t\u0004C\u0004\u0003H\u0001!IA!\u0013\t\u000f\t=\u0003\u0001\"\u0003\u0003R!9!\u0011\r\u0001\u0005\n\t\r\u0004b\u0002B6\u0001\u0011%!Q\u000e\u0005\n\u0005o\u0002\u0011\u0013!C\u0005\u0005sBqA! \u0001\t\u0013\u0011yHA\u000bM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ$Vm\u001d;\u000b\u0005iZ\u0014a\u00017pO*\tA(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001yT\t\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015I\u0001\u0004B]f\u0014VM\u001a\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011n\nQ!\u001e;jYNL!AS$\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\u0014\t\u0003\u001d\u0002i\u0011!O\u0001\u0007i6\u0004H)\u001b:\u0016\u0003E\u0003\"AU,\u000e\u0003MS!\u0001V+\u0002\u0005%|'\"\u0001,\u0002\t)\fg/Y\u0005\u00031N\u0013AAR5mK\u00069A/\u001c9ESJ\u0004\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\ta\f\u0005\u0002`O6\t\u0001M\u0003\u0002bE\u000611m\\7n_:T!\u0001P2\u000b\u0005\u0011,\u0017AB1qC\u000eDWMC\u0001g\u0003\ry'oZ\u0005\u0003Q\u0002\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003!awn\u001a)s_B\u001cX#\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=,\u0016\u0001B;uS2L!!\u001d8\u0003\u0015A\u0013x\u000e]3si&,7/A\u0005m_\u001e\u0004&o\u001c9tA\u0005IAn\\4D_:4\u0017nZ\u000b\u0002kB\u0011aJ^\u0005\u0003of\u0012\u0011\u0002T8h\u0007>tg-[4\u0002\u00151|wmQ8oM&<\u0007%\u0001\u0003uS6,W#A>\u0011\u0005\u0019c\u0018BA?H\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013AE2mK\u0006tWM]\"iK\u000e\\\u0007o\\5oiN,\"!a\u0001\u0011\u000f\u0005\u0015\u0011q\u00020\u0002\u00145\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!A\u0004nkR\f'\r\\3\u000b\u0007\u00055\u0011)\u0001\u0006d_2dWm\u0019;j_:LA!!\u0005\u0002\b\t\u0019Q*\u00199\u0011\u0007\u0001\u000b)\"C\u0002\u0002\u0018\u0005\u0013A\u0001T8oO\u0006\u00192\r\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;tA\t)Bj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:N_\u000e\\7c\u0001\t\u0002 A\u0019a*!\t\n\u0007\u0005\r\u0012HA\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ\fq\u0001\\8h\t&\u00148\u000fE\u0003\u0002*\u0005e\u0012K\u0004\u0003\u0002,\u0005Ub\u0002BA\u0017\u0003gi!!a\f\u000b\u0007\u0005ER(\u0001\u0004=e>|GOP\u0005\u0002\u0005&\u0019\u0011qG!\u0002\u000fA\f7m[1hK&!\u00111HA\u001f\u0005\r\u0019V-\u001d\u0006\u0004\u0003o\t\u0015\u0002BA\u0013\u0003C\tA\u0001\\8hgB1a)!\u0012_\u0003\u0013J1!a\u0012H\u0005\u0011\u0001vn\u001c7\u0011\u00079\u000bY%C\u0002\u0002Ne\u00121\u0001T8h\u0013\u0011\t\t%!\t\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m!\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-w\u000511/\u001a:wKJLA!!\u0018\u0002X\t!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2LA!!\u0015\u0002\"QA\u00111MA4\u0003S\nY\u0007E\u0002\u0002fAi\u0011\u0001\u0001\u0005\b\u0003K!\u0002\u0019AA\u0014\u0011\u001d\t\t\u0005\u0006a\u0001\u0003\u0007Bq!!\u0015\u0015\u0001\u0004\t\u0019&A\u000bbY2\u001cE.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0005\u0005E\u0004cBA:\u0003wr\u00161\u0003\b\u0005\u0003k\n9\bE\u0002\u0002.\u0005K1!!\u001fB\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011CA?\u0015\r\tI(Q\u0001\ti\u0016\f'\u000fR8x]R\u0011\u00111\u0011\t\u0004\u0001\u0006\u0015\u0015bAAD\u0003\n!QK\\5uQ\r1\u00121\u0012\t\u0005\u0003\u001b\u000b\u0019*\u0004\u0002\u0002\u0010*\u0019\u0011\u0011S3\u0002\u000b),h.\u001b;\n\t\u0005U\u0015q\u0012\u0002\u0006\u0003\u001a$XM]\u0001\u001cg\u0016$X\u000f]%oGJ,\u0017m]5oO2Lh)\u001b7uQfdunZ:\u0015\u0011\u0005\r\u00131TAQ\u0003WCq!!(\u0018\u0001\u0004\ty*\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004R!!\u000b\u0002:yCq!a)\u0018\u0001\u0004\t)+A\bti\u0006\u0014HOT;n\u0005\u0006$8\r[3t!\r\u0001\u0015qU\u0005\u0004\u0003S\u000b%aA%oi\"9\u0011QV\fA\u0002\u0005\u0015\u0016A\u00042bi\u000eD\u0017J\\2sK6,g\u000e^\u0001-i\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pORC'o\\<t\u000bb\u001cW\r\u001d;j_:D3\u0001GAZ!\u0011\ti)!.\n\t\u0005]\u0016q\u0012\u0002\u0005)\u0016\u001cH/\u0001\u001duKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h%\u0016$XO\u001d8t\u0019><w+\u001b;i\t&\u0014H/[3tiJ\u000bG/[8)\u0007e\t\u0019,A\u001duKN$xI]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h\u0013\u001etwN]3t+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8tQ\rQ\u00121W\u00019i\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pO&;gn\u001c:fg&s\u0007K]8he\u0016\u001c8\u000fU1si&$\u0018n\u001c8tQ\rY\u00121W\u0001Ui\u0016\u001cHo\u0012:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pO&;gn\u001c:fg\n{G\u000f[%o!J|wM]3tgB\u000b'\u000f^5uS>t7/\u00118e+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8tQ\ra\u00121W\u0001*i\u0016\u001cH\u000fR5sif|eMZ:fiJ+7/\u001a;JM2\u000b'oZ3s)\"\fg.\u00128e\u001f\u001a47/\u001a;)\u0007u\t\u0019,\u0001\u0017uKN$H)\u001b:us>3gm]3u%\u0016\u001cX\r^%g'6\fG\u000e\\3s)\"\fgn\u0015;beR|eMZ:fi\"\u001aa$a-\u0002gQ,7\u000f\u001e'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e'be\u001e,'\u000f\u00165b]\u0006\u001bG/\u001b<f'\u0016<W.\u001a8u\u0005\u0006\u001cXm\u00144gg\u0016$\bfA\u0010\u00024\u0006\u0001D/Z:u\t&\u0014H/_(gMN,G\u000fT1sO\u0016\u0014H\u000b[1o\u0003\u000e$\u0018N^3TK\u001elWM\u001c;CCN,wJ\u001a4tKRD3\u0001IAZ\u0003\u0011#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI:{GoQ8og&$WM]\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017\u0010R3mKR,Gj\\4tQ\r\t\u00131W\u0001Ii\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=D_6\u0004\u0018m\u0019;EK2,G/\u001a'pOND3AIAZ\u0003\t#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI\u000e{gn]5eKJ\u001cE.Z1okB\u0004v\u000e\\5ds\u000e{W\u000e]1di2{wm\u001d\u0015\u0004G\u0005M\u0016a\u000b;fgRdunZ:V]\u0012,'o\u00117fC:,\b/\u00138fY&<\u0017N\u00197f\r>\u00148i\\7qC\u000e$\u0018n\u001c8)\u0007\u0011\n\u0019,\u0001\u0015uKN$8i\u001c8dkJ\u0014XM\u001c;M_\u001e\u001cE.Z1okB\fe\u000e\u001a'pOR\u0013XO\\2bi&|g\u000eK\u0002&\u0003g\u000b\u0001\u0006^3ti\u000e{gnY;se\u0016tG\u000fT8h\u00072,\u0017M\\;q\u0003:$Gk\u001c9jG\u0012+G.\u001a;j_:D3AJAZ\u0003\t#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI:{GoQ8og&$WM]+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004O\u0005M\u0016a\u0007;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s\u001d>tW\rK\u0002)\u0003g\u000b1\u0004^3ti\u000ecW-\u00198bE2,wJ\u001a4tKR\u001chi\u001c:US6,\u0007fA\u0015\u00024\u0006\u0001C/Z:u\u00072,\u0017M\\1cY\u0016|eMZ:fiN4uN]*i_J$H+[7fQ\rQ\u00131W\u0001+i\u0016\u001cH/\u00168eK\u000eLG-\u001a3Ue\u0006t7/Y2uS>t\u0017\r\u001c#bi\u0006tu\u000e^\"mK\u0006t\u0017M\u00197fQ\rY\u00131W\u0001\u0011i\u0016\u001cH\u000fR8oK\u000ecW-\u00198j]\u001eD3\u0001LAZ\u0003A!Xm\u001d;E_:,G)\u001a7fi&tw\rK\u0002.\u0003g\u000bAc\u0019:fCR,7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014H\u0003BA\u0010\u0005#AaA\u000f\u0018A\u0002\u0005%\u0013\u0001G2sK\u0006$Xm\u00117fC:,'/T1oC\u001e,'/T8dWR!\u00111\rB\f\u0011\u001d\u0011Ib\fa\u0001\u0003\u0007\nA\u0001]8pY\u0006I1M]3bi\u0016dun\u001a\u000b\t\u0003\u0013\u0012yBa\t\u0003.!9!\u0011\u0005\u0019A\u0002\u0005\u0015\u0016aC:fO6,g\u000e^*ju\u0016DqA!\n1\u0001\u0004\u00119#A\u0007dY\u0016\fg.\u001e9Q_2L7-\u001f\t\u0005\u0003g\u0012I#\u0003\u0003\u0003,\u0005u$AB*ue&tw\rC\u0004]aA\u0005\t\u0019\u00010\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tM\"f\u00010\u00036-\u0012!q\u0007\t\u0005\u0005s\u0011\u0019%\u0004\u0002\u0003<)!!Q\bB \u0003%)hn\u00195fG.,GMC\u0002\u0003B\u0005\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ea\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000ede\u0016\fG/\u001a'poJ+G/\u001a8uS>tGj\\4D_:4\u0017n\u001a\u000b\u0006k\n-#Q\n\u0005\b\u0005C\u0011\u0004\u0019AAS\u0011\u001d\u0011)C\ra\u0001\u0005O\tAb\u001e:ji\u0016\u0014VmY8sIN$\"\"a!\u0003T\tU#\u0011\fB/\u0011\u0019Q4\u00071\u0001\u0002J!9!qK\u001aA\u0002\u0005\u0015\u0016A\u00038v[\n\u000bGo\u00195fg\"9!1L\u001aA\u0002\u0005\u0015\u0016a\u0004:fG>\u0014Hm\u001d)fe\n\u000bGo\u00195\t\u000f\t}3\u00071\u0001\u0002&\u0006\t\"-\u0019;dQ\u0016\u001c\b+\u001a:TK\u001elWM\u001c;\u0002\u001b\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3t)\u0019\t\u0019I!\u001a\u0003h!1!\b\u000ea\u0001\u0003\u0013BqA!\u001b5\u0001\u0004\t)+\u0001\u0006ok6\u0014VmY8sIN\fq!\\1lK2{w\r\u0006\u0004\u0002J\t=$1\u000f\u0005\t\u0005c*\u0004\u0013!a\u0001#\u0006\u0019A-\u001b:\t\r\tUT\u00071\u0001v\u0003\u0019\u0019wN\u001c4jO\u0006\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tm$fA)\u00036\u00059!/Z2pe\u0012\u001cH\u0003\u0003BA\u0005\u001b\u0013\tJ!&\u0011\t\t\r%\u0011R\u0007\u0003\u0005\u000bS1Aa\"a\u0003\u0019\u0011XmY8sI&!!1\u0012BC\u00055iU-\\8ssJ+7m\u001c:eg\"9!qR\u001cA\u0002\u0005\u0015\u0016aA6fs\"9!1S\u001cA\u0002\u0005\u0015\u0016!\u0002<bYV,\u0007b\u0002BLo\u0001\u0007\u00111C\u0001\ni&lWm\u001d;b[B\u0004")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir;
    private final File logDir;
    private final TopicPartition topicPartition;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    private Pool<TopicPartition, Log> setupIncreasinglyFilthyLogs(Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        public class Kafka_log_LogCleanerManagerTest$LogMock$1
        extends Log {
            public Iterable<Object> getFirstBatchTimestampForSegments(Iterable<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }

            public Kafka_log_LogCleanerManagerTest$LogMock$1(LogCleanerManagerTest $outer, File dir, LogConfig config, TopicPartition tp$1, File tpDir$1) {
                super(dir, config, 0L, 0L, (Scheduler)$outer.time().scheduler(), new BrokerTopicStats(), (Time)$outer.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), $outer.topicPartition(), new ProducerStateManager(tp$1, tpDir$1, 3600000), new LogDirFailureChannel(10));
            }
        }
        Kafka_log_LogCleanerManagerTest$LogMock$1 log = new Kafka_log_LogCleanerManagerTest$LogMock$1(this, tpDir, this.createLowRetentionLogConfig(logSegmentSize, LogConfig$.MODULE$.Compact()), tp, tpDir);
        this.writeRecords(log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, Log>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get(), ClassTag$.MODULE$.apply(LogCleaningException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        Assert.assertEquals((Object)((Object)log), (Object)thrownException.log());
        Assert.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.markPartitionUncleanable(((Log)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assert.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        Seq partitions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1, tp2}));
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable & scala.Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((Log)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, Log> logs = this.setupIncreasinglyFilthyLogs((Seq<TopicPartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 20, 5);
        ((Log)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Log log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assert.assertEquals((long)1L, (long)log.logSegments().size());
        log.maybeIncrementLogStartOffset(2L);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, Log>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)2L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        Log log = this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assert.assertEquals((long)1L, (long)log.logSegments().size());
        Assert.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, Log>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((long)3L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog.size());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 0 logs ready to be compacted", (long)0L, (long)Option$.MODULE$.option2Iterable(cleanable).size());
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable & scala.Serializable)x$1 -> (TopicPartition)x$1._1(), Iterable$.MODULE$.canBuildFrom()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 1 logs ready to be compacted", (long)1L, (long)Option$.MODULE$.option2Iterable(cleanable2).size());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)deletableLog2.size());
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{((LogToClean)cleanable2.get()).topicPartition()})));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog3.size());
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{log.topicPartition()})));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$2 -> (TopicPartition)x$2._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$3 -> (TopicPartition)x$3._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        this.time().sleep(compactionLag + 1);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(3L);
        this.time().sleep(compactionLag + 1);
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._2$mcJ$sp());
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, false, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)3L, (long)cleanableOffsets._2$mcJ$sp());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)4L, (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 562));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    private LogCleanerManager createCleanerManager(Log log) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)this.topicPartition(), (Object)log);
        return new LogCleanerManager((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), logs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, Log> pool) {
        return new LogCleanerManagerMock((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), pool, null);
    }

    private Log createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition) {
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy);
        File partitionDir = new File(this.logDir(), Log$.MODULE$.logDirName(topicPartition));
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(partitionDir, config, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    private void writeRecords(Log log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numBatches);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                LogCleanerManagerTest.$anonfun$writeRecords$1(this, log, recordsPerBatch, batchesPerSegment, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        log.roll(log.roll$default$1());
    }

    private void appendRecords(Log log, int numRecords) {
        long startOffset = log.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq records = (IndexedSeq)new RichLong(startOffset).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1 & Serializable & scala.Serializable)offset -> LogCleanerManagerTest.$anonfun$appendRecords$1(this, endOffset, lastTimestamp, BoxesRunTime.unboxToLong((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.maybeIncrementHighWatermark(log.logEndOffsetMetadata());
    }

    private Log makeLog(File dir, LogConfig config) {
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(dir, config, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, Pool logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        Log log = $this.createLog(2048, LogConfig$.MODULE$.Compact(), tp);
        logs$1.put((Object)tp, (Object)log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, Log log$2, int recordsPerBatch$1, int batchesPerSegment$1, int i) {
        $this.appendRecords(log$2, recordsPerBatch$1);
        if (i % batchesPerSegment$1 == 0) {
            return log$2.roll(log$2.roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendRecords$1(LogCleanerManagerTest $this, long endOffset$1, LongRef lastTimestamp$1, long offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1L) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public LogCleanerManagerTest() {
        Logging.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.topicPartition = new TopicPartition("log", 0);
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1$adapted(LogCleanerManagerTest $this, Log log$2, int recordsPerBatch$1, int batchesPerSegment$1, Object i) {
        return LogCleanerManagerTest.$anonfun$writeRecords$1($this, log$2, recordsPerBatch$1, batchesPerSegment$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap(Predef$.MODULE$.$conforms());
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

