/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.common.RecordValidationException;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple5;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rme\u0001B,Y\u0001uCQ\u0001\u001a\u0001\u0005\u0002\u0015Dq\u0001\u001b\u0001C\u0002\u0013\u0005\u0011\u000e\u0003\u0004x\u0001\u0001\u0006IA\u001b\u0005\bq\u0002\u0011\r\u0011\"\u0001z\u0011\u0019q\b\u0001)A\u0005u\"Aq\u0010\u0001b\u0001\n\u0003\t\t\u0001\u0003\u0005\u0002\u0010\u0001\u0001\u000b\u0011BA\u0002\u0011%\t\t\u0002\u0001b\u0001\n\u0003\t\u0019\u0002\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u000b\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!a\u0016\u0001\t\u0003\t\t\u0005C\u0004\u0002\\\u0001!\t!!\u0011\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b!9\u0011\u0011\u0011\u0001\u0005\n\u0005\r\u0005bBAF\u0001\u0011%\u0011Q\u0012\u0005\b\u00037\u0003A\u0011BAO\u0011\u001d\ty\u000b\u0001C\u0001\u0003\u0003Bq!a-\u0001\t\u0013\t)\fC\u0004\u0002:\u0002!\t!!\u0011\t\u000f\u0005m\u0006\u0001\"\u0001\u0002B!9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBAd\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u0017\u0004A\u0011AA!\u0011\u001d\ty\r\u0001C\u0005\u0003#Dq!!6\u0001\t\u0003\t\t\u0005C\u0004\u0002Z\u0002!I!a7\t\u000f\u0005-\b\u0001\"\u0003\u0002n\"9\u00111\u001f\u0001\u0005\u0002\u0005\u0005\u0003bBA|\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003w\u0004A\u0011BA\u007f\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0003\u0003BqA!\u0002\u0001\t\u0003\t\t\u0005C\u0004\u0003\n\u0001!IAa\u0003\t\u000f\t=\u0001\u0001\"\u0001\u0002B!9!1\u0003\u0001\u0005\u0002\u0005\u0005\u0003b\u0002B\f\u0001\u0011%!\u0011\u0004\u0005\b\u0005?\u0001A\u0011AA!\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0003\u0003BqAa\n\u0001\t\u0003\t\t\u0005C\u0004\u0003,\u0001!IA!\f\t\u000f\tE\u0002\u0001\"\u0001\u0002B!9!Q\u0007\u0001\u0005\u0002\u0005\u0005\u0003b\u0002B$\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0005\u0017\u0002A\u0011AA!\u0011\u001d\u0011y\u0005\u0001C\u0001\u0003\u0003BqAa\u0015\u0001\t\u0003\t\t\u0005C\u0004\u0003X\u0001!\t!!\u0011\t\u000f\tm\u0003\u0001\"\u0001\u0002B!9!q\f\u0001\u0005\u0002\u0005\u0005\u0003b\u0002B2\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0005O\u0002A\u0011AA!\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0003\u0003BqAa\u001c\u0001\t\u0003\t\t\u0005C\u0004\u0003t\u0001!\t!!\u0011\t\u000f\t]\u0004\u0001\"\u0001\u0002B!9!1\u0010\u0001\u0005\u0002\u0005\u0005\u0003b\u0002BD\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0005\u0017\u0003A\u0011AA!\u0011\u001d\u0011y\t\u0001C\u0001\u0003\u0003BqAa%\u0001\t\u0003\t\t\u0005C\u0004\u0003\u0018\u0002!\t!!\u0011\t\u000f\tm\u0005\u0001\"\u0001\u0002B!9!q\u0014\u0001\u0005\u0002\u0005\u0005\u0003b\u0002BR\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0005k\u0003A\u0011AA!\u0011\u001d\u0011I\f\u0001C\u0001\u0003\u0003BqA!0\u0001\t\u0003\t\t\u0005C\u0004\u0003B\u0002!\t!!\u0011\t\u000f\t\u0015\u0007\u0001\"\u0001\u0002B!9!\u0011\u001a\u0001\u0005\u0002\u0005\u0005\u0003b\u0002Bk\u0001\u0011\u0005\u0011\u0011\t\u0005\b\u00053\u0004A\u0011AA!\u0011\u001d\u0011i\u000e\u0001C\u0001\u0003\u0003BqA!9\u0001\t\u0003\t\t\u0005C\u0004\u0003f\u0002!IAa:\t\u000f\tu\b\u0001\"\u0003\u0003\u0000\"I11\u0003\u0001\u0012\u0002\u0013%1Q\u0003\u0005\b\u0007W\u0001A\u0011BB\u0017\u0011%\u0019)\u0004AI\u0001\n\u0013\u0019)\u0002C\u0005\u00048\u0001\t\n\u0011\"\u0003\u0004:!91Q\b\u0001\u0005\n\r}\u0002bBB$\u0001\u0011\u00051\u0011\n\u0005\b\u0007#\u0002A\u0011BB*\u0011\u001d\u0019y\u0006\u0001C\u0001\u0007CBqaa\u001c\u0001\t\u0003\u0019\t\bC\u0004\u0004~\u0001!\taa \u0003!1{wMV1mS\u0012\fGo\u001c:UKN$(BA-[\u0003\rawn\u001a\u0006\u00027\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001_!\ty&-D\u0001a\u0015\u0005\t\u0017!B:dC2\f\u0017BA2a\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u001a\t\u0003O\u0002i\u0011\u0001W\u0001\u0005i&lW-F\u0001k!\tYW/D\u0001m\u0015\tig.A\u0003vi&d7O\u0003\u0002pa\u000611m\\7n_:T!aW9\u000b\u0005I\u001c\u0018AB1qC\u000eDWMC\u0001u\u0003\ry'oZ\u0005\u0003m2\u0014A\u0001V5nK\u0006)A/[7fA\u0005qAo\u001c9jGB\u000b'\u000f^5uS>tW#\u0001>\u0011\u0005mdX\"\u00018\n\u0005ut'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013Q\u0016AB:feZ,'/\u0003\u0003\u0002\u000e\u0005\u001d!\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0003E\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000fI\u0001\u000e[\u0016$(/[2t\u0017\u0016L8+\u001a;\u0016\u0005\u0005U\u0001CBA\f\u0003C\t)#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003\u001diW\u000f^1cY\u0016T1!a\ba\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\tIBA\u0002TKR\u0004B!a\n\u0002:5\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0003d_J,'\u0002BA\u0018\u0003c\tq!\\3ue&\u001c7O\u0003\u0003\u00024\u0005U\u0012AB=b[6,'O\u0003\u0002\u00028\u0005\u00191m\\7\n\t\u0005m\u0012\u0011\u0006\u0002\u000b\u001b\u0016$(/[2OC6,\u0017AD7fiJL7m]&fsN+G\u000fI\u0001\u0011i\u0016\u001cHo\u00148ms>sWMQ1uG\"$\"!a\u0011\u0011\u0007}\u000b)%C\u0002\u0002H\u0001\u0014A!\u00168ji\"\u001a!\"a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015t\u0003\u0015QWO\\5u\u0013\u0011\t)&a\u0014\u0003\tQ+7\u000f^\u0001\u0014i\u0016\u001cH/\u00117m_^lU\u000f\u001c;j\u0005\u0006$8\r\u001b\u0015\u0004\u0017\u0005-\u0013!\u0005;fgRl\u0015n]'bi\u000eDW*Y4jG\"\u001aA\"a\u0013\u0002#\rDWmY6P]2LxJ\\3CCR\u001c\u0007\u000e\u0006\u0005\u0002D\u0005\r\u0014QNA?\u0011\u001d\t)'\u0004a\u0001\u0003O\nQ!\\1hS\u000e\u00042aXA5\u0013\r\tY\u0007\u0019\u0002\u0005\u0005f$X\rC\u0004\u0002p5\u0001\r!!\u001d\u0002+M|WO]2f\u0007>l\u0007O]3tg&|g\u000eV=qKB!\u00111OA=\u001b\t\t)HC\u0002\u0002x9\faA]3d_J$\u0017\u0002BA>\u0003k\u0012qbQ8naJ,7o]5p]RK\b/\u001a\u0005\b\u0003\u007fj\u0001\u0019AA9\u0003U!\u0018M]4fi\u000e{W\u000e\u001d:fgNLwN\u001c+za\u0016\fAc\u00195fG.\fE\u000e\\8x\u001bVdG/\u001b\"bi\u000eDG\u0003CA\"\u0003\u000b\u000b9)!#\t\u000f\u0005\u0015d\u00021\u0001\u0002h!9\u0011q\u000e\bA\u0002\u0005E\u0004bBA@\u001d\u0001\u0007\u0011\u0011O\u0001\u0013G\",7m['jg6\fGo\u00195NC\u001eL7\r\u0006\u0005\u0002D\u0005=\u00151SAL\u0011\u001d\t\tj\u0004a\u0001\u0003O\n!BY1uG\"l\u0015mZ5d\u0011\u001d\t)j\u0004a\u0001\u0003O\n1B]3d_J$W*Y4jG\"9\u0011\u0011T\bA\u0002\u0005E\u0014aD2p[B\u0014Xm]:j_:$\u0016\u0010]3\u0002!Y\fG.\u001b3bi\u0016lUm]:bO\u0016\u001cHCCA\"\u0003?\u000bI+a+\u0002.\"9\u0011\u0011\u0015\tA\u0002\u0005\r\u0016a\u0002:fG>\u0014Hm\u001d\t\u0005\u0003g\n)+\u0003\u0003\u0002(\u0006U$!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0002fA\u0001\r!a\u001a\t\u000f\u0005=\u0004\u00031\u0001\u0002r!9\u0011q\u0010\tA\u0002\u0005E\u0014\u0001\t;fgRdunZ!qa\u0016tG\rV5nK:{gnQ8naJ,7o]3e-FB3!EA&\u0003}\u0019\u0007.Z2l\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3O_:\u001cu.\u001c9sKN\u001cX\r\u001a\u000b\u0005\u0003\u0007\n9\fC\u0004\u0002fI\u0001\r!a\u001a\u0002AQ,7\u000f\u001e'pO\u0006\u0003\b/\u001a8e)&lWMT8o\u0007>l\u0007O]3tg\u0016$gKM\u0001%i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Wc!\u001aA#a\u0013\u0002G\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"\u0014VmY8naJ,7o]5p]R!\u00111IAb\u0011\u001d\t)-\u0006a\u0001\u0003O\n1\u0002^1sO\u0016$X*Y4jG\u0006!C/Z:u\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3XSRD'+Z2p[B\u0014Xm]:j_:4&\u0007K\u0002\u0017\u0003\u0017\nq\u0005^3ti2{w-\u00119qK:$G+[7f/&$\bn\\;u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Wc!\u001aq#a\u0013\u0002M\rDWmY6M_\u001e\f\u0005\u000f]3oIRKW.Z,ji\"|W\u000f\u001e*fG>l\u0007O]3tg&|g\u000e\u0006\u0003\u0002D\u0005M\u0007bBA31\u0001\u0007\u0011qM\u0001%i\u0016\u001cH/\u00138wC2LGm\u00144gg\u0016$(+\u00198hK\u0006sGMU3d_J$7i\\;oi\"\u001a\u0011$a\u0013\u0002A\u0005\u001c8/\u001a:u\u0013:4\u0018\r\\5e\u0005\u0006$8\r[\"pk:$xJ^3se&$Wm\u001d\u000b\u0007\u0003\u0007\ni.a:\t\u000f\u0005}'\u00041\u0001\u0002b\u0006yA.Y:u\u001f\u001a47/\u001a;EK2$\u0018\rE\u0002`\u0003GL1!!:a\u0005\rIe\u000e\u001e\u0005\b\u0003ST\u0002\u0019AAq\u0003\u0015\u0019w.\u001e8u\u0003\u00152\u0018\r\\5eCR,'+Z2pe\u0012\u0014\u0015\r^2i/&$\bnQ8v]R|e/\u001a:sS\u0012,7\u000f\u0006\u0004\u0002D\u0005=\u0018\u0011\u001f\u0005\b\u0003?\\\u0002\u0019AAq\u0011\u001d\tIo\u0007a\u0001\u0003C\fq\u0005^3ti2{w-\u00119qK:$G+[7f/&$\bn\\;u%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8We!\u001aA$a\u0013\u0002'Q,7\u000f\u001e(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007u\tY%\u0001\ndQ\u0016\u001c7NT8o\u0007>l\u0007O]3tg\u0016$G\u0003BA\"\u0003\u007fDq!!\u001a\u001f\u0001\u0004\t9'A\nuKN$hj\u001c8D_6\u0004(/Z:tK\u00124&\u0007K\u0002 \u0003\u0017\n1\u0003^3tiJ+7m\\7qe\u0016\u001c8/[8o-FB3\u0001IA&\u0003I\u0019\u0007.Z2l%\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8\u0015\t\u0005\r#Q\u0002\u0005\b\u0003K\n\u0003\u0019AA4\u0003M!Xm\u001d;SK\u000e|W\u000e\u001d:fgNLwN\u001c,3Q\r\u0011\u00131J\u0001!i\u0016\u001cHo\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c,1)>4\u0016\u0007K\u0002$\u0003\u0017\n\u0011e\u00195fG.\u001c%/Z1uKRKW.Z+q\u0007>tg/\u001a:tS>tgI]8n-B\"B!a\u0011\u0003\u001c!9!Q\u0004\u0013A\u0002\u0005\u001d\u0014a\u0002;p\u001b\u0006<\u0017nY\u0001!i\u0016\u001cHo\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c,1)>4&\u0007K\u0002&\u0003\u0017\n\u0001\u0005^3ti\u000e\u0013X-\u0019;f)&lW-\u00169D_:4XM]:j_:4\u0016\u0007V8We!\u001aa%a\u0013\u0002!Q,7\u000f^\"p[B\u0014Xm]:fIZ\u000b\u0004fA\u0014\u0002L\u0005y1\r[3dW\u000e{W\u000e\u001d:fgN,G\r\u0006\u0003\u0002D\t=\u0002bBA3Q\u0001\u0007\u0011qM\u0001\u0011i\u0016\u001cHoQ8naJ,7o]3e-JB3!KA&\u0003\u0011\"Xm\u001d;J]Z\fG.\u001b3De\u0016\fG/\u001a+j[\u0016tuN\\\"p[B\u0014Xm]:fIZ\u000b\u0004f\u0002\u0016\u0002L\te\"1H\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012!Q\b\t\u0005\u0005\u007f\u0011\u0019%\u0004\u0002\u0003B)\u0011qNW\u0005\u0005\u0005\u000b\u0012\tEA\rSK\u000e|'\u000f\u001a,bY&$\u0017\r^5p]\u0016C8-\u001a9uS>t\u0017\u0001\n;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,GM\u0016\u001a)\u000f-\nYE!\u000f\u0003<\u0005\tC/Z:u\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,7i\\7qe\u0016\u001c8/\u001a3Wc!:A&a\u0013\u0003:\tm\u0012!\t;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.Z\"p[B\u0014Xm]:fIZ\u0013\u0004fB\u0017\u0002L\te\"1H\u0001*i\u0016\u001cH/\u00112t_2,H/Z(gMN,G/Q:tS\u001etW.\u001a8u\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u00079\nY%\u0001\u0014uKN$\u0018IY:pYV$Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;D_6\u0004(/Z:tK\u0012D3aLA&\u0003-\"Xm\u001d;SK2\fG/\u001b<f\u001f\u001a47/\u001a;BgNLwM\\7f]RtuN\\\"p[B\u0014Xm]:fIZ\u000b\u0004f\u0001\u0019\u0002L\u0005YC/Z:u%\u0016d\u0017\r^5wK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$hj\u001c8D_6\u0004(/Z:tK\u00124&\u0007K\u00022\u0003\u0017\n\u0001\u0006^3tiJ+G.\u0019;jm\u0016|eMZ:fi\u0006\u001b8/[4o[\u0016tGoQ8naJ,7o]3e-FB3AMA&\u0003!\"Xm\u001d;SK2\fG/\u001b<f\u001f\u001a47/\u001a;BgNLwM\\7f]R\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\r\u0019\u00141J\u00019i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8Wc9{gnQ8naJ,7o]3eQ\r!\u00141J\u00019i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8We9{gnQ8naJ,7o]3eQ\r)\u00141J\u00016i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8Wc\r{W\u000e\u001d:fgN,G\rK\u00027\u0003\u0017\nQ\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;feV\u00038i\u001c8wKJ\u001c\u0018n\u001c8WaQ{gKM\"p[B\u0014Xm]:fI\"\u001aq'a\u0013\u0002OQ,7\u000f^\"p]R\u0014x\u000e\u001c*fG>\u0014Hm\u001d(pi\u0006cGn\\<fI\u001a\u0013x.\\\"mS\u0016tGo\u001d\u0015\bq\u0005-#\u0011\bB@G\t\u0011\t\tE\u0002|\u0005\u0007K1A!\"o\u0005YIeN^1mS\u0012\u0014VmY8sI\u0016C8-\u001a9uS>t\u0017a\b;fgR\u001cuN\u001c;s_2\u0014VmY8sINtu\u000e^\"p[B\u0014Xm]:fI\"\u001a\u0011(a\u0013\u0002uQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,2)>4\u0006GT8o\u0007>l\u0007O]3tg\u0016$\u0007f\u0001\u001e\u0002L\u00059D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-F\"vN\u0016\u0019D_6\u0004(/Z:tK\u0012D3aOA&\u0003a\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gNV\u0019U_Z\u0013dj\u001c8D_6\u0004(/Z:tK\u0012D3\u0001PA&\u0003U\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:Va\u000e{gN^3sg&|gNV\u0019U_Z\u00134i\\7qe\u0016\u001c8/\u001a3)\u0007u\nY%\u0001\u001euKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014Hi\\<o\u0007>tg/\u001a:tS>tgK\r+p-FruN\\\"p[B\u0014Xm]:fI\"\u001aa(a\u0013\u0002oQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,3)>4\u0016gQ8naJ,7o]3eQ\ry\u00141J\u00015i\u0016\u001cH\u000fR8x]\u000e{gN^3sg&|gn\u00144Ue\u0006t7/Y2uS>t\u0017\r\u001c*fG>\u0014Hm\u001d(piB+'/\\5ui\u0016$\u0007f\u0002!\u0002L\te\"qU\u0012\u0003\u0005S\u0003BAa+\u000326\u0011!Q\u0016\u0006\u0004\u0005_s\u0017AB3se>\u00148/\u0003\u0003\u00034\n5&\u0001J+ogV\u0004\bo\u001c:uK\u00124uN]'fgN\fw-\u001a$pe6\fG/\u0012=dKB$\u0018n\u001c8\u0002cQ,7\u000f\u001e#po:\u001cuN\u001c<feNLwN\\(g\u0013\u0012,W\u000e]8uK:$(+Z2pe\u0012\u001chj\u001c;QKJl\u0017\u000e\u001e;fI\":\u0011)a\u0013\u0003:\t\u001d\u0016A\u000f;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ$un\u001e8D_:4XM]:j_:4&\u0007V8Wa9{gnQ8naJ,7o]3eQ\r\u0011\u00151J\u00018i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'\u000fR8x]\u000e{gN^3sg&|gN\u0016\u001aU_Z\u00034i\\7qe\u0016\u001c8/\u001a3)\u0007\r\u000bY%\u0001\u001auKN$hj\u001c8J]\u000e\u0014X-Y:j]\u001e|eMZ:fiJ+7m\u001c:e\u0005\u0006$8\r\u001b%bg6+GO]5dg2{wmZ3eQ\r!\u00151J\u0001,i\u0016\u001cHoQ8naJ,7o]3e\u0005\u0006$8\r[,ji\"|W\u000f\u001e*fG>\u0014Hm\u001d(pi\u0006cGn\\<fI\":Q)a\u0013\u0003:\t}\u0014a\u000b;fgRT6\u000b\u001e3D_6\u0004(/Z:tK\u0012<\u0016\u000e\u001e5V]\u00064\u0018-\u001b7bE2,\u0017J\u0011)WKJ\u001c\u0018n\u001c8)\u000f\u0019\u000bYE!\u000f\u0003N\u000e\u0012!q\u001a\t\u0005\u0005W\u0013\t.\u0003\u0003\u0003T\n5&aI+ogV\u0004\bo\u001c:uK\u0012\u001cu.\u001c9sKN\u001c\u0018n\u001c8UsB,W\t_2faRLwN\\\u0001.i\u0016\u001cH/\u00168d_6\u0004(/Z:tK\u0012\u0014\u0015\r^2i/&$\bn\\;u%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$\u0007fB$\u0002L\te\"qP\u0001.i\u0016\u001cHOU3d_6\u0004(/Z:tK\u0012\u0014\u0015\r^2i/&$\bn\\;u%\u0016\u001cwN\u001d3t\u001d>$\u0018\t\u001c7po\u0016$\u0007f\u0002%\u0002L\te\"qP\u0001+i\u0016\u001cH/\u00138wC2LG\rV5nKN$\u0018-\u001c9Fq\u000e,\u0007\u000f^5p]\"\u000b7OQ1uG\"Le\u000eZ3yQ\rI\u00151J\u0001(i\u0016\u001cH/\u00138wC2LGMU3d_J$W\t_2faRLwN\u001c%bg\n\u000bGo\u00195J]\u0012,\u0007\u0010K\u0002K\u0003\u0017\n\u0011\u0005^3ti\n\u000bGo\u00195XSRDw.\u001e;SK\u000e|'\u000fZ:O_R\fE\u000e\\8xK\u0012$b!a\u0011\u0003j\ne\bb\u0002Bv\u0017\u0002\u0007!Q^\u0001\fg>,(oY3D_\u0012,7\r\u0005\u0003\u0003p\nUXB\u0001By\u0015\r\u0011\u0019PW\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u00119P!=\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007b\u0002B~\u0017\u0002\u0007!Q^\u0001\fi\u0006\u0014x-\u001a;D_\u0012,7-A\u0007de\u0016\fG/\u001a*fG>\u0014Hm\u001d\u000b\t\u0003G\u001b\ta!\u0002\u0004\u0010!911\u0001'A\u0002\u0005\u001d\u0014AC7bO&\u001cg+\u00197vK\"I1q\u0001'\u0011\u0002\u0003\u00071\u0011B\u0001\ni&lWm\u001d;b[B\u00042aXB\u0006\u0013\r\u0019i\u0001\u0019\u0002\u0005\u0019>tw\rC\u0004\u0004\u00121\u0003\r!!\u001d\u0002\u000b\r|G-Z2\u0002/\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u0012TCAB\fU\u0011\u0019Ia!\u0007,\u0005\rm\u0001\u0003BB\u000f\u0007Oi!aa\b\u000b\t\r\u000521E\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\na\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007S\u0019yBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001e\u0019:fCR,gj\u001c8J]\u000e\u0014X-Y:j]\u001e|eMZ:fiJ+7m\u001c:egRA\u00111UB\u0018\u0007c\u0019\u0019\u0004C\u0004\u0004\u00049\u0003\r!a\u001a\t\u0013\r\u001da\n%AA\u0002\r%\u0001\"CB\t\u001dB\u0005\t\u0019AA9\u0003)\u001a'/Z1uK:{g.\u00138de\u0016\f7/\u001b8h\u001f\u001a47/\u001a;SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uII\n!f\u0019:fCR,gj\u001c8J]\u000e\u0014X-Y:j]\u001e|eMZ:fiJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0004<)\"\u0011\u0011OB\r\u0003]\u0019'/Z1uKR;xNQ1uG\",GMU3d_J$7\u000f\u0006\u0005\u0002$\u000e\u000531IB#\u0011\u001d\u0019\u0019!\u0015a\u0001\u0003OBqaa\u0002R\u0001\u0004\u0019I\u0001C\u0004\u0004\u0012E\u0003\r!!\u001d\u0002\u0019\rDWmY6PM\u001a\u001cX\r^:\u0015\r\u0005\r31JB'\u0011\u001d\t\tK\u0015a\u0001\u0003GCqaa\u0014S\u0001\u0004\u0019I!\u0001\u0006cCN,wJ\u001a4tKR\fAD]3d_J$7oV5uQ&sg/\u00197jI&sg.\u001a:NC\u001eL7\r\u0006\u0005\u0002$\u000eU3\u0011LB/\u0011\u001d\u00199f\u0015a\u0001\u0003O\nqBY1uG\"l\u0015mZ5d-\u0006dW/\u001a\u0005\b\u00077\u001a\u0006\u0019AA4\u0003A\u0011XmY8sI6\u000bw-[2WC2,X\rC\u0004\u0004\u0012M\u0003\r!!\u001d\u0002/5\f\u0017PY3DQ\u0016\u001c7NQ1tKRKW.Z:uC6\u0004HCBA\"\u0007G\u001a)\u0007C\u0004\u0003:Q\u0003\ra!\u0003\t\u000f\r\u001dD\u000b1\u0001\u0004j\u0005)!-\u0019;dQB!\u00111OB6\u0013\u0011\u0019i'!\u001e\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r[\u0001\u0016m\u0006d\u0017\u000eZ1uK2{w-\u00119qK:$G+[7f)!\t\u0019ea\u001d\u0004x\rm\u0004bBB;+\u0002\u00071\u0011B\u0001\u0016Kb\u0004Xm\u0019;fI2{w-\u00119qK:$G+[7f\u0011\u001d\u0019I(\u0016a\u0001\u0007\u0013\tQ#\u001a=qK\u000e$X\r\u001a\"bg\u0016$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0004hU\u0003\ra!\u001b\u00027Y,'/\u001b4z%\u0016\u001cwN\u001d3D_:4XM]:j_:\u001cF/\u0019;t))\t\u0019e!!\u0004\f\u000e=5\u0011\u0013\u0005\b\u0007\u00073\u0006\u0019ABC\u0003\u0015\u0019H/\u0019;t!\u0011\t\u0019ha\"\n\t\r%\u0015Q\u000f\u0002\u0016%\u0016\u001cwN\u001d3D_:4XM]:j_:\u001cF/\u0019;t\u0011\u001d\u0019iI\u0016a\u0001\u0003C\f1C\\;n\u0007>tg/\u001a:uK\u0012\u0014VmY8sINDq!!)W\u0001\u0004\t\u0019\u000bC\u0004\u0004\u0014Z\u0003\ra!&\u0002\u0015\r|W\u000e\u001d:fgN,G\rE\u0002`\u0007/K1a!'a\u0005\u001d\u0011un\u001c7fC:\u0004")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Set<MetricName> metricsKeySet = (Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Time time() {
        return this.time;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    @Test
    public void testOnlyOneBatch() {
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testAllowMultiBatch() {
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.GZIP);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testMisMatchMagic() {
        this.checkMismatchMagic((byte)0, (byte)1, CompressionType.GZIP);
        this.checkMismatchMagic((byte)1, (byte)0, CompressionType.GZIP);
    }

    private void checkOnlyOneBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }

    private void checkAllowMultiBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType);
    }

    private void checkMismatchMagic(byte batchMagic, byte recordMagic, CompressionType compressionType) {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.validateMessages(this.recordsWithInvalidInnerMagic(batchMagic, recordMagic, compressionType), batchMagic, compressionType, compressionType), ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        Assert.assertEquals((long)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$checkMismatchMagic$2(x$1))), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    private void validateMessages(MemoryRecords records, byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), 0L, CompressionCodec$.MODULE$.getCompressionCodec(sourceCompressionType.name), CompressionCodec$.MODULE$.getCompressionCodec(targetCompressionType.name), false, magic, TimestampType.CREATE_TIME, 1000L, -1, true, (ApiVersion)KAFKA_2_3_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.NONE);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            this.validateLogAppendTime(now, 1234L, (RecordBatch)batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)"The offset of max timestamp should be 0", (long)0L, (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, false);
    }

    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        long now = System.currentTimeMillis();
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            this.validateLogAppendTime(now, -1L, (RecordBatch)batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size may have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        RecordConversionStats stats = validatedResults.recordConversionStats();
        this.verifyRecordConversionStats(stats, 3, records, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            this.validateLogAppendTime(now, 1234L, (RecordBatch)batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.validateRecordBatchWithCountOverrides(lastOffsetDelta, count), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
    }

    private void validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records.buffer().putInt(57, count);
        records.buffer().putInt(23, lastOffsetDelta);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), this.time().milliseconds(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkNonCompressed(byte magic) {
        void var10_8;
        void var11_9;
        void var9_7;
        void var8_6;
        void var6_5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var6_5, (short)var8_6, (int)var9_7, (int)var11_9, (boolean)var10_8, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, (int)var11_9, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkNonCompressed$1$adapted(this, timestampSeq, (short)var8_6, (long)var6_5, (int)var9_7, (boolean)var10_8, (int)var11_9, i, arg_0));
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)"Offset of max timestamp should be 1", (long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 0, records, false);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkRecompression(byte magic) {
        void var10_8;
        void var11_9;
        void var9_7;
        void var8_6;
        void var6_5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var6_5, (short)var8_6, (int)var9_7, (int)var11_9, (boolean)var10_8, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)GZIPCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, (int)var11_9, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkRecompression$1$adapted(this, timestampSeq, (short)var8_6, (long)var6_5, (int)var9_7, (int)var11_9, i, arg_0));
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)"Offset of max timestamp should be 2", (long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef(0L);
        Time x$7 = this.time();
        long x$8 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$10 = DefaultCompressionCodec$.MODULE$;
        boolean x$12 = false;
        TimestampType x$13 = TimestampType.CREATE_TIME;
        long x$14 = 1000L;
        int x$15 = -1;
        boolean x$16 = true;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, x$8, (CompressionCodec)x$9, (CompressionCodec)x$10, x$12, toMagic, x$13, x$14, x$15, x$16, x$17, x$18);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$checkCreateTimeUpConversionFromV0$1(this, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(-1L).toString(), (long)-1L, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        long timestamp = System.currentTimeMillis();
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.GZIP;
        MemoryRecords records = this.createRecords(x$1, timestamp, x$2);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef(0L);
        Time x$7 = this.time();
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$10 = DefaultCompressionCodec$.MODULE$;
        byte x$11 = 2;
        boolean x$12 = false;
        TimestampType x$13 = TimestampType.CREATE_TIME;
        long x$14 = 1000L;
        int x$15 = -1;
        boolean x$16 = true;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, timestamp, (CompressionCodec)x$9, (CompressionCodec)x$10, x$12, x$11, x$13, x$14, x$15, x$16, x$17, x$18);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            LogValidatorTest.$anonfun$testCreateTimeUpConversionV1ToV2$1(this, timestamp, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)timestamp, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkCompressed(byte magic) {
        void var10_8;
        void var11_9;
        void var9_7;
        void var8_6;
        void var6_5;
        long now = System.currentTimeMillis();
        Seq timestampSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)BoxesRunTime.boxToLong((long)1324L), (Object)BoxesRunTime.boxToShort((short)((short)10)), (Object)BoxesRunTime.boxToInteger((int)984), (Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToInteger((int)40)) : new Tuple5((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToShort((short)-1), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToInteger((int)-1));
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var6_5, (short)var8_6, (int)var9_7, (int)var11_9, (boolean)var10_8, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        boolean x$9 = false;
        TimestampType x$10 = TimestampType.CREATE_TIME;
        long x$11 = 1000L;
        boolean x$13 = true;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, magic, x$10, x$11, (int)var11_9, x$13, x$14, x$15);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        IntRef i = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkCompressed$1$adapted(this, timestampSeq, (short)var8_6, (long)var6_5, (int)var9_7, (int)var11_9, i, arg_0));
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString(), (long)(((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        byte x$8 = 1;
        boolean x$9 = false;
        TimestampType x$10 = TimestampType.CREATE_TIME;
        long x$11 = 1000L;
        int x$12 = -1;
        boolean x$13 = true;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, x$8, x$10, x$11, x$12, x$13, x$14, x$15);
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        byte x$8 = 1;
        boolean x$9 = false;
        TimestampType x$10 = TimestampType.CREATE_TIME;
        long x$11 = 1000L;
        int x$12 = -1;
        boolean x$13 = true;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, x$8, x$10, x$11, x$12, x$13, x$14, x$15);
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef((long)offset);
        Time x$7 = this.time();
        long x$8 = System.currentTimeMillis();
        NoCompressionCodec$ x$9 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$10 = NoCompressionCodec$.MODULE$;
        byte x$11 = 0;
        boolean x$12 = false;
        TimestampType x$13 = TimestampType.CREATE_TIME;
        long x$14 = 1000L;
        int x$15 = -1;
        boolean x$16 = true;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, x$8, (CompressionCodec)x$9, (CompressionCodec)x$10, x$12, x$11, x$13, x$14, x$15, x$16, x$17, x$18).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        byte x$1 = 0;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test(expected=InvalidRecordException.class)
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        List batches = TestUtils.toList((Iterable)LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, false, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords().batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        Assert.assertFalse((boolean)((MutableRecordBatch)batches.get(0)).isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.NONE;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        byte x$1 = 1;
        CompressionType x$2 = CompressionType.GZIP;
        long x$3 = this.createRecords$default$2();
        MemoryRecords records = this.createRecords(x$1, x$3, x$2);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        MemoryRecords records = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())});
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testNonIncreasingOffsetRecordBatchHasMetricsLogged() {
        MemoryRecords records = this.createNonIncreasingOffsetRecords((byte)2, this.createNonIncreasingOffsetRecords$default$2(), this.createNonIncreasingOffsetRecords$default$3());
        ((MutableRecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).head()).setLastOffset(2L);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1195));
        Assert.assertEquals((long)this.metricsKeySet().count((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(x$8))), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    @Test(expected=InvalidRecordException.class)
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test(expected=UnsupportedCompressionTypeException.class)
    public void testZStdCompressedWithUnavailableIBPVersion() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)ZStdCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, true, (ApiVersion)KAFKA_2_0_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test(expected=InvalidRecordException.class)
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$);
    }

    @Test(expected=InvalidRecordException.class)
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test
    public void testInvalidTimestampExceptionHasBatchIndex() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        RecordValidationException e = (RecordValidationException)((Object)Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            TopicPartition x$2 = this.topicPartition();
            kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
            Time x$4 = this.time();
            long x$5 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
            byte x$8 = 1;
            boolean x$9 = false;
            TimestampType x$10 = TimestampType.CREATE_TIME;
            long x$11 = 1000L;
            int x$12 = -1;
            boolean x$13 = true;
            ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
            BrokerTopicStats x$15 = this.brokerTopicStats();
            return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, x$9, x$8, x$10, x$11, x$12, x$13, x$14, x$15);
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1258)));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assert.assertEquals((long)e.recordErrors().size(), (long)1L);
        Assert.assertEquals((long)((ProduceResponse.RecordError)e.recordErrors().head()).batchIndex, (long)0L);
        Assert.assertNull((Object)((ProduceResponse.RecordError)e.recordErrors().head()).message);
    }

    @Test
    public void testInvalidRecordExceptionHasBatchIndex() {
        RecordValidationException e = (RecordValidationException)((Object)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.validateMessages(this.recordsWithInvalidInnerMagic((byte)0, (byte)1, CompressionType.GZIP), (byte)0, CompressionType.GZIP, CompressionType.GZIP), ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1286)));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidRecordException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Assert.assertEquals((long)e.recordErrors().size(), (long)1L);
        Assert.assertEquals((long)((ProduceResponse.RecordError)e.recordErrors().head()).batchIndex, (long)0L);
        Assert.assertNull((Object)((ProduceResponse.RecordError)e.recordErrors().head()).message);
    }

    private void testBatchWithoutRecordsNotAllowed(CompressionCodec sourceCodec, CompressionCodec targetCodec) {
        int offset = 1234567;
        long l = 1324L;
        short s = (short)10;
        int n = 984;
        boolean bl = true;
        int n2 = 40;
        ByteBuffer buffer = ByteBuffer.allocate(61);
        DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)l, (short)s, (int)n, (long)0L, (long)5L, (int)n2, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)bl, (boolean)false);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), sourceCodec, targetCodec, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, true, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    private MemoryRecords createNonIncreasingOffsetRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(3L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createNonIncreasingOffsetRecords$default$2() {
        return -1L;
    }

    private CompressionType createNonIncreasingOffsetRecords$default$3() {
        return CompressionType.NONE;
    }

    private MemoryRecords createTwoBatchedRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, "1".getBytes(), "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "2".getBytes(), "b".getBytes());
        builder.append(12L, "3".getBytes(), "c".getBytes());
        builder.close();
        buf.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buf.slice());
    }

    public void checkOffsets(MemoryRecords records, long baseOffset) {
        Assert.assertTrue((String)"Message set should not be empty", (boolean)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).nonEmpty());
        LongRef offset = LongRef.create((long)baseOffset);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            LogValidatorTest.$anonfun$checkOffsets$1(offset, entry);
            return BoxedUnit.UNIT;
        });
    }

    private MemoryRecords recordsWithInvalidInnerMagic(byte batchMagicValue, byte recordMagicValue, CompressionType codec) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, 20).map((Function1 & Serializable & scala.Serializable)id -> LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$1(recordMagicValue, BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.sizeInBytes()), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536)), (byte)batchMagicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        IntRef offset = IntRef.create((int)1234567);
        records.foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        if (batch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)batch;
            Assert.assertEquals((String)new StringBuilder(35).append("Unexpected base timestamp of batch ").append(batch).toString(), (long)expected, (long)defaultRecordBatch.firstTimestamp());
            return;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assert.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assert.assertEquals((String)new StringBuilder(34).append("Unexpected max timestamp of batch ").append(batch).toString(), (long)expectedLogAppendTime, (long)batch.maxTimestamp());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$validateLogAppendTime$1(expectedLogAppendTime, record);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records, boolean compressed) {
        Assert.assertNotNull((String)"Records processing info is null", (Object)stats);
        Assert.assertEquals((long)numConvertedRecords, (long)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assert.assertTrue((String)new StringBuilder(29).append("Conversion time not recorded ").append(stats).toString(), (stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringBuilder(26).append("Conversion time not valid ").append(stats).toString(), (stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0);
        }
        int originalSize = records.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assert.assertTrue((String)new StringBuilder(35).append("Temp bytes too small, orig=").append(originalSize).append(" actual=").append(tempBytes).toString(), (tempBytes > (long)originalSize ? 1 : 0) != 0);
            return;
        }
        if (numConvertedRecords > 0 || compressed) {
            Assert.assertTrue((String)"Temp bytes not updated", (tempBytes > 0L ? 1 : 0) != 0);
            return;
        }
        Assert.assertEquals((long)0L, (long)tempBytes);
    }

    public static final /* synthetic */ boolean $anonfun$checkMismatchMagic$2(MetricName x$1) {
        return x$1.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$3(Seq timestampSeq$1, IntRef i$1, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(i$1.elem)), (long)record.timestamp());
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$1(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$1, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$1, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$1, (long)batch.baseSequence());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)isTransactional$1), (Object)BoxesRunTime.boxToBoolean((boolean)batch.isTransactional()));
        Assert.assertEquals((long)partitionLeaderEpoch$1, (long)batch.partitionLeaderEpoch());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkNonCompressed$3(timestampSeq$1, i$1, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$3(Seq timestampSeq$2, IntRef i$2, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(i$2.elem)), (long)record.timestamp());
        ++i$2.elem;
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$1(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$2, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$2, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$2, (long)batch.baseSequence());
        Assert.assertEquals((long)partitionLeaderEpoch$2, (long)batch.partitionLeaderEpoch());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkRecompression$3(timestampSeq$2, i$2, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkCreateTimeUpConversionFromV0$1(LogValidatorTest $this, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
        Assert.assertEquals((long)-1L, (long)batch.maxTimestamp());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
        Assert.assertEquals((long)-1L, (long)batch.producerId());
        Assert.assertEquals((long)-1L, (long)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$testCreateTimeUpConversionV1ToV2$1(LogValidatorTest $this, long timestamp$1, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(timestamp$1, (RecordBatch)batch);
        Assert.assertEquals((long)timestamp$1, (long)batch.maxTimestamp());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
        Assert.assertEquals((long)-1L, (long)batch.producerId());
        Assert.assertEquals((long)-1L, (long)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$3(Seq timestampSeq$3, IntRef i$3, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(i$3.elem)), (long)record.timestamp());
        ++i$3.elem;
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$1(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.timestamp()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$3, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$3, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$3, (long)batch.baseSequence());
        Assert.assertEquals((long)partitionLeaderEpoch$3, (long)batch.partitionLeaderEpoch());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            LogValidatorTest.$anonfun$checkCompressed$3(timestampSeq$3, i$3, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(MetricName x$8) {
        return x$8.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$checkOffsets$1(LongRef offset$1, Record entry) {
        Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)offset$1.elem, (long)entry.offset());
        ++offset$1.elem;
    }

    public static final /* synthetic */ LegacyRecord $anonfun$recordsWithInvalidInnerMagic$1(byte recordMagicValue$1, int id) {
        return LegacyRecord.create((byte)recordMagicValue$1, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public static final /* synthetic */ void $anonfun$recordsWithInvalidInnerMagic$3(MemoryRecordsBuilder builder$1, IntRef offset$2, LegacyRecord record) {
        builder$1.appendUncheckedWithOffset((long)offset$2.elem, record);
        ++offset$2.elem;
    }

    public static final /* synthetic */ void $anonfun$validateLogAppendTime$1(long expectedLogAppendTime$1, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((String)new StringBuilder(31).append("Unexpected timestamp of record ").append(record).toString(), (long)expectedLogAppendTime$1, (long)record.timestamp());
    }

    public static final /* synthetic */ Object $anonfun$checkNonCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkNonCompressed$1($this, timestampSeq$1, producerEpoch$1, producerId$1, baseSequence$1, isTransactional$1, partitionLeaderEpoch$1, i$1, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkRecompression$1$adapted(LogValidatorTest $this, Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkRecompression$1($this, timestampSeq$2, producerEpoch$2, producerId$2, baseSequence$2, partitionLeaderEpoch$2, i$2, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkCompressed$1$adapted(LogValidatorTest $this, Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkCompressed$1($this, timestampSeq$3, producerEpoch$3, producerId$3, baseSequence$3, partitionLeaderEpoch$3, i$3, batch);
        return BoxedUnit.UNIT;
    }
}

