/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001I4Aa\u0003\u0007\u0001#!)a\u0003\u0001C\u0001/!9\u0011\u0004\u0001b\u0001\n\u0013Q\u0002BB\u0012\u0001A\u0003%1\u0004C\u0004%\u0001\t\u0007I\u0011A\u0013\t\r1\u0002\u0001\u0015!\u0003'\u0011\u0015i\u0003\u0001\"\u0011/\u0011\u0015Q\u0004\u0001\"\u0011<\u0011\u0015)\u0005\u0001\"\u0001<\u0011\u0015Q\u0005\u0001\"\u0003L\u0011\u0015q\u0006\u0001\"\u0003`\u0005u\tE\r\u001a)beRLG/[8ogR{G\u000b\u001f8SKF,Xm\u001d;UKN$(BA\u0007\u000f\u0003\u0019\u0019XM\u001d<fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u0005a\u0011BA\u000b\r\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0019!\t\u0019\u0002!\u0001\u0004u_BL7-M\u000b\u00027A\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005Y\u0006twMC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"AB*ue&tw-A\u0004u_BL7-\r\u0011\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t+\u00051\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#aA%oi\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\ty#\u0007\u0005\u0002(a%\u0011\u0011\u0007\u000b\u0002\u0005+:LG\u000fC\u00034\r\u0001\u0007A'\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"!\u000e\u001d\u000e\u0003YR!aN\u0010\u0002\tU$\u0018\u000e\\\u0005\u0003sY\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0015\u0019X\r^+q)\u0005y\u0003FA\u0004>!\tq4)D\u0001@\u0015\t\u0001\u0015)A\u0003kk:LGOC\u0001C\u0003\ry'oZ\u0005\u0003\t~\u0012aAQ3g_J,\u0017\u0001P:i_VdGMU3dK&4Xm\u00149fe\u0006$\u0018n\u001c8O_R\fE\u000f^3naR,Gm\u00165f]>#\b.\u001a:QCJ$\u0018\u000e^5p]\"\u000b7/\u0012:s_JD#\u0001C$\u0011\u0005yB\u0015BA%@\u0005\u0011!Vm\u001d;\u00021M,g\u000eZ!eIB\u000b'\u000f^5uS>t7OU3rk\u0016\u001cH\u000fF\u0002M/f\u0003\"!T+\u000e\u00039S!a\u0014)\u0002\u0011I,\u0017/^3tiNT!!\u0015*\u0002\r\r|W.\\8o\u0015\ty1K\u0003\u0002U\u0003\u00061\u0011\r]1dQ\u0016L!A\u0016(\u00035\u0005#G\rU1si&$\u0018n\u001c8t)>$\u0006P\u001c*fgB|gn]3\t\u000baK\u0001\u0019\u0001\u0014\u0002\u00111,\u0017\rZ3s\u0013\u0012DQAW\u0005A\u0002m\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002N9&\u0011QL\u0014\u0002\u001a\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_RChNU3rk\u0016\u001cH/A\u0007de\u0016\fG/\u001a*fcV,7\u000f\u001e\u000b\u00037\u0002DQ!\u0019\u0006A\u0002\t\f!\u0002]1si&$\u0018n\u001c8t!\r\u00197N\u001c\b\u0003I&t!!\u001a5\u000e\u0003\u0019T!a\u001a\t\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0013B\u00016)\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001\\7\u0003\t1K7\u000f\u001e\u0006\u0003U\"\u0002\"a\u001c9\u000e\u0003AK!!\u001d)\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0002")
public class AddPartitionsToTxnRequestTest
extends BaseRequestTest {
    private final String topic1;
    private final int numPartitions;

    private String topic1() {
        return this.topic1;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic1(), this.numPartitions(), this.servers().size(), new Properties());
    }

    @Test
    public void shouldReceiveOperationNotAttemptedWhenOtherPartitionHasError() {
        TopicPartition nonExistentTopic = new TopicPartition("unknownTopic", 0);
        TopicPartition createdTopicPartition = new TopicPartition(this.topic1(), 0);
        AddPartitionsToTxnRequest request = this.createRequest((List<TopicPartition>)new .colon.colon((Object)createdTopicPartition, (List)new .colon.colon((Object)nonExistentTopic, (List)Nil$.MODULE$)));
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        AddPartitionsToTxnResponse response = this.sendAddPartitionsRequest(leaderId, request);
        Assert.assertEquals((long)2L, (long)response.errors().size());
        Assert.assertTrue((boolean)response.errors().containsKey(createdTopicPartition));
        Assert.assertEquals((Object)Errors.OPERATION_NOT_ATTEMPTED, response.errors().get(createdTopicPartition));
        Assert.assertTrue((boolean)response.errors().containsKey(nonExistentTopic));
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, response.errors().get(nonExistentTopic));
    }

    private AddPartitionsToTxnResponse sendAddPartitionsRequest(int leaderId, AddPartitionsToTxnRequest request) {
        return AddPartitionsToTxnResponse.parse((ByteBuffer)this.connectAndSend((AbstractRequest)request, ApiKeys.ADD_PARTITIONS_TO_TXN, this.brokerSocketServer(leaderId), this.connectAndSend$default$4(), this.connectAndSend$default$5()), (short)request.version());
    }

    private AddPartitionsToTxnRequest createRequest(List<TopicPartition> partitions) {
        String transactionalId = "foobar";
        long producerId = 1000L;
        short producerEpoch = 0;
        return (AddPartitionsToTxnRequest)new AddPartitionsToTxnRequest.Builder(transactionalId, producerId, producerEpoch, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(partitions).asJava()).build();
    }

    public AddPartitionsToTxnRequestTest() {
        this.topic1 = "foobartopic";
        this.numPartitions = 3;
    }
}

