/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import kafka.network.SocketServer;
import kafka.server.ApiVersionsRequestTest$;
import kafka.server.BaseRequestTest;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)<Q!\u0004\b\t\u0002M1Q!\u0006\b\t\u0002YAQ!H\u0001\u0005\u0002yAQaH\u0001\u0005\u0002\u00012A!\u0006\b\u0001g!)Q\u0004\u0002C\u0001o!)\u0011\b\u0002C!u!)a\b\u0002C\u0001\u007f!)q\t\u0002C\u0001\u007f!)\u0011\n\u0002C\u0001\u007f!)1\n\u0002C\u0001\u007f!)Q\n\u0002C\u0005\u001d\"9a\fBI\u0001\n\u0013y\u0016AF!qSZ+'o]5p]N\u0014V-];fgR$Vm\u001d;\u000b\u0005=\u0001\u0012AB:feZ,'OC\u0001\u0012\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001F\u0001\u000e\u00039\u0011a#\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiR+7\u000f^\n\u0003\u0003]\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0014\u0003m1\u0018\r\\5eCR,\u0017\t]5WKJ\u001c\u0018n\u001c8t%\u0016\u001c\bo\u001c8tKR\u0011\u0011\u0005\n\t\u00031\tJ!aI\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006K\r\u0001\rAJ\u0001\u0014CBLg+\u001a:tS>t7OU3ta>t7/\u001a\t\u0003OEj\u0011\u0001\u000b\u0006\u0003S)\n\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003W1\naaY8n[>t'BA\t.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IB#aE!qSZ+'o]5p]N\u0014Vm\u001d9p]N,7C\u0001\u00035!\t!R'\u0003\u00027\u001d\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH\u000fF\u00019!\t!B!A\u0006ce>\\WM]\"pk:$X#A\u001e\u0011\u0005aa\u0014BA\u001f\u001a\u0005\rIe\u000e^\u0001\u0017i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiR\t\u0011\u0005\u000b\u0002\b\u0003B\u0011!)R\u0007\u0002\u0007*\u0011AiL\u0001\u0006UVt\u0017\u000e^\u0005\u0003\r\u000e\u0013A\u0001V3ti\u0006aC/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cHoV5uQVs7/\u001e9q_J$X\r\u001a,feNLwN\u001c\u0015\u0003\u0011\u0005\u000b!\u0005^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e,bY&$\u0017\r^5p]Z\u0003\u0004FA\u0005B\u0003\t\"Xm\u001d;Ba&4VM]:j_:\u001c(+Z9vKN$h+\u00197jI\u0006$\u0018n\u001c8Wg!\u0012!\"Q\u0001\u0017g\u0016tG-\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiR!ae\u0014+]\u0011\u0015\u00016\u00021\u0001R\u0003\u001d\u0011X-];fgR\u0004\"a\n*\n\u0005MC#AE!qSZ+'o]5p]N\u0014V-];fgRDq!V\u0006\u0011\u0002\u0003\u0007a+\u0001\u0006ba&4VM]:j_:\u00042\u0001G,Z\u0013\tA\u0016D\u0001\u0004PaRLwN\u001c\t\u00031iK!aW\r\u0003\u000bMCwN\u001d;\t\u000bu[\u0001\u0019A-\u0002\u001fI,7\u000f]8og\u00164VM]:j_:\f\u0001e]3oI\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\t\u0001M\u000b\u0002WC.\n!\r\u0005\u0002dQ6\tAM\u0003\u0002fM\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003Of\t!\"\u00198o_R\fG/[8o\u0013\tIGMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ApiVersionsRequestTest
extends BaseRequestTest {
    public static void validateApiVersionsResponse(ApiVersionsResponse apiVersionsResponse) {
        ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Test
    public void testApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, (Option<Object>)None$.MODULE$, request.version());
        ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
    }

    @Test
    public void testApiVersionsRequestWithUnsupportedVersion() {
        ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)), (short)0);
        Assert.assertEquals((long)Errors.UNSUPPORTED_VERSION.code(), (long)apiVersionsResponse.data.errorCode());
        Assert.assertFalse((boolean)apiVersionsResponse.data.apiKeys().isEmpty());
        ApiVersionsResponseData.ApiVersionsResponseKey apiVersion = apiVersionsResponse.data.apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assert.assertEquals((long)ApiKeys.API_VERSIONS.id, (long)apiVersion.apiKey());
        Assert.assertEquals((long)ApiKeys.API_VERSIONS.oldestVersion(), (long)apiVersion.minVersion());
        Assert.assertEquals((long)ApiKeys.API_VERSIONS.latestVersion(), (long)apiVersion.maxVersion());
    }

    @Test
    public void testApiVersionsRequestValidationV0() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)((short)0))), (short)0);
        ApiVersionsRequestTest$.MODULE$.validateApiVersionsResponse(apiVersionsResponse);
    }

    @Test
    public void testApiVersionsRequestValidationV3() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), (short)3);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)((short)3))), (short)3);
        Assert.assertEquals((long)Errors.INVALID_REQUEST.code(), (long)apiVersionsResponse.data.errorCode());
    }

    private ApiVersionsResponse sendApiVersionsRequest(ApiVersionsRequest request, Option<Object> apiVersion, short responseVersion) {
        ApiKeys x$2 = ApiKeys.API_VERSIONS;
        SocketServer x$4 = this.connectAndSend$default$3();
        SecurityProtocol x$5 = this.connectAndSend$default$5();
        return ApiVersionsResponse.parse((ByteBuffer)this.connectAndSend((AbstractRequest)request, x$2, x$4, apiVersion, x$5), (short)responseVersion);
    }

    private Option<Object> sendApiVersionsRequest$default$2() {
        return None$.MODULE$;
    }
}

