/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchManager;
import kafka.server.FetchSession;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0001?!)q\u0006\u0001C\u0001a!)\u0001\b\u0001C\u0001s!)q\t\u0001C\u0005\u0011\")!\f\u0001C\u0001a!)A\f\u0001C\u0001a!9a\f\u0001b\u0001\n\u0003y\u0006B\u00027\u0001A\u0003%\u0001\rC\u0003n\u0001\u0011\u0005\u0001\u0007C\u0003p\u0001\u0011\u0005\u0001\u0007C\u0003r\u0001\u0011\u0005\u0001G\u0001\tGKR\u001c\u0007nU3tg&|g\u000eV3ti*\u0011q\u0002E\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003E\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000f\u0011\u0005u\u0001Q\"\u0001\b\u0002\u001b\u001ddwNY1m)&lWm\\;u+\u0005\u0001\u0003CA\u0011)\u001b\u0005\u0011#BA\u0012%\u0003\u0015\u0011X\u000f\\3t\u0015\t)c%A\u0003kk:LGOC\u0001(\u0003\ry'oZ\u0005\u0003S\t\u0012q\u0001V5nK>,H\u000f\u000b\u0002\u0003WA\u0011A&L\u0007\u0002I%\u0011a\u0006\n\u0002\u0005%VdW-\u0001\tuKN$h*Z<TKN\u001c\u0018n\u001c8JIR\t\u0011\u0007\u0005\u0002\u0016e%\u00111G\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u0004kA\u0011AFN\u0005\u0003o\u0011\u0012A\u0001V3ti\u0006\u0019\u0012m]:feR\u001c\u0015m\u00195f\u0007>tG/Y5ogR\u0019\u0011GO \t\u000bm\"\u0001\u0019\u0001\u001f\u0002\u000b\r\f7\r[3\u0011\u0005ui\u0014B\u0001 \u000f\u0005E1U\r^2i'\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.\u001a\u0005\u0006\u0001\u0012\u0001\r!Q\u0001\u000bg\u0016\u001c8/[8o\u0013\u0012\u001c\bcA\u000bC\t&\u00111I\u0006\u0002\u000byI,\u0007/Z1uK\u0012t\u0004CA\u000bF\u0013\t1eCA\u0002J]R\f1\u0002Z;n[f\u001c%/Z1uKR\u0011\u0011\n\u0017\u000b\u0002\u0015B\u00191jU+\u000e\u00031S!!\u0014(\u0002\u000bU$\u0018\u000e\\:\u000b\u0005=\u0003\u0016AB2p[6|gN\u0003\u0002\u0012#*\u0011!KJ\u0001\u0007CB\f7\r[3\n\u0005Qc%\u0001H%na2L7-\u001b;MS:\\W\r\u001a%bg\"\u001cu\u000e\u001c7fGRLwN\u001c\t\u0003;YK!a\u0016\b\u0003\u001f\r\u000b7\r[3e!\u0006\u0014H/\u001b;j_:DQ!W\u0003A\u0002\u0011\u000bAa]5{K\u0006\u0001B/Z:u'\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.\u001a\u0015\u0003\rU\n\u0001\u0004^3tiJ+7/\u001b>f\u0007\u0006\u001c\u0007.\u001a3TKN\u001c\u0018n\u001c8tQ\t9Q'A\bF\u001bB#\u0016l\u0018)B%R{F*S*U+\u0005\u0001\u0007cA1gQ6\t!M\u0003\u0002dI\u0006!Q\u000f^5m\u0015\u0005)\u0017\u0001\u00026bm\u0006L!a\u001a2\u0003\t1K7\u000f\u001e\t\u0003S*l\u0011AT\u0005\u0003W:\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\tF\u001bB#\u0016l\u0018)B%R{F*S*UA\u0005\tB/Z:u\r\u0016$8\r\u001b*fcV,7\u000f^:)\u0005))\u0014a\u0007;fgRLen\u0019:f[\u0016tG/\u00197GKR\u001c\u0007nU3tg&|g\u000e\u000b\u0002\fk\u0005AB/Z:u5\u0016\u0014xnU5{K\u001a+Go\u00195TKN\u001c\u0018n\u001c8)\u00051)\u0004")
public class FetchSessionTest {
    private final List<TopicPartition> EMPTY_PART_LIST = Collections.unmodifiableList(new ArrayList());

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    @Test
    public void testNewSessionId() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 10000);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach$mVc$sp_this = inclusive;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                FetchSessionTest.$anonfun$testNewSessionId$1(cache, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public void assertCacheContains(FetchSessionCache cache, Seq<Object> sessionIds) {
        IntRef i = IntRef.create((int)0);
        sessionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sessionId -> {
            ++i$1.elem;
            Assert.assertTrue((String)new StringBuilder(26).append("Missing session ").append(i$1.elem).append(" out of ").append(sessionIds.size()).append("(").append(sessionId).append(")").toString(), (boolean)cache.get(sessionId).isDefined());
        });
        Assert.assertEquals((long)sessionIds.size(), (long)cache.size());
    }

    /*
     * WARNING - void declaration
     */
    private ImplicitLinkedHashCollection<CachedPartition> dummyCreate(int size) {
        void var2_2;
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection(size);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, size - 1);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach_this = inclusive;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                cacheMap.add((ImplicitLinkedHashCollection.Element)new CachedPartition("test", foreach_i));
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        return var2_2;
    }

    @Test
    public void testSessionCache() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        Assert.assertEquals((long)0L, (long)cache.size());
        int id1 = cache.maybeCreateSession(0L, false, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id2 = cache.maybeCreateSession(10L, false, 20, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        int id3 = cache.maybeCreateSession(20L, false, 30, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(30));
        Assert.assertEquals((long)0L, (long)cache.maybeCreateSession(30L, false, 40, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(40)));
        Assert.assertEquals((long)0L, (long)cache.maybeCreateSession(40L, false, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5)));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2, id3}));
        cache.touch((FetchSession)cache.get(id1).get(), 200L);
        int id4 = cache.maybeCreateSession(210L, false, 11, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(11));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cache.touch((FetchSession)cache.get(id1).get(), 400L);
        cache.touch((FetchSession)cache.get(id3).get(), 390L);
        cache.touch((FetchSession)cache.get(id4).get(), 400L);
        int id5 = cache.maybeCreateSession(410L, false, 50, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(50));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id4, id5}));
        Assert.assertEquals((long)0L, (long)cache.maybeCreateSession(410L, false, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5)));
        int id6 = cache.maybeCreateSession(410L, true, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
    }

    @Test
    public void testResizeCachedSessions() {
        FetchSessionCache cache = new FetchSessionCache(2, 100L);
        Assert.assertEquals((long)0L, (long)cache.totalPartitions());
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id1 = cache.maybeCreateSession(0L, false, 2, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(2));
        Assert.assertTrue((id1 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cache.get(id1).get();
        Assert.assertEquals((long)2L, (long)session1.size());
        Assert.assertEquals((long)2L, (long)cache.totalPartitions());
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id2 = cache.maybeCreateSession(0L, false, 4, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(4));
        FetchSession session2 = (FetchSession)cache.get(id2).get();
        Assert.assertTrue((id2 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assert.assertEquals((long)6L, (long)cache.totalPartitions());
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        int id3 = cache.maybeCreateSession(200L, false, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        Assert.assertTrue((id3 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assert.assertEquals((long)9L, (long)cache.totalPartitions());
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        cache.remove(id3);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2}));
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        Assert.assertEquals((long)4L, (long)cache.totalPartitions());
        java.util.Iterator iter = session2.partitionMap().iterator();
        iter.next();
        iter.remove();
        Assert.assertEquals((long)3L, (long)session2.size());
        Assert.assertEquals((long)4L, (long)session2.cachedSize());
        cache.touch(session2, session2.lastUsedMs());
        Assert.assertEquals((long)3L, (long)cache.totalPartitions());
    }

    public List<TopicPartition> EMPTY_PART_LIST() {
        return this.EMPTY_PART_LIST;
    }

    @Test
    public void testFetchRequests() {
        FetchResponse resp8;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        FetchContext context = fetchManager.newContext(FetchMetadata.LEGACY, new HashMap(), this.EMPTY_PART_LIST(), true);
        Assert.assertEquals(SessionlessFetchContext.class, context.getClass());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData2.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context2 = fetchManager.newContext(FetchMetadata.INITIAL, reqData2, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, context2.getClass());
        java.util.Iterator reqData2Iter = reqData2.entrySet().iterator();
        context2.foreachPartition((Function2 & Serializable & scala.Serializable)(topicPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$1(reqData2Iter, topicPart, data);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 0)).get()));
        Assert.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 1)).get()));
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData2 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData2.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData2.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals(respData2, (Object)resp2.responseData());
        FetchContext context3 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(SessionErrorContext.class, context3.getClass());
        Assert.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context3.updateAndGenerateResponseData(respData2).error());
        FetchContext context4 = fetchManager.newContext(new FetchMetadata(resp2.sessionId() + 1, 1), reqData2, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(SessionErrorContext.class, context4.getClass());
        Assert.assertEquals((Object)Errors.FETCH_SESSION_ID_NOT_FOUND, (Object)context4.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap reqData5 = new LinkedHashMap();
        FetchContext context5 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 1), reqData5, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(IncrementalFetchContext.class, context5.getClass());
        java.util.Iterator reqData5Iter = reqData2.entrySet().iterator();
        context5.foreachPartition((Function2 & Serializable & scala.Serializable)(topicPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$2(reqData5Iter, topicPart, data);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context5.getFetchOffset(new TopicPartition("foo", 1)).get()));
        FetchResponse resp5 = context5.updateAndGenerateResponseData(respData2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assert.assertEquals((long)resp2.sessionId(), (long)resp5.sessionId());
        Assert.assertEquals((long)0L, (long)resp5.responseData().size());
        FetchContext context6 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(SessionErrorContext.class, context6.getClass());
        Assert.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context6.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap reqData7 = new LinkedHashMap();
        FetchResponse resp7 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 2), reqData7, this.EMPTY_PART_LIST(), false).getThrottledResponse(100);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assert.assertEquals((long)resp2.sessionId(), (long)resp7.sessionId());
        Assert.assertEquals((long)100L, (long)resp7.throttleTimeMs());
        int prevSessionId = resp5.sessionId();
        do {
            LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData8 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
            reqData8.put(new TopicPartition("bar", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
            reqData8.put(new TopicPartition("bar", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
            FetchContext context8 = fetchManager.newContext(new FetchMetadata(prevSessionId, -1), reqData8, this.EMPTY_PART_LIST(), false);
            Assert.assertEquals(SessionlessFetchContext.class, context8.getClass());
            Assert.assertEquals((long)0L, (long)cache.size());
            LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData8 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
            respData8.put(new TopicPartition("bar", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
            respData8.put(new TopicPartition("bar", 1), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
            resp8 = context8.updateAndGenerateResponseData(respData8);
            Assert.assertEquals((Object)Errors.NONE, (Object)resp8.error());
        } while (resp8.sessionId() == prevSessionId);
    }

    @Test
    public void testIncrementalFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData1.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData1.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)resp1.responseData().size());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(new TopicPartition("bar", 0), new FetchRequest.PartitionData(15L, 0L, 0, Optional.empty()));
        ArrayList<TopicPartition> removed2 = new ArrayList<TopicPartition>();
        removed2.add(new TopicPartition("foo", 0));
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false);
        Assert.assertEquals(IncrementalFetchContext.class, context2.getClass());
        Iterator reqData2Iter = ((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 1), new TopicPartition("bar", 0)}))).iterator();
        context2.foreachPartition((Function2 & Serializable & scala.Serializable)(topicPart, data) -> {
            FetchSessionTest.$anonfun$testIncrementalFetchSession$1(reqData2Iter, topicPart, data);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(new TopicPartition("foo", 0)));
        Assert.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 1)).get()));
        Assert.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("bar", 0)).get()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(new TopicPartition("bar", 2)));
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData2 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData2.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        respData2.put(new TopicPartition("bar", 0), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertEquals((long)1L, (long)resp2.responseData().size());
        Assert.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testZeroSizeFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData1.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData1.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)resp1.responseData().size());
        LinkedHashMap reqData2 = new LinkedHashMap();
        ArrayList<TopicPartition> removed2 = new ArrayList<TopicPartition>();
        removed2.add(new TopicPartition("foo", 0));
        removed2.add(new TopicPartition("foo", 1));
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false);
        Assert.assertEquals(SessionlessFetchContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assert.assertEquals((long)0L, (long)resp2.sessionId());
        Assert.assertTrue((boolean)resp2.responseData().isEmpty());
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    public static final /* synthetic */ void $anonfun$testNewSessionId$1(FetchSessionCache cache$1, int i) {
        Assert.assertTrue((cache$1.newSessionId() > 0 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$1(java.util.Iterator reqData2Iter$1, TopicPartition topicPart, FetchRequest.PartitionData data) {
        Map.Entry entry = (Map.Entry)reqData2Iter$1.next();
        Assert.assertEquals(entry.getKey(), (Object)topicPart);
        Assert.assertEquals(entry.getValue(), (Object)data);
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$2(java.util.Iterator reqData5Iter$1, TopicPartition topicPart, FetchRequest.PartitionData data) {
        Map.Entry entry = (Map.Entry)reqData5Iter$1.next();
        Assert.assertEquals(entry.getKey(), (Object)topicPart);
        Assert.assertEquals(entry.getValue(), (Object)data);
    }

    public static final /* synthetic */ void $anonfun$testIncrementalFetchSession$1(Iterator reqData2Iter$2, TopicPartition topicPart, FetchRequest.PartitionData data) {
        Assert.assertEquals((Object)reqData2Iter$2.next(), (Object)topicPart);
    }
}

