/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Optional;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.FailedPartitions;
import kafka.server.FetchPartitionData;
import kafka.server.Fetching$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaAlterLogDirsThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.utils.DelayedItem;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.immutable.Range;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBqA\n\u0001C\u0002\u0013%q\u0005\u0003\u00044\u0001\u0001\u0006I\u0001\u000b\u0005\bi\u0001\u0011\r\u0011\"\u0003(\u0011\u0019)\u0004\u0001)A\u0005Q!9a\u0007\u0001b\u0001\n\u00139\u0004BB\u001e\u0001A\u0003%\u0001\bC\u0003=\u0001\u0011%Q\bC\u0004L\u0001E\u0005I\u0011\u0002'\t\u000b]\u0003A\u0011\u0001-\t\u000b\r\u0004A\u0011\u0001-\t\u000b\u0015\u0004A\u0011\u0001-\t\u000b\u001d\u0004A\u0011\u0001-\t\u000b%\u0004A\u0011\u0001-\t\u000b-\u0004A\u0011\u0001-\t\u000b5\u0004A\u0011\u0001-\t\u000b=\u0004A\u0011\u0001-\t\u000bE\u0004A\u0011\u0001-\t\u000bM\u0004A\u0011\u0001;\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\ti\"+\u001a9mS\u000e\f\u0017\t\u001c;fe2{w\rR5sgRC'/Z1e)\u0016\u001cHO\u0003\u0002\u00181\u000511/\u001a:wKJT\u0011!G\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0002\"!\n\u0001\u000e\u0003Y\tA\u0001^\u0019qaU\t\u0001\u0006\u0005\u0002*c5\t!F\u0003\u0002,Y\u000511m\\7n_:T!!G\u0017\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0005\u0003e)\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0003ucA\u0004\u0004%\u0001\u0003ucA\f\u0014!\u0002;2aF\u0002\u0013\u0001\u00054bS2,G\rU1si&$\u0018n\u001c8t+\u0005A\u0004CA\u0013:\u0013\tQdC\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006\tb-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u001d=4gm]3u\u0003:$W\t]8dQR\u0019a(\u0011$\u0011\u0005\u0015z\u0014B\u0001!\u0017\u00059yeMZ:fi\u0006sG-\u00129pG\"DQA\u0011\u0005A\u0002\r\u000b1BZ3uG\"|eMZ:fiB\u0011Q\u0004R\u0005\u0003\u000bz\u0011A\u0001T8oO\"9q\t\u0003I\u0001\u0002\u0004A\u0015a\u00037fC\u0012,'/\u00129pG\"\u0004\"!H%\n\u0005)s\"aA%oi\u0006ArN\u001a4tKR\fe\u000eZ#q_\u000eDG\u0005Z3gCVdG\u000f\n\u001a\u0016\u00035S#\u0001\u0013(,\u0003=\u0003\"\u0001U+\u000e\u0003ES!AU*\u0002\u0013Ut7\r[3dW\u0016$'B\u0001+\u001f\u0003)\tgN\\8uCRLwN\\\u0005\u0003-F\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\tJ7o];fg\u0016\u0003xn\u00195SKF,Xm\u001d;Ge>lGj\\2bYJ+\u0007\u000f\\5dCR\t\u0011\f\u0005\u0002\u001e5&\u00111L\b\u0002\u0005+:LG\u000f\u000b\u0002\u000b;B\u0011a,Y\u0007\u0002?*\u0011\u0001mL\u0001\u0006UVt\u0017\u000e^\u0005\u0003E~\u0013A\u0001V3ti\u0006id-\u001a;dQ\u0016\u0003xn\u00195t\rJ|W\u000eT3bI\u0016\u00148\u000b[8vY\u0012D\u0015M\u001c3mK\u0016C8-\u001a9uS>tgI]8n\u000f\u0016$Hj\\2bYJ+\u0007\u000f\\5dC\"\u00121\"X\u0001\u001eg\"|W\u000f\u001c3UeVt7-\u0019;f)>\u0014V\r\u001d7jG\u0006|eMZ:fi\"\u0012A\"X\u0001.g\"|W\u000f\u001c3UeVt7-\u0019;f)>,e\u000eZ(gMN,Go\u00144MCJ<Wm\u001d;D_6lwN\\#q_\u000eD\u0007FA\u0007^\u0003\u0005\u001b\bn\\;mIR\u0013XO\\2bi\u0016$v.\u00138ji&\fGNR3uG\"|eMZ:fi&3'+\u001a9mS\u000e\f'+\u001a;ve:\u001cXK\u001c3fM&tW\rZ(gMN,G\u000f\u000b\u0002\u000f;\u0006Y3\u000f[8vY\u0012\u0004v\u000e\u001c7J]\u0012,g-\u001b8ji\u0016d\u00170\u00134SKBd\u0017nY1O_R\fe/Y5mC\ndW\r\u000b\u0002\u0010;\u000613\u000f[8vY\u00124U\r^2i\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00148GSJ\u001cHOR3uG\"|e\u000e\\=)\u0005Ai\u0016\u0001H:i_VdGMR3uG\"|e.\u001a*fa2L7-Y!u\u0003RKW.\u001a\u0015\u0003#u\u000bQf\u001d5pk2$g)\u001a;dQ:{g\u000eR3mCf,G-\u00118e\u001d>tGK];oG\u0006$\u0018N\\4SKBd\u0017nY1tQ\t\u0011R,\u0001\u0003tiV\u0014GcC;\u0002\n\u0005e\u0011QDA\u0011\u0003K\u00012A^=|\u001b\u00059(B\u0001=0\u0003!)\u0017m]=n_\u000e\\\u0017B\u0001>x\u0005MIU\t\u001f9fGR\fG/[8o'\u0016$H/\u001a:t!\riBP`\u0005\u0003{z\u0011aa\u00149uS>t\u0007cA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007A\u0012aB2mkN$XM]\u0005\u0005\u0003\u000f\t\tAA\u0005QCJ$\u0018\u000e^5p]\"9\u00111B\nA\u0002\u00055\u0011a\u00027pOR\u000b\u0004\u000f\r\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003\r\u0002\u00071|w-\u0003\u0003\u0002\u0018\u0005E!a\u0001'pO\"9\u00111D\nA\u0002\u00055\u0011a\u00027pOR\u000b\u0004/\r\u0005\b\u0003?\u0019\u0002\u0019AA\u0007\u0003%1W\u000f^;sK2{w\r\u0003\u0004\u0002$M\u0001\rA`\u0001\na\u0006\u0014H/\u001b;j_:Dq!a\n\u0014\u0001\u0004\tI#\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0011\u0007\u0015\nY#C\u0002\u0002.Y\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'/A\u000btiV\u0014w+\u001b;i\r\u0016$8\r['fgN\fw-Z:\u0015\u001d\u0005M\u0012QGA\u001c\u0003s\tY$!\u0010\u0002@A\u0019a/_-\t\u000f\u0005-A\u00031\u0001\u0002\u000e!9\u00111\u0004\u000bA\u0002\u00055\u0001bBA\u0010)\u0001\u0007\u0011Q\u0002\u0005\u0007\u0003G!\u0002\u0019\u0001@\t\u000f\u0005\u001dB\u00031\u0001\u0002*!9\u0011\u0011\t\u000bA\u0002\u0005\r\u0013\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u00151\u0018QIA%\u0013\r\t9e\u001e\u0002\b\u0007\u0006\u0004H/\u001e:f!\u0019i\u00121JA(3&\u0019\u0011Q\n\u0010\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CBA)\u0003/\nY&\u0004\u0002\u0002T)\u0019\u0011Q\u000b\u0010\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002Z\u0005M#aA*fcB1Q$!\u0018)\u0003CJ1!a\u0018\u001f\u0005\u0019!V\u000f\u001d7feA\u0019Q%a\u0019\n\u0007\u0005\u0015dC\u0001\nGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8ECR\f\u0007")
public class ReplicaAlterLogDirsThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final FailedPartitions failedPartitions = new FailedPartitions();

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private OffsetAndEpoch offsetAndEpoch(long fetchOffset, int leaderEpoch) {
        return new OffsetAndEpoch(fetchOffset, leaderEpoch);
    }

    private int offsetAndEpoch$default$2() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void issuesEpochRequestFromLocalReplica() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partitionT1p0 = (Partition)EasyMock.createMock(Partition.class);
        Partition partitionT1p1 = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpochT1p0 = 2;
        int leaderEpochT1p1 = 5;
        int leoT1p0 = 13;
        int leoT1p1 = 232;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partitionT1p0);
        EasyMock.expect((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p0, false)).andReturn((Object)new EpochEndOffset(leaderEpochT1p0, (long)leoT1p0)).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p1(), false)).andStubReturn((Object)partitionT1p1);
        EasyMock.expect((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p1, false)).andReturn((Object)new EpochEndOffset(leaderEpochT1p1, (long)leoT1p1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{partitionT1p0, partitionT1p1, replicaManager});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        Tuple2[] tuple2Array = new Tuple2[2];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), leaderEpochT1p0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        OffsetsForLeaderEpochRequest.PartitionData partitionData2 = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), leaderEpochT1p1);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, null, null).fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(Errors.NONE, leaderEpochT1p0, (long)leoT1p0);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(Errors.NONE, leaderEpochT1p1, (long)leoT1p1);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map expected = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        Assert.assertEquals((String)"results from leader epoch request should have offset from local replica", (Object)expected, (Object)result);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void fetchEpochsFromLeaderShouldHandleExceptionFromGetLocalReplica() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partitionT1p0 = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int leaderEpoch = 2;
        int leo = 13;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partitionT1p0);
        EasyMock.expect((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch, (long)leo)).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p1(), false)).andThrow((Throwable)new KafkaStorageException()).once();
        EasyMock.replay((Object[])new Object[]{partitionT1p0, replicaManager});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        Tuple2[] tuple2Array = new Tuple2[2];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), leaderEpoch);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        OffsetsForLeaderEpochRequest.PartitionData partitionData2 = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), leaderEpoch);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, null, null).fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        EpochEndOffset epochEndOffset = new EpochEndOffset(Errors.NONE, leaderEpoch, (long)leo);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        EpochEndOffset epochEndOffset2 = new EpochEndOffset(Errors.KAFKA_STORAGE_ERROR, -1, -1L);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))), (Object)result);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldTruncateToReplicaOffset() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Capture truncateCaptureT1p0 = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Capture truncateCaptureT1p1 = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log logT1p0 = (Log)EasyMock.createNiceMock(Log.class);
        Log logT1p1 = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLogT1p0 = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLogT1p1 = (Log)EasyMock.createNiceMock(Log.class);
        Partition partitionT1p0 = (Partition)EasyMock.createMock(Partition.class);
        Partition partitionT1p1 = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int leaderEpoch = 2;
        int futureReplicaLEO = 191;
        int replicaT1p0LEO = 190;
        int replicaT1p1LEO = 192;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partitionT1p0);
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p1(), false)).andStubReturn((Object)partitionT1p1);
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLogT1p0);
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p1())).andStubReturn((Object)futureLogT1p1);
        partitionT1p0.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateCaptureT1p0)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        partitionT1p1.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateCaptureT1p1)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLogT1p0.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLogT1p1.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureLogT1p0.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)futureLogT1p0.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch, (long)replicaT1p0LEO)).anyTimes();
        EasyMock.expect((Object)futureLogT1p1.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)futureLogT1p1.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch, (long)replicaT1p1LEO)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(logT1p0, logT1p1, futureLogT1p0, partitionT1p0, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partitionT1p0, partitionT1p1, logT1p0, logT1p1, futureLogT1p0, futureLogT1p1});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        thread.doWork();
        Assert.assertEquals((long)replicaT1p0LEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p0.getValue()));
        Assert.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p1.getValue()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldTruncateToEndOffsetOfLargestCommonEpoch() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLog = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int leaderEpoch = 5;
        int futureReplicaLEO = 195;
        int replicaLEO = 200;
        int replicaEpochEndOffset = 190;
        int futureReplicaEpochEndOffset = 191;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partition);
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLog);
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.eq((boolean)true));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureLog.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).once();
        EasyMock.expect((Object)futureLog.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch - 2)))).once();
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch - 1, (long)replicaLEO)).anyTimes();
        EasyMock.expect((Object)futureLog.endOffsetForEpoch(leaderEpoch - 1)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch - 2))).anyTimes();
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch - 2, false)).andReturn((Object)new EpochEndOffset(leaderEpoch - 2, (long)replicaEpochEndOffset)).anyTimes();
        EasyMock.expect((Object)futureLog.endOffsetForEpoch(leaderEpoch - 2)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaEpochEndOffset, leaderEpoch - 2))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        thread.doWork();
        thread.doWork();
        Assert.assertTrue((String)new StringBuilder(48).append("Expected offset ").append(replicaEpochEndOffset).append(" in captured truncation offsets ").append(truncateToCapture.getValues()).toString(), (boolean)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)replicaEpochEndOffset)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldTruncateToInitialFetchOffsetIfReplicaReturnsUndefinedOffset() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLog = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int initialFetchOffset = 100;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partition);
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.eq((boolean)true));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLog);
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)futureLog.latestEpoch()).andReturn((Object)None$.MODULE$).anyTimes();
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(initialFetchOffset, this.offsetAndEpoch$default$2());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        thread.doWork();
        Assert.assertEquals((String)"Expected future replica to truncate to initial fetch offset if replica returns UNDEFINED_EPOCH_OFFSET", (long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldPollIndefinitelyIfReplicaNotAvailable() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLog = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int futureReplicaLeaderEpoch = 1;
        int futureReplicaLEO = 290;
        int replicaLEO = 300;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partition);
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.eq((boolean)true));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLog);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureLog.latestEpoch()).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpoch)));
        EasyMock.expect((Object)futureLog.endOffsetForEpoch(futureReplicaLeaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, futureReplicaLeaderEpoch)));
        EasyMock.expect((Object)replicaManager.localLog(this.t1p0())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andReturn((Object)futureLog).anyTimes();
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), futureReplicaLeaderEpoch, false)).andReturn((Object)new EpochEndOffset(Errors.REPLICA_NOT_AVAILABLE, -1, -1L)).times(3).andReturn((Object)new EpochEndOffset(futureReplicaLeaderEpoch, (long)replicaLEO));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        replicaManager.fetchMessages(EasyMock.anyLong(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (IsolationLevel)EasyMock.anyObject(), (Option)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, responseCallback){
            private final Capture responseCallback$1;

            public void answer() {
                ((Function1)this.responseCallback$1.getValue()).apply((Object)Seq$.MODULE$.empty());
            }
            {
                this.responseCallback$1 = responseCallback$1;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 2);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach$mVc$sp_this = inclusive;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                thread.doWork();
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((long)0L, (long)truncated.getValues().size());
        thread.doWork();
        Assert.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnly() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLog = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int leaderEpoch = 5;
        int futureReplicaLEO = 190;
        int replicaLEO = 213;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0(), false)).andStubReturn((Object)partition);
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new EpochEndOffset(leaderEpoch, (long)replicaLEO));
        partition.truncateTo((long)futureReplicaLEO, true);
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLog);
        EasyMock.expect((Object)futureLog.latestEpoch()).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        EasyMock.expect((Object)futureLog.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, this.offsetAndEpoch$default$2());
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 3);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach$mVc$sp_this = inclusive;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                thread.doWork();
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        EasyMock.verify((Object[])new Object[]{partition});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchOneReplicaAtATime() {
        void var13_21;
        void var12_20;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLog = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stub(log, null, futureLog, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, leaderEpoch);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, leaderEpoch);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        PartitionFetchState partitionFetchState = PartitionFetchState$.MODULE$.apply(150L, leaderEpoch, (ReplicaState)Fetching$.MODULE$);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        PartitionFetchState partitionFetchState2 = PartitionFetchState$.MODULE$.apply(160L, leaderEpoch, (ReplicaState)Fetching$.MODULE$);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Set partitionsWithError = resultWithPartitions.partitionsWithError();
        void fetchRequestOpt2 = var12_20;
        void partitionsWithError2 = var13_21;
        Assert.assertTrue((boolean)fetchRequestOpt2.isDefined());
        FetchRequest.Builder fetchRequest = (FetchRequest.Builder)fetchRequestOpt2.get();
        Assert.assertFalse((boolean)fetchRequest.fetchData().isEmpty());
        Assert.assertFalse((boolean)partitionsWithError2.nonEmpty());
        FetchRequest request = (FetchRequest)fetchRequest.build();
        Assert.assertEquals((long)0L, (long)request.minBytes());
        Seq fetchInfos = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq();
        Assert.assertEquals((long)1L, (long)fetchInfos.length());
        Assert.assertEquals((String)"Expected fetch request for first partition", (Object)this.t1p0(), (Object)((Tuple2)fetchInfos.head())._1());
        Assert.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchNonDelayedAndNonTruncatingReplicas() {
        void var28_44;
        void var27_43;
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void var21_33;
        void var20_32;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void var14_22;
        void var13_21;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        Log log = (Log)EasyMock.createNiceMock(Log.class);
        Log futureLog = (Log)EasyMock.createNiceMock(Log.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int startOffset = 123;
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)startOffset)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stub(log, null, futureLog, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        Tuple2[] tuple2Array = new Tuple2[2];
        OffsetAndEpoch offsetAndEpoch = this.offsetAndEpoch(0L, leaderEpoch);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        OffsetAndEpoch offsetAndEpoch2 = this.offsetAndEpoch(0L, leaderEpoch);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        Tuple2[] tuple2Array2 = new Tuple2[2];
        PartitionFetchState partitionFetchState = PartitionFetchState$.MODULE$.apply(150L, leaderEpoch, (ReplicaState)Fetching$.MODULE$);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        PartitionFetchState partitionFetchState2 = PartitionFetchState$.MODULE$.apply(160L, leaderEpoch, (ReplicaState)Truncating$.MODULE$);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Set partitionsWithError = resultWithPartitions.partitionsWithError();
        void fetchRequestOpt2 = var13_21;
        void partitionsWithError2 = var14_22;
        Assert.assertTrue((boolean)fetchRequestOpt2.isDefined());
        FetchRequest.Builder fetchRequest = (FetchRequest.Builder)fetchRequestOpt2.get();
        Assert.assertFalse((boolean)fetchRequest.fetchData().isEmpty());
        Assert.assertFalse((boolean)partitionsWithError2.nonEmpty());
        Seq fetchInfos = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((FetchRequest)fetchRequest.build()).fetchData()).asScala()).toSeq();
        Assert.assertEquals((long)1L, (long)fetchInfos.length());
        Assert.assertEquals((String)"Expected fetch request for non-truncating partition", (Object)this.t1p0(), (Object)((Tuple2)fetchInfos.head())._1());
        Assert.assertEquals((long)150L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos.head())._2()).fetchOffset);
        Tuple2[] tuple2Array3 = new Tuple2[2];
        PartitionFetchState partitionFetchState3 = PartitionFetchState$.MODULE$.apply(140L, leaderEpoch, (ReplicaState)Fetching$.MODULE$);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        PartitionFetchState partitionFetchState4 = new PartitionFetchState(160L, leaderEpoch, new DelayedItem(5000L), (ReplicaState)Fetching$.MODULE$);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3)));
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option fetchRequest2Opt = (Option)resultWithPartitions2.result();
        Set partitionsWithError22 = resultWithPartitions2.partitionsWithError();
        void fetchRequest2Opt2 = var20_32;
        void partitionsWithError23 = var21_33;
        Assert.assertTrue((boolean)fetchRequest2Opt2.isDefined());
        FetchRequest.Builder fetchRequest2 = (FetchRequest.Builder)fetchRequest2Opt2.get();
        Assert.assertFalse((boolean)fetchRequest2.fetchData().isEmpty());
        Assert.assertFalse((boolean)partitionsWithError23.nonEmpty());
        Seq fetchInfos2 = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((FetchRequest)fetchRequest2.build()).fetchData()).asScala()).toSeq();
        Assert.assertEquals((long)1L, (long)fetchInfos2.length());
        Assert.assertEquals((String)"Expected fetch request for non-delayed partition", (Object)this.t1p0(), (Object)((Tuple2)fetchInfos2.head())._1());
        Assert.assertEquals((long)140L, (long)((FetchRequest.PartitionData)((Tuple2)fetchInfos2.head())._2()).fetchOffset);
        Tuple2[] tuple2Array4 = new Tuple2[2];
        PartitionFetchState partitionFetchState5 = new PartitionFetchState(140L, leaderEpoch, new DelayedItem(5000L), (ReplicaState)Fetching$.MODULE$);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        PartitionFetchState partitionFetchState6 = new PartitionFetchState(160L, leaderEpoch, new DelayedItem(5000L), (ReplicaState)Fetching$.MODULE$);
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions3 = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4)));
        if (resultWithPartitions3 == null) {
            throw new MatchError(null);
        }
        Option fetchRequest3Opt = (Option)resultWithPartitions3.result();
        Set partitionsWithError3 = resultWithPartitions3.partitionsWithError();
        void fetchRequest3Opt2 = var27_43;
        void partitionsWithError32 = var28_44;
        Assert.assertTrue((String)"Expected no fetch requests since all partitions are delayed", (boolean)fetchRequest3Opt2.isEmpty());
        Assert.assertFalse((boolean)partitionsWithError32.nonEmpty());
    }

    public IExpectationSetters<Option<Partition>> stub(Log logT1p0, Log logT1p1, Log futureLog, Partition partition, ReplicaManager replicaManager) {
        EasyMock.expect((Object)replicaManager.localLog(this.t1p0())).andReturn((Object)new Some((Object)logT1p0)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException(this.t1p0())).andReturn((Object)logT1p0).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andReturn((Object)futureLog).anyTimes();
        EasyMock.expect((Object)replicaManager.nonOfflinePartition(this.t1p0())).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLog(this.t1p1())).andReturn((Object)new Some((Object)logT1p1)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException(this.t1p1())).andReturn((Object)logT1p1).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p1())).andReturn((Object)futureLog).anyTimes();
        return EasyMock.expect((Object)replicaManager.nonOfflinePartition(this.t1p1())).andReturn((Object)new Some((Object)partition)).anyTimes();
    }

    public IExpectationSetters<BoxedUnit> stubWithFetchMessages(Log logT1p0, Log logT1p1, Log futureLog, Partition partition, ReplicaManager replicaManager, Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>> responseCallback) {
        this.stub(logT1p0, logT1p1, futureLog, partition, replicaManager);
        replicaManager.fetchMessages(EasyMock.anyLong(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Function1)EasyMock.capture(responseCallback), (IsolationLevel)EasyMock.anyObject(), (Option)EasyMock.anyObject());
        return EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, responseCallback){
            private final Capture responseCallback$2;

            public void answer() {
                ((Function1)this.responseCallback$2.getValue()).apply((Object)Seq$.MODULE$.empty());
            }
            {
                this.responseCallback$2 = responseCallback$2;
            }
        }).anyTimes();
    }
}

