/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kafka.api.Request$;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.OffsetAndEpoch;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaManagerTest$;
import kafka.server.ReplicaManagerTest$$anon$2$;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.epoch.util.ReplicaFetcherMockBlockingSend;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.Growable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015b\u0001B(Q\u0001UCQ\u0001\u0018\u0001\u0005\u0002uCq\u0001\u0019\u0001C\u0002\u0013\u0005\u0011\r\u0003\u0004k\u0001\u0001\u0006IA\u0019\u0005\bW\u0002\u0011\r\u0011\"\u0001m\u0011\u0019\u0019\b\u0001)A\u0005[\"9A\u000f\u0001b\u0001\n\u0003)\bbBA\u0003\u0001\u0001\u0006IA\u001e\u0005\f\u0003\u000f\u0001\u0001\u0019!a\u0001\n\u0003\tI\u0001C\u0006\u0002\u0018\u0001\u0001\r\u00111A\u0005\u0002\u0005e\u0001bCA\u0013\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0017A\u0011\"a\n\u0001\u0005\u0004%\t!!\u000b\t\u0011\u0005E\u0002\u0001)A\u0005\u0003WA\u0011\"a\r\u0001\u0005\u0004%\t!!\u000b\t\u0011\u0005U\u0002\u0001)A\u0005\u0003WA\u0011\"a\u000e\u0001\u0001\u0004%\t!!\u000b\t\u0013\u0005e\u0002\u00011A\u0005\u0002\u0005m\u0002\u0002CA \u0001\u0001\u0006K!a\u000b\t\u0013\u0005\u0005\u0003A1A\u0005\u0002\u0005\r\u0003\u0002CA&\u0001\u0001\u0006I!!\u0012\t\u000f\u00055\u0003\u0001\"\u0001\u0002P!9\u0011q\f\u0001\u0005\u0002\u0005=\u0003bBA5\u0001\u0011\u0005\u0011q\n\u0005\b\u0003g\u0002A\u0011AA(\u0011\u001d\t9\b\u0001C\u0001\u0003\u001fBq!a\u001f\u0001\t\u0003\ty\u0005C\u0004\u0002\u0000\u0001!\t!a\u0014\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002P!9\u0011q\u0011\u0001\u0005\u0002\u0005=\u0003bBAF\u0001\u0011\u0005\u0011q\n\u0005\b\u0003\u001f\u0003A\u0011AA(\u0011\u001d\t\u0019\n\u0001C\u0001\u0003\u001fBq!a&\u0001\t\u0003\ty\u0005C\u0004\u0002\u001c\u0002!\t!a\u0014\t\u000f\u0005}\u0005\u0001\"\u0001\u0002P!9\u00111\u0015\u0001\u0005\u0002\u0005=\u0003bBAT\u0001\u0011\u0005\u0011q\n\u0005\b\u0003k\u0003A\u0011AA(\u0011\u001d\tI\f\u0001C\u0001\u0003\u001fBq!!0\u0001\t\u0003\ty\u0005C\u0004\u0002B\u0002!\t!a\u0014\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002P!9\u0011\u0011\u001a\u0001\u0005\u0002\u0005=\u0003bBAg\u0001\u0011\u0005\u0011q\n\u0005\b\u0003#\u0004A\u0011BAj\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0005[A\u0011B!\u001b\u0001#\u0003%IAa\u001b\t\u000f\t\u0005\u0005\u0001\"\u0003\u0003\u0004\"I!q\u0019\u0001\u0012\u0002\u0013%!\u0011\u001a\u0005\b\u0005\u001b\u0004A\u0011\u0002Bh\r\u0019\u0019)\u0001\u0001\u0003\u0004\b!1AL\rC\u0001\u0007\u0017A\u0011ba\n3\u0001\u0004%Ia!\u000b\t\u0013\r5\"\u00071A\u0005\n\r=\u0002\u0002CB\u001ae\u0001\u0006Kaa\u000b\t\u0013\rU\"\u00071A\u0005\n\r]\u0002\"CB!e\u0001\u0007I\u0011BB\"\u0011!\u00199E\rQ!\n\re\u0002bBB%e\u0011\u000511\n\u0005\b\u0007\u001b\u0012D\u0011AB(\u0011\u001d\u0019\tF\rC\u0001\u0007'Bqaa\u00163\t\u0003\u0019I\u0006C\u0004\u0004^\u0001!Iaa\u0018\t\u0013\r\u001d\u0005!%A\u0005\n\r%\u0005\"CBG\u0001E\u0005I\u0011BBH\u0011\u001d\u0019\u0019\n\u0001C\u0005\u0007+C\u0011b!.\u0001#\u0003%Iaa.\t\u0013\rm\u0006!%A\u0005\n\ru\u0006\"CBa\u0001E\u0005I\u0011BBb\u0011\u001d\u00199\r\u0001C\u0005\u0007\u0013D\u0011ba6\u0001#\u0003%Iaa.\t\u0013\re\u0007!%A\u0005\n\ru\u0006\"CBn\u0001E\u0005I\u0011BBb\u0011\u001d\u0019i\u000e\u0001C\u0005\u0007?Dqa!=\u0001\t\u0013\u0019\u0019\u0010C\u0005\u0005\b\u0001\t\n\u0011\"\u0003\u0005\n!9AQ\u0002\u0001\u0005\u0002\u0005=\u0003b\u0002C\t\u0001\u0011\u0005\u0011q\n\u0005\b\t+\u0001A\u0011\u0002C\f\u0005I\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005E\u0013\u0016AB:feZ,'OC\u0001T\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\f\u0005\u0002`\u00015\t\u0001+A\u0003u_BL7-F\u0001c!\t\u0019\u0007.D\u0001e\u0015\t)g-\u0001\u0003mC:<'\"A4\u0002\t)\fg/Y\u0005\u0003S\u0012\u0014aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0003uS6,W#A7\u0011\u00059\fX\"A8\u000b\u0005A\u0014\u0016!B;uS2\u001c\u0018B\u0001:p\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013aB7fiJL7m]\u000b\u0002mB\u0019q/!\u0001\u000e\u0003aT!\u0001^=\u000b\u0005i\\\u0018AB2p[6|gN\u0003\u0002Ty*\u0011QP`\u0001\u0007CB\f7\r[3\u000b\u0003}\f1a\u001c:h\u0013\r\t\u0019\u0001\u001f\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013!D6bM.\f'l[\"mS\u0016tG/\u0006\u0002\u0002\fA!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012I\u000b!A_6\n\t\u0005U\u0011q\u0002\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002#-\fgm[1[W\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\u0005\u0005\u0002cA,\u0002\u001e%\u0019\u0011q\u0004-\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003GI\u0011\u0011!a\u0001\u0003\u0017\t1\u0001\u001f\u00132\u00039Y\u0017MZ6b5.\u001cE.[3oi\u0002\n\u0011B_6WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005-\u0002cA,\u0002.%\u0019\u0011q\u0006-\u0003\u0007%sG/\u0001\u0006{WZ+'o]5p]\u0002\nQbY8se\u0016d\u0017\r^5p]&#\u0017AD2peJ,G.\u0019;j_:LE\rI\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\u0006\u00192m\u001c8ue>dG.\u001a:Fa>\u001c\u0007n\u0018\u0013fcR!\u00111DA\u001f\u0011%\t\u0019\u0003EA\u0001\u0002\u0004\tY#\u0001\td_:$(o\u001c7mKJ,\u0005o\\2iA\u0005Y!M]8lKJ,\u0005o\\2i+\t\t)\u0005E\u0002X\u0003\u000fJ1!!\u0013Y\u0005\u0011auN\\4\u0002\u0019\t\u0014xn[3s\u000bB|7\r\u001b\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005m\u0001f\u0001\u000b\u0002TA!\u0011QKA.\u001b\t\t9FC\u0002\u0002Zy\fQA[;oSRLA!!\u0018\u0002X\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004+\u0005\r\u0004\u0003BA+\u0003KJA!a\u001a\u0002X\t)\u0011I\u001a;fe\u0006\tC/Z:u\u0011&<\u0007nV1uKJl\u0015M]6ESJ,7\r^8ss6\u000b\u0007\u000f]5oO\"\u001aa#!\u001c\u0011\t\u0005U\u0013qN\u0005\u0005\u0003c\n9F\u0001\u0003UKN$\u0018!\u000b;fgRD\u0015n\u001a5xCR,'/T1sWJ+G.\u0019;jm\u0016$\u0015N]3di>\u0014\u00180T1qa&tw\rK\u0002\u0018\u0003[\nq\u0003^3ti&cG.Z4bYJ+\u0017/^5sK\u0012\f5m[:)\u0007a\ti'\u0001\u0013uKN$8\t\\3beB+(oZ1u_JLxJ\u001c\"fG>l\u0017N\\4G_2dwn^3sQ\rI\u0012QN\u00019i\u0016\u001cHOU3dK&4XmT;u\u001f\u001a|%\u000fZ3s'\u0016\fX/\u001a8dK\u0016C8-\u001a9uS>tw+\u001b;i\u0019><7\u000b^1si>3gm]3uQ\rQ\u0012QN\u0001#i\u0016\u001cHOU3bI\u000e{W.\\5ui\u0016$g)\u001a;dQ2KW.\u001b;fI\u0006#HjU()\u0007m\ti'A\u0016uKN$H)\u001a7bs\u0016$g)\u001a;dQ&s7\r\\;eKN\f%m\u001c:uK\u0012$&/\u00198tC\u000e$\u0018n\u001c8tQ\ra\u0012QN\u00010i\u0016\u001cHOR3uG\"\u0014U-_8oI\"Kw\r[,bi\u0016\u0014X.\u0019:l%\u0016$XO\u001d8F[B$\u0018PU3ta>t7/\u001a\u0015\u0004;\u00055\u0014!\u000b;fgR4u\u000e\u001c7po\u0016\u00148\u000b^1uK:{G/\u00169eCR,G-\u00134M_\u001e\u0014V-\u00193GC&d7\u000fK\u0002\u001f\u0003[\nq\u0006^3ti\u001a+Go\u00195NKN\u001c\u0018mZ3t/\",gNT8u\r>dGn\\<fe\u001a{'o\u00148f!\u0006\u0014H/\u001b;j_:D3aHA7\u0003q\"Xm\u001d;CK\u000e|W.\u001a$pY2|w/\u001a:XQ\u0016tG*Z1eKJL5/\u00168dQ\u0006tw-\u001a3CkRl\u0015n]:fI2+\u0017\rZ3s+B$\u0017\r^3)\u0007\u0001\ni'A\nuKN$(+\u001a9mS\u000e\f7+\u001a7fGR|'\u000fK\u0002\"\u0003[\na\u0004^3tiB\u0013XMZ3se\u0016$'+\u001a9mS\u000e\f\u0017i\u001d$pY2|w/\u001a:)\u0007\t\ni'\u0001\u000fuKN$\bK]3gKJ\u0014X\r\u001a*fa2L7-Y!t\u0019\u0016\fG-\u001a:)\u0007\r\ni'\u0001\u000euKN$XK\\6o_^t'+\u001a9mS\u000e\f7+\u001a7fGR|'\u000fK\u0004%\u0003[\nY+!,\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#!a,\u0011\u0007\r\f\t,C\u0002\u00024\u0012\u0014ac\u00117bgNtu\u000e\u001e$pk:$W\t_2faRLwN\\\u0001\u001bi\u0016\u001cH\u000fR3gCVdGOU3qY&\u001c\u0017mU3mK\u000e$xN\u001d\u0015\u0004K\u00055\u0014A\u000b;fgR4U\r^2i\r>dGn\\<fe:{G/\u00117m_^,GMR8s\u001f2$WM]\"mS\u0016tGo\u001d\u0015\u0004M\u00055\u0014\u0001\r;fgR\u0014UmY8nK\u001a{G\u000e\\8xKJ<\u0006.\u001b7f\u001f2$7\t\\5f]R4U\r^2i\u0013:\u0004VO]4bi>\u0014\u0018\u0010K\u0002(\u0003[\n\u0001\u0007^3ti\n+7m\\7f\r>dGn\\<fe^C\u0017\u000e\\3OK^\u001cE.[3oi\u001a+Go\u00195J]B+(oZ1u_JL\bf\u0001\u0015\u0002n\u0005\u0001C/Z:u\r\u0016$8\r\u001b$s_6dU-\u00193fe\u0006cw/Y=t\u00032dwn^3eQ\rI\u0013QN\u0001%i\u0016\u001cHo\u00117fCJ4U\r^2i!V\u0014x-\u0019;pef|en\u0015;paJ+\u0007\u000f\\5dC\"\u001a!&!\u001c\u0002MQ,7\u000f^\"mK\u0006\u0014\bK]8ek\u000e,\u0007+\u001e:hCR|'/_(o'R|\u0007OU3qY&\u001c\u0017\rK\u0002,\u0003[\n!c]3oIB\u0013x\u000eZ;dKJ\f\u0005\u000f]3oIR1\u0011Q\u001bB\u000b\u0005?\u0001b!a6\u0002f\u0006%XBAAm\u0015\u0011\tY.!8\u0002\r\u0005$x.\\5d\u0015\u0011\ty.!9\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0002d\u001a\fA!\u001e;jY&!\u0011q]Am\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007\u0003BAv\u0005\u001fqA!!<\u0003\n9!\u0011q\u001eB\u0003\u001d\u0011\t\tPa\u0001\u000f\t\u0005M(\u0011\u0001\b\u0005\u0003k\fyP\u0004\u0003\u0002x\u0006uXBAA}\u0015\r\tY\u0010V\u0001\u0007yI|w\u000e\u001e \n\u0003}L!! @\n\u0005Mc\u0018B\u0001>|\u0013\r\u00119!_\u0001\te\u0016\fX/Z:ug&!!1\u0002B\u0007\u0003=\u0001&o\u001c3vG\u0016\u0014Vm\u001d9p]N,'b\u0001B\u0004s&!!\u0011\u0003B\n\u0005E\u0001\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0006\u0005\u0005\u0017\u0011i\u0001C\u0004\u0003\u00181\u0002\rA!\u0007\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0019qLa\u0007\n\u0007\tu\u0001K\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u000f\t\u0005B\u00061\u0001\u0003$\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0003\u0002B\u0013\u0005Oi\u0011!_\u0005\u0004\u0005SI(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0012g\u0016tGmQ8ogVlWM\u001d$fi\u000eDG\u0003\u0004B\u0018\u0005o\u0011IDa\u000f\u0003P\t\u0015\u0004CBAl\u0003K\u0014\t\u0004E\u0002`\u0005gI1A!\u000eQ\u0005I1U\r^2i!\u0006\u0014H/\u001b;j_:$\u0015\r^1\t\u000f\t]Q\u00061\u0001\u0003\u001a!9!\u0011E\u0017A\u0002\t\r\u0002b\u0002B\u001f[\u0001\u0007!qH\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0011\t\t\u0005#\u0011\n\b\u0005\u0005\u0007\u0012)%\u0004\u0002\u0003\u000e%!!q\tB\u0007\u000311U\r^2i%\u0016\fX/Z:u\u0013\u0011\u0011YE!\u0014\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\u0011\u00119E!\u0004\t\u000f\tES\u00061\u0001\u0003T\u0005\t2\r\\5f]RlU\r^1eCR\fw\n\u001d;\u0011\u000b]\u0013)F!\u0017\n\u0007\t]\u0003L\u0001\u0004PaRLwN\u001c\t\u0005\u00057\u0012\t'\u0004\u0002\u0003^)\u0019!qL=\u0002\u000fI,\u0007\u000f\\5dC&!!1\rB/\u00059\u0019E.[3oi6+G/\u00193bi\u0006D\u0011Ba\u001a.!\u0003\u0005\r!!\u0012\u0002\u000fQLW.Z8vi\u0006Y2/\u001a8e\u0007>t7/^7fe\u001a+Go\u00195%I\u00164\u0017-\u001e7uIU*\"A!\u001c+\t\u0005\u0015#qN\u0016\u0003\u0005c\u0002BAa\u001d\u0003~5\u0011!Q\u000f\u0006\u0005\u0005o\u0012I(A\u0005v]\u000eDWmY6fI*\u0019!1\u0010-\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0000\tU$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011\u0003O]3qCJ,'+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018I\u001c3M_\u001el\u0015M\\1hKJ$\u0002C!\"\u0003\u0018\ne%Q\u0014BQ\u0005K\u0013\tLa/\u0011\u000f]\u00139I!\u0007\u0003\f&\u0019!\u0011\u0012-\u0003\rQ+\b\u000f\\33!\u0011\u0011iIa%\u000e\u0005\t=%b\u0001BI%\u0006\u0019An\\4\n\t\tU%q\u0012\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\bb\u0002B\u0011_\u0001\u0007\u00111\u0006\u0005\b\u00057{\u0003\u0019AA\u0016\u0003eaW-\u00193fe\u0016\u0003xn\u00195J]2+\u0017\rZ3s\u0003:$\u0017j\u001d:\t\u000f\t}u\u00061\u0001\u0002,\u0005\u0001bm\u001c7m_^,'O\u0011:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0005G{\u0003\u0019AA\u0016\u00039aW-\u00193fe\n\u0013xn[3s\u0013\u0012DqAa*0\u0001\u0004\u0011I+\u0001\bd_VtG\u000fR8x]2\u000bGo\u00195\u0011\t\t-&QV\u0007\u0003\u0003;LAAa,\u0002^\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0007b\u0002BZ_\u0001\u0007!QW\u0001\u0011Kb\u0004Xm\u0019;UeVt7-\u0019;j_:\u00042a\u0016B\\\u0013\r\u0011I\f\u0017\u0002\b\u0005>|G.Z1o\u0011%\u0011il\fI\u0001\u0002\u0004\u0011y,\u0001\u0006fqR\u0014\u0018\r\u0015:paN\u0004BA!1\u0003D6\u0011\u0011\u0011]\u0005\u0005\u0005\u000b\f\tO\u0001\u0006Qe>\u0004XM\u001d;jKN\fA\u0006\u001d:fa\u0006\u0014XMU3qY&\u001c\u0017-T1oC\u001e,'/\u00118e\u0019><W*\u00198bO\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t-'\u0006\u0002B`\u0005_\n!\u0004\\3bI\u0016\u0014\u0018I\u001c3JgJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$\"B!5\u0003h\n%(Q\u001eBx!\u0011\u0011\u0019N!9\u000f\t\tU'1\u001c\b\u0005\u0003_\u00149.C\u0002\u0003Zf\fq!\\3tg\u0006<W-\u0003\u0003\u0003^\n}\u0017a\u0006'fC\u0012,'/\u00118e\u0013N\u0014(+Z9vKN$H)\u0019;b\u0015\r\u0011I._\u0005\u0005\u0005G\u0014)O\u0001\u000eMK\u0006$WM]!oI&\u001b(\u000fU1si&$\u0018n\u001c8Ti\u0006$XM\u0003\u0003\u0003^\n}\u0007b\u0002B\u0011c\u0001\u0007!1\u0005\u0005\b\u0005W\f\u0004\u0019AA\u0016\u0003-aW-\u00193fe\u0016\u0003xn\u00195\t\u000f\t\r\u0016\u00071\u0001\u0002,!9!\u0011_\u0019A\u0002\tM\u0018AD1mSZ,'I]8lKJLEm\u001d\t\u0007\u0005k\u0014YPa@\u000e\u0005\t](b\u0001B}1\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tu(q\u001f\u0002\u0004'\u0016\f\bcA2\u0004\u0002%\u001911\u00013\u0003\u000f%sG/Z4fe\nq1)\u00197mE\u0006\u001c7NU3tk2$X\u0003BB\u0005\u0007+\u0019\"A\r,\u0015\u0005\r5\u0001#BB\be\rEQ\"\u0001\u0001\u0011\t\rM1Q\u0003\u0007\u0001\t\u001d\u00199B\rb\u0001\u00073\u0011\u0011\u0001V\t\u0005\u00077\u0019\t\u0003E\u0002X\u0007;I1aa\bY\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aVB\u0012\u0013\r\u0019)\u0003\u0017\u0002\u0004\u0003:L\u0018!\u0002<bYV,WCAB\u0016!\u00159&QKB\t\u0003%1\u0018\r\\;f?\u0012*\u0017\u000f\u0006\u0003\u0002\u001c\rE\u0002\"CA\u0012k\u0005\u0005\t\u0019AB\u0016\u0003\u00191\u0018\r\\;fA\u0005\u0019a-\u001e8\u0016\u0005\re\u0002#B,\u0003V\rm\u0002cB,\u0004>\rE\u00111D\u0005\u0004\u0007\u007fA&!\u0003$v]\u000e$\u0018n\u001c82\u0003\u001d1WO\\0%KF$B!a\u0007\u0004F!I\u00111\u0005\u001d\u0002\u0002\u0003\u00071\u0011H\u0001\u0005MVt\u0007%A\u0006bgN,'\u000f\u001e$je\u0016$WCAB\t\u0003\u001dI7OR5sK\u0012,\"A!.\u0002\t\u0019L'/\u001a\u000b\u0005\u00037\u0019)\u0006C\u0004\u0004(q\u0002\ra!\u0005\u0002\r=tg)\u001b:f)\u0011\u0019iaa\u0017\t\u000f\rUR\b1\u0001\u0004<\u0005i\u0011\r\u001d9f]\u0012\u0014VmY8sIN$Bb!\u0019\u0004d\r\u00154\u0011NB=\u0007{\u0002Raa\u00043\u0003SDqAa\u0006?\u0001\u0004\u0011I\u0002C\u0004\u0004hy\u0002\rAa\t\u0002\u0013A\f'\u000f^5uS>t\u0007bBB6}\u0001\u00071QN\u0001\be\u0016\u001cwN\u001d3t!\u0011\u0019yg!\u001e\u000e\u0005\rE$bAB:s\u00061!/Z2pe\u0012LAaa\u001e\u0004r\tiQ*Z7pef\u0014VmY8sIND\u0011ba\u001f?!\u0003\u0005\rA!.\u0002\u0019%\u001chI]8n\u00072LWM\u001c;\t\u0013\r}d\b%AA\u0002\r\u0005\u0015\u0001\u0004:fcVL'/\u001a3BG.\u001c\bcA,\u0004\u0004&\u00191Q\u0011-\u0003\u000bMCwN\u001d;\u0002/\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\"TCABFU\u0011\u0011)La\u001c\u0002/\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012*TCABIU\u0011\u0019\tIa\u001c\u0002\u001f\u0019,Go\u00195Bg\u000e{gn];nKJ$bba&\u0004\u001a\u000em5QTBR\u0007O\u001b\t\fE\u0003\u0004\u0010I\u0012\t\u0004C\u0004\u0003\u0018\u0005\u0003\rA!\u0007\t\u000f\r\u001d\u0014\t1\u0001\u0003$!9!QH!A\u0002\r}\u0005\u0003BBQ\u0005\u0013rA!!<\u0003F!I1QU!\u0011\u0002\u0003\u0007\u00111F\u0001\t[&t')\u001f;fg\"I1\u0011V!\u0011\u0002\u0003\u000711V\u0001\u000fSN|G.\u0019;j_:dUM^3m!\u0011\u0011\u0019e!,\n\t\r=&Q\u0002\u0002\u000f\u0013N|G.\u0019;j_:dUM^3m\u0011%\u0019\u0019,\u0011I\u0001\u0002\u0004\u0011\u0019&\u0001\bdY&,g\u000e^'fi\u0006$\u0017\r^1\u00023\u0019,Go\u00195Bg\u000e{gn];nKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0007sSC!a\u000b\u0003p\u0005Ib-\u001a;dQ\u0006\u001b8i\u001c8tk6,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019yL\u000b\u0003\u0004,\n=\u0014!\u00074fi\u000eD\u0017i]\"p]N,X.\u001a:%I\u00164\u0017-\u001e7uIY*\"a!2+\t\tM#qN\u0001\u0010M\u0016$8\r[!t\r>dGn\\<feRq1qSBf\u0007\u001b\u001cym!5\u0004T\u000eU\u0007b\u0002B\f\u000b\u0002\u0007!\u0011\u0004\u0005\b\u0007O*\u0005\u0019\u0001B\u0012\u0011\u001d\u0011i$\u0012a\u0001\u0007?C\u0011b!*F!\u0003\u0005\r!a\u000b\t\u0013\r%V\t%AA\u0002\r-\u0006\"CBZ\u000bB\u0005\t\u0019\u0001B*\u0003e1W\r^2i\u0003N4u\u000e\u001c7po\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00023\u0019,Go\u00195Bg\u001a{G\u000e\\8xKJ$C-\u001a4bk2$H%N\u0001\u001aM\u0016$8\r[!t\r>dGn\\<fe\u0012\"WMZ1vYR$c'A\u0007gKR\u001c\u0007.T3tg\u0006<Wm\u001d\u000b\u0011\u0007/\u001b\toa9\u0004h\u000e%81^Bw\u0007_DqAa\u0006J\u0001\u0004\u0011I\u0002C\u0004\u0004f&\u0003\r!a\u000b\u0002\u0013I,\u0007\u000f\\5dC&#\u0007bBB4\u0013\u0002\u0007!1\u0005\u0005\b\u0005{I\u0005\u0019ABP\u0011\u001d\u0019)+\u0013a\u0001\u0003WAqa!+J\u0001\u0004\u0019Y\u000bC\u0004\u00044&\u0003\rAa\u0015\u0002QM,G/\u001e9SKBd\u0017nY1NC:\fw-\u001a:XSRDWj\\2lK\u0012\u0004VO]4bi>\u0014\u0018.Z:\u0015\r\te1Q\u001fC\u0002\u0011\u001d\u00199P\u0013a\u0001\u0007s\fQ\u0001^5nKJ\u0004Baa?\u0004\u00006\u00111Q \u0006\u0004\u0007o|\u0017\u0002\u0002C\u0001\u0007{\u0014\u0011\"T8dWRKW.\u001a:\t\u0013\tE(\n%AA\u0002\u0011\u0015\u0001C\u0002B{\u0005w\fY#\u0001\u001atKR,\bOU3qY&\u001c\u0017-T1oC\u001e,'oV5uQ6{7m[3e!V\u0014x-\u0019;pe&,7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t!YA\u000b\u0003\u0005\u0006\t=\u0014a\f;fgR|E\u000e\u001a'fC\u0012,'\u000fT8tKNlU\r\u001e:jGN<\u0006.\u001a8SK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:\u001c\bf\u0001'\u0002n\u0005\tD/Z:u\u001f2$gi\u001c7m_^,'\u000fT8tKNlU\r\u001e:jGN<\u0006.\u001a8SK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:\u001c\bfA'\u0002n\u0005I\u0004O]3qCJ,G)\u001b4gKJ,g\u000e\u001e*fa2L7-Y'b]\u0006<WM]:XSRDWj\\2lK\u0012\u0014%o\\6feR{\u0007/[2Ti\u0006$8\u000f\u0006\u0002\u0005\u001aAYq\u000bb\u0007\u0003\u001a\teAq\u0004C\u0010\u0013\r!i\u0002\u0017\u0002\u0007)V\u0004H.\u001a\u001b\u0011\u0007}#\t#C\u0002\u0005$A\u0013\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:")
public class ReplicaManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private KafkaZkClient kafkaZkClient;
    private final int zkVersion;
    private final int correlationId;
    private int controllerEpoch = 0;
    private final long brokerEpoch;

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public KafkaZkClient kafkaZkClient() {
        return this.kafkaZkClient;
    }

    public void kafkaZkClient_$eq(KafkaZkClient x$1) {
        this.kafkaZkClient = x$1;
    }

    public int zkVersion() {
        return this.zkVersion;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @Before
    public void setUp() {
        this.kafkaZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        EasyMock.expect((Object)this.kafkaZkClient().getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.kafkaZkClient()});
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            rm.createPartition(new TopicPartition(this.topic(), 1)).createLogIfNotExists(1, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(rm.highWatermarkCheckpoints()));
            rm.checkpointHighWatermarks();
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$2 -> new File((String)x$2), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            rm.createPartition(new TopicPartition(this.topic(), 1)).createLogIfNotExists(1, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(rm.highWatermarkCheckpoints()));
            rm.checkpointHighWatermarks();
        }
        finally {
            rm.shutdown(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$3 -> new File((String)x$3), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            MemoryRecords memoryRecords = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())});
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            rm.appendRecords(0L, (short)3, false, true, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Function1 & Serializable & scala.Serializable)responseStatus -> {
                ReplicaManagerTest.callback$1(responseStatus);
                return BoxedUnit.UNIT;
            }, rm.appendRecords$default$7(), rm.appendRecords$default$8());
        }
        finally {
            rm.shutdown(false);
        }
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testClearPurgatoryOnBecomingFollower() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$4 -> new File((String)x$4), Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            rm.createPartition(new TopicPartition(this.topic(), 0)).createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(rm.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$2(x$5, x$6);
                return BoxedUnit.UNIT;
            });
            rm.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())});
            CallbackResult<ProduceResponse.PartitionResponse> appendResult = this.appendRecords(rm, new TopicPartition(this.topic(), 0), records, this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$3(response);
                return BoxedUnit.UNIT;
            });
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$4(x$7, x$8);
                return BoxedUnit.UNIT;
            });
            Assert.assertTrue((boolean)appendResult.isFired());
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testReceiveOutOfOrderSequenceExceptionWithLogStartOffset() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.createPartition(new TopicPartition(this.topic(), 0));
            partition.createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> {
                ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$1(x$9, x$10);
                return BoxedUnit.UNIT;
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, numRecords);
            if (range == null) {
                throw null;
            }
            Range foreach_this = range;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2(this, producerId, epoch, replicaManager, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            Assert.assertEquals((long)0L, (long)partition.logStartOffset());
            int outOfRangeSequence = numRecords + 10;
            MemoryRecords record = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)epoch, (int)outOfRangeSequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(9).append("message: ").append(outOfRangeSequence).toString().getBytes())});
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), record, this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$4(response);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testReadCommittedFetchLimitedAtLSO() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            replicaManager.createPartition(new TopicPartition(this.topic(), 0)).createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$11, x$12) -> {
                ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$1(x$11, x$12);
                return BoxedUnit.UNIT;
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, numRecords);
            if (range == null) {
                throw null;
            }
            Range foreach_this = range;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$2(this, producerId, epoch, replicaManager, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            TopicPartition x$2 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$3 = new FetchRequest.PartitionData((long)numRecords, 0L, 100000, Optional.empty());
            IsolationLevel x$4 = IsolationLevel.READ_UNCOMMITTED;
            int x$5 = this.fetchAsFollower$default$4();
            Option<ClientMetadata> x$6 = this.fetchAsFollower$default$6();
            this.fetchAsFollower(replicaManager, x$2, x$3, x$5, x$4, x$6);
            TopicPartition x$8 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$9 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$10 = IsolationLevel.READ_COMMITTED;
            int x$112 = this.fetchAsConsumer$default$4();
            Option<ClientMetadata> x$122 = this.fetchAsConsumer$default$6();
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(replicaManager, x$8, x$9, x$112, x$10, x$122);
            FetchPartitionData fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            TopicPartition x$14 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$15 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$16 = IsolationLevel.READ_COMMITTED;
            int x$17 = 1000;
            Option<ClientMetadata> x$18 = this.fetchAsConsumer$default$6();
            consumerFetchResult = this.fetchAsConsumer(replicaManager, x$14, x$15, x$17, x$16, x$18);
            Assert.assertFalse((boolean)consumerFetchResult.isFired());
            timer.advanceClock(1001L);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
            MemoryRecords commitRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), commitRecordBatch, false, this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$4(response);
                return BoxedUnit.UNIT;
            });
            TopicPartition x$20 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$21 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$22 = IsolationLevel.READ_COMMITTED;
            int x$23 = this.fetchAsConsumer$default$4();
            Option<ClientMetadata> x$24 = this.fetchAsConsumer$default$6();
            consumerFetchResult = this.fetchAsConsumer(replicaManager, x$20, x$21, x$23, x$22, x$24);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            TopicPartition x$26 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$27 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000, Optional.empty());
            IsolationLevel x$28 = IsolationLevel.READ_UNCOMMITTED;
            int x$29 = this.fetchAsFollower$default$4();
            Option<ClientMetadata> x$30 = this.fetchAsFollower$default$6();
            this.fetchAsFollower(replicaManager, x$26, x$27, x$29, x$28, x$30);
            TopicPartition x$32 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$33 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$34 = IsolationLevel.READ_COMMITTED;
            int x$35 = this.fetchAsConsumer$default$4();
            Option<ClientMetadata> x$36 = this.fetchAsConsumer$default$6();
            consumerFetchResult = this.fetchAsConsumer(replicaManager, x$32, x$33, x$35, x$34, x$36);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).size());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testDelayedFetchIncludesAbortedTransactions() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            replicaManager.createPartition(new TopicPartition(this.topic(), 0)).createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> {
                ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$1(x$13, x$14);
                return BoxedUnit.UNIT;
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            int n = 0;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range range = RichInt$.MODULE$.until$extension0(n, numRecords);
            if (range == null) {
                throw null;
            }
            Range foreach_this = range;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$2(this, producerId, epoch, replicaManager, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
            MemoryRecords abortRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), abortRecordBatch, false, this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$4(response);
                return BoxedUnit.UNIT;
            });
            TopicPartition x$2 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$3 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000, Optional.empty());
            IsolationLevel x$4 = IsolationLevel.READ_UNCOMMITTED;
            int x$5 = this.fetchAsFollower$default$4();
            Option<ClientMetadata> x$6 = this.fetchAsFollower$default$6();
            this.fetchAsFollower(replicaManager, x$2, x$3, x$5, x$4, x$6);
            TopicPartition x$8 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$9 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$10 = IsolationLevel.READ_COMMITTED;
            int x$11 = 10000;
            Option<ClientMetadata> x$12 = this.fetchAsConsumer$default$6();
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(replicaManager, x$8, x$9, x$11, x$10, x$12);
            Assert.assertFalse((boolean)fetchResult.isFired());
            timer.advanceClock(1001L);
            FetchPartitionData fetchData = fetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().records()).asScala()).size());
            Assert.assertTrue((boolean)fetchData.abortedTransactions().isDefined());
            Assert.assertEquals((long)1L, (long)((SeqLike)fetchData.abortedTransactions().get()).size());
            FetchResponse.AbortedTransaction abortedTransaction = (FetchResponse.AbortedTransaction)((IterableLike)fetchData.abortedTransactions().get()).head();
            Assert.assertEquals((long)0L, (long)abortedTransaction.firstOffset);
            Assert.assertEquals((long)producerId, (long)abortedTransaction.producerId);
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testFetchBeyondHighWatermarkReturnEmptyResponse() {
        ReplicaManager rm = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            rm.createPartition(new TopicPartition(this.topic(), 0)).createLogIfNotExists(0, false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(rm.highWatermarkCheckpoints()));
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1), new Node(2, "host2", 2)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$15, x$16) -> {
                ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$1(x$15, x$16);
                return BoxedUnit.UNIT;
            });
            rm.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localLogOrException();
            int n = 1;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 2);
            if (inclusive == null) {
                throw null;
            }
            Range.Inclusive foreach_this = inclusive;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2(this, rm, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            FetchPartitionData followerFetchData = this.fetchAsFollower(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()), this.fetchAsFollower$default$4(), this.fetchAsFollower$default$5(), this.fetchAsFollower$default$6()).assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)followerFetchData.error());
            Assert.assertTrue((String)"Should return some data", (boolean)followerFetchData.records().batches().iterator().hasNext());
            FetchPartitionData consumerFetchData = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()), this.fetchAsConsumer$default$4(), this.fetchAsConsumer$default$5(), this.fetchAsConsumer$default$6()).assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)consumerFetchData.error());
            Assert.assertEquals((String)"Should return empty response", (Object)MemoryRecords.EMPTY, (Object)consumerFetchData.records());
        }
        finally {
            rm.shutdown(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFollowerStateNotUpdatedIfLogReadFails() {
        int maxFetchBytes = 0x100000;
        Seq aliveBrokersIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        int leaderEpoch = 5;
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)aliveBrokersIds);
        try {
            void $minus$greater$extension_$this;
            void $minus$greater$extension_$this2;
            Object object;
            void map_bf;
            TopicPartition tp = new TopicPartition(this.topic(), 0);
            List list = aliveBrokersIds.toList();
            CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x -> ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$1(BoxesRunTime.unboxToInt((Object)x));
            if (list == null) {
                throw null;
            }
            List map_this = list;
            if (map_bf == List$.MODULE$.ReusableCBF()) {
                if (map_this == Nil$.MODULE$) {
                    object = Nil$.MODULE$;
                } else {
                    .colon.colon map_h;
                    .colon.colon map_t = map_h = new .colon.colon((Object)ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$1(BoxesRunTime.unboxToInt((Object)map_this.head())), (List)Nil$.MODULE$);
                    for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                        .colon.colon map_nx = new .colon.colon((Object)ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$1(BoxesRunTime.unboxToInt((Object)map_rest.head())), (List)Nil$.MODULE$);
                        map_t.tl_$eq((List)map_nx);
                        map_t = map_nx;
                    }
                    object = map_h;
                }
            } else {
                void map_f;
                object = TraversableLike.map$((TraversableLike)map_this, (Function1)map_f, (CanBuildFrom)map_bf);
            }
            java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava();
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(0).setReplicas(replicas).setIsNew(true);
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{leaderAndIsrPartitionState}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            LeaderAndIsrResponse leaderAndIsrResponse = replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable & scala.Serializable)(x$17, x$18) -> {
                ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$2(x$17, x$18);
                return BoxedUnit.UNIT;
            });
            Assert.assertEquals((Object)Errors.NONE, (Object)leaderAndIsrResponse.error());
            Assert.assertTrue((boolean)replicaManager.nonOfflinePartition(tp).isDefined());
            Partition partition = (Partition)replicaManager.nonOfflinePartition(tp).get();
            Assert.assertTrue((boolean)partition.getReplica(1).isDefined());
            Replica followerReplica = (Replica)partition.getReplica(1).get();
            Assert.assertEquals((long)-1L, (long)followerReplica.logStartOffset());
            Assert.assertEquals((long)-1L, (long)followerReplica.logEndOffset());
            int n = 1;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 5);
            if (inclusive == null) {
                throw null;
            }
            Range.Inclusive foreach_this = inclusive;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$3(this, replicaManager, tp, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            ObjectRef successfulFetch = ObjectRef.create((Object)None$.MODULE$);
            FetchRequest.PartitionData validFetchPartitionData = new FetchRequest.PartitionData(0L, 0L, maxFetchBytes, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)));
            long x$1 = 0L;
            int x$2 = 1;
            int x$3 = 1;
            boolean x$5 = false;
            Tuple2[] tuple2Array = new Tuple2[1];
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)validFetchPartitionData);
            Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
            QuotaFactory.UnboundedQuota$ x$7 = QuotaFactory.UnboundedQuota$.MODULE$;
            IsolationLevel x$8 = IsolationLevel.READ_UNCOMMITTED;
            Function1 & Serializable & scala.Serializable x$9 = (Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.callback$2(response, successfulFetch, tp);
                return BoxedUnit.UNIT;
            };
            None$ x$10 = None$.MODULE$;
            replicaManager.fetchMessages(x$1, x$2, x$3, maxFetchBytes, x$5, x$6, (ReplicaQuota)x$7, (Function1)x$9, x$8, (Option)x$10);
            Assert.assertTrue((boolean)((Option)successfulFetch.elem).isDefined());
            Assert.assertEquals((long)0L, (long)followerReplica.logStartOffset());
            Assert.assertEquals((long)0L, (long)followerReplica.logEndOffset());
            FetchRequest.PartitionData invalidFetchPartitionData = new FetchRequest.PartitionData(3L, 0L, maxFetchBytes, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)));
            long x$11 = 0L;
            int x$12 = 1;
            int x$13 = 1;
            boolean x$15 = false;
            Tuple2[] tuple2Array2 = new Tuple2[1];
            Object object3 = Predef$.MODULE$.ArrowAssoc((Object)tp);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)invalidFetchPartitionData);
            Seq x$16 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
            QuotaFactory.UnboundedQuota$ x$172 = QuotaFactory.UnboundedQuota$.MODULE$;
            IsolationLevel x$182 = IsolationLevel.READ_UNCOMMITTED;
            Function1 & Serializable & scala.Serializable x$19 = (Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.callback$2(response, successfulFetch, tp);
                return BoxedUnit.UNIT;
            };
            None$ x$20 = None$.MODULE$;
            replicaManager.fetchMessages(x$11, x$12, x$13, maxFetchBytes, x$15, x$16, (ReplicaQuota)x$172, (Function1)x$19, x$182, (Option)x$20);
            Assert.assertTrue((boolean)((Option)successfulFetch.elem).isDefined());
            Assert.assertEquals((long)0L, (long)followerReplica.logStartOffset());
            Assert.assertEquals((long)0L, (long)followerReplica.logEndOffset());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchMessagesWhenNotFollowerForOnePartition() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_$this2;
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
            replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
            replicaManager.createPartition(tp1).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
            java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            java.util.List partition1Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(2)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable & scala.Serializable)(x$21, x$22) -> {
                ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$1(x$21, x$22);
                return BoxedUnit.UNIT;
            });
            int n = 1;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 2);
            if (inclusive == null) {
                throw null;
            }
            Range.Inclusive foreach_this = inclusive;
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2(this, replicaManager, tp0, tp1, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                    foreach_i += foreach_this.step();
                }
            }
            Tuple2[] tuple2Array = new Tuple2[2];
            FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty());
            Object object = Predef$.MODULE$.ArrowAssoc((Object)tp0);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            FetchRequest.PartitionData partitionData2 = new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty());
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp1);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            replicaManager.fetchMessages(1000L, 1, 0, Integer.MAX_VALUE, false, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Function1 & Serializable & scala.Serializable)responseStatus -> {
                ReplicaManagerTest.fetchCallback$1(responseStatus, tp0, tp1);
                return BoxedUnit.UNIT;
            }, IsolationLevel.READ_UNCOMMITTED, (Option)None$.MODULE$);
            Option tp0Log = replicaManager.localLog(tp0);
            Assert.assertTrue((boolean)tp0Log.isDefined());
            Assert.assertEquals((String)"hw should be incremented", (long)1L, (long)((Log)tp0Log.get()).highWatermark());
            replicaManager.localLog(tp1);
            Option tp1Replica = replicaManager.localLog(tp1);
            Assert.assertTrue((boolean)tp1Replica.isDefined());
            Assert.assertEquals((String)"hw should not be incremented", (long)0L, (long)((Log)tp1Replica.get()).highWatermark());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBecomeFollowerWhenLeaderIsUnchangedButMissedLeaderUpdate() {
        void var12_12;
        void var11_11;
        int topicPartition = 0;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
        LogManager mockLogMgr = (LogManager)tuple2._2();
        void replicaManager2 = var11_11;
        void mockLogMgr2 = var12_12;
        TopicPartition tp = new TopicPartition(this.topic(), topicPartition);
        Partition partition = replicaManager2.createPartition(tp);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager2.highWatermarkCheckpoints());
        partition.createLogIfNotExists(followerBrokerId, false, false, (OffsetCheckpoints)offsetCheckpoints);
        partition.makeFollower(controllerId, this.leaderAndIsrPartitionState(tp, leaderEpoch, leaderBrokerId, (Seq<Integer>)aliveBrokerIds), this.correlationId(), (OffsetCheckpoints)offsetCheckpoints);
        LeaderAndIsrRequest leaderAndIsrRequest0 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{this.leaderAndIsrPartitionState(tp, leaderEpoch += leaderEpochIncrement, leaderBrokerId, (Seq<Integer>)aliveBrokerIds)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(followerBrokerId, "host1", 0), new Node(leaderBrokerId, "host2", 1)}))).asJava()).build();
        replicaManager2.becomeLeaderOrFollower(this.correlationId(), leaderAndIsrRequest0, (Function2 & Serializable & scala.Serializable)(x$24, followers) -> {
            ReplicaManagerTest.$anonfun$testBecomeFollowerWhenLeaderIsUnchangedButMissedLeaderUpdate$1(followerBrokerId, x$24, followers);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)countDownLatch.await(1000L, TimeUnit.MILLISECONDS));
        EasyMock.verify((Object[])new Object[]{mockLogMgr2});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaSelector() {
        void var10_10;
        int topicPartition = 0;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        int controllerId = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
        TopicPartition tp = new TopicPartition(this.topic(), topicPartition);
        Partition partition = var10_10.createPartition(tp);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(var10_10.highWatermarkCheckpoints());
        partition.createLogIfNotExists(leaderBrokerId, false, false, (OffsetCheckpoints)offsetCheckpoints);
        partition.makeLeader(controllerId, this.leaderAndIsrPartitionState(tp, leaderEpoch, leaderBrokerId, (Seq<Integer>)aliveBrokerIds), this.correlationId(), (OffsetCheckpoints)offsetCheckpoints);
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        ClientMetadata.DefaultClientMetadata metadata = new ClientMetadata.DefaultClientMetadata("rack-a", "client-id", InetAddress.getByName("localhost"), KafkaPrincipal.ANONYMOUS, "default");
        Assert.assertFalse((boolean)var10_10.findPreferredReadReplica(tp0, (ClientMetadata)metadata, Request$.MODULE$.OrdinaryConsumerId(), 1L, System.currentTimeMillis()).isDefined());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreferredReplicaAsFollower() {
        void var8_8;
        int topicPartition = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
        java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        var8_8.createPartition(new TopicPartition(this.topic(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        var8_8.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$25, x$26) -> {
            ReplicaManagerTest.$anonfun$testPreferredReplicaAsFollower$1(x$25, x$26);
            return BoxedUnit.UNIT;
        });
        ClientMetadata.DefaultClientMetadata metadata = new ClientMetadata.DefaultClientMetadata("rack-a", "client-id", InetAddress.getByName("localhost"), KafkaPrincipal.ANONYMOUS, "default");
        FetchRequest.PartitionData x$3 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
        Some x$4 = new Some((Object)metadata);
        int x$5 = this.fetchAsConsumer$default$4();
        IsolationLevel x$6 = this.fetchAsConsumer$default$5();
        CallbackResult<FetchPartitionData> consumerResult = this.fetchAsConsumer((ReplicaManager)var8_8, tp0, x$3, x$5, x$6, (Option<ClientMetadata>)x$4);
        Assert.assertTrue((boolean)consumerResult.isFired());
        Assert.assertTrue((boolean)consumerResult.assertFired().preferredReadReplica().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreferredReplicaAsLeader() {
        void var8_8;
        int topicPartition = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
        java.util.List brokerList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        var8_8.createPartition(new TopicPartition(this.topic(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(brokerList).setZkVersion(0).setReplicas(brokerList).setIsNew(false)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        var8_8.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$27, x$28) -> {
            ReplicaManagerTest.$anonfun$testPreferredReplicaAsLeader$1(x$27, x$28);
            return BoxedUnit.UNIT;
        });
        ClientMetadata.DefaultClientMetadata metadata = new ClientMetadata.DefaultClientMetadata("rack-a", "client-id", InetAddress.getByName("localhost"), KafkaPrincipal.ANONYMOUS, "default");
        FetchRequest.PartitionData x$3 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
        Some x$4 = new Some((Object)metadata);
        int x$5 = this.fetchAsConsumer$default$4();
        IsolationLevel x$6 = this.fetchAsConsumer$default$5();
        CallbackResult<FetchPartitionData> consumerResult = this.fetchAsConsumer((ReplicaManager)var8_8, tp0, x$3, x$5, x$6, (Option<ClientMetadata>)x$4);
        Assert.assertTrue((boolean)consumerResult.isFired());
        Assert.assertFalse((boolean)consumerResult.assertFired().preferredReadReplica().isDefined());
    }

    @Test(expected=ClassNotFoundException.class)
    public void testUnknownReplicaSelector() {
        int topicPartition = 0;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ReplicaSelectorClassProp(), "non-a-class");
        this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, props);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDefaultReplicaSelector() {
        void var8_8;
        int topicPartition = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true, this.prepareReplicaManagerAndLogManager$default$7());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
        Assert.assertFalse((boolean)var8_8.replicaSelectorOpt().isDefined());
    }

    @Test
    public void testFetchFollowerNotAllowedForOlderClients() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeFollowerRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(1).setLeaderEpoch(0).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(0, becomeFollowerRequest, (Function2 & Serializable & scala.Serializable)(x$29, x$30) -> {
            ReplicaManagerTest.$anonfun$testFetchFollowerNotAllowedForOlderClients$1(x$29, x$30);
            return BoxedUnit.UNIT;
        });
        ClientMetadata.DefaultClientMetadata clientMetadata = new ClientMetadata.DefaultClientMetadata("", "", null, KafkaPrincipal.ANONYMOUS, "");
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(0)));
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)new Some((Object)clientMetadata), this.sendConsumerFetch$default$5());
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NONE, (Object)fetchResult.get().error());
        partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(0)));
        fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)None$.MODULE$, this.sendConsumerFetch$default$5());
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)fetchResult.get().error());
    }

    @Test
    public void testBecomeFollowerWhileOldClientFetchInPurgatory() {
        MockTimer mockTimer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(mockTimer, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2 & Serializable & scala.Serializable)(x$31, x$32) -> {
            ReplicaManagerTest.$anonfun$testBecomeFollowerWhileOldClientFetchInPurgatory$1(x$31, x$32);
            return BoxedUnit.UNIT;
        });
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty());
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)None$.MODULE$, 10L);
        Assert.assertNull((Object)fetchResult.get());
        LeaderAndIsrRequest becomeFollowerRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(1).setLeaderEpoch(2).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(0, becomeFollowerRequest, (Function2 & Serializable & scala.Serializable)(x$33, x$34) -> {
            ReplicaManagerTest.$anonfun$testBecomeFollowerWhileOldClientFetchInPurgatory$2(x$33, x$34);
            return BoxedUnit.UNIT;
        });
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)fetchResult.get().error());
    }

    @Test
    public void testBecomeFollowerWhileNewClientFetchInPurgatory() {
        MockTimer mockTimer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(mockTimer, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2 & Serializable & scala.Serializable)(x$35, x$36) -> {
            ReplicaManagerTest.$anonfun$testBecomeFollowerWhileNewClientFetchInPurgatory$1(x$35, x$36);
            return BoxedUnit.UNIT;
        });
        ClientMetadata.DefaultClientMetadata clientMetadata = new ClientMetadata.DefaultClientMetadata("", "", null, KafkaPrincipal.ANONYMOUS, "");
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)));
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)new Some((Object)clientMetadata), 10L);
        Assert.assertNull((Object)fetchResult.get());
        LeaderAndIsrRequest becomeFollowerRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(1).setLeaderEpoch(2).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(0, becomeFollowerRequest, (Function2 & Serializable & scala.Serializable)(x$37, x$38) -> {
            ReplicaManagerTest.$anonfun$testBecomeFollowerWhileNewClientFetchInPurgatory$2(x$37, x$38);
            return BoxedUnit.UNIT;
        });
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.FENCED_LEADER_EPOCH, (Object)fetchResult.get().error());
    }

    @Test
    public void testFetchFromLeaderAlwaysAllowed() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2 & Serializable & scala.Serializable)(x$39, x$40) -> {
            ReplicaManagerTest.$anonfun$testFetchFromLeaderAlwaysAllowed$1(x$39, x$40);
            return BoxedUnit.UNIT;
        });
        ClientMetadata.DefaultClientMetadata clientMetadata = new ClientMetadata.DefaultClientMetadata("", "", null, KafkaPrincipal.ANONYMOUS, "");
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)));
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)new Some((Object)clientMetadata), this.sendConsumerFetch$default$5());
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NONE, (Object)fetchResult.get().error());
        partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty());
        fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)new Some((Object)clientMetadata), this.sendConsumerFetch$default$5());
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NONE, (Object)fetchResult.get().error());
    }

    @Test
    public void testClearFetchPurgatoryOnStopReplica() {
        MockTimer mockTimer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(mockTimer, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2 & Serializable & scala.Serializable)(x$41, x$42) -> {
            ReplicaManagerTest.$anonfun$testClearFetchPurgatoryOnStopReplica$1(x$41, x$42);
            return BoxedUnit.UNIT;
        });
        FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(1)));
        AtomicReference<FetchPartitionData> fetchResult = this.sendConsumerFetch(replicaManager, tp0, partitionData, (Option<ClientMetadata>)None$.MODULE$, 10L);
        Assert.assertNull((Object)fetchResult.get());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.metadataCache().contains(tp0))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        replicaManager.stopReplica(tp0, true);
        Assert.assertNotNull((Object)fetchResult.get());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)fetchResult.get().error());
    }

    @Test
    public void testClearProducePurgatoryOnStopReplica() {
        MockTimer mockTimer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(mockTimer, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))));
        TopicPartition tp0 = new TopicPartition(this.topic(), 0);
        LazyOffsetCheckpoints offsetCheckpoints = new LazyOffsetCheckpoints(replicaManager.highWatermarkCheckpoints());
        replicaManager.createPartition(tp0).createLogIfNotExists(0, false, false, (OffsetCheckpoints)offsetCheckpoints);
        java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
        LeaderAndIsrRequest becomeLeaderRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(0).setLeader(0).setLeaderEpoch(1).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
        replicaManager.becomeLeaderOrFollower(1, becomeLeaderRequest, (Function2 & Serializable & scala.Serializable)(x$43, x$44) -> {
            ReplicaManagerTest.$anonfun$testClearProducePurgatoryOnStopReplica$1(x$43, x$44);
            return BoxedUnit.UNIT;
        });
        AtomicReference<ProduceResponse.PartitionResponse> produceResult = this.sendProducerAppend(replicaManager, tp0);
        Assert.assertNull((Object)produceResult.get());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.metadataCache().contains(tp0))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        replicaManager.stopReplica(tp0, true);
        Assert.assertNotNull((Object)produceResult.get());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)produceResult.get().error);
    }

    /*
     * WARNING - void declaration
     */
    private AtomicReference<ProduceResponse.PartitionResponse> sendProducerAppend(ReplicaManager replicaManager, TopicPartition topicPartition) {
        void var3_3;
        void $minus$greater$extension_$this;
        AtomicReference produceResult = new AtomicReference();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes()), new SimpleRecord("c".getBytes())});
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)records);
        replicaManager.appendRecords(10L, (short)-1, false, true, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.callback$3(response, produceResult, topicPartition);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private AtomicReference<FetchPartitionData> sendConsumerFetch(ReplicaManager replicaManager, TopicPartition topicPartition, FetchRequest.PartitionData partitionData, Option<ClientMetadata> clientMetadataOpt, long timeout) {
        void $minus$greater$extension_$this;
        AtomicReference<FetchPartitionData> fetchResult = new AtomicReference<FetchPartitionData>();
        int x$2 = Request$.MODULE$.OrdinaryConsumerId();
        int x$3 = 1;
        int x$4 = 100;
        boolean x$5 = false;
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)partitionData);
        Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        QuotaFactory.UnboundedQuota$ x$7 = QuotaFactory.UnboundedQuota$.MODULE$;
        IsolationLevel x$8 = IsolationLevel.READ_UNCOMMITTED;
        Function1 & Serializable & scala.Serializable x$9 = (Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.callback$4(response, fetchResult, topicPartition);
            return BoxedUnit.UNIT;
        };
        replicaManager.fetchMessages(timeout, x$2, x$3, x$4, x$5, x$6, (ReplicaQuota)x$7, (Function1)x$9, x$8, clientMetadataOpt);
        return fetchResult;
    }

    private long sendConsumerFetch$default$5() {
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<ReplicaManager, LogManager> prepareReplicaManagerAndLogManager(int topicPartition, int leaderEpochInLeaderAndIsr, int followerBrokerId, int leaderBrokerId, CountDownLatch countDownLatch, boolean expectTruncation, Properties extraProps) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        ((Growable)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(extraProps).asScala());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        int localLogOffset = 10;
        int offsetFromLeader = 5;
        int leaderEpochFromLeader = 3;
        MockScheduler mockScheduler = new MockScheduler((Time)this.time());
        BrokerTopicStats mockBrokerTopicStats = new BrokerTopicStats();
        LogDirFailureChannel mockLogDirFailureChannel = new LogDirFailureChannel(config.logDirs().size());
        Log mockLog = new Log(this, config, mockScheduler, mockBrokerTopicStats, topicPartition, mockLogDirFailureChannel, leaderEpochFromLeader, localLogOffset){
            private final int leaderEpochFromLeader$1;
            private final int localLogOffset$1;

            public Option<OffsetAndEpoch> endOffsetForEpoch(int leaderEpoch) {
                Assert.assertEquals((long)leaderEpoch, (long)this.leaderEpochFromLeader$1);
                return new Some((Object)new OffsetAndEpoch((long)this.localLogOffset$1, this.leaderEpochFromLeader$1));
            }

            public Option<Object> latestEpoch() {
                return new Some((Object)BoxesRunTime.boxToInteger((int)this.leaderEpochFromLeader$1));
            }

            public LogOffsetMetadata logEndOffsetMetadata() {
                return new LogOffsetMetadata((long)this.localLogOffset$1, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3());
            }

            public long logEndOffset() {
                return this.localLogOffset$1;
            }
            {
                this.leaderEpochFromLeader$1 = leaderEpochFromLeader$1;
                this.localLogOffset$1 = localLogOffset$1;
                super(new File(new File((String)config$1.logDirs().head()), new StringBuilder(2).append($outer.topic()).append("-0").toString()), LogConfig$.MODULE$.apply(), 0L, 0L, (Scheduler)mockScheduler$1, mockBrokerTopicStats$1, (Time)$outer.time(), 30000, 30000, new TopicPartition($outer.topic(), topicPartition$3), new ProducerStateManager(new TopicPartition($outer.topic(), topicPartition$3), new File(new File((String)config$1.logDirs().head()), new StringBuilder(1).append($outer.topic()).append("-").append(topicPartition$3).toString()), 30000), mockLogDirFailureChannel$1);
            }
        };
        TopicPartition topicPartitionObj = new TopicPartition(this.topic(), topicPartition);
        LogManager mockLogMgr = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)mockLogMgr.liveLogDirs()).andReturn(config.logDirs().map((Function1 & Serializable & scala.Serializable)x$45 -> new File((String)x$45).getAbsoluteFile(), Seq$.MODULE$.canBuildFrom())).anyTimes();
        EasyMock.expect((Object)mockLogMgr.currentDefaultConfig()).andReturn((Object)LogConfig$.MODULE$.apply());
        EasyMock.expect((Object)mockLogMgr.getOrCreateLog(topicPartitionObj, LogConfig$.MODULE$.apply(), false, false)).andReturn((Object)mockLog).anyTimes();
        if (expectTruncation) {
            void $minus$greater$extension_y4;
            void $minus$greater$extension_$this4;
            Tuple2[] tuple2Array = new Tuple2[1];
            Long l = BoxesRunTime.boxToLong((long)offsetFromLeader);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartitionObj);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
            mockLogMgr.truncateTo((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), false);
            EasyMock.expect((Object)BoxedUnit.UNIT).once();
        }
        mockLogMgr.initializingLog(topicPartitionObj);
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        mockLogMgr.finishedInitializingLog((TopicPartition)EasyMock.eq((Object)topicPartitionObj), (Option)EasyMock.anyObject(), (Function0)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockLogMgr});
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> TestUtils$.MODULE$.createBroker(Predef$.MODULE$.Integer2int(brokerId), new StringBuilder(4).append("host").append(brokerId).toString(), Predef$.MODULE$.Integer2int(brokerId), TestUtils$.MODULE$.createBroker$default$4()), Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        aliveBrokerIds.foreach((Function1 & Serializable & scala.Serializable)brokerId -> EasyMock.expect((Object)metadataCache.getAliveBroker(BoxesRunTime.unboxToInt((Object)EasyMock.eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId)))))).andReturn((Object)Option$.MODULE$.apply((Object)TestUtils$.MODULE$.createBroker(Predef$.MODULE$.Integer2int(brokerId), new StringBuilder(4).append("host").append(brokerId).toString(), Predef$.MODULE$.Integer2int(brokerId), TestUtils$.MODULE$.createBroker$default$4()))).anyTimes());
        Tuple2[] tuple2Array = new Tuple2[2];
        Node node = new Node(leaderBrokerId, "host1", 9092, "rack-a");
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Node node2 = new Node(followerBrokerId, "host2", 9092, "rack-b");
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)followerBrokerId));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        EasyMock.expect((Object)metadataCache.getPartitionReplicaEndpoints((TopicPartition)EasyMock.anyObject(), (ListenerName)EasyMock.anyObject())).andReturn((Object)((TraversableOnce)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).toMap(Predef$.MODULE$.$conforms())).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        MockTimer timer = new MockTimer();
        String x$1 = "Produce";
        boolean x$3 = false;
        int x$4 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$5 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$6 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$1, (Timer)timer, x$4, x$5, x$3, x$6);
        String x$7 = "Fetch";
        boolean x$9 = false;
        int x$10 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$11 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$12 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$7, (Timer)timer, x$10, x$11, x$9, x$12);
        String x$13 = "DeleteRecords";
        boolean x$15 = false;
        int x$16 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$17 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$18 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$13, (Timer)timer, x$16, x$17, x$15, x$18);
        String x$19 = "ElectLeader";
        boolean x$21 = false;
        int x$22 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$23 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$24 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockElectLeaderPurgatory = new DelayedOperationPurgatory(x$19, (Timer)timer, x$22, x$23, x$21, x$24);
        QuotaFactory.QuotaManagers quota = QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "");
        Tuple2[] tuple2Array2 = new Tuple2[1];
        EpochEndOffset epochEndOffset = new EpochEndOffset(leaderEpochFromLeader, (long)offsetFromLeader);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)topicPartitionObj);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ReplicaFetcherMockBlockingSend blockingSend = new ReplicaFetcherMockBlockingSend((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava(), new BrokerEndPoint(1, "host1", 1), (Time)this.time());
        ReplicaManager replicaManager = new ReplicaManager(this, config, mockScheduler, mockLogMgr, quota, mockBrokerTopicStats, metadataCache, mockLogDirFailureChannel, mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, mockElectLeaderPurgatory, blockingSend, leaderEpochInLeaderAndIsr, topicPartition, countDownLatch){
            private final /* synthetic */ ReplicaManagerTest $outer;
            public final QuotaFactory.QuotaManagers quota$1;
            public final ReplicaFetcherMockBlockingSend blockingSend$1;
            public final int leaderEpochInLeaderAndIsr$1;
            public final int topicPartition$3;
            public final CountDownLatch countDownLatch$1;

            public ReplicaFetcherManager createReplicaFetcherManager(Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager) {
                return new ReplicaFetcherManager(this, metrics, time, threadNamePrefix, quotaManager){
                    private final /* synthetic */ $anon$2 $outer;
                    public final Metrics metrics$1;
                    public final Time time$1;

                    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                        return new ReplicaFetcherThread(this, fetcherId, sourceBroker){
                            private final /* synthetic */ $anon$2$$anon$3 $outer;

                            /*
                             * WARNING - void declaration
                             */
                            public void doWork() {
                                void $minus$greater$extension_$this;
                                OffsetAndEpoch initialOffset = new OffsetAndEpoch(0L, this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().leaderEpochInLeaderAndIsr$1);
                                Tuple2[] tuple2Array = new Tuple2[1];
                                Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().kafka$server$ReplicaManagerTest$$anon$$$outer().topic(), this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().topicPartition$3));
                                if (Predef.ArrowAssoc$.MODULE$ == null) {
                                    throw null;
                                }
                                tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)initialOffset);
                                this.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
                                super.doWork();
                                this.initiateShutdown();
                                this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().countDownLatch$1.countDown();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                super(new StringBuilder(21).append("ReplicaFetcherThread-").append(fetcherId$1).toString(), fetcherId$1, sourceBroker$1, $outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().config(), $outer.failedPartitions(), $outer.replicaManager(), $outer.metrics$1, $outer.time$1, (ReplicaQuota)$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().quota$1.follower(), (Option)new Some((Object)$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().blockingSend$1));
                            }
                        };
                    }

                    public /* synthetic */ $anon$2 kafka$server$ReplicaManagerTest$$anon$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.metrics$1 = metrics$1;
                        this.time$1 = time$1;
                        super($outer.config(), (ReplicaManager)$outer, metrics$1, time$1, threadNamePrefix$1, quotaManager$1);
                    }
                };
            }

            public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.quota$1 = quota$1;
                this.blockingSend$1 = blockingSend$1;
                this.leaderEpochInLeaderAndIsr$1 = leaderEpochInLeaderAndIsr$1;
                this.topicPartition$3 = topicPartition$3;
                this.countDownLatch$1 = countDownLatch$1;
                super(config$1, $outer.metrics(), (Time)$outer.time(), $outer.kafkaZkClient(), (Scheduler)mockScheduler$1, mockLogMgr$1, new AtomicBoolean(false), quota$1, mockBrokerTopicStats$1, metadataCache$1, mockLogDirFailureChannel$1, mockProducePurgatory$1, mockFetchPurgatory$1, mockDeleteRecordsPurgatory$1, mockElectLeaderPurgatory$1, Option$.MODULE$.apply((Object)$outer.getClass().getName()));
            }
        };
        return new Tuple2((Object)replicaManager, (Object)mockLogMgr);
    }

    private Properties prepareReplicaManagerAndLogManager$default$7() {
        return new Properties();
    }

    private LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderAndIsrPartitionState(TopicPartition topicPartition, int leaderEpoch, int leaderBrokerId, Seq<Integer> aliveBrokerIds) {
        return new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(topicPartition.partition()).setControllerEpoch(this.controllerEpoch()).setLeader(leaderBrokerId).setLeaderEpoch(leaderEpoch).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(aliveBrokerIds).asJava()).setZkVersion(this.zkVersion()).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(aliveBrokerIds).asJava()).setIsNew(false);
    }

    /*
     * WARNING - void declaration
     */
    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records, boolean isFromClient, short requiredAcks) {
        void $minus$greater$extension_$this;
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)records);
        replicaManager.appendRecords(1000L, requiredAcks, false, isFromClient, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Function1 & Serializable & scala.Serializable)responses -> {
            ReplicaManagerTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8());
        return result;
    }

    private boolean appendRecords$default$4() {
        return true;
    }

    private short appendRecords$default$5() {
        return -1;
    }

    private CallbackResult<FetchPartitionData> fetchAsConsumer(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel, Option<ClientMetadata> clientMetadata) {
        return this.fetchMessages(replicaManager, -1, partition, partitionData, minBytes, isolationLevel, clientMetadata);
    }

    private int fetchAsConsumer$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsConsumer$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private Option<ClientMetadata> fetchAsConsumer$default$6() {
        return None$.MODULE$;
    }

    private CallbackResult<FetchPartitionData> fetchAsFollower(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel, Option<ClientMetadata> clientMetadata) {
        return this.fetchMessages(replicaManager, 1, partition, partitionData, minBytes, isolationLevel, clientMetadata);
    }

    private int fetchAsFollower$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsFollower$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private Option<ClientMetadata> fetchAsFollower$default$6() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private CallbackResult<FetchPartitionData> fetchMessages(ReplicaManager replicaManager, int replicaId, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel, Option<ClientMetadata> clientMetadata) {
        void $minus$greater$extension_$this;
        CallbackResult<FetchPartitionData> result = new CallbackResult<FetchPartitionData>();
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)partitionData);
        replicaManager.fetchMessages(1000L, replicaId, minBytes, Integer.MAX_VALUE, false, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Function1 & Serializable & scala.Serializable)responseStatus -> {
            ReplicaManagerTest.fetchCallback$2(responseStatus, partition, result);
            return BoxedUnit.UNIT;
        }, isolationLevel, clientMetadata);
        return result;
    }

    private ReplicaManager setupReplicaManagerWithMockedPurgatories(MockTimer timer, Seq<Object> aliveBrokerIds) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$47 -> new File((String)x$47), Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> TestUtils$.MODULE$.createBroker(BoxesRunTime.unboxToInt((Object)brokerId), new StringBuilder(4).append("host").append(BoxesRunTime.unboxToInt((Object)brokerId)).toString(), BoxesRunTime.unboxToInt((Object)brokerId), TestUtils$.MODULE$.createBroker$default$4()), Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)metadataCache.getAliveBrokers()).thenReturn((Object)aliveBrokers);
        aliveBrokerIds.foreach((Function1 & Serializable & scala.Serializable)brokerId -> ReplicaManagerTest.$anonfun$setupReplicaManagerWithMockedPurgatories$3(metadataCache, BoxesRunTime.unboxToInt((Object)brokerId)));
        String x$1 = "Produce";
        boolean x$3 = false;
        int x$4 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$5 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$6 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$1, (Timer)timer, x$4, x$5, x$3, x$6);
        String x$7 = "Fetch";
        boolean x$9 = false;
        int x$10 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$11 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$12 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$7, (Timer)timer, x$10, x$11, x$9, x$12);
        String x$13 = "DeleteRecords";
        boolean x$15 = false;
        int x$16 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$17 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$18 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$13, (Timer)timer, x$16, x$17, x$15, x$18);
        String x$19 = "DelayedElectLeader";
        boolean x$21 = false;
        int x$22 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$23 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$24 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDelayedElectLeaderPurgatory = new DelayedOperationPurgatory(x$19, (Timer)timer, x$22, x$23, x$21, x$24);
        return new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, mockDelayedElectLeaderPurgatory, Option$.MODULE$.apply((Object)this.getClass().getName()));
    }

    private Seq<Object> setupReplicaManagerWithMockedPurgatories$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOldLeaderLosesMetricsWhenReassignPartitions() {
        void var9_9;
        void var8_8;
        void var7_7;
        int controllerEpoch = 0;
        int leaderEpoch = 0;
        int leaderEpochIncrement = 1;
        int correlationId = 0;
        int controllerId = 0;
        Tuple4<ReplicaManager, ReplicaManager, BrokerTopicStats, BrokerTopicStats> tuple4 = this.prepareDifferentReplicaManagersWithMockedBrokerTopicStats();
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        ReplicaManager rm0 = (ReplicaManager)tuple4._1();
        ReplicaManager rm1 = (ReplicaManager)tuple4._2();
        BrokerTopicStats mockTopicStats1 = (BrokerTopicStats)tuple4._4();
        void rm02 = var7_7;
        void rm12 = var8_8;
        void mockTopicStats12 = var9_9;
        mockTopicStats12.removeOldLeaderMetrics(this.topic());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid().once();
        EasyMock.replay((Object[])new Object[]{mockTopicStats12});
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            java.util.List partition1Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(leaderEpoch).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host0", 0), new Node(1, "host1", 1)}))).asJava()).build();
            rm02.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$49, x$50) -> {
                ReplicaManagerTest.$anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$1(x$49, x$50);
                return BoxedUnit.UNIT;
            });
            rm12.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$51, x$52) -> {
                ReplicaManagerTest.$anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$2(x$51, x$52);
                return BoxedUnit.UNIT;
            });
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch + leaderEpochIncrement).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch + leaderEpochIncrement).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host0", 0), new Node(1, "host1", 1)}))).asJava()).build();
            rm02.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$53, x$54) -> {
                ReplicaManagerTest.$anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$3(x$53, x$54);
                return BoxedUnit.UNIT;
            });
            rm12.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$55, x$56) -> {
                ReplicaManagerTest.$anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$4(x$55, x$56);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            rm02.shutdown(rm02.shutdown$default$1());
            rm12.shutdown(rm12.shutdown$default$1());
        }
        EasyMock.verify((Object[])new Object[]{mockTopicStats12});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOldFollowerLosesMetricsWhenReassignPartitions() {
        void var9_9;
        void var8_8;
        void var7_7;
        int controllerEpoch = 0;
        int leaderEpoch = 0;
        int leaderEpochIncrement = 1;
        int correlationId = 0;
        int controllerId = 0;
        Tuple4<ReplicaManager, ReplicaManager, BrokerTopicStats, BrokerTopicStats> tuple4 = this.prepareDifferentReplicaManagersWithMockedBrokerTopicStats();
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        ReplicaManager rm0 = (ReplicaManager)tuple4._1();
        ReplicaManager rm1 = (ReplicaManager)tuple4._2();
        BrokerTopicStats mockTopicStats1 = (BrokerTopicStats)tuple4._4();
        void rm02 = var7_7;
        void rm12 = var8_8;
        void mockTopicStats12 = var9_9;
        mockTopicStats12.removeOldLeaderMetrics(this.topic());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid().once();
        mockTopicStats12.removeOldFollowerMetrics(this.topic());
        EasyMock.expect((Object)BoxedUnit.UNIT).andVoid().once();
        EasyMock.replay((Object[])new Object[]{mockTopicStats12});
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            java.util.List partition0Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}))).asJava();
            java.util.List partition1Replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 0, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(leaderEpoch).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(leaderEpoch).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host0", 0), new Node(1, "host1", 1)}))).asJava()).build();
            rm02.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$58, x$59) -> {
                ReplicaManagerTest.$anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$1(x$58, x$59);
                return BoxedUnit.UNIT;
            });
            rm12.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$60, x$61) -> {
                ReplicaManagerTest.$anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$2(x$60, x$61);
                return BoxedUnit.UNIT;
            });
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp0.topic()).setPartitionIndex(tp0.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch + leaderEpochIncrement).setIsr(partition0Replicas).setZkVersion(0).setReplicas(partition0Replicas).setIsNew(true), new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp1.topic()).setPartitionIndex(tp1.partition()).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(leaderEpoch + leaderEpochIncrement).setIsr(partition1Replicas).setZkVersion(0).setReplicas(partition1Replicas).setIsNew(true)}))).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host0", 0), new Node(1, "host1", 1)}))).asJava()).build();
            rm02.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$62, x$63) -> {
                ReplicaManagerTest.$anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$3(x$62, x$63);
                return BoxedUnit.UNIT;
            });
            rm12.becomeLeaderOrFollower(correlationId, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$64, x$65) -> {
                ReplicaManagerTest.$anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$4(x$64, x$65);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            rm02.shutdown(rm02.shutdown$default$1());
            rm12.shutdown(rm12.shutdown$default$1());
        }
        EasyMock.verify((Object[])new Object[]{mockTopicStats12});
    }

    private Tuple4<ReplicaManager, ReplicaManager, BrokerTopicStats, BrokerTopicStats> prepareDifferentReplicaManagersWithMockedBrokerTopicStats() {
        Properties props0 = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        Properties props1 = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props0.put("log0.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        props1.put("log1.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config0 = KafkaConfig$.MODULE$.fromProps(props0);
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(props1);
        LogManager mockLogMgr0 = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config0.logDirs().map((Function1 & Serializable & scala.Serializable)x$66 -> new File((String)x$66), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        LogManager mockLogMgr1 = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config1.logDirs().map((Function1 & Serializable & scala.Serializable)x$67 -> new File((String)x$67), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        BrokerTopicStats mockTopicStats0 = (BrokerTopicStats)EasyMock.createMock(BrokerTopicStats.class);
        BrokerTopicStats mockTopicStats1 = (BrokerTopicStats)EasyMock.createMock(BrokerTopicStats.class);
        MetadataCache metadataCache0 = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        MetadataCache metadataCache1 = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        EasyMock.expect((Object)metadataCache0.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache0});
        EasyMock.expect((Object)metadataCache1.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache1});
        ReplicaManager rm0 = new ReplicaManager(config0, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr0, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config0, this.metrics(), (Time)this.time(), ""), mockTopicStats0, metadataCache0, new LogDirFailureChannel(config0.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        ReplicaManager rm1 = new ReplicaManager(config1, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr1, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config1, this.metrics(), (Time)this.time(), ""), mockTopicStats1, metadataCache1, new LogDirFailureChannel(config1.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        return new Tuple4((Object)rm0, (Object)rm1, (Object)mockTopicStats0, (Object)mockTopicStats1);
    }

    private static final void callback$1(Map responseStatus) {
        Errors errors = ((ProduceResponse.PartitionResponse)responseStatus.values().head()).error;
        Errors errors2 = Errors.INVALID_REQUIRED_ACKS;
        Predef$.MODULE$.assert(!(errors != null ? !errors.equals(errors2) : errors2 != null));
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$2(Iterable x$5, Iterable x$6) {
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$4(Iterable x$7, Iterable x$8) {
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$1(Iterable x$9, Iterable x$10) {
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2(ReplicaManagerTest $this, long producerId$1, short epoch$1, ReplicaManager replicaManager$1, int sequence) {
        MemoryRecords records = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId$1, (short)epoch$1, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(8).append("message ").append(sequence).toString().getBytes())});
        return $this.appendRecords(replicaManager$1, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.OUT_OF_ORDER_SEQUENCE_NUMBER, (Object)response.error);
        Assert.assertEquals((long)0L, (long)response.logStartOffset);
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$1(Iterable x$11, Iterable x$12) {
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReadCommittedFetchLimitedAtLSO$2(ReplicaManagerTest $this, long producerId$2, short epoch$2, ReplicaManager replicaManager$2, int sequence) {
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$2, (short)epoch$2, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(8).append("message ").append(sequence).toString().getBytes())});
        return $this.appendRecords(replicaManager$2, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$1(Iterable x$13, Iterable x$14) {
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testDelayedFetchIncludesAbortedTransactions$2(ReplicaManagerTest $this, long producerId$3, short epoch$3, ReplicaManager replicaManager$3, int sequence) {
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$3, (short)epoch$3, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(8).append("message ").append(sequence).toString().getBytes())});
        return $this.appendRecords(replicaManager$3, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$1(Iterable x$15, Iterable x$16) {
    }

    public static final /* synthetic */ void $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2(ReplicaManagerTest $this, ReplicaManager rm$1, int i) {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(new StringBuilder(8).append("message ").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return $this.appendRecords(rm$1, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Integer $anonfun$testFollowerStateNotUpdatedIfLogReadFails$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ void $anonfun$testFollowerStateNotUpdatedIfLogReadFails$2(Iterable x$17, Iterable x$18) {
    }

    public static final /* synthetic */ void $anonfun$testFollowerStateNotUpdatedIfLogReadFails$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFollowerStateNotUpdatedIfLogReadFails$3(ReplicaManagerTest $this, ReplicaManager replicaManager$4, TopicPartition tp$1, int i) {
        return $this.appendRecords(replicaManager$4, tp$1, TestUtils$.MODULE$.singletonRecords(new StringBuilder(8).append("message ").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$4(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testFollowerStateNotUpdatedIfLogReadFails$5(TopicPartition tp$1, Tuple2 x$19) {
        Object object = x$19._1();
        return !(object != null ? !object.equals(tp$1) : tp$1 != null);
    }

    public static final /* synthetic */ FetchPartitionData $anonfun$testFollowerStateNotUpdatedIfLogReadFails$6(Tuple2 x$20) {
        return (FetchPartitionData)x$20._2();
    }

    private static final void callback$2(Seq response, ObjectRef successfulFetch$1, TopicPartition tp$1) {
        Tuple2 tuple2;
        Option option = response.headOption();
        if (option == null) {
            throw null;
        }
        Option filter_this = option;
        Object object = filter_this.isEmpty() || ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$5(tp$1, tuple2 = (Tuple2)filter_this.get()) ? filter_this : None$.MODULE$;
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? None$.MODULE$ : new Some((Object)ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$6((Tuple2)object.get()));
        successfulFetch$1.elem = object2;
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$1(Iterable x$21, Iterable x$22) {
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2(ReplicaManagerTest $this, ReplicaManager replicaManager$5, TopicPartition tp0$1, TopicPartition tp1$1, int i) {
        $this.appendRecords(replicaManager$5, tp0$1, TestUtils$.MODULE$.singletonRecords(new StringBuilder(8).append("message ").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$3(response);
            return BoxedUnit.UNIT;
        });
        return $this.appendRecords(replicaManager$5, tp1$1, TestUtils$.MODULE$.singletonRecords(new StringBuilder(8).append("message ").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$4(response);
            return BoxedUnit.UNIT;
        });
    }

    private static final void fetchCallback$1(Seq responseStatus, TopicPartition tp0$1, TopicPartition tp1$1) {
        scala.collection.immutable.Map responseStatusMap = responseStatus.toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)2L, (long)responseStatus.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0$1, tp1$1})), (Object)responseStatusMap.keySet());
        Option tp0Status = responseStatusMap.get((Object)tp0$1);
        Assert.assertTrue((boolean)tp0Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp0Status.get()).highWatermark());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp0Status.get()).error());
        Assert.assertTrue((boolean)((FetchPartitionData)tp0Status.get()).records().batches().iterator().hasNext());
        Option tp1Status = responseStatusMap.get((Object)tp1$1);
        Assert.assertTrue((boolean)tp1Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp1Status.get()).highWatermark());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp1Status.get()).error());
        Assert.assertFalse((boolean)((FetchPartitionData)tp1Status.get()).records().batches().iterator().hasNext());
    }

    public static final /* synthetic */ void $anonfun$testBecomeFollowerWhenLeaderIsUnchangedButMissedLeaderUpdate$1(int followerBrokerId$1, Iterable x$24, Iterable followers) {
        Assert.assertEquals((long)followerBrokerId$1, (long)((Partition)followers.head()).partitionId());
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplicaAsFollower$1(Iterable x$25, Iterable x$26) {
    }

    public static final /* synthetic */ void $anonfun$testPreferredReplicaAsLeader$1(Iterable x$27, Iterable x$28) {
    }

    public static final /* synthetic */ void $anonfun$testFetchFollowerNotAllowedForOlderClients$1(Iterable x$29, Iterable x$30) {
    }

    public static final /* synthetic */ void $anonfun$testBecomeFollowerWhileOldClientFetchInPurgatory$1(Iterable x$31, Iterable x$32) {
    }

    public static final /* synthetic */ void $anonfun$testBecomeFollowerWhileOldClientFetchInPurgatory$2(Iterable x$33, Iterable x$34) {
    }

    public static final /* synthetic */ void $anonfun$testBecomeFollowerWhileNewClientFetchInPurgatory$1(Iterable x$35, Iterable x$36) {
    }

    public static final /* synthetic */ void $anonfun$testBecomeFollowerWhileNewClientFetchInPurgatory$2(Iterable x$37, Iterable x$38) {
    }

    public static final /* synthetic */ void $anonfun$testFetchFromLeaderAlwaysAllowed$1(Iterable x$39, Iterable x$40) {
    }

    public static final /* synthetic */ void $anonfun$testClearFetchPurgatoryOnStopReplica$1(Iterable x$41, Iterable x$42) {
    }

    public static final /* synthetic */ void $anonfun$testClearProducePurgatoryOnStopReplica$1(Iterable x$43, Iterable x$44) {
    }

    private static final void callback$3(Map response, AtomicReference produceResult$1, TopicPartition topicPartition$1) {
        produceResult$1.set(response.apply((Object)topicPartition$1));
    }

    private static final void callback$4(Seq response, AtomicReference fetchResult$1, TopicPartition topicPartition$2) {
        fetchResult$1.set(response.toMap(Predef$.MODULE$.$conforms()).apply((Object)topicPartition$2));
    }

    private static final void appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assert.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    /*
     * WARNING - void declaration
     */
    private static final void fetchCallback$2(Seq responseStatus, TopicPartition partition$2, CallbackResult result$2) {
        void var5_5;
        void var4_4;
        Assert.assertEquals((long)1L, (long)responseStatus.size());
        Tuple2 tuple2 = (Tuple2)responseStatus.head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        FetchPartitionData fetchData = (FetchPartitionData)tuple2._2();
        void topicPartition2 = var4_4;
        void fetchData2 = var5_5;
        Assert.assertEquals((Object)partition$2, (Object)topicPartition2);
        result$2.fire(fetchData2);
    }

    public static final /* synthetic */ OngoingStubbing $anonfun$setupReplicaManagerWithMockedPurgatories$3(MetadataCache metadataCache$2, int brokerId) {
        return Mockito.when((Object)metadataCache$2.getAliveBroker(brokerId)).thenReturn((Object)Option$.MODULE$.apply((Object)TestUtils$.MODULE$.createBroker(brokerId, new StringBuilder(4).append("host").append(brokerId).toString(), brokerId, TestUtils$.MODULE$.createBroker$default$4())));
    }

    public static final /* synthetic */ void $anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$1(Iterable x$49, Iterable x$50) {
    }

    public static final /* synthetic */ void $anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$2(Iterable x$51, Iterable x$52) {
    }

    public static final /* synthetic */ void $anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$3(Iterable x$53, Iterable x$54) {
    }

    public static final /* synthetic */ void $anonfun$testOldLeaderLosesMetricsWhenReassignPartitions$4(Iterable x$55, Iterable x$56) {
    }

    public static final /* synthetic */ void $anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$1(Iterable x$58, Iterable x$59) {
    }

    public static final /* synthetic */ void $anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$2(Iterable x$60, Iterable x$61) {
    }

    public static final /* synthetic */ void $anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$3(Iterable x$62, Iterable x$63) {
    }

    public static final /* synthetic */ void $anonfun$testOldFollowerLosesMetricsWhenReassignPartitions$4(Iterable x$64, Iterable x$65) {
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
        this.zkVersion = 0;
        this.correlationId = 0;
        this.brokerEpoch = 0L;
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2$adapted(ReplicaManagerTest $this, long producerId$1, short epoch$1, ReplicaManager replicaManager$1, Object sequence) {
        return ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2($this, producerId$1, epoch$1, replicaManager$1, BoxesRunTime.unboxToInt((Object)sequence));
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReadCommittedFetchLimitedAtLSO$2$adapted(ReplicaManagerTest $this, long producerId$2, short epoch$2, ReplicaManager replicaManager$2, Object sequence) {
        return ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$2($this, producerId$2, epoch$2, replicaManager$2, BoxesRunTime.unboxToInt((Object)sequence));
    }

    public static final /* synthetic */ CallbackResult $anonfun$testDelayedFetchIncludesAbortedTransactions$2$adapted(ReplicaManagerTest $this, long producerId$3, short epoch$3, ReplicaManager replicaManager$3, Object sequence) {
        return ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$2($this, producerId$3, epoch$3, replicaManager$3, BoxesRunTime.unboxToInt((Object)sequence));
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2$adapted(ReplicaManagerTest $this, ReplicaManager rm$1, Object i) {
        return ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2($this, rm$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFollowerStateNotUpdatedIfLogReadFails$3$adapted(ReplicaManagerTest $this, ReplicaManager replicaManager$4, TopicPartition tp$1, Object i) {
        return ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$3($this, replicaManager$4, tp$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2$adapted(ReplicaManagerTest $this, ReplicaManager replicaManager$5, TopicPartition tp0$1, TopicPartition tp1$1, Object i) {
        return ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2($this, replicaManager$5, tp0$1, tp1$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testFollowerStateNotUpdatedIfLogReadFails$5$adapted(TopicPartition tp$1, Tuple2 x$19) {
        return BoxesRunTime.boxToBoolean((boolean)ReplicaManagerTest.$anonfun$testFollowerStateNotUpdatedIfLogReadFails$5(tp$1, x$19));
    }

    public class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public T assertFired() {
            Assert.assertTrue((String)"Callback has not been fired", (boolean)this.isFired());
            return (T)this.value().get();
        }

        public boolean isFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            Option<Function1<T, BoxedUnit>> option = this.fun();
            if (option == null) {
                throw null;
            }
            Option<Function1<T, BoxedUnit>> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                ((Function1)foreach_this.get()).apply(value);
                return;
            }
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.isFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$CallbackResult$$$outer() {
            return ReplicaManagerTest.this;
        }

        public static final /* synthetic */ void $anonfun$fire$1(Object value$1, Function1 f) {
            f.apply(value$1);
        }

        public CallbackResult() {
            if (ReplicaManagerTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }

        public static final /* synthetic */ Object $anonfun$fire$1$adapted(Object value$1, Function1 f) {
            f.apply(value$1);
            return BoxedUnit.UNIT;
        }
    }
}

