/*
 * Decompiled with CFR 0.152.
 */
package kafka.zookeeper;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.CreateRequest$;
import kafka.zookeeper.CreateResponse;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteRequest$;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.ExistsRequest;
import kafka.zookeeper.ExistsRequest$;
import kafka.zookeeper.ExistsResponse;
import kafka.zookeeper.GetAclRequest;
import kafka.zookeeper.GetAclRequest$;
import kafka.zookeeper.GetAclResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenRequest$;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataRequest$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.SetAclRequest;
import kafka.zookeeper.SetAclRequest$;
import kafka.zookeeper.SetAclResponse;
import kafka.zookeeper.SetDataRequest;
import kafka.zookeeper.SetDataRequest$;
import kafka.zookeeper.SetDataResponse;
import kafka.zookeeper.StateChangeHandler;
import kafka.zookeeper.ZNodeChangeHandler;
import kafka.zookeeper.ZNodeChildChangeHandler;
import kafka.zookeeper.ZooKeeperClient;
import kafka.zookeeper.ZooKeeperClientTest$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001\u0002\u00180\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004J\u0001\u0001\u0006I!\u0011\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u0019I\u0006\u0001)A\u0005\u0019\"I!\f\u0001a\u0001\u0002\u0004%Ia\u0017\u0005\n?\u0002\u0001\r\u00111A\u0005\n\u0001D\u0011\"\u001b\u0001A\u0002\u0003\u0005\u000b\u0015\u0002/\t\u000b)\u0004A\u0011I6\t\u000bM\u0004A\u0011I6\t\u000ba\u0004A\u0011A6\t\u000bu\u0004A\u0011\u0002@\t\r\u0005}\u0001\u0001\"\u0001l\u0011\u0019\ti\u0003\u0001C\u0001W\"1\u0011\u0011\u0007\u0001\u0005\u0002-Da!!\u000e\u0001\t\u0003Y\u0007BBA\u001d\u0001\u0011\u00051\u000e\u0003\u0004\u0002>\u0001!\ta\u001b\u0005\u0007\u0003\u0003\u0002A\u0011A6\t\r\u0005\u0015\u0003\u0001\"\u0001l\u0011\u0019\tI\u0005\u0001C\u0001W\"1\u0011Q\n\u0001\u0005\u0002-Da!!\u0015\u0001\t\u0003Y\u0007BBA+\u0001\u0011\u00051\u000e\u0003\u0004\u0002Z\u0001!\ta\u001b\u0005\u0007\u0003;\u0002A\u0011A6\t\r\u0005\u0005\u0004\u0001\"\u0001l\u0011\u0019\t)\u0007\u0001C\u0001W\"1\u0011\u0011\u000e\u0001\u0005\u0002-Da!!\u001c\u0001\t\u0003Y\u0007BBA9\u0001\u0011\u00051\u000e\u0003\u0004\u0002v\u0001!\ta\u001b\u0005\u0007\u0003s\u0002A\u0011A6\t\r\u0005u\u0004\u0001\"\u0001l\u0011\u0019\t\t\t\u0001C\u0001W\"1\u0011Q\u0011\u0001\u0005\u0002-Da!!#\u0001\t\u0003Y\u0007BBAG\u0001\u0011\u00051\u000e\u0003\u0004\u0002\u0012\u0002!\ta\u001b\u0005\u0007\u0003+\u0003A\u0011A6\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\"1\u00111\u0019\u0001\u0005\u0002-Da!a2\u0001\t\u0003Y\u0007BBAf\u0001\u0011%1\u000eC\u0004\u0002N\u0002!I!a4\u0003'i{wnS3fa\u0016\u00148\t\\5f]R$Vm\u001d;\u000b\u0005A\n\u0014!\u0003>p_.,W\r]3s\u0015\u0005\u0011\u0014!B6bM.\f7\u0001A\n\u0003\u0001U\u0002\"AN\u001d\u000e\u0003]R!\u0001O\u0019\u0002\u0005i\\\u0017B\u0001\u001e8\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012!\u0010\t\u0003}\u0001i\u0011aL\u0001\t[>\u001c7\u000eU1uQV\t\u0011\t\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006!A.\u00198h\u0015\u00051\u0015\u0001\u00026bm\u0006L!\u0001S\"\u0003\rM#(/\u001b8h\u0003%iwnY6QCRD\u0007%\u0001\u0003uS6,W#\u0001'\u0011\u00055;V\"\u0001(\u000b\u0005=\u0003\u0016!B;uS2\u001c(BA)S\u0003\u0019\u0019w.\\7p]*\u0011!g\u0015\u0006\u0003)V\u000ba!\u00199bG\",'\"\u0001,\u0002\u0007=\u0014x-\u0003\u0002Y\u001d\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003=Qxn\\&fKB,'o\u00117jK:$X#\u0001/\u0011\u0005yj\u0016B\u000100\u0005=Qvn\\&fKB,'o\u00117jK:$\u0018a\u0005>p_.+W\r]3s\u00072LWM\u001c;`I\u0015\fHCA1h!\t\u0011W-D\u0001d\u0015\u0005!\u0017!B:dC2\f\u0017B\u00014d\u0005\u0011)f.\u001b;\t\u000f!<\u0011\u0011!a\u00019\u0006\u0019\u0001\u0010J\u0019\u0002!i|wnS3fa\u0016\u00148\t\\5f]R\u0004\u0013!B:fiV\u0003H#A1)\u0005%i\u0007C\u00018r\u001b\u0005y'B\u00019V\u0003\u0015QWO\\5u\u0013\t\u0011xN\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u0012!\"\u001e\t\u0003]ZL!a^8\u0003\u000b\u00053G/\u001a:\u0002;Q,7\u000f^+oe\u0016\u001cx\u000e\u001c<bE2,7i\u001c8oK\u000e$8\u000b\u001e:j]\u001eD#a\u0003>\u0011\u00059\\\u0018B\u0001?p\u0005\u0011!Vm\u001d;\u0002)I,hN\\5oOj[7+\u001a8e)\"\u0014X-\u00193t+\u0005y\bCBA\u0001\u0003\u000f\tY!\u0004\u0002\u0002\u0004)\u0019\u0011QA2\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\n\u0005\r!aA*fiB!\u0011QBA\u000e\u001d\u0011\ty!a\u0006\u0011\u0007\u0005E1-\u0004\u0002\u0002\u0014)\u0019\u0011QC\u001a\u0002\rq\u0012xn\u001c;?\u0013\r\tIbY\u0001\u0007!J,G-\u001a4\n\u0007!\u000biBC\u0002\u0002\u001a\r\fQ\u0003^3ti\u000e{gN\\3di&|g\u000eV5nK>,H\u000f\u000b\u0004\u000eu\u0006\r\u0012QE\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u0011q\u0005\t\u0004}\u0005%\u0012bAA\u0016_\ty\"l\\8LK\u0016\u0004XM]\"mS\u0016tG\u000fV5nK>,H/\u0012=dKB$\u0018n\u001c8\u0002\u001dQ,7\u000f^\"p]:,7\r^5p]\"\u0012aB_\u0001\u001bi\u0016\u001cH\u000fR3mKR,gj\u001c8Fq&\u001cH/\u001a8u5:{G-\u001a\u0015\u0003\u001fi\fq\u0003^3ti\u0012+G.\u001a;f\u000bbL7\u000f^5oOjsu\u000eZ3)\u0005AQ\u0018A\u0007;fgR,\u00050[:ug:{g.\u0012=jgR,g\u000e\u001e.O_\u0012,\u0007FA\t{\u0003]!Xm\u001d;Fq&\u001cHo]#ySN$\u0018N\\4[\u001d>$W\r\u000b\u0002\u0013u\u0006YB/Z:u\u000f\u0016$H)\u0019;b\u001d>tW\t_5ti\u0016tGO\u0017(pI\u0016D#a\u0005>\u00021Q,7\u000f^$fi\u0012\u000bG/Y#ySN$\u0018N\\4[\u001d>$W\r\u000b\u0002\u0015u\u0006YB/Z:u'\u0016$H)\u0019;b\u001d>tW\t_5ti\u0016tGO\u0017(pI\u0016D#!\u0006>\u00021Q,7\u000f^*fi\u0012\u000bG/Y#ySN$\u0018N\\4[\u001d>$W\r\u000b\u0002\u0017u\u0006QB/Z:u\u000f\u0016$\u0018i\u00197O_:,\u00050[:uK:$(LT8eK\"\u0012qC_\u0001\u0018i\u0016\u001cHoR3u\u0003\u000edW\t_5ti&twM\u0017(pI\u0016D#\u0001\u0007>\u00025Q,7\u000f^*fi\u0006\u001bGNT8o\u000bbL7\u000f^3oijsu\u000eZ3)\u0005eQ\u0018a\b;fgR<U\r^\"iS2$'/\u001a8O_:,\u00050[:uK:$(LT8eK\"\u0012!D_\u0001\u001di\u0016\u001cHoR3u\u0007\"LG\u000e\u001a:f]\u0016C\u0018n\u001d;j]\u001eTfj\u001c3fQ\tY\"0\u0001\u0015uKN$x)\u001a;DQ&dGM]3o\u000bbL7\u000f^5oOjsu\u000eZ3XSRD7\t[5mIJ,g\u000e\u000b\u0002\u001du\u0006!B/Z:u!&\u0004X\r\\5oK\u0012<U\r\u001e#bi\u0006D#!\b>\u0002#Q,7\u000f^'jq\u0016$\u0007+\u001b9fY&tW\r\u000b\u0002\u001fu\u0006\tC/Z:u5:{G-Z\"iC:<W\rS1oI2,'OR8s\u0007J,\u0017\r^5p]\"\u0012qD_\u0001\"i\u0016\u001cHO\u0017(pI\u0016\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7fe\u001a{'\u000fR3mKRLwN\u001c\u0015\u0003Ai\f1\u0005^3tijsu\u000eZ3DQ\u0006tw-\u001a%b]\u0012dWM\u001d$pe\u0012\u000bG/Y\"iC:<W\r\u000b\u0002\"u\u0006\u0011D/Z:u\u00052|7m[(o%\u0016\fX/Z:u\u0007>l\u0007\u000f\\3uS>tgI]8n'R\fG/Z\"iC:<W\rS1oI2,'\u000f\u000b\u0002#u\u0006AC/Z:u\u000bb\u001cW\r\u001d;j_:LeNQ3g_J,\u0017J\\5uS\u0006d\u0017N_5oON+7o]5p]\"\u00121E_\u0001*i\u0016\u001cHO\u0017(pI\u0016\u001c\u0005.\u001b7e\u0007\"\fgnZ3IC:$G.\u001a:G_J\u001c\u0005.\u001b7e\u0007\"\fgnZ3)\u0005\u0011R\u0018\u0001\n;fgR\u001cF/\u0019;f\u0007\"\fgnZ3IC:$G.\u001a:G_J\fU\u000f\u001e5GC&dWO]3)\u0005\u0015R\u0018\u0001\n;fgR\u001cuN\u001c8fGRLwN\u001c'pgN\u0014V-];fgR$VM]7j]\u0006$\u0018n\u001c8)\u0005\u0019R\u0018!\u0005;fgR\u001cVm]:j_:,\u0005\u0010]5ss\"\u0012qE_\u0001\u001di\u0016\u001cHoU3tg&|g.\u0012=qSJLH)\u001e:j]\u001e\u001cEn\\:fQ\tA#0\u0001\u000bjg\u0016C\b/Z2uK\u0012lU\r\u001e:jG:\u000bW.\u001a\u000b\u0007\u0003;\u000b\u0019+a0\u0011\u0007\t\fy*C\u0002\u0002\"\u000e\u0014qAQ8pY\u0016\fg\u000eC\u0004\u0002&&\u0002\r!a*\u0002\u00155,GO]5d\u001d\u0006lW\r\u0005\u0003\u0002*\u0006mVBAAV\u0015\u0011\ti+a,\u0002\t\r|'/\u001a\u0006\u0005\u0003c\u000b\u0019,A\u0004nKR\u0014\u0018nY:\u000b\t\u0005U\u0016qW\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005e\u0016aA2p[&!\u0011QXAV\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\b\u0003\u0003L\u0003\u0019AA\u0006\u0003\u0011q\u0017-\\3\u0002GQ,7\u000f\u001e.p_.+W\r]3s'R\fG/Z\"iC:<WMU1uK6+GO]5dg\"\u0012!F_\u0001 i\u0016\u001cHOW8p\u0017\u0016,\u0007/\u001a:TKN\u001c\u0018n\u001c8Ti\u0006$X-T3ue&\u001c\u0007FA\u0016{\u0003Q\u0019G.Z1o\u001b\u0016$(/[2t%\u0016<\u0017n\u001d;ss\u0006)!-\u001f;fgV\u0011\u0011\u0011\u001b\t\u0006E\u0006M\u0017q[\u0005\u0004\u0003+\u001c'!B!se\u0006L\bc\u00012\u0002Z&\u0019\u00111\\2\u0003\t\tKH/\u001a")
public class ZooKeeperClientTest
extends ZooKeeperTestHarness {
    private final String kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    private final Time kafka$zookeeper$ZooKeeperClientTest$$time = Time.SYSTEM;
    private ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;

    public String kafka$zookeeper$ZooKeeperClientTest$$mockPath() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$mockPath;
    }

    public Time kafka$zookeeper$ZooKeeperClientTest$$time() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$time;
    }

    public ZooKeeperClient kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() {
        return this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient;
    }

    private void kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads("@Before");
        this.cleanMetricsRegistry();
        super.setUp();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "testMetricGroup", "testMetricType"));
    }

    @Override
    @After
    public void tearDown() {
        if (this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient() != null) {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        }
        super.tearDown();
        System.clearProperty("java.security.auth.login.config");
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads("@After");
    }

    @Test
    public void testUnresolvableConnectString() {
        try {
            new ZooKeeperClient("some.invalid.hostname.foo.bar.local", this.zkSessionTimeout(), 10, Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");
            return;
        }
        catch (ZooKeeperClientTimeoutException zooKeeperClientTimeoutException) {
            Assert.assertEquals((String)"ZooKeeper client threads still running", (Object)Predef$.MODULE$.Set().empty(), this.runningZkSendThreads());
            return;
        }
    }

    private Set<String> runningZkSendThreads() {
        return (Set)((TraversableLike)((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isAlive()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Set$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)t.contains("SendThread()")));
    }

    @Test(expected=ZooKeeperClientTimeoutException.class)
    public void testConnectionTimeout() {
        this.zookeeper().shutdown();
        new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), 10, Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType").close();
    }

    @Test
    public void testConnection() {
        try (ZooKeeperClient client = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");){
            scala.collection.mutable.Set threads = (scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(Thread.getAllStackTraces().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), Set$.MODULE$.canBuildFrom());
            Assert.assertTrue((String)new StringBuilder(48).append("ZooKeeperClient event thread not found, threads=").append(threads).toString(), (boolean)threads.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains(ZooKeeperTestHarness$.MODULE$.ZkClientEventThreadSuffix()))));
        }
    }

    @Test
    public void testDeleteNonExistentZNode() {
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, DeleteRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)deleteResponse.resultCode());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> deleteResponse.maybeThrow(), ClassTag$.MODULE$.apply(KeeperException.NoNodeException.class), new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
    }

    @Test
    public void testDeleteExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, DeleteRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code for delete should be OK", (Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode());
    }

    @Test
    public void testExistsNonExistentZNode() {
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)existsResponse.resultCode());
    }

    @Test
    public void testExistsExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        ExistsResponse existsResponse = (ExistsResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)existsResponse.resultCode());
    }

    @Test
    public void testGetDataNonExistentZNode() {
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)getDataResponse.resultCode());
    }

    @Test
    public void testGetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
        Assert.assertArrayEquals((String)"Data for getData should match created znode data", (byte[])data, (byte[])getDataResponse.data());
    }

    @Test
    public void testSetDataNonExistentZNode() {
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, SetDataRequest$.MODULE$.apply$default$4()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)setDataResponse.resultCode());
    }

    @Test
    public void testSetDataExistingZNode() {
        byte[] data = this.bytes();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), data, -1, SetDataRequest$.MODULE$.apply$default$4()));
        Assert.assertEquals((String)"Response code for setData should be OK", (Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode());
        GetDataResponse getDataResponse = (GetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
        Assert.assertArrayEquals((String)"Data for getData should match setData's data", (byte[])data, (byte[])getDataResponse.data());
    }

    @Test
    public void testGetAclNonExistentZNode() {
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetAclRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)getAclResponse.resultCode());
    }

    @Test
    public void testGetAclExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetAclResponse getAclResponse = (GetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetAclRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for getAcl should be OK", (Object)KeeperException.Code.OK, (Object)getAclResponse.resultCode());
        Assert.assertEquals((String)new StringBuilder(14).append("ACL should be ").append(JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala()).toString(), (Object)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), (Object)getAclResponse.acl());
    }

    @Test
    public void testSetAclNonExistentZNode() {
        SetAclResponse setAclResponse = (SetAclResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetAclRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), -1, SetAclRequest$.MODULE$.apply$default$4()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)setAclResponse.resultCode());
    }

    @Test
    public void testGetChildrenNonExistentZNode() {
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetChildrenRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code should be NONODE", (Object)KeeperException.Code.NONODE, (Object)getChildrenResponse.resultCode());
    }

    @Test
    public void testGetChildrenExistingZNode() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetChildrenRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        Assert.assertEquals((String)"getChildren should return no children", (Object)Seq$.MODULE$.empty(), (Object)getChildrenResponse.children());
    }

    @Test
    public void testGetChildrenExistingZNodeWithChildren() {
        String child1 = "child1";
        String child2 = "child2";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        String child2Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child2).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create child1 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode());
        CreateResponse createResponseChild2 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child2Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create child2 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild2.resultCode());
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetChildrenRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        Assert.assertEquals((String)"getChildren should return two children", (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{child1, child2})), (Object)getChildrenResponse.children().sorted((Ordering)Ordering.String$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPipelinedGetData() {
        void map_bf;
        void map_f;
        void map_bf2;
        void map_f2;
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 3);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$1(BoxesRunTime.unboxToInt((Object)x));
        if (inclusive == null) {
            throw null;
        }
        ((IndexedSeq)((IndexedSeq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f2, (CanBuildFrom)map_bf2)).map(arg_0 -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$2(this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient(), arg_0), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)createResponse -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$3(createResponse);
            return BoxedUnit.UNIT;
        });
        int n2 = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive2 = RichInt$.MODULE$.to$extension0(n2, 3);
        CanBuildFrom canBuildFrom2 = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect2 = (Function1 & Serializable & scala.Serializable)x -> ZooKeeperClientTest.$anonfun$testPipelinedGetData$4(BoxesRunTime.unboxToInt((Object)x));
        if (inclusive2 == null) {
            throw null;
        }
        IndexedSeq getDataRequests = (IndexedSeq)TraversableLike.map$((TraversableLike)inclusive2, (Function1)map_f, (CanBuildFrom)map_bf);
        Seq getDataResponses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)getDataRequests);
        getDataResponses.foreach((Function1 & Serializable & scala.Serializable)getDataResponse -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$5(getDataResponse);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)getDataResponses.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ZooKeeperClientTest.$anonfun$testPipelinedGetData$6(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testMixedPipeline() {
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        GetDataRequest getDataRequest = new GetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetDataRequest$.MODULE$.apply$default$2());
        SetDataRequest setDataRequest = new SetDataRequest("/nonexistent", (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, SetDataRequest$.MODULE$.apply$default$4());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{getDataRequest, setDataRequest})));
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode());
        Assert.assertArrayEquals((String)"Data for getData should be empty", (byte[])((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (byte[])((GetDataResponse)responses.head()).data());
        Assert.assertEquals((String)"Response code for setData should be NONODE", (Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.last()).resultCode());
    }

    @Test
    public void testZNodeChangeHandlerForCreation() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$1;

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleCreation() {
                this.znodeChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$1 = znodeChangeHandlerCountDownLatch$1;
                ZNodeChangeHandler.$init$((ZNodeChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2());
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{existsRequest, createRequest})));
        Assert.assertEquals((String)"Response code for exists should be NONODE", (Object)KeeperException.Code.NONODE, (Object)((AsyncResponse)responses.head()).resultCode());
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode());
        Assert.assertTrue((String)"Failed to receive create notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChangeHandlerForDeletion() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$2;

            public void handleCreation() {
                ZNodeChangeHandler.handleCreation$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                ZNodeChangeHandler.handleDataChange$((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                this.znodeChangeHandlerCountDownLatch$2.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$2 = znodeChangeHandlerCountDownLatch$2;
                ZNodeChangeHandler.$init$((ZNodeChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2());
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{createRequest, existsRequest})));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode());
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode());
        DeleteResponse deleteResponse = (DeleteResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new DeleteRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), -1, DeleteRequest$.MODULE$.apply$default$3()));
        Assert.assertEquals((String)"Response code for delete should be OK", (Object)KeeperException.Code.OK, (Object)deleteResponse.resultCode());
        Assert.assertTrue((String)"Failed to receive delete notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testZNodeChangeHandlerForDataChange() {
        CountDownLatch znodeChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChangeHandler zNodeChangeHandler = new ZNodeChangeHandler(this, znodeChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch znodeChangeHandlerCountDownLatch$3;

            public void handleCreation() {
                ZNodeChangeHandler.handleCreation$((ZNodeChangeHandler)this);
            }

            public void handleDeletion() {
                ZNodeChangeHandler.handleDeletion$((ZNodeChangeHandler)this);
            }

            public void handleDataChange() {
                this.znodeChangeHandlerCountDownLatch$3.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.znodeChangeHandlerCountDownLatch$3 = znodeChangeHandlerCountDownLatch$3;
                ZNodeChangeHandler.$init$((ZNodeChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChangeHandler(zNodeChangeHandler);
        ExistsRequest existsRequest = new ExistsRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), ExistsRequest$.MODULE$.apply$default$2());
        CreateRequest createRequest = new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
        Seq responses = this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequests((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{createRequest, existsRequest})));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.last()).resultCode());
        Assert.assertEquals((String)"Response code for exists should be OK", (Object)KeeperException.Code.OK, (Object)((AsyncResponse)responses.head()).resultCode());
        SetDataResponse setDataResponse = (SetDataResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new SetDataRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), -1, SetDataRequest$.MODULE$.apply$default$4()));
        Assert.assertEquals((String)"Response code for setData should be OK", (Object)KeeperException.Code.OK, (Object)setDataResponse.resultCode());
        Assert.assertTrue((String)"Failed to receive data change notification", (boolean)znodeChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testBlockOnRequestCompletionFromStateChangeHandler() {
        CountDownLatch latch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(null, latch){
            private final String name;
            private final CountDownLatch latch$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.latch$1.await();
            }
            {
                this.latch$1 = latch$1;
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType"));
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(stateChangeHandler);
        Thread requestThread = new Thread(this, latch){
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                try {
                    this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.$outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
                }
                finally {
                    this.latch$1.countDown();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread reinitializeThread = new Thread(this){
            private final /* synthetic */ ZooKeeperClientTest $outer;

            public void run() {
                this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().forceReinitialize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        reinitializeThread.start();
        Thread.sleep(100L);
        requestThread.start();
        reinitializeThread.join();
        requestThread.join();
    }

    @Test
    public void testExceptionInBeforeInitializingSession() {
        StateChangeHandler faultyHandler = new StateChangeHandler(null){
            private final String name;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                throw new RuntimeException();
            }
            {
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        AtomicInteger goodCalls = new AtomicInteger(0);
        StateChangeHandler goodHandler = new StateChangeHandler(null, goodCalls){
            private final String name;
            private final AtomicInteger goodCalls$1;

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public void onAuthFailure() {
                StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void beforeInitializingSession() {
                this.goodCalls$1.incrementAndGet();
            }
            {
                this.goodCalls$1 = goodCalls$1;
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType"));
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(faultyHandler);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerStateChangeHandler(goodHandler);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().forceReinitialize();
        Assert.assertEquals((long)1L, (long)goodCalls.get());
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
    }

    @Test
    public void testZNodeChildChangeHandlerForChildChange() {
        CountDownLatch zNodeChildChangeHandlerCountDownLatch = new CountDownLatch(1);
        ZNodeChildChangeHandler zNodeChildChangeHandler = new ZNodeChildChangeHandler(this, zNodeChildChangeHandlerCountDownLatch){
            private final String path;
            private final CountDownLatch zNodeChildChangeHandlerCountDownLatch$1;

            public void handleChildChange() {
                this.zNodeChildChangeHandlerCountDownLatch$1.countDown();
            }

            public String path() {
                return this.path;
            }
            {
                this.zNodeChildChangeHandlerCountDownLatch$1 = zNodeChildChangeHandlerCountDownLatch$1;
                ZNodeChildChangeHandler.$init$((ZNodeChildChangeHandler)this);
                this.path = $outer.kafka$zookeeper$ZooKeeperClientTest$$mockPath();
            }
        };
        String child1 = "child1";
        String child1Path = new StringBuilder(1).append(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath()).append("/").append(child1).toString();
        CreateResponse createResponse = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().registerZNodeChildChangeHandler(zNodeChildChangeHandler);
        GetChildrenResponse getChildrenResponse = (GetChildrenResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(this.kafka$zookeeper$ZooKeeperClientTest$$mockPath(), GetChildrenRequest$.MODULE$.apply$default$2()));
        Assert.assertEquals((String)"Response code for getChildren should be OK", (Object)KeeperException.Code.OK, (Object)getChildrenResponse.resultCode());
        CreateResponse createResponseChild1 = (CreateResponse)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().handleRequest((AsyncRequest)new CreateRequest(child1Path, (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5()));
        Assert.assertEquals((String)"Response code for create child1 should be OK", (Object)KeeperException.Code.OK, (Object)createResponseChild1.resultCode());
        Assert.assertTrue((String)"Failed to receive child change notification", (boolean)zNodeChildChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testStateChangeHandlerForAuthFailure() {
        System.setProperty("java.security.auth.login.config", "no-such-file-exists.conf");
        CountDownLatch stateChangeHandlerCountDownLatch = new CountDownLatch(1);
        StateChangeHandler stateChangeHandler = new StateChangeHandler(null, stateChangeHandlerCountDownLatch){
            private final String name;
            private final CountDownLatch stateChangeHandlerCountDownLatch$1;

            public void beforeInitializingSession() {
                StateChangeHandler.beforeInitializingSession$((StateChangeHandler)this);
            }

            public void afterInitializingSession() {
                StateChangeHandler.afterInitializingSession$((StateChangeHandler)this);
            }

            public String name() {
                return this.name;
            }

            public void onAuthFailure() {
                this.stateChangeHandlerCountDownLatch$1.countDown();
            }
            {
                this.stateChangeHandlerCountDownLatch$1 = stateChangeHandlerCountDownLatch$1;
                StateChangeHandler.$init$((StateChangeHandler)this);
                this.name = this.getClass().getName();
            }
        };
        try (ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), Integer.MAX_VALUE, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testMetricGroup", "testMetricType");){
            zooKeeperClient.registerStateChangeHandler(stateChangeHandler);
            zooKeeperClient.forceReinitialize();
            Assert.assertTrue((String)"Failed to receive auth failed notification", (boolean)stateChangeHandlerCountDownLatch.await(5L, TimeUnit.SECONDS));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConnectionLossRequestTermination() {
        int batchSize = 10;
        this.zookeeper().shutdown();
        try (ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), 2, this.kafka$zookeeper$ZooKeeperClientTest$$time(), "testGroupType", "testGroupName");){
            void map_bf;
            void map_f;
            int n = 1;
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, batchSize);
            CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)i -> ZooKeeperClientTest.$anonfun$testConnectionLossRequestTermination$1(BoxesRunTime.unboxToInt((Object)i));
            if (inclusive == null) {
                throw null;
            }
            IndexedSeq requests = (IndexedSeq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf);
            CountDownLatch countDownLatch = new CountDownLatch(1);
            AtomicBoolean running = new AtomicBoolean(true);
            ArrayBlockingQueue unexpectedResponses = new ArrayBlockingQueue(batchSize);
            Thread requestThread = new Thread(null, running, zooKeeperClient, requests, unexpectedResponses, countDownLatch){
                private final AtomicBoolean running$1;
                private final ZooKeeperClient zooKeeperClient$1;
                private final IndexedSeq requests$1;
                private final ArrayBlockingQueue unexpectedResponses$1;
                private final CountDownLatch countDownLatch$1;

                public void run() {
                    while (this.running$1.get()) {
                        Seq responses = this.zooKeeperClient$1.handleRequests((Seq)this.requests$1);
                        Seq suffix = (Seq)responses.dropWhile((Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)$anon$11.$anonfun$run$1(response)));
                        if (!suffix.forall((Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)$anon$11.$anonfun$run$2(response)))) {
                            responses.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)$anon$11.$anonfun$run$3(this, x$1)));
                        }
                        if (this.unexpectedResponses$1.isEmpty() && !suffix.nonEmpty()) continue;
                        this.running$1.set(false);
                    }
                    this.countDownLatch$1.countDown();
                }

                public static final /* synthetic */ boolean $anonfun$run$1(GetDataResponse response) {
                    KeeperException.Code code = response.resultCode();
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return code == null ? code2 != null : !code.equals(code2);
                }

                public static final /* synthetic */ boolean $anonfun$run$2(GetDataResponse response) {
                    KeeperException.Code code = response.resultCode();
                    KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
                    return !(code != null ? !code.equals(code2) : code2 != null);
                }

                public static final /* synthetic */ boolean $anonfun$run$3($anon$11 $this, GetDataResponse x$1) {
                    return $this.unexpectedResponses$1.add(x$1);
                }
                {
                    this.running$1 = running$1;
                    this.zooKeeperClient$1 = zooKeeperClient$1;
                    this.requests$1 = requests$1;
                    this.unexpectedResponses$1 = unexpectedResponses$1;
                    this.countDownLatch$1 = countDownLatch$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(kafka.zookeeper.GetDataResponse ), $anonfun$run$2$adapted(kafka.zookeeper.GetDataResponse ), $anonfun$run$3$adapted(kafka.zookeeper.ZooKeeperClientTest$$anon$11 kafka.zookeeper.GetDataResponse )}, serializedLambda);
                }
            };
            requestThread.start();
            if (!countDownLatch.await(30L, TimeUnit.SECONDS)) {
                running.set(false);
                requestThread.join(5000L);
                throw Assertions$.MODULE$.fail("Failed to receive a CONNECTIONLOSS response code after zookeeper has shutdown.", new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
            }
            if (!unexpectedResponses.isEmpty()) {
                throw Assertions$.MODULE$.fail(new StringBuilder(114).append("Received an unexpected non-CONNECTIONLOSS response code after a CONNECTIONLOSS response code from a single batch: ").append(unexpectedResponses).toString(), new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
            }
        }
    }

    @Test
    public void testSessionExpiry() {
        int maxInflightRequests = 2;
        ExecutorService responseExecutor = Executors.newSingleThreadExecutor();
        Semaphore sendSemaphore = new Semaphore(0);
        Semaphore sendCompleteSemaphore = new Semaphore(0);
        int sendSize = maxInflightRequests * 5;
        VolatileObjectRef resultCodes = VolatileObjectRef.create(null);
        ConcurrentLinkedQueue stateChanges = new ConcurrentLinkedQueue();
        ZooKeeperClient zooKeeperClient = new ZooKeeperClient(this, maxInflightRequests, responseExecutor, sendCompleteSemaphore, sendSemaphore){
            private final ExecutorService responseExecutor$1;
            public final Semaphore sendCompleteSemaphore$1;
            public final Semaphore sendSemaphore$1;

            public <Req extends AsyncRequest> void send(Req request, Function1<AsyncResponse, BoxedUnit> processResponse) {
                super.send(request, (Function1 & Serializable & scala.Serializable)response -> {
                    $this.responseExecutor$1.submit(new Runnable(this, (Function1)processResponse, (AsyncResponse)response){
                        private final /* synthetic */ $anon$12 $outer;
                        private final Function1 processResponse$1;
                        private final AsyncResponse response$1;

                        public void run() {
                            this.$outer.sendCompleteSemaphore$1.release();
                            this.$outer.sendSemaphore$1.acquire();
                            this.processResponse$1.apply((Object)this.response$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.processResponse$1 = processResponse$1;
                            this.response$1 = response$1;
                        }
                    });
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$send$1($anon$12 $this, Function1 processResponse$1, AsyncResponse response) {
                $this.responseExecutor$1.submit(new /* invalid duplicate definition of identical inner class */);
            }
            {
                this.responseExecutor$1 = responseExecutor$1;
                this.sendCompleteSemaphore$1 = sendCompleteSemaphore$1;
                this.sendSemaphore$1 = sendSemaphore$1;
                super($outer.zkConnect(), $outer.zkSessionTimeout(), $outer.zkConnectionTimeout(), maxInflightRequests$1, $outer.kafka$zookeeper$ZooKeeperClientTest$$time(), "testGroupType", "testGroupName");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$send$1$adapted(kafka.zookeeper.ZooKeeperClientTest$$anon$12 scala.Function1 kafka.zookeeper.AsyncResponse )}, serializedLambda);
            }
        };
        try {
            zooKeeperClient.registerStateChangeHandler(new StateChangeHandler(null, stateChanges, sendSemaphore, sendSize, zooKeeperClient){
                private final String name;
                private final ConcurrentLinkedQueue stateChanges$1;
                private final Semaphore sendSemaphore$1;
                private final int sendSize$1;
                private final ZooKeeperClient zooKeeperClient$2;

                public void onAuthFailure() {
                    StateChangeHandler.onAuthFailure$((StateChangeHandler)this);
                }

                public String name() {
                    return this.name;
                }

                public void afterInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("afterInitializingSession");
                }

                public void beforeInitializingSession() {
                    this.verifyHandlerThread();
                    this.stateChanges$1.add("beforeInitializingSession");
                    this.sendSemaphore$1.release(this.sendSize$1);
                }

                private void verifyHandlerThread() {
                    String threadName = Thread.currentThread().getName();
                    Assert.assertTrue((String)new StringBuilder(20).append("Unexpected thread + ").append(threadName).toString(), (boolean)threadName.startsWith(this.zooKeeperClient$2.expiryScheduler().threadNamePrefix()));
                }
                {
                    this.stateChanges$1 = stateChanges$1;
                    this.sendSemaphore$1 = sendSemaphore$1;
                    this.sendSize$1 = sendSize$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                    StateChangeHandler.$init$((StateChangeHandler)this);
                    this.name = "test-state-change-handler";
                }
            });
            Thread requestThread = new Thread(null, sendSize, resultCodes, zooKeeperClient){
                private final int sendSize$1;
                private final VolatileObjectRef resultCodes$1;
                private final ZooKeeperClient zooKeeperClient$2;

                /*
                 * WARNING - void declaration
                 */
                public void run() {
                    void map_bf;
                    void map_f;
                    int n = 1;
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, this.sendSize$1);
                    CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
                    Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)i -> $anon$15.$anonfun$run$4(BoxesRunTime.unboxToInt((Object)i));
                    if (inclusive == null) {
                        throw null;
                    }
                    IndexedSeq requests = (IndexedSeq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf);
                    this.resultCodes$1.elem = (Seq)this.zooKeeperClient$2.handleRequests((Seq)requests).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.resultCode(), Seq$.MODULE$.canBuildFrom());
                }

                public static final /* synthetic */ GetDataRequest $anonfun$run$4(int i) {
                    return new GetDataRequest(new StringBuilder(1).append("/").append(i).toString(), GetDataRequest$.MODULE$.apply$default$2());
                }
                {
                    this.sendSize$1 = sendSize$1;
                    this.resultCodes$1 = resultCodes$1;
                    this.zooKeeperClient$2 = zooKeeperClient$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$4$adapted(java.lang.Object ), $anonfun$run$5(kafka.zookeeper.GetDataResponse )}, serializedLambda);
                }
            };
            requestThread.start();
            sendCompleteSemaphore.acquire();
            ZooKeeper anotherZkClient = this.createZooKeeperClientToTriggerSessionExpiry(zooKeeperClient.currentZooKeeper());
            sendSemaphore.release(maxInflightRequests);
            anotherZkClient.close();
            sendSemaphore.release(maxInflightRequests);
            requestThread.join(10000L);
            if (requestThread.isAlive()) {
                requestThread.interrupt();
                throw Assertions$.MODULE$.fail("Request thread did not complete", new Position("ZooKeeperClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568));
            }
            Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"beforeInitializingSession", "afterInitializingSession"})), (Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(stateChanges).asScala()).toSeq());
            Assert.assertEquals((long)((Seq)resultCodes.elem).size(), (long)sendSize);
            int connectionLostCount = ((Seq)resultCodes.elem).count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ZooKeeperClientTest.$anonfun$testSessionExpiry$1(x$6)));
            Assert.assertTrue((String)new StringBuilder(36).append("Unexpected connection lost requests ").append((Seq)resultCodes.elem).toString(), (connectionLostCount <= maxInflightRequests ? 1 : 0) != 0);
            int expiredCount = ((Seq)resultCodes.elem).count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ZooKeeperClientTest.$anonfun$testSessionExpiry$2(x$7)));
            Assert.assertTrue((String)new StringBuilder(36).append("Unexpected session expired requests ").append((Seq)resultCodes.elem).toString(), (expiredCount <= maxInflightRequests ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringBuilder(39).append("No connection lost or expired requests ").append((Seq)resultCodes.elem).toString(), (connectionLostCount + expiredCount > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).head());
            Assert.assertEquals((Object)KeeperException.Code.NONODE, (Object)((Seq)resultCodes.elem).last());
            Assert.assertTrue((String)new StringBuilder(23).append("Unexpected result code ").append((Seq)resultCodes.elem).toString(), (boolean)((SeqLike)((Seq)resultCodes.elem).filterNot(arg_0 -> ZooKeeperClientTest.$anonfun$testSessionExpiry$3$adapted((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeeperException.Code[]{KeeperException.Code.NONODE, KeeperException.Code.SESSIONEXPIRED, KeeperException.Code.CONNECTIONLOSS})), arg_0))).isEmpty());
        }
        finally {
            zooKeeperClient.close();
            responseExecutor.shutdownNow();
        }
        Assert.assertFalse((String)"Expiry executor not shutdown", (boolean)zooKeeperClient.expiryScheduler().isStarted());
    }

    @Test
    public void testSessionExpiryDuringClose() {
        Semaphore semaphore = new Semaphore(0);
        ExecutorService closeExecutor = Executors.newSingleThreadExecutor();
        try {
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().expiryScheduler().schedule("test", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> semaphore.acquireUninterruptibly(), 0L, -1L, TimeUnit.SECONDS);
            this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().scheduleSessionExpiryHandler();
            Future<?> closeFuture = closeExecutor.submit(new Runnable(this){
                private final /* synthetic */ ZooKeeperClientTest $outer;

                public void run() {
                    this.$outer.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            Assert.assertFalse((String)"Close completed without shutting down expiry scheduler gracefully", (boolean)closeFuture.isDone());
            Assert.assertTrue((boolean)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().currentZooKeeper().getState().isAlive());
            semaphore.release();
            closeFuture.get(10L, TimeUnit.SECONDS);
            Assert.assertFalse((String)"Expiry executor not shutdown", (boolean)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().expiryScheduler().isStarted());
        }
        finally {
            closeExecutor.shutdownNow();
        }
    }

    public boolean isExpectedMetricName(MetricName metricName, String name) {
        String string = metricName.getName();
        if (!(string != null ? !string.equals(name) : name != null)) {
            String string2 = metricName.getGroup();
            String string3 = "testMetricGroup";
            if (string2 != null && string2.equals(string3)) {
                String string4 = metricName.getType();
                String string5 = "testMetricType";
                if (string4 != null && string4.equals(string5)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Test
    public void testZooKeeperStateChangeRateMetrics() {
        String expiresPerSecName = "ZooKeeperExpiresPerSec";
        String disconnectsPerSecName = "ZooKeeperDisconnectsPerSec";
        this.checkMeterCount$1(expiresPerSecName, 0L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Expired, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 0L);
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().ZooKeeperClientWatcher().process(new WatchedEvent(Watcher.Event.EventType.None, Watcher.Event.KeeperState.Disconnected, null));
        this.checkMeterCount$1(expiresPerSecName, 1L);
        this.checkMeterCount$1(disconnectsPerSecName, 1L);
    }

    @Test
    public void testZooKeeperSessionStateMetric() {
        Assert.assertEquals((Object)new Some((Object)ZooKeeper.States.CONNECTED.toString()), (Object)this.gaugeValue$1("SessionState"));
        Assert.assertEquals((Object)ZooKeeper.States.CONNECTED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
        this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().close();
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.gaugeValue$1("SessionState"));
        Assert.assertEquals((Object)ZooKeeper.States.CLOSED, (Object)this.kafka$zookeeper$ZooKeeperClientTest$$zooKeeperClient().connectionState());
    }

    private void cleanMetricsRegistry() {
        MetricsRegistry metrics = Metrics.defaultRegistry();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(metrics.allMetrics().keySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            metrics.removeMetric(x$1);
            return BoxedUnit.UNIT;
        });
    }

    private byte[] bytes() {
        return UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
    }

    public static final /* synthetic */ CreateRequest $anonfun$testPipelinedGetData$1(int x) {
        return new CreateRequest(new StringBuilder(1).append("/").append(x).toString(), ((Object)BoxesRunTime.boxToInteger((int)(x * 2))).toString().getBytes(), (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)ZooDefs.Ids.OPEN_ACL_UNSAFE).asScala(), CreateMode.PERSISTENT, CreateRequest$.MODULE$.apply$default$5());
    }

    public static final /* synthetic */ CreateResponse $anonfun$testPipelinedGetData$2(ZooKeeperClient eta$0$1$1, CreateRequest request) {
        return (CreateResponse)eta$0$1$1.handleRequest((AsyncRequest)request);
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$3(CreateResponse createResponse) {
        Assert.assertEquals((String)"Response code for create should be OK", (Object)KeeperException.Code.OK, (Object)createResponse.resultCode());
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testPipelinedGetData$4(int x) {
        return new GetDataRequest(new StringBuilder(1).append("/").append(x).toString(), GetDataRequest$.MODULE$.apply$default$2());
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$5(GetDataResponse getDataResponse) {
        Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
    }

    public static final /* synthetic */ void $anonfun$testPipelinedGetData$6(Tuple2 x0$1) {
        if (x0$1 != null) {
            GetDataResponse getDataResponse = (GetDataResponse)x0$1._1();
            int i = x0$1._2$mcI$sp();
            Assert.assertEquals((String)"Response code for getData should be OK", (Object)KeeperException.Code.OK, (Object)getDataResponse.resultCode());
            Assert.assertEquals((String)"Data for getData should match", (Object)BoxesRunTime.boxToInteger((int)((i + 1) * 2)), (Object)Integer.valueOf(new String(getDataResponse.data())));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ GetDataRequest $anonfun$testConnectionLossRequestTermination$1(int i) {
        return new GetDataRequest(new StringBuilder(1).append("/").append(i).toString(), GetDataRequest$.MODULE$.apply$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpiry$1(KeeperException.Code x$6) {
        KeeperException.Code code = x$6;
        KeeperException.Code code2 = KeeperException.Code.CONNECTIONLOSS;
        return !(code != null ? !code.equals(code2) : code2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testSessionExpiry$2(KeeperException.Code x$7) {
        KeeperException.Code code = x$7;
        KeeperException.Code code2 = KeeperException.Code.SESSIONEXPIRED;
        return !(code != null ? !code.equals(code2) : code2 != null);
    }

    private final void checkMeterCount$1(String name, long expected) {
        Option option = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).collectFirst((PartialFunction)new scala.Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    MetricName metricName = (MetricName)x1._1();
                    Metric meter = (Metric)x1._2();
                    if (meter instanceof Meter) {
                        Meter meter2 = (Meter)meter;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$1)) {
                            object = meter2;
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                if (x1 == null) return false;
                MetricName metricName = (MetricName)x1._1();
                if (!((Metric)x1._2() instanceof Meter)) return false;
                if (!this.$outer.isExpectedMetricName(metricName, this.name$1)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        });
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw package$.MODULE$.error(new StringBuilder(31).append("Unable to find meter with name ").append(name).toString());
        }
        Meter meter = (Meter)getOrElse_this.get();
        Assert.assertEquals((String)new StringBuilder(27).append("Unexpected meter count for ").append(name).toString(), (long)expected, (long)meter.count());
    }

    private final Option gaugeValue$1(String name) {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).collectFirst((PartialFunction)new scala.Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ZooKeeperClientTest $outer;
            private final String name$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    MetricName metricName = (MetricName)x1._1();
                    Metric gauge = (Metric)x1._2();
                    if (gauge instanceof Gauge) {
                        Gauge gauge2 = (Gauge)gauge;
                        if (this.$outer.isExpectedMetricName(metricName, this.name$2)) {
                            object = (String)gauge2.value();
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                if (x1 == null) return false;
                MetricName metricName = (MetricName)x1._1();
                if (!((Metric)x1._2() instanceof Gauge)) return false;
                if (!this.$outer.isExpectedMetricName(metricName, this.name$2)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$2 = name$2;
            }
        });
    }

    public ZooKeeperClientTest() {
        this.kafka$zookeeper$ZooKeeperClientTest$$mockPath = "/foo";
    }

    public static final /* synthetic */ Object $anonfun$testSessionExpiry$3$adapted(scala.collection.immutable.Set eta$0$1$2, KeeperException.Code elem) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$2.contains((Object)elem));
    }
}

