/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$Throttle$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentInProgress$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;

public final class ReassignPartitionsCommand$
implements Logging {
    public static ReassignPartitionsCommand$ MODULE$;
    private final ReassignPartitionsCommand.Throttle NoThrottle;
    private final String AnyLogDir;
    private final int EarliestVersion;
    private final String helpText;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Map<TopicPartitionReplica, String> $lessinit$greater$default$4() {
        return scala.collection.Map$.MODULE$.empty();
    }

    public ReassignPartitionsCommand.Throttle NoThrottle() {
        return this.NoThrottle;
    }

    public String AnyLogDir() {
        return this.AnyLogDir;
    }

    public int EarliestVersion() {
        return this.EarliestVersion;
    }

    public String helpText() {
        return this.helpText;
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = this.validateAndParseArgs(args);
        String zkConnect = (String)opts.options().valueOf(opts.zkConnectOpt());
        Time time = Time.SYSTEM;
        Option<Admin> adminClientOpt = this.createAdminClient(opts);
        try (KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnect, JaasUtils.isZkSecurityEnabled(), 30000, 30000, Integer.MAX_VALUE, time, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8(), KafkaZkClient$.MODULE$.apply$default$9());){
            try {
                if (opts.options().has((OptionSpec)opts.verifyOpt())) {
                    this.verifyAssignment(zkClient, adminClientOpt, opts);
                } else if (opts.options().has((OptionSpec)opts.generateOpt())) {
                    this.generateAssignment(zkClient, opts);
                } else if (opts.options().has((OptionSpec)opts.executeOpt())) {
                    this.executeAssignment(zkClient, adminClientOpt, opts);
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(38).append("Partitions reassignment failed due to ").append(e.getMessage()).toString());
                Predef$.MODULE$.println((Object)Utils.stackTrace((Throwable)e));
            }
        }
    }

    private Option<Admin> createAdminClient(ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (opts.options().has(opts.bootstrapServerOpt())) {
            Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
            props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
            props.putIfAbsent("client.id", "reassign-partitions-tool");
            return new Some((Object)AdminClient.create((Properties)props));
        }
        return None$.MODULE$;
    }

    public void verifyAssignment(KafkaZkClient zkClient, Option<Admin> adminClientOpt, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String jsonString = Utils.readFileAsString((String)((String)opts.options().valueOf(opts.reassignmentJsonFileOpt())));
        this.verifyAssignment(zkClient, adminClientOpt, jsonString);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyAssignment(KafkaZkClient zkClient, Option<Admin> adminClientOpt, String jsonString) {
        void var7_7;
        void var6_6;
        Predef$.MODULE$.println((Object)"Status of partition reassignment: ");
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq partitionsToBeReassigned = (Seq)tuple2._1();
        Map replicaAssignment = (Map)tuple2._2();
        void partitionsToBeReassigned2 = var6_6;
        void replicaAssignment2 = var7_7;
        Map<TopicPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfPartitionReassignmentSucceeded(zkClient, (Map<TopicPartition, Seq<Object>>)partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()));
        Map<TopicPartitionReplica, ReassignmentStatus> replicasReassignmentStatus = this.checkIfReplicaReassignmentSucceeded(adminClientOpt, (Map<TopicPartitionReplica, String>)replicaAssignment2);
        reassignedPartitionsStatus.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ReassignPartitionsCommand$.$anonfun$verifyAssignment$1(x0$1);
            return BoxedUnit.UNIT;
        });
        replicasReassignmentStatus.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ReassignPartitionsCommand$.$anonfun$verifyAssignment$2(x0$2);
            return BoxedUnit.UNIT;
        });
        this.removeThrottle(zkClient, reassignedPartitionsStatus, replicasReassignmentStatus, adminZkClient);
    }

    public void removeThrottle(KafkaZkClient zkClient, Map<TopicPartition, ReassignmentStatus> reassignedPartitionsStatus, Map<TopicPartitionReplica, ReassignmentStatus> replicasReassignmentStatus, AdminZkClient adminZkClient) {
        if (reassignedPartitionsStatus.forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$removeThrottle$1(x0$1))) && replicasReassignmentStatus.forall((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$removeThrottle$2(x0$2)))) {
            BooleanRef changed = BooleanRef.create((boolean)false);
            ((IterableLike)zkClient.getAllBrokersInCluster().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Seq$.MODULE$.canBuildFrom())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
                Properties configs = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString());
                if (configs.remove(DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()) != null) {
                    adminZkClient.changeBrokerConfig((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId}))), configs);
                    changed$1.elem = true;
                }
            });
            ((Seq)((SetLike)reassignedPartitionsStatus.keySet().map((Function1 & Serializable & scala.Serializable)tp -> tp.topic(), Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)replicasReassignmentStatus.keySet().map((Function1 & Serializable & scala.Serializable)replica -> replica.topic(), Set$.MODULE$.canBuildFrom())).toSeq().distinct()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ReassignPartitionsCommand$.$anonfun$removeThrottle$7(adminZkClient, changed, topic);
                return BoxedUnit.UNIT;
            });
            if (changed.elem) {
                Predef$.MODULE$.println((Object)"Throttle was removed.");
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void generateAssignment(KafkaZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        void var10_12;
        void var9_11;
        String topicsToMoveJsonFile = (String)opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
        String string = (String)opts.options().valueOf(opts.brokerListOpt());
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int[] brokerListToReassign = (int[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(string).split(','))), (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ReassignPartitionsCommand$.$anonfun$generateAssignment$1(x$3)), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Iterable duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            String string2 = "Broker list contains duplicate entries: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new AdminCommandFailedException(new StringOps(string2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignments.mkString(",")})));
        }
        String topicsToMoveJsonString = Utils.readFileAsString((String)topicsToMoveJsonFile);
        boolean disableRackAware = opts.options().has((OptionSpec)opts.disableRackAware());
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> tuple2 = this.generateAssignment(zkClient, (Seq<Object>)Predef$.MODULE$.wrapIntArray(brokerListToReassign), topicsToMoveJsonString, disableRackAware);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map proposedAssignments = (Map)tuple2._1();
        Map currentAssignments = (Map)tuple2._2();
        void proposedAssignments2 = var9_11;
        void currentAssignments2 = var10_12;
        String string3 = "Current partition replica assignment\n%s\n";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps(string3).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicPartition, Seq<Object>>)currentAssignments2, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
        String string4 = "Proposed partition reassignment configuration\n%s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps(string4).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson((Map<TopicPartition, Seq<Object>>)proposedAssignments2, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
    }

    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> generateAssignment(KafkaZkClient zkClient, Seq<Object> brokerListToReassign, String topicsToMoveJsonString, boolean disableRackAware) {
        Seq<String> topicsToReassign = this.parseTopicsData(topicsToMoveJsonString);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            String string = "List of topics to reassign contains duplicate entries: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new AdminCommandFailedException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateTopicsToReassign.mkString(",")})));
        }
        Map<TopicPartition, Seq<Object>> currentAssignment = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)topicsToReassign.toSet());
        scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String string = ((TopicPartition)x0$1._1()).topic();
            return string;
        });
        Product rackAwareMode = disableRackAware ? RackAwareMode$Disabled$.MODULE$ : RackAwareMode$Enforced$.MODULE$;
        Seq<BrokerMetadata> brokerMetadatas = new AdminZkClient(zkClient).getBrokerMetadatas((RackAwareMode)rackAwareMode, (Option<Seq<Object>>)new Some(brokerListToReassign));
        scala.collection.mutable.Map partitionsToBeReassigned = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        groupedByTopic.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            void var7_6;
            Map assignment;
            String topic;
            if (x0$2 != null) {
                topic = (String)x0$2._1();
                assignment = (Map)x0$2._2();
                Tuple2 tuple2 = (Tuple2)assignment.head();
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Seq replicas = (Seq)tuple2._2();
            } else {
                throw new MatchError(null);
            }
            Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, assignment.size(), var7_6.size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)partitionsToBeReassigned.$plus$plus$eq((TraversableOnce)assignedReplicas.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                void $minus$greater$extension_$this;
                Seq replicas;
                if (x0$3 != null) {
                    int partition = x0$3._1$mcI$sp();
                    replicas = (Seq)x0$3._2();
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition));
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom()));
            return map;
        });
        return new Tuple2((Object)partitionsToBeReassigned, currentAssignment);
    }

    public void executeAssignment(KafkaZkClient zkClient, Option<Admin> adminClientOpt, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String reassignmentJsonString = Utils.readFileAsString((String)((String)opts.options().valueOf(opts.reassignmentJsonFileOpt())));
        long interBrokerThrottle = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.interBrokerThrottleOpt()));
        long replicaAlterLogDirsThrottle = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.replicaAlterLogDirsThrottleOpt()));
        long timeoutMs = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.timeoutOpt()));
        this.executeAssignment(zkClient, adminClientOpt, reassignmentJsonString, new ReassignPartitionsCommand.Throttle(interBrokerThrottle, replicaAlterLogDirsThrottle, ReassignPartitionsCommand$Throttle$.MODULE$.apply$default$3()), timeoutMs);
    }

    /*
     * WARNING - void declaration
     */
    public void executeAssignment(KafkaZkClient zkClient, Option<Admin> adminClientOpt, String reassignmentJsonString, ReassignPartitionsCommand.Throttle throttle, long timeoutMs) {
        void var9_8;
        void var8_7;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parseAndValidate(zkClient, reassignmentJsonString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq partitionAssignment = (Seq)tuple2._1();
        Map replicaAssignment = (Map)tuple2._2();
        void partitionAssignment2 = var8_7;
        void replicaAssignment2 = var9_8;
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkClient, adminClientOpt, (Map<TopicPartition, Seq<Object>>)partitionAssignment2.toMap(Predef$.MODULE$.$conforms()), (Map<TopicPartitionReplica, String>)replicaAssignment2, adminZkClient);
        if (zkClient.reassignPartitionsInProgress()) {
            Predef$.MODULE$.println((Object)"There is an existing assignment running.");
            reassignPartitionsCommand.maybeLimit(throttle);
            return;
        }
        this.printCurrentAssignment(zkClient, (Seq<String>)((Seq)partitionAssignment2.map((Function1 & Serializable & scala.Serializable)x$6 -> ((TopicPartition)x$6._1()).topic(), Seq$.MODULE$.canBuildFrom())));
        if (throttle.interBrokerLimit() >= 0L || throttle.replicaAlterLogDirsLimit() >= 0L) {
            Predef$.MODULE$.println((Object)String.format("Warning: You must run Verify periodically, until the reassignment completes, to ensure the throttle is removed. You can also alter the throttle by rerunning the Execute command passing a new value.", new Object[0]));
        }
        if (reassignPartitionsCommand.reassignPartitions(throttle, timeoutMs)) {
            Predef$.MODULE$.println((Object)"Successfully started reassignment of partitions.");
            return;
        }
        String string = "Failed to reassign partitions %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionAssignment2})));
    }

    public long executeAssignment$default$5() {
        return 10000L;
    }

    public void printCurrentAssignment(KafkaZkClient zkClient, Seq<String> topics) {
        Map<TopicPartition, Seq<Object>> currentPartitionReplicaAssignment = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)topics.toSet());
        String string = "Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatAsReassignmentJson(currentPartitionReplicaAssignment, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
    }

    /*
     * WARNING - void declaration
     */
    public String formatAsReassignmentJson(Map<TopicPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicPartitionReplica, String> replicaLogDirAssignment) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[2];
        Integer n = BoxesRunTime.boxToInteger((int)1);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"version");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Object object2 = JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array;
            if (x0$1 != null) {
                void $minus$greater$extension_y2;
                void $minus$greater$extension_$this2;
                void $minus$greater$extension_y3;
                void $minus$greater$extension_$this3;
                void $minus$greater$extension_y4;
                void $minus$greater$extension_$this4;
                TopicPartition tp = (TopicPartition)x0$1._1();
                Seq replicas = (Seq)x0$1._2();
                tuple2Array = new Tuple2[4];
                String string = tp.topic();
                Object object = Predef$.MODULE$.ArrowAssoc((Object)"topic");
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
                Integer n = BoxesRunTime.boxToInteger((int)tp.partition());
                Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"partition");
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
                Object object3 = JavaConverters$.MODULE$.seqAsJavaListConverter(replicas).asJava();
                Object object4 = Predef$.MODULE$.ArrowAssoc((Object)"replicas");
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
                Object object5 = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)r -> ReassignPartitionsCommand$.$anonfun$formatAsReassignmentJson$2(replicaLogDirAssignment, tp, BoxesRunTime.unboxToInt((Object)r)), Seq$.MODULE$.canBuildFrom())).asJava();
                Object object6 = Predef$.MODULE$.ArrowAssoc((Object)"log_dirs");
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            java.util.Map map = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
            return map;
        }, Iterable$.MODULE$.canBuildFrom())).asJava();
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"partitions");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        return Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<String> parseTopicsData(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt((Object)((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
                return this.parseTopicsData(n, js);
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestVersion();
            }
            return this.parseTopicsData(n, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    public Seq<String> parseTopicsData(int version, JsonValue js) {
        switch (version) {
            case 1: {
                return (Seq)Option$.MODULE$.option2Iterable(js.asJsonObject().get("topics")).toSeq().flatMap((Function1 & Serializable & scala.Serializable)partitionsSeq -> partitionsSeq.asJsonArray().iterator().map((Function1 & Serializable & scala.Serializable)p -> p.asJsonObject().apply("topic").to(DecodeJson$DecodeString$.MODULE$)), Seq$.MODULE$.canBuildFrom());
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(String jsonData) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            int n;
            JsonValue js = (JsonValue)((Some)option).value();
            Option<JsonValue> option2 = js.asJsonObject().get("version");
            if (option2 instanceof Some) {
                n = BoxesRunTime.unboxToInt((Object)((JsonValue)((Some)option2).value()).to(DecodeJson$DecodeInt$.MODULE$));
                return this.parsePartitionReassignmentData(n, js);
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                n = this.EarliestVersion();
            }
            return this.parsePartitionReassignmentData(n, js);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new AdminOperationException("The input string is not a valid JSON");
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(int version, JsonValue jsonData) {
        switch (version) {
            case 1: {
                ListBuffer partitionAssignment = (ListBuffer)ListBuffer$.MODULE$.empty();
                scala.collection.mutable.Map replicaAssignment = Map$.MODULE$.empty();
                Option$.MODULE$.option2Iterable(jsonData.asJsonObject().get("partitions")).toSeq().foreach((Function1 & Serializable & scala.Serializable)partitionsSeq -> {
                    ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$1(partitionAssignment, replicaAssignment, partitionsSeq);
                    return BoxedUnit.UNIT;
                });
                return new Tuple2((Object)partitionAssignment, (Object)replicaAssignment);
            }
        }
        throw new AdminOperationException(new StringBuilder(34).append("Not supported version field value ").append(version).toString());
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parseAndValidate(KafkaZkClient zkClient, String reassignmentJsonString) {
        void var5_5;
        void var4_4;
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(reassignmentJsonString);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq partitionsToBeReassigned = (Seq)tuple2._1();
        Map replicaAssignment = (Map)tuple2._2();
        void partitionsToBeReassigned2 = var4_4;
        void replicaAssignment2 = var5_5;
        if (partitionsToBeReassigned2.isEmpty()) {
            throw new AdminCommandFailedException("Partition reassignment data file is empty");
        }
        if (partitionsToBeReassigned2.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseAndValidate$1(x$10)))) {
            throw new AdminCommandFailedException("Partition replica list cannot be empty");
        }
        Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates((Traversable)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            void var1_1;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            return var1_1;
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicateReassignedPartitions.nonEmpty()) {
            String string = "Partition reassignment contains duplicate topic partitions: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new AdminCommandFailedException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateReassignedPartitions.mkString(",")})));
        }
        Seq duplicateEntries = (Seq)((TraversableLike)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Seq replicas = (Seq)x0$2._2();
            Tuple2 tuple2 = new Tuple2((Object)tp, CoreUtils$.MODULE$.duplicates(replicas));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parseAndValidate$4(x0$3)));
        if (duplicateEntries.nonEmpty()) {
            String duplicatesMsg = ((TraversableOnce)duplicateEntries.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                String string;
                Iterable duplicateReplicas;
                TopicPartition tp;
                if (x0$4 != null) {
                    tp = (TopicPartition)x0$4._1();
                    duplicateReplicas = (Iterable)x0$4._2();
                    string = "%s contains multiple entries for %s";
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                String string2 = new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tp, duplicateReplicas.mkString(",")}));
                return string2;
            }, Seq$.MODULE$.canBuildFrom())).mkString(". ");
            String string = "Partition replica lists may not contain duplicate entries: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            throw new AdminCommandFailedException(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatesMsg})));
        }
        Seq proposedTopics = (Seq)((SeqLike)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            if (x0$5 == null) {
                throw new MatchError(null);
            }
            String string = ((TopicPartition)x0$5._1()).topic();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        Map<TopicPartition, Seq<Object>> existingAssignment = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)proposedTopics.toSet());
        Seq nonExistentPartitions = (Seq)((TraversableLike)partitionsToBeReassigned2.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            void var1_1;
            if (x0$6 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$6._1();
            return var1_1;
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)existingAssignment.contains((Object)key)));
        if (nonExistentPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(58).append("The proposed assignment contains non-existent partitions: ").append(nonExistentPartitions).toString());
        }
        Seq<Object> existingBrokerIDs = zkClient.getSortedBrokerList();
        scala.collection.immutable.Set nonExistingBrokerIDs = ((TraversableOnce)((TraversableLike)partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()).values().flatten((Function1)Predef$.MODULE$.$conforms())).filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)existingBrokerIDs.contains(elem)))).toSet();
        if (nonExistingBrokerIDs.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(57).append("The proposed assignment contains non-existent brokerIDs: ").append(nonExistingBrokerIDs.mkString(",")).toString());
        }
        return new Tuple2((Object)partitionsToBeReassigned2, (Object)replicaAssignment2);
    }

    /*
     * WARNING - void declaration
     */
    public Map<TopicPartition, ReassignmentStatus> checkIfPartitionReassignmentSucceeded(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> partitionsToBeReassigned) {
        void var6_6;
        void var5_5;
        Map<TopicPartition, Seq<Object>> partitionsBeingReassigned = zkClient.getPartitionReassignment();
        Tuple2 tuple2 = partitionsToBeReassigned.keys().partition((Function1 & Serializable & scala.Serializable)topicAndPartition -> BoxesRunTime.boxToBoolean((boolean)partitionsBeingReassigned.contains((Object)topicAndPartition)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Iterable beingReassigned = (Iterable)tuple2._1();
        Iterable notBeingReassigned = (Iterable)tuple2._2();
        void beingReassigned2 = var5_5;
        return ((MapLike)var6_6.groupBy((Function1 & Serializable & scala.Serializable)x$12 -> x$12.topic()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            Iterable partitions = (Iterable)x0$1._2();
            Map<TopicPartition, Seq<Object>> replicasForTopic = zkClient.getReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
            Iterable iterable = (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)topicAndPartition -> {
                void var3_7;
                Seq newReplicas = (Seq)partitionsToBeReassigned.apply(topicAndPartition);
                Option option = replicasForTopic.get(topicAndPartition);
                if (option instanceof Some) {
                    Seq seq = (Seq)((Some)option).value();
                    if (!(seq != null ? !seq.equals(newReplicas) : newReplicas != null)) {
                        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                        return new Tuple2(topicAndPartition, (Object)var3_7);
                    }
                }
                ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                return new Tuple2(topicAndPartition, (Object)var3_7);
            }, Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)((TraversableOnce)beingReassigned2.map((Function1 & Serializable & scala.Serializable)topicAndPartition -> new Tuple2(topicAndPartition, (Object)ReassignmentInProgress$.MODULE$), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    private Map<TopicPartitionReplica, ReassignmentStatus> checkIfReplicaReassignmentSucceeded(Option<Admin> adminClientOpt, Map<TopicPartitionReplica, String> replicaAssignment) {
        scala.collection.immutable.Map map;
        if (replicaAssignment.nonEmpty()) {
            if (adminClientOpt == null) {
                throw null;
            }
            if (adminClientOpt.isEmpty()) {
                throw ReassignPartitionsCommand$.$anonfun$checkIfReplicaReassignmentSucceeded$1();
            }
            Admin adminClient = (Admin)adminClientOpt.get();
            map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)adminClient.describeReplicaLogDirs((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter(replicaAssignment.keySet()).asJava()).all().get()).asScala();
        } else {
            map = scala.collection.Map$.MODULE$.empty();
        }
        scala.collection.immutable.Map replicaLogDirInfos = map;
        return (Map)replicaAssignment.map(arg_0 -> ReassignPartitionsCommand$.$anonfun$checkIfReplicaReassignmentSucceeded$2((Map)replicaLogDirInfos, arg_0), scala.collection.Map$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.ReassignPartitionsCommandOptions validateAndParseArgs(String[] args) {
        void var2_2;
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.helpText());
        if (((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.generateOpt(), opts.executeOpt(), opts.verifyOpt()}))).count(arg_0 -> ReassignPartitionsCommand$.$anonfun$validateAndParseArgs$1$adapted(opts.options(), arg_0)) != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --generate, --execute or --verify");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.zkConnectOpt()}));
        if (opts.options().has((OptionSpec)opts.verifyOpt())) {
            if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
            }
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.verifyOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.interBrokerThrottleOpt(), opts.replicaAlterLogDirsThrottleOpt(), opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()}))));
        } else if (opts.options().has((OptionSpec)opts.generateOpt())) {
            if (!opts.options().has(opts.topicsToMoveJsonFileOpt()) || !opts.options().has(opts.brokerListOpt())) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
            }
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.generateOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.interBrokerThrottleOpt(), opts.replicaAlterLogDirsThrottleOpt(), opts.reassignmentJsonFileOpt()}))));
        } else if (opts.options().has((OptionSpec)opts.executeOpt())) {
            if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
            }
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), (OptionSpec<?>)opts.executeOpt(), (Set<OptionSpec<?>>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()}))));
        }
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$verifyAssignment$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            ReassignmentStatus status = (ReassignmentStatus)x0$1._2();
            if (ReassignmentCompleted$.MODULE$.equals(status)) {
                String string = "Reassignment of partition %s completed successfully";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                return;
            }
            if (ReassignmentFailed$.MODULE$.equals(status)) {
                String string = "Reassignment of partition %s failed";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                return;
            }
            if (ReassignmentInProgress$.MODULE$.equals(status)) {
                String string = "Reassignment of partition %s is still in progress";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
                return;
            }
            throw new MatchError((Object)status);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyAssignment$2(Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartitionReplica replica = (TopicPartitionReplica)x0$2._1();
            ReassignmentStatus status = (ReassignmentStatus)x0$2._2();
            if (ReassignmentCompleted$.MODULE$.equals(status)) {
                String string = "Reassignment of replica %s completed successfully";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})));
                return;
            }
            if (ReassignmentFailed$.MODULE$.equals(status)) {
                String string = "Reassignment of replica %s failed";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})));
                return;
            }
            if (ReassignmentInProgress$.MODULE$.equals(status)) {
                String string = "Reassignment of replica %s is still in progress";
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replica})));
                return;
            }
            throw new MatchError((Object)status);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$removeThrottle$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        ReassignmentStatus reassignmentStatus = (ReassignmentStatus)x0$1._2();
        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
        boolean bl = !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$removeThrottle$2(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        ReassignmentStatus reassignmentStatus = (ReassignmentStatus)x0$2._2();
        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
        boolean bl = !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$removeThrottle$7(AdminZkClient adminZkClient$1, BooleanRef changed$1, String topic) {
        Properties configs = adminZkClient$1.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        if (configs.remove(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()) != null | configs.remove(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()) != null) {
            adminZkClient$1.changeTopicConfig(topic, configs);
            changed$1.elem = true;
        }
    }

    public static final /* synthetic */ int $anonfun$generateAssignment$1(String x$3) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(x$3).toInt();
    }

    public static final /* synthetic */ String $anonfun$formatAsReassignmentJson$2(Map replicaLogDirAssignment$1, TopicPartition tp$1, int r) {
        return (String)replicaLogDirAssignment$1.getOrElse((Object)new TopicPartitionReplica(tp$1.topic(), tp$1.partition(), r), (Function0 & Serializable & scala.Serializable)() -> MODULE$.AnyLogDir());
    }

    public static final /* synthetic */ boolean $anonfun$parsePartitionReassignmentData$5(Tuple2 x$8) {
        Object object = x$8._2();
        String string = MODULE$.AnyLogDir();
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ void $anonfun$parsePartitionReassignmentData$1(ListBuffer partitionAssignment$1, scala.collection.mutable.Map replicaAssignment$1, JsonValue partitionsSeq) {
        partitionsSeq.asJsonArray().iterator().foreach((Function1 & Serializable & scala.Serializable)p -> {
            void $minus$greater$extension_$this;
            Seq seq;
            JsonObject partitionFields = p.asJsonObject();
            String topic = partitionFields.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
            int partition = BoxesRunTime.unboxToInt((Object)partitionFields.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
            Seq newReplicas = (Seq)partitionFields.apply("replicas").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            Option<JsonValue> option = partitionFields.get("log_dirs");
            if (option instanceof Some) {
                seq = (Seq)((JsonValue)((Some)option).value()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            } else if (None$.MODULE$.equals(option)) {
                seq = (Seq)newReplicas.map((Function1 & Serializable & scala.Serializable)x$7 -> ReassignPartitionsCommand$.MODULE$.AnyLogDir(), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(option);
            }
            if (newReplicas.size() != seq.size()) {
                throw new AdminCommandFailedException(new StringBuilder(78).append("Size of replicas list ").append(newReplicas).append(" is different from ").append("size of log dirs list ").append(seq).append(" for partition ").append(new TopicPartition(topic, partition)).toString());
            }
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            partitionAssignment$1.$plus$eq((Object)new Tuple2((Object)$minus$greater$extension_$this, (Object)newReplicas));
            return (scala.collection.mutable.Map)replicaAssignment$1.$plus$plus$eq((TraversableOnce)((TraversableLike)((TraversableLike)newReplicas.zip((GenIterable)seq, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                void $minus$greater$extension_$this;
                String logDir;
                if (x0$1 != null) {
                    int replica = x0$1._1$mcI$sp();
                    logDir = (String)x0$1._2();
                    Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica(topic, partition, replica));
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)logDir);
                return tuple2;
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$5(x$8))));
        });
    }

    public static final /* synthetic */ boolean $anonfun$parseAndValidate$1(Tuple2 x$10) {
        return ((SeqLike)x$10._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseAndValidate$4(Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((Iterable)x0$3._2()).nonEmpty();
        return bl;
    }

    public static final /* synthetic */ Nothing$ $anonfun$checkIfReplicaReassignmentSucceeded$1() {
        throw new AdminCommandFailedException("bootstrap-server needs to be provided in order to reassign replica to the specified log directory");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Tuple2 $anonfun$checkIfReplicaReassignmentSucceeded$2(Map replicaLogDirInfos$1, Tuple2 x0$1) {
        void var3_8;
        if (x0$1 == null) throw new MatchError(null);
        TopicPartitionReplica replica = (TopicPartitionReplica)x0$1._1();
        String newLogDir = (String)x0$1._2();
        Option option = replicaLogDirInfos$1.get((Object)replica);
        if (option instanceof Some) {
            Product product;
            DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaLogDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((Some)option).value();
            if (replicaLogDirInfo.getCurrentReplicaLogDir() == null) {
                Predef$.MODULE$.println((Object)new StringBuilder(109).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" is not found in any live log dir on ").append("broker ").append(replica.brokerId()).append(". There is likely offline log directory on the broker.").toString());
                product = ReassignmentFailed$.MODULE$;
            } else {
                String string = replicaLogDirInfo.getFutureReplicaLogDir();
                if (!(string != null ? !string.equals(newLogDir) : newLogDir != null)) {
                    product = ReassignmentInProgress$.MODULE$;
                } else if (replicaLogDirInfo.getFutureReplicaLogDir() != null) {
                    Predef$.MODULE$.println((Object)new StringBuilder(61).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" on broker ").append(replica.brokerId()).append(" ").append("is being moved to log dir ").append(replicaLogDirInfo.getFutureReplicaLogDir()).append(" instead of ").append(newLogDir).toString());
                    product = ReassignmentFailed$.MODULE$;
                } else {
                    String string2 = replicaLogDirInfo.getCurrentReplicaLogDir();
                    if (!(string2 != null ? !string2.equals(newLogDir) : newLogDir != null)) {
                        product = ReassignmentCompleted$.MODULE$;
                    } else {
                        Predef$.MODULE$.println((Object)new StringBuilder(59).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" on broker ").append(replica.brokerId()).append(" ").append("is not being moved from log dir ").append(replicaLogDirInfo.getCurrentReplicaLogDir()).append(" to ").append(newLogDir).toString());
                        product = ReassignmentFailed$.MODULE$;
                    }
                }
            }
            ReassignmentInProgress$ reassignmentInProgress$ = product;
            return new Tuple2((Object)replica, (Object)var3_8);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            Predef$.MODULE$.println((Object)new StringBuilder(56).append("Partition ").append(replica.topic()).append("-").append(replica.partition()).append(" is not found in any live log dir on broker ").append(replica.brokerId()).append(".").toString());
            ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
        }
        return new Tuple2((Object)replica, (Object)var3_8);
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.NoThrottle = new ReassignPartitionsCommand.Throttle(-1L, -1L, ReassignPartitionsCommand$Throttle$.MODULE$.apply$default$3());
        this.AnyLogDir = "any";
        this.EarliestVersion = 1;
        this.helpText = "This tool helps to moves topic partitions between replicas.";
    }

    public static final /* synthetic */ Object $anonfun$validateAndParseArgs$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.has(x$1));
    }
}

