/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import kafka.admin.ZkSecurityMigrator;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;

public final class ZkSecurityMigrator$
implements Logging {
    public static ZkSecurityMigrator$ MODULE$;
    private final String usageMessage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ZkSecurityMigrator$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String usageMessage() {
        return this.usageMessage;
    }

    public void run(String[] args) {
        boolean bl;
        String jaasFile = System.getProperty("java.security.auth.login.config");
        ZkSecurityMigrator.ZkSecurityMigratorOptions opts = new ZkSecurityMigrator.ZkSecurityMigratorOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.usageMessage());
        if (jaasFile == null) {
            String string = "the system property %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String errorMsg = new StringBuilder(82).append("No JAAS configuration file has been specified. Please make sure that you have set ").append(new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"java.security.auth.login.config"}))).toString();
            String string2 = "ERROR: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            System.out.println(new StringOps(string2).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
            throw new IllegalArgumentException("Incorrect configuration");
        }
        if (!JaasUtils.isZkSecurityEnabled()) {
            String string = "Security isn't enabled, most likely the file isn't set properly: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            String errorMsg = new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jaasFile}));
            String string3 = "ERROR: %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            System.out.println(new StringOps(string3).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
            throw new IllegalArgumentException("Incorrect configuration");
        }
        String string = (String)opts.options().valueOf(opts.zkAclOpt());
        if ("secure".equals(string)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(ZkSecurityMigrator$.$anonfun$run$1()));
            }
            bl = true;
        } else if ("unsecure".equals(string)) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(ZkSecurityMigrator$.$anonfun$run$2()));
            }
            bl = false;
        } else {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), this.usageMessage());
        }
        String zkUrl = (String)opts.options().valueOf(opts.zkUrlOpt());
        int zkSessionTimeout = (Integer)opts.options().valueOf(opts.zkSessionTimeoutOpt());
        int zkConnectionTimeout = (Integer)opts.options().valueOf(opts.zkConnectionTimeoutOpt());
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkUrl, bl, zkSessionTimeout, zkConnectionTimeout, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8(), KafkaZkClient$.MODULE$.apply$default$9());
        new ZkSecurityMigrator(zkClient).kafka$admin$ZkSecurityMigrator$$run();
    }

    public void main(String[] args) {
        try {
            this.run(args);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$run$1() {
        return "zookeeper.acl option is secure";
    }

    public static final /* synthetic */ String $anonfun$run$2() {
        return "zookeeper.acl option is unsecure";
    }

    private ZkSecurityMigrator$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.usageMessage = "ZooKeeper Migration Tool Help. This tool updates the ACLs of znodes as part of the process of setting up ZooKeeper authentication.";
    }
}

