/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\tmv!B\u0012%\u0011\u0003Yc!B\u0017%\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004\"B\u001c\u0002\t\u0003A\u0004b\u0002BW\u0003\u0011%!q\u0016\u0005\b\u0005k\u000bA\u0011\u0002B\\\r\u0011iC\u0005\u0001\u001e\t\u0011\u00053!\u0011!Q\u0001\n\tC\u0001\"\u0012\u0004\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0013\u001a\u0011\t\u0011)A\u0005\u0015\"AQJ\u0002B\u0001B\u0003%a\n\u0003\u0005R\r\t\u0005\t\u0015!\u0003S\u0011!)fA!A!\u0002\u00131\u0006\u0002C-\u0007\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011\u00194!\u0011!Q\u0001\n\u001dDQ!\u000e\u0004\u0005\u0002),Aa\u001d\u0004\u0001i\u0016!QP\u0002\u0001\u007f\u000b\u0015\tYA\u0002\u0001\u007f\u000b\u0019\tiA\u0002\u0001\u0002\u0010!I\u0011q\b\u0004C\u0002\u0013%\u0011\u0011\t\u0005\t\u000372\u0001\u0015!\u0003\u0002D!9\u0011Q\f\u0004\u0005\u0002\u0005}\u0003bBAA\r\u0011%\u00111\u0011\u0005\b\u0003K3A\u0011AAT\u0011\u001d\tYN\u0002C\u0001\u0003;Dq!!:\u0007\t\u0003\t9\u000fC\u0004\u0002n\u001a!I!a<\t\u000f\t]a\u0001\"\u0001\u0003\u001a!9!\u0011\u0006\u0004\u0005\u0002\t-\u0002b\u0002B\u001b\r\u0011\u0005!q\u0007\u0005\b\u0005w1A\u0011\u0002B\u001f\u0011\u001d\u0011yD\u0002C\u0001\u0005\u0003B\u0011B!\u0014\u0007#\u0003%\tAa\u0014\t\u000f\t\u0015d\u0001\"\u0001\u0003>\u00051BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'O\u0003\u0002&M\u0005YAO]1og\u0006\u001cG/[8o\u0015\t9\u0003&A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0015\u0002\u000b-\fgm[1\u0004\u0001A\u0011A&A\u0007\u0002I\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'o\u0005\u0002\u0002_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001fe\u00129Ga\u001e\u0003\u0002\n\r%1\u0013BQ\u0005W\u0003\"\u0001\f\u0004\u0014\u0007\u0019y3\b\u0005\u0002=\u007f5\tQH\u0003\u0002?Q\u0005)Q\u000f^5mg&\u0011\u0001)\u0010\u0002\b\u0019><w-\u001b8h\u0003!\u0011'o\\6fe&#\u0007C\u0001\u0019D\u0013\t!\u0015GA\u0002J]R\f\u0011\u0002\u001e=o\u0007>tg-[4\u0011\u00051:\u0015B\u0001%%\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\ng\u000eDW\rZ;mKJ\u0004\"\u0001P&\n\u00051k$!C*dQ\u0016$W\u000f\\3s\u0003E\u0001(o\u001c3vG\u0016\u0014\u0018\nZ'b]\u0006<WM\u001d\t\u0003Y=K!\u0001\u0015\u0013\u0003#A\u0013x\u000eZ;dKJLE-T1oC\u001e,'/\u0001\u0006uq:l\u0015M\\1hKJ\u0004\"\u0001L*\n\u0005Q##a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003]!\bP\\'be.,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0005\u0002-/&\u0011\u0001\f\n\u0002 )J\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004\"a\u00173\u000e\u0003qS!AP/\u000b\u0005y{\u0016AB2p[6|gN\u0003\u0002*A*\u0011\u0011MY\u0001\u0007CB\f7\r[3\u000b\u0003\r\f1a\u001c:h\u0013\t)GL\u0001\u0003US6,\u0017A\u00037pO\u000e{g\u000e^3yiB\u00111\f[\u0005\u0003Sr\u0013!\u0002T8h\u0007>tG/\u001a=u)%I4\u000e\\7o_B\f(\u000fC\u0003B\u001f\u0001\u0007!\tC\u0003F\u001f\u0001\u0007a\tC\u0003J\u001f\u0001\u0007!\nC\u0003N\u001f\u0001\u0007a\nC\u0003R\u001f\u0001\u0007!\u000bC\u0003V\u001f\u0001\u0007a\u000bC\u0003Z\u001f\u0001\u0007!\fC\u0003g\u001f\u0001\u0007qM\u0001\fJ]&$\bK]8ek\u000e,'/\u00133DC2d'-Y2l!\u0011\u0001To\u001e>\n\u0005Y\f$!\u0003$v]\u000e$\u0018n\u001c82!\ta\u00030\u0003\u0002zI\t!\u0012J\\5u!J|G-^2fe&#'+Z:vYR\u0004\"\u0001M>\n\u0005q\f$\u0001B+oSR\u0014Q#\u00113e!\u0006\u0014H/\u001b;j_:\u001c8)\u00197mE\u0006\u001c7\u000e\u0005\u00031k~T\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015Q,\u0001\u0005qe>$xnY8m\u0013\u0011\tI!a\u0001\u0003\r\u0015\u0013(o\u001c:t\u00059)e\u000e\u001a+y]\u000e\u000bG\u000e\u001c2bG.\u0014\u0011\"\u00119j%\u0016\u001cX\u000f\u001c;\u0016\t\u0005E\u0011Q\u0006\t\b\u0003'\t\u0019c`A\u0015\u001d\u0011\t)\"a\b\u000f\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007+\u0003\u0019a$o\\8u}%\t!'C\u0002\u0002\"E\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002&\u0005\u001d\"AB#ji\",'OC\u0002\u0002\"E\u0002B!a\u000b\u0002.1\u0001AaBA\u0018'\t\u0007\u0011\u0011\u0007\u0002\u0002)F!\u00111GA\u001d!\r\u0001\u0014QG\u0005\u0004\u0003o\t$a\u0002(pi\"Lgn\u001a\t\u0004a\u0005m\u0012bAA\u001fc\t\u0019\u0011I\\=\u0002\u0011%\u001c\u0018i\u0019;jm\u0016,\"!a\u0011\u0011\t\u0005\u0015\u0013qK\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u00051\u0011\r^8nS\u000eTA!!\u0014\u0002P\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005E\u00131K\u0001\u0005kRLGN\u0003\u0002\u0002V\u0005!!.\u0019<b\u0013\u0011\tI&a\u0012\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003%I7/Q2uSZ,\u0007%\u0001\u000biC:$G.Z%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\bu\u0006\u0005\u0014QOA=\u0011\u001d\t\u0019G\u0006a\u0001\u0003K\nq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\t\u0005\u0003O\nyG\u0004\u0003\u0002j\u0005-\u0004cAA\fc%\u0019\u0011QN\u0019\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t(a\u001d\u0003\rM#(/\u001b8h\u0015\r\ti'\r\u0005\u0007\u0003o2\u0002\u0019\u0001\"\u0002)Q\u0014\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t\u0011\u001d\tYH\u0006a\u0001\u0003{\n\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u0007\u0005}\u0004#D\u0001\u0007\u0003m\u0001(/\u001a9be\u0016Le.\u001b;Qe>$WoY3JIR\u0013\u0018M\\:jiRQ\u0011QQAJ\u0003+\u000b9*a'\u0011\u000b\u0005}4#a\"\u0011\rA\nIIQAG\u0013\r\tY)\r\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u00071\ny)C\u0002\u0002\u0012\u0012\u0012!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\"9\u00111M\fA\u0002\u0005\u0015\u0004BBA</\u0001\u0007!\t\u0003\u0004\u0002\u001a^\u0001\rAQ\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"Dq!!(\u0018\u0001\u0004\ty*A\u0006uq:lU\r^1eCR\f\u0007c\u0001\u0017\u0002\"&\u0019\u00111\u0015\u0013\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0002A!\fg\u000e\u001a7f\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_R\u0013\u0018M\\:bGRLwN\u001c\u000b\fu\u0006%\u00161VA[\u0003\u007f\u000b9\u000eC\u0004\u0002da\u0001\r!!\u001a\t\u000f\u00055\u0006\u00041\u0001\u00020\u0006Q\u0001O]8ek\u000e,'/\u00133\u0011\u0007A\n\t,C\u0002\u00024F\u0012A\u0001T8oO\"9\u0011q\u0017\rA\u0002\u0005e\u0016!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u00021\u0003wK1!!02\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\t\t\r\u0007a\u0001\u0003\u0007\f!\u0002]1si&$\u0018n\u001c8t!\u0019\t)-a3\u0002P6\u0011\u0011q\u0019\u0006\u0004\u0003\u0013\f\u0014AC2pY2,7\r^5p]&!\u0011QZAd\u0005\r\u0019V\r\u001e\t\u0005\u0003#\f\u0019.D\u0001^\u0013\r\t).\u0018\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\tY\b\u0007a\u0001\u00033\u00042!a \u0012\u0003QA\u0017M\u001c3mKRCh.S7nS\u001e\u0014\u0018\r^5p]R)!0a8\u0002d\"1\u0011\u0011]\rA\u0002\t\u000b1\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8o\u0013\u0012Da!!'\u001a\u0001\u0004\u0011\u0015a\u00055b]\u0012dW\r\u0016=o\u000b6LwM]1uS>tG#\u0002>\u0002j\u0006-\bBBAq5\u0001\u0007!\t\u0003\u0004\u0002\u001aj\u0001\rAQ\u0001(Y><\u0017J\u001c<bY&$7\u000b^1uKR\u0013\u0018M\\:ji&|g.\u00118e%\u0016$XO\u001d8FeJ|'\u000f\u0006\u0005\u0002r\u0006m\u0018Q B\u0004!\u001d\t\u00190a>\u0000\u0003gi!!!>\u000b\u0007\u0005E\u0013'\u0003\u0003\u0002z\u0006U(\u0001\u0002'fMRDq!a\u0019\u001c\u0001\u0004\t)\u0007C\u0004\u0002\u0000n\u0001\rA!\u0001\u0002!Q\u0014\u0018M\\:bGRLwN\\*uCR,\u0007c\u0001\u0017\u0003\u0004%\u0019!Q\u0001\u0013\u0003!Q\u0013\u0018M\\:bGRLwN\\*uCR,\u0007b\u0002B\u00057\u0001\u0007!1B\u0001\u0012iJ\fgn]1di&|gNU3tk2$\b\u0003\u0002B\u0007\u0005'i!Aa\u0004\u000b\u0007\tEQ,\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011)Ba\u0004\u0003#Q\u0013\u0018M\\:bGRLwN\u001c*fgVdG/\u0001\u000biC:$G.Z#oIR\u0013\u0018M\\:bGRLwN\u001c\u000b\fu\nm!Q\u0004B\u0010\u0005C\u0011)\u0003C\u0004\u0002dq\u0001\r!!\u001a\t\u000f\u00055F\u00041\u0001\u00020\"9\u0011q\u0017\u000fA\u0002\u0005e\u0006b\u0002B\u00129\u0001\u0007!1B\u0001\u0010ibtW*\u0019:lKJ\u0014Vm];mi\"9\u00111\u0010\u000fA\u0002\t\u001d\u0002cAA@%\u00059BO]1og\u0006\u001cG/[8o)>\u0004\u0018nY\"p]\u001aLwm]\u000b\u0003\u0005[\u0001BAa\f\u000325\u0011\u0011qJ\u0005\u0005\u0005g\tyE\u0001\u0006Qe>\u0004XM\u001d;jKN\fA\u0002]1si&$\u0018n\u001c8G_J$2A\u0011B\u001d\u0011\u001d\t\u0019G\ba\u0001\u0003K\n\u0011$\u00192peR$\u0016.\\3e\u001fV$HK]1og\u0006\u001cG/[8ogR\t!0A\u0004ti\u0006\u0014H/\u001e9\u0015\u0007i\u0014\u0019\u0005C\u0005\u0003F\u0001\u0002\n\u00111\u0001\u0003H\u0005yRM\\1cY\u0016$&/\u00198tC\u000e$\u0018n\u001c8bY&#W\t\u001f9je\u0006$\u0018n\u001c8\u0011\u0007A\u0012I%C\u0002\u0003LE\u0012qAQ8pY\u0016\fg.A\tti\u0006\u0014H/\u001e9%I\u00164\u0017-\u001e7uIE*\"A!\u0015+\t\t\u001d#1K\u0016\u0003\u0005+\u0002BAa\u0016\u0003b5\u0011!\u0011\f\u0006\u0005\u00057\u0012i&A\u0005v]\u000eDWmY6fI*\u0019!qL\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003d\te#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006A1\u000f[;uI><h\u000eC\u0004\u0003j\r\u0001\rAa\u001b\u0002\r\r|gNZ5h!\u0011\u0011iGa\u001d\u000e\u0005\t=$b\u0001B9Q\u000511/\u001a:wKJLAA!\u001e\u0003p\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d\u0011Ih\u0001a\u0001\u0005w\naB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0003\u0003n\tu\u0014\u0002\u0002B@\u0005_\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'\u000fC\u0003J\u0007\u0001\u0007!\nC\u0004\u0003\u0006\u000e\u0001\rAa\"\u0002\u0011i\\7\t\\5f]R\u0004BA!#\u0003\u00106\u0011!1\u0012\u0006\u0004\u0005\u001bC\u0013A\u0001>l\u0013\u0011\u0011\tJa#\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0011\u001d\u0011)j\u0001a\u0001\u0005/\u000bq!\\3ue&\u001c7\u000f\u0005\u0003\u0003\u001a\nuUB\u0001BN\u0015\r\u0011)*X\u0005\u0005\u0005?\u0013YJA\u0004NKR\u0014\u0018nY:\t\u000f\t\r6\u00011\u0001\u0003&\u0006iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004BA!\u001c\u0003(&!!\u0011\u0016B8\u00055iU\r^1eCR\f7)Y2iK\")\u0011l\u0001a\u00015\u0006!\u0012N\\5u)J\fgn]1di&|g.\u0012:s_J$2a\u001eBY\u0011\u0019\u0011\u0019\f\u0002a\u0001\u007f\u0006)QM\u001d:pe\u00069\u0012N\\5u)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u000b\u0004o\ne\u0006bBAO\u000b\u0001\u0007\u0011Q\u0012")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final ProducerIdManager producerIdManager;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Scheduler scheduler, KafkaZkClient kafkaZkClient, Metrics metrics, MetadataCache metadataCache, Time time) {
        return TransactionCoordinator$.MODULE$.apply(kafkaConfig, replicaManager, scheduler, kafkaZkClient, metrics, metadataCache, time);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Function1<InitProducerIdResult, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        Either either;
        Either either2;
        if (transactionalId == null) {
            long producerId = this.producerIdManager.generateProducerId();
            responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
            return;
        }
        if (transactionalId.isEmpty()) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
            return;
        }
        if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
            return;
        }
        Either.RightProjection rightProjection = this.txnManager.getTransactionState(transactionalId).right();
        if (rightProjection == null) {
            throw null;
        }
        Either.RightProjection flatMap_this = rightProjection;
        Either either3 = flatMap_this.e();
        if (either3 instanceof Right) {
            Option option = (Option)((Right)either3).value();
            either2 = TransactionCoordinator.$anonfun$handleInitProducerId$1(this, transactionalId, transactionTimeoutMs, option);
        } else {
            either2 = flatMap_this.e();
        }
        Either.RightProjection rightProjection2 = either2.right();
        if (rightProjection2 == null) {
            throw null;
        }
        Either.RightProjection flatMap_this2 = rightProjection2;
        Either either4 = flatMap_this2.e();
        if (either4 instanceof Right) {
            CoordinatorEpochAndTxnMetadata coordinatorEpochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Right)either4).value();
            either = TransactionCoordinator.$anonfun$handleInitProducerId$2(this, transactionalId, transactionTimeoutMs, coordinatorEpochAndTxnMetadata);
        } else {
            either = flatMap_this2.e();
        }
        if (either instanceof Left) {
            Errors error2 = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            TransactionState transactionState = newMetadata.txnState();
            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
            if (!(transactionState != null ? !transactionState.equals(prepareEpochFence$) : prepareEpochFence$ != null)) {
                this.handleEndTransaction(transactionalId, newMetadata.producerId(), newMetadata.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                    Errors errors = error;
                    Errors errors2 = Errors.NONE;
                    if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                    } else {
                        responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
                    }
                    return BoxedUnit.UNIT;
                });
                return;
            }
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata));
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
                    responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError((Errors)error));
                }
                return BoxedUnit.UNIT;
            }, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError((Object)either);
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProduceIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata) {
        Left left;
        if (txnMetadata.pendingTransitionInProgress()) {
            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        }
        TransactionState transactionState = txnMetadata.state();
        boolean bl = PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState);
        if (bl) {
            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        } else {
            boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState));
            if (bl2) {
                TxnTransitMetadata txnTransitMetadata;
                if (txnMetadata.isProducerEpochExhausted()) {
                    long newProducerId = this.producerIdManager.generateProducerId();
                    txnTransitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, transactionTimeoutMs, this.time.milliseconds());
                } else {
                    txnTransitMetadata = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, this.time.milliseconds());
                }
                TxnTransitMetadata transitMetadata = txnTransitMetadata;
                left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
            } else if (Ongoing$.MODULE$.equals(transactionState)) {
                left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
            } else {
                boolean bl3 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                if (bl3) {
                    String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                throw new MatchError((Object)transactionState);
            }
        }
        return left;
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        Either either;
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either.RightProjection rightProjection = this.txnManager.getTransactionState(transactionalId).right();
        if (rightProjection == null) {
            throw null;
        }
        Either.RightProjection flatMap_this = rightProjection;
        Either either2 = flatMap_this.e();
        if (either2 instanceof Right) {
            Option option = (Option)((Right)either2).value();
            either = TransactionCoordinator.$anonfun$handleAddPartitionsToTransaction$2(this, producerId, producerEpoch, partitions, option);
        } else {
            either = flatMap_this.e();
        }
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError((Object)either);
    }

    public void handleTxnImmigration(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function5 & Serializable & scala.Serializable)(transactionalId, coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId, BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void handleTxnEmigration(int txnTopicPartitionId, int coordinatorEpoch) {
        this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch);
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("TransactionalId: ").append(transactionalId).append("'s state is ").append(transactionState).append(", but received transaction ").append("marker result to send: ").append(transactionResult).toString());
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback) {
        Tuple2 tuple2;
        Either either;
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either.RightProjection rightProjection = this.txnManager.getTransactionState(transactionalId).right();
        if (rightProjection == null) {
            throw null;
        }
        Either.RightProjection flatMap_this = rightProjection;
        Either either2 = flatMap_this.e();
        if (either2 instanceof Right) {
            Option option = (Option)((Right)either2).value();
            either = TransactionCoordinator.$anonfun$handleEndTransaction$1(this, producerId, producerEpoch, txnMarkerResult, transactionalId, option);
        } else {
            either = flatMap_this.e();
        }
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)error -> {
                Errors errors = error;
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    Either either;
                    Either.RightProjection rightProjection = $this.txnManager.getTransactionState(transactionalId).right();
                    if (rightProjection == null) {
                        throw null;
                    }
                    Either.RightProjection $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_flatMap_this = rightProjection;
                    Either either2 = $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_flatMap_this.e();
                    if (either2 instanceof Right) {
                        Option option = (Option)((Right)either2).value();
                        either = TransactionCoordinator.$anonfun$handleEndTransaction$5(this, transactionalId, coordinatorEpoch, producerId, producerEpoch, txnMarkerResult, option);
                    } else {
                        either = $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_flatMap_this.e();
                    }
                    if (either instanceof Left) {
                        Errors $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_err = (Errors)((Left)either).value();
                        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)$anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_err);
                        return BoxedUnit.UNIT;
                    } else {
                        Tuple2 tuple2;
                        if (!(either instanceof Right) || (tuple2 = (Tuple2)((Right)either).value()) == null) throw new MatchError((Object)either);
                        TransactionMetadata $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                        TxnTransitMetadata $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                        responseCallback.apply((Object)Errors.NONE);
                        $this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId, coordinatorEpoch, txnMarkerResult, $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_txnMetadata, $anonfun$handleEndTransaction$12_sendTxnMarkersCallback$1_newPreSendMetadata);
                    }
                    return BoxedUnit.UNIT;
                } else {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(newMetadata).append(" to transaction log with coordinator epoch ").append(coordinatorEpoch).append(" failed").toString());
                    responseCallback.apply(error);
                }
                return BoxedUnit.UNIT;
            }, this.txnManager.appendTransactionToLog$default$5());
            return;
        }
        throw new MatchError((Object)either);
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void abortTimedOutTransactions() {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable & scala.Serializable)txnIdAndPidEpoch -> {
            Either either;
            Either.RightProjection rightProjection = $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).right();
            if (rightProjection == null) {
                throw null;
            }
            Either.RightProjection flatMap_this = rightProjection;
            Either either2 = flatMap_this.e();
            if (either2 instanceof Right) {
                Option option = (Option)((Right)either2).value();
                either = TransactionCoordinator.$anonfun$abortTimedOutTransactions$2(this, txnIdAndPidEpoch, option);
            } else {
                either = flatMap_this.e();
            }
            return either;
        });
    }

    public void startup(boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.abortTimedOutTransactions(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.scheduler.schedule$default$5());
        if (enableTransactionalIdExpiration) {
            this.txnManager.enableTransactionalIdExpiration();
        }
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$1() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdManager.shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete.");
    }

    public static final /* synthetic */ Either $anonfun$handleInitProducerId$1(TransactionCoordinator $this, String transactionalId$1, int transactionTimeoutMs$1, Option x0$1) {
        Either<Errors, CoordinatorEpochAndTxnMetadata> either;
        if (None$.MODULE$.equals(x0$1)) {
            long producerId = $this.producerIdManager.generateProducerId();
            short x$3 = -1;
            Empty$ x$5 = Empty$.MODULE$;
            scala.collection.mutable.Set x$6 = Set$.MODULE$.empty();
            long x$7 = $this.time.milliseconds();
            long x$8 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
            TransactionMetadata createdMetadata = new TransactionMetadata(transactionalId$1, producerId, x$3, transactionTimeoutMs$1, x$5, (scala.collection.mutable.Set<TopicPartition>)x$6, x$8, x$7);
            either = $this.txnManager.putTransactionStateIfNotExists(transactionalId$1, createdMetadata);
        } else if (x0$1 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
            either = package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
        } else {
            throw new MatchError((Object)x0$1);
        }
        return either;
    }

    public static final /* synthetic */ Either $anonfun$handleInitProducerId$2(TransactionCoordinator $this, String transactionalId$1, int transactionTimeoutMs$1, CoordinatorEpochAndTxnMetadata existingEpochAndMetadata) {
        int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
        TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
        return (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> $this.prepareInitProduceIdTransit(transactionalId$1, transactionTimeoutMs$1, coordinatorEpoch, txnMetadata));
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$4(Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
            return;
        }
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    public static final /* synthetic */ void $anonfun$handleInitProducerId$7(TransactionCoordinator $this, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("Initialized transactionalId ").append(transactionalId).append(" with producerId ").append(newMetadata.producerId()).append(" and producer ").append("epoch ").append(newMetadata.producerEpoch()).append(" on partition ").append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId)).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
    }

    public static final /* synthetic */ Either $anonfun$handleAddPartitionsToTransaction$2(TransactionCoordinator $this, long producerId$1, short producerEpoch$1, Set partitions$1, Option x0$1) {
        Left left;
        if (None$.MODULE$.equals(x0$1)) {
            left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
        } else if (x0$1 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
            int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
            TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
            left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                block8: {
                    block7: {
                        if (txnMetadata.producerId() != producerId$1) {
                            return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                        }
                        if (txnMetadata.producerEpoch() != producerEpoch$1) {
                            return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                        }
                        if (txnMetadata.pendingTransitionInProgress()) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                        TransactionState transactionState = txnMetadata.state();
                        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                        if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block7;
                        TransactionState transactionState2 = txnMetadata.state();
                        PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                        if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block8;
                    }
                    return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                }
                TransactionState transactionState = txnMetadata.state();
                Ongoing$ ongoing$ = Ongoing$.MODULE$;
                if (!(transactionState != null ? !transactionState.equals(ongoing$) : ongoing$ != null) && partitions$1.subsetOf(txnMetadata.topicPartitions())) {
                    return package$.MODULE$.Left().apply((Object)Errors.NONE);
                }
                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions$1.toSet(), $this.time.milliseconds())));
            });
        } else {
            throw new MatchError((Object)x0$1);
        }
        return left;
    }

    public static final /* synthetic */ Either $anonfun$handleEndTransaction$1(TransactionCoordinator $this, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, String transactionalId$4, Option x0$1) {
        Left left;
        if (None$.MODULE$.equals(x0$1)) {
            left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
        } else if (x0$1 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
            TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
            int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
            left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                Right right;
                TransactionState transactionState;
                if (txnMetadata.producerId() != producerId$2) {
                    return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                }
                if (producerEpoch$2 < txnMetadata.producerEpoch()) {
                    return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    Object object = txnMetadata.pendingState().get();
                    PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                    if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                }
                if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                    Product nextState;
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult2 = TransactionResult.COMMIT;
                    Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                    PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                    if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                        txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                        txnMetadata.producerEpoch_$eq(producerEpoch$2);
                    }
                    right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult3 = TransactionResult.COMMIT;
                    right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult4 = TransactionResult.ABORT;
                    right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult5 = TransactionResult.COMMIT;
                    right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                    TransactionResult transactionResult = txnMarkerResult$1;
                    TransactionResult transactionResult6 = TransactionResult.ABORT;
                    right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else if (Empty$.MODULE$.equals(transactionState)) {
                    right = $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                } else {
                    boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                    if (bl) {
                        String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId$4).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                        $this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    throw new MatchError((Object)transactionState);
                }
                return right;
            });
        } else {
            throw new MatchError((Object)x0$1);
        }
        return left;
    }

    public static final /* synthetic */ Either $anonfun$handleEndTransaction$5(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$4, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Option x0$1) {
        Left left;
        if (None$.MODULE$.equals(x0$1)) {
            String errorMsg = new StringBuilder(118).append("The coordinator still owns the transaction partition for ").append(transactionalId$4).append(", but there is ").append("no metadata in the cache; this is not expected").toString();
            $this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        if (x0$1 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$4) {
                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                left = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    Left<Errors, Nothing$> left;
                    if (txnMetadata.producerId() != producerId$2) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (txnMetadata.producerEpoch() != producerEpoch$2) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    TransactionState transactionState = txnMetadata.state();
                    boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                    if (bl) {
                        left = $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult$1;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult$1;
                        TransactionResult transactionResult3 = TransactionResult.ABORT;
                        left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? $this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                    } else {
                        boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl2) {
                            String errorMsg = new StringBuilder(103).append("Found transactionalId ").append(transactionalId$4).append(" with state ").append(txnMetadata.state()).append(". ").append("This is illegal as we should never have transitioned to this state.").toString();
                            $this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return left;
                });
            } else {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult$1).append(" was ").append("successfully appended to the log for ").append(transactionalId$4).append(" with old epoch ").append(coordinatorEpoch$4).toString());
                left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
            }
        } else {
            throw new MatchError((Object)x0$1);
        }
        Left left2 = left;
        return left2;
    }

    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$4, int coordinatorEpoch$4, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either either;
            Either.RightProjection rightProjection = this.txnManager.getTransactionState(transactionalId$4).right();
            if (rightProjection == null) {
                throw null;
            }
            Either.RightProjection flatMap_this = rightProjection;
            Either either2 = flatMap_this.e();
            if (either2 instanceof Right) {
                Option option = (Option)((Right)either2).value();
                either = TransactionCoordinator.$anonfun$handleEndTransaction$5(this, transactionalId$4, coordinatorEpoch$4, producerId$2, producerEpoch$2, txnMarkerResult$1, option);
            } else {
                either = flatMap_this.e();
            }
            if (either instanceof Left) {
                Errors err = (Errors)((Left)either).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            }
            if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId$4, coordinatorEpoch$4, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)either);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(newMetadata).append(" to transaction log with coordinator epoch ").append(coordinatorEpoch).append(" failed").toString());
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$handleEndTransaction$12(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$4, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, Errors error) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either either;
            Either.RightProjection rightProjection = $this.txnManager.getTransactionState(transactionalId$4).right();
            if (rightProjection == null) {
                throw null;
            }
            Either.RightProjection sendTxnMarkersCallback$1_flatMap_this = rightProjection;
            Either either2 = sendTxnMarkersCallback$1_flatMap_this.e();
            if (either2 instanceof Right) {
                Option option = (Option)((Right)either2).value();
                either = TransactionCoordinator.$anonfun$handleEndTransaction$5($this, transactionalId$4, coordinatorEpoch$4, producerId$2, producerEpoch$2, txnMarkerResult$1, option);
            } else {
                either = sendTxnMarkersCallback$1_flatMap_this.e();
            }
            if (either instanceof Left) {
                Errors sendTxnMarkersCallback$1_err = (Errors)((Left)either).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult).append(" to transaction log and returning ").append(sendTxnMarkersCallback$1_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)sendTxnMarkersCallback$1_err);
                return;
            }
            if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                TransactionMetadata sendTxnMarkersCallback$1_txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata sendTxnMarkersCallback$1_newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                $this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId$4, coordinatorEpoch$4, txnMarkerResult$1, sendTxnMarkersCallback$1_txnMetadata, sendTxnMarkersCallback$1_newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)either);
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(172).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId).append("'s EndTransaction request of ").append(txnMarkerResult).append(", ").append("since appending ").append(newMetadata).append(" to transaction log with coordinator epoch ").append(coordinatorEpoch).append(" failed").toString());
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$6(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$1, Errors x0$2) {
        if (Errors.NONE.equals(x0$2)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Completed rollback ongoing transaction of transactionalId: ").append(txnIdAndPidEpoch$1.transactionalId()).append(" due to timeout").toString());
            return;
        }
        boolean bl = Errors.INVALID_PRODUCER_ID_MAPPING.equals(x0$2) ? true : (Errors.INVALID_PRODUCER_EPOCH.equals(x0$2) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(x0$2));
        if (bl) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Rolling back ongoing transaction of transactionalId: ").append(txnIdAndPidEpoch$1.transactionalId()).append(" has aborted due to ").append(x0$2.exceptionName()).toString());
            return;
        }
        $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Rolling back ongoing transaction of transactionalId: ").append(txnIdAndPidEpoch$1.transactionalId()).append(" failed due to ").append(x0$2.exceptionName()).toString());
    }

    public static final /* synthetic */ Either $anonfun$abortTimedOutTransactions$2(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$1, Option x0$1) {
        Left left;
        if (None$.MODULE$.equals(x0$1)) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(123).append("Could not find transaction metadata when trying to timeout transaction with transactionalId ").append(txnIdAndPidEpoch$1.transactionalId()).append(". ProducerId: ").append(txnIdAndPidEpoch$1.producerId()).append(". ProducerEpoch: ").append(txnIdAndPidEpoch$1.producerEpoch()).toString());
            left = package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
        } else if (x0$1 instanceof Some) {
            Left left2;
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
            Either transitMetadata = (Either)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                if (txnMetadata.producerId() != txnIdAndPidEpoch$1.producerId()) {
                    $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch$1.transactionalId()).append(". ").append("Expected producerId: ").append(txnIdAndPidEpoch$1.producerId()).append(". Found producerId: ").append(txnMetadata.producerId()).toString());
                    return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                }
                return package$.MODULE$.Right().apply((Object)txnMetadata.prepareFenceProducerEpoch());
            });
            if (transitMetadata instanceof Right) {
                TxnTransitMetadata txnTransitMetadata = (TxnTransitMetadata)((Right)transitMetadata).value();
                $this.handleEndTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$2 -> {
                    TransactionCoordinator.$anonfun$abortTimedOutTransactions$6($this, txnIdAndPidEpoch$1, x0$2);
                    return BoxedUnit.UNIT;
                });
                left2 = package$.MODULE$.Right().apply((Object)txnTransitMetadata);
            } else {
                left2 = package$.MODULE$.Left().apply((Object)transitMetadata);
            }
            left = left2;
        } else {
            throw new MatchError((Object)x0$1);
        }
        return left;
    }

    public TransactionCoordinator(int brokerId, TransactionConfig txnConfig, Scheduler scheduler, ProducerIdManager producerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.producerIdManager = producerIdManager;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
    }
}

