/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.FetchLogEnd$;
import kafka.server.ReplicaManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005x!\u0002\u001c8\u0011\u0003qd!\u0002!8\u0011\u0003\t\u0005\"\u0002%\u0002\t\u0003I\u0005b\u0002&\u0002\u0005\u0004%\ta\u0013\u0005\u0007\u001f\u0006\u0001\u000b\u0011\u0002'\t\u000fA\u000b!\u0019!C\u0001\u0017\"1\u0011+\u0001Q\u0001\n1CqAU\u0001C\u0002\u0013\u00051\n\u0003\u0004T\u0003\u0001\u0006I\u0001\u0014\u0005\b)\u0006\u0011\r\u0011\"\u0001L\u0011\u0019)\u0016\u0001)A\u0005\u0019\u001a!\u0001i\u000e\u0001W\u0011!i6B!A!\u0002\u0013a\u0005\u0002\u00030\f\u0005\u0003\u0005\u000b\u0011B0\t\u0011\u0015\\!\u0011!Q\u0001\n\u0019D\u0001\"[\u0006\u0003\u0002\u0003\u0006IA\u001b\u0005\ta.\u0011\t\u0011)A\u0005c\"AAo\u0003B\u0001B\u0003%Q\u000f\u0003\u0006\u0002\u0004-\u0011\t\u0011)A\u0005\u0003\u000bAa\u0001S\u0006\u0005\u0002\u0005=QABA\u0011\u0017\u0001\t\u0019\u0003C\u0005\u0002^-\u0011\r\u0011\"\u0003\u0002`!A\u0011\u0011P\u0006!\u0002\u0013\t\t\u0007C\u0005\u0002|-\u0011\r\u0011\"\u0003\u0002~!A\u00111R\u0006!\u0002\u0013\ty\bC\u0005\u0002\u000e.\u0011\r\u0011\"\u0003\u0002\u0010\"A\u0011qU\u0006!\u0002\u0013\t\t\nC\u0005\u0002*.\u0011\r\u0011\"\u0003\u0002\u0010\"A\u00111V\u0006!\u0002\u0013\t\t\nC\u0005\u0002..\u0011\r\u0011\"\u0003\u00020\"A\u0011QX\u0006!\u0002\u0013\t\t\f\u0003\u0005\u0002@.\u0011\r\u0011\"\u0003L\u0011\u001d\t\tm\u0003Q\u0001\n1C\u0011\"a1\f\u0005\u0004%I!!2\t\u0011\u000557\u0002)A\u0005\u0003\u000fD\u0001\"a4\f\t\u00039\u0014\u0011\u001b\u0005\t\u00037\\A\u0011A\u001c\u0002^\"9\u00111^\u0006\u0005\u0002\u00055\bb\u0002B\u0004\u0017\u0011\u0005!\u0011\u0002\u0005\b\u0005\u0017YA\u0011\u0001B\u0007\u0011\u001d\u0011\td\u0003C\u0001\u0005gAqA!\u0010\f\t\u0013\u0011y\u0004C\u0004\u0003J-!\tAa\u0013\t\u000f\t]3\u0002\"\u0001\u0003Z!9!1M\u0006\u0005\u0002\t\u0015\u0004B\u0002B5\u0017\u0011%1\nC\u0004\u0003l-!IA!\u001c\t\u0011\t\r5\u0002\"\u00018\u0005\u000bCqA!%\f\t\u0003\u0011\u0019\nC\u0004\u0003\".!\tAa)\t\u000f\t%6\u0002\"\u0003\u0003\n!9!1V\u0006\u0005\u0002\t5\u0006\"\u0003Bd\u0017E\u0005I\u0011\u0001Be\u0011\u001d\u0011yn\u0003C\u0001\u0005\u0013\tq\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\u000b\u0005aJ\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:T!AO\u001e\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002y\u0005)1.\u00194lC\u000e\u0001\u0001CA \u0002\u001b\u00059$a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s'\t\t!\t\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\nq\u0004R3gCVdG\u000f\u0016:b]N\f7\r^5p]Nl\u0015\r\u001f+j[\u0016|W\u000f^'t+\u0005a\u0005CA\"N\u0013\tqEIA\u0002J]R\f\u0001\u0005R3gCVdG\u000f\u0016:b]N\f7\r^5p]Nl\u0015\r\u001f+j[\u0016|W\u000f^'tA\u0005\u0011C)\u001a4bk2$HK]1og\u0006\u001cG/[8oC2LE-\u0012=qSJ\fG/[8o\u001bN\f1\u0005R3gCVdG\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]6\u001b\b%\u0001\u0016EK\u001a\fW\u000f\u001c;BE>\u0014H\u000fV5nK\u0012|U\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u001c\u0018J\u001c;feZ\fG.T:\u0002W\u0011+g-Y;mi\u0006\u0013wN\u001d;US6,GmT;u)J\fgn]1di&|gn]%oi\u0016\u0014h/\u00197Ng\u0002\na\u0006R3gCVdGOU3n_Z,W\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm]%oi\u0016\u0014h/\u00197Ng\u0006yC)\u001a4bk2$(+Z7pm\u0016,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7/\u00138uKJ4\u0018\r\\'tAM\u00191BQ,\u0011\u0005a[V\"A-\u000b\u0005i[\u0014!B;uS2\u001c\u0018B\u0001/Z\u0005\u001daunZ4j]\u001e\f\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u0001\tu.\u001cE.[3oiB\u0011\u0001mY\u0007\u0002C*\u0011!mO\u0001\u0003u.L!\u0001Z1\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002YO&\u0011\u0001.\u0017\u0002\n'\u000eDW\rZ;mKJ\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002l]6\tAN\u0003\u0002nw\u000511/\u001a:wKJL!a\u001c7\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u000611m\u001c8gS\u001e\u0004\"a\u0010:\n\u0005M<$!\u0005+sC:\u001c\u0018m\u0019;j_:\u001cuN\u001c4jO\u0006!A/[7f!\t1x0D\u0001x\u0015\tQ\u0006P\u0003\u0002zu\u000611m\\7n_:T!\u0001P>\u000b\u0005ql\u0018AB1qC\u000eDWMC\u0001\u007f\u0003\ry'oZ\u0005\u0004\u0003\u00039(\u0001\u0002+j[\u0016\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0002\b\u0005-QBAA\u0005\u0015\r\t\u0019\u0001_\u0005\u0005\u0003\u001b\tIAA\u0004NKR\u0014\u0018nY:\u0015!\u0005E\u00111CA\u000b\u0003/\tI\"a\u0007\u0002\u001e\u0005}\u0001CA \f\u0011\u0015i6\u00031\u0001M\u0011\u0015q6\u00031\u0001`\u0011\u0015)7\u00031\u0001g\u0011\u0015I7\u00031\u0001k\u0011\u0015\u00018\u00031\u0001r\u0011\u0015!8\u00031\u0001v\u0011\u001d\t\u0019a\u0005a\u0001\u0003\u000b\u0011acU3oIRCh.T1sW\u0016\u00148oQ1mY\n\f7m\u001b\t\u000f\u0007\u0006\u0015\u0012\u0011\u0006'\u0002@\u0005-\u0013\u0011KA,\u0013\r\t9\u0003\u0012\u0002\n\rVt7\r^5p]V\u0002B!a\u000b\u0002:9!\u0011QFA\u001b!\r\ty\u0003R\u0007\u0003\u0003cQ1!a\r>\u0003\u0019a$o\\8u}%\u0019\u0011q\u0007#\u0002\rA\u0013X\rZ3g\u0013\u0011\tY$!\u0010\u0003\rM#(/\u001b8h\u0015\r\t9\u0004\u0012\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t=\u0002\u0011I,\u0017/^3tiNLA!!\u0013\u0002D\t\tBK]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\u0011\u0007}\ni%C\u0002\u0002P]\u00121\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006\u00042aPA*\u0013\r\t)f\u000e\u0002\u0013)btGK]1og&$X*\u001a;bI\u0006$\u0018\rE\u0002D\u00033J1!a\u0017E\u0005\u0011)f.\u001b;\u0002\u0019MDW\u000f\u001e;j]\u001e$un\u001e8\u0016\u0005\u0005\u0005\u0004\u0003BA2\u0003kj!!!\u001a\u000b\t\u0005\u001d\u0014\u0011N\u0001\u0007CR|W.[2\u000b\t\u0005-\u0014QN\u0001\u000bG>t7-\u001e:sK:$(\u0002BA8\u0003c\nA!\u001e;jY*\u0011\u00111O\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002x\u0005\u0015$!D!u_6L7MQ8pY\u0016\fg.A\u0007tQV$H/\u001b8h\t><h\u000eI\u0001\ngR\fG/\u001a'pG.,\"!a \u0011\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007SA!!\"\u0002j\u0005)An\\2lg&!\u0011\u0011RAB\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017AC:uCR,Gj\\2lA\u0005\tBn\\1eS:<\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005E\u0005CBAJ\u0003;\u000b\t+\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003\u001diW\u000f^1cY\u0016T1!a'E\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\u000b)JA\u0002TKR\u00042aPAR\u0013\r\t)k\u000e\u0002#)J\fgn]1di&|g\u000eU1si&$\u0018n\u001c8B]\u0012dU-\u00193fe\u0016\u0003xn\u00195\u0002%1|\u0017\rZ5oOB\u000b'\u000f^5uS>t7\u000fI\u0001\u0012Y\u0016\fg/\u001b8h!\u0006\u0014H/\u001b;j_:\u001c\u0018A\u00057fCZLgn\u001a)beRLG/[8og\u0002\n\u0001\u0004\u001e:b]N\f7\r^5p]6+G/\u00193bi\u0006\u001c\u0015m\u00195f+\t\t\t\fE\u0004\u0002\u0014\u0006MF*a.\n\t\u0005U\u0016Q\u0013\u0002\u0004\u001b\u0006\u0004\bcA \u0002:&\u0019\u00111X\u001c\u0003+QCh.T3uC\u0012\fG/Y\"bG\",WI\u001c;ss\u0006IBO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003y!(/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG/A\u0010ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi\u0002\n1\u0003]1si&$\u0018n\u001c8M_\u0006$7+\u001a8t_J,\"!a2\u0011\t\u0005\u001d\u0011\u0011Z\u0005\u0005\u0003\u0017\fIA\u0001\u0004TK:\u001cxN]\u0001\u0015a\u0006\u0014H/\u001b;j_:du.\u00193TK:\u001cxN\u001d\u0011\u0002'\u0005$G\rT8bI&tw\rU1si&$\u0018n\u001c8\u0015\r\u0005]\u00131[Al\u0011\u0019\t)n\ta\u0001\u0019\u0006Y\u0001/\u0019:uSRLwN\\%e\u0011\u0019\tIn\ta\u0001\u0019\u0006\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r[\u0001\u000egR\fG/\u001a*fC\u0012dunY6\u0016\u0005\u0005}\u0007\u0003BAq\u0003Ol!!a9\u000b\t\u0005\u0015\u00181Q\u0001\u0017%\u0016,g\u000e\u001e:b]R\u0014V-\u00193Xe&$X\rT8dW&!\u0011\u0011^Ar\u0005!\u0011V-\u00193M_\u000e\\\u0017\u0001\u0006;j[\u0016$w*\u001e;Ue\u0006t7/Y2uS>t7\u000f\u0006\u0002\u0002pB1\u0011\u0011_A~\u0005\u0003qA!a=\u0002x:!\u0011qFA{\u0013\u0005)\u0015bAA}\t\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u007f\u0003\u007f\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003s$\u0005cA \u0003\u0004%\u0019!QA\u001c\u0003CQ\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\fe\u000e\u001a)s_\u0012,8-\u001a:JI\u0016\u0003xn\u00195\u0002?\u0015t\u0017M\u00197f)J\fgn]1di&|g.\u00197JI\u0016C\b/\u001b:bi&|g\u000e\u0006\u0002\u0002X\u0005\u0019r-\u001a;Ue\u0006t7/Y2uS>t7\u000b^1uKR!!q\u0002B\u0017!!\t\tP!\u0005\u0003\u0016\t\u0005\u0012\u0002\u0002B\n\u0003\u007f\u0014a!R5uQ\u0016\u0014\b\u0003\u0002B\f\u0005;i!A!\u0007\u000b\u0007\tm\u00010\u0001\u0005qe>$xnY8m\u0013\u0011\u0011yB!\u0007\u0003\r\u0015\u0013(o\u001c:t!\u0015\u0019%1\u0005B\u0014\u0013\r\u0011)\u0003\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007}\u0012I#C\u0002\u0003,]\u0012adQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195B]\u0012$\u0006P\\'fi\u0006$\u0017\r^1\t\u000f\t=r\u00051\u0001\u0002*\u0005yAO]1og\u0006\u001cG/[8oC2LE-\u0001\u0010qkR$&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-\u00134O_R,\u00050[:ugR1!Q\u0007B\u001c\u0005s\u0001\u0002\"!=\u0003\u0012\tU!q\u0005\u0005\b\u0005_A\u0003\u0019AA\u0015\u0011\u001d\u0011Y\u0004\u000ba\u0001\u0003\u0017\n1\u0002\u001e=o\u001b\u0016$\u0018\rZ1uC\u0006qr-\u001a;B]\u0012l\u0015-\u001f2f\u0003\u0012$GK]1og\u0006\u001cG/[8o'R\fG/\u001a\u000b\u0007\u0005\u001f\u0011\tEa\u0011\t\u000f\t=\u0012\u00061\u0001\u0002*!9!QI\u0015A\u0002\t\u001d\u0013!F2sK\u0006$X\r\u001a+y]6+G/\u00193bi\u0006|\u0005\u000f\u001e\t\u0006\u0007\n\r\u00121J\u0001\u001dm\u0006d\u0017\u000eZ1uKR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t)\u0011\u0011iEa\u0015\u0011\u0007\r\u0013y%C\u0002\u0003R\u0011\u0013qAQ8pY\u0016\fg\u000e\u0003\u0004\u0003V)\u0002\r\u0001T\u0001\ribtG+[7f_V$Xj]\u0001\u0018iJ\fgn]1di&|g\u000eV8qS\u000e\u001cuN\u001c4jON,\"Aa\u0017\u0011\t\tu#qL\u0007\u0003\u0003[JAA!\u0019\u0002n\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u0019A\f'\u000f^5uS>tgi\u001c:\u0015\u00071\u00139\u0007C\u0004\u000301\u0002\r!!\u000b\u0002C\u001d,G\u000f\u0016:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u0002/1|\u0017\r\u001a+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\fGC\u0002B8\u0005k\u0012\t\tE\u0004Y\u0005c\nI#a\u0013\n\u0007\tM\u0014L\u0001\u0003Q_>d\u0007b\u0002B<]\u0001\u0007!\u0011P\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\u0011YH! \u000e\u0003aL1Aa y\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Da!!7/\u0001\u0004a\u0015\u0001H1eI2{\u0017\rZ3e)J\fgn]1di&|gn\u001d+p\u0007\u0006\u001c\u0007.\u001a\u000b\t\u0003/\u00129Ia#\u0003\u000e\"1!\u0011R\u0018A\u00021\u000b\u0011\u0003\u001e=o)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\tIn\fa\u0001\u0019\"9!qR\u0018A\u0002\t=\u0014AG7fi\u0006$\u0017\r^1QKJ$&/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017\u0001\n7pC\u0012$&/\u00198tC\u000e$\u0018n\u001c8t\r>\u0014H\u000b\u001f8U_BL7\rU1si&$\u0018n\u001c8\u0015\u0011\u0005]#Q\u0013BL\u00053Ca!!61\u0001\u0004a\u0005BBAma\u0001\u0007A\nC\u0004\u0003\u001cB\u0002\rA!(\u0002\u001dM,g\u000e\u001a+y]6\u000b'o[3sgB\u0019!q\u0014\u000b\u000e\u0003-\taE]3n_Z,GK]1og\u0006\u001cG/[8og\u001a{'\u000f\u0016=o)>\u0004\u0018n\u0019)beRLG/[8o)\u0019\t9F!*\u0003(\"1\u0011Q[\u0019A\u00021Ca!!72\u0001\u0004a\u0015A\f<bY&$\u0017\r^3Ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oi&\u001b8\u000b^1cY\u0016\fa#\u00199qK:$GK]1og\u0006\u001cG/[8o)>dun\u001a\u000b\r\u0003/\u0012yK!-\u00034\n]&\u0011\u0019\u0005\b\u0005_\u0019\u0004\u0019AA\u0015\u0011\u0019\tIn\ra\u0001\u0019\"9!QW\u001aA\u0002\u0005E\u0013a\u00038fo6+G/\u00193bi\u0006DqA!/4\u0001\u0004\u0011Y,\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB91I!0\u0003\u0016\u0005]\u0013b\u0001B`\t\nIa)\u001e8di&|g.\r\u0005\n\u0005\u0007\u001c\u0004\u0013!a\u0001\u0005\u000b\fAB]3uef|e.\u0012:s_J\u0004ra\u0011B_\u0005+\u0011i%\u0001\u0011baB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000eT8hI\u0011,g-Y;mi\u0012*TC\u0001BfU\u0011\u0011)M!4,\u0005\t=\u0007\u0003\u0002Bi\u00057l!Aa5\u000b\t\tU'q[\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!7E\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005;\u0014\u0019NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001b\u001d5vi\u0012|wO\u001c")
public class TransactionStateManager
implements Logging {
    private final KafkaZkClient zkClient;
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final Set<TransactionPartitionAndLeaderEpoch> leavingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private final int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    private Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    private Set<TransactionPartitionAndLeaderEpoch> leavingPartitions() {
        return this.leavingPartitions;
    }

    private scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    /*
     * WARNING - void declaration
     */
    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        void inWriteLock_lock;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public ReentrantReadWriteLock.ReadLock stateReadLock() {
        return this.stateLock().readLock();
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        Iterable iterable;
        void inReadLock_lock;
        long now = this.time.milliseconds();
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void inReadLock_lock;
            long now = $this.time.milliseconds();
            ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
            if (CoreUtils$.MODULE$ == null) {
                throw null;
            }
            Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
            inReadLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$enableTransactionalIdExpiration$2(this, now);
            }
            finally {
                inReadLock_inLock_lock.unlock();
            }
        }, this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(String transactionalId, TransactionMetadata txnMetadata) {
        Either either;
        Either.RightProjection rightProjection = this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)new Some((Object)txnMetadata)).right();
        if (rightProjection == null) {
            throw null;
        }
        Either.RightProjection map_this = rightProjection;
        Either either2 = map_this.e();
        if (either2 instanceof Right) {
            Object map_b = ((Right)either2).value();
            Option option = (Option)map_b;
            either = new Right((Object)TransactionStateManager.$anonfun$putTransactionStateIfNotExists$1(txnMetadata, option));
        } else {
            either = map_this.e();
        }
        return either;
    }

    /*
     * WARNING - void declaration
     */
    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    /*
     * WARNING - void declaration
     */
    public Properties transactionTopicConfigs() {
        void var1_1;
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogMinInsyncReplicas())).toString());
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.config.transactionLogSegmentBytes())).toString());
        return var1_1;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private int getTransactionTopicPartitionCount() {
        Option<Object> option = this.zkClient.getTopicPartitionCount("__transaction_state");
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToInteger((int)this.config.transactionLogNumPartitions()) : getOrElse_this.get();
        return BoxesRunTime.unboxToInt((Object)object);
    }

    /*
     * WARNING - void declaration
     */
    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        long startMs = this.time.milliseconds();
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)Pool$.MODULE$.$lessinit$greater$default$1());
        Option<Log> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            Log log = (Log)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    void inReadLock_lock;
                    ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
                    if (CoreUtils$.MODULE$ == null) {
                        throw null;
                    }
                    Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    if (!bl) break;
                    Records records = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchLogEnd$.MODULE$, true).records();
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(125).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(memoryRecords.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$6(loadedTransactions, currOffset, batch);
                        return BoxedUnit.UNIT;
                    });
                    long endMs = this.time.milliseconds();
                    long timeLapse = endMs - startMs;
                    this.partitionLoadSensor().record((double)timeLapse, endMs, false);
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append(timeLapse).append(" milliseconds").toString());
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> metadataPerTransactionalId) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, metadataPerTransactionalId);
        Option currentTxnMetadataCacheEntry = this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry);
        if (currentTxnMetadataCacheEntry.isDefined()) {
            int coordinatorEpoch2 = ((TxnMetadataCacheEntry)currentTxnMetadataCacheEntry.get()).coordinatorEpoch();
            Pool<String, TransactionMetadata> metadataPerTxnId = ((TxnMetadataCacheEntry)currentTxnMetadataCacheEntry.get()).metadataPerTransactionalId();
            String errorMsg = new StringBuilder(130).append("The metadata cache for txn partition ").append(txnTopicPartition).append(" has already exist with epoch ").append(coordinatorEpoch2).append(" ").append("and ").append(metadataPerTxnId.size()).append(" entries while trying to add to it; ").append("this should not happen").toString();
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMsg);
            throw new IllegalStateException(errorMsg);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        void inWriteLock_lock;
        this.validateTransactionTopicPartitionCountIsStable();
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            void loadTransactions$1_inWriteLock_lock;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Loading transaction metadata from ").append(topicPartition).toString());
            Pool<String, TransactionMetadata> loadTransactions$1_loadedTransactions = this.loadTransactionMetadata(topicPartition, coordinatorEpoch);
            ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
            if (CoreUtils$.MODULE$ == null) {
                throw null;
            }
            Lock loadTransactions$1_inWriteLock_inLock_lock = loadTransactions$1_inWriteLock_lock.writeLock();
            loadTransactions$1_inWriteLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$3(this, partitionAndLeaderEpoch, topicPartition, coordinatorEpoch, loadTransactions$1_loadedTransactions, sendTxnMarkers);
            }
            finally {
                loadTransactions$1_inWriteLock_inLock_lock.unlock();
            }
        }, this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    /*
     * WARNING - void declaration
     */
    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        void inWriteLock_lock;
        this.validateTransactionTopicPartitionCountIsStable();
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        this.scheduler.schedule(new StringBuilder(26).append("remove-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.removeTransactions$1(partitionAndLeaderEpoch, partitionId, topicPartition), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        if (this.transactionTopicPartitionCount() != curTransactionTopicPartitionCount) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(this.transactionTopicPartitionCount()).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError) {
        void inReadLock_lock;
        void $minus$greater$extension_$this;
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        long timestamp = this.time.milliseconds();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)});
        TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)records);
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$appendTransactionToLog$13(this, transactionalId, responseCallback, coordinatorEpoch, newMetadata, recordsPerPartition, topicPartition, retryOnError);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$6));
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        $this.leavingPartitions().remove((Object)partitionAndLeaderEpoch$1);
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(int txnPartitionId$1, TransactionPartitionAndLeaderEpoch x$1) {
        return x$1.txnPartitionId() == txnPartitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$2(TransactionStateManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int txnPartitionId = x0$1._1$mcI$sp();
        boolean bl = !$this.leavingPartitions().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(txnPartitionId, x$1)));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$5(long now$1, Tuple2 x0$3) {
        boolean bl;
        if (x0$3 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                bl = false;
            } else {
                TransactionState transactionState = txnMetadata.state();
                boolean bl2 = Ongoing$.MODULE$.equals(transactionState) ? txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1 : false;
                bl = bl2;
            }
        } else {
            throw new MatchError(null);
        }
        boolean bl3 = bl;
        return bl3;
    }

    public static final /* synthetic */ Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$1) {
        return (Iterable)((TraversableLike)$this.transactionMetadataCache().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$2($this, x0$1)))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Iterable iterable = (Iterable)((TraversableLike)((TxnMetadataCacheEntry)x0$2._2()).metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$5(now$1, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                if (x0$4 == null) {
                    throw new MatchError(null);
                }
                String txnId = (String)x0$4._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$4._2();
                TransactionalIdAndProducerIdEpoch transactionalIdAndProducerIdEpoch = new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                return transactionalIdAndProducerIdEpoch;
            }, Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$4(Tuple2 x0$2) {
        boolean bl;
        if (x0$2 != null) {
            TransactionState transactionState = ((TransactionMetadata)x0$2._2()).state();
            boolean bl2 = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
            bl = bl2;
        } else {
            throw new MatchError(null);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$enableTransactionalIdExpiration$5(TransactionStateManager $this, long now$2, Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((TransactionMetadata)x0$3._2()).txnLastUpdateTimestamp() <= now$2 - (long)$this.config.transactionalIdExpirationMs();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$12(TransactionStateManager $this, scala.collection.immutable.Map transactionalIdByPartition$1, TopicPartition topicPartition$1, ProduceResponse.PartitionResponse response$1) {
        scala.collection.mutable.Iterable toRemove = (scala.collection.mutable.Iterable)transactionalIdByPartition$1.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition()));
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition()));
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)foreach_this.get();
            toRemove.foreach((Function1 & Serializable & scala.Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(192).append("Failed to remove expired transactionalId: ").append(transactionalId).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(idCoordinatorEpochAndMetadata.coordinatorEpoch()).toString());
                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$11(TransactionStateManager $this, scala.collection.immutable.Map transactionalIdByPartition$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            void inReadLock_lock;
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            ProduceResponse.PartitionResponse response = (ProduceResponse.PartitionResponse)x0$1._2();
            ReentrantReadWriteLock reentrantReadWriteLock = $this.stateLock();
            if (CoreUtils$.MODULE$ == null) {
                throw null;
            }
            Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
            inReadLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$enableTransactionalIdExpiration$12($this, transactionalIdByPartition$1, topicPartition, response);
            }
            finally {
                inReadLock_inLock_lock.unlock();
            }
            return;
        }
        throw new MatchError(null);
    }

    private final void removeFromCacheCallback$1(Map responses, scala.collection.immutable.Map transactionalIdByPartition$1) {
        responses.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TransactionStateManager.$anonfun$enableTransactionalIdExpiration$11(this, transactionalIdByPartition$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$enableTransactionalIdExpiration$2(TransactionStateManager $this, long now$2) {
        scala.collection.immutable.Map transactionalIdByPartition = ((TraversableLike)$this.transactionMetadataCache().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TxnMetadataCacheEntry entry = (TxnMetadataCacheEntry)x0$1._2();
            Iterable iterable = (Iterable)((TraversableLike)((TraversableLike)entry.metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$4(x0$2)))).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$enableTransactionalIdExpiration$5($this, now$2, x0$3)))).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                if (x0$4 == null) {
                    throw new MatchError(null);
                }
                String transactionalId = (String)x0$4._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$4._2();
                TxnTransitMetadata txnMetadataTransition = (TxnTransitMetadata)txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> txnMetadata.prepareDead());
                TransactionalIdCoordinatorEpochAndMetadata transactionalIdCoordinatorEpochAndMetadata = new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, entry.coordinatorEpoch(), txnMetadataTransition);
                return transactionalIdCoordinatorEpochAndMetadata;
            }, Iterable$.MODULE$.canBuildFrom());
            return iterable;
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)transactionalIdCoordinatorEpochAndMetadata -> BoxesRunTime.boxToInteger((int)$this.partitionFor(transactionalIdCoordinatorEpochAndMetadata.transactionalId())));
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)transactionalIdByPartition.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            if (x0$5 == null) {
                throw new MatchError(null);
            }
            int partition = x0$5._1$mcI$sp();
            SimpleRecord[] deletes = (SimpleRecord[])((TraversableOnce)((scala.collection.mutable.Iterable)x0$5._2()).map((Function1 & Serializable & scala.Serializable)entry -> new SimpleRecord(now$2, TransactionLog$.MODULE$.keyToBytes(entry.transactionalId()), null), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
            MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])deletes);
            TopicPartition topicPartition = new TopicPartition("__transaction_state", partition);
            Tuple2 tuple2 = new Tuple2((Object)topicPartition, (Object)records);
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        $this.replicaManager.appendRecords($this.config.requestTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, false, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, transactionalIdByPartition);
            return BoxedUnit.UNIT;
        }, (Option<Lock>)new Some((Object)$this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
    }

    public static final /* synthetic */ Nothing$ $anonfun$putTransactionStateIfNotExists$2(TransactionMetadata txnMetadata$3) {
        throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata$3).toString());
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$putTransactionStateIfNotExists$1(TransactionMetadata txnMetadata$3, Option x$2) {
        if (x$2 == null) {
            throw null;
        }
        if (x$2.isEmpty()) {
            throw TransactionStateManager.$anonfun$putTransactionStateIfNotExists$2(txnMetadata$3);
        }
        return (CoordinatorEpochAndTxnMetadata)x$2.get();
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$3) {
        return x$3.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$3(int partitionId$1, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ TransactionMetadata $anonfun$getAndMaybeAddTransactionState$5(TxnMetadataCacheEntry cacheEntry$1, String transactionalId$2, TransactionMetadata createdTxnMetadata) {
        Option option = Option$.MODULE$.apply((Object)cacheEntry$1.metadataPerTransactionalId().putIfNotExists(transactionalId$2, createdTxnMetadata));
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? createdTxnMetadata : getOrElse_this.get();
        return (TransactionMetadata)object;
    }

    public static final /* synthetic */ Option $anonfun$getAndMaybeAddTransactionState$4(Option createdTxnMetadataOpt$1, TxnMetadataCacheEntry cacheEntry$1, String transactionalId$2) {
        None$ none$;
        if (createdTxnMetadataOpt$1 == null) {
            throw null;
        }
        if (createdTxnMetadataOpt$1.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            TransactionMetadata transactionMetadata = (TransactionMetadata)createdTxnMetadataOpt$1.get();
            none$ = new Some((Object)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$5(cacheEntry$1, transactionalId$2, transactionMetadata));
        }
        return none$;
    }

    public static final /* synthetic */ CoordinatorEpochAndTxnMetadata $anonfun$getAndMaybeAddTransactionState$7(TxnMetadataCacheEntry cacheEntry$1, TransactionMetadata x$5) {
        return new CoordinatorEpochAndTxnMetadata(cacheEntry$1.coordinatorEpoch(), x$5);
    }

    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$2, Option createdTxnMetadataOpt$1) {
        Left left;
        int partitionId = $this.partitionFor(transactionalId$2);
        if ($this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$3)))) {
            return package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        if ($this.leavingPartitions().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$3(partitionId, x$4)))) {
            return package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
        }
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            None$ none$;
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option option2 = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId$2));
            if (option2 == null) {
                throw null;
            }
            Option orElse_this = option2;
            Option option3 = orElse_this.isEmpty() ? TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$4(createdTxnMetadataOpt$1, cacheEntry, transactionalId$2) : orElse_this;
            Right$ right$ = package$.MODULE$.Right();
            if (option3 == null) {
                throw null;
            }
            if (option3.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                TransactionMetadata transactionMetadata = (TransactionMetadata)option3.get();
                none$ = new Some((Object)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$7(cacheEntry, transactionMetadata));
            }
            left = right$.apply((Object)none$);
        } else if (None$.MODULE$.equals(option)) {
            left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    public static final /* synthetic */ long $anonfun$loadTransactionMetadata$1() {
        return -1L;
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        Option<Object> option = this.replicaManager.getLogEndOffset(topicPartition$2);
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToLong((long)TransactionStateManager.$anonfun$loadTransactionMetadata$1()) : getOrElse_this.get();
        return BoxesRunTime.unboxToLong((Object)object);
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ String $anonfun$loadTransactionMetadata$8() {
        return "Transaction state log's key should not be null";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        void require_requirement;
        boolean bl = record.hasKey();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (require_requirement == false) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)TransactionStateManager.$anonfun$loadTransactionMetadata$8()).toString());
        }
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        if (!record.hasValue()) {
            loadedTransactions$1.remove(transactionalId);
        } else {
            TransactionMetadata txnMetadata = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
            loadedTransactions$1.put(transactionalId, txnMetadata);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$6(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch) {
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions$1, currOffset$1, batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        $this.leavingPartitions().remove((Object)partitionAndLeaderEpoch$2);
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$6(Function5 sendTxnMarkers$1, TransactionalIdCoordinatorEpochAndTransitMetadata txnTransitMetadata) {
        sendTxnMarkers$1.apply((Object)txnTransitMetadata.transactionalId(), (Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$3(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$2, Pool loadedTransactions$2, Function5 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$2, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                String transactionalId = (String)x0$1._1();
                TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                Object t = txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    TransactionState transactionState = txnMetadata.state();
                    Object object = PrepareAbort$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$2, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : (PrepareCommit$.MODULE$.equals(transactionState) ? transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$2, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds()))) : BoxedUnit.UNIT);
                    return object;
                });
                return t;
            });
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            Function1 & Serializable & scala.Serializable foreach_f = (Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                sendTxnMarkers$1.apply((Object)txnTransitMetadata.transactionalId(), (Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                return BoxedUnit.UNIT;
            };
            transactionsPendingForCompletion.underlying().foreach((Function1)foreach_f);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadTransactions$1(TopicPartition topicPartition$3, int coordinatorEpoch$2, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function5 sendTxnMarkers$1) {
        void inWriteLock_lock;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Loading transaction metadata from ").append(topicPartition).toString());
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$2);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$3(this, partitionAndLeaderEpoch$2, topicPartition$3, coordinatorEpoch$2, loadedTransactions, sendTxnMarkers$1);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3) {
        $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$3);
        return $this.leavingPartitions().add((Object)partitionAndLeaderEpoch$3);
    }

    public static final /* synthetic */ Object $anonfun$removeTransactionsForTxnTopicPartition$2(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$2, TopicPartition topicPartition$4) {
        if ($this.leavingPartitions().contains((Object)partitionAndLeaderEpoch$3)) {
            Option option = $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$2));
            if (option instanceof Some) {
                TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Removed ").append(txnMetadataCacheEntry.metadataPerTransactionalId().size()).append(" cached transaction metadata for ").append(topicPartition$4).append(" on follower transition").toString());
            } else if (None$.MODULE$.equals(option)) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(206).append("Trying to remove cached transaction metadata for ").append(topicPartition$4).append(" on follower transition but there is no entries remaining; ").append("it is likely that another process for removing the cached entries has just executed earlier before").toString());
            } else {
                throw new MatchError((Object)option);
            }
            return BoxesRunTime.boxToBoolean((boolean)$this.leavingPartitions().remove((Object)partitionAndLeaderEpoch$3));
        }
        return BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeTransactions$1(TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$2, TopicPartition topicPartition$4) {
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(this, partitionAndLeaderEpoch$3, partitionId$2, topicPartition$4);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$4, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$4).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$4, Errors err$1) {
        return new StringBuilder(140).append("Accessing the cached transaction metadata for ").append(transactionalId$4).append(" returns ").append(err$1).append(" error; ").append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$3, String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$3) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(231).append("The cached coordinator epoch for ").append(transactionalId$4).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$3).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$4).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$3).append(" for ").append(transactionalId$4).append(" succeeded").toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$3) {
        return new StringBuilder(254).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$4).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$4)).append(") while it was ").append(coordinatorEpoch$3).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$3, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$3) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(169).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString());
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(159).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString());
            metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(187).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$3).toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(190).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$4, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(173).append("TransactionalId ").append(transactionalId$4).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$5, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$3, Function1 retryOnError$1, Function1 responseCallback$1) {
        block16: {
            block14: {
                block18: {
                    block17: {
                        block15: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$5)) {
                                var33_8 = "Append status %s should only have one partition %s";
                                if (Predef$.MODULE$ == null) {
                                    throw null;
                                }
                                throw new IllegalStateException(new StringOps(var33_8).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$5})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$5);
                            v0 = status.error;
                            var14_10 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_10) == false : var14_10 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var15_11 = status.error;
                                var11_12 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_11) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_11) != false));
                                if (var11_12) {
                                    var8_13 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_14 = Errors.NOT_LEADER_FOR_PARTITION.equals(var15_11) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_11) != false;
                                    if (var10_14) {
                                        var8_13 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_15 = Errors.MESSAGE_TOO_LARGE.equals(var15_11) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_11) != false;
                                        var8_13 = var9_15 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_11;
                                    }
                                }
                                v1 = var8_13;
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var16_17 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_17) == false : var16_17 != null) break block14;
                            var17_18 = false;
                            var18_19 = null;
                            var19_20 = this.getTransactionState(transactionalId$4);
                            if (!(var19_20 instanceof Left)) break block15;
                            err = (Errors)((Left)var19_20).value();
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (Errors)err));
                            responseError.elem = err;
                            break block16;
                        }
                        if (!(var19_20 instanceof Right)) break block17;
                        var17_18 = true;
                        var18_19 = (Right)var19_20;
                        var21_22 = (Option)var18_19.value();
                        if (!(var21_22 instanceof Some)) break block17;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_22).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$3, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block16;
                    }
                    if (!var17_18 || !None$.MODULE$.equals(var24_25 = (Option)var18_19.value())) break block18;
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$3));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block16;
                }
                throw new MatchError(var19_20);
            }
            var25_26 = false;
            var26_27 = null;
            var27_28 = this.getTransactionState(transactionalId$4);
            if (!(var27_28 instanceof Right)) ** GOTO lbl-1000
            var25_26 = true;
            var26_27 = (Right)var27_28;
            var28_29 = (Option)var26_27.value();
            if (var28_29 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_29).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$3, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_26 && None$.MODULE$.equals(var31_32 = (Option)var26_27.value())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var27_28 instanceof Left) {
                error = (Errors)((Left)var27_28).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var27_28);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$appendTransactionToLog$15(TransactionStateManager $this, TopicPartition topicPartition$5, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$3, Function1 retryOnError$1, Function1 responseCallback$1, Map responseStatus) {
        block16: {
            block14: {
                block18: {
                    block17: {
                        block15: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$5)) {
                                var33_8 = "Append status %s should only have one partition %s";
                                if (Predef$.MODULE$ == null) {
                                    throw null;
                                }
                                throw new IllegalStateException(new StringOps(var33_8).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$5})));
                            }
                            updateCacheCallback$1_status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$5);
                            v0 = updateCacheCallback$1_status.error;
                            var14_10 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_10) == false : var14_10 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)updateCacheCallback$1_status));
                                var15_11 = updateCacheCallback$1_status.error;
                                var11_12 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_11) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_11) != false));
                                if (var11_12) {
                                    var8_13 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_14 = Errors.NOT_LEADER_FOR_PARTITION.equals(var15_11) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_11) != false;
                                    if (var10_14) {
                                        var8_13 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_15 = Errors.MESSAGE_TOO_LARGE.equals(var15_11) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_11) != false;
                                        var8_13 = var9_15 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_11;
                                    }
                                }
                                v1 = var8_13;
                            }
                            updateCacheCallback$1_responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)updateCacheCallback$1_responseError.elem;
                            var16_17 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_17) == false : var16_17 != null) break block14;
                            var17_18 = false;
                            var18_19 = null;
                            var19_20 = $this.getTransactionState(transactionalId$4);
                            if (!(var19_20 instanceof Left)) break block15;
                            updateCacheCallback$1_err = (Errors)((Left)var19_20).value();
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (Errors)updateCacheCallback$1_err));
                            updateCacheCallback$1_responseError.elem = updateCacheCallback$1_err;
                            break block16;
                        }
                        if (!(var19_20 instanceof Right)) break block17;
                        var17_18 = true;
                        var18_19 = (Right)var19_20;
                        var21_22 = (Option)var18_19.value();
                        if (!(var21_22 instanceof Some)) break block17;
                        updateCacheCallback$1_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_22).value();
                        updateCacheCallback$1_metadata = updateCacheCallback$1_epochAndMetadata.transactionMetadata();
                        (BoxedUnit)updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)updateCacheCallback$1_epochAndMetadata, (int)coordinatorEpoch$3, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError, (TransactionMetadata)updateCacheCallback$1_metadata));
                        break block16;
                    }
                    if (!var17_18 || !None$.MODULE$.equals(var24_25 = (Option)var18_19.value())) break block18;
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)$this, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$3));
                    updateCacheCallback$1_responseError.elem = Errors.NOT_COORDINATOR;
                    break block16;
                }
                throw new MatchError(var19_20);
            }
            var25_26 = false;
            var26_27 = null;
            var27_28 = $this.getTransactionState(transactionalId$4);
            if (!(var27_28 instanceof Right)) ** GOTO lbl-1000
            var25_26 = true;
            var26_27 = (Right)var27_28;
            var28_29 = (Option)var26_27.value();
            if (var28_29 instanceof Some) {
                updateCacheCallback$1_epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_29).value();
                updateCacheCallback$1_metadata = updateCacheCallback$1_epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)updateCacheCallback$1_epochAndTxnMetadata, (int)coordinatorEpoch$3, (Function1)retryOnError$1, (ObjectRef)updateCacheCallback$1_responseError, (TransactionMetadata)updateCacheCallback$1_metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_26 && None$.MODULE$.equals(var31_32 = (Option)var26_27.value())) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError));
            } else if (var27_28 instanceof Left) {
                updateCacheCallback$1_error = (Errors)((Left)var27_28).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError, (Errors)updateCacheCallback$1_error));
            } else {
                throw new MatchError(var27_28);
            }
        }
        responseCallback$1.apply((Object)((Errors)updateCacheCallback$1_responseError.elem));
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$4, Function1 responseCallback$1, int coordinatorEpoch$3, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, TopicPartition topicPartition$5, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$4);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$3) {
                    responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                $this.replicaManager.appendRecords(newMetadata$1.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, false, (Map<TopicPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)((Function1 & Serializable & scala.Serializable)arg_0 -> TransactionStateManager.$anonfun$appendTransactionToLog$15$adapted($this, topicPartition$5, transactionalId$4, newMetadata$1, coordinatorEpoch$3, retryOnError$1, responseCallback$1, arg_0)), (Option<Lock>)new Some((Object)$this.stateLock().readLock()), $this.replicaManager.appendRecords$default$8());
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata$1).append(" for transaction id ").append(transactionalId$4).append(" with coordinator epoch ").append(coordinatorEpoch$3).append(" to the local transaction log").toString());
                return;
            }
        } else {
            throw new MatchError(either);
        }
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$6) {
        return false;
    }

    public TransactionStateManager(int brokerId, KafkaZkClient zkClient, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics) {
        this.zkClient = zkClient;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.leavingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionTopicPartitionCount = this.getTransactionTopicPartitionCount();
        this.partitionLoadSensor = metrics.sensor("PartitionLoadTime");
        this.partitionLoadSensor().add(metrics.metricName("partition-load-time-max", "transaction-coordinator-metrics", "The max time it took to load the partitions in the last 30sec"), (MeasurableStat)new Max());
        this.partitionLoadSensor().add(metrics.metricName("partition-load-time-avg", "transaction-coordinator-metrics", "The avg time it took to load the partitions in the last 30sec"), (MeasurableStat)new Avg());
    }

    public static final /* synthetic */ Object $anonfun$enableTransactionalIdExpiration$13$adapted(TransactionStateManager $this, scala.collection.mutable.Iterable toRemove$1, ProduceResponse.PartitionResponse response$1, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        toRemove$1.foreach((Function1 & Serializable & scala.Serializable)idCoordinatorEpochAndMetadata -> {
            String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
            TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
            return txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                    Errors errors = response$1.error;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                    }
                }
                $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(192).append("Failed to remove expired transactionalId: ").append(transactionalId).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(idCoordinatorEpochAndMetadata.coordinatorEpoch()).toString());
                txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                return BoxedUnit.UNIT;
            });
        });
        return BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$appendTransactionToLog$15$adapted(TransactionStateManager $this, TopicPartition topicPartition$5, String transactionalId$4, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$3, Function1 retryOnError$1, Function1 responseCallback$1, Map responseStatus) {
        block16: {
            block14: {
                block18: {
                    block17: {
                        block15: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$5)) {
                                var33_8 = "Append status %s should only have one partition %s";
                                if (Predef$.MODULE$ == null) {
                                    throw null;
                                }
                                throw new IllegalStateException(new StringOps(var33_8).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$5})));
                            }
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$5);
                            v0 = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status.error;
                            var14_10 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var14_10) == false : var14_10 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_status));
                                var15_11 = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status.error;
                                var11_12 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var15_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var15_11) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var15_11) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var15_11) != false));
                                if (var11_12) {
                                    var8_13 = Errors.COORDINATOR_NOT_AVAILABLE;
                                } else {
                                    var10_14 = Errors.NOT_LEADER_FOR_PARTITION.equals(var15_11) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var15_11) != false;
                                    if (var10_14) {
                                        var8_13 = Errors.NOT_COORDINATOR;
                                    } else {
                                        var9_15 = Errors.MESSAGE_TOO_LARGE.equals(var15_11) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var15_11) != false;
                                        var8_13 = var9_15 != false ? Errors.UNKNOWN_SERVER_ERROR : var15_11;
                                    }
                                }
                                v1 = var8_13;
                            }
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem;
                            var16_17 = Errors.NONE;
                            if (v2 != null ? v2.equals(var16_17) == false : var16_17 != null) break block14;
                            var17_18 = false;
                            var18_19 = null;
                            var19_20 = $this.getTransactionState(transactionalId$4);
                            if (!(var19_20 instanceof Left)) break block15;
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_err = (Errors)((Left)var19_20).value();
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_err));
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_err;
                            break block16;
                        }
                        if (!(var19_20 instanceof Right)) break block17;
                        var17_18 = true;
                        var18_19 = (Right)var19_20;
                        var21_22 = (Option)var18_19.value();
                        if (!(var21_22 instanceof Some)) break block17;
                        $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var21_22).value();
                        $anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata.transactionMetadata();
                        (BoxedUnit)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata, (int)coordinatorEpoch$3, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (TransactionMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata));
                        break block16;
                    }
                    if (!var17_18 || !None$.MODULE$.equals(var24_25 = (Option)var18_19.value())) break block18;
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)$this, (String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$3));
                    $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem = Errors.NOT_COORDINATOR;
                    break block16;
                }
                throw new MatchError(var19_20);
            }
            var25_26 = false;
            var26_27 = null;
            var27_28 = $this.getTransactionState(transactionalId$4);
            if (!(var27_28 instanceof Right)) ** GOTO lbl-1000
            var25_26 = true;
            var26_27 = (Right)var27_28;
            var28_29 = (Option)var26_27.value();
            if (var28_29 instanceof Some) {
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var28_29).value();
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata, (int)coordinatorEpoch$3, (Function1)retryOnError$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (TransactionMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var25_26 && None$.MODULE$.equals(var31_32 = (Option)var26_27.value())) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError));
            } else if (var27_28 instanceof Left) {
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_error = (Errors)((Left)var27_28).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$4, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_error));
            } else {
                throw new MatchError(var27_28);
            }
        }
        responseCallback$1.apply((Object)((Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem));
        return BoxedUnit.UNIT;
    }
}

