/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.IndexOffsetOverflowException;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging$;
import org.apache.kafka.common.utils.MappedByteBuffers;
import org.apache.kafka.common.utils.OperatingSystem;
import org.apache.kafka.common.utils.Utils;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tEe!B\u001e=\u0003\u0003\t\u0005\u0002\u0003)\u0001\u0005\u0003\u0007I\u0011A)\t\u0011U\u0003!\u00111A\u0005\u0002YC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006KA\u0015\u0005\tI\u0002\u0011)\u0019!C\u0001K\"A\u0011\u000e\u0001B\u0001B\u0003%a\r\u0003\u0005k\u0001\t\u0015\r\u0011\"\u0001l\u0011!y\u0007A!A!\u0002\u0013a\u0007\u0002\u00039\u0001\u0005\u000b\u0007I\u0011A9\t\u0011U\u0004!\u0011!Q\u0001\nIDQA\u001e\u0001\u0005\u0002]D\u0011B \u0001A\u0002\u0003\u0007I\u0011B3\t\u0015}\u0004\u0001\u0019!a\u0001\n\u0013\t\t\u0001\u0003\u0006\u0002\u0006\u0001\u0001\r\u0011!Q!\n\u0019Da!!\u0003\u0001\r#Y\u0007BBA\u0006\u0001\u0011E1\u000eC\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0005\u0002\u0010!A\u0011Q\u0005\u0001!\u0002\u0013\t\t\u0002C\u0005\u0002(\u0001\u0001\r\u0011\"\u0005\u0002*!I\u0011q\u0007\u0001A\u0002\u0013E\u0011\u0011\b\u0005\t\u0003{\u0001\u0001\u0015)\u0003\u0002,!9\u0011\u0011\t\u0001!B\u0013a\u0007\u0002CA#\u0001\u0001\u0007I\u0011C6\t\u0013\u0005\u001d\u0003\u00011A\u0005\u0012\u0005%\u0003bBA'\u0001\u0001\u0006K\u0001\u001c\u0005\u0007\u0003#\u0002A\u0011A9\t\r\u0005M\u0003\u0001\"\u0001l\u0011\u0019\t)\u0006\u0001C\u0001W\"1\u0011q\u000b\u0001\u0005\u0002\u0015Dq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0004bBA9\u0001\u0011\u0005\u00111\u000e\u0005\u0007\u0003g\u0002A\u0011A6\t\u000f\u0005U\u0004\u0001\"\u0001\u0002l!9\u0011q\u000f\u0001\u0005\u0002\u0005-\u0004bBA=\u0001\u0019\u0005\u00111\u000e\u0005\b\u0003w\u0002a\u0011CA6\u0011\u001d\ti\b\u0001D\u0001\u0003\u007fBq!!\"\u0001\t\u0003\tY\u0007C\u0004\u0002\b\u0002!\t!!#\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"9\u00111\u0013\u0001\u0005\u0012\u0005-\u0004\u0002CAK\u0001\u0011EA(a\u001b\t\u000f\u0005]\u0005\u0001\"\u0005\u0002\u001a\"9\u0011q\u0019\u0001\u0007\u0012\u0005%\u0007bBAp\u0001\u0011E\u0011\u0011\u001d\u0005\b\u0005\u0017\u0001A\u0011\u0003B\u0007\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005/AqA!\n\u0001\t\u0013\u00119\u0003C\u0004\u00032\u0001!IAa\r\t\u000f\tu\u0002\u0001\"\u0003\u0003@\u001d9!\u0011\n\u001f\t\u0002\t-cAB\u001e=\u0011\u0003\u0011i\u0005\u0003\u0004wm\u0011\u0005!\u0011\r\u0005\n\u0005G2$\u0019!C!\u0005KB\u0001Ba\u001e7A\u0003%!q\r\u0005\n\u0005s2\u0014\u0013!C\u0001\u0005w\u0012Q\"\u00112tiJ\f7\r^%oI\u0016D(BA\u001f?\u0003\rawn\u001a\u0006\u0002\u007f\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001C\u0015B\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0005Y\u0006twMC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%#%AB(cU\u0016\u001cG\u000f\u0005\u0002L\u001d6\tAJ\u0003\u0002N\r\u0006\u0011\u0011n\\\u0005\u0003\u001f2\u0013\u0011b\u00117pg\u0016\f'\r\\3\u0002\t\u0019LG.Z\u000b\u0002%B\u00111jU\u0005\u0003)2\u0013AAR5mK\u0006Aa-\u001b7f?\u0012*\u0017\u000f\u0006\u0002X;B\u0011\u0001lW\u0007\u00023*\t!,A\u0003tG\u0006d\u0017-\u0003\u0002]3\n!QK\\5u\u0011\u001dq&!!AA\u0002I\u000b1\u0001\u001f\u00132\u0003\u00151\u0017\u000e\\3!Q\t\u0019\u0011\r\u0005\u0002YE&\u00111-\u0017\u0002\tm>d\u0017\r^5mK\u0006Q!-Y:f\u001f\u001a47/\u001a;\u0016\u0003\u0019\u0004\"\u0001W4\n\u0005!L&\u0001\u0002'p]\u001e\f1BY1tK>3gm]3uA\u0005aQ.\u0019=J]\u0012,\u0007pU5{KV\tA\u000e\u0005\u0002Y[&\u0011a.\u0017\u0002\u0004\u0013:$\u0018!D7bq&sG-\u001a=TSj,\u0007%\u0001\u0005xe&$\u0018M\u00197f+\u0005\u0011\bC\u0001-t\u0013\t!\u0018LA\u0004C_>dW-\u00198\u0002\u0013]\u0014\u0018\u000e^1cY\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0003yundX\u0010\u0005\u0002z\u00015\tA\bC\u0003Q\u0015\u0001\u0007!\u000bC\u0003e\u0015\u0001\u0007a\rC\u0004k\u0015A\u0005\t\u0019\u00017\t\u000bAT\u0001\u0019\u0001:\u0002\u000f}cWM\\4uQ\u0006Yq\f\\3oORDw\fJ3r)\r9\u00161\u0001\u0005\b=2\t\t\u00111\u0001g\u0003!yF.\u001a8hi\"\u0004\u0003FA\u0007b\u0003%)g\u000e\u001e:z'&TX-\u0001\u0007`o\u0006\u0014X.\u00128ue&,7/\u0001\u0003m_\u000e\\WCAA\t!\u0011\t\u0019\"!\t\u000e\u0005\u0005U!\u0002BA\f\u00033\tQ\u0001\\8dWNTA!a\u0007\u0002\u001e\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005}a)\u0001\u0003vi&d\u0017\u0002BA\u0012\u0003+\u0011QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0017!\u00027pG.\u0004\u0013\u0001B7nCB,\"!a\u000b\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\rG\u0003\rq\u0017n\\\u0005\u0005\u0003k\tyC\u0001\tNCB\u0004X\r\u001a\"zi\u0016\u0014UO\u001a4fe\u0006AQ.\\1q?\u0012*\u0017\u000fF\u0002X\u0003wA\u0001BX\n\u0002\u0002\u0003\u0007\u00111F\u0001\u0006[6\f\u0007\u000f\t\u0015\u0003)\u0005\f1bX7bq\u0016sGO]5fg\"\u0012Q#Y\u0001\t?\u0016tGO]5fg\u0006aq,\u001a8ue&,7o\u0018\u0013fcR\u0019q+a\u0013\t\u000fy;\u0012\u0011!a\u0001Y\u0006Iq,\u001a8ue&,7\u000f\t\u0015\u00031\u0005\fa![:Gk2d\u0017AC7bq\u0016sGO]5fg\u00069QM\u001c;sS\u0016\u001c\u0018A\u00027f]\u001e$\b.\u0001\u0004sKNL'0\u001a\u000b\u0004e\u0006u\u0003BBA0;\u0001\u0007A.A\u0004oK^\u001c\u0016N_3\u0002\u0011I,g.Y7f)>$2aVA3\u0011\u0019\t9G\ba\u0001%\u0006\ta-A\u0003gYV\u001c\b\u000eF\u0001X\u00039!W\r\\3uK&3W\t_5tiN$\u0012A]\u0001\u0010iJLW\u000eV8WC2LGmU5{K\u0006Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t\u0003\u0015\u0019Gn\\:f\u00031\u0019Gn\\:f\u0011\u0006tG\r\\3s\u0003-\u0019\u0018M\\5us\u000eCWmY6\u0002\u0011Q\u0014XO\\2bi\u0016\f!\u0002\u001e:v]\u000e\fG/\u001a+p)\r9\u0016\u0011\u0011\u0005\u0007\u0003\u0007;\u0003\u0019\u00014\u0002\r=4gm]3u\u0003\u0015\u0011Xm]3u\u00039\u0011X\r\\1uSZ,wJ\u001a4tKR$2\u0001\\AF\u0011\u0019\t\u0019)\u000ba\u0001M\u0006y1-\u00198BaB,g\u000eZ(gMN,G\u000fF\u0002s\u0003#Ca!a!+\u0001\u00041\u0017AD:bM\u00164uN]2f+:l\u0017\r]\u0001\u000bM>\u00148-Z+o[\u0006\u0004\u0018!C7bs\n,Gj\\2l+\u0011\tY*a)\u0015\t\u0005u\u0015q\u0018\u000b\u0005\u0003?\u000b)\f\u0005\u0003\u0002\"\u0006\rF\u0002\u0001\u0003\b\u0003Kk#\u0019AAT\u0005\u0005!\u0016\u0003BAU\u0003_\u00032\u0001WAV\u0013\r\ti+\u0017\u0002\b\u001d>$\b.\u001b8h!\rA\u0016\u0011W\u0005\u0004\u0003gK&aA!os\"A\u0011qW\u0017\u0005\u0002\u0004\tI,A\u0002gk:\u0004R\u0001WA^\u0003?K1!!0Z\u0005!a$-\u001f8b[\u0016t\u0004bBA\u0007[\u0001\u0007\u0011\u0011\u0019\t\u0005\u0003'\t\u0019-\u0003\u0003\u0002F\u0006U!\u0001\u0002'pG.\f!\u0002]1sg\u0016,e\u000e\u001e:z)\u0019\tY-!5\u0002\\B\u0019\u00110!4\n\u0007\u0005=GH\u0001\u0006J]\u0012,\u00070\u00128uefDq!a5/\u0001\u0004\t).\u0001\u0004ck\u001a4WM\u001d\t\u0005\u0003[\t9.\u0003\u0003\u0002Z\u0006=\"A\u0003\"zi\u0016\u0014UO\u001a4fe\"1\u0011Q\u001c\u0018A\u00021\f\u0011A\\\u0001\u0019Y\u0006\u0014x-Z:u\u0019><XM\u001d\"pk:$7\u000b\\8u\r>\u0014Hc\u00027\u0002d\u0006\u001d\u00181\u001e\u0005\b\u0003K|\u0003\u0019AAk\u0003\rIG\r\u001f\u0005\u0007\u0003S|\u0003\u0019\u00014\u0002\rQ\f'oZ3u\u0011\u001d\tio\fa\u0001\u0003_\fAb]3be\u000eDWI\u001c;jif\u0004B!!=\u0003\u00069!\u00111\u001fB\u0001\u001d\u0011\t)0a@\u000f\t\u0005]\u0018Q`\u0007\u0003\u0003sT1!a?A\u0003\u0019a$o\\8u}%\tq(\u0003\u0002>}%\u0019!1\u0001\u001f\u0002\u001f%sG-\u001a=TK\u0006\u00148\r\u001b+za\u0016LAAa\u0002\u0003\n\t\t\u0012J\u001c3fqN+\u0017M]2i\u000b:$\u0018\u000e^=\u000b\u0007\t\rA(A\rt[\u0006dG.Z:u+B\u0004XM\u001d\"pk:$7\u000b\\8u\r>\u0014Hc\u00027\u0003\u0010\tE!1\u0003\u0005\b\u0003K\u0004\u0004\u0019AAk\u0011\u0019\tI\u000f\ra\u0001M\"9\u0011Q\u001e\u0019A\u0002\u0005=\u0018!E5oI\u0016D8\u000b\\8u%\u0006tw-\u001a$peRA!\u0011\u0004B\u0010\u0005C\u0011\u0019\u0003E\u0003Y\u00057aG.C\u0002\u0003\u001ee\u0013a\u0001V;qY\u0016\u0014\u0004bBAsc\u0001\u0007\u0011Q\u001b\u0005\u0007\u0003S\f\u0004\u0019\u00014\t\u000f\u00055\u0018\u00071\u0001\u0002p\u0006\t2m\\7qCJ,\u0017J\u001c3fq\u0016sGO]=\u0015\u000f1\u0014IC!\f\u00030!9!1\u0006\u001aA\u0002\u0005-\u0017AC5oI\u0016DXI\u001c;ss\"1\u0011\u0011\u001e\u001aA\u0002\u0019Dq!!<3\u0001\u0004\ty/\u0001\rs_VtG\rR8x]R{W\t_1di6+H\u000e^5qY\u0016$R\u0001\u001cB\u001b\u0005sAaAa\u000e4\u0001\u0004a\u0017A\u00028v[\n,'\u000f\u0003\u0004\u0003<M\u0002\r\u0001\\\u0001\u0007M\u0006\u001cGo\u001c:\u0002\u0015Q|'+\u001a7bi&4X\r\u0006\u0003\u0003B\t\u001d\u0003\u0003\u0002-\u0003D1L1A!\u0012Z\u0005\u0019y\u0005\u000f^5p]\"1\u00111\u0011\u001bA\u0002\u0019\fQ\"\u00112tiJ\f7\r^%oI\u0016D\bCA=7'\u00151$q\nB+!\rA&\u0011K\u0005\u0004\u0005'J&AB!osJ+g\r\u0005\u0003\u0003X\tuSB\u0001B-\u0015\r\u0011YFP\u0001\u0006kRLGn]\u0005\u0005\u0005?\u0012IFA\u0004M_\u001e<\u0017N\\4\u0015\u0005\t-\u0013A\u00037pO\u001e,'OT1nKV\u0011!q\r\t\u0005\u0005S\u0012\tH\u0004\u0003\u0003l\t5\u0004cAA|3&\u0019!qN-\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\u0019H!\u001e\u0003\rM#(/\u001b8h\u0015\r\u0011y'W\u0001\fY><w-\u001a:OC6,\u0007%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005{R3\u0001\u001cB@W\t\u0011\t\t\u0005\u0003\u0003\u0004\n5UB\u0001BC\u0015\u0011\u00119I!#\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BF3\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t=%Q\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public abstract class AbstractIndex
implements Closeable {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final boolean writable;
    private volatile long _length;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    private volatile int _maxEntries;
    private volatile int _entries;

    public static int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static String loggerName() {
        return AbstractIndex$.MODULE$.loggerName();
    }

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ fatal_this = abstractIndex$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), fatal_this.msgWithLogIdent((String)function0.apply()), (Throwable)function02.apply());
            return;
        }
    }

    public static void fatal(Function0<String> function0) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ fatal_this = abstractIndex$;
        if (fatal_this.logger().underlying().isErrorEnabled(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker())) {
            fatal_this.logger().underlying().error(Logging$.MODULE$.kafka$utils$Logging$$FatalMarker(), fatal_this.msgWithLogIdent((String)function0.apply()));
            return;
        }
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ error_this = abstractIndex$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            error_this.logger().underlying().error(error_this.msgWithLogIdent((String)function0.apply()), (Throwable)function02.apply());
            return;
        }
    }

    public static void error(Function0<String> function0) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ error_this = abstractIndex$;
        if (error_this.logger().underlying().isErrorEnabled()) {
            error_this.logger().underlying().error(error_this.msgWithLogIdent((String)function0.apply()));
            return;
        }
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ warn_this = abstractIndex$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            warn_this.logger().underlying().warn(warn_this.msgWithLogIdent((String)function0.apply()), (Throwable)function02.apply());
            return;
        }
    }

    public static void warn(Function0<String> function0) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ warn_this = abstractIndex$;
        if (warn_this.logger().underlying().isWarnEnabled()) {
            warn_this.logger().underlying().warn(warn_this.msgWithLogIdent((String)function0.apply()));
            return;
        }
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ info_this = abstractIndex$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            info_this.logger().underlying().info(info_this.msgWithLogIdent((String)function0.apply()), (Throwable)function02.apply());
            return;
        }
    }

    public static void info(Function0<String> function0) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ info_this = abstractIndex$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            info_this.logger().underlying().info(info_this.msgWithLogIdent((String)function0.apply()));
            return;
        }
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ debug_this = abstractIndex$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent((String)function0.apply()), (Throwable)function02.apply());
            return;
        }
    }

    public static void debug(Function0<String> function0) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ debug_this = abstractIndex$;
        if (debug_this.logger().underlying().isDebugEnabled()) {
            debug_this.logger().underlying().debug(debug_this.msgWithLogIdent((String)function0.apply()));
            return;
        }
    }

    public static boolean isTraceEnabled() {
        return AbstractIndex$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return AbstractIndex$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ trace_this = abstractIndex$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            trace_this.logger().underlying().trace(trace_this.msgWithLogIdent((String)function0.apply()), (Throwable)function02.apply());
            return;
        }
    }

    public static void trace(Function0<String> function0) {
        AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
        if (abstractIndex$ == null) {
            throw null;
        }
        AbstractIndex$ trace_this = abstractIndex$;
        if (trace_this.logger().underlying().isTraceEnabled()) {
            trace_this.logger().underlying().trace(trace_this.msgWithLogIdent((String)function0.apply()));
            return;
        }
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public boolean writable() {
        return this.writable;
    }

    private long _length() {
        return this._length;
    }

    private void _length_$eq(long x$1) {
        this._length = x$1;
    }

    public abstract int entrySize();

    public int _warmEntries() {
        return 8192 / this.entrySize();
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this._maxEntries;
    }

    public int maxEntries() {
        return this._maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public long length() {
        return this._length();
    }

    /*
     * WARNING - void declaration
     */
    public boolean resize(int newSize) {
        boolean bl;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            bl = AbstractIndex.$anonfun$resize$1(this, newSize);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
        }
        finally {
            this.file_$eq(f);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void flush() {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            AbstractIndex.$anonfun$flush$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public boolean deleteIfExists() {
        this.closeHandler();
        return Files.deleteIfExists(this.file().toPath());
    }

    /*
     * WARNING - void declaration
     */
    public void trimToValidSize() {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            this.resize(this.entrySize() * this._entries());
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    @Override
    public void close() {
        this.trimToValidSize();
        this.closeHandler();
    }

    /*
     * WARNING - void declaration
     */
    public void closeHandler() {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            this.safeForceUnmap();
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void reset() {
        this.truncate();
        this.resize(this.maxIndexSize());
    }

    public int relativeOffset(long offset) {
        Option<Object> relativeOffset = this.toRelative(offset);
        if (relativeOffset.isEmpty()) {
            throw new IndexOffsetOverflowException(new StringBuilder(32).append("Integer overflow for offset: ").append(offset).append(" (").append(this.file().getAbsoluteFile()).append(")").toString());
        }
        return BoxesRunTime.unboxToInt((Object)relativeOffset.get());
    }

    public boolean canAppendOffset(long offset) {
        return this.toRelative(offset).isDefined();
    }

    public void safeForceUnmap() {
        try {
            this.forceUnmap();
            return;
        }
        catch (Throwable t) {
            AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
            if (abstractIndex$ == null) {
                throw null;
            }
            AbstractIndex$ error_this = abstractIndex$;
            if (error_this.logger().underlying().isErrorEnabled()) {
                error_this.logger().underlying().error(error_this.msgWithLogIdent(AbstractIndex.$anonfun$safeForceUnmap$1(this)), t);
                return;
            }
            return;
        }
    }

    public void forceUnmap() {
        try {
            MappedByteBuffers.unmap((String)this.file().getAbsolutePath(), (MappedByteBuffer)this.mmap());
        }
        finally {
            this.mmap_$eq(null);
        }
    }

    public <T> T maybeLock(Lock lock, Function0<T> fun) {
        Object object;
        if (OperatingSystem.IS_WINDOWS) {
            lock.lock();
        }
        try {
            object = fun.apply();
        }
        finally {
            if (OperatingSystem.IS_WINDOWS) {
                lock.unlock();
            }
        }
        return (T)object;
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int largestLowerBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._1$mcI$sp();
    }

    public int smallestUpperBoundSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        return this.indexSlotRangeFor(idx, target, searchEntity)._2$mcI$sp();
    }

    private Tuple2<Object, Object> indexSlotRangeFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return new Tuple2.mcII.sp(-1, -1);
        }
        int firstHotEntry = Math.max(0, this._entries() - 1 - this._warmEntries());
        if (this.compareIndexEntry(this.parseEntry(idx, firstHotEntry), target, searchEntity) < 0) {
            return this.binarySearch$1(firstHotEntry, this._entries() - 1, idx, target, searchEntity);
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return new Tuple2.mcII.sp(-1, 0);
        }
        return this.binarySearch$1(0, firstHotEntry, idx, target, searchEntity);
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        int n;
        Enumeration.Value value = IndexSearchType$.MODULE$.KEY();
        if (!(value != null ? !value.equals(searchEntity) : searchEntity != null)) {
            n = Long.compare(indexEntry.indexKey(), target);
        } else {
            Enumeration.Value value2 = IndexSearchType$.MODULE$.VALUE();
            if (!(value2 != null ? !value2.equals(searchEntity) : searchEntity != null)) {
                n = Long.compare(indexEntry.indexValue(), target);
            } else {
                throw new MatchError((Object)searchEntity);
            }
        }
        return n;
    }

    private int roundDownToExactMultiple(int number, int factor) {
        return factor * (number / factor);
    }

    private Option<Object> toRelative(long offset) {
        long relativeOffset = offset - this.baseOffset();
        if (relativeOffset < 0L || relativeOffset > Integer.MAX_VALUE) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((int)relativeOffset)));
    }

    public static final /* synthetic */ String $anonfun$resize$2(AbstractIndex $this, int roundedNewSize$1) {
        return new StringBuilder(51).append("Index ").append($this.file().getAbsolutePath()).append(" was not resized because it already has size ").append(roundedNewSize$1).toString();
    }

    public static final /* synthetic */ String $anonfun$resize$3(AbstractIndex $this, int roundedNewSize$1) {
        return new StringBuilder(40).append("Resized ").append($this.file().getAbsolutePath()).append(" to ").append(roundedNewSize$1).append(", position is ").append($this.mmap().position()).append(" ").append("and limit is ").append($this.mmap().limit()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$resize$1(AbstractIndex $this, int newSize$1) {
        boolean bl;
        int roundedNewSize = $this.roundDownToExactMultiple(newSize$1, $this.entrySize());
        if ($this._length() == (long)roundedNewSize) {
            AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
            if (abstractIndex$ == null) {
                throw null;
            }
            AbstractIndex$ debug_this = abstractIndex$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(AbstractIndex.$anonfun$resize$2($this, roundedNewSize)));
            }
            return false;
        }
        RandomAccessFile raf = new RandomAccessFile($this.file(), "rw");
        try {
            int position = $this.mmap().position();
            if (OperatingSystem.IS_WINDOWS) {
                $this.safeForceUnmap();
            }
            raf.setLength(roundedNewSize);
            $this._length_$eq(roundedNewSize);
            $this.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
            $this._maxEntries = $this.mmap().limit() / $this.entrySize();
            $this.mmap().position(position);
            AbstractIndex$ abstractIndex$ = AbstractIndex$.MODULE$;
            if (abstractIndex$ == null) {
                throw null;
            }
            AbstractIndex$ debug_this = abstractIndex$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(AbstractIndex.$anonfun$resize$3($this, roundedNewSize)));
            }
            bl = true;
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close(), AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
        }
        return bl;
    }

    public static final /* synthetic */ MappedByteBuffer $anonfun$flush$1(AbstractIndex $this) {
        return $this.mmap().force();
    }

    public static final /* synthetic */ String $anonfun$safeForceUnmap$1(AbstractIndex $this) {
        return new StringBuilder(22).append("Error unmapping index ").append($this.file()).toString();
    }

    private final Tuple2 binarySearch$1(int begin, int end, ByteBuffer idx$1, long target$1, Enumeration.Value searchEntity$1) {
        int lo = begin;
        int hi = end;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx$1, mid);
            int compareResult = this.compareIndexEntry(found, target$1, searchEntity$1);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return new Tuple2.mcII.sp(mid, mid);
        }
        return new Tuple2.mcII.sp(lo, lo == this._entries() - 1 ? -1 : lo + 1);
    }

    public AbstractIndex(File file, long baseOffset, int maxIndexSize, boolean writable) {
        MappedByteBuffer mappedByteBuffer;
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        this.writable = writable;
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = writable ? new RandomAccessFile(this.file(), "rw") : new RandomAccessFile(this.file(), "r");
        try {
            MappedByteBuffer idx;
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder(24).append("Invalid max index size: ").append(maxIndexSize).toString());
                }
                raf.setLength(this.roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            this._length_$eq(raf.length());
            MappedByteBuffer mappedByteBuffer2 = idx = writable ? raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this._length()) : raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this._length());
            if (newlyCreated) {
                idx.position(0);
            } else {
                idx.position(this.roundDownToExactMultiple(idx.limit(), this.entrySize()));
            }
            mappedByteBuffer = idx;
        }
        finally {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raf.close(), AbstractIndex$.MODULE$, CoreUtils$.MODULE$.swallow$default$3());
        }
        this.mmap = mappedByteBuffer;
        this._maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

