/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r]a!B\u001d;\u0001ir\u0004\u0002C)\u0001\u0005\u000b\u0007I\u0011A*\t\u0011\t\u0004!\u0011!Q\u0001\nQC\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0001\u001a\u0005\to\u0002\u0011\t\u0011)A\u0005K\"A\u0001\u0010\u0001BC\u0002\u0013\u0005\u0011\u0010C\u0005\u0002\u0002\u0001\u0011\t\u0011)A\u0005u\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\b\u0001\u0011E\u0013\u0011\u0003\u0005\u000b\u0003?\u0001!\u0019!C\u0001u\u0005E\u0001\u0002CA\u0011\u0001\u0001\u0006I!a\u0005\t\u0013\u0005\r\u0002\u00011A\u0005\n\u0005\u0015\u0002\"CA\u001f\u0001\u0001\u0007I\u0011BA \u0011!\tY\u0005\u0001Q!\n\u0005\u001d\u0002\"CA+\u0001\t\u0007I\u0011BA,\u0011!\tY\u0007\u0001Q\u0001\n\u0005e\u0003\"CA7\u0001\t\u0007I\u0011BA8\u0011!\ti\t\u0001Q\u0001\n\u0005E\u0004\"CAH\u0001\t\u0007I\u0011BAI\u0011!\t9\u000b\u0001Q\u0001\n\u0005M\u0005\"CAU\u0001\t\u0007I\u0011BAV\u0011!\t\u0019\f\u0001Q\u0001\n\u00055\u0006\"CA[\u0001\u0001\u0007I\u0011BA\\\u0011%\ty\f\u0001a\u0001\n\u0013\t\t\r\u0003\u0005\u0002F\u0002\u0001\u000b\u0015BA]\u0011%\tI\r\u0001a\u0001\n\u0013\tY\rC\u0005\u0002T\u0002\u0001\r\u0011\"\u0003\u0002V\"A\u0011\u0011\u001c\u0001!B\u0013\ti\rC\u0004\u0002^\u0002!\t!a8\t\u0011\u0005\u0015\b\u0001\"\u0001;\u0003OD\u0001\"a=\u0001\t\u0003Q\u0014Q\u001f\u0005\b\u0003{\u0004A\u0011AA\u0000\u0011%\u0011\t\u0003AI\u0001\n\u0003\u0011\u0019\u0003C\u0004\u0003:\u0001!\tAa\u000f\t\u000f\t%\u0003\u0001\"\u0001\u0003<!9!1\n\u0001\u0005\u0002\t5\u0003b\u0002B*\u0001\u0011\u0005!Q\u000b\u0005\b\u00053\u0002A\u0011\u0001B.\u0011\u001d\u0011\u0019\u0007\u0001C\u0005\u0005KBqAa\u001d\u0001\t\u0013\u0011)\bC\u0004\u0003z\u0001!\tAa\u001f\t\u000f\t}\u0004\u0001\"\u0001\u0003\u0002\"9!q\u0012\u0001\u0005\u0002\tE\u0005b\u0002BO\u0001\u0011\u0005!q\u0014\u0005\b\u0005K\u0003A\u0011\u0001BT\u0011\u001d\u0011\t\f\u0001C\u0001\u0005gCqA!0\u0001\t\u0003\u0011y\f\u0003\u0005\u0002n\u0001!\tA\u000fBb\u0011\u001d\u0011i\r\u0001C\u0001\u0005\u001fDqAa6\u0001\t\u0013\u0011In\u0002\u0005\u0003`jB\tA\u000fBq\r\u001dI$\b#\u0001;\u0005GDq!a\u00014\t\u0003\u0011)\u000fC\u0004\u0003hN\"\tA!;\t\u000f\t58\u0007\"\u0001\u0003p\"9!1`\u001a\u0005\u0002\tu\bbBB\u0006g\u0011\u00051Q\u0002\u0002\u0012\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014(BA\u001e=\u0003\rawn\u001a\u0006\u0002{\u0005)1.\u00194lCN!\u0001aP#L!\t\u00015)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0019\te.\u001f*fMB\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nP\u0001\u0006kRLGn]\u0005\u0003\u0015\u001e\u0013q\u0001T8hO&tw\r\u0005\u0002M\u001f6\tQJ\u0003\u0002Oy\u00059Q.\u001a;sS\u000e\u001c\u0018B\u0001)N\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\bY><G)\u001b:t\u0007\u0001)\u0012\u0001\u0016\t\u0004+bSV\"\u0001,\u000b\u0005]\u000b\u0015AC2pY2,7\r^5p]&\u0011\u0011L\u0016\u0002\u0004'\u0016\f\bCA.a\u001b\u0005a&BA/_\u0003\tIwNC\u0001`\u0003\u0011Q\u0017M^1\n\u0005\u0005d&\u0001\u0002$jY\u0016\f\u0001\u0002\\8h\t&\u00148\u000fI\u0001\u0005Y><7/F\u0001f!\u00111e\r[:\n\u0005\u001d<%\u0001\u0002)p_2\u0004\"![9\u000e\u0003)T!a\u001b7\u0002\r\r|W.\\8o\u0015\tiTN\u0003\u0002o_\u00061\u0011\r]1dQ\u0016T\u0011\u0001]\u0001\u0004_J<\u0017B\u0001:k\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"\u0001^;\u000e\u0003iJ!A\u001e\u001e\u0003\u00071{w-A\u0003m_\u001e\u001c\b%\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u000b\u0002uB\u00111P`\u0007\u0002y*\u0011Q\u0010P\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005}d(\u0001\u0006'pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.A\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0011\u0002\rqJg.\u001b;?)!\t9!!\u0003\u0002\f\u00055\u0001C\u0001;\u0001\u0011\u0015\tv\u00011\u0001U\u0011\u0015\u0019w\u00011\u0001f\u0011\u0015Ax\u00011\u0001{\u0003)awnZ4fe:\u000bW.Z\u000b\u0003\u0003'\u0001B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033q\u0016\u0001\u00027b]\u001eLA!!\b\u0002\u0018\t11\u000b\u001e:j]\u001e\fAc\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0017!F8gMN,Go\u00115fG.\u0004x.\u001b8u\r&dW\rI\u0001\fG\",7m\u001b9pS:$8/\u0006\u0002\u0002(A9\u0011\u0011FA\u00185\u0006MRBAA\u0016\u0015\r\tiCV\u0001\nS6lW\u000f^1cY\u0016LA!!\r\u0002,\t\u0019Q*\u00199\u0011\t\u0005U\u0012\u0011H\u0007\u0003\u0003oQ1!a\t}\u0013\u0011\tY$a\u000e\u0003)=3gm]3u\u0007\",7m\u001b9pS:$h)\u001b7f\u0003=\u0019\u0007.Z2la>Lg\u000e^:`I\u0015\fH\u0003BA!\u0003\u000f\u00022\u0001QA\"\u0013\r\t)%\u0011\u0002\u0005+:LG\u000fC\u0005\u0002J1\t\t\u00111\u0001\u0002(\u0005\u0019\u0001\u0010J\u0019\u0002\u0019\rDWmY6q_&tGo\u001d\u0011)\u00075\ty\u0005E\u0002A\u0003#J1!a\u0015B\u0005!1x\u000e\\1uS2,\u0017AC5o!J|wM]3tgV\u0011\u0011\u0011\f\t\b\u00037\n\t\u0007[A3\u001b\t\tiFC\u0002\u0002`Y\u000bq!\\;uC\ndW-\u0003\u0003\u0002d\u0005u#a\u0002%bg\"l\u0015\r\u001d\t\u0004i\u0006\u001d\u0014bAA5u\t\u0001Bj\\4DY\u0016\fg.\u001b8h'R\fG/Z\u0001\fS:\u0004&o\\4sKN\u001c\b%A\u000bv]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005E\u0004\u0003CA.\u0003C\n\u0019(a\"\u0011\t\u0005U\u00141\u0011\b\u0005\u0003o\ny\bE\u0002\u0002z\u0005k!!a\u001f\u000b\u0007\u0005u$+\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0003\u000b\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001e\u0005\u0015%bAAA\u0003B)\u00111LAEQ&!\u00111RA/\u0005\r\u0019V\r^\u0001\u0017k:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8tA\u0005!An\\2l+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006\rVBAAL\u0015\u0011\tI*a'\u0002\u000b1|7m[:\u000b\t\u0005u\u0015qT\u0001\u000bG>t7-\u001e:sK:$(bAAQ=\u0006!Q\u000f^5m\u0013\u0011\t)+a&\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0003\u0015awnY6!\u0003I\u0001\u0018-^:fI\u000ecW-\u00198j]\u001e\u001cuN\u001c3\u0016\u0005\u00055\u0006\u0003BAK\u0003_KA!!-\u0002\u0018\nI1i\u001c8eSRLwN\\\u0001\u0014a\u0006,8/\u001a3DY\u0016\fg.\u001b8h\u0007>tG\rI\u0001\u001aI&\u0014H/[3ti2{wm\u00117fC:\f'\r\\3SCRLw.\u0006\u0002\u0002:B\u0019\u0001)a/\n\u0007\u0005u\u0016I\u0001\u0004E_V\u0014G.Z\u0001\u001eI&\u0014H/[3ti2{wm\u00117fC:\f'\r\\3SCRLwn\u0018\u0013fcR!\u0011\u0011IAb\u0011%\tIeFA\u0001\u0002\u0004\tI,\u0001\u000eeSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|\u0007\u0005K\u0002\u0019\u0003\u001f\nQ\u0002^5nK>3G*Y:u%VtWCAAg!\r\u0001\u0015qZ\u0005\u0004\u0003#\f%\u0001\u0002'p]\u001e\f\u0011\u0003^5nK>3G*Y:u%Vtw\fJ3r)\u0011\t\t%a6\t\u0013\u0005%#$!AA\u0002\u00055\u0017A\u0004;j[\u0016|e\rT1tiJ+h\u000e\t\u0015\u00047\u0005=\u0013!F1mY\u000ecW-\u00198fe\u000eCWmY6q_&tGo]\u000b\u0003\u0003C\u0004r!!\u001e\u0002d\"\fi-\u0003\u0003\u00022\u0005\u0015\u0015!D2mK\u0006t\u0017N\\4Ti\u0006$X\r\u0006\u0003\u0002j\u0006=\b#\u0002!\u0002l\u0006\u0015\u0014bAAw\u0003\n1q\n\u001d;j_:Da!!=\u001e\u0001\u0004A\u0017A\u0001;q\u0003A\u0019X\r^\"mK\u0006t\u0017N\\4Ti\u0006$X\r\u0006\u0004\u0002B\u0005]\u0018\u0011 \u0005\u0007\u0003ct\u0002\u0019\u00015\t\u000f\u0005mh\u00041\u0001\u0002f\u0005)1\u000f^1uK\u0006IrM]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h)\u0019\u0011\tA!\u0003\u0003\u0018A)\u0001)a;\u0003\u0004A\u0019AO!\u0002\n\u0007\t\u001d!H\u0001\u0006M_\u001e$vn\u00117fC:DqAa\u0003 \u0001\u0004\u0011i!\u0001\u0003uS6,\u0007\u0003\u0002B\b\u0005'i!A!\u0005\u000b\u0005!S\u0017\u0002\u0002B\u000b\u0005#\u0011A\u0001V5nK\"I!\u0011D\u0010\u0011\u0002\u0003\u0007!1D\u0001\u000eaJ,7\t\\3b]N#\u0018\r^:\u0011\u0007Q\u0014i\"C\u0002\u0003 i\u0012Q\u0002\u0015:f\u00072,\u0017M\\*uCR\u001c\u0018aI4sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e$C-\u001a4bk2$HEM\u000b\u0003\u0005KQCAa\u0007\u0003(-\u0012!\u0011\u0006\t\u0005\u0005W\u0011)$\u0004\u0002\u0003.)!!q\u0006B\u0019\u0003%)hn\u00195fG.,GMC\u0002\u00034\u0005\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u00119D!\f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0014qCV\u001cXm\u00117fC:Lgn\u001a$pe:{gnQ8na\u0006\u001cG/\u001a3QCJ$\u0018\u000e^5p]N$\"A!\u0010\u0011\u000bU\u0013yDa\u0011\n\u0007\t\u0005cK\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0015\u0001%Q\t5t\u0013\r\u00119%\u0011\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u001b\u0011,G.\u001a;bE2,Gj\\4t\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u0011\u0011\tB(\u0011\u0019\u0011\tf\ta\u0001Q\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0017!F1c_J$\u0018I\u001c3QCV\u001cXm\u00117fC:Lgn\u001a\u000b\u0005\u0003\u0003\u00129\u0006\u0003\u0004\u0003R\u0011\u0002\r\u0001[\u0001\u000fe\u0016\u001cX/\\3DY\u0016\fg.\u001b8h)\u0011\t\tE!\u0018\t\u000f\t}S\u00051\u0001\u0003b\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0003V\u0005\u007fA\u0017!E5t\u00072,\u0017M\\5oO&s7\u000b^1uKR1!q\rB7\u0005_\u00022\u0001\u0011B5\u0013\r\u0011Y'\u0011\u0002\b\u0005>|G.Z1o\u0011\u0019\u0011\tF\na\u0001Q\"9!\u0011\u000f\u0014A\u0002\u0005\u0015\u0014!D3ya\u0016\u001cG/\u001a3Ti\u0006$X-A\fjg\u000ecW-\u00198j]\u001eLen\u0015;bi\u0016\u0004\u0016-^:fIR!!q\rB<\u0011\u0019\u0011\tf\na\u0001Q\u0006!2\r[3dW\u000ecW-\u00198j]\u001e\f%m\u001c:uK\u0012$B!!\u0011\u0003~!1!\u0011\u000b\u0015A\u0002!\f\u0011#\u001e9eCR,7\t[3dWB|\u0017N\u001c;t)\u0019\t\tEa!\u0003\b\"1!QQ\u0015A\u0002i\u000bq\u0001Z1uC\u0012K'\u000fC\u0004\u0003\n&\u0002\rAa#\u0002\rU\u0004H-\u0019;f!\u0015\u0001\u00151\u001eBG!\u0019\u0001%Q\t5\u0002N\u0006\u0011\u0012\r\u001c;fe\u000eCWmY6q_&tG\u000fR5s)!\t\tEa%\u0003\u0016\ne\u0005B\u0002B)U\u0001\u0007\u0001\u000e\u0003\u0004\u0003\u0018*\u0002\rAW\u0001\rg>,(oY3M_\u001e$\u0015N\u001d\u0005\u0007\u00057S\u0003\u0019\u0001.\u0002\u0015\u0011,7\u000f\u001e'pO\u0012K'/A\niC:$G.\u001a'pO\u0012K'OR1jYV\u0014X\r\u0006\u0003\u0002B\t\u0005\u0006b\u0002BRW\u0001\u0007\u00111O\u0001\u0004I&\u0014\u0018aF7bs\n,GK];oG\u0006$Xm\u00115fG.\u0004x.\u001b8u)!\t\tE!+\u0003,\n5\u0006B\u0002BCY\u0001\u0007!\f\u0003\u0004\u0003R1\u0002\r\u0001\u001b\u0005\b\u0005_c\u0003\u0019AAg\u0003\u0019ygMZ:fi\u0006aAm\u001c8f\u00072,\u0017M\\5oORA\u0011\u0011\tB[\u0005o\u0013I\f\u0003\u0004\u0003R5\u0002\r\u0001\u001b\u0005\u0007\u0005\u000bk\u0003\u0019\u0001.\t\u000f\tmV\u00061\u0001\u0002N\u0006IQM\u001c3PM\u001a\u001cX\r^\u0001\rI>tW\rR3mKRLgn\u001a\u000b\u0005\u0003\u0003\u0012\t\rC\u0004\u0003`9\u0002\rA!\u0019\u0015\t\t\u0015'\u0011\u001a\t\u0006\u0003k\u00129\r[\u0005\u0005\u0003\u0017\u000b)\tC\u0004\u0003L>\u0002\r!a\u001d\u0002\r1|w\rR5s\u0003ai\u0017M]6QCJ$\u0018\u000e^5p]Vs7\r\\3b]\u0006\u0014G.\u001a\u000b\u0007\u0003\u0003\u0012\tNa5\t\u000f\t-\u0007\u00071\u0001\u0002t!1!Q\u001b\u0019A\u0002!\f\u0011\u0002]1si&$\u0018n\u001c8\u0002-%\u001cXK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:$bAa\u001a\u0003\\\nu\u0007\"B\u001e2\u0001\u0004\u0019\bB\u0002B)c\u0001\u0007\u0001.A\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ\u0004\"\u0001^\u001a\u0014\u0007MzT\t\u0006\u0002\u0003b\u0006\u0011\u0012n]\"p[B\f7\r^!oI\u0012+G.\u001a;f)\u0011\u00119Ga;\t\u000bm*\u0004\u0019A:\u0002%5\f\u0007pQ8na\u0006\u001cG/[8o\t\u0016d\u0017-\u001f\u000b\t\u0003\u001b\u0014\tPa=\u0003x\")1H\u000ea\u0001g\"9!Q\u001f\u001cA\u0002\u00055\u0017\u0001\u00054jeN$H)\u001b:us>3gm]3u\u0011\u001d\u0011IP\u000ea\u0001\u0003\u001b\f1A\\8x\u0003A\u0019G.Z1oC\ndWm\u00144gg\u0016$8\u000f\u0006\u0005\u0003\u0000\u000e\u000511AB\u0005!\u001d\u0001%QIAg\u0003\u001bDQaO\u001cA\u0002MDqa!\u00028\u0001\u0004\u00199!A\bmCN$8\t\\3b]>3gm]3u!\u0015\u0001\u00151^Ag\u0011\u001d\u0011Ip\u000ea\u0001\u0003\u001b\fqcY1mGVd\u0017\r^3DY\u0016\fg.\u00192mK\nKH/Z:\u0015\u0011\t}8qBB\t\u0007'AQa\u000f\u001dA\u0002MDqA!>9\u0001\u0004\ti\rC\u0004\u0004\u0016a\u0002\r!!4\u0002#Ut7\r\\3b]\u0006\u0014G.Z(gMN,G\u000f")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final HashMap<String, Set<TopicPartition>> kafka$log$LogCleanerManager$$uncleanablePartitions;
    private final ReentrantLock kafka$log$LogCleanerManager$$lock;
    private final Condition pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private volatile long kafka$log$LogCleanerManager$$timeOfLastRun;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> calculateCleanableBytes(Log log, long l, long l2) {
        return LogCleanerManager$.MODULE$.calculateCleanableBytes(log, l, l2);
    }

    public static Tuple2<Object, Object> cleanableOffsets(Log log, Option<Object> option, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, option, l);
    }

    public static long maxCompactionDelay(Log log, long l, long l2) {
        return LogCleanerManager$.MODULE$.maxCompactionDelay(log, l, l2);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    public HashMap<String, Set<TopicPartition>> kafka$log$LogCleanerManager$$uncleanablePartitions() {
        return this.kafka$log$LogCleanerManager$$uncleanablePartitions;
    }

    public ReentrantLock kafka$log$LogCleanerManager$$lock() {
        return this.kafka$log$LogCleanerManager$$lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    private void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public long kafka$log$LogCleanerManager$$timeOfLastRun() {
        return this.kafka$log$LogCleanerManager$$timeOfLastRun;
    }

    private void kafka$log$LogCleanerManager$$timeOfLastRun_$eq(long x$1) {
        this.kafka$log$LogCleanerManager$$timeOfLastRun = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        scala.collection.immutable.Map map;
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            map = LogCleanerManager.$anonfun$allCleanerCheckpoints$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        Option option;
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$cleaningState$1(this, tp);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$setCleaningState$1(this, tp, state);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogToClean> grabFilthiestCompactedLog(Time time, PreCleanStats preCleanStats) {
        Option option;
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$grabFilthiestCompactedLog$1(this, time, preCleanStats);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    public PreCleanStats grabFilthiestCompactedLog$default$2() {
        return new PreCleanStats();
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Tuple2<TopicPartition, Log>> pauseCleaningForNonCompactedPartitions() {
        Iterable iterable;
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        Iterable iterable;
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$deletableLogs$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public void abortCleaning(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("The cleaning for partition ").append(topicPartition).append(" is aborted").toString());
    }

    /*
     * WARNING - void declaration
     */
    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("The cleaning for partition ").append(topicPartition).append(" is aborted and paused").toString());
    }

    /*
     * WARNING - void declaration
     */
    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                Option option = $this.inProgress().get(topicPartition);
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(67).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is not paused.").toString());
                }
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                LogCleaningState state = (LogCleaningState)((Some)option).value();
                boolean bl = false;
                LogCleaningPaused logCleaningPaused = null;
                if (state instanceof LogCleaningPaused) {
                    bl = true;
                    logCleaningPaused = (LogCleaningPaused)state;
                    if (logCleaningPaused.pausedCount() == 1) {
                        return $this.inProgress().remove(topicPartition);
                    }
                }
                if (!bl) throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
                int count = logCleaningPaused.pausedCount();
                if (count <= 1) throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
                return $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(count - 1));
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState logCleaningState = (LogCleaningState)((Some)option).value();
            bl = !(logCleaningState != null ? !logCleaningState.equals(expectedState) : expectedState != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            boolean bl2 = (LogCleaningState)((Some)option).value() instanceof LogCleaningPaused;
            bl = bl2;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void checkCleaningAborted(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$checkCleaningAborted$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$updateCheckpoints$1(this, dataDir, update);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$alterCheckpointDir$1(this, sourceLogDir, topicPartition, destLogDir);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleLogDirFailure(String dir) {
        void inLock_lock;
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Stopping cleaning logs in dir ").append(dir).toString());
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)((scala.collection.immutable.Map)this.checkpoints().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir$3, x0$1)))));
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$maybeTruncateCheckpoint$1(this, topicPartition, dataDir, offset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$doneCleaning$1(this, topicPartition, dataDir, endOffset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                LogCleaningState logCleaningState;
                boolean bl = false;
                Some some = null;
                Option option = $this.inProgress().get(topicPartition);
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                    if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                        return $this.inProgress().remove(topicPartition);
                    }
                }
                if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                    $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(1));
                    $this.pausedCleaningCond().signalAll();
                    return BoxedUnit.UNIT;
                }
                if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
                throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        void inLock_lock;
        ObjectRef partitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            partitions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions.elem).$plus$plus((GenTraversableOnce)this.kafka$log$LogCleanerManager$$uncleanablePartitions().getOrElse((Object)logDir, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        }
        finally {
            inLock_lock.unlock();
        }
        return (scala.collection.immutable.Set)partitions.elem;
    }

    /*
     * WARNING - void declaration
     */
    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$markPartitionUncleanable$1(this, logDir, partition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isUncleanablePartition(Log log, TopicPartition topicPartition) {
        boolean bl;
        void inLock_lock;
        ReentrantLock reentrantLock = this.kafka$log$LogCleanerManager$$lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            bl = LogCleanerManager.$anonfun$isUncleanablePartition$1(this, log, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$allCleanerCheckpoints$1(LogCleanerManager $this) {
        return ((TraversableOnce)$this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)checkpoint -> {
            try {
                return checkpoint.read();
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return Predef$.MODULE$.Map().empty();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ Option $anonfun$cleaningState$1(LogCleanerManager $this, TopicPartition tp$1) {
        return $this.inProgress().get((Object)tp$1);
    }

    public static final /* synthetic */ Option $anonfun$setCleaningState$1(LogCleanerManager $this, TopicPartition tp$2, LogCleaningState state$1) {
        return $this.inProgress().put((Object)tp$2, (Object)state$1);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((Log)x0$1._2()).config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$2._1();
        Log log = (Log)x0$2._2();
        boolean bl = $this.inProgress().contains((Object)topicPartition) || $this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.needCompactionNow() && ltc.cleanableBytes() > 0L || ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ Option $anonfun$grabFilthiestCompactedLog$1(LogCleanerManager $this, Time time$1, PreCleanStats preCleanStats$1) {
        long now = time$1.milliseconds();
        $this.kafka$log$LogCleanerManager$$timeOfLastRun_$eq(now);
        scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
        Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3($this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            LogToClean logToClean;
            if (x0$3 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$3._1();
                Log log = (Log)x0$3._2();
                try {
                    void var12_9;
                    void var10_8;
                    Option lastCleanOffset = lastClean.get((Object)topicPartition);
                    Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long firstDirtyOffset = tuple2._1$mcJ$sp();
                    long firstUncleanableDirtyOffset = tuple2._2$mcJ$sp();
                    long compactionDelayMs = LogCleanerManager$.MODULE$.maxCompactionDelay(log, (long)var10_8, now);
                    preCleanStats$1.updateMaxCompactionDelay(compactionDelayMs);
                    logToClean = new LogToClean(topicPartition, log, (long)var10_8, (long)var12_9, compactionDelayMs > 0L);
                }
                catch (Throwable e) {
                    throw new LogCleaningException(log, new StringBuilder(53).append("Failed to calculate log cleaning stats for partition ").append(topicPartition).toString(), e);
                }
            } else {
                throw new MatchError(null);
            }
            LogToClean logToClean2 = logToClean;
            return logToClean2;
        }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
        $this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
        Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
        if (cleanableLogs.isEmpty()) {
            return None$.MODULE$;
        }
        preCleanStats$1.recordCleanablePartitions(cleanableLogs.size());
        LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        $this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
        return new Some((Object)filthiest);
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = !((Log)x0$1._2()).config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$2._1();
        boolean bl = $this.inProgress().contains((Object)topicPartition);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Iterable $anonfun$pauseCleaningForNonCompactedPartitions$1(LogCleanerManager $this) {
        void var1_1;
        Iterable deletableLogs = (Iterable)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3($this, x0$2)));
        deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$3._1();
            Option option = $this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
            return option;
        });
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$1._1();
        Log log = (Log)x0$1._2();
        boolean bl = !$this.inProgress().contains((Object)topicPartition) && log.config().compact() && !$this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Iterable $anonfun$deletableLogs$1(LogCleanerManager $this) {
        void var1_1;
        Iterable toClean = (Iterable)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2($this, x0$1)));
        toClean.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Option option = $this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
            return option;
        });
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$abortCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$1) {
        $this.abortAndPauseCleaning(topicPartition$1);
        $this.resumeCleaning((Iterable<TopicPartition>)((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$1}))));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$2) {
        block7: {
            block6: {
                var2_2 = false;
                var3_3 = null;
                var4_4 = $this.inProgress().get((Object)topicPartition$2);
                if (!None$.MODULE$.equals(var4_4)) break block6;
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(1));
                break block7;
            }
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            var2_2 = true;
            var3_3 = (Some)var4_4;
            var5_5 = (LogCleaningState)var3_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var5_5)) {
                $this.inProgress().put((Object)topicPartition$2, (Object)LogCleaningAborted$.MODULE$);
            } else if (var2_2 && (var6_6 = (LogCleaningState)var3_3.value()) instanceof LogCleaningPaused) {
                count = ((LogCleaningPaused)var6_6).pausedCount();
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(count + 1));
            } else {
                if (var2_2) {
                    s = (LogCleaningState)var3_3.value();
                    throw new IllegalStateException(new StringBuilder(77).append("Compaction for partition ").append(topicPartition$2).append(" cannot be aborted and paused since it is in ").append(s).append(" state.").toString());
                }
                throw new MatchError((Object)var4_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$2)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    public static final /* synthetic */ void $anonfun$checkCleaningAborted$1(LogCleanerManager $this, TopicPartition topicPartition$3) {
        if ($this.isCleaningInState(topicPartition$3, LogCleaningAborted$.MODULE$)) {
            throw new LogCleaningAbortedException();
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateCheckpoints$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition k = (TopicPartition)x0$1._1();
        boolean bl = $this.logs().keys().contains((Object)k);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$updateCheckpoints$1(LogCleanerManager $this, File dataDir$1, Option update$1) {
        OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$1);
        if (checkpoint != null) {
            try {
                Map existing = ((MapLike)checkpoint.read().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$updateCheckpoints$2($this, x0$1)))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(update$1));
                checkpoint.write((Map<TopicPartition, Object>)existing);
                return;
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
        }
    }

    public static final /* synthetic */ Option $anonfun$alterCheckpointDir$2(TopicPartition topicPartition$4, OffsetCheckpointFile x$4) {
        return x$4.read().get((Object)topicPartition$4);
    }

    public static final /* synthetic */ void $anonfun$alterCheckpointDir$1(LogCleanerManager $this, File sourceLogDir$1, TopicPartition topicPartition$4, File destLogDir$1) {
        try {
            None$ none$;
            Option option = $this.checkpoints().get((Object)sourceLogDir$1);
            if (option == null) {
                throw null;
            }
            Option flatMap_this = option;
            if (flatMap_this.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                OffsetCheckpointFile offsetCheckpointFile = (OffsetCheckpointFile)flatMap_this.get();
                none$ = LogCleanerManager.$anonfun$alterCheckpointDir$2(topicPartition$4, offsetCheckpointFile);
            }
            if (none$ instanceof Some) {
                long offset = BoxesRunTime.unboxToLong((Object)((Some)none$).value());
                $this.updateCheckpoints(sourceLogDir$1, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
                $this.updateCheckpoints(destLogDir$1, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$4, (Object)BoxesRunTime.boxToLong((long)offset))));
            } else if (!None$.MODULE$.equals(none$)) {
                throw new MatchError((Object)none$);
            }
        }
        catch (KafkaStorageException e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to access checkpoint file in dir ").append(sourceLogDir$1.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
        Set logUncleanablePartitions = (Set)$this.kafka$log$LogCleanerManager$$uncleanablePartitions().getOrElse((Object)sourceLogDir$1.toString(), (Function0 & Serializable & scala.Serializable)() -> (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
        if (logUncleanablePartitions.contains((Object)topicPartition$4)) {
            logUncleanablePartitions.remove((Object)topicPartition$4);
            $this.markPartitionUncleanable(destLogDir$1.toString(), topicPartition$4);
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$3, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((File)x0$1._1()).getAbsolutePath();
        boolean bl = string == null ? dir$3 != null : !string.equals(dir$3);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$maybeTruncateCheckpoint$1(LogCleanerManager $this, TopicPartition topicPartition$5, File dataDir$2, long offset$1) {
        Map<TopicPartition, Object> existing;
        OffsetCheckpointFile checkpoint;
        if ($this.logs().get(topicPartition$5).config().compact() && (checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$2)) != null && BoxesRunTime.unboxToLong((Object)(existing = checkpoint.read()).getOrElse((Object)topicPartition$5, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) > offset$1) {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Long l = BoxesRunTime.boxToLong((long)offset$1);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition$5);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            checkpoint.write((Map<TopicPartition, Object>)existing.$plus(new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y)));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Object $anonfun$doneCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$6, File dataDir$3, long endOffset$1) {
        LogCleaningState logCleaningState;
        boolean bl = false;
        Some some = null;
        Option option = $this.inProgress().get((Object)topicPartition$6);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
            if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                $this.updateCheckpoints(dataDir$3, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$6, (Object)BoxesRunTime.boxToLong((long)endOffset$1))));
                return $this.inProgress().remove((Object)topicPartition$6);
            }
        }
        if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
            $this.inProgress().put((Object)topicPartition$6, (Object)new LogCleaningPaused(1));
            $this.pausedCleaningCond().signalAll();
            return BoxedUnit.UNIT;
        }
        if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition$6).append(" cannot be in ").append(option).append(" state.").toString());
        throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition$6).append(" should exist.").toString());
    }

    public static final /* synthetic */ Object $anonfun$markPartitionUncleanable$1(LogCleanerManager $this, String logDir$2, TopicPartition partition$1) {
        Boolean bl;
        Option option = $this.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)logDir$2);
        if (option instanceof Some) {
            bl = BoxesRunTime.boxToBoolean((boolean)((Set)((Some)option).value()).add((Object)partition$1));
        } else if (None$.MODULE$.equals(option)) {
            bl = $this.kafka$log$LogCleanerManager$$uncleanablePartitions().put((Object)logDir$2, (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$1})));
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isUncleanablePartition$1(LogCleanerManager $this, Log log$1, TopicPartition topicPartition$7) {
        Set set;
        Option option = $this.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)log$1.dir().getParent());
        if (option == null) {
            throw null;
        }
        Option exists_this = option;
        boolean bl = !exists_this.isEmpty() && (set = (Set)exists_this.get()).contains((Object)topicPartition$7);
        return bl;
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((TraversableOnce)logDirs.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$log$LogCleanerManager$$uncleanablePartitions = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$log$LogCleanerManager$$lock = new ReentrantLock();
        this.pausedCleaningCond = this.kafka$log$LogCleanerManager$$lock().newCondition();
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = dir.getAbsolutePath();
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"logDirectory");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return this.newGauge("uncleanable-partitions-count", new Gauge<Object>(this, dir){
                private final /* synthetic */ LogCleanerManager $outer;
                private final File dir$1;

                /*
                 * WARNING - void declaration
                 */
                public int value() {
                    int n;
                    void inLock_lock;
                    ReentrantLock reentrantLock = this.$outer.kafka$log$LogCleanerManager$$lock();
                    if (CoreUtils$.MODULE$ == null) {
                        throw null;
                    }
                    inLock_lock.lock();
                    try {
                        n = $anon$1.$anonfun$value$1(this);
                    }
                    finally {
                        inLock_lock.unlock();
                    }
                    return n;
                }

                public static final /* synthetic */ int $anonfun$value$2(Set x$1) {
                    return x$1.size();
                }

                public static final /* synthetic */ int $anonfun$value$3() {
                    return 0;
                }

                public static final /* synthetic */ int $anonfun$value$1($anon$1 $this) {
                    Option option = $this.$outer.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)$this.dir$1.getAbsolutePath());
                    if (option == null) {
                        throw null;
                    }
                    Option map_this = option;
                    Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)$anon$1.$anonfun$value$2((Set)map_this.get())));
                    if (object == null) {
                        throw null;
                    }
                    Object object2 = object.isEmpty() ? BoxesRunTime.boxToInteger((int)$anon$1.$anonfun$value$3()) : object.get();
                    return BoxesRunTime.unboxToInt((Object)object2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dir$1 = dir$1;
                }

                public static final /* synthetic */ Object $anonfun$value$2$adapted(Set x$1) {
                    return BoxesRunTime.boxToInteger((int)$anon$1.$anonfun$value$2(x$1));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.log.LogCleanerManager$$anon$1 ), $anonfun$value$2$adapted(scala.collection.mutable.Set ), $anonfun$value$3()}, serializedLambda);
                }
            }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        });
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            String string = dir.getAbsolutePath();
            Object object = Predef$.MODULE$.ArrowAssoc((Object)"logDirectory");
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            return this.newGauge("uncleanable-bytes", new Gauge<Object>(this, dir){
                private final /* synthetic */ LogCleanerManager $outer;
                private final File dir$2;

                /*
                 * WARNING - void declaration
                 */
                public long value() {
                    long l;
                    void inLock_lock;
                    ReentrantLock reentrantLock = this.$outer.kafka$log$LogCleanerManager$$lock();
                    if (CoreUtils$.MODULE$ == null) {
                        throw null;
                    }
                    inLock_lock.lock();
                    try {
                        l = $anon$2.$anonfun$value$4(this);
                    }
                    finally {
                        inLock_lock.unlock();
                    }
                    return l;
                }

                /*
                 * WARNING - void declaration
                 */
                public static final /* synthetic */ long $anonfun$value$5($anon$2 $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
                    void var13_10;
                    void var10_8;
                    void var8_7;
                    Option lastCleanOffset;
                    Log log = $this.$outer.logs().get(tp);
                    Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)(lastCleanOffset = lastClean$1.get((Object)tp)), now$1);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long firstDirtyOffset = tuple2._1$mcJ$sp();
                    long firstUncleanableDirtyOffset = tuple2._2$mcJ$sp();
                    Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, (long)var8_7, (long)var10_8);
                    if (tuple22 == null) {
                        throw new MatchError(null);
                    }
                    long uncleanableBytes = tuple22._2$mcJ$sp();
                    return (long)var13_10;
                }

                public static final /* synthetic */ long $anonfun$value$4($anon$2 $this) {
                    long l;
                    Option option = $this.$outer.kafka$log$LogCleanerManager$$uncleanablePartitions().get((Object)$this.dir$2.getAbsolutePath());
                    if (option instanceof Some) {
                        Set partitions = (Set)((Some)option).value();
                        scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.$outer.allCleanerCheckpoints();
                        long now = Time.SYSTEM.milliseconds();
                        l = BoxesRunTime.unboxToLong((Object)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToLong((long)$anon$2.$anonfun$value$5($this, lastClean, now, tp)), Set$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    } else {
                        l = 0L;
                    }
                    return l;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.dir$2 = dir$2;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$4(kafka.log.LogCleanerManager$$anon$2 ), $anonfun$value$5$adapted(kafka.log.LogCleanerManager$$anon$2 scala.collection.immutable.Map long org.apache.kafka.common.TopicPartition )}, serializedLambda);
                }
            }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        });
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.kafka$log$LogCleanerManager$$timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public long value() {
                return Time.SYSTEM.milliseconds() - this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public static final /* synthetic */ Object $anonfun$isUncleanablePartition$2$adapted(TopicPartition topicPartition$7, Set partitions) {
        return BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)topicPartition$7));
    }
}

