/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import kafka.log.BatchMetadata;
import kafka.log.ProducerStateEntry$;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=tAB\u0012%\u0011\u0003!\u0003F\u0002\u0004+I!\u0005Ae\u000b\u0005\u0006e\u0005!\t\u0001\u000e\u0005\tk\u0005\u0011\r\u0011\"\u0001%m!1!(\u0001Q\u0001\n]BQaO\u0001\u0005\u0002q2QA\u000b\u0013\u0001IyB\u0001b\u0010\u0004\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\t\u001a\u0011\t\u0011)A\u0005\u0003\"AQI\u0002BC\u0002\u0013\u0005a\t\u0003\u0005S\r\t\u0005\t\u0015!\u0003H\u0011!\u0019fA!a\u0001\n\u0003!\u0006\u0002\u0003-\u0007\u0005\u0003\u0007I\u0011A-\t\u0011}3!\u0011!Q!\nUC\u0001\u0002\u0019\u0004\u0003\u0002\u0004%\tA\u000e\u0005\tC\u001a\u0011\t\u0019!C\u0001E\"AAM\u0002B\u0001B\u0003&q\u0007\u0003\u0005f\r\t\u0005\r\u0011\"\u0001g\u0011!QgA!a\u0001\n\u0003Y\u0007\u0002C7\u0007\u0005\u0003\u0005\u000b\u0015B4\t\u000bI2A\u0011\u00018\t\u000bQ4A\u0011\u0001\u001c\t\u000bU4A\u0011\u0001!\t\u000bY4A\u0011\u0001\u001c\t\u000b]4A\u0011\u0001!\t\u000ba4A\u0011\u0001!\t\u000be4A\u0011\u0001\u001c\t\u000bi4A\u0011A>\t\r}4A\u0011AA\u0001\u0011\u001d\t\u0019B\u0002C\u0001\u0003+Aq!!\u0007\u0007\t\u0013\tY\u0002C\u0004\u0002\"\u0019!\t!a\t\t\u000f\u0005%b\u0001\"\u0001\u0002,!9\u00111\n\u0004\u0005\u0002\u00055\u0003bBA*\r\u0011\u0005\u0013QK\u0001\u0013!J|G-^2feN#\u0018\r^3F]R\u0014\u0018P\u0003\u0002&M\u0005\u0019An\\4\u000b\u0003\u001d\nQa[1gW\u0006\u0004\"!K\u0001\u000e\u0003\u0011\u0012!\u0003\u0015:pIV\u001cWM]*uCR,WI\u001c;ssN\u0011\u0011\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001K\u0001\u0013\u001dVl')\u0019;dQ\u0016\u001cHk\u001c*fi\u0006Lg.F\u00018!\ti\u0003(\u0003\u0002:]\t\u0019\u0011J\u001c;\u0002'9+XNQ1uG\",7\u000fV8SKR\f\u0017N\u001c\u0011\u0002\u000b\u0015l\u0007\u000f^=\u0015\u0007u\ni\u0007\u0005\u0002*\rM\u0011a\u0001L\u0001\u000baJ|G-^2fe&#W#A!\u0011\u00055\u0012\u0015BA\"/\u0005\u0011auN\\4\u0002\u0017A\u0014x\u000eZ;dKJLE\rI\u0001\u000eE\u0006$8\r['fi\u0006$\u0017\r^1\u0016\u0003\u001d\u00032\u0001S'P\u001b\u0005I%B\u0001&L\u0003\u001diW\u000f^1cY\u0016T!\u0001\u0014\u0018\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002O\u0013\n)\u0011+^3vKB\u0011\u0011\u0006U\u0005\u0003#\u0012\u0012QBQ1uG\"lU\r^1eCR\f\u0017A\u00042bi\u000eDW*\u001a;bI\u0006$\u0018\rI\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0016\u0003U\u0003\"!\f,\n\u0005]s#!B*i_J$\u0018!\u00059s_\u0012,8-\u001a:Fa>\u001c\u0007n\u0018\u0013fcR\u0011!,\u0018\t\u0003[mK!\u0001\u0018\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b=2\t\t\u00111\u0001V\u0003\rAH%M\u0001\u000faJ|G-^2fe\u0016\u0003xn\u00195!\u0003A\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007.\u0001\u000bd_>\u0014H-\u001b8bi>\u0014X\t]8dQ~#S-\u001d\u000b\u00035\u000eDqAX\b\u0002\u0002\u0003\u0007q'A\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0002\nQcY;se\u0016tG\u000f\u0016=o\r&\u00148\u000f^(gMN,G/F\u0001h!\ri\u0003.Q\u0005\u0003S:\u0012aa\u00149uS>t\u0017!G2veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r^0%KF$\"A\u00177\t\u000fy\u0013\u0012\u0011!a\u0001O\u000612-\u001e:sK:$H\u000b\u001f8GSJ\u001cHo\u00144gg\u0016$\b\u0005\u0006\u0004>_B\f(o\u001d\u0005\u0006\u007fQ\u0001\r!\u0011\u0005\u0006\u000bR\u0001\ra\u0012\u0005\u0006'R\u0001\r!\u0016\u0005\u0006AR\u0001\ra\u000e\u0005\u0006KR\u0001\raZ\u0001\tM&\u00148\u000f^*fc\u0006Ya-\u001b:ti>3gm]3u\u0003\u001da\u0017m\u001d;TKF\fa\u0002\\1ti\u0012\u000bG/Y(gMN,G/A\u0007mCN$H+[7fgR\fW\u000e]\u0001\u0010Y\u0006\u001cHo\u00144gg\u0016$H)\u001a7uC\u00069\u0011n]#naRLX#\u0001?\u0011\u00055j\u0018B\u0001@/\u0005\u001d\u0011un\u001c7fC:\f\u0001\"\u00193e\u0005\u0006$8\r\u001b\u000b\f5\u0006\r\u0011QAA\u0004\u0003\u0017\ty\u0001C\u0003T9\u0001\u0007Q\u000bC\u0003w9\u0001\u0007q\u0007\u0003\u0004\u0002\nq\u0001\r!Q\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$\bBBA\u00079\u0001\u0007q'A\u0006pM\u001a\u001cX\r\u001e#fYR\f\u0007BBA\t9\u0001\u0007\u0011)A\u0005uS6,7\u000f^1na\u0006\u0001R.Y=cKV\u0003H-\u0019;f\u000bB|7\r\u001b\u000b\u0004y\u0006]\u0001\"B*\u001e\u0001\u0004)\u0016\u0001E1eI\n\u000bGo\u00195NKR\fG-\u0019;b)\rQ\u0016Q\u0004\u0005\u0007\u0003?q\u0002\u0019A(\u0002\u000b\t\fGo\u00195\u0002\rU\u0004H-\u0019;f)\rQ\u0016Q\u0005\u0005\u0007\u0003Oy\u0002\u0019A\u001f\u0002\u00139,\u0007\u0010^#oiJL\u0018A\u00054j]\u0012$U\u000f\u001d7jG\u0006$XMQ1uG\"$B!!\f\u00020A\u0019Q\u0006[(\t\u000f\u0005}\u0001\u00051\u0001\u00022A!\u00111GA$\u001b\t\t)D\u0003\u0003\u00028\u0005e\u0012A\u0002:fG>\u0014HM\u0003\u0003\u0002<\u0005u\u0012AB2p[6|gNC\u0002(\u0003\u007fQA!!\u0011\u0002D\u00051\u0011\r]1dQ\u0016T!!!\u0012\u0002\u0007=\u0014x-\u0003\u0003\u0002J\u0005U\"a\u0003*fG>\u0014HMQ1uG\"\faCY1uG\"<\u0016\u000e\u001e5TKF,XM\\2f%\u0006tw-\u001a\u000b\u0007\u0003[\ty%!\u0015\t\u000bQ\f\u0003\u0019A\u001c\t\u000bY\f\u0003\u0019A\u001c\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0016\u0011\t\u0005e\u0013q\r\b\u0005\u00037\n\u0019\u0007E\u0002\u0002^9j!!a\u0018\u000b\u0007\u0005\u00054'\u0001\u0004=e>|GOP\u0005\u0004\u0003Kr\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002j\u0005-$AB*ue&twMC\u0002\u0002f9BQaP\u0003A\u0002\u0005\u0003")
public class ProducerStateEntry {
    private final long producerId;
    private final Queue<BatchMetadata> batchMetadata;
    private short producerEpoch;
    private int coordinatorEpoch;
    private Option<Object> currentTxnFirstOffset;

    public static ProducerStateEntry empty(long l) {
        return ProducerStateEntry$.MODULE$.empty(l);
    }

    public long producerId() {
        return this.producerId;
    }

    public Queue<BatchMetadata> batchMetadata() {
        return this.batchMetadata;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public void coordinatorEpoch_$eq(int x$1) {
        this.coordinatorEpoch = x$1;
    }

    public Option<Object> currentTxnFirstOffset() {
        return this.currentTxnFirstOffset;
    }

    public void currentTxnFirstOffset_$eq(Option<Object> x$1) {
        this.currentTxnFirstOffset = x$1;
    }

    public int firstSeq() {
        if (this.isEmpty()) {
            return -1;
        }
        return ((BatchMetadata)this.batchMetadata().front()).firstSeq();
    }

    public long firstOffset() {
        if (this.isEmpty()) {
            return -1L;
        }
        return ((BatchMetadata)this.batchMetadata().front()).firstOffset();
    }

    public int lastSeq() {
        if (this.isEmpty()) {
            return -1;
        }
        return ((BatchMetadata)this.batchMetadata().last()).lastSeq();
    }

    public long lastDataOffset() {
        if (this.isEmpty()) {
            return -1L;
        }
        return ((BatchMetadata)this.batchMetadata().last()).lastOffset();
    }

    public long lastTimestamp() {
        if (this.isEmpty()) {
            return -1L;
        }
        return ((BatchMetadata)this.batchMetadata().last()).timestamp();
    }

    public int lastOffsetDelta() {
        if (this.isEmpty()) {
            return 0;
        }
        return ((BatchMetadata)this.batchMetadata().last()).offsetDelta();
    }

    public boolean isEmpty() {
        return this.batchMetadata().isEmpty();
    }

    public void addBatch(short producerEpoch, int lastSeq, long lastOffset, int offsetDelta, long timestamp) {
        this.maybeUpdateEpoch(producerEpoch);
        this.addBatchMetadata(new BatchMetadata(lastSeq, lastOffset, offsetDelta, timestamp));
    }

    public boolean maybeUpdateEpoch(short producerEpoch) {
        if (this.producerEpoch() != producerEpoch) {
            this.batchMetadata().clear();
            this.producerEpoch_$eq(producerEpoch);
            return true;
        }
        return false;
    }

    private void addBatchMetadata(BatchMetadata batch) {
        if (this.batchMetadata().size() == ProducerStateEntry$.MODULE$.NumBatchesToRetain()) {
            this.batchMetadata().dequeue();
        }
        this.batchMetadata().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{batch}));
    }

    public void update(ProducerStateEntry nextEntry) {
        this.maybeUpdateEpoch(nextEntry.producerEpoch());
        while (nextEntry.batchMetadata().nonEmpty()) {
            this.addBatchMetadata((BatchMetadata)nextEntry.batchMetadata().dequeue());
        }
        this.coordinatorEpoch_$eq(nextEntry.coordinatorEpoch());
        this.currentTxnFirstOffset_$eq(nextEntry.currentTxnFirstOffset());
    }

    public Option<BatchMetadata> findDuplicateBatch(RecordBatch batch) {
        if (batch.producerEpoch() != this.producerEpoch()) {
            return None$.MODULE$;
        }
        return this.batchWithSequenceRange(batch.baseSequence(), batch.lastSequence());
    }

    public Option<BatchMetadata> batchWithSequenceRange(int firstSeq, int lastSeq) {
        return ((Queue)this.batchMetadata().filter((Function1 & java.io.Serializable & Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)ProducerStateEntry.$anonfun$batchWithSequenceRange$1(firstSeq, lastSeq, metadata)))).headOption();
    }

    public String toString() {
        return new StringBuilder(105).append("ProducerStateEntry(").append("producerId=").append(this.producerId()).append(", ").append("producerEpoch=").append(this.producerEpoch()).append(", ").append("currentTxnFirstOffset=").append(this.currentTxnFirstOffset()).append(", ").append("coordinatorEpoch=").append(this.coordinatorEpoch()).append(", ").append("batchMetadata=").append(this.batchMetadata()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$batchWithSequenceRange$1(int firstSeq$1, int lastSeq$1, BatchMetadata metadata) {
        return firstSeq$1 == metadata.firstSeq() && lastSeq$1 == metadata.lastSeq();
    }

    public ProducerStateEntry(long producerId, Queue<BatchMetadata> batchMetadata, short producerEpoch, int coordinatorEpoch, Option<Object> currentTxnFirstOffset) {
        this.producerId = producerId;
        this.batchMetadata = batchMetadata;
        this.producerEpoch = producerEpoch;
        this.coordinatorEpoch = coordinatorEpoch;
        this.currentTxnFirstOffset = currentTxnFirstOffset;
    }
}

