/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import java.net.InetAddress;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.PermissionType;
import kafka.security.auth.PermissionType$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.ResourceType;
import kafka.security.auth.ResourceType$;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class AuthorizerUtils$ {
    public static AuthorizerUtils$ MODULE$;
    private final String WildcardPrincipal;
    private final String WildcardHost;

    static {
        new AuthorizerUtils$();
    }

    public String WildcardPrincipal() {
        return this.WildcardPrincipal;
    }

    public String WildcardHost() {
        return this.WildcardHost;
    }

    public Either<ApiError, Tuple2<Resource, Acl>> convertToResourceAndAcl(AclBindingFilter filter) {
        Right right;
        Success success;
        if (Try$.MODULE$ == null) {
            throw null;
        }
        try {
            success = new Success((Object)ResourceType$.MODULE$.fromJava(filter.patternFilter().resourceType()));
        }
        catch (Throwable throwable) {
            Option option = NonFatal$.MODULE$.unapply(throwable);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable apply_e = (Throwable)option.get();
            Failure failure = new Failure(apply_e);
            success = failure;
        }
        Try try_ = success.flatMap((Function1 & Serializable & scala.Serializable)resourceType -> {
            Success success;
            if (Try$.MODULE$ == null) {
                throw null;
            }
            try {
                success = new Success((Object)AuthorizerUtils$.$anonfun$convertToResourceAndAcl$3(filter));
            }
            catch (Throwable throwable) {
                Option option = NonFatal$.MODULE$.unapply(throwable);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable apply_e = (Throwable)option.get();
                Failure failure = new Failure(apply_e);
                success = failure;
            }
            return success.flatMap((Function1 & Serializable & scala.Serializable)principal -> {
                Success success;
                if (Try$.MODULE$ == null) {
                    throw null;
                }
                try {
                    success = new Success((Object)Operation$.MODULE$.fromJava(filter.entryFilter().operation()));
                }
                catch (Throwable throwable) {
                    Option option = NonFatal$.MODULE$.unapply(throwable);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable apply_e = (Throwable)option.get();
                    Failure failure = new Failure(apply_e);
                    success = failure;
                }
                return success.flatMap((Function1 & Serializable & scala.Serializable)operation -> {
                    Success success;
                    if (Try$.MODULE$ == null) {
                        throw null;
                    }
                    try {
                        success = new Success((Object)PermissionType$.MODULE$.fromJava(filter.entryFilter().permissionType()));
                    }
                    catch (Throwable throwable) {
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable apply_e = (Throwable)option.get();
                        Failure failure = new Failure(apply_e);
                        success = failure;
                    }
                    return success.map((Function1 & Serializable & scala.Serializable)permissionType -> {
                        Resource resource = new Resource((ResourceType)resourceType, filter.patternFilter().name(), filter.patternFilter().patternType());
                        Acl acl = new Acl((KafkaPrincipal)principal, (PermissionType)permissionType, filter.entryFilter().host(), (Operation)operation);
                        return new Tuple3(permissionType, (Object)resource, (Object)acl);
                    }).map((Function1 & Serializable & scala.Serializable)x$1 -> {
                        if (x$1 == null) {
                            throw new MatchError(null);
                        }
                        Resource resource = (Resource)x$1._2();
                        Acl acl = (Acl)x$1._3();
                        Tuple2 tuple2 = new Tuple2((Object)resource, (Object)acl);
                        return tuple2;
                    });
                });
            });
        });
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            right = package$.MODULE$.Left().apply((Object)new ApiError(Errors.INVALID_REQUEST, throwable.getMessage()));
        } else if (try_ instanceof Success) {
            Tuple2 s = (Tuple2)((Success)try_).value();
            right = package$.MODULE$.Right().apply((Object)s);
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    public AclBinding convertToAclBinding(Resource resource, Acl acl) {
        ResourcePattern resourcePattern = new ResourcePattern(resource.resourceType().toJava(), resource.name(), resource.patternType());
        return new AclBinding(resourcePattern, this.convertToAccessControlEntry(acl));
    }

    public AccessControlEntry convertToAccessControlEntry(Acl acl) {
        return new AccessControlEntry(acl.principal().toString(), acl.host().toString(), acl.operation().toJava(), acl.permissionType().toJava());
    }

    public Acl convertToAcl(AccessControlEntry ace) {
        return new Acl(SecurityUtils.parseKafkaPrincipal((String)ace.principal()), PermissionType$.MODULE$.fromJava(ace.permissionType()), ace.host(), Operation$.MODULE$.fromJava(ace.operation()));
    }

    public Resource convertToResource(ResourcePattern resourcePattern) {
        return new Resource(ResourceType$.MODULE$.fromJava(resourcePattern.resourceType()), resourcePattern.name(), resourcePattern.patternType());
    }

    public void validateAclBinding(AclBinding aclBinding) {
        if (aclBinding.isUnknown()) {
            throw new IllegalArgumentException("ACL binding contains unknown elements");
        }
    }

    public Set<AclOperation> supportedOperations(org.apache.kafka.common.resource.ResourceType resourceType) {
        return (Set)ResourceType$.MODULE$.fromJava(resourceType).supportedOperations().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toJava(), Set$.MODULE$.canBuildFrom());
    }

    public boolean isClusterResource(String name) {
        return name.equals(Resource$.MODULE$.ClusterResourceName());
    }

    public AuthorizableRequestContext sessionToRequestContext(RequestChannel.Session session) {
        return new AuthorizableRequestContext(session){
            private final RequestChannel.Session session$1;

            public String clientId() {
                return "";
            }

            public int requestType() {
                return -1;
            }

            public String listenerName() {
                return "";
            }

            public InetAddress clientAddress() {
                return this.session$1.clientAddress();
            }

            public KafkaPrincipal principal() {
                return this.session$1.principal();
            }

            public SecurityProtocol securityProtocol() {
                return null;
            }

            public int correlationId() {
                return -1;
            }

            public int requestVersion() {
                return -1;
            }
            {
                this.session$1 = session$1;
            }
        };
    }

    public static final /* synthetic */ KafkaPrincipal $anonfun$convertToResourceAndAcl$3(AclBindingFilter filter$1) {
        return SecurityUtils.parseKafkaPrincipal((String)filter$1.entryFilter().principal());
    }

    private AuthorizerUtils$() {
        MODULE$ = this;
        this.WildcardPrincipal = "User:*";
        this.WildcardHost = "*";
    }
}

