/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import joptsimple.OptionSpec;
import kafka.common.MessageFormatter;
import kafka.tools.ConsoleConsumer;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class ConsoleConsumer$
implements Logging {
    public static ConsoleConsumer$ MODULE$;
    private int messageCount;
    private final CountDownLatch kafka$tools$ConsoleConsumer$$shutdownLatch;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConsoleConsumer$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int messageCount() {
        return this.messageCount;
    }

    public void messageCount_$eq(int x$1) {
        this.messageCount = x$1;
    }

    public CountDownLatch kafka$tools$ConsoleConsumer$$shutdownLatch() {
        return this.kafka$tools$ConsoleConsumer$$shutdownLatch;
    }

    public void main(String[] args) {
        ConsoleConsumer.ConsumerConfig conf = new ConsoleConsumer.ConsumerConfig(args);
        try {
            this.run(conf);
            return;
        }
        catch (AuthenticationException e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(this.msgWithLogIdent(ConsoleConsumer$.$anonfun$main$1()), (Throwable)e);
            }
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        catch (Throwable e) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(this.msgWithLogIdent(ConsoleConsumer$.$anonfun$main$3()), e);
            }
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    public void run(ConsoleConsumer.ConsumerConfig conf) {
        long timeoutMs = conf.timeoutMs() >= 0 ? (long)conf.timeoutMs() : Long.MAX_VALUE;
        KafkaConsumer consumer = new KafkaConsumer(this.consumerProps(conf), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        ConsoleConsumer.ConsumerWrapper consumerWrapper = conf.partitionArg().isDefined() ? new ConsoleConsumer.ConsumerWrapper((Option<String>)Option$.MODULE$.apply((Object)conf.topicArg()), conf.partitionArg(), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)conf.offsetArg())), (Option<String>)None$.MODULE$, (Consumer<byte[], byte[]>)consumer, timeoutMs) : new ConsoleConsumer.ConsumerWrapper((Option<String>)Option$.MODULE$.apply((Object)conf.topicArg()), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)Option$.MODULE$.apply((Object)conf.whitelistArg()), (Consumer<byte[], byte[]>)consumer, timeoutMs);
        this.addShutdownHook(consumerWrapper, conf);
        try {
            this.process(Predef$.MODULE$.int2Integer(conf.maxMessages()), conf.formatter(), consumerWrapper, System.out, conf.skipMessageOnError());
        }
        finally {
            consumerWrapper.cleanup();
            conf.formatter().close();
            this.reportRecordCount();
            this.kafka$tools$ConsoleConsumer$$shutdownLatch().countDown();
        }
    }

    public void addShutdownHook(ConsoleConsumer.ConsumerWrapper consumer, ConsoleConsumer.ConsumerConfig conf) {
        Runtime.getRuntime().addShutdownHook(new Thread(consumer, conf){
            private final ConsoleConsumer.ConsumerWrapper consumer$1;
            private final ConsoleConsumer.ConsumerConfig conf$1;

            public void run() {
                this.consumer$1.wakeup();
                ConsoleConsumer$.MODULE$.kafka$tools$ConsoleConsumer$$shutdownLatch().await();
                if (this.conf$1.enableSystestEventsLogging()) {
                    System.out.println("shutdown_complete");
                }
            }
            {
                this.consumer$1 = consumer$1;
                this.conf$1 = conf$1;
            }
        });
    }

    public void process(Integer maxMessages, MessageFormatter formatter, ConsoleConsumer.ConsumerWrapper consumer, PrintStream output, boolean skipMessageOnError) {
        while (this.messageCount() < Predef$.MODULE$.Integer2int(maxMessages) || BoxesRunTime.equalsNumObject((Number)maxMessages, (Object)BoxesRunTime.boxToInteger((int)-1))) {
            ConsumerRecord<byte[], byte[]> consumerRecord;
            try {
                consumerRecord = consumer.receive();
            }
            catch (WakeupException wakeupException) {
                if (this.logger().underlying().isTraceEnabled()) {
                    this.logger().underlying().trace(this.msgWithLogIdent(ConsoleConsumer$.$anonfun$process$1()));
                    return;
                }
                return;
            }
            catch (Throwable e) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(this.msgWithLogIdent(ConsoleConsumer$.$anonfun$process$2()), e);
                    return;
                }
                return;
            }
            ConsumerRecord<byte[], byte[]> msg = consumerRecord;
            this.messageCount_$eq(this.messageCount() + 1);
            try {
                formatter.writeTo((ConsumerRecord<byte[], byte[]>)new ConsumerRecord(msg.topic(), msg.partition(), msg.offset(), msg.timestamp(), msg.timestampType(), Predef$.MODULE$.long2Long(0L), 0, 0, msg.key(), msg.value(), msg.headers()), output);
            }
            catch (Throwable e) {
                if (skipMessageOnError) {
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(this.msgWithLogIdent(ConsoleConsumer$.$anonfun$process$4()), e);
                    }
                }
                throw e;
            }
            if (!this.checkErr(output, formatter)) continue;
            return;
        }
    }

    public void reportRecordCount() {
        System.err.println(new StringBuilder(30).append("Processed a total of ").append(this.messageCount()).append(" messages").toString());
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkErr(PrintStream output, MessageFormatter formatter) {
        void var3_3;
        boolean gotError = output.checkError();
        if (gotError) {
            System.err.println("Unable to write to standard out, closing consumer.");
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties consumerProps(ConsoleConsumer.ConsumerConfig config) {
        void var2_2;
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.consumerProps());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.extraConsumerProps());
        this.setAutoOffsetResetValue(config, props);
        props.put("bootstrap.servers", config.bootstrapServer());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "isolation.level", config.options(), config.isolationLevelOpt());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoOffsetResetValue(ConsoleConsumer.ConsumerConfig config, Properties props) {
        void var4_5;
        void var3_4;
        String string = "latest";
        String earliestConfigValue = "earliest";
        String latestConfigValue = string;
        void earliestConfigValue2 = var3_4;
        void latestConfigValue2 = var4_5;
        if (props.containsKey("auto.offset.reset")) {
            String autoResetOption = props.getProperty("auto.offset.reset");
            if (config.options().has((OptionSpec)config.resetBeginningOpt()) && !earliestConfigValue2.equals(autoResetOption)) {
                System.err.println(new StringBuilder(96).append("Can't simultaneously specify --from-beginning and 'auto.offset.reset=").append(autoResetOption).append("', ").append("please remove one option").toString());
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
        } else {
            void autoResetOption = config.options().has((OptionSpec)config.resetBeginningOpt()) ? earliestConfigValue2 : latestConfigValue2;
            props.put("auto.offset.reset", (Object)autoResetOption);
        }
    }

    public static final /* synthetic */ String $anonfun$main$1() {
        return "Authentication failed: terminating consumer process";
    }

    public static final /* synthetic */ String $anonfun$main$3() {
        return "Unknown error when running consumer: ";
    }

    public static final /* synthetic */ String $anonfun$process$1() {
        return "Caught WakeupException because consumer is shutdown, ignore and terminate.";
    }

    public static final /* synthetic */ String $anonfun$process$2() {
        return "Error processing message, terminating consumer process: ";
    }

    public static final /* synthetic */ String $anonfun$process$4() {
        return "Error processing message, skipping this message: ";
    }

    private ConsoleConsumer$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.messageCount = 0;
        this.kafka$tools$ConsoleConsumer$$shutdownLatch = new CountDownLatch(1);
    }
}

