/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import kafka.Kafka$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.Exit$;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u00114AAD\b\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)1\u0006\u0001C\u0001=!)\u0001\u0007\u0001C\u0001=!)Q\u0007\u0001C\u0001=!)A\t\u0001C\u0001=!)a\t\u0001C\u0001=!)\u0001\n\u0001C\u0001=!)!\n\u0001C\u0001=!)A\n\u0001C\u0001=!)a\n\u0001C\u0001=!)\u0001\u000b\u0001C\u0001#\")Q\f\u0001C\u0001=\nI1*\u00194lCR+7\u000f\u001e\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011aD\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002?A\u0011A\u0003I\u0005\u0003CU\u0011A!\u00168ji\"\u0012!a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nQA[;oSRT\u0011\u0001K\u0001\u0004_J<\u0017B\u0001\u0016&\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000e\u000b\u0002\u0004[A\u0011AEL\u0005\u0003_\u0015\u0012Q!\u00114uKJ\f!\u0004^3ti\u001e+GoS1gW\u0006\u001cuN\u001c4jO\u001a\u0013x.\\!sOND#\u0001\u0002\u001a\u0011\u0005\u0011\u001a\u0014B\u0001\u001b&\u0005\u0011!Vm\u001d;\u0002SQ,7\u000f^$fi.\u000bgm[1D_:4\u0017n\u001a$s_6\f%oZ:O_:\f%oZ:BiRCW-\u00128eQ\u0011)!g\u000e\u001d\u0002\u0011\u0015D\b/Z2uK\u0012\u001c\u0013!\u000f\t\u0003u\tk\u0011a\u000f\u0006\u0003yu\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0005yz\u0014AB2p[6|gN\u0003\u0002\u0011\u0001*\u0011\u0011iJ\u0001\u0007CB\f7\r[3\n\u0005\r[$A\u0004$bi\u0006dW\t_5u\u000bJ\u0014xN]\u0001&i\u0016\u001cHoR3u\u0017\u000647.Y\"p]\u001aLwM\u0012:p[\u0006\u0013xm\u001d(p]\u0006\u0013xm](oYfDCA\u0002\u001a8q\u0005iC/Z:u\u000f\u0016$8*\u00194lC\u000e{gNZ5h\rJ|W.\u0011:hg:{g.\u0011:hg\u0006#H\u000b[3CK\u001e<\u0017N\\4)\t\u001d\u0011t\u0007O\u0001\u0016i\u0016\u001cHoS1gW\u0006\u001c6\u000f\u001c)bgN<xN\u001d3tQ\tA!'\u0001\u0011uKN$8*\u00194lCN\u001bH\u000eU1tg^|'\u000fZ:XSRD7+_7c_2\u001c\bFA\u00053\u0003\u0005\"Xm\u001d;D_:tWm\u0019;j_:\u001cX*\u0019=SK\u0006,H\u000f['t\t\u00164\u0017-\u001e7uQ\tQ!'\u0001\u0012uKN$8i\u001c8oK\u000e$\u0018n\u001c8t\u001b\u0006D(+Z1vi\"l5/\u0012=qY&\u001c\u0017\u000e\u001e\u0015\u0003\u0017I\nA\u0003\u001d:fa\u0006\u0014X\rR3gCVdGoQ8oM&<G#\u0001*\u0011\u0005MSfB\u0001+Y!\t)V#D\u0001W\u0015\t9\u0016#\u0001\u0004=e>|GOP\u0005\u00033V\ta\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011,F\u0001\u000eaJ,\u0007/\u0019:f\u0007>tg-[4\u0015\u0005I{\u0006\"\u00021\u000e\u0001\u0004\t\u0017!\u00027j]\u0016\u001c\bc\u0001\u000bc%&\u00111-\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f")
public class KafkaTest {
    /*
     * WARNING - void declaration
     */
    @Before
    public void setUp() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(status, x$1) -> KafkaTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)status), x$1);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @After
    public void tearDown() {
        Exit$.MODULE$.resetExitProcedure();
    }

    @Test
    public void testGetKafkaConfigFromArgs() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config1 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assert.assertEquals((long)1L, (long)config1.brokerId());
        KafkaConfig config2 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=2"})));
        Assert.assertEquals((long)2L, (long)config2.brokerId());
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact"})));
        Assert.assertEquals((long)1L, (long)config3.brokerId());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"compact"}), (Object)config3.logCleanupPolicy());
        KafkaConfig config4 = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "log.cleanup.policy=compact,delete", "--override", "broker.id=2"})));
        Assert.assertEquals((long)2L, (long)config4.brokerId());
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"compact", "delete"}), (Object)config4.logCleanupPolicy());
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsAtTheEnd() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "broker.id=1", "broker.id=2"})));
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsOnly() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "broker.id=2"})));
    }

    @Test(expected=FatalExitError.class)
    public void testGetKafkaConfigFromArgsNonArgsAtTheBegging() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "broker.id=1", "--override", "broker.id=2"})));
    }

    @Test
    public void testKafkaSslPasswords() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", "ssl.keystore.password=keystore_password", "--override", "ssl.key.password=key_password", "--override", "ssl.truststore.password=truststore_password"})));
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assert.assertEquals((Object)"key_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assert.assertEquals((Object)"keystore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assert.assertEquals((Object)"truststore_password", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    @Test
    public void testKafkaSslPasswordsWithSymbols() {
        String password = "=!#-+!?*/\"'^%$=\\.,@:;=";
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringBuilder(22).append("ssl.keystore.password=").append(password).toString(), "--override", new StringBuilder(17).append("ssl.key.password=").append(password).toString(), "--override", new StringBuilder(24).append("ssl.truststore.password=").append(password).toString()})));
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).toString());
        Assert.assertEquals((Object)"[hidden]", (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).toString());
        Assert.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeystorePasswordProp()).value());
        Assert.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslKeyPasswordProp()).value());
        Assert.assertEquals((Object)password, (Object)config.getPassword(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    @Test
    public void testConnectionsMaxReauthMsDefault() {
        String propertiesFile = this.prepareDefaultConfig();
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile})));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    @Test
    public void testConnectionsMaxReauthMsExplicit() {
        String propertiesFile = this.prepareDefaultConfig();
        int expected = 3600000;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(Kafka$.MODULE$.getPropsFromArgs((String[])((Object[])new String[]{propertiesFile, "--override", new StringBuilder(47).append("sasl_ssl.oauthbearer.connections.max.reauth.ms=").append(expected).toString()})));
        Assert.assertEquals((long)expected, (long)BoxesRunTime.unboxToLong(config.valuesWithPrefixOverride("sasl_ssl.oauthbearer.").get("connections.max.reauth.ms")));
    }

    public String prepareDefaultConfig() {
        return this.prepareConfig((String[])((Object[])new String[]{"broker.id=1", "zookeeper.connect=somewhere"}));
    }

    public String prepareConfig(String[] lines) {
        String string;
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines));
            int foreach_len = foreach_this.length();
            for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
                String string2 = (String)foreach_this.apply(foreach_i);
                KafkaTest.$anonfun$prepareConfig$1(writer, string2);
            }
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int status, Option x$1) {
        throw new FatalExitError(status);
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public static final /* synthetic */ Object $anonfun$prepareConfig$1$adapted(OutputStream writer$1, String l) {
        KafkaTest.$anonfun$prepareConfig$1(writer$1, l);
        return BoxedUnit.UNIT;
    }
}

