/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.RackAwareMode;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.TopicCommand;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversable;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001A\u0002\u0013\u0005\u0011\u0007C\u0004A\u0001\u0001\u0007I\u0011A!\t\r!\u0003\u0001\u0015)\u00033\u0011\u001dI\u0005A1A\u0005\u0002)Caa\u0016\u0001!\u0002\u0013Y\u0005b\u0002-\u0001\u0005\u0004%\t!\u0017\u0005\u0007C\u0002\u0001\u000b\u0011\u0002.\t\u000b\t\u0004A\u0011I2\t\u000b5\u0004A\u0011A2\t\u000bI\u0004A\u0011A2\t\u000bQ\u0004A\u0011A2\t\u000bY\u0004A\u0011A2\t\u000ba\u0004A\u0011B=\t\u000bu\u0004A\u0011B2\t\u000by\u0004A\u0011B@\t\r\u0005E\u0002\u0001\"\u0001d\u0011\u0019\t)\u0004\u0001C\u0001G\"1\u0011\u0011\b\u0001\u0005\u0002\rDa!!\u0010\u0001\t\u0003\u0019\u0007BBA!\u0001\u0011\u00051\r\u0003\u0004\u0002F\u0001!\ta\u0019\u0005\u0007\u0003\u0013\u0002A\u0011A2\t\u000f\u00055\u0003\u0001\"\u0003\u0002P!I\u00111\u000f\u0001\u0012\u0002\u0013%\u0011Q\u000f\u0005\n\u0003\u0017\u0003\u0011\u0013!C\u0005\u0003\u001bCq!!\u0014\u0001\t\u0013\t\t\nC\u0004\u0002.\u0002!I!a,\t\r\u0005-\u0007\u0001\"\u0001d\u0011\u0019\ty\r\u0001C\u0001G\nyA)\u001a7fi\u0016$v\u000e]5d)\u0016\u001cHO\u0003\u0002\"E\u0005)\u0011\rZ7j]*\t1%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#BA\u0015#\u0003\tQ8.\u0003\u0002,Q\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0018\u0011\u0005=\u0002Q\"\u0001\u0011\u0002\u000fM,'O^3sgV\t!\u0007E\u00024qij\u0011\u0001\u000e\u0006\u0003kY\n!bY8mY\u0016\u001cG/[8o\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d5\u0005\r\u0019V-\u001d\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{\t\naa]3sm\u0016\u0014\u0018BA =\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003\u0005\u001a\u0003\"a\u0011#\u000e\u0003YJ!!\u0012\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b\u000f\u000e\t\t\u00111\u00013\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005IR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u+\u0005Y\u0005\u0003\u0002'P#Rk\u0011!\u0014\u0006\u0003\u001dR\n\u0011\"[7nkR\f'\r\\3\n\u0005Ak%aA'baB\u00111IU\u0005\u0003'Z\u00121!\u00138u!\raU+U\u0005\u0003-6\u0013A\u0001T5ti\u0006QR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uA\u0005iR\r\u001f9fGR,GMU3qY&\u001c\u0017MR;mY\u0006\u001b8/[4o[\u0016tG/F\u0001[!\u0011au*U.\u0011\u0005q{V\"A/\u000b\u0005y\u0013\u0013AC2p]R\u0014x\u000e\u001c7fe&\u0011\u0001-\u0018\u0002\u0012%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\u0018AH3ya\u0016\u001cG/\u001a3SKBd\u0017nY1Gk2d\u0017i]:jO:lWM\u001c;!\u0003!!X-\u0019:E_^tG#\u0001\")\u0005%)\u0007C\u00014l\u001b\u00059'B\u00015j\u0003\u0015QWO\\5u\u0015\u0005Q\u0017aA8sO&\u0011An\u001a\u0002\u0006\u0003\u001a$XM]\u0001$i\u0016\u001cH\u000fR3mKR,Gk\u001c9jG^KG\u000f[!mY\u0006c\u0017N^3SKBd\u0017nY1tQ\tQq\u000e\u0005\u0002ga&\u0011\u0011o\u001a\u0002\u0005)\u0016\u001cH/\u0001\u0016uKN$(+Z:v[\u0016$U\r\\3uKR{\u0007/[2XSRD'+Z2pm\u0016\u0014X\r\u001a$pY2|w/\u001a:)\u0005-y\u0017!\u000b;fgR\u0014Vm];nK\u0012+G.\u001a;f)>\u0004\u0018nY(o\u0007>tGO]8mY\u0016\u0014h)Y5m_Z,'\u000f\u000b\u0002\r_\u0006QC/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8u\tV\u0014\u0018N\\4EK2,G/\u001a+pa&\u001c\u0007FA\u0007p\u000359W\r^\"p]R\u0014x\u000e\u001c7feR\t!\u0010\u0005\u0003Dwj\n\u0016B\u0001?7\u0005\u0019!V\u000f\u001d7fe\u00051RM\\:ve\u0016\u001cuN\u001c;s_2dWM]#ySN$8/\u0001\u000fhKR\fE\u000e\u001c*fa2L7-Y:Ge>l\u0017i]:jO:lWM\u001c;\u0015\r\u0005\u0005\u0011QDA\u0014!\u0019\t\u0019!!\u0005\u0002\u00189!\u0011QAA\u0007!\r\t9AN\u0007\u0003\u0003\u0013Q1!a\u0003%\u0003\u0019a$o\\8u}%\u0019\u0011q\u0002\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019\"!\u0006\u0003\u0007M+GOC\u0002\u0002\u0010Y\u00022\u0001XA\r\u0013\r\tY\"\u0018\u0002\u0014!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\u0005\b\u0003?\u0001\u0002\u0019AA\u0011\u0003\u0015!x\u000e]5d!\u0011\t\u0019!a\t\n\t\u0005\u0015\u0012Q\u0003\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0005%\u0002\u00031\u0001\u0002,\u0005Q\u0011m]:jO:lWM\u001c;\u0011\u000f\u0005\r\u0011QF)\u00020%\u0019\u0001+!\u0006\u0011\u0007MB\u0014+A\u0016uKN$\u0018J\\2sK\u0006\u001cX\rU1si&$\u0018n\u001c8D_VtG\u000fR;sS:<G)\u001a7fi\u0016$v\u000e]5dQ\t\tr.A\u0011uKN$H)\u001a7fi\u0016$v\u000e]5d\tV\u0014\u0018N\\4BI\u0012\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\u0013_\u0006\tC/Z:u\u0003\u0012$\u0007+\u0019:uSRLwN\u001c#ve&tw\rR3mKR,Gk\u001c9jG\"\u00121c\\\u0001\u001fi\u0016\u001cHOU3de\u0016\fG/\u001a+pa&\u001c\u0017I\u001a;fe\u0012+G.\u001a;j_:D#\u0001F8\u00025Q,7\u000f\u001e#fY\u0016$XMT8o\u000bbL7\u000f^5oOR{\u0007/[2)\u0005Uy\u0017A\u0007;fgR$U\r\\3uKR{\u0007/[2XSRD7\t\\3b]\u0016\u0014\bF\u0001\fp\u0003\u0015\"Xm\u001d;EK2,G/\u001a+pa&\u001c\u0017\t\u001c:fC\u0012LX*\u0019:lK\u0012\f5\u000fR3mKR,G\r\u000b\u0002\u0018_\u0006I2M]3bi\u0016$Vm\u001d;U_BL7-\u00118e\u00072,8\u000f^3s)\u001d\u0011\u0014\u0011KA*\u0003;Bq!a\b\u0019\u0001\u0004\t\t\u0003C\u0005\u0002Va\u0001\n\u00111\u0001\u0002X\u0005\u0011B-\u001a7fi\u0016$v\u000e]5d\u000b:\f'\r\\3e!\r\u0019\u0015\u0011L\u0005\u0004\u000372$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003?B\u0002\u0013!a\u0001\u0003C\n\u0011C]3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u!\u001d\t\u0019!!\fR\u0003G\u0002R!!\u001a\u0002pEsA!a\u001a\u0002l9!\u0011qAA5\u0013\u00059\u0014bAA7m\u00059\u0001/Y2lC\u001e,\u0017b\u0001,\u0002r)\u0019\u0011Q\u000e\u001c\u0002G\r\u0014X-\u0019;f)\u0016\u001cH\u000fV8qS\u000e\fe\u000eZ\"mkN$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u000f\u0016\u0005\u0003/\nIh\u000b\u0002\u0002|A!\u0011QPAD\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015!C;oG\",7m[3e\u0015\r\t)IN\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAE\u0003\u007f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\r\u001a'/Z1uKR+7\u000f\u001e+pa&\u001c\u0017I\u001c3DYV\u001cH/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a$+\t\u0005\u0005\u0014\u0011\u0010\u000b\be\u0005M\u0015QSAV\u0011\u001d\tyb\u0007a\u0001\u0003CAq!a&\u001c\u0001\u0004\tI*A\u0007ce>\\WM]\"p]\u001aLwm\u001d\t\u0005ga\nY\n\u0005\u0003\u0002\u001e\u0006\u001dVBAAP\u0015\u0011\t\t+a)\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003K\u000bAA[1wC&!\u0011\u0011VAP\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003?Z\u0002\u0019AA1\u0003%9(/\u001b;f\tV\u00048\u000f\u0006\u0005\u00022\u0006U\u0016\u0011XA_!\u0011\u0019\u0004(a-\u0011\t\r[\u0018+\u0015\u0005\u0007\u0003oc\u0002\u0019A)\u0002\u000f9,XnS3zg\"1\u00111\u0018\u000fA\u0002E\u000bqA\\;n\tV\u00048\u000fC\u0004\u0002@r\u0001\r!!1\u0002\u00071|w\r\u0005\u0003\u0002D\u0006\u001dWBAAc\u0015\r\tyLI\u0005\u0005\u0003\u0013\f)MA\u0002M_\u001e\fa\u0003^3ti\u0012K7/\u00192mK\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u0015\u0003;=\f\u0011\u0005^3ti\u0012+G.\u001a;j]\u001e\u0004\u0016M\u001d;jC2d\u0017\u0010R3mKR,G\rV8qS\u000eD#AH8")
public class DeleteTopicTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment;
    private final scala.collection.immutable.Map<Object, ReplicaAssignment> expectedReplicaFullAssignment;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment() {
        return this.expectedReplicaAssignment;
    }

    public scala.collection.immutable.Map<Object, ReplicaAssignment> expectedReplicaFullAssignment() {
        return this.expectedReplicaFullAssignment;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$1(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$2(this, follower, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$6(this, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$7(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        String topic = new TopicPartition("test", 0).topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option option = this.zkClient().getControllerId();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        }
        int controllerId = BoxesRunTime.unboxToInt((Object)getOrElse_this.get());
        KafkaServer controller = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$2(controllerId, s)))).head();
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$3(leaderIdOpt, controllerId, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        controller.shutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$4(this, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        controller.startup();
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        void $minus$greater$extension_$this;
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$3(this, s)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$5(topicPartition$2, x$3)))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$6(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        Seq oldAssignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, 0));
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        KafkaZkClient x$3 = this.zkClient();
        None$ x$4 = None$.MODULE$;
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)newReplicas);
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        AdminZkClient x$6 = this.adminZkClient();
        Map x$7 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(x$3, (Option)x$4, (Map)x$5, x$7, x$6);
        Assert.assertTrue((String)"Partition reassignment should fail for [test,0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$8(this, topicPartition, newReplicas)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$10(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Option option = this.zkClient().getControllerId();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        }
        int controllerId = BoxesRunTime.unboxToInt((Object)getOrElse_this.get());
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$12(controllerId, s)))).head();
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$13(controller, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$14(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Seq assignedReplicas = this.zkClient().getReplicasForPartition(new TopicPartition(topic, 0));
        Assert.assertEquals((String)"Partition should not be reassigned to 0, 1, 2", (Object)oldAssignedReplicas, (Object)assignedReplicas);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, (Seq<KafkaServer>)servers);
    }

    private Tuple2<KafkaServer, Object> getController() {
        Option option = this.zkClient().getControllerId();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail("Controller doesn't exist", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        }
        int controllerId = BoxesRunTime.unboxToInt((Object)getOrElse_this.get());
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$getController$2(controllerId, s))).get();
        return new Tuple2((Object)controller, (Object)BoxesRunTime.boxToInteger((int)controllerId));
    }

    /*
     * WARNING - void declaration
     */
    private void ensureControllerExists() {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$ensureControllerExists$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$ensureControllerExists$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    private scala.collection.immutable.Set<PartitionAndReplica> getAllReplicasFromAssignment(String topic, scala.collection.immutable.Map<Object, Seq<Object>> assignment) {
        return ((TraversableOnce)assignment.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            Seq seq = (Seq)((Seq)x0$1._2()).map((Function1 & Serializable & scala.Serializable)r -> DeleteTopicTest.$anonfun$getAllReplicasFromAssignment$2(topic, partition, BoxesRunTime.unboxToInt((Object)r)), Seq$.MODULE$.canBuildFrom());
            return seq;
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIncreasePartitionCountDuringDeleteTopic() {
        void var9_12;
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$3(this, s)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$5(topicPartition$3, x$4)))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$6(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(topicPartition);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        this.adminZkClient().deleteTopic(topic);
        this.ensureControllerExists();
        Tuple2<KafkaServer, Object> tuple2 = this.getController();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaServer controller = (KafkaServer)tuple2._1();
        int n = tuple2._2$mcI$sp();
        scala.collection.immutable.Set<PartitionAndReplica> allReplicasForTopic = this.getAllReplicasFromAssignment(topic, this.expectedReplicaAssignment());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$8((KafkaServer)var9_12, topic, allReplicasForTopic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$9(topic), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        TopicCommand.TopicCommandOptions topicCommandOptions = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--zookeeper", this.zkConnect(), "--alter", "--topic", topic, "--partitions", "2"}));
        new TopicCommand.ZookeeperTopicService(this.zkClient()).alterTopic(topicCommandOptions);
        var9_12.shutdown();
        this.ensureControllerExists();
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$10(this, n)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testIncreasePartitionCountDuringDeleteTopic$11(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        follower.startup();
        var9_12.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, (Seq<KafkaServer>)servers);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteTopicDuringAddPartition() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$1(leaderIdOpt, x$7)))).last();
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$1 = qual$1.getBrokerMetadatas$default$1();
        Option x$2 = qual$1.getBrokerMetadatas$default$2();
        Seq brokers = qual$1.getBrokerMetadatas(x$1, x$2);
        follower.shutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$2(this, follower)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$3(follower), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        AdminZkClient qual$2 = this.adminZkClient();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.expectedReplicaFullAssignment();
        int x$6 = 2;
        Tuple2[] tuple2Array = new Tuple2[2];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Some x$72 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        boolean x$8 = qual$2.addPartitions$default$6();
        qual$2.addPartitions(topic, x$4, brokers, x$6, (Option)x$72, x$8);
        this.adminZkClient().deleteTopic(topic);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$4(this, newPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$6(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddPartitionDuringDeleteTopic() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        this.zkClient().createTopLevelPaths();
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$1 = qual$1.getBrokerMetadatas$default$1();
        Option x$2 = qual$1.getBrokerMetadatas$default$2();
        Seq brokers = qual$1.getBrokerMetadatas(x$1, x$2);
        this.adminZkClient().deleteTopic(topic);
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminZkClient qual$2 = this.adminZkClient();
        scala.collection.immutable.Map<Object, ReplicaAssignment> x$4 = this.expectedReplicaFullAssignment();
        int x$6 = 2;
        Tuple2[] tuple2Array = new Tuple2[2];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Some x$7 = new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)));
        boolean x$8 = qual$2.addPartitions$default$6();
        qual$2.addPartitions(topic, x$4, brokers, x$6, (Option)x$7, x$8);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testAddPartitionDuringDeleteTopic$1(newPartition, x$9))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecreateTopicAfterDeletion() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic(topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$1(this, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteNonExistingTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic("test2");
            throw Assertions$.MODULE$.fail("Expected UnknownTopicOrPartitionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test2", 1, this.servers());
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$1(this, topicPartition)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
            Assert.assertTrue((String)"Topic test mistakenly deleted", (boolean)this.zkClient().topicExists(topic));
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            return;
        }
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        this.servers_$eq(this.createTestTopicAndCluster(topic, brokerConfigs, this.expectedReplicaAssignment()));
        KafkaServer server = (KafkaServer)this.servers().head();
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Log log = (Log)qual$1.getLog(topicPartition, x$2).get();
        this.writeDups(100, 3, log);
        LogCleaner qual$2 = server.logManager().cleaner();
        TopicPartition x$3 = new TopicPartition(topicName, 0);
        long x$4 = 0L;
        long x$5 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$3, x$4, x$5);
        this.adminZkClient().deleteTopic("test");
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "test", 1, this.servers());
    }

    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        String topic = new TopicPartition("test", 0).topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2(), this.createTestTopicAndCluster$default$3()));
        try {
            this.adminZkClient().deleteTopic(topic);
            this.adminZkClient().deleteTopic(topic);
            throw Assertions$.MODULE$.fail("Expected TopicAlreadyMarkedForDeletionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
        }
        catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 1, this.servers());
            return;
        }
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, boolean deleteTopicEnabled, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)x$12 -> x$12.setProperty("delete.topic.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)deleteTopicEnabled)).toString()));
        return this.createTestTopicAndCluster(topic, brokerConfigs, replicaAssignment);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs, scala.collection.immutable.Map<Object, List<Object>> replicaAssignment) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)this.expectedReplicaAssignment(), (Seq<KafkaServer>)servers);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!servers.forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$createTestTopicAndCluster$4(topicPartition$6, x$13)))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$createTestTopicAndCluster$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        return servers;
    }

    private boolean createTestTopicAndCluster$default$2() {
        return true;
    }

    private scala.collection.immutable.Map<Object, List<Object>> createTestTopicAndCluster$default$3() {
        return this.expectedReplicaAssignment();
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log) {
        IntRef counter = IntRef.create((int)0);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return (Seq)RichInt$.MODULE$.until$extension0(n, numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> DeleteTopicTest.$anonfun$writeDups$1(numKeys, counter, log, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDisableDeleteTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, false, this.createTestTopicAndCluster$default$3()));
        this.adminZkClient().deleteTopic("test");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDisableDeleteTopic$1(this, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testDisableDeleteTopic$2(topic), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDisableDeleteTopic$3(topicPartition, x$14))));
        Assert.assertTrue((String)"Topic path disappeared", (boolean)this.zkClient().topicExists(topic));
        Option leaderIdOpt = this.zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletingPartiallyDeletedTopic() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2[] tuple2Array = new Tuple2[2];
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, true, (scala.collection.immutable.Map<Object, List<Object>>)replicaAssignment));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.shutdown();
            return BoxedUnit.UNIT;
        });
        KafkaZkClient qual$1 = this.zkClient();
        String x$1 = TopicPartitionZNode$.MODULE$.path(new TopicPartition(topic, 0));
        int x$2 = qual$1.deleteRecursive$default$2();
        qual$1.deleteRecursive(x$1, x$2);
        this.adminZkClient().deleteTopic(topic);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            x$16.startup();
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), topic, 2, this.servers());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$1(Option leaderIdOpt$1, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$1.get());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$3(KafkaServer follower$1, KafkaServer s) {
        return s.config().brokerId() != follower$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$4(TopicPartition topicPartition$1, KafkaServer x$2) {
        LogManager qual$1 = x$2.getLogManager();
        boolean x$22 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$1, x$22).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$2(DeleteTopicTest $this, KafkaServer follower$1, TopicPartition topicPartition$1) {
        return ((IterableLike)$this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$3(follower$1, s)))).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$4(topicPartition$1, x$2)));
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicWithRecoveredFollower$5() {
        return "Replicas 0,1 have not deleted log.";
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$6(DeleteTopicTest $this, String topic$1) {
        return $this.zkClient().isTopicMarkedForDeletion(topic$1);
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicWithRecoveredFollower$7() {
        return "Admin path /admin/delete_topics/test path deleted even when a follower replica is down";
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$2(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$3(Option leaderIdOpt$2, int controllerId$1, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$2.get()) && s.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$4(DeleteTopicTest $this, String topic$2) {
        return $this.zkClient().isTopicMarkedForDeletion(topic$2);
    }

    public static final /* synthetic */ String $anonfun$testResumeDeleteTopicOnControllerFailover$5() {
        return "Admin path /admin/delete_topics/test path deleted even when a replica is down";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$3(DeleteTopicTest $this, KafkaServer s) {
        return ((LinearSeqOptimized)$this.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$5(TopicPartition topicPartition$2, KafkaServer x$3) {
        LogManager qual$1 = x$3.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$2, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentDuringDeleteTopic$6() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$7(Option leaderIdOpt$3, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$3.get());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$8(DeleteTopicTest $this, TopicPartition topicPartition$2, Seq newReplicas$1) {
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition$2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)newReplicas$1);
        Object object2 = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded($this.zkClient(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).getOrElse((Object)topicPartition$2, (Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new StringBuilder(38).append("Failed to get reassignment status for ").append(topicPartition$2).toString(), new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141)));
        ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
        return !(object2 != null ? !object2.equals(reassignmentFailed$) : reassignmentFailed$ != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentDuringDeleteTopic$10() {
        return "Partition reassignment shouldn't complete.";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$12(int controllerId$2, KafkaServer s) {
        return s.config().brokerId() == controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$13(KafkaServer controller$1, TopicPartition topicPartition$2) {
        return !controller$1.kafkaController().controllerContext().partitionsBeingReassigned().contains((Object)topicPartition$2);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentDuringDeleteTopic$14() {
        return "Partition should be removed from partitionsBeingReassigned.";
    }

    public static final /* synthetic */ boolean $anonfun$getController$2(int controllerId$3, KafkaServer s) {
        return s.config().brokerId() == controllerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$ensureControllerExists$1(DeleteTopicTest $this) {
        try {
            $this.getController();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$ensureControllerExists$2() {
        return "Controller should eventually exist";
    }

    public static final /* synthetic */ PartitionAndReplica $anonfun$getAllReplicasFromAssignment$2(String topic$3, int partition$1, int r) {
        return new PartitionAndReplica(new TopicPartition(topic$3, partition$1), r);
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$3(DeleteTopicTest $this, KafkaServer s) {
        return ((LinearSeqOptimized)$this.expectedReplicaAssignment().apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$5(TopicPartition topicPartition$3, KafkaServer x$4) {
        LogManager qual$1 = x$4.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$3, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$6() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$7(Option leaderIdOpt$4, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$4.get());
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$8(KafkaServer controller$2, String topic$4, scala.collection.immutable.Set allReplicasForTopic$1) {
        Set replicasInDeletionSuccessful = controller$2.kafkaController().controllerContext().replicasInState(topic$4, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Set offlineReplicas = controller$2.kafkaController().controllerContext().replicasInState(topic$4, (ReplicaState)OfflineReplica$.MODULE$);
        scala.collection.immutable.Set set = allReplicasForTopic$1;
        Set set2 = replicasInDeletionSuccessful.union((GenSet)offlineReplicas);
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$9(String topic$4) {
        return new StringBuilder(95).append("Not all replicas for topic ").append(topic$4).append(" are in states of either ReplicaDeletionSuccessful or OfflineReplica").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testIncreasePartitionCountDuringDeleteTopic$10(DeleteTopicTest $this, int previousControllerId$1) {
        Tuple2<KafkaServer, Object> tuple2 = $this.getController();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaServer cfr_ignored_0 = (KafkaServer)tuple2._1();
        int n = tuple2._2$mcI$sp();
        return n != previousControllerId$1;
    }

    public static final /* synthetic */ String $anonfun$testIncreasePartitionCountDuringDeleteTopic$11() {
        return "The new controller should not have the failed controller id";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$1(Option leaderIdOpt$5, KafkaServer x$7) {
        return x$7.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$5.get());
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$2(DeleteTopicTest $this, KafkaServer follower$2) {
        return $this.zkClient().getBroker(follower$2.config().brokerId()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicDuringAddPartition$3(KafkaServer follower$2) {
        return new StringBuilder(33).append("Follower ").append(follower$2.config().brokerId()).append(" was not removed from ZK").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$5(TopicPartition newPartition$1, KafkaServer x$8) {
        LogManager qual$3 = x$8.getLogManager();
        boolean x$10 = qual$3.getLog$default$2();
        return qual$3.getLog(newPartition$1, x$10).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$4(DeleteTopicTest $this, TopicPartition newPartition$1) {
        return $this.servers().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$5(newPartition$1, x$8)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicDuringAddPartition$6() {
        return "Replica logs not for new partition [test,1] not deleted after delete topic is complete.";
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitionDuringDeleteTopic$1(TopicPartition newPartition$2, KafkaServer x$9) {
        LogManager qual$3 = x$9.getLogManager();
        boolean x$10 = qual$3.getLog$default$2();
        return qual$3.getLog(newPartition$2, x$10).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$2(TopicPartition topicPartition$4, KafkaServer x$10) {
        LogManager qual$1 = x$10.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$4, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$1(DeleteTopicTest $this, TopicPartition topicPartition$4) {
        return $this.servers().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$2(topicPartition$4, x$10)));
    }

    public static final /* synthetic */ String $anonfun$testRecreateTopicAfterDeletion$3() {
        return "Replicas for topic test not created.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$2(TopicPartition topicPartition$5, KafkaServer x$11) {
        LogManager qual$1 = x$11.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$5, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$1(DeleteTopicTest $this, TopicPartition topicPartition$5) {
        return $this.servers().forall((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$2(topicPartition$5, x$11)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteNonExistingTopic$3() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$4(TopicPartition topicPartition$6, KafkaServer x$13) {
        LogManager qual$1 = x$13.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$6, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTestTopicAndCluster$5() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(IntRef counter$1, Log log$1, int key) {
        int count = counter$1.elem;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)counter$1.elem)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
        ++counter$1.elem;
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDups$1(int numKeys$1, IntRef counter$1, Log log$1, int _) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(n, numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> DeleteTopicTest.$anonfun$writeDups$2(counter$1, log$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$1(DeleteTopicTest $this, String topic$5) {
        return !$this.zkClient().isTopicMarkedForDeletion(topic$5);
    }

    public static final /* synthetic */ String $anonfun$testDisableDeleteTopic$2(String topic$5) {
        String string = "Admin path /admin/delete_topics/%s path not deleted even if deleteTopic is disabled";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic$5}));
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$3(TopicPartition topicPartition$7, KafkaServer x$14) {
        LogManager qual$1 = x$14.getLogManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition$7, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeletingPartiallyDeletedTopic$4(KafkaServer x$17) {
        return x$17.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testDeletingPartiallyDeletedTopic$3(DeleteTopicTest $this) {
        return $this.servers().exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeletingPartiallyDeletedTopic$4(x$17)));
    }

    public static final /* synthetic */ String $anonfun$testDeletingPartiallyDeletedTopic$5() {
        return "No controller is elected";
    }

    /*
     * WARNING - void declaration
     */
    public DeleteTopicTest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.expectedReplicaFullAssignment = this.expectedReplicaAssignment().mapValues((Function1 & Serializable & scala.Serializable)x$1 -> new ReplicaAssignment((Seq)x$1, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$)).toMap(Predef$.MODULE$.$conforms());
    }
}

