/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.AbstractCoordinatorConcurrencyTest;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.log.Log;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r]f\u0001\u0002.\\\u0001\tDa\u0001 \u0001\u0005\u0002\u00055\u0005\"CAI\u0001\t\u0007I\u0011BAJ\u0011!\tY\n\u0001Q\u0001\n\u0005U\u0005\"CAO\u0001\t\u0007I\u0011BAJ\u0011!\ty\n\u0001Q\u0001\n\u0005U\u0005\"CAQ\u0001\t\u0007I\u0011BAJ\u0011!\t\u0019\u000b\u0001Q\u0001\n\u0005U\u0005\"CAS\u0001\t\u0007I\u0011BAT\u0011!\ty\u000b\u0001Q\u0001\n\u0005%\u0006bCAY\u0001\u0001\u0007\t\u0019!C\u0005\u0003gC1\"a/\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002>\"Y\u0011\u0011\u0019\u0001A\u0002\u0003\u0005\u000b\u0015BA[\u0011-\t\u0019\r\u0001a\u0001\u0002\u0004%I!!2\t\u0017\u00055\u0007\u00011AA\u0002\u0013%\u0011q\u001a\u0005\f\u0003'\u0004\u0001\u0019!A!B\u0013\t9\rC\u0006\u0002V\u0002\u0001\r\u00111A\u0005\n\u0005]\u0007bCAp\u0001\u0001\u0007\t\u0019!C\u0005\u0003CD1\"!:\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002Z\"I\u0011q\u001d\u0001C\u0002\u0013%\u0011\u0011\u001e\u0005\t\u0005\u007f\u0002\u0001\u0015!\u0003\u0002l\"I!\u0011\u0011\u0001C\u0002\u0013%!1\u0011\u0005\t\u0005#\u0003\u0001\u0015!\u0003\u0003\u0006\"I!1\u0013\u0001C\u0002\u0013%!Q\u0013\u0005\t\u0005_\u0003\u0001\u0015!\u0003\u0003\u0018\"9!\u0011\u0017\u0001\u0005B\tM\u0006b\u0002Bb\u0001\u0011\u0005#1\u0017\u0005\b\u0005\u001b\u0004A\u0011\u0001BZ\u0011\u001d\u00119\u000e\u0001C\u0001\u0005gCqAa7\u0001\t\u0003\u0011\u0019\fC\u0004\u0003`\u0002!\tAa-\t\u000f\t\r\b\u0001\"\u0011\u00034\"9!Q\u001d\u0001\u0005\n\t\u001d\bb\u0002B\u007f\u0001\u0011%!q \u0005\b\u0007\u000f\u0001A\u0011BB\u0005\u0011\u001d\u0019I\u0002\u0001C\u0005\u00077Aqaa\n\u0001\t\u0013\u0019I\u0003C\u0004\u0004.\u0001!Iaa\f\u0007\u000f\u0005u\b!!\u0001\u0002\u0000\"1AP\nC\u0001\u0005\u0013A\u0011Ba\t'\u0001\u0004%\tA!\n\t\u0013\t5b\u00051A\u0005\u0002\t=\u0002\u0002\u0003B\u001aM\u0001\u0006KAa\n\t\u000f\t]b\u0005\"\u0001\u0003:\u001911Q\u0007\u0001\u0001\u0007oAa\u0001 \u0017\u0005\u0002\rm\u0002bBB Y\u0011\u00053\u0011\t\u0005\b\u0007\u000bbC\u0011IB$\r\u0019\u0019Y\u0005\u0001\u0001\u0004N!Q1\u0011\u000b\u0019\u0003\u0002\u0003\u0006Iaa\u0015\t\rq\u0004D\u0011AB/\u0011\u001d\u0019y\u0004\rC!\u0007GBqa!\u00121\t\u0003\u001a9G\u0002\u0004\u0004l\u0001\u00011Q\u000e\u0005\u0007yV\"\taa\u001c\t\u000f\r}R\u0007\"\u0011\u0004t!91QI\u001b\u0005B\r]\u0004bBB>k\u0011%1Q\u0010\u0004\u0007\u0007\u001b\u0003\u0001aa$\t\u0015\rE%H!A!\u0002\u0013\t)\n\u0003\u0004}u\u0011\u000511\u0013\u0005\b\u0007\u007fQD\u0011\tBZ\u0011\u001d\u0019IJ\u000fC!\u0005g3aaa'\u0001\u0001\ru\u0005BCBI\u007f\t\u0005\t\u0015!\u0003\u0002\u0016\"1Ap\u0010C\u0001\u0007?C\u0011b!*@\u0005\u0004%\taa*\t\u0011\r%v\b)A\u0005\u0005;Cqaa\u0010@\t\u0003\u0012\u0019\fC\u0004\u0004\u001a~\"\tEa-\u0007\r\r-\u0006\u0001ABW\u0011)\u0019yK\u0012B\u0001B\u0003%1\u0011\u0001\u0005\u0007y\u001a#\ta!-\t\u000f\r}b\t\"\u0011\u00034\"91\u0011\u0014$\u0005B\tMv!\u0002:\\\u0011\u0003\u0019h!\u0002.\\\u0011\u0003)\b\"\u0002?M\t\u0003ih\u0001\u0002@M\u0001}D!\"a\u0004O\u0005\u000b\u0007I\u0011AA\t\u0011)\t\u0019C\u0014B\u0001B\u0003%\u00111\u0003\u0005\u000b\u0003Kq%\u0011!Q\u0001\n\u0005\u001d\u0002BCA\u0017\u001d\n\u0005\t\u0015!\u0003\u00020!1AP\u0014C\u0001\u0003\u0013B\u0011\"!\u0016O\u0005\u0004%\t!a\u0016\t\u0011\u0005\u0015d\n)A\u0005\u00033B\u0011\"a\u001aO\u0001\u0004%\t!!\u001b\t\u0013\u0005Ed\n1A\u0005\u0002\u0005M\u0004\u0002CA@\u001d\u0002\u0006K!a\u001b\t\u000f\u0005%e\n\"\u0011\u0002\f\n)CK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'oQ8oGV\u0014(/\u001a8dsR+7\u000f\u001e\u0006\u00039v\u000b1\u0002\u001e:b]N\f7\r^5p]*\u0011alX\u0001\fG>|'\u000fZ5oCR|'OC\u0001a\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A2\u0011\u0007\u0011,w-D\u0001^\u0013\t1WL\u0001\u0012BEN$(/Y2u\u0007>|'\u000fZ5oCR|'oQ8oGV\u0014(/\u001a8dsR+7\u000f\u001e\t\u0003Q:s!![&\u000f\u0005)\fhBA6q\u001d\taw.D\u0001n\u0015\tq\u0017-\u0001\u0004=e>|GOP\u0005\u0002A&\u0011alX\u0005\u00039v\u000bQ\u0005\u0016:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\"p]\u000e,(O]3oGf$Vm\u001d;\u0011\u0005QdU\"A.\u0014\u000513\bCA<{\u001b\u0005A(\"A=\u0002\u000bM\u001c\u0017\r\\1\n\u0005mD(AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002g\nYAK]1og\u0006\u001cG/[8o'\u0011qe/!\u0001\u0011\t\u0005\r\u0011\u0011\u0002\b\u0004U\u0006\u0015\u0011bAA\u0004;\u0006\u0011\u0013IY:ue\u0006\u001cGoQ8pe\u0012Lg.\u0019;pe\u000e{gnY;se\u0016t7-\u001f+fgRLA!a\u0003\u0002\u000e\t\t2i\\8sI&t\u0017\r^8s\u001b\u0016l'-\u001a:\u000b\u0007\u0005\u001dQ,A\bue\u0006t7/Y2uS>t\u0017\r\\%e+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005ua\u0002BA\f\u00033\u0001\"\u0001\u001c=\n\u0007\u0005m\u00010\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\t\tC\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037A\u0018\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u00133!\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\t\u0004o\u0006%\u0012bAA\u0016q\n!Aj\u001c8h\u0003\u0011!\u0018.\\3\u0011\t\u0005E\u0012QI\u0007\u0003\u0003gQA!!\u000e\u00028\u0005)Q\u000f^5mg*!\u0011\u0011HA\u001e\u0003\u0019\u0019w.\\7p]*\u0019\u0001-!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\r\u0013aA8sO&!\u0011qIA\u001a\u0005!iunY6US6,G\u0003CA&\u0003\u001f\n\t&a\u0015\u0011\u0007\u00055c*D\u0001M\u0011\u001d\tya\u0015a\u0001\u0003'Aq!!\nT\u0001\u0004\t9\u0003C\u0004\u0002.M\u0003\r!a\f\u0002%QDh.T3tg\u0006<WmS3z\u0005f$Xm]\u000b\u0003\u00033\u0002Ra^A.\u0003?J1!!\u0018y\u0005\u0015\t%O]1z!\r9\u0018\u0011M\u0005\u0004\u0003GB(\u0001\u0002\"zi\u0016\f1\u0003\u001e=o\u001b\u0016\u001c8/Y4f\u0017\u0016L()\u001f;fg\u0002\nQ!\u001a8eK\u0012,\"!a\u001b\u0011\u0007]\fi'C\u0002\u0002pa\u0014qAQ8pY\u0016\fg.A\u0005f]\u0012,Gm\u0018\u0013fcR!\u0011QOA>!\r9\u0018qO\u0005\u0004\u0003sB(\u0001B+oSRD\u0011\"! X\u0003\u0003\u0005\r!a\u001b\u0002\u0007a$\u0013'\u0001\u0004f]\u0012,G\r\t\u0015\u00041\u0006\r\u0005cA<\u0002\u0006&\u0019\u0011q\u0011=\u0003\u0011Y|G.\u0019;jY\u0016\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'!\"!a$\u0011\u0005Q\u0004\u0011!\u00048Ue\u0006t7/Y2uS>t7/\u0006\u0002\u0002\u0016B\u0019q/a&\n\u0007\u0005e\u0005PA\u0002J]R\faB\u001c+sC:\u001c\u0018m\u0019;j_:\u001c\b%\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006\t2m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0011\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u00039qW/\u001c)beRLG/[8og\u0002\n\u0011\u0002\u001e=o\u0007>tg-[4\u0016\u0005\u0005%\u0006c\u0001;\u0002,&\u0019\u0011QV.\u0003#Q\u0013\u0018M\\:bGRLwN\\\"p]\u001aLw-\u0001\u0006uq:\u001cuN\u001c4jO\u0002\na\u0003\u001e:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\u000b\u0003\u0003k\u00032\u0001^A\\\u0013\r\tIl\u0017\u0002\u0017)J\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe\u0006QBO]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'o\u0018\u0013fcR!\u0011QOA`\u0011%\tihCA\u0001\u0002\u0004\t),A\fue\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8sA\u0005yA\u000f\u001f8Ti\u0006$X-T1oC\u001e,'/\u0006\u0002\u0002HB\u0019A/!3\n\u0007\u0005-7LA\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4fe\u0006\u0019B\u000f\u001f8Ti\u0006$X-T1oC\u001e,'o\u0018\u0013fcR!\u0011QOAi\u0011%\tiHDA\u0001\u0002\u0004\t9-\u0001\tuq:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3sA\u00059B\u000f\u001f8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM]\u000b\u0003\u00033\u00042\u0001^An\u0013\r\tin\u0017\u0002 )J\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018a\u0007;y]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002v\u0005\r\b\"CA?#\u0005\u0005\t\u0019AAm\u0003a!\bP\\'be.,'o\u00115b]:,G.T1oC\u001e,'\u000fI\u0001\u000eC2dw\n]3sCRLwN\\:\u0016\u0005\u0005-\bCBAw\u0003g\f90\u0004\u0002\u0002p*\u0019\u0011\u0011\u001f=\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002v\u0006=(aA*fcB\"\u0011\u0011 B!!\u0015\tYP\nB \u001b\u0005\u0001!\u0001\u0004+y]>\u0003XM]1uS>tW\u0003\u0002B\u0001\u0005#\u00192A\nB\u0002!\u0011\tYP!\u0002\n\u0007\t\u001dQMA\u0005Pa\u0016\u0014\u0018\r^5p]R\u0011!1\u0002\t\u0006\u0003w4#Q\u0002\t\u0005\u0005\u001f\u0011\t\u0002\u0004\u0001\u0005\u000f\tMaE1\u0001\u0003\u0016\t\t!+\u0005\u0003\u0003\u0018\tu\u0001cA<\u0003\u001a%\u0019!1\u0004=\u0003\u000f9{G\u000f[5oOB\u0019qOa\b\n\u0007\t\u0005\u0002PA\u0002B]f\faA]3tk2$XC\u0001B\u0014!\u00159(\u0011\u0006B\u0007\u0013\r\u0011Y\u0003\u001f\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0015I,7/\u001e7u?\u0012*\u0017\u000f\u0006\u0003\u0002v\tE\u0002\"CA?S\u0005\u0005\t\u0019\u0001B\u0014\u0003\u001d\u0011Xm];mi\u0002B3AKAB\u00039\u0011Xm];mi\u000e\u000bG\u000e\u001c2bG.$B!!\u001e\u0003<!9!QH\u0016A\u0002\t5\u0011!\u0001:\u0011\t\t=!\u0011\t\u0003\f\u0005\u0007\u0002\u0011\u0011!A\u0001\u0006\u0003\u0011)E\u0001\u0002`cE!!q\tB0%\u0019\u0011IE!\u0014\u0003Z\u00191!1\n\u0001\u0001\u0005\u000f\u0012A\u0002\u0010:fM&tW-\\3oiz\u0002BAa\u0014\u0003V5\u0011!\u0011\u000b\u0006\u0005\u0005'\n9$\u0001\u0005qe>$xnY8m\u0013\u0011\u00119F!\u0015\u0003\r\u0015\u0013(o\u001c:t!\r!(1L\u0005\u0004\u0005;Z&\u0001F%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a*fgVdGO\u0005\u0004\u0003b\t\r$1\u000f\u0004\u0007\u0005\u0017\u0002\u0001Aa\u0018\u0011\t\t\u0015$qN\u0007\u0003\u0005ORAA!\u001b\u0003l\u0005!A.\u00198h\u0015\t\u0011i'\u0001\u0003kCZ\f\u0017\u0002\u0002B9\u0005O\u0012aa\u00142kK\u000e$\b\u0003\u0002B;\u0005wj!Aa\u001e\u000b\t\te$1N\u0001\u0003S>LAA! \u0003x\ta1+\u001a:jC2L'0\u00192mK\u0006q\u0011\r\u001c7Pa\u0016\u0014\u0018\r^5p]N\u0004\u0013aD1mYR\u0013\u0018M\\:bGRLwN\\:\u0016\u0005\t\u0015\u0005#\u0002BD\u0005\u001b;WB\u0001BE\u0015\u0011\u0011Y)a<\u0002\u000f5,H/\u00192mK&!!q\u0012BE\u0005\r\u0019V\r^\u0001\u0011C2dGK]1og\u0006\u001cG/[8og\u0002\nQ\u0003\u001e=o%\u0016\u001cwN\u001d3t\u0005f\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u0003\u0018BA\u0011Q\u001eBM\u0003+\u0013i*\u0003\u0003\u0003\u001c\u0006=(aA'baB1!q\u0011BP\u0005GKAA!)\u0003\n\nY\u0011I\u001d:bs\n+hMZ3s!\u0011\u0011)Ka+\u000e\u0005\t\u001d&\u0002\u0002BU\u0003o\taA]3d_J$\u0017\u0002\u0002BW\u0005O\u0013AbU5na2,'+Z2pe\u0012\fa\u0003\u001e=o%\u0016\u001cwN\u001d3t\u0005f\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003kB3!\u0007B\\!\u0011\u0011ILa0\u000e\u0005\tm&\u0002\u0002B_\u0003\u0003\nQA[;oSRLAA!1\u0003<\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u00045\t\u001d\u0007\u0003\u0002B]\u0005\u0013LAAa3\u0003<\n)\u0011I\u001a;fe\u0006qB/Z:u\u0007>t7-\u001e:sK:$xi\\8e!\u0006$\bnU3rk\u0016t7-\u001a\u0015\u00047\tE\u0007\u0003\u0002B]\u0005'LAA!6\u0003<\n!A+Z:u\u0003u!Xm\u001d;D_:\u001cWO\u001d:f]R\u0014\u0016M\u001c3p[N+\u0017/^3oG\u0016\u001c\bf\u0001\u000f\u0003R\u0006\u0011C/Z:u\u0007>t7-\u001e:sK:$Hj\\1e+:dw.\u00193QCJ$\u0018\u000e^5p]ND3!\bBi\u0003\r\"Xm\u001d;D_:\u001cWO\u001d:f]R$&/\u00198tC\u000e$\u0018n\u001c8FqBL'/\u0019;j_:D3A\bBi\u0003A)g.\u00192mK\u000e{W\u000e\u001d7fi&|g.A\tm_\u0006$WK\u001c7pC\u0012\f5\r^5p]N$bA!;\u0003t\ne\bCBA\u000b\u0005W\u0014i/\u0003\u0003\u0003\u0010\u0006\u0005\u0002\u0003BA\u0002\u0005_LAA!=\u0002\u000e\t1\u0011i\u0019;j_:DqA!>!\u0001\u0004\u001190\u0001\tqCJ$\u0018\u000e^5p]N$v\u000eT8bIB1\u0011Q\u0003Bv\u0003+CqAa?!\u0001\u0004\u001190\u0001\nqCJ$\u0018\u000e^5p]N$v.\u00168m_\u0006$\u0017AE2sK\u0006$X\r\u0016:b]N\f7\r^5p]N$Ba!\u0001\u0004\u0004A)\u0011Q\u0003BvO\"91QA\u0011A\u0002\u0005M\u0011!\u0003;y]B\u0013XMZ5y\u0003E1XM]5gsR\u0013\u0018M\\:bGRLwN\u001c\u000b\u0007\u0003k\u001aYaa\u0004\t\r\r5!\u00051\u0001h\u0003\r!\bP\u001c\u0005\b\u0007#\u0011\u0003\u0019AB\n\u00035)\u0007\u0010]3di\u0016$7\u000b^1uKB\u0019Ao!\u0006\n\u0007\r]1L\u0001\tUe\u0006t7/Y2uS>t7\u000b^1uK\u0006\u0019BO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCR!1QDB\u0013!\u00159(\u0011FB\u0010!\r!8\u0011E\u0005\u0004\u0007GY&a\u0005+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007BBB\u0007G\u0001\u0007q-\u0001\nqe\u0016\u0004\u0018M]3Ue\u0006t7/Y2uS>tG\u0003BA;\u0007WAaa!\u0004%\u0001\u00049\u0017!\u00049sKB\f'/\u001a+y]2{w\r\u0006\u0003\u0002v\rE\u0002bBB\u001aK\u0001\u0007\u0011QS\u0001\fa\u0006\u0014H/\u001b;j_:LEMA\fJ]&$\bK]8ek\u000e,'/\u00133Pa\u0016\u0014\u0018\r^5p]N\u0019Af!\u000f\u0011\u000b\u0005mhE!\u0017\u0015\u0005\ru\u0002cAA~Y\u0005\u0019!/\u001e8\u0015\t\u0005U41\t\u0005\u0007\u0007\u001bq\u0003\u0019A4\u0002\u001d\u0005<\u0018-\u001b;B]\u00124VM]5gsR!\u0011QOB%\u0011\u0019\u0019ia\fa\u0001O\nY\u0012\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016=o\u001fB,'/\u0019;j_:\u001c2\u0001MB(!\u0015\tYP\nB'\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007\u0003+\u0011Yo!\u0016\u0011\t\r]3\u0011L\u0007\u0003\u0003oIAaa\u0017\u00028\tqAk\u001c9jGB\u000b'\u000f^5uS>tG\u0003BB0\u0007C\u00022!a?1\u0011\u001d\u0019\tF\ra\u0001\u0007'\"B!!\u001e\u0004f!11QB\u001aA\u0002\u001d$B!!\u001e\u0004j!11Q\u0002\u001bA\u0002\u001d\u0014q\"\u00128e)btw\n]3sCRLwN\\\n\u0004k\r=CCAB9!\r\tY0\u000e\u000b\u0005\u0003k\u001a)\b\u0003\u0004\u0004\u000e]\u0002\ra\u001a\u000b\u0005\u0003k\u001aI\b\u0003\u0004\u0004\u000ea\u0002\raZ\u0001\u0012iJ\fgn]1di&|gNU3tk2$H\u0003BB@\u0007\u0017\u0003Ba!!\u0004\b6\u001111\u0011\u0006\u0005\u0007\u000b\u000b9$\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0019Iia!\u0003#Q\u0013\u0018M\\:bGRLwN\u001c*fgVdG\u000f\u0003\u0004\u0004\u000ee\u0002\ra\u001a\u0002\u0017\u0019>\fG\r\u0016=o!\u0006\u0014H/\u001b;j_:\f5\r^5p]N)!Ha\u0019\u0003n\u0006\u0019B\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c8JIR!1QSBL!\r\tYP\u000f\u0005\b\u0007#c\u0004\u0019AAK\u0003\u0015\tw/Y5u\u0005a)f\u000e\\8bIRCh\u000eU1si&$\u0018n\u001c8BGRLwN\\\n\u0006\u007f\t\r$Q\u001e\u000b\u0005\u0007C\u001b\u0019\u000bE\u0002\u0002|~Bqa!%B\u0001\u0004\t)*\u0001\u0006uq:\u0014VmY8sIN,\"A!(\u0002\u0017QDhNU3d_J$7\u000f\t\u0002\u0019\u000bb\u0004\u0018N]3Ue\u0006t7/Y2uS>t7/Q2uS>t7#\u0002$\u0003d\t5\u0018\u0001\u0004;sC:\u001c\u0018m\u0019;j_:\u001cH\u0003BBZ\u0007k\u00032!a?G\u0011\u001d\u0019y\u000b\u0013a\u0001\u0007\u0003\u0001")
public class TransactionCoordinatorConcurrencyTest
extends AbstractCoordinatorConcurrencyTest<Transaction> {
    private final int nTransactions = this.nThreads() * 10;
    private final int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch;
    private final int numPartitions = this.nThreads() * 5;
    private final TransactionConfig kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
    private TransactionCoordinator kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator;
    private TransactionStateManager kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager;
    private TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Seq<TxnOperation<? extends Object>> allOperations = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TxnOperation[]{new InitProducerIdOperation(this), new AddPartitionsToTxnOperation(this, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 0)})))), new EndTxnOperation(this)}));
    private final scala.collection.mutable.Set<Transaction> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Map<Object, ArrayBuffer<SimpleRecord>> txnRecordsByPartition;

    private int nTransactions() {
        return this.nTransactions;
    }

    public int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    public TransactionConfig kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig;
    }

    public TransactionCoordinator kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator;
    }

    private void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator_$eq(TransactionCoordinator x$1) {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator = x$1;
    }

    public TransactionStateManager kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager;
    }

    private void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager_$eq(TransactionStateManager x$1) {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager = x$1;
    }

    private TransactionMarkerChannelManager txnMarkerChannelManager() {
        return this.txnMarkerChannelManager;
    }

    private void txnMarkerChannelManager_$eq(TransactionMarkerChannelManager x$1) {
        this.txnMarkerChannelManager = x$1;
    }

    private Seq<TxnOperation<? extends Object>> allOperations() {
        return this.allOperations;
    }

    public scala.collection.mutable.Set<Transaction> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions;
    }

    private Map<Object, ArrayBuffer<SimpleRecord>> txnRecordsByPartition() {
        return this.txnRecordsByPartition;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager_$eq(new TransactionStateManager(0, this.zkClient(), (Scheduler)this.scheduler(), (ReplicaManager)this.replicaManager(), this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig(), (Time)this.time(), new Metrics()));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.numPartitions());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TransactionCoordinatorConcurrencyTest.$anonfun$setUp$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        int producerId = 11;
        ProducerIdManager pidManager = (ProducerIdManager)EasyMock.createNiceMock(ProducerIdManager.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)pidManager.generateProducerId())).andReturn((Object)BoxesRunTime.boxToLong((long)producerId)).anyTimes();
        String x$1 = "txn-purgatory-name";
        MockTimer x$2 = new MockTimer();
        boolean x$3 = false;
        int x$4 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$5 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$6 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory txnMarkerPurgatory = new DelayedOperationPurgatory(x$1, (Timer)x$2, x$4, x$5, x$3, x$6);
        Node brokerNode = new Node(0, "host", 10);
        MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getPartitionLeaderEndpoint(EasyMock.anyString(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)brokerNode)).anyTimes();
        NetworkClient networkClient = (NetworkClient)EasyMock.createNiceMock(NetworkClient.class);
        this.txnMarkerChannelManager_$eq(new TransactionMarkerChannelManager(this, metadataCache, networkClient, txnMarkerPurgatory){
            private final DelayedOperationPurgatory txnMarkerPurgatory$1;

            public void shutdown() {
                this.txnMarkerPurgatory$1.shutdown();
            }
            {
                this.txnMarkerPurgatory$1 = txnMarkerPurgatory$1;
                super(KafkaConfig$.MODULE$.fromProps($outer.serverProps()), metadataCache$1, networkClient$1, $outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager(), txnMarkerPurgatory$1, (Time)$outer.time());
            }
        });
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator_$eq(new TransactionCoordinator(0, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig(), (Scheduler)this.scheduler(), pidManager, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager(), this.txnMarkerChannelManager(), (Time)this.time(), new LogContext()));
        EasyMock.replay((Object[])new Object[]{pidManager});
        EasyMock.replay((Object[])new Object[]{metadataCache});
        EasyMock.replay((Object[])new Object[]{networkClient});
    }

    @Override
    @After
    public void tearDown() {
        try {
            EasyMock.reset((Object[])new Object[]{this.zkClient(), this.replicaManager()});
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().shutdown();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testConcurrentGoodPathSequence() {
        this.verifyConcurrentOperations((Function1 & Serializable & scala.Serializable)txnPrefix -> this.createTransactions((String)txnPrefix), this.allOperations());
    }

    @Test
    public void testConcurrentRandomSequences() {
        this.verifyConcurrentRandomSequences((Function1 & Serializable & scala.Serializable)txnPrefix -> this.createTransactions((String)txnPrefix), this.allOperations());
    }

    @Test
    public void testConcurrentLoadUnloadPartitions() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        scala.collection.immutable.Set partitionsToLoad = RichInt$.MODULE$.until$extension0(n, this.numPartitions() / 2).toSet();
        int n2 = this.numPartitions() / 2;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        scala.collection.immutable.Set partitionsToUnload = RichInt$.MODULE$.until$extension0(n2, this.numPartitions()).toSet();
        this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)this.loadUnloadActions((scala.collection.immutable.Set<Object>)partitionsToLoad, (scala.collection.immutable.Set<Object>)partitionsToUnload));
    }

    @Test
    public void testConcurrentTransactionExpiration() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        scala.collection.immutable.Set partitionsToLoad = RichInt$.MODULE$.until$extension0(n, this.numPartitions() / 3).toSet();
        int n2 = this.numPartitions() / 3;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        scala.collection.immutable.Set partitionsToUnload = RichInt$.MODULE$.until$extension0(n2, this.numPartitions() * 2 / 3).toSet();
        int n3 = this.numPartitions() * 2 / 3;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        scala.collection.immutable.Set partitionsWithExpiringTxn = RichInt$.MODULE$.until$extension0(n3, this.numPartitions()).toSet();
        scala.collection.immutable.Set expiringTransactions = ((TraversableOnce)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().filter((Function1 & Serializable & scala.Serializable)txn -> BoxesRunTime.boxToBoolean((boolean)partitionsWithExpiringTxn.contains((Object)BoxesRunTime.boxToInteger((int)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId())))))).toSet();
        ExpireTransactionsAction expireAction = new ExpireTransactionsAction(this, (scala.collection.immutable.Set<Transaction>)expiringTransactions);
        this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)this.loadUnloadActions((scala.collection.immutable.Set<Object>)partitionsToLoad, (scala.collection.immutable.Set<Object>)partitionsToUnload).$plus((Object)expireAction));
    }

    @Override
    public void enableCompletion() {
        super.enableCompletion();
        synchronized (this) {
            this.txnMarkerChannelManager().generateRequests().foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
                TransactionCoordinatorConcurrencyTest.$anonfun$enableCompletion$3(requestAndHandler);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<AbstractCoordinatorConcurrencyTest.Action> loadUnloadActions(scala.collection.immutable.Set<Object> partitionsToLoad, scala.collection.immutable.Set<Object> partitionsToUnload) {
        void flatMap_bf;
        void flatMap_f;
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 10);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)i -> this.createTransactions(new StringBuilder(35).append("testConcurrentLoadUnloadPartitions").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString());
        if (inclusive == null) {
            throw null;
        }
        ((TraversableOnce)TraversableLike.flatMap$((TraversableLike)inclusive, (Function1)flatMap_f, (CanBuildFrom)flatMap_bf)).toSet().foreach((Function1 & Serializable & scala.Serializable)txn -> {
            this.prepareTransaction(txn);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set unload = (scala.collection.immutable.Set)partitionsToLoad.map((Function1 & Serializable & scala.Serializable)x$1 -> TransactionCoordinatorConcurrencyTest.$anonfun$loadUnloadActions$3(this, BoxesRunTime.unboxToInt((Object)x$1)), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
        unload.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.run();
            return BoxedUnit.UNIT;
        });
        unload.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.await();
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Set)((TraversableLike)partitionsToLoad.map((Function1 & Serializable & scala.Serializable)x$4 -> TransactionCoordinatorConcurrencyTest.$anonfun$loadUnloadActions$6(this, BoxesRunTime.unboxToInt((Object)x$4)), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsToUnload.map((Function1 & Serializable & scala.Serializable)x$5 -> TransactionCoordinatorConcurrencyTest.$anonfun$loadUnloadActions$7(this, BoxesRunTime.unboxToInt((Object)x$5)), scala.collection.immutable.Set$.MODULE$.canBuildFrom()), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
    }

    private scala.collection.immutable.Set<Transaction> createTransactions(String txnPrefix) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        IndexedSeq transactions = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, this.nTransactions()).map((Function1 & Serializable & scala.Serializable)i -> TransactionCoordinatorConcurrencyTest.$anonfun$createTransactions$1(this, txnPrefix, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().$plus$plus$eq((TraversableOnce)transactions);
        return transactions.toSet();
    }

    /*
     * WARNING - void declaration
     */
    public void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(Transaction txn, TransactionState expectedState) {
        Object object;
        boolean bl;
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Option computeUntilTrue_result;
            if (TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$2(expectedState, computeUntilTrue_result = TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$1(this, txn))) {
                boolean bl2 = true;
                Object object2 = Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                bl = bl2;
                object = object2;
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                boolean bl3 = false;
                Object object3 = Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                bl = bl3;
                object = object3;
                break;
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)computeUntilTrue_waitTime, (long)computeUntilTrue_pause));
        }
        Option option = (Option)object;
        Assert.assertTrue((String)new StringBuilder(23).append("Invalid metadata state ").append(option).toString(), (boolean)bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<TransactionMetadata> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(Transaction txn) {
        boolean bl = false;
        Right right = null;
        Either either = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().getTransactionState(txn.transactionalId());
        if (either instanceof Left) {
            Errors error;
            Errors errors = error = (Errors)((Left)either).value();
            Errors errors2 = Errors.NOT_COORDINATOR;
            if (errors == null) {
                if (errors2 == null) return None$.MODULE$;
                throw new AssertionError((Object)new StringBuilder(34).append("Unexpected transaction error ").append(error).append(" for ").append(txn).toString());
            }
            if (!errors.equals(errors2)) throw new AssertionError((Object)new StringBuilder(34).append("Unexpected transaction error ").append(error).append(" for ").append(txn).toString());
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option = (Option)right.value();
            if (option instanceof Some) {
                CoordinatorEpochAndTxnMetadata metadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
                return new Some((Object)metadata.transactionMetadata());
            }
        }
        if (!bl) throw new MatchError((Object)either);
        Option option = (Option)right.value();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)either);
        return None$.MODULE$;
    }

    private void prepareTransaction(Transaction txn) {
        int partitionId = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId());
        ArrayBuffer txnRecords = (ArrayBuffer)this.txnRecordsByPartition().apply((Object)BoxesRunTime.boxToInteger((int)partitionId));
        InitProducerIdOperation initPidOp = new InitProducerIdOperation(this);
        AddPartitionsToTxnOperation addPartitionsOp = new AddPartitionsToTxnOperation(this, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 0)}))));
        initPidOp.run(txn);
        initPidOp.awaitAndVerify(txn);
        addPartitionsOp.run(txn);
        addPartitionsOp.awaitAndVerify(txn);
        Option<TransactionMetadata> option = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn);
        if (option == null) {
            throw null;
        }
        Option<TransactionMetadata> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw TransactionCoordinatorConcurrencyTest.$anonfun$prepareTransaction$1(txn);
        }
        TransactionMetadata txnMetadata = (TransactionMetadata)getOrElse_this.get();
        txnRecords.$plus$eq((Object)new SimpleRecord(txn.txnMessageKeyBytes(), TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit())));
        txnMetadata.state_$eq((TransactionState)PrepareCommit$.MODULE$);
        txnRecords.$plus$eq((Object)new SimpleRecord(txn.txnMessageKeyBytes(), TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit())));
        this.prepareTxnLog(partitionId);
    }

    private void prepareTxnLog(int partitionId) {
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Option<Object> option = this.replicaManager().getLogEndOffset(topicPartition);
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? BoxesRunTime.boxToLong((long)TransactionCoordinatorConcurrencyTest.$anonfun$prepareTxnLog$1()) : getOrElse_this.get();
        long startOffset = BoxesRunTime.unboxToLong((Object)object);
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)this.txnRecordsByPartition().apply((Object)BoxesRunTime.boxToInteger((int)partitionId))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        long endOffset = startOffset + (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, bufferCapture, records){
            private final Capture bufferCapture$1;
            private final MemoryRecords records$1;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.bufferCapture$1 = bufferCapture$1;
                this.records$1 = records$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock});
        synchronized (this) {
            this.replicaManager().updateLog(topicPartition, logMock, endOffset);
            return;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$txnRecordsByPartition$1(int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$setUp$1(TransactionCoordinatorConcurrencyTest $this, int i) {
        $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().addLoadedTransactionsToCache(i, $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
    }

    private static final WriteTxnMarkersResponse createResponse$1(WriteTxnMarkersRequest request) {
        java.util.Map pidErrorMap = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(request.markers()).asScala()).map((Function1 & Serializable & scala.Serializable)marker -> new Tuple2((Object)BoxesRunTime.boxToLong((long)marker.producerId()), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(marker.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(tp, (Object)Errors.NONE), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        return new WriteTxnMarkersResponse(pidErrorMap);
    }

    public static final /* synthetic */ void $anonfun$enableCompletion$3(RequestAndCompletionHandler requestAndHandler) {
        WriteTxnMarkersResponse response = TransactionCoordinatorConcurrencyTest.createResponse$1((WriteTxnMarkersRequest)((WriteTxnMarkersRequest.Builder)requestAndHandler.request()).build());
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
    }

    public static final /* synthetic */ UnloadTxnPartitionAction $anonfun$loadUnloadActions$3(TransactionCoordinatorConcurrencyTest $this, int x$1) {
        return new UnloadTxnPartitionAction($this, x$1);
    }

    public static final /* synthetic */ LoadTxnPartitionAction $anonfun$loadUnloadActions$6(TransactionCoordinatorConcurrencyTest $this, int x$4) {
        return new LoadTxnPartitionAction($this, x$4);
    }

    public static final /* synthetic */ UnloadTxnPartitionAction $anonfun$loadUnloadActions$7(TransactionCoordinatorConcurrencyTest $this, int x$5) {
        return new UnloadTxnPartitionAction($this, x$5);
    }

    public static final /* synthetic */ Transaction $anonfun$createTransactions$1(TransactionCoordinatorConcurrencyTest $this, String txnPrefix$1, int i) {
        return new Transaction(new StringBuilder(0).append(txnPrefix$1).append(i).toString(), i, $this.time());
    }

    public static final /* synthetic */ Option $anonfun$verifyTransaction$1(TransactionCoordinatorConcurrencyTest $this, Transaction txn$1) {
        $this.enableCompletion();
        return $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn$1);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTransaction$3(TransactionState expectedState$1, TransactionMetadata m) {
        TransactionState transactionState = m.state();
        return !(transactionState != null ? !transactionState.equals(expectedState$1) : expectedState$1 != null) && m.pendingState().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTransaction$2(TransactionState expectedState$1, Option metadata) {
        TransactionMetadata transactionMetadata;
        boolean bl;
        return metadata.nonEmpty() && (bl = metadata.isEmpty() || TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$3(expectedState$1, transactionMetadata = (TransactionMetadata)metadata.get()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$prepareTransaction$1(Transaction txn$2) {
        throw new IllegalStateException(new StringBuilder(22).append("Transaction not found ").append(txn$2).toString());
    }

    public static final /* synthetic */ long $anonfun$prepareTxnLog$1() {
        return 20L;
    }

    public TransactionCoordinatorConcurrencyTest() {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch = 10;
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.txnRecordsByPartition = ((TraversableOnce)RichInt$.MODULE$.until$extension0(n, this.numPartitions()).map((Function1 & Serializable & scala.Serializable)i -> TransactionCoordinatorConcurrencyTest.$anonfun$txnRecordsByPartition$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ Object $anonfun$verifyTransaction$2$adapted(TransactionState expectedState$1, Option metadata) {
        return BoxesRunTime.boxToBoolean((boolean)TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$2(expectedState$1, metadata));
    }

    public static final /* synthetic */ Object $anonfun$verifyTransaction$3$adapted(TransactionState expectedState$1, TransactionMetadata m) {
        return BoxesRunTime.boxToBoolean((boolean)TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$3(expectedState$1, m));
    }

    public class AddPartitionsToTxnOperation
    extends TxnOperation<Errors> {
        private final scala.collection.immutable.Set<TopicPartition> partitions;

        public void run(Transaction txn) {
            Option<TransactionMetadata> option = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn);
            if (option == null) {
                throw null;
            }
            Option<TransactionMetadata> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                TransactionMetadata transactionMetadata = (TransactionMetadata)foreach_this.get();
                AddPartitionsToTxnOperation.$anonfun$run$2(this, txn, transactionMetadata);
                return;
            }
        }

        public void awaitAndVerify(Transaction txn) {
            Option option = this.result();
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                throw AddPartitionsToTxnOperation.$anonfun$awaitAndVerify$2();
            }
            Errors error = (Errors)getOrElse_this.get();
            Assert.assertEquals((Object)Errors.NONE, (Object)error);
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)Ongoing$.MODULE$);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$2(AddPartitionsToTxnOperation $this, Transaction txn$3, TransactionMetadata txnMetadata) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleAddPartitionsToTransaction(txn$3.transactionalId(), txnMetadata.producerId(), txnMetadata.producerEpoch(), $this.partitions, (Function1 & Serializable & scala.Serializable)r -> {
                $this.resultCallback(r);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ Nothing$ $anonfun$awaitAndVerify$2() {
            throw new IllegalStateException("AddPartitionsToTransaction has not completed");
        }

        public AddPartitionsToTxnOperation(TransactionCoordinatorConcurrencyTest $outer, scala.collection.immutable.Set<TopicPartition> partitions) {
            this.partitions = partitions;
            super($outer);
        }

        public static final /* synthetic */ Object $anonfun$run$2$adapted(AddPartitionsToTxnOperation $this, Transaction txn$3, TransactionMetadata txnMetadata) {
            AddPartitionsToTxnOperation.$anonfun$run$2($this, txn$3, txnMetadata);
            return BoxedUnit.UNIT;
        }
    }

    public class EndTxnOperation
    extends TxnOperation<Errors> {
        public void run(Transaction txn) {
            Option<TransactionMetadata> option = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn);
            if (option == null) {
                throw null;
            }
            Option<TransactionMetadata> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                TransactionMetadata transactionMetadata = (TransactionMetadata)foreach_this.get();
                EndTxnOperation.$anonfun$run$4(this, txn, transactionMetadata);
                return;
            }
        }

        public void awaitAndVerify(Transaction txn) {
            Option option = this.result();
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                throw EndTxnOperation.$anonfun$awaitAndVerify$3();
            }
            Errors error = (Errors)getOrElse_this.get();
            if (!txn.ended()) {
                txn.ended_$eq(true);
                Assert.assertEquals((Object)Errors.NONE, (Object)error);
                TransactionResult transactionResult = this.transactionResult(txn);
                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                CompleteCommit$ expectedState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
                this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)expectedState);
                return;
            }
            Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)error);
        }

        private TransactionResult transactionResult(Transaction txn) {
            String txnId = txn.transactionalId();
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            if (StringOps$.MODULE$.apply$extension(txnId, txnId.length() - 1) % 2 == 0) {
                return TransactionResult.COMMIT;
            }
            return TransactionResult.ABORT;
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$4(EndTxnOperation $this, Transaction txn$4, TransactionMetadata txnMetadata) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleEndTransaction(txn$4.transactionalId(), txnMetadata.producerId(), txnMetadata.producerEpoch(), $this.transactionResult(txn$4), (Function1 & Serializable & scala.Serializable)r -> {
                $this.resultCallback(r);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ Nothing$ $anonfun$awaitAndVerify$3() {
            throw new IllegalStateException("EndTransaction has not completed");
        }

        public EndTxnOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }

        public static final /* synthetic */ Object $anonfun$run$4$adapted(EndTxnOperation $this, Transaction txn$4, TransactionMetadata txnMetadata) {
            EndTxnOperation.$anonfun$run$4($this, txn$4, txnMetadata);
            return BoxedUnit.UNIT;
        }
    }

    public class ExpireTransactionsAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        private final scala.collection.immutable.Set<Transaction> transactions;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        @Override
        public void run() {
            this.transactions.foreach((Function1 & Serializable & scala.Serializable)txn -> {
                ExpireTransactionsAction.$anonfun$run$6(this, txn);
                return BoxedUnit.UNIT;
            });
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().enableTransactionalIdExpiration();
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().time().sleep(this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig().removeExpiredTransactionalIdsIntervalMs() + 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void await() {
            boolean bl;
            long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
            long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long computeUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                void computeUntilTrue_pause;
                void computeUntilTrue_waitTime;
                boolean bl2 = ExpireTransactionsAction.$anonfun$await$3(this);
                Boolean computeUntilTrue_result = BoxesRunTime.boxToBoolean((boolean)bl2);
                if (ExpireTransactionsAction.$anonfun$await$5(bl2)) {
                    Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result);
                    boolean bl3 = true;
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    bl = bl3;
                    break;
                }
                if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                    Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result);
                    boolean bl4 = false;
                    if (Predef.ArrowAssoc$.MODULE$ == null) {
                        throw null;
                    }
                    bl = bl4;
                    break;
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)computeUntilTrue_waitTime, (long)computeUntilTrue_pause));
            }
            Assert.assertTrue((String)"Transaction not expired", (boolean)bl);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$6(ExpireTransactionsAction $this, Transaction txn) {
            Option<TransactionMetadata> option = $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn);
            if (option == null) {
                throw null;
            }
            Option<TransactionMetadata> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                TransactionMetadata transactionMetadata = (TransactionMetadata)foreach_this.get();
                transactionMetadata.txnLastUpdateTimestamp_$eq($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().time().milliseconds() - (long)$this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig().transactionalIdExpirationMs());
                return;
            }
        }

        public static final /* synthetic */ boolean $anonfun$await$4(ExpireTransactionsAction $this, Transaction txn) {
            return $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).isEmpty();
        }

        public static final /* synthetic */ boolean $anonfun$await$3(ExpireTransactionsAction $this) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().replicaManager().tryCompleteDelayedRequests();
            return $this.transactions.forall((Function1 & Serializable & scala.Serializable)txn -> BoxesRunTime.boxToBoolean((boolean)ExpireTransactionsAction.$anonfun$await$4($this, txn)));
        }

        public static final /* synthetic */ boolean $anonfun$await$5(boolean x) {
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            return x;
        }

        public ExpireTransactionsAction(TransactionCoordinatorConcurrencyTest $outer, scala.collection.immutable.Set<Transaction> transactions) {
            this.transactions = transactions;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }

        public static final /* synthetic */ Object $anonfun$await$5$adapted(Object x) {
            return BoxesRunTime.boxToBoolean((boolean)ExpireTransactionsAction.$anonfun$await$5(BoxesRunTime.unboxToBoolean((Object)x)));
        }

        public static final /* synthetic */ Object $anonfun$run$7$adapted(ExpireTransactionsAction $this, TransactionMetadata txnMetadata) {
            txnMetadata.txnLastUpdateTimestamp_$eq($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().time().milliseconds() - (long)$this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig().transactionalIdExpirationMs());
            return BoxedUnit.UNIT;
        }
    }

    public class InitProducerIdOperation
    extends TxnOperation<InitProducerIdResult> {
        public void run(Transaction txn) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleInitProducerId(txn.transactionalId(), 60000, (Function1 & Serializable & scala.Serializable)r -> {
                this.resultCallback(r);
                return BoxedUnit.UNIT;
            });
        }

        public void awaitAndVerify(Transaction txn) {
            Option option = this.result();
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                throw InitProducerIdOperation.$anonfun$awaitAndVerify$1();
            }
            InitProducerIdResult initPidResult = (InitProducerIdResult)getOrElse_this.get();
            Assert.assertEquals((Object)Errors.NONE, (Object)initPidResult.error());
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)Empty$.MODULE$);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public static final /* synthetic */ Nothing$ $anonfun$awaitAndVerify$1() {
            throw new IllegalStateException("InitProducerId has not completed");
        }

        public InitProducerIdOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }
    }

    public class LoadTxnPartitionAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        private final int txnTopicPartitionId;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        @Override
        public void run() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().onElection(this.txnTopicPartitionId, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch());
        }

        @Override
        public void await() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> {
                LoadTxnPartitionAction.$anonfun$await$1(this, txn);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$await$1(LoadTxnPartitionAction $this, Transaction txn) {
            if ($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId()) == $this.txnTopicPartitionId) {
                $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)CompleteCommit$.MODULE$);
            }
        }

        public LoadTxnPartitionAction(TransactionCoordinatorConcurrencyTest $outer, int txnTopicPartitionId) {
            this.txnTopicPartitionId = txnTopicPartitionId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public static class Transaction
    implements AbstractCoordinatorConcurrencyTest.CoordinatorMember {
        private final String transactionalId;
        private final byte[] txnMessageKeyBytes;
        private volatile boolean ended;

        public String transactionalId() {
            return this.transactionalId;
        }

        public byte[] txnMessageKeyBytes() {
            return this.txnMessageKeyBytes;
        }

        public boolean ended() {
            return this.ended;
        }

        public void ended_$eq(boolean x$1) {
            this.ended = x$1;
        }

        public String toString() {
            return this.transactionalId();
        }

        public Transaction(String transactionalId, long producerId, MockTime time) {
            this.transactionalId = transactionalId;
            this.txnMessageKeyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
            this.ended = false;
        }
    }

    public abstract class TxnOperation<R>
    extends AbstractCoordinatorConcurrencyTest.Operation {
        private volatile Option<R> result = None$.MODULE$;

        public Option<R> result() {
            return this.result;
        }

        public void result_$eq(Option<R> x$1) {
            this.result = x$1;
        }

        public void resultCallback(R r) {
            this.result_$eq((Option<R>)new Some(r));
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$TxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public TxnOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }
    }

    public class UnloadTxnPartitionAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        private final int txnTopicPartitionId;
        private final ArrayBuffer<SimpleRecord> txnRecords;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        public ArrayBuffer<SimpleRecord> txnRecords() {
            return this.txnRecords;
        }

        @Override
        public void run() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().onResignation(this.txnTopicPartitionId, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch())));
        }

        @Override
        public void await() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> {
                UnloadTxnPartitionAction.$anonfun$await$2(this, txn);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$await$2(UnloadTxnPartitionAction $this, Transaction txn) {
            if ($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId()) == $this.txnTopicPartitionId) {
                Assert.assertTrue((String)"Transaction metadata not removed", (boolean)$this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).isEmpty());
            }
        }

        public UnloadTxnPartitionAction(TransactionCoordinatorConcurrencyTest $outer, int txnTopicPartitionId) {
            this.txnTopicPartitionId = txnTopicPartitionId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
    }
}

