/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.MockScheduler;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\reb\u0001B0a\u0001\u001dDQA\u001c\u0001\u0005\u0002=DqA\u001d\u0001C\u0002\u0013\u00051\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002;\t\u0013\u0005\u0015\u0001\u00011A\u0005\u0002\u0005\u001d\u0001\"CA\b\u0001\u0001\u0007I\u0011AA\t\u0011!\ti\u0002\u0001Q!\n\u0005%\u0001\"CA\u0010\u0001\t\u0007I\u0011AA\u0011\u0011!\tI\u0003\u0001Q\u0001\n\u0005\r\u0002\"CA\u0016\u0001\t\u0007I\u0011AA\u0017\u0011!\t)\u0004\u0001Q\u0001\n\u0005=\u0002\"CA\u001c\u0001\t\u0007I\u0011AA\u001d\u0011!\t\t\u0005\u0001Q\u0001\n\u0005m\u0002\"CA\"\u0001\t\u0007I\u0011AA#\u0011!\tI\u0006\u0001Q\u0001\n\u0005\u001d\u0003\"CA.\u0001\t\u0007I\u0011AA/\u0011!\t\u0019\b\u0001Q\u0001\n\u0005}\u0003\"CA;\u0001\t\u0007I\u0011AA<\u0011!\ty\b\u0001Q\u0001\n\u0005e\u0004\"CAA\u0001\t\u0007I\u0011AA<\u0011!\t\u0019\t\u0001Q\u0001\n\u0005e\u0004\"CAC\u0001\t\u0007I\u0011BAD\u0011!\tI\n\u0001Q\u0001\n\u0005%\u0005\"CAN\u0001\t\u0007I\u0011BA<\u0011!\ti\n\u0001Q\u0001\n\u0005e\u0004\"CAP\u0001\t\u0007I\u0011BAQ\u0011!\tI\u000b\u0001Q\u0001\n\u0005\r\u0006\"CAV\u0001\t\u0007I\u0011BA<\u0011!\ti\u000b\u0001Q\u0001\n\u0005e\u0004\"CAX\u0001\t\u0007I\u0011BAY\u0011!\tY\r\u0001Q\u0001\n\u0005M\u0006\"CAg\u0001\t\u0007I\u0011BAh\u0011!\tY\u000e\u0001Q\u0001\n\u0005E\u0007\u0002C2\u0001\u0005\u0004%\t!!8\t\u0011\u0005\u0015\b\u0001)A\u0005\u0003?D1\"a:\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002j\"Y\u0011\u0011\u001f\u0001A\u0002\u0003\u0007I\u0011AAz\u0011-\t9\u0010\u0001a\u0001\u0002\u0003\u0006K!a;\t\u0013\u0005e\b\u00011A\u0005\u0002\u0005m\b\"CA\u007f\u0001\u0001\u0007I\u0011AA\u0000\u0011!\u0011\u0019\u0001\u0001Q!\n\u0005\u001d\u0004b\u0002B\u0003\u0001\u0011%!q\u0001\u0005\b\u0005\u0013\u0001A\u0011\u0002B\u0006\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0005\u000fAqAa\r\u0001\t\u0003\u00119\u0001C\u0004\u00038\u0001!\tAa\u0002\t\u000f\tm\u0002\u0001\"\u0001\u0003\b!9!q\b\u0001\u0005\u0002\t\u001d\u0001b\u0002B\"\u0001\u0011\u0005!q\u0001\u0005\b\u0005\u000f\u0002A\u0011\u0001B\u0004\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005\u000fAqAa\u0014\u0001\t\u0003\u00119\u0001C\u0004\u0003T\u0001!\tAa\u0002\t\u000f\t]\u0003\u0001\"\u0001\u0003\b!9!1\f\u0001\u0005\u0002\t\u001d\u0001b\u0002B0\u0001\u0011\u0005!q\u0001\u0005\b\u0005G\u0002A\u0011\u0001B3\u0011\u001d\u0011\t\b\u0001C\u0001\u0005\u000fAqA!\u001e\u0001\t\u0003\u00119\u0001C\u0004\u0003z\u0001!\tAa\u0002\t\u000f\tu\u0004\u0001\"\u0001\u0003\b!9!\u0011\u0011\u0001\u0005\u0002\t\u001d\u0001b\u0002BC\u0001\u0011\u0005!q\u0011\u0005\b\u0005\u001b\u0003A\u0011\u0001B\u0004\u0011\u001d\u0011\t\n\u0001C\u0001\u0005\u000fAqA!&\u0001\t\u0003\u00119\u0001C\u0004\u0003\u001a\u0002!\tAa\u0002\t\u000f\tu\u0005\u0001\"\u0001\u0003\b!9!\u0011\u0015\u0001\u0005\u0002\t\u001d\u0001b\u0002BS\u0001\u0011\u0005!q\u0001\u0005\b\u0005S\u0003A\u0011\u0001B\u0004\u0011\u001d\u0011i\u000b\u0001C\u0001\u0005\u000fAqA!-\u0001\t\u0003\u00119\u0001C\u0004\u00036\u0002!\tAa\u0002\t\u000f\te\u0006\u0001\"\u0001\u0003\b!9!Q\u0018\u0001\u0005\u0002\t\u001d\u0001b\u0002Ba\u0001\u0011\u0005!q\u0001\u0005\b\u0005\u000b\u0004A\u0011\u0001B\u0004\u0011\u001d\u0011I\r\u0001C\u0001\u0005\u000fAqA!4\u0001\t\u0003\u00119\u0001C\u0004\u0003R\u0002!\tAa\u0002\t\u000f\tU\u0007\u0001\"\u0001\u0003\b!9!\u0011\u001c\u0001\u0005\u0002\t\u001d\u0001b\u0002Bo\u0001\u0011\u0005!q\u0001\u0005\b\u0005C\u0004A\u0011\u0001B\u0004\u0011\u001d\u0011)\u000f\u0001C\u0001\u0005\u000fAqA!;\u0001\t\u0003\u00119\u0001C\u0004\u0003n\u0002!\tAa\u0002\t\u000f\tE\b\u0001\"\u0001\u0003\b!9!Q\u001f\u0001\u0005\n\t]\bb\u0002B~\u0001\u0011%!Q \u0005\b\u0007\u0003\u0001A\u0011BB\u0002\u0011%\u0019\u0019\u0002AI\u0001\n\u0013\u0019)\u0002C\u0004\u0004,\u0001!\ta!\f\t\u000f\rM\u0002\u0001\"\u0001\u00046\tQBK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'\u000fV3ti*\u0011\u0011MY\u0001\fiJ\fgn]1di&|gN\u0003\u0002dI\u0006Y1m\\8sI&t\u0017\r^8s\u0015\u0005)\u0017!B6bM.\f7\u0001A\n\u0003\u0001!\u0004\"!\u001b7\u000e\u0003)T\u0011a[\u0001\u0006g\u000e\fG.Y\u0005\u0003[*\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001q!\t\t\b!D\u0001a\u0003\u0011!\u0018.\\3\u0016\u0003Q\u0004\"!^@\u000e\u0003YT!a\u001e=\u0002\u000bU$\u0018\u000e\\:\u000b\u0005eT\u0018AB2p[6|gN\u0003\u0002fw*\u0011A0`\u0001\u0007CB\f7\r[3\u000b\u0003y\f1a\u001c:h\u0013\r\t\tA\u001e\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059a.\u001a=u!&$WCAA\u0005!\rI\u00171B\u0005\u0004\u0003\u001bQ'\u0001\u0002'p]\u001e\f1B\\3yiBKGm\u0018\u0013fcR!\u00111CA\r!\rI\u0017QC\u0005\u0004\u0003/Q'\u0001B+oSRD\u0011\"a\u0007\u0006\u0003\u0003\u0005\r!!\u0003\u0002\u0007a$\u0013'\u0001\u0005oKb$\b+\u001b3!\u0003)\u0001\u0018\u000eZ'b]\u0006<WM]\u000b\u0003\u0003G\u00012!]A\u0013\u0013\r\t9\u0003\u0019\u0002\u0012!J|G-^2fe&#W*\u00198bO\u0016\u0014\u0018a\u00039jI6\u000bg.Y4fe\u0002\n!\u0003\u001e:b]N\f7\r^5p]6\u000bg.Y4feV\u0011\u0011q\u0006\t\u0004c\u0006E\u0012bAA\u001aA\n9BK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM]\u0001\u0014iJ\fgn]1di&|g.T1oC\u001e,'\u000fI\u0001 iJ\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014XCAA\u001e!\r\t\u0018QH\u0005\u0004\u0003\u007f\u0001'a\b+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u0006\u0001CO]1og\u0006\u001cG/[8o\u001b\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:!\u0003-\u0019\u0017\r\u001d;ve\u0016$G\u000b\u001f8\u0016\u0005\u0005\u001d\u0003CBA%\u0003\u001f\n\u0019&\u0004\u0002\u0002L)\u0019\u0011QJ?\u0002\u0011\u0015\f7/_7pG.LA!!\u0015\u0002L\t91)\u00199ukJ,\u0007cA9\u0002V%\u0019\u0011q\u000b1\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0002\u0019\r\f\u0007\u000f^;sK\u0012$\u0006P\u001c\u0011\u0002-\r\f\u0007\u000f^;sK\u0012,%O]8sg\u000e\u000bG\u000e\u001c2bG.,\"!a\u0018\u0011\r\u0005%\u0013qJA1!\u001dI\u00171MA4\u0003'I1!!\u001ak\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002j\u0005=TBAA6\u0015\r\ti\u0007_\u0001\taJ|Go\\2pY&!\u0011\u0011OA6\u0005\u0019)%O]8sg\u000692-\u00199ukJ,G-\u0012:s_J\u001c8)\u00197mE\u0006\u001c7\u000eI\u0001\tEJ|7.\u001a:JIV\u0011\u0011\u0011\u0010\t\u0004S\u0006m\u0014bAA?U\n\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0003E\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eI\u0001\u0010iJ\fgn]1di&|g.\u00197JIV\u0011\u0011\u0011\u0012\t\u0005\u0003\u0017\u000b)*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0015\u0001\u00026bm\u0006LA!a&\u0002\u000e\n11\u000b\u001e:j]\u001e\f\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u0011\u0002\u0015A\u0014x\u000eZ;dKJLE-A\u0006qe>$WoY3s\u0013\u0012\u0004\u0013!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007.\u0006\u0002\u0002$B\u0019\u0011.!*\n\u0007\u0005\u001d&NA\u0003TQ>\u0014H/\u0001\bqe>$WoY3s\u000bB|7\r\u001b\u0011\u0002\u0019QDh\u000eV5nK>,H/T:\u0002\u001bQDh\u000eV5nK>,H/T:!\u0003)\u0001\u0018M\u001d;ji&|gn]\u000b\u0003\u0003g\u0003b!!.\u0002@\u0006\rWBAA\\\u0015\u0011\tI,a/\u0002\u000f5,H/\u00192mK*\u0019\u0011Q\u00186\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002B\u0006]&aA*fiB!\u0011QYAd\u001b\u0005A\u0018bAAeq\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u00039beRLG/[8og\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\u0005E\u0007\u0003BAj\u0003/l!!!6\u000b\u0005]$\u0017\u0002BAm\u0003+\u0014Q\"T8dWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sAU\u0011\u0011q\u001c\t\u0004c\u0006\u0005\u0018bAArA\n1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'/\u0001\u0007d_>\u0014H-\u001b8bi>\u0014\b%\u0001\u0004sKN,H\u000e^\u000b\u0003\u0003W\u00042!]Aw\u0013\r\ty\u000f\u0019\u0002\u0015\u0013:LG\u000f\u0015:pIV\u001cWM]%e%\u0016\u001cX\u000f\u001c;\u0002\u0015I,7/\u001e7u?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005U\b\"CA\u000eI\u0005\u0005\t\u0019AAv\u0003\u001d\u0011Xm];mi\u0002\nQ!\u001a:s_J,\"!a\u001a\u0002\u0013\u0015\u0014(o\u001c:`I\u0015\fH\u0003BA\n\u0005\u0003A\u0011\"a\u0007(\u0003\u0003\u0005\r!a\u001a\u0002\r\u0015\u0014(o\u001c:!\u00039iwnY6QS\u0012l\u0015M\\1hKJ$\"!a\u0005\u0002'%t\u0017\u000e\u001e)jI\u001e+g.\u001a:jG6{7m[:\u0015\t\u0005M!Q\u0002\u0005\b\u0003\u000bS\u0003\u0019\u0001B\b!\u0011\u0011\tBa\b\u000f\t\tM!1\u0004\t\u0004\u0005+QWB\u0001B\f\u0015\r\u0011IBZ\u0001\u0007yI|w\u000e\u001e \n\u0007\tu!.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\u0013\tCC\u0002\u0003\u001e)\fAg\u001d5pk2$'+\u001a;ve:LeN^1mS\u0012\u0014V-];fgR<\u0006.\u001a8Ue\u0006t7/Y2uS>t\u0017\r\\%e\u0013N,U\u000e\u001d;zQ\rY#q\u0005\t\u0005\u0005S\u0011y#\u0004\u0002\u0003,)\u0019!QF?\u0002\u000b),h.\u001b;\n\t\tE\"1\u0006\u0002\u0005)\u0016\u001cH/\u0001\u001ftQ>,H\u000eZ!dG\u0016\u0004H/\u00138jiBKG-\u00118e%\u0016$XO\u001d8OKb$\b+\u001b3XQ\u0016tGK]1og\u0006\u001cG/[8oC2LE-S:Ok2d\u0007f\u0001\u0017\u0003(\u0005y3\u000f[8vY\u0012Le.\u001b;QS\u0012<\u0016\u000e\u001e5Fa>\u001c\u0007NW3s_\u001a{'OT3x)J\fgn]1di&|g.\u00197JI\"\u001aQFa\n\u0002YMDw.\u001e7e\u000f\u0016tWM]1uK:+w\u000f\u0015:pIV\u001cWM]%e\u0013\u001a,\u0005o\\2ig\u0016C\b.Y;ti\u0016$\u0007f\u0001\u0018\u0003(\u0005Q4\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5O_R\u001cun\u001c:eS:\fGo\u001c:P]&s\u0017\u000e\u001e)jI^CWM\u001c(pi\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0004_\t\u001d\u0012\u0001S:i_VdGMU3ta>tGmV5uQ\u000e{wN\u001d3j]\u0006$xN\u001d'pC\u0012Le\u000e\u0015:pOJ,7o](o\u0013:LG\u000fU5e/\",gnQ8pe\u0012Lg\u000e^8s\u0019>\fG-\u001b8hQ\r\u0001$qE\u0001\\g\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRD\u0017J\u001c<bY&$\u0007+\u001b3NCB\u0004\u0018N\\4P]\u0006#G\rU1si&$\u0018n\u001c8t)>$&/\u00198tC\u000e$\u0018n\u001c8XQ\u0016tGK]1og\u0006\u001cG/[8oC2LEMT8u!J,7/\u001a8uQ\r\t$qE\u0001Tg\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRD\u0017J\u001c<bY&$'+Z9vKN$\u0018\t\u001a3QCJ$\u0018\u000e^5p]N$v\u000e\u0016:b]N\f7\r^5p]^CWM\u001c+sC:\u001c\u0018m\u0019;j_:\fG.\u00133Jg\u0016k\u0007\u000f^=)\u0007I\u00129#\u0001*tQ>,H\u000e\u001a*fgB|g\u000eZ,ji\"LeN^1mS\u0012\u0014V-];fgR\fE\r\u001a)beRLG/[8ogR{GK]1og\u0006\u001cG/[8o/\",g\u000e\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ%t\u001dVdG\u000eK\u00024\u0005O\t\u0001i\u001d5pk2$'+Z:q_:$w+\u001b;i\u001d>$8i\\8sI&t\u0017\r^8s\u001f:\fE\r\u001a)beRLG/[8og^CWM\u001c(pi\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0004i\t\u001d\u0012AT:i_VdGMU3ta>tGmV5uQ\u000e{wN\u001d3j]\u0006$xN\u001d'pC\u0012Le\u000e\u0015:pOJ,7o](o\u0003\u0012$\u0007+\u0019:uSRLwN\\:XQ\u0016t7i\\8sI&tGo\u001c:M_\u0006$\u0017N\\4)\u0007U\u00129#\u0001(tQ>,H\u000e\u001a*fgB|g\u000eZ,ji\"\u001cuN\\2veJ,g\u000e\u001e+sC:\u001c\u0018m\u0019;j_:\u001cxJ\\!eIB\u000b'\u000f^5uS>t7o\u00165f]N#\u0018\r^3JgB\u0013X\r]1sK\u000e{W.\\5uQ\r1$qE\u0001Mg\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRD7i\u001c8dkJ\u0014XM\u001c;Ue\u0006t7/Y2uS>twJ\\!eIB\u000b'\u000f^5uS>t7o\u00165f]N#\u0018\r^3JgB\u0013X\r]1sK\u0006\u0013wN\u001d;)\u0007]\u00129#\u0001\u0010wC2LG-\u0019;f\u0007>t7-\u001e:sK:$HK]1og\u0006\u001cG/[8ogR!\u00111\u0003B4\u0011\u001d\u0011I\u0007\u000fa\u0001\u0005W\nQa\u001d;bi\u0016\u00042!\u001dB7\u0013\r\u0011y\u0007\u0019\u0002\u0011)J\fgn]1di&|gn\u0015;bi\u0016\fAj\u001d5pk2$'+Z:q_:$w+\u001b;i\u0013:4\u0018\r\\5e):D\bK]8ek\u000e,W\t]8dQ>s\u0017\t\u001a3QCJ$\u0018\u000e^5p]N<\u0006.\u001a8Fa>\u001c\u0007n]!sK\u0012KgMZ3sK:$\bfA\u001d\u0003(\u0005q4\u000f[8vY\u0012\f\u0005\u000f]3oI:+w/T3uC\u0012\fG/\u0019+p\u0019><wJ\\!eIB\u000b'\u000f^5uS>t7o\u00165f]B\u000b'\u000f^5uS>t7/\u00113eK\u0012D3A\u000fB\u0014\u0003e\u001a\bn\\;mIJ+7\u000f]8oI^KG\u000f[*vG\u000e,7o](o\u0003\u0012$\u0007+\u0019:uSRLwN\\:XQ\u0016t7\u000b^1uK&\u001bxJ\\4pS:<\u0007fA\u001e\u0003(\u0005\u00015\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5Tk\u000e\u001cWm]:P]\u0006#G\rU1si&$\u0018n\u001c8t/\",gn\u0015;bi\u0016L5oQ8na2,G/Z\"p[6LG\u000fK\u0002=\u0005O\tqh\u001d5pk2$'+Z:q_:$w+\u001b;i'V\u001c7-Z:t\u001f:\fE\r\u001a)beRLG/[8og^CWM\\*uCR,\u0017j]\"p[BdW\r^3BE>\u0014H\u000fK\u0002>\u0005O\tqD^1mS\u0012\fG/Z*vG\u000e,7o\u001d4vY\u0006#G\rU1si&$\u0018n\u001c8t)\u0011\t\u0019B!#\t\u000f\t-e\b1\u0001\u0003l\u0005i\u0001O]3wS>,8o\u0015;bi\u0016\f\u0011j\u001d5pk2$'+Z:q_:$w+\u001b;i\u000bJ\u0014xN]:O_:,wJ\\!eIB\u000b'\u000f^5uS>tw\u000b[3o\u001d>,%O]8sg\u0006sG\rU1si&$\u0018n\u001c8t)\",7+Y7fQ\ry$qE\u0001=g\"|W\u000f\u001c3SKBd\u0017pV5uQ&sg/\u00197jIBKG-T1qa&twm\u00148F]\u0012$\u0006P\\,iK:$\u0006P\\%e\t>,7O\u001c;Fq&\u001cH\u000fK\u0002A\u0005O\t\u0001i\u001d5pk2$'+\u001a9ms^KG\u000f[%om\u0006d\u0017\u000e\u001a)jI6\u000b\u0007\u000f]5oO>sWI\u001c3Uq:<\u0006.\u001a8QS\u0012$un]3oi6\u000bGo\u00195NCB\u0004X\r\u001a\u0015\u0004\u0003\n\u001d\u0012\u0001R:i_VdGMU3qYf<\u0016\u000e\u001e5Qe>$WoY3s\r\u0016t7-\u001a3P]\u0016sG\r\u0016=o/\",g.\u00129pG\"L5OT8u'\u0006lW-Q:Ue\u0006t7/Y2uS>t\u0007f\u0001\"\u0003(\u0005\t5\u000f[8vY\u0012\u0014V\r^;s]>[wJ\\#oIRChn\u00165f]N#\u0018\r^;t\u0013N\u001cu.\u001c9mKR,7i\\7nSR\fe\u000e\u001a*fgVdG/S:D_6l\u0017\u000e\u001e\u0015\u0004\u0007\n\u001d\u0012aP:i_VdGMU3ukJtwj[(o\u000b:$G\u000b\u001f8XQ\u0016t7\u000b^1ukNL5oQ8na2,G/Z!c_J$\u0018I\u001c3SKN,H\u000e^%t\u0003\n|'\u000f\u001e\u0015\u0004\t\n\u001d\u0012\u0001W:i_VdGMU3ukJt\u0017J\u001c<bY&$G\u000b\u001f8SKF,Xm\u001d;P]\u0016sG\r\u0016=o%\u0016\fX/Z:u/\",gn\u0015;biV\u001c\u0018j]\"p[BdW\r^3BE>\u0014H/\u00118e%\u0016\u001cX\u000f\u001c;Jg:{G/\u00112peRD3!\u0012B\u0014\u0003i\u001b\bn\\;mIJ+G/\u001e:o\u0013:4\u0018\r\\5e)bt'+Z9vKN$xJ\\#oIRChNU3rk\u0016\u001cHo\u00165f]N#\u0018\r^;t\u0013N\u001cu.\u001c9mKR,7i\\7nSR\fe\u000e\u001a*fgVdG/S:O_R\u001cu.\\7ji\"\u001aaIa\n\u0002\u0011NDw.\u001e7e%\u0016$XO\u001d8D_:\u001cWO\u001d:f]R$\u0006P\u001c*fcV,7\u000f^(o\u000b:$G\u000b\u001f8SKF,Xm\u001d;XQ\u0016t7\u000b^1ukNL5\u000f\u0015:fa\u0006\u0014XmQ8n[&$\bfA$\u0003(\u0005!5\u000f[8vY\u0012\u0014V\r^;s]&sg/\u00197jIRChNU3rk\u0016\u001cHo\u00148F]\u0012$\u0006P\u001c*fcV,7\u000f^,iK:\u001cF/\u0019;vg&\u001b\bK]3qCJ,\u0017IY8si\"\u001a\u0001Ja\n\u0002\u0015NDw.\u001e7e\u0003B\u0004XM\u001c3Qe\u0016\u0004\u0018M]3D_6l\u0017\u000e\u001e+p\u0019><wJ\\#oIRChn\u00165f]N#\u0018\r^;t\u0013N|enZ8j]\u001e\fe\u000e\u001a*fgVdG/S:D_6l\u0017\u000e\u001e\u0015\u0004\u0013\n\u001d\u0012\u0001S:i_VdG-\u00119qK:$\u0007K]3qCJ,\u0017IY8siR{Gj\\4P]\u0016sG\r\u0016=o/\",gn\u0015;biV\u001c\u0018j](oO>LgnZ!oIJ+7/\u001e7u\u0013N\f%m\u001c:uQ\rQ%qE\u0001Ag\"|W\u000f\u001c3SKN\u0004xN\u001c3XSRD\u0017J\u001c<bY&$'+Z9vKN$xJ\\#oIRChn\u00165f]R\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012L5OT;mY\"\u001a1Ja\n\u0002\u0003NDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\b.\u00138wC2LGMU3rk\u0016\u001cHo\u00148F]\u0012$\u0006P\\,iK:$&/\u00198tC\u000e$\u0018n\u001c8bY&#\u0017j]#naRL\bf\u0001'\u0003(\u0005\u00015\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5O_R\u001cun\u001c:eS:\fGo\u001c:P]\u0016sG\r\u0016=o/\",g.S:O_R\u001cun\u001c:eS:\fGo\u001c:G_JLE\rK\u0002N\u0005O\t!j\u001d5pk2$'+Z:q_:$w+\u001b;i\u0007>|'\u000fZ5oCR|'\u000fT8bI&s\u0007K]8he\u0016\u001c8o\u00148F]\u0012$\u0006P\\,iK:\u001cun\u001c:eS:\fGo\u001c:Jg2{\u0017\rZ5oO\"\u001aaJa\n\u0002!NDw.\u001e7e\u0013:\u001c'/Z7f]R,\u0005o\\2i\u0003:$W\u000b\u001d3bi\u0016lU\r^1eCR\fwJ\u001c%b]\u0012dW-\u00138jiBKGm\u00165f]\u0016C\u0018n\u001d;j]\u001e,U\u000e\u001d;z)J\fgn]1di&|g\u000eK\u0002P\u0005O\t1k\u001d5pk2$\u0017J\\2sK6,g\u000e^#q_\u000eD\u0017I\u001c3Va\u0012\fG/Z'fi\u0006$\u0017\r^1P]\"\u000bg\u000e\u001a7f\u0013:LG\u000fU5e/\",g.\u0012=jgRLgnZ\"p[BdW\r^3Ue\u0006t7/Y2uS>t\u0007f\u0001)\u0003(\u0005I6\u000f[8vY\u0012Len\u0019:f[\u0016tG/\u00129pG\"\fe\u000eZ+qI\u0006$X-T3uC\u0012\fG/Y(o\u0011\u0006tG\r\\3J]&$\b+\u001b3XQ\u0016tW\t_5ti&twmQ8na2,G/Z\"p[6LG\u000f\u0016:b]N\f7\r^5p]\"\u001a\u0011Ka\n\u0002-NDw.\u001e7e/\u0006LGOR8s\u0007>lW.\u001b;U_\u000e{W\u000e\u001d7fi\u0016|e\u000eS1oI2,\u0017J\\5u!&$\u0017I\u001c3Fq&\u001cH/\u001b8h)J\fgn]1di&|g.\u00138Qe\u0016\u0004\u0018M]3D_6l\u0017\u000e^*uCR,\u0007f\u0001*\u0003(\u0005)6\u000f[8vY\u0012<\u0016-\u001b;G_J\u001cu.\\7jiR{7i\\7qY\u0016$Xm\u00148IC:$G.Z%oSR\u0004\u0016\u000eZ!oI\u0016C\u0018n\u001d;j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8J]B\u0013X\r]1sK\u0006\u0013wN\u001d;Ti\u0006$X\rK\u0002T\u0005O\t!j\u001d5pk2$\u0017IY8siR\u0013\u0018M\\:bGRLwN\\(o\u0011\u0006tG\r\\3J]&$\b+\u001b3XQ\u0016tW\t_5ti&tw\r\u0016:b]N\f7\r^5p]&swJ\\4pS:<7\u000b^1uK\"\u001aAKa\n\u0002_MDw.\u001e7e+N,G*Y:u\u000bB|7\r\u001b+p\r\u0016t7-Z,iK:,\u0005o\\2ig\u0006\u0013X-\u0012=iCV\u001cH/\u001a3)\u0007U\u00139#\u0001\u0019tQ>,H\u000e\u001a*f[>4X\r\u0016:b]N\f7\r^5p]N4uN\u001d)beRLG/[8o\u001f:,U.[4sCRLwN\u001c\u0015\u0004-\n\u001d\u0012\u0001O:i_VdG-\u00112peR,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8t\u0013:|enZ8j]\u001e\u001cF/\u0019;f\u0003:$')^7q\u000bB|7\r\u001b\u0015\u0004/\n\u001d\u0012\u0001Q:i_VdGMT8u\u0003\n|'\u000f^#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cH\u000b[1u\u0011\u00064X-\u0011)f]\u0012LgnZ*uCR,GK]1og&$\u0018n\u001c8)\u0007a\u00139#A#wC2LG-\u0019;f%\u0016\u001c\bo\u001c8eg^KG\u000f[\"p]\u000e,(O]3oiR\u0013\u0018M\\:bGRLwN\\:P]&s\u0017\u000e\u001e)jI^CWM\\%o!J,\u0007/\u0019:f'R\fG/\u001a\u000b\u0005\u0003'\u0011I\u0010C\u0004\u0003je\u0003\rAa\u001b\u0002OY\fG.\u001b3bi\u0016Len\u0019:f[\u0016tG/\u00129pG\"\fe\u000eZ+qI\u0006$X-T3uC\u0012\fG/\u0019\u000b\u0005\u0003'\u0011y\u0010C\u0004\u0003ji\u0003\rAa\u001b\u0002\u00175|7m\u001b)sKB\f'/\u001a\u000b\u0007\u0003'\u001a)a!\u0003\t\u000f\r\u001d1\f1\u0001\u0003l\u0005\u0001BO]1og\u0006\u001cG/[8o'R\fG/\u001a\u0005\n\u0007\u0017Y\u0006\u0013!a\u0001\u0007\u001b\t1B];o\u0007\u0006dGNY1dWB\u0019\u0011na\u0004\n\u0007\rE!NA\u0004C_>dW-\u00198\u0002+5|7m\u001b)sKB\f'/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u0003\u0016\u0005\u0007\u001b\u0019Ib\u000b\u0002\u0004\u001cA!1QDB\u0014\u001b\t\u0019yB\u0003\u0003\u0004\"\r\r\u0012!C;oG\",7m[3e\u0015\r\u0019)C[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0015\u0007?\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003iIg.\u001b;Qe>$WoY3s\u0013\u0012lunY6DC2d'-Y2l)\u0011\t\u0019ba\f\t\u000f\rER\f1\u0001\u0002l\u0006\u0019!/\u001a;\u0002\u001d\u0015\u0014(o\u001c:t\u0007\u0006dGNY1dWR!\u00111CB\u001c\u0011\u001d\u0019\tD\u0018a\u0001\u0003O\u0002")
public class TransactionCoordinatorTest {
    private final MockTime time = new MockTime();
    private long nextPid = 0L;
    private final ProducerIdManager pidManager = (ProducerIdManager)EasyMock.createNiceMock(ProducerIdManager.class);
    private final TransactionStateManager transactionManager = (TransactionStateManager)EasyMock.createNiceMock(TransactionStateManager.class);
    private final TransactionMarkerChannelManager transactionMarkerChannelManager = (TransactionMarkerChannelManager)EasyMock.createNiceMock(TransactionMarkerChannelManager.class);
    private final Capture<TransactionMetadata> capturedTxn = EasyMock.newCapture();
    private final Capture<Function1<Errors, BoxedUnit>> capturedErrorsCallback = EasyMock.newCapture();
    private final int brokerId;
    private final int coordinatorEpoch;
    private final String transactionalId;
    private final int producerId;
    private final short producerEpoch;
    private final int txnTimeoutMs;
    private final Set<TopicPartition> partitions = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)}));
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final TransactionCoordinator coordinator = new TransactionCoordinator(this.brokerId(), new TransactionConfig(TransactionConfig$.MODULE$.$lessinit$greater$default$1(), TransactionConfig$.MODULE$.$lessinit$greater$default$2(), TransactionConfig$.MODULE$.$lessinit$greater$default$3(), TransactionConfig$.MODULE$.$lessinit$greater$default$4(), TransactionConfig$.MODULE$.$lessinit$greater$default$5(), TransactionConfig$.MODULE$.$lessinit$greater$default$6(), TransactionConfig$.MODULE$.$lessinit$greater$default$7(), TransactionConfig$.MODULE$.$lessinit$greater$default$8(), TransactionConfig$.MODULE$.$lessinit$greater$default$9(), TransactionConfig$.MODULE$.$lessinit$greater$default$10()), (Scheduler)this.scheduler(), this.pidManager(), this.transactionManager(), this.transactionMarkerChannelManager(), (Time)this.time(), new LogContext());
    private InitProducerIdResult result;
    private Errors error = Errors.NONE;

    public MockTime time() {
        return this.time;
    }

    public long nextPid() {
        return this.nextPid;
    }

    public void nextPid_$eq(long x$1) {
        this.nextPid = x$1;
    }

    public ProducerIdManager pidManager() {
        return this.pidManager;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public TransactionMarkerChannelManager transactionMarkerChannelManager() {
        return this.transactionMarkerChannelManager;
    }

    public Capture<TransactionMetadata> capturedTxn() {
        return this.capturedTxn;
    }

    public Capture<Function1<Errors, BoxedUnit>> capturedErrorsCallback() {
        return this.capturedErrorsCallback;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private String transactionalId() {
        return this.transactionalId;
    }

    private int producerId() {
        return this.producerId;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private MockScheduler scheduler() {
        return this.scheduler;
    }

    public TransactionCoordinator coordinator() {
        return this.coordinator;
    }

    public InitProducerIdResult result() {
        return this.result;
    }

    public void result_$eq(InitProducerIdResult x$1) {
        this.result = x$1;
    }

    public Errors error() {
        return this.error;
    }

    public void error_$eq(Errors x$1) {
        this.error = x$1;
    }

    private void mockPidManager() {
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.pidManager().generateProducerId())).andAnswer((IAnswer)new IAnswer<Object>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public long answer() {
                this.$outer.nextPid_$eq(this.$outer.nextPid() + 1L);
                return this.$outer.nextPid() - 1L;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).anyTimes();
    }

    private void initPidGenericMocks(String transactionalId) {
        this.mockPidManager();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
    }

    @Test
    public void shouldReturnInvalidRequestWhenTransactionalIdIsEmpty() {
        this.mockPidManager();
        EasyMock.replay((Object[])new Object[]{this.pidManager()});
        this.coordinator().handleInitProducerId("", this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.INVALID_REQUEST), (Object)this.result());
        this.coordinator().handleInitProducerId("", this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.INVALID_REQUEST), (Object)this.result());
    }

    @Test
    public void shouldAcceptInitPidAndReturnNextPidWhenTransactionalIdIsNull() {
        this.mockPidManager();
        EasyMock.replay((Object[])new Object[]{this.pidManager()});
        this.coordinator().handleInitProducerId(null, this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(0L, 0, Errors.NONE), (Object)this.result());
        this.coordinator().handleInitProducerId(null, this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(1L, 0, Errors.NONE), (Object)this.result());
    }

    @Test
    public void shouldInitPidWithEpochZeroForNewTransactionalId() {
        this.initPidGenericMocks(this.transactionalId());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$)).once();
        EasyMock.expect((Object)this.transactionManager().putTransactionStateIfNotExists((TransactionMetadata)EasyMock.capture(this.capturedTxn()))).andAnswer((IAnswer)new IAnswer<Either<Errors, CoordinatorEpochAndTxnMetadata>>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public Either<Errors, CoordinatorEpochAndTxnMetadata> answer() {
                Assert.assertTrue((boolean)this.$outer.capturedTxn().hasCaptured());
                return package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.$outer.coordinatorEpoch(), (TransactionMetadata)this.$outer.capturedTxn().getValue()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).once();
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.anyObject(), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public void answer() {
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.pidManager(), this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(this.nextPid() - 1L, 0, Errors.NONE), (Object)this.result());
    }

    @Test
    public void shouldGenerateNewProducerIdIfEpochsExhausted() {
        this.initPidGenericMocks(this.transactionalId());
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), (short)32766, this.txnTimeoutMs(), (TransactionState)Empty$.MODULE$, Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.anyObject(), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public void answer() {
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.pidManager(), this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertNotEquals((long)this.producerId(), (long)this.result().producerId());
        Assert.assertEquals((long)0L, (long)this.result().producerEpoch());
        Assert.assertEquals((Object)Errors.NONE, (Object)this.result().error());
    }

    @Test
    public void shouldRespondWithNotCoordinatorOnInitPidWhenNotCoordinator() {
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.NOT_COORDINATOR), (Object)this.result());
    }

    @Test
    public void shouldRespondWithCoordinatorLoadInProgressOnInitPidWhenCoordintorLoading() {
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.COORDINATOR_LOAD_IN_PROGRESS), (Object)this.result());
    }

    @Test
    public void shouldRespondWithInvalidPidMappingOnAddPartitionsToTransactionWhenTransactionalIdNotPresent() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)1, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_ID_MAPPING, (Object)this.error());
    }

    @Test
    public void shouldRespondWithInvalidRequestAddPartitionsToTransactionWhenTransactionalIdIsEmpty() {
        this.coordinator().handleAddPartitionsToTransaction("", 0L, (short)1, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.error());
    }

    @Test
    public void shouldRespondWithInvalidRequestAddPartitionsToTransactionWhenTransactionalIdIsNull() {
        this.coordinator().handleAddPartitionsToTransaction(null, 0L, (short)1, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.error());
    }

    @Test
    public void shouldRespondWithNotCoordinatorOnAddPartitionsWhenNotCoordinator() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)1, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)this.error());
    }

    @Test
    public void shouldRespondWithCoordinatorLoadInProgressOnAddPartitionsWhenCoordintorLoading() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)1, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)this.error());
    }

    @Test
    public void shouldRespondWithConcurrentTransactionsOnAddPartitionsWhenStateIsPrepareCommit() {
        this.validateConcurrentTransactions((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldRespondWithConcurrentTransactionOnAddPartitionsWhenStateIsPrepareAbort() {
        this.validateConcurrentTransactions((TransactionState)PrepareAbort$.MODULE$);
    }

    public void validateConcurrentTransactions(TransactionState state) {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), 0L, 0, 0, state, Set$.MODULE$.empty(), 0L, 0L)))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)0, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.CONCURRENT_TRANSACTIONS, (Object)this.error());
    }

    @Test
    public void shouldRespondWithInvalidTnxProduceEpochOnAddPartitionsWhenEpochsAreDifferent() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), 0L, 10, 0, (TransactionState)PrepareCommit$.MODULE$, Set$.MODULE$.empty(), 0L, 0L)))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)0, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_EPOCH, (Object)this.error());
    }

    @Test
    public void shouldAppendNewMetadataToLogOnAddPartitionsWhenPartitionsAdded() {
        this.validateSuccessfulAddPartitions((TransactionState)Empty$.MODULE$);
    }

    @Test
    public void shouldRespondWithSuccessOnAddPartitionsWhenStateIsOngoing() {
        this.validateSuccessfulAddPartitions((TransactionState)Ongoing$.MODULE$);
    }

    @Test
    public void shouldRespondWithSuccessOnAddPartitionsWhenStateIsCompleteCommit() {
        this.validateSuccessfulAddPartitions((TransactionState)CompleteCommit$.MODULE$);
    }

    @Test
    public void shouldRespondWithSuccessOnAddPartitionsWhenStateIsCompleteAbort() {
        this.validateSuccessfulAddPartitions((TransactionState)CompleteAbort$.MODULE$);
    }

    public void validateSuccessfulAddPartitions(TransactionState previousState) {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), previousState, Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.anyObject(), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldRespondWithErrorsNoneOnAddPartitionWhenNoErrorsAndPartitionsTheSame() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), 0L, 0, 0, (TransactionState)Empty$.MODULE$, this.partitions(), 0L, 0L)))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleAddPartitionsToTransaction(this.transactionalId(), 0L, (short)0, this.partitions(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReplyWithInvalidPidMappingOnEndTxnWhenTxnIdDoesntExist() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), 0L, (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_ID_MAPPING, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReplyWithInvalidPidMappingOnEndTxnWhenPidDosentMatchMapped() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), 10L, 0, 0, (TransactionState)Ongoing$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), 0L, (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_ID_MAPPING, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReplyWithProducerFencedOnEndTxnWhenEpochIsNotSameAsTransaction() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)Ongoing$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_EPOCH, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnOkOnEndTxnWhenStatusIsCompleteCommitAndResultIsCommit() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)CompleteCommit$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnOkOnEndTxnWhenStatusIsCompleteAbortAndResultIsAbort() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)CompleteAbort$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.ABORT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.NONE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnInvalidTxnRequestOnEndTxnRequestWhenStatusIsCompleteAbortAndResultIsNotAbort() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)CompleteAbort$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnInvalidTxnRequestOnEndTxnRequestWhenStatusIsCompleteCommitAndResultIsNotCommit() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)CompleteCommit$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.ABORT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnConcurrentTxnRequestOnEndTxnRequestWhenStatusIsPrepareCommit() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)PrepareCommit$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.CONCURRENT_TRANSACTIONS, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldReturnInvalidTxnRequestOnEndTxnRequestWhenStatusIsPrepareAbort() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), new TransactionMetadata(this.transactionalId(), (long)this.producerId(), 1, 1, (TransactionState)PrepareAbort$.MODULE$, Set$.MODULE$.empty(), 0L, this.time().milliseconds())))));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), (short)1, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)this.error());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldAppendPrepareCommitToLogOnEndTxnWhenStatusIsOngoingAndResultIsCommit() {
        this.mockPrepare((TransactionState)PrepareCommit$.MODULE$, this.mockPrepare$default$2());
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldAppendPrepareAbortToLogOnEndTxnWhenStatusIsOngoingAndResultIsAbort() {
        this.mockPrepare((TransactionState)PrepareAbort$.MODULE$, this.mockPrepare$default$2());
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), TransactionResult.ABORT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldRespondWithInvalidRequestOnEndTxnWhenTransactionalIdIsNull() {
        this.coordinator().handleEndTransaction(null, 0L, (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.error());
    }

    @Test
    public void shouldRespondWithInvalidRequestOnEndTxnWhenTransactionalIdIsEmpty() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction("", 0L, (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.INVALID_REQUEST, (Object)this.error());
    }

    @Test
    public void shouldRespondWithNotCoordinatorOnEndTxnWhenIsNotCoordinatorForId() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), 0L, (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)this.error());
    }

    @Test
    public void shouldRespondWithCoordinatorLoadInProgressOnEndTxnWhenCoordinatorIsLoading() {
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS));
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleEndTransaction(this.transactionalId(), 0L, (short)0, TransactionResult.COMMIT, (Function1 & Serializable & scala.Serializable)ret -> {
            this.errorsCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS, (Object)this.error());
    }

    @Test
    public void shouldIncrementEpochAndUpdateMetadataOnHandleInitPidWhenExistingEmptyTransaction() {
        this.validateIncrementEpochAndUpdateMetadata((TransactionState)Empty$.MODULE$);
    }

    @Test
    public void shouldIncrementEpochAndUpdateMetadataOnHandleInitPidWhenExistingCompleteTransaction() {
        this.validateIncrementEpochAndUpdateMetadata((TransactionState)CompleteAbort$.MODULE$);
    }

    @Test
    public void shouldIncrementEpochAndUpdateMetadataOnHandleInitPidWhenExistingCompleteCommitTransaction() {
        this.validateIncrementEpochAndUpdateMetadata((TransactionState)CompleteCommit$.MODULE$);
    }

    @Test
    public void shouldWaitForCommitToCompleteOnHandleInitPidAndExistingTransactionInPrepareCommitState() {
        this.validateRespondsWithConcurrentTransactionsOnInitPidWhenInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWaitForCommitToCompleteOnHandleInitPidAndExistingTransactionInPrepareAbortState() {
        this.validateRespondsWithConcurrentTransactionsOnInitPidWhenInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldAbortTransactionOnHandleInitPidWhenExistingTransactionInOngoingState() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.transactionManager().putTransactionStateIfNotExists((TransactionMetadata)EasyMock.anyObject())).andReturn((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))).anyTimes();
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata)))).anyTimes();
        TransactionMetadata originalMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), (short)(this.producerEpoch() + 1), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)originalMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds())), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public void answer() {
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.CONCURRENT_TRANSACTIONS), (Object)this.result());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldUseLastEpochToFenceWhenEpochsAreExhausted() {
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), (short)32766, this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.transactionManager().putTransactionStateIfNotExists((TransactionMetadata)EasyMock.anyObject())).andReturn((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata))).anyTimes();
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata)))).anyTimes();
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)new TxnTransitMetadata((long)this.producerId(), Short.MAX_VALUE, this.txnTimeoutMs(), (TransactionState)PrepareAbort$.MODULE$, this.partitions().toSet(), this.time().milliseconds(), this.time().milliseconds())), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionCoordinatorTest $outer;

            public void answer() {
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), this.txnTimeoutMs(), (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)32767L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.CONCURRENT_TRANSACTIONS), (Object)this.result());
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldRemoveTransactionsForPartitionOnEmigration() {
        this.transactionManager().removeTransactionsForTxnTopicPartition(0, this.coordinatorEpoch());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        this.transactionMarkerChannelManager().removeMarkersForTxnTopicPartition(0);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.transactionManager(), this.transactionMarkerChannelManager()});
        this.coordinator().onResignation(0, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)this.coordinatorEpoch())));
        EasyMock.verify((Object[])new Object[]{this.transactionManager(), this.transactionMarkerChannelManager()});
    }

    @Test
    public void shouldAbortExpiredTransactionsInOngoingStateAndBumpEpoch() {
        long now = this.time().milliseconds();
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), now, now);
        EasyMock.expect((Object)this.transactionManager().timedOutTransactions()).andReturn((Object)new .colon.colon((Object)new TransactionalIdAndProducerIdEpoch(this.transactionalId(), (long)this.producerId(), this.producerEpoch()), (List)Nil$.MODULE$));
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), txnMetadata)))).times(2);
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        TxnTransitMetadata expectedTransition = new TxnTransitMetadata((long)this.producerId(), bumpedEpoch, this.txnTimeoutMs(), (TransactionState)PrepareAbort$.MODULE$, this.partitions().toSet(), now, now + (long)TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs());
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)expectedTransition), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null){

            public void answer() {
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.transactionManager(), this.transactionMarkerChannelManager()});
        this.coordinator().startup(false);
        this.time().sleep((long)TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    @Test
    public void shouldNotAbortExpiredTransactionsThatHaveAPendingStateTransition() {
        TransactionMetadata metadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
        metadata.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().timedOutTransactions()).andReturn((Object)new .colon.colon((Object)new TransactionalIdAndProducerIdEpoch(this.transactionalId(), (long)this.producerId(), this.producerEpoch()), (List)Nil$.MODULE$));
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), metadata)))).once();
        EasyMock.replay((Object[])new Object[]{this.transactionManager(), this.transactionMarkerChannelManager()});
        this.coordinator().startup(false);
        this.time().sleep((long)TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.transactionManager()});
    }

    private void validateRespondsWithConcurrentTransactionsOnInitPidWhenInPrepareState(TransactionState state) {
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        TransactionMetadata metadata = new TransactionMetadata(this.transactionalId(), 0L, 0, 0, state, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 1)})), 0L, 0L);
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), metadata)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.transactionManager()});
        this.coordinator().handleInitProducerId(this.transactionalId(), 10, (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult(-1L, -1, Errors.CONCURRENT_TRANSACTIONS), (Object)this.result());
    }

    private void validateIncrementEpochAndUpdateMetadata(TransactionState state) {
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)this.pidManager().generateProducerId())).andReturn((Object)BoxesRunTime.boxToLong((long)this.producerId())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.transactionManager().validateTransactionTimeoutMs(EasyMock.anyInt()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        TransactionMetadata metadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), state, Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), metadata))));
        Capture capturedNewMetadata = EasyMock.newCapture();
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.capture((Capture)capturedNewMetadata), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, metadata, capturedNewMetadata){
            private final /* synthetic */ TransactionCoordinatorTest $outer;
            private final TransactionMetadata metadata$1;
            private final Capture capturedNewMetadata$1;

            public void answer() {
                this.metadata$1.completeTransitionTo((TxnTransitMetadata)this.capturedNewMetadata$1.getValue());
                ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metadata$1 = metadata$1;
                this.capturedNewMetadata$1 = capturedNewMetadata$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.pidManager(), this.transactionManager()});
        int newTxnTimeoutMs = 10;
        this.coordinator().handleInitProducerId(this.transactionalId(), newTxnTimeoutMs, (Function1 & Serializable & scala.Serializable)ret -> {
            this.initProducerIdMockCallback(ret);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)new InitProducerIdResult((long)this.producerId(), (short)(this.producerEpoch() + 1), Errors.NONE), (Object)this.result());
        Assert.assertEquals((long)newTxnTimeoutMs, (long)metadata.txnTimeoutMs());
        Assert.assertEquals((long)this.time().milliseconds(), (long)metadata.txnLastUpdateTimestamp());
        Assert.assertEquals((long)((short)(this.producerEpoch() + 1)), (long)metadata.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)metadata.producerId());
    }

    private TransactionMetadata mockPrepare(TransactionState transactionState, boolean runCallback) {
        long now = this.time().milliseconds();
        TransactionMetadata originalMetadata = new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (TransactionState)Ongoing$.MODULE$, this.partitions(), now, now);
        TxnTransitMetadata transition = new TxnTransitMetadata((long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), transactionState, this.partitions().toSet(), now, now);
        EasyMock.expect((Object)this.transactionManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), originalMetadata)))).once();
        this.transactionManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)transition), (Function1)EasyMock.capture(this.capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, runCallback){
            private final /* synthetic */ TransactionCoordinatorTest $outer;
            private final boolean runCallback$1;

            public void answer() {
                if (this.runCallback$1) {
                    ((Function1)this.$outer.capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.runCallback$1 = runCallback$1;
            }
        }).once();
        return new TransactionMetadata(this.transactionalId(), (long)this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), transactionState, this.partitions(), this.time().milliseconds(), this.time().milliseconds());
    }

    private boolean mockPrepare$default$2() {
        return false;
    }

    public void initProducerIdMockCallback(InitProducerIdResult ret) {
        this.result_$eq(ret);
    }

    public void errorsCallback(Errors ret) {
        this.error_$eq(ret);
    }

    public TransactionCoordinatorTest() {
        this.brokerId = 0;
        this.coordinatorEpoch = 0;
        this.transactionalId = "known";
        this.producerId = 10;
        this.producerEpoch = 1;
        this.txnTimeoutMs = 1;
    }
}

