/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogUtils$;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.RollParams;
import kafka.server.FetchDataInfo;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011\b\u0003\u0004F\u0001\u0001\u0006IA\u000f\u0005\b\r\u0002\u0011\r\u0011\"\u0001H\u0011\u0019\u0019\u0006\u0001)A\u0005\u0011\"IA\u000b\u0001a\u0001\u0002\u0004%\t!\u0016\u0005\n=\u0002\u0001\r\u00111A\u0005\u0002}C\u0011\"\u001a\u0001A\u0002\u0003\u0005\u000b\u0015\u0002,\t\u000b\u0019\u0004A\u0011A4\t\u000fi\u0004\u0011\u0013!C\u0001w\"I\u0011Q\u0002\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!!\u0016\u0001\t\u0003\t)\u0005C\u0004\u0002`\u0001!\t!!\u0012\t\u000f\u0005%\u0004\u0001\"\u0001\u0002F!9\u0011Q\u000e\u0001\u0005\u0002\u0005\u0015\u0003bBA9\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003k\u0002A\u0011AA#\u0011\u001d\tI\b\u0001C\u0001\u0003\u000bBq!! \u0001\t\u0003\t)\u0005C\u0004\u0002\u0002\u0002!\t!!\u0012\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002F!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005\u0015\u0003bBAG\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003#\u0003A\u0011AA#\u0011\u001d\t)\n\u0001C\u0001\u0003\u000bBq!!'\u0001\t\u0013\tY\n\u0003\u0005\u0002D\u0002\t\n\u0011\"\u0003|\u0011!\t)\rAI\u0001\n\u0013Y\b\"CAd\u0001E\u0005I\u0011BAe\u0011\u001d\ti\r\u0001C\u0001\u0003\u000bBq!!5\u0001\t\u0003\t)\u0005\u0003\u0004g\u0001\u0011%\u0011Q\u001b\u0005\b\u0003[\u0004A\u0011AA#\u0011\u001d\t\t\u0010\u0001C\u0001\u0003\u000bBq!!>\u0001\t\u0003\t)\u0005C\u0004\u0002z\u0002!\t!!\u0012\u0003\u001d1{wmU3h[\u0016tG\u000fV3ti*\u0011\u0011FK\u0001\u0004Y><'\"A\u0016\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0004CA\u001c\u0001\u001b\u0005A\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002uA\u00111hQ\u0007\u0002y)\u0011QHP\u0001\u0007G>lWn\u001c8\u000b\u0005-z$B\u0001!B\u0003\u0019\t\u0007/Y2iK*\t!)A\u0002pe\u001eL!\u0001\u0012\u001f\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u0005tK\u001elWM\u001c;t+\u0005A\u0005cA%O!6\t!J\u0003\u0002L\u0019\u00069Q.\u001e;bE2,'BA'1\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001f*\u00131\"\u0011:sCf\u0014UO\u001a4feB\u0011q'U\u0005\u0003%\"\u0012!\u0002T8h'\u0016<W.\u001a8u\u0003%\u0019XmZ7f]R\u001c\b%\u0001\u0004m_\u001e$\u0015N]\u000b\u0002-B\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0003S>T\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^1\n!a)\u001b7f\u0003)awn\u001a#je~#S-\u001d\u000b\u0003A\u000e\u0004\"aL1\n\u0005\t\u0004$\u0001B+oSRDq\u0001Z\u0004\u0002\u0002\u0003\u0007a+A\u0002yIE\nq\u0001\\8h\t&\u0014\b%A\u0007de\u0016\fG/Z*fO6,g\u000e\u001e\u000b\u0005!\"l'\u000fC\u0003j\u0013\u0001\u0007!.\u0001\u0004pM\u001a\u001cX\r\u001e\t\u0003_-L!\u0001\u001c\u0019\u0003\t1{gn\u001a\u0005\b]&\u0001\n\u00111\u0001p\u0003IIg\u000eZ3y\u0013:$XM\u001d<bY\nKH/Z:\u0011\u0005=\u0002\u0018BA91\u0005\rIe\u000e\u001e\u0005\bg&\u0001\n\u00111\u0001u\u0003\u0011!\u0018.\\3\u0011\u0005UDX\"\u0001<\u000b\u0005]d\u0014!B;uS2\u001c\u0018BA=w\u0005\u0011!\u0016.\\3\u0002/\r\u0014X-\u0019;f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012\u0012T#\u0001?+\u0005=l8&\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003%)hn\u00195fG.,GMC\u0002\u0002\bA\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY!!\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\fde\u0016\fG/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u0003\u0016\u0003iv\fqA]3d_J$7\u000f\u0006\u0004\u0002\u0018\u0005\r\u0012Q\u0005\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004\u001f\u0002\rI,7m\u001c:e\u0013\u0011\t\t#a\u0007\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u0015IG\u00021\u0001k\u0011\u001d\t\u0019\u0002\u0004a\u0001\u0003O\u0001RaLA\u0015\u0003[I1!a\u000b1\u0005)a$/\u001a9fCR,GM\u0010\t\u0005\u0003_\tiD\u0004\u0003\u00022\u0005e\u0002cAA\u001aa5\u0011\u0011Q\u0007\u0006\u0004\u0003oa\u0013A\u0002\u001fs_>$h(C\u0002\u0002<A\na\u0001\u0015:fI\u00164\u0017\u0002BA \u0003\u0003\u0012aa\u0015;sS:<'bAA\u001ea\u0005)1/\u001a;vaR\t\u0001\rK\u0002\u000e\u0003\u0013\u0002B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001f\n\u0015!\u00026v]&$\u0018\u0002BA*\u0003\u001b\u0012aAQ3g_J,\u0017\u0001\u0003;fCJ$wn\u001e8)\u00079\tI\u0006\u0005\u0003\u0002L\u0005m\u0013\u0002BA/\u0003\u001b\u0012Q!\u00114uKJ\fa\u0003^3tiJ+\u0017\rZ(o\u000b6\u0004H/_*fO6,g\u000e\u001e\u0015\u0004\u001f\u0005\r\u0004\u0003BA&\u0003KJA!a\u001a\u0002N\t!A+Z:u\u0003e!Xm\u001d;SK\u0006$')\u001a4pe\u00164\u0015N]:u\u001f\u001a47/\u001a;)\u0007A\t\u0019'A\tuKN$(+Z1e\u0003\u001a$XM\u001d'bgRD3!EA2\u0003=!Xm\u001d;SK\u0006$gI]8n\u000f\u0006\u0004\bf\u0001\n\u0002d\u0005aA/Z:u)J,hnY1uK\"\u001a1#a\u0019\u00021Q,7\u000f\u001e+sk:\u001c\u0017\r^3F[B$\u0018pU3h[\u0016tG\u000fK\u0002\u0015\u0003G\na\u0007^3tiJ+Gn\\1e\u0019\u0006\u0014x-Z:u)&lWm\u001d;b[B\fe\u000e\u001a(fqR|eMZ:fi\u00063G/\u001a:UeVt7-\u0019;j_:D3!FA2\u0003A!Xm\u001d;UeVt7-\u0019;f\rVdG\u000eK\u0002\u0017\u0003G\n\u0011\u0004^3ti\u001aKg\u000eZ(gMN,GOQ=US6,7\u000f^1na\"\u001aq#a\u0019\u00023Q,7\u000f\u001e(fqR|eMZ:fi\u000e\u000bGnY;mCRLwN\u001c\u0015\u00041\u0005\r\u0014A\u0006;fgR\u001c\u0005.\u00198hK\u001aKG.Z*vM\u001aL\u00070Z:)\u0007e\t\u0019'A\u000fuKN$(+Z2pm\u0016\u0014\u0018PR5yKN\u001cuN\u001d:vaRLe\u000eZ3yQ\rQ\u00121M\u0001\u001ci\u0016\u001cHOU3d_Z,'\u000f\u0016:b]N\f7\r^5p]&sG-\u001a=)\u0007m\t\u0019'A\u0007f]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u000b\u0011\u0003/\ti*a*\u0002,\u0006U\u0016qWA^\u0003\u007fCq!a(\u001d\u0001\u0004\t\t+A\td_:$(o\u001c7SK\u000e|'\u000f\u001a+za\u0016\u0004B!!\u0007\u0002$&!\u0011QUA\u000e\u0005E\u0019uN\u001c;s_2\u0014VmY8sIRK\b/\u001a\u0005\u0007\u0003Sc\u0002\u0019\u00016\u0002\u0015A\u0014x\u000eZ;dKJLE\rC\u0004\u0002.r\u0001\r!a,\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\ry\u0013\u0011W\u0005\u0004\u0003g\u0003$!B*i_J$\b\"B5\u001d\u0001\u0004Q\u0007\u0002CA]9A\u0005\t\u0019A8\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0011!\ti\f\bI\u0001\u0002\u0004y\u0017\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011!\t\t\r\bI\u0001\u0002\u0004Q\u0017!\u0003;j[\u0016\u001cH/Y7q\u0003])g\u000e\u001a+y]J+7m\u001c:eg\u0012\"WMZ1vYR$S'A\ff]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u00059RM\u001c3Uq:\u0014VmY8sIN$C-\u001a4bk2$HeN\u000b\u0003\u0003\u0017T#A[?\u0002CQ,7\u000f\u001e*fG>4XM]=GSb,7oQ8seV\u0004H\u000fV5nK&sG-\u001a=)\u0007\u0001\n\u0019'\u0001\u0010uKN$(+Z2pm\u0016\u0014\u0018pV5uQ\u000e{'O];qi6+7o]1hK\"\u001a\u0011%a\u0019\u0015\u0013A\u000b9.a7\u0002f\u0006%\bBBAmE\u0001\u0007!.\u0001\u0006cCN,wJ\u001a4tKRDq!!8#\u0001\u0004\ty.A\tgS2,\u0017\t\u001c:fC\u0012LX\t_5tiN\u00042aLAq\u0013\r\t\u0019\u000f\r\u0002\b\u0005>|G.Z1o\u0011\u0019\t9O\ta\u0001_\u0006a\u0011N\\5u\r&dWmU5{K\"9\u00111\u001e\u0012A\u0002\u0005}\u0017a\u00039sK\u0006dGn\\2bi\u0016\fq\u0005^3ti\u000e\u0013X-\u0019;f/&$\b.\u00138ji\u001aKG.Z*ju\u0016\f\u0005\u000f]3oI6+7o]1hK\"\u001a1%a\u0019\u0002OQ,7\u000f^\"sK\u0006$XmV5uQ&s\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3DY\u0016\f'o\u00155vi\u0012|wO\u001c\u0015\u0004I\u0005\r\u0014AL:i_VdG\r\u0016:v]\u000e\fG/Z#wK:Lem\u00144gg\u0016$\bk\\5oiN$v.Q$ba&sG\u000b[3M_\u001eD3!JA2\u0003I!Xm\u001d;BaB,g\u000e\u001a$s_64\u0015\u000e\\3)\u0007\u0019\n\u0019\u0007")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        LogSegment seg = LogUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records) {
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
    }

    @Before
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @After
    public void teardown() {
        this.segments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        FetchDataInfo read = seg.read(40L, 300, seg.read$default$3(), seg.read$default$4());
        Assert.assertNull((String)"Read beyond the last offset in the segment should be null", (Object)read);
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, -1L, -1L, ms);
        Records read = seg.read(41L, 300, seg.read$default$3(), seg.read$default$4()).records();
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        FetchDataInfo read = seg.read(52L, 200, seg.read$default$3(), seg.read$default$4());
        Assert.assertNull((String)"Read beyond the last offset in the segment should give null", (Object)read);
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 30);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogSegmentTest.$anonfun$testTruncate$1(this, offset, seg, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        long x$1 = 0L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.close();
        long x$4 = 0L;
        int x$6 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(x$4, x$6, (Time)time);
        Assert.assertEquals((long)0L, (long)seg.timeIndex().sizeInBytes());
        Assert.assertEquals((long)0L, (long)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assert.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)reopened.timeIndex().isFull());
        Assert.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assert.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assert.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assert.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, (long)Integer.MAX_VALUE + 200L, 1024, time.milliseconds());
        Assert.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numMessages);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogSegmentTest.$anonfun$testReloadLargestTimestampAndNextOffsetAfterTruncation$1(this, seg, offset, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assert.assertEquals((String)new StringBuilder(25).append("Should have ").append(expectedNumEntries).append(" time indexes").toString(), (long)expectedNumEntries, (long)seg.timeIndex().entries());
        seg.truncateTo(41L);
        Assert.assertEquals((String)"Should have 0 time indexes", (long)0L, (long)seg.timeIndex().entries());
        Assert.assertEquals((String)"Largest timestamp should be 400", (long)400L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        long x$1 = 40L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        time.sleep(500L);
        Assert.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assert.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)seg.timeIndex().isFull());
        Assert.assertFalse((boolean)seg.offsetIndex().isFull());
        Assert.assertNull((String)"Segment should be empty.", (Object)seg.read(0L, 1024, seg.read$default$3(), seg.read$default$4()));
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3());
        int n = 40;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 50);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)foreach$mVc$sp_i, (long)(foreach$mVc$sp_i * 10), (long)foreach$mVc$sp_i, this.records(foreach$mVc$sp_i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("msg").append(foreach$mVc$sp_i).toString()})));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Assert.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)42L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)420L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)421L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)430L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)44L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)431L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L, seg.findOffsetByTimestamp$default$2()));
        Assert.assertEquals((long)41L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)401L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)40L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)399L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assert.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, -1L, -1L, this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assert.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        File logFile = seg.log().file();
        File indexFile = seg.lazyOffsetIndex().file();
        seg.changeFileSuffixes("", ".deleted");
        Assert.assertEquals((Object)new StringBuilder(8).append(logFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assert.assertEquals((Object)new StringBuilder(8).append(indexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyOffsetIndex().file().getAbsolutePath());
        Assert.assertTrue((boolean)seg.log().file().exists());
        Assert.assertTrue((boolean)seg.lazyOffsetIndex().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 100);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)foreach$mVc$sp_i, -1L, -1L, this.records(foreach$mVc$sp_i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)foreach$mVc$sp_i)).toString()})));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        File indexFile = seg.lazyOffsetIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range2 = RichInt$.MODULE$.until$extension0(n2, 100);
        if (range2 == null) {
            throw null;
        }
        Range foreach$mVc$sp_this2 = range2;
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                LogSegmentTest.$anonfun$testRecoveryFixesCorruptIndex$2(seg, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
    }

    @Test
    public void testRecoverTransactionIndex() {
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        segment.append(101L, -1L, 100L, MemoryRecords.withTransactionalRecords((long)100L, (CompressionType)CompressionType.NONE, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(103L, -1L, 102L, MemoryRecords.withTransactionalRecords((long)102L, (CompressionType)CompressionType.NONE, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(105L, -1L, 104L, MemoryRecords.withRecords((long)104L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(partitionLeaderEpoch), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        segment.append(107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        ProducerStateManager stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3());
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{new BatchMetadata(10, 10L, 5, -1L)})), producerEpoch, 0, -1L, (Option)new Some((Object)BoxesRunTime.boxToLong((long)75L))));
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assert.assertEquals((long)1L, (long)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 100);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)foreach$mVc$sp_i, (long)(foreach$mVc$sp_i * 10), (long)foreach$mVc$sp_i, this.records(foreach$mVc$sp_i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)foreach$mVc$sp_i)).toString()})));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        File timeIndexFile = seg.lazyTimeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range2 = RichInt$.MODULE$.until$extension0(n2, 100);
        if (range2 == null) {
            throw null;
        }
        Range foreach$mVc$sp_this2 = range2;
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                LogSegmentTest.$anonfun$testRecoveryFixesCorruptTimeIndex$2(seg, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 10);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogSegmentTest.$anonfun$testRecoveryWithCorruptMessage$1(this, messagesAppended, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        File tempDir = TestUtils$.MODULE$.tempDir();
        Tuple2[] tuple2Array = new Tuple2[3];
        Integer n = BoxesRunTime.boxToInteger((int)10);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Integer n2 = BoxesRunTime.boxToInteger((int)1000);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Integer n3 = BoxesRunTime.boxToInteger((int)0);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        LogConfig logConfig = new LogConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, baseOffset, logConfig, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        File tempDir = TestUtils$.MODULE$.tempDir();
        Tuple2[] tuple2Array = new Tuple2[3];
        Integer n = BoxesRunTime.boxToInteger((int)10);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.IndexIntervalBytesProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Integer n2 = BoxesRunTime.boxToInteger((int)1000);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentIndexBytesProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Integer n3 = BoxesRunTime.boxToInteger((int)0);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentJitterMsProp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        LogConfig logConfig = new LogConfig((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, false, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assert.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assert.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, true, 0x20000000, true, LogSegment$.MODULE$.open$default$8());
        this.segments().$plus$eq((Object)segReopen);
        FetchDataInfo readAgain = segReopen.read(55L, 200, segReopen.read$default$3(), segReopen.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records().records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assert.assertEquals((long)oldPosition, (long)position);
        Assert.assertEquals((long)oldSize, (long)size);
        Assert.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, 10000, seg.read$default$3(), seg.read$default$4());
        Assert.assertEquals((long)offset, (long)((RecordBatch)log.records().batches().iterator().next()).baseOffset());
        Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(log.records().batches()).asScala()).size());
    }

    @Test
    public void testAppendFromFile() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        FileRecords fileRecords = FileRecords.open((File)Log$.MODULE$.logFile(tempDir, 0L, Log$.MODULE$.logFile$default$3()));
        fileRecords.append(LogSegmentTest.records$2(0L, 1024));
        fileRecords.append(LogSegmentTest.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(LogSegmentTest.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assert.assertEquals((long)sizeBeforeOverflow, (long)bytesAppended);
        Assert.assertEquals((long)sizeBeforeOverflow, (long)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assert.assertEquals((long)(sizeAfterOverflow - sizeBeforeOverflow), (long)overflowBytesAppended);
        Assert.assertEquals((long)overflowBytesAppended, (long)overflowSegment.size());
        Utils.delete((File)tempDir);
    }

    public static final /* synthetic */ void $anonfun$testTruncate$1(LogSegmentTest $this, IntRef offset$2, LogSegment seg$1, int _) {
        MemoryRecords ms1 = $this.records(offset$2.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
        seg$1.append((long)offset$2.elem, -1L, -1L, ms1);
        MemoryRecords ms2 = $this.records(offset$2.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
        seg$1.append((long)(offset$2.elem + 1), -1L, -1L, ms2);
        FetchDataInfo read = seg$1.read((long)offset$2.elem, 10000, seg$1.read$default$3(), seg$1.read$default$4());
        Assert.assertEquals((Object)new .colon.colon((Object)((Record)ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read.records().records()).asScala()).toList());
        seg$1.truncateTo((long)(offset$2.elem + 1));
        FetchDataInfo read2 = seg$1.read((long)offset$2.elem, 10000, seg$1.read$default$3(), seg$1.read$default$4());
        Assert.assertEquals((long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records().records()).asScala()).size());
        TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records().records().iterator());
        ++offset$2.elem;
    }

    public static final /* synthetic */ void $anonfun$testReloadLargestTimestampAndNextOffsetAfterTruncation$1(LogSegmentTest $this, LogSegment seg$2, IntRef offset$3, int _) {
        seg$2.append((long)offset$3.elem, (long)offset$3.elem, (long)offset$3.elem, $this.records(offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
        ++offset$3.elem;
    }

    public static final /* synthetic */ void $anonfun$testRecoveryFixesCorruptIndex$2(LogSegment seg$4, int i) {
        long x$1 = i;
        int x$2 = 1;
        boolean x$3 = true;
        long x$4 = seg$4.read$default$3();
        Iterable records = seg$4.read(x$1, x$2, x$4, x$3).records().records();
        Assert.assertEquals((long)i, (long)((Record)records.iterator().next()).offset());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryFixesCorruptTimeIndex$2(LogSegment seg$5, int i) {
        Assert.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)seg$5.findOffsetByTimestamp((long)((long)(i * 10)), (long)seg$5.findOffsetByTimestamp$default$2()).get()).offset);
        if (i < 99) {
            Assert.assertEquals((long)(i + 1), (long)((FileRecords.TimestampAndOffset)seg$5.findOffsetByTimestamp((long)((long)(i * 10 + 1)), (long)seg$5.findOffsetByTimestamp$default$2()).get()).offset);
        }
    }

    public static final /* synthetic */ void $anonfun$testRecoveryWithCorruptMessage$1(LogSegmentTest $this, int messagesAppended$1, int _) {
        LogSegment seg = $this.createSegment(0L, $this.createSegment$default$2(), $this.createSegment$default$3());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, messagesAppended$1);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)foreach$mVc$sp_i, -1L, -1L, $this.records(foreach$mVc$sp_i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)foreach$mVc$sp_i)).toString()})));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended$1);
        int position = seg.log().searchForOffsetWithSize((long)((long)offsetToBeginCorruption), (int)0).position + TestUtils$.MODULE$.random().nextInt(15);
        TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
        seg.recover(new ProducerStateManager($this.topicPartition(), $this.logDir(), ProducerStateManager$.MODULE$.$lessinit$greater$default$3()), seg.recover$default$2());
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Assert.assertEquals((String)"Should have truncated off bad messages.", (Object)RichInt$.MODULE$.until$extension0(n2, offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lastOffset()), Iterable$.MODULE$.canBuildFrom())).toList());
        seg.deleteIfExists();
    }

    private static final MemoryRecords records$1(long offset, String record) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())});
    }

    private static final MemoryRecords records$2(long offset, int size) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new byte[size])});
    }
}

