/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=h\u0001B\"E\u0001%CQ\u0001\u0015\u0001\u0005\u0002ECq\u0001\u0016\u0001A\u0002\u0013\u0005Q\u000bC\u0004_\u0001\u0001\u0007I\u0011A0\t\r\u0015\u0004\u0001\u0015)\u0003W\u0011\u001d1\u0007\u00011A\u0005\u0002\u001dDqa\u001b\u0001A\u0002\u0013\u0005A\u000e\u0003\u0004o\u0001\u0001\u0006K\u0001\u001b\u0005\b_\u0002\u0011\r\u0011\"\u0001q\u0011\u0019a\b\u0001)A\u0005c\"9Q\u0010\u0001b\u0001\n\u0003q\bbBA\u0003\u0001\u0001\u0006Ia \u0005\n\u0003\u000f\u0001!\u0019!C\u0001\u0003\u0013A\u0001\"!\u0005\u0001A\u0003%\u00111\u0002\u0005\n\u0003'\u0001!\u0019!C\u0001\u0003+A\u0001\"a\t\u0001A\u0003%\u0011q\u0003\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\t9\u0004\u0001C\u0001\u0003OAq!!\u0011\u0001\t\u0003\t9\u0003C\u0004\u0002L\u0001!\t!a\n\t\u000f\u0005=\u0003\u0001\"\u0001\u0002(!9\u00111\u000b\u0001\u0005\u0002\u0005\u001d\u0002bBA,\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003W\u0002A\u0011AA\u0014\u0011\u001d\ty\u0007\u0001C\u0001\u0003OAq!a\u001d\u0001\t\u0003\t9\u0003C\u0004\u0002x\u0001!\t!a\n\t\u000f\u0005m\u0004\u0001\"\u0001\u0002(!9\u0011q\u0010\u0001\u0005\u0002\u0005\u001d\u0002bBAB\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003\u000f\u0003A\u0011AA\u0014\u0011\u001d\t\u0019\n\u0001C\u0001\u0003OAq!a&\u0001\t\u0003\t9\u0003C\u0004\u0002\u001c\u0002!\t!a\n\t\u000f\u0005}\u0005\u0001\"\u0001\u0002(!9\u00111\u0015\u0001\u0005\u0002\u0005\u001d\u0002bBAT\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003W\u0003A\u0011AA\u0014\u0011\u001d\t9\f\u0001C\u0001\u0003OAq!a/\u0001\t\u0003\t9\u0003C\u0004\u0002@\u0002!\t!a\n\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002(!9\u0011q\u0019\u0001\u0005\u0002\u0005\u001d\u0002bBAf\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003\u001f\u0004A\u0011AA\u0014\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003OAq!a6\u0001\t\u0003\t9\u0003C\u0004\u0002\\\u0002!\t!a\n\t\u000f\u0005}\u0007\u0001\"\u0001\u0002(!9\u00111\u001d\u0001\u0005\u0002\u0005\u001d\u0002bBAt\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003g\u0004A\u0011AA\u0014\u0011\u001d\t9\u0010\u0001C\u0001\u0003OAqAa\u0001\u0001\t\u0003\t9\u0003C\u0004\u0003\b\u0001!\t!a\n\t\u000f\t-\u0001\u0001\"\u0001\u0002(!9!q\u0002\u0001\u0005\u0002\u0005\u001d\u0002b\u0002B\n\u0001\u0011%!Q\u0003\u0005\b\u0005c\u0001A\u0011\u0002B\u001a\u0011%\u0011i\u0007AI\u0001\n\u0013\u0011y\u0007C\u0005\u0003\u0006\u0002\t\n\u0011\"\u0003\u0003\b\"9!1\u0012\u0001\u0005\n\t5\u0005\"\u0003BY\u0001E\u0005I\u0011\u0002BD\u0011%\u0011\u0019\fAI\u0001\n\u0013\u0011)\fC\u0005\u0003:\u0002\t\n\u0011\"\u0003\u0003<\"9!1\u0012\u0001\u0005\n\t}\u0006b\u0002Bk\u0001\u0011%!q\u001b\u0002\u0019!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:UKN$(BA#G\u0003\rawn\u001a\u0006\u0002\u000f\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001K!\tYe*D\u0001M\u0015\u0005i\u0015!B:dC2\f\u0017BA(M\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0015\t\u0003'\u0002i\u0011\u0001R\u0001\u0007Y><G)\u001b:\u0016\u0003Y\u0003\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\u0005%|'\"A.\u0002\t)\fg/Y\u0005\u0003;b\u0013AAR5mK\u0006QAn\\4ESJ|F%Z9\u0015\u0005\u0001\u001c\u0007CA&b\u0013\t\u0011GJ\u0001\u0003V]&$\bb\u00023\u0004\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\n\u0014a\u00027pO\u0012K'\u000fI\u0001\rgR\fG/Z'b]\u0006<WM]\u000b\u0002QB\u00111+[\u0005\u0003U\u0012\u0013A\u0003\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u0014\u0018\u0001E:uCR,W*\u00198bO\u0016\u0014x\fJ3r)\t\u0001W\u000eC\u0004e\r\u0005\u0005\t\u0019\u00015\u0002\u001bM$\u0018\r^3NC:\fw-\u001a:!\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001r!\t\u0011(0D\u0001t\u0015\t!X/\u0001\u0004d_6lwN\u001c\u0006\u0003\u000fZT!a\u001e=\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0018aA8sO&\u00111p\u001d\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u000baJ|G-^2fe&#W#A@\u0011\u0007-\u000b\t!C\u0002\u0002\u00041\u0013A\u0001T8oO\u0006Y\u0001O]8ek\u000e,'/\u00133!\u0003Ii\u0017\r\u001f)jI\u0016C\b/\u001b:bi&|g.T:\u0016\u0005\u0005-\u0001cA&\u0002\u000e%\u0019\u0011q\u0002'\u0003\u0007%sG/A\nnCb\u0004\u0016\u000eZ#ya&\u0014\u0018\r^5p]6\u001b\b%\u0001\u0003uS6,WCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fg\u0006)Q\u000f^5mg&!\u0011\u0011EA\u000e\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!B:fiV\u0003H#\u00011)\u0007A\tY\u0003\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t\u0004_\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003k\tyC\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001a\u0011#a\u000f\u0011\t\u00055\u0012QH\u0005\u0005\u0003\u007f\tyCA\u0003BMR,'/\u0001\nuKN$()Y:jG&#W*\u00199qS:<\u0007f\u0001\n\u0002FA!\u0011QFA$\u0013\u0011\tI%a\f\u0003\tQ+7\u000f^\u0001'i\u0016\u001cH/\u00119qK:$G\u000b\u001f8NCJ\\WM],ji\"tu\u000e\u0015:pIV\u001cWM]*uCR,\u0007fA\n\u0002F\u0005qB/Z:u!J|G-^2feN+\u0017/^3oG\u0016<&/\u00199Be>,h\u000e\u001a\u0015\u0004)\u0005\u0015\u0013!\f;fgR\u0004&o\u001c3vG\u0016\u00148+Z9vK:\u001cWmV5uQ^\u0013\u0018\r]!s_VtGMQ1uG\"\u0014VmY8sI\"\u001aQ#!\u0012\u0002KQ,7\u000f\u001e)s_\u0012,8-\u001a:TKF,XM\\2f\u0013:4\u0018\r\\5e/J\f\u0007/\u0011:pk:$\u0007f\u0002\f\u0002F\u0005m\u0013QL\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u0011q\f\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011QM:\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\tI'a\u0019\u00037=+Ho\u00144Pe\u0012,'oU3rk\u0016t7-Z#yG\u0016\u0004H/[8o\u0003)\"Xm\u001d;O_Z\u000bG.\u001b3bi&|gn\u00148GSJ\u001cH/\u00128uef<\u0006.\u001a8M_\u0006$\u0017N\\4M_\u001eD3aFA#\u0003m!Xm\u001d;D_:$(o\u001c7SK\u000e|'\u000f\u001a\"v[B\u001cX\t]8dQ\"\u001a\u0001$!\u0012\u0002AQ,7\u000f\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1DC\u000eDW\r\u001a\u0015\u00043\u0005\u0015\u0013\u0001\t;fgRd\u0015m\u001d;Ti\u0006\u0014G.Z(gMN,GoQ8na2,G/\u001a3Uq:D3AGA#\u0003y!Xm\u001d;Qe\u0016\u0004\u0018M]3Va\u0012\fG/\u001a#pKNtu\u000e^'vi\u0006$X\rK\u0002\u001c\u0003\u000b\na$\u001e9eCR,\u0007K]8ek\u000e,'\u000f\u0016:b]N\f7\r^5p]N#\u0018\r^3)\u0007q\t)%\u0001\u0017uKN$x*\u001e;PMN+\u0017/^3oG\u0016\fe\r^3s\u0007>tGO]8m%\u0016\u001cwN\u001d3Fa>\u001c\u0007NQ;na\"\u001aQ$!\u0012\u0002aQ,7\u000f\u001e(p]R\u0013\u0018M\\:bGRLwN\\1m\u0003B\u0004XM\u001c3XSRDwJ\\4pS:<GK]1og\u0006\u001cG/[8oQ\u001dq\u0012QIA.\u0003\u0017\u001b#!!$\u0011\t\u0005\u0005\u0014qR\u0005\u0005\u0003#\u000b\u0019G\u0001\rJ]Z\fG.\u001b3Uq:\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:\fq\u0006^3tiR\u0013XO\\2bi\u0016\fe\u000e\u001a*fY>\fGMU3n_Z,7oT;u\u001f\u001a\u0014\u0016M\\4f':\f\u0007o\u001d5piND3aHA#\u0003A!Xm\u001d;UC.,7K\\1qg\"|G\u000fK\u0002!\u0003\u000b\nA\u0006^3tiJ+7m\u001c<fe\u001a\u0013x.\\*oCB\u001c\bn\u001c;V]\u001aLg.[:iK\u0012$&/\u00198tC\u000e$\u0018n\u001c8)\u0007\u0005\n)%\u0001\u0016uKN$(+Z2pm\u0016\u0014hI]8n':\f\u0007o\u001d5pi\u001aKg.[:iK\u0012$&/\u00198tC\u000e$\u0018n\u001c8)\u0007\t\n)%A\u0014uKN$(+Z2pm\u0016\u0014hI]8n':\f\u0007o\u001d5pi\u0016k\u0007\u000f^=Ue\u0006t7/Y2uS>t\u0007fA\u0012\u0002F\u0005AC/Z:u!J|G-^2feN#\u0018\r^3BMR,'OR3oG&tw-\u00112peRl\u0015M]6fe\"\u001aA%!\u0012\u0002;Q,7\u000f\u001e*f[>4X-\u0012=qSJ,G\rU5eg>s'+\u001a7pC\u0012Ds!JA#\u00037\nyk\t\u0002\u00022B!\u0011\u0011MAZ\u0013\u0011\t),a\u0019\u00035Us7N\\8x]B\u0013x\u000eZ;dKJLE-\u0012=dKB$\u0018n\u001c8\u0002[Q,7\u000f^!dG\u0016\u0004H/\u00119qK:$w+\u001b;i_V$\bK]8ek\u000e,'o\u0015;bi\u0016|eNU3qY&\u001c\u0017\rK\u0002'\u0003\u000b\n\u0011\u0006^3ti\u0006\u001b7-\u001a9u\u0003B\u0004XM\u001c3XSRD7+Z9vK:\u001cWmR1qg>s'+\u001a9mS\u000e\f\u0007fA\u0014\u0002F\u0005IB/Z:u\t\u0016dW\r^3T]\u0006\u00048\u000f[8ug\n+gm\u001c:fQ\rA\u0013QI\u0001\ri\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a\u0015\u0004S\u0005\u0015\u0013A\n;fgR4\u0015N]:u+:\u001cH/\u00192mK>3gm]3u\u0003\u001a$XM\u001d+sk:\u001c\u0017\r^5p]\"\u001a!&!\u0012\u0002]Q,7\u000f\u001e'pC\u00124%o\\7T]\u0006\u00048\u000f[8u%\u0016$\u0018-\u001b8t\u001d>tW\t\u001f9je\u0016$\u0007K]8ek\u000e,'o\u001d\u0015\u0004W\u0005\u0015\u0013!\t;fgR\u001c6.\u001b9T]\u0006\u00048\u000f[8u\u0013\u001a|eMZ:fiVs7\r[1oO\u0016$\u0007f\u0001\u0017\u0002F\u0005yA/Z:u'R\f'\u000f^(gMN,G\u000fK\u0002.\u0003\u000b\n\u0001\u0004^3tiBKG-\u0012=qSJ\fG/[8o)&lWm\\;uQ\u001dq\u0013QIA.\u0003_\u000bq\u0003^3ti\u001aK'o\u001d;V]N$\u0018M\u00197f\u001f\u001a47/\u001a;)\u0007=\n)%\u0001\u0018uKN$\bK]8ek\u000e,'o],ji\"|enZ8j]\u001e$&/\u00198tC\u000e$\u0018n\u001c8t\t>tG/\u0012=qSJ,\u0007f\u0001\u0019\u0002F\u0005iC/Z:u'\u0016\fX/\u001a8dK:{GOV1mS\u0012\fG/\u001a3G_J<%o\\;q\u001b\u0016$\u0018\rZ1uCR{\u0007/[2)\u0007E\n)%\u0001\u000fuKN$x\n\u001c3Fa>\u001c\u0007NR8s\u0007>tGO]8m%\u0016\u001cwN\u001d3)\u000fI\n)%a\u0017\u0002l\u000e\u0012\u0011Q\u001e\t\u0005\u0003C\ny/\u0003\u0003\u0002r\u0006\r$a\u0006)s_\u0012,8-\u001a:GK:\u001cW\rZ#yG\u0016\u0004H/[8o\u0003Y!Xm\u001d;D_>\u0014H-\u001b8bi>\u0014h)\u001a8dS:<\u0007fA\u001a\u0002F\u0005\u0001C/Z:u\u0007>|'\u000fZ5oCR|'OR3oG\u0016$\u0017I\u001a;feJ+Gn\\1eQ\u001d!\u0014QIA.\u0003w\u001c#!!@\u0011\t\u0005\u0005\u0014q`\u0005\u0005\u0005\u0003\t\u0019GA\u0013Ue\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8s\r\u0016t7-\u001a3Fq\u000e,\u0007\u000f^5p]\u0006iB/Z:u\u0019>\fGM\u0012:p[\u0016k\u0007\u000f^=T]\u0006\u00048\u000f[8u\r&dW\rK\u00026\u0003\u000b\n\u0011\u0005^3ti2{\u0017\r\u001a$s_6$&/\u001e8dCR,Gm\u00158baNDw\u000e\u001e$jY\u0016D3ANA#\u0003}!Xm\u001d;M_\u0006$gI]8n\u0007>\u0014(/\u001e9u':\f\u0007o\u001d5pi\u001aKG.\u001a\u0015\u0004o\u0005\u0015\u0013a\u0007;fgR\f\u0005\u000f]3oI\u0016k\u0007\u000f^=D_:$(o\u001c7CCR\u001c\u0007\u000eK\u00029\u0003\u000b\n1\u0004^3ti2{\u0017\r\u001a$s_6\u001cuN\u001d:vaR\u001cf.\u00199tQ>$Hc\u00011\u0003\u0018!9!\u0011D\u001dA\u0002\tm\u0011aD7bW\u00164\u0015\u000e\\3D_J\u0014X\u000f\u001d;\u0011\r-\u0013iB!\ta\u0013\r\u0011y\u0002\u0014\u0002\n\rVt7\r^5p]F\u0002BAa\t\u0003.5\u0011!Q\u0005\u0006\u0005\u0005O\u0011I#\u0001\u0005dQ\u0006tg.\u001a7t\u0015\r\u0011YCW\u0001\u0004]&|\u0017\u0002\u0002B\u0018\u0005K\u00111BR5mK\u000eC\u0017M\u001c8fY\u0006\u0011\u0012\r\u001d9f]\u0012,e\u000e\u001a+y]6\u000b'o[3s)A\u0011)D!\u0011\u0003F\t\u001d#\u0011\u000bB1\u0005K\u0012I\u0007\u0005\u0004L\u0005o\u0011Yd`\u0005\u0004\u0005sa%A\u0002+va2,'\u0007E\u0002T\u0005{I1Aa\u0010E\u00051\u0019u.\u001c9mKR,G\r\u0016=o\u0011\u0019\u0011\u0019E\u000fa\u0001Q\u00069Q.\u00199qS:<\u0007\"B?;\u0001\u0004y\bb\u0002B%u\u0001\u0007!1J\u0001\u000eaJ|G-^2fe\u0016\u0003xn\u00195\u0011\u0007-\u0013i%C\u0002\u0003P1\u0013Qa\u00155peRDqAa\u0015;\u0001\u0004\u0011)&A\u0006d_:$(o\u001c7UsB,\u0007\u0003\u0002B,\u0005;j!A!\u0017\u000b\u0007\tm3/\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005?\u0012IFA\tD_:$(o\u001c7SK\u000e|'\u000f\u001a+za\u0016DaAa\u0019;\u0001\u0004y\u0018AB8gMN,G\u000fC\u0005\u0003hi\u0002\n\u00111\u0001\u0002\f\u0005\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0005\t\u0005WR\u0004\u0013!a\u0001\u007f\u0006IA/[7fgR\fW\u000e]\u0001\u001dCB\u0004XM\u001c3F]\u0012$\u0006P\\'be.,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011\tH\u000b\u0003\u0002\f\tM4F\u0001B;!\u0011\u00119H!!\u000e\u0005\te$\u0002\u0002B>\u0005{\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t}D*\u0001\u0006b]:|G/\u0019;j_:LAAa!\u0003z\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00029\u0005\u0004\b/\u001a8e\u000b:$G\u000b\u001f8NCJ\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!\u0011\u0012\u0016\u0004\u007f\nM\u0014AB1qa\u0016tG\rF\ta\u0005\u001f\u0013\tJa%\u0003\u0016\ne%1\u0014BO\u0005OCQAZ\u001fA\u0002!DQ!`\u001fA\u0002}DqA!\u0013>\u0001\u0004\u0011Y\u0005C\u0004\u0003\u0018v\u0002\r!a\u0003\u0002\u0007M,\u0017\u000f\u0003\u0004\u0003du\u0002\ra \u0005\t\u0005Wj\u0004\u0013!a\u0001\u007f\"I!qT\u001f\u0011\u0002\u0003\u0007!\u0011U\u0001\u0010SN$&/\u00198tC\u000e$\u0018n\u001c8bYB\u00191Ja)\n\u0007\t\u0015FJA\u0004C_>dW-\u00198\t\u0013\t%V\b%AA\u0002\t-\u0016AB8sS\u001eLg\u000eE\u0002T\u0005[K1Aa,E\u00051\t\u0005\u000f]3oI>\u0013\u0018nZ5o\u0003A\t\u0007\u000f]3oI\u0012\"WMZ1vYR$c'\u0001\tbaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!q\u0017\u0016\u0005\u0005C\u0013\u0019(\u0001\tbaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%qU\u0011!Q\u0018\u0016\u0005\u0005W\u0013\u0019\bF\u0007a\u0005\u0003\u0014\u0019M!2\u0003H\n%'1\u001b\u0005\u0006M\u0006\u0003\r\u0001\u001b\u0005\u0006{\u0006\u0003\ra \u0005\b\u0005\u0013\n\u0005\u0019\u0001B&\u0011\u0019\u0011\u0019'\u0011a\u0001\u007f\"9!1Z!A\u0002\t5\u0017!\u00022bi\u000eD\u0007\u0003\u0002B,\u0005\u001fLAA!5\u0003Z\tY!+Z2pe\u0012\u0014\u0015\r^2i\u0011\u001d\u0011I+\u0011a\u0001\u0005W\u000bacY;se\u0016tGo\u00158baNDw\u000e^(gMN,Go]\u000b\u0003\u00053\u0004RAa7\u0003j~tAA!8\u0003fB\u0019!q\u001c'\u000e\u0005\t\u0005(b\u0001Br\u0011\u00061AH]8pizJ1Aa:M\u0003\u0019\u0001&/\u001a3fM&!!1\u001eBw\u0005\r\u0019V\r\u001e\u0006\u0004\u0005Od\u0005")
public class ProducerStateManagerTest {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxPidExpirationMs;
    private final MockTime time = new MockTime();

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public ProducerStateManager stateManager() {
        return this.stateManager;
    }

    public void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    public long producerId() {
        return this.producerId;
    }

    public int maxPidExpirationMs() {
        return this.maxPidExpirationMs;
    }

    public MockTime time() {
        return this.time;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.append$default$7(), this.append$default$8());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Option option = this.stateManager().lastEntry(this.producerId());
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }
        ProducerStateEntry firstEntry = (ProducerStateEntry)getOrElse_this.get();
        Assert.assertEquals((long)producerEpoch, (long)firstEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assert.assertEquals((long)-1L, (long)firstEntry.lastSeq());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(ProducerFencedException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, this.append$default$7(), this.append$default$8()), ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.append$default$7(), this.append$default$8());
        Option option2 = this.stateManager().lastEntry(this.producerId());
        if (option2 == null) {
            throw null;
        }
        Option getOrElse_this2 = option2;
        if (getOrElse_this2.isEmpty()) {
            throw Assertions$.MODULE$.fail("Expected last entry to be defined", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        }
        ProducerStateEntry secondEntry = (ProducerStateEntry)getOrElse_this2.get();
        Assert.assertEquals((long)producerEpoch, (long)secondEntry.producerEpoch());
        Assert.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assert.assertEquals((long)0L, (long)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)0L, (long)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Replication$.MODULE$);
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 2020L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0x7FFFFFF5L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)9L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assert.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test(expected=OutOfOrderSequenceException.class)
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)epoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControlRecordBumpsEpoch() {
        void var4_4;
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        short bumpedEpoch = (short)1;
        Tuple2<CompletedTxn, Object> tuple2 = this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        CompletedTxn completedTxn = (CompletedTxn)tuple2._1();
        long l = tuple2._2$mcJ$sp();
        Assert.assertEquals((long)1L, (long)var4_4.firstOffset());
        Assert.assertEquals((long)1L, (long)var4_4.lastOffset());
        Assert.assertEquals((long)2L, (long)l);
        Assert.assertTrue((boolean)var4_4.isAborted());
        Assert.assertEquals((long)this.producerId(), (long)var4_4.producerId());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assert.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assert.assertEquals((long)bumpedEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((long)-1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)-1L, (long)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedEpoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Option option = this.stateManager().lastEntry(this.producerId());
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((ProducerStateEntry)map_this.get()).firstSeq()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)object);
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assert.assertEquals((Object)new Some((Object)firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Option option = this.stateManager().firstUnstableOffset();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this.get()).messageOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)object);
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assert.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Option option2 = this.stateManager().firstUnstableOffset();
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object2 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this2.get()).messageOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)object2);
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assert.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, false);
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, false);
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((long)0L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), this.append$default$7(), this.append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)5L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assert.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        CompletedTxn completedTxn = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assert.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assert.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assert.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assert.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assert.assertEquals((long)producerEpoch, (long)lastEntry.producerEpoch());
        Assert.assertEquals((long)1L, (long)lastEntry.firstSeq());
        Assert.assertEquals((long)10L, (long)lastEntry.lastSeq());
        Assert.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assert.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)coordinatorEpoch, (long)lastEntry.coordinatorEpoch());
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            int x$20 = 2;
            long x$21 = 2L;
            boolean x$22 = true;
            long x$23 = this.append$default$6();
            AppendOrigin x$24 = this.append$default$8();
            this.append(x$17, x$18, bumpedEpoch, x$20, x$21, x$23, x$22, x$24);
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            int x$28 = 2;
            long x$29 = 2L;
            boolean x$30 = true;
            long x$31 = this.append$default$6();
            AppendOrigin x$32 = this.append$default$8();
            this.append(x$25, x$26, x$27, x$28, x$29, x$31, x$30, x$32);
        }, ClassTag$.MODULE$.apply(OutOfOrderSequenceException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        int x$36 = 0;
        long x$37 = 0L;
        boolean x$38 = true;
        long x$39 = this.append$default$6();
        AppendOrigin x$40 = this.append$default$8();
        this.append(x$33, x$34, bumpedEpoch, x$36, x$37, x$39, x$38, x$40);
        Assert.assertEquals((long)bumpedEpoch, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test(expected=InvalidTxnStateException.class)
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = false;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((String)"Directory doesn't contain a single file as expected", (long)1L, (long)this.logDir().list().length);
        Assert.assertTrue((String)"Snapshot file is empty", (((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).head()).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        int x$20 = 2;
        long x$21 = 2L;
        boolean x$22 = true;
        long x$23 = this.append$default$6();
        AppendOrigin x$24 = this.append$default$8();
        this.append(recoveredMapping, x$18, epoch, x$20, x$21, x$23, x$22, x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        ControlRecordType x$4 = ControlRecordType.ABORT;
        long x$5 = 0L;
        int x$7 = this.appendEndTxnMarker$default$6();
        this.appendEndTxnMarker(x$1, x$2, epoch, x$4, x$5, x$7, appendTimestamp);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Option lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assert.assertTrue((boolean)lastEntry.isDefined());
        Assert.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assert.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assert.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assert.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assert.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        long x$2 = this.producerId();
        long x$5 = 2L;
        long x$6 = 70001L;
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        boolean x$8 = this.append$default$7();
        this.append(recoveredMapping, x$2, epoch, sequence, x$5, x$6, x$8, (AppendOrigin)x$7);
        Assert.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assert.assertEquals((long)epoch, (long)producerStateEntry.producerEpoch());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.firstSeq());
        Assert.assertEquals((long)sequence, (long)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        int outOfOrderSequence = 3;
        try {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            long x$5 = 1L;
            long x$6 = 1L;
            AppendOrigin.Client$ x$7 = AppendOrigin.Client$.MODULE$;
            boolean x$8 = this.append$default$7();
            this.append(x$1, x$2, epoch, outOfOrderSequence, x$5, x$6, x$8, (AppendOrigin)x$7);
            throw Assertions$.MODULE$.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
        }
        catch (OutOfOrderSequenceException outOfOrderSequenceException) {
        }
        catch (Exception exception) {
            throw Assertions$.MODULE$.fail("Expected an OutOfOrderSequenceException to be raised.", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
        }
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$13 = 1L;
        long x$14 = 1L;
        AppendOrigin.Replication$ x$15 = AppendOrigin.Replication$.MODULE$;
        boolean x$16 = this.append$default$7();
        this.append(x$9, x$10, epoch, outOfOrderSequence, x$13, x$14, x$16, (AppendOrigin)x$15);
        Assert.assertEquals((long)outOfOrderSequence, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncate() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncate();
        Assert.assertEquals((long)0L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Option option = this.stateManager().firstUnstableOffset();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this.get()).messageOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)object);
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Option option2 = this.stateManager().firstUnstableOffset();
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object2 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this2.get()).messageOffset()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)object2);
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Option option3 = this.stateManager().firstUnstableOffset();
        if (option3 == null) {
            throw null;
        }
        Option map_this3 = option3;
        Object object3 = map_this3.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this3.get()).messageOffset()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)object3);
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Option option4 = this.stateManager().firstUnstableOffset();
        if (option4 == null) {
            throw null;
        }
        Option map_this4 = option4;
        Object object4 = map_this4.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this4.get()).messageOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)object4);
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assert.assertEquals((long)2L, (long)this.stateManager().activeProducers().size());
        Option entry1 = this.stateManager().lastEntry(pid1);
        Assert.assertTrue((boolean)entry1.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastSeq());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Option entry2 = this.stateManager().lastEntry(pid2);
        Assert.assertTrue((boolean)entry2.isDefined());
        Assert.assertEquals((long)0L, (long)((ProducerStateEntry)entry2.get()).lastSeq());
        Assert.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assert.assertEquals((long)1L, (long)this.logDir().listFiles().length);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testStartOffset() {
        short epoch = (short)0;
        long pid2 = 2L;
        this.append(this.stateManager(), pid2, epoch, 0, 0L, 1L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 1L, 2L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 2L, 3L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 3L, 4L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
            recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
            this.append(recoveredMapping, pid2, epoch, 1, 4L, 5L, this.append$default$7(), this.append$default$8());
        }, ClassTag$.MODULE$.apply(UnknownProducerIdException.class), new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674));
    }

    @Test(expected=UnknownProducerIdException.class)
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Option option = this.stateManager().firstUnstableOffset();
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this.get()).messageOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)object);
        long anotherPid = 2L;
        ProducerStateManager x$9 = this.stateManager();
        long x$13 = 105L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, anotherPid, epoch, sequence, x$13, x$15, x$14, x$16);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Option option2 = this.stateManager().firstUnstableOffset();
        if (option2 == null) {
            throw null;
        }
        Option map_this2 = option2;
        Object object2 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this2.get()).messageOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)object2);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Option option3 = this.stateManager().firstUnstableOffset();
        if (option3 == null) {
            throw null;
        }
        Option map_this3 = option3;
        Object object3 = map_this3.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this3.get()).messageOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)object3);
        this.stateManager().onHighWatermarkUpdated(100L);
        Option option4 = this.stateManager().firstUnstableOffset();
        if (option4 == null) {
            throw null;
        }
        Option map_this4 = option4;
        Object object4 = map_this4.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this4.get()).messageOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)object4);
        this.stateManager().onHighWatermarkUpdated(110L);
        Option option5 = this.stateManager().firstUnstableOffset();
        if (option5 == null) {
            throw null;
        }
        Option map_this5 = option5;
        Object object5 = map_this5.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this5.get()).messageOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)object5);
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Option option6 = this.stateManager().firstUnstableOffset();
        if (option6 == null) {
            throw null;
        }
        Option map_this6 = option6;
        Object object6 = map_this6.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this6.get()).messageOffset()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)object6);
        this.stateManager().onHighWatermarkUpdated(113L);
        Option option7 = this.stateManager().firstUnstableOffset();
        if (option7 == null) {
            throw null;
        }
        Option map_this7 = option7;
        Object object7 = map_this7.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)((LogOffsetMetadata)map_this7.get()).messageOffset()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)object7);
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxPidExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assert.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxPidExpirationMs());
        short epoch = (short)0;
        long x$2 = this.producerId();
        int x$4 = -1;
        long x$5 = 99L;
        boolean x$6 = true;
        AppendOrigin.Coordinator$ x$7 = AppendOrigin.Coordinator$.MODULE$;
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, x$4, x$5, x$8, x$6, (AppendOrigin)x$7);
        long x$10 = this.producerId();
        int x$12 = -1;
        long x$13 = 100L;
        boolean x$14 = true;
        AppendOrigin.Coordinator$ x$15 = AppendOrigin.Coordinator$.MODULE$;
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, x$12, x$13, x$16, x$14, (AppendOrigin)x$15);
    }

    @Test(expected=ProducerFencedException.class)
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        if (lastEntry == null) {
            throw null;
        }
        Object object = lastEntry.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)((ProducerStateEntry)lastEntry.get()).coordinatorEpoch()));
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)object);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        try {
            this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7());
            throw Assertions$.MODULE$.fail("Expected coordinator to be fenced", new Position("ProducerStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786));
        }
        catch (TransactionCoordinatorFencedException transactionCoordinatorFencedException) {
            return;
        }
    }

    @Test(expected=TransactionCoordinatorFencedException.class)
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, producerEpoch, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs()).truncateAndReload(0L, 2L, 70000L);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7());
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assert.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assert.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assert.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        short producerEpoch = (short)145;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)EasyMock.createMock(RecordBatch.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)batch.iterator()).andReturn(Collections.emptyIterator()).once();
        EasyMock.replay((Object[])new Object[]{batch});
        this.append(this.stateManager(), producerId, producerEpoch, baseOffset, batch, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assert.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = Log$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxPidExpirationMs());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assert.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assert.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Tuple2<CompletedTxn, Object> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        CompletedTxn completedTxn = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        long lastStableOffset = mapping.lastStableOffset(completedTxn);
        mapping.completeTxn(completedTxn);
        mapping.updateMapEndOffset(offset + 1L);
        return new Tuple2((Object)completedTxn, (Object)BoxesRunTime.boxToLong((long)lastStableOffset));
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, long offset, RecordBatch batch, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.append(batch, (Option)None$.MODULE$);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Set<Object> currentSnapshotOffsets() {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())), (Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toSet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$2) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$2, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assert.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxPidExpirationMs = 60000;
    }

    public static final /* synthetic */ Object $anonfun$testControlRecordBumpsEpoch$1$adapted(ProducerStateEntry x$2) {
        return BoxesRunTime.boxToInteger((int)x$2.firstSeq());
    }

    public static final /* synthetic */ Object $anonfun$testLastStableOffsetCompletedTxn$1$adapted(LogOffsetMetadata x$3) {
        return BoxesRunTime.boxToLong((long)x$3.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testLastStableOffsetCompletedTxn$2$adapted(LogOffsetMetadata x$4) {
        return BoxesRunTime.boxToLong((long)x$4.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffsetAfterTruncation$1$adapted(LogOffsetMetadata x$5) {
        return BoxesRunTime.boxToLong((long)x$5.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffsetAfterTruncation$2$adapted(LogOffsetMetadata x$6) {
        return BoxesRunTime.boxToLong((long)x$6.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffsetAfterTruncation$3$adapted(LogOffsetMetadata x$7) {
        return BoxesRunTime.boxToLong((long)x$7.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffsetAfterTruncation$4$adapted(LogOffsetMetadata x$8) {
        return BoxesRunTime.boxToLong((long)x$8.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$1$adapted(LogOffsetMetadata x$9) {
        return BoxesRunTime.boxToLong((long)x$9.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$2$adapted(LogOffsetMetadata x$10) {
        return BoxesRunTime.boxToLong((long)x$10.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$3$adapted(LogOffsetMetadata x$11) {
        return BoxesRunTime.boxToLong((long)x$11.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$4$adapted(LogOffsetMetadata x$12) {
        return BoxesRunTime.boxToLong((long)x$12.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$5$adapted(LogOffsetMetadata x$13) {
        return BoxesRunTime.boxToLong((long)x$13.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$6$adapted(LogOffsetMetadata x$14) {
        return BoxesRunTime.boxToLong((long)x$14.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testFirstUnstableOffset$7$adapted(LogOffsetMetadata x$15) {
        return BoxesRunTime.boxToLong((long)x$15.messageOffset());
    }

    public static final /* synthetic */ Object $anonfun$testCoordinatorFencing$1$adapted(ProducerStateEntry x$16) {
        return BoxesRunTime.boxToInteger((int)x$16.coordinatorEpoch());
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }
}

