/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001)3AAB\u0004\u0001\u0019!)\u0011\u0003\u0001C\u0001%!)A\u0003\u0001C\u0001+!)Q\u0005\u0001C\u0001+!)q\u0005\u0001C\u0005Q!)1\t\u0001C\u0005\t\n\u0001sJ\u001a4tKR\u001chi\u001c:MK\u0006$WM]#q_\u000eD'+Z9vKN$H+Z:u\u0015\tA\u0011\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0015\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000e!\tqq\"D\u0001\b\u0013\t\u0001rAA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u000f\u0001\u0005\u0019C/Z:u\u001f\u001a47/\u001a;t\r>\u0014H*Z1eKJ,\u0005o\\2i\u000bJ\u0014xN]\"pI\u0016\u001cH#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005u\u0001\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\u000b),h.\u001b;\u000b\u0003\t\n1a\u001c:h\u0013\t!sD\u0001\u0003UKN$\u0018A\u0007;fgR\u001cUO\u001d:f]R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>t\u0007FA\u0002\u001e\u0003M\t7o]3siJ+7\u000f]8og\u0016,%O]8s)\u00111\u0012FN\u001e\t\u000b)\"\u0001\u0019A\u0016\u0002\u000b\u0015\u0014(o\u001c:\u0011\u00051\"T\"A\u0017\u000b\u00059z\u0013\u0001\u00039s_R|7m\u001c7\u000b\u0005A\n\u0014AB2p[6|gN\u0003\u0002\u000be)\u00111'I\u0001\u0007CB\f7\r[3\n\u0005Uj#AB#se>\u00148\u000fC\u00038\t\u0001\u0007\u0001(\u0001\u0005ce>\\WM]%e!\t9\u0012(\u0003\u0002;1\t\u0019\u0011J\u001c;\t\u000bq\"\u0001\u0019A\u001f\u0002\u000fI,\u0017/^3tiB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iL\u0001\te\u0016\fX/Z:ug&\u0011!i\u0010\u0002\u001d\u001f\u001a47/\u001a;t\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\u0007\u0015C\u0015\n\u0005\u0002?\r&\u0011qi\u0010\u0002\u001e\u001f\u001a47/\u001a;t\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\u001c\bo\u001c8tK\")q'\u0002a\u0001q!)A(\u0002a\u0001{\u0001")
public class OffsetsForLeaderEpochRequestTest
extends BaseRequestTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetsForLeaderEpochErrorCodes() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map epochs = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (java.util.Map)epochs, (int)1).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, request);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)OffsetsForLeaderEpochRequestTest.$anonfun$testOffsetsForLeaderEpochErrorCodes$2(x$2)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, follower, request);
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, nonReplica, request);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    private void assertResponseError(Errors error, int brokerId, OffsetsForLeaderEpochRequest request) {
        OffsetsForLeaderEpochResponse response = this.sendRequest(brokerId, request);
        Assert.assertEquals((long)request.epochsByTopicPartition().size(), (long)response.responses().size());
        ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.responses()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)partitionData -> {
            OffsetsForLeaderEpochRequestTest.$anonfun$assertResponseError$1(error, partitionData);
            return BoxedUnit.UNIT;
        });
    }

    private OffsetsForLeaderEpochResponse sendRequest(int brokerId, OffsetsForLeaderEpochRequest request) {
        return OffsetsForLeaderEpochResponse.parse((ByteBuffer)this.connectAndSend((AbstractRequest)request, ApiKeys.OFFSET_FOR_LEADER_EPOCH, this.brokerSocketServer(brokerId), this.connectAndSend$default$4(), this.connectAndSend$default$5()), (short)request.version());
    }

    public static final /* synthetic */ int $anonfun$testOffsetsForLeaderEpochErrorCodes$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    /*
     * WARNING - void declaration
     */
    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional currentLeaderEpoch, TopicPartition topicPartition$1) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(currentLeaderEpoch, 0);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)topicPartition$1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map epochs = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (java.util.Map)epochs, (int)1).build();
        this.assertResponseError(error, brokerId, request);
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$1, EpochEndOffset partitionData) {
        Assert.assertEquals((Object)error$1, (Object)partitionData.error());
    }
}

