/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0013'\u00015BQA\u000f\u0001\u0005\u0002mBqA\u0010\u0001A\u0002\u0013\u0005q\bC\u0004O\u0001\u0001\u0007I\u0011A(\t\rY\u0003\u0001\u0015)\u0003A\u0011\u001d9\u0006A1A\u0005\u0002aCa!\u0019\u0001!\u0002\u0013I\u0006b\u00022\u0001\u0005\u0004%\t\u0001\u0017\u0005\u0007G\u0002\u0001\u000b\u0011B-\t\u000f\u0011\u0004!\u0019!C\u0001K\"1\u0011\u000f\u0001Q\u0001\n\u0019DqA\u001d\u0001C\u0002\u0013\u0005Q\r\u0003\u0004t\u0001\u0001\u0006IA\u001a\u0005\bi\u0002\u0011\r\u0011\"\u0001f\u0011\u0019)\b\u0001)A\u0005M\"9a\u000f\u0001b\u0001\n\u0003)\u0007BB<\u0001A\u0003%a\rC\u0004y\u0001\t\u0007I\u0011A3\t\re\u0004\u0001\u0015!\u0003g\u0011\u001dQ\bA1A\u0005\u0002\u0015Daa\u001f\u0001!\u0002\u00131\u0007b\u0002?\u0001\u0001\u0004%\t! \u0005\n\u0003/\u0001\u0001\u0019!C\u0001\u00033Aq!!\b\u0001A\u0003&a\u0010C\u0004\u0002 \u0001!\t%!\t\t\u000f\u0005E\u0002\u0001\"\u0001\u0002\"!9\u00111\b\u0001\u0005\u0002\u0005\u0005\u0002bBA \u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\tI\u0006\u0001C\u0005\u0003\u0013Cq!a%\u0001\t\u0013\t)\nC\u0004\u00026\u0002!I!a.\t\u000f\u0005-\u0007\u0001\"\u0003\u0002\"\u00199\u0011q\n\u0001\u0001M\u0005E\u0003BCA-C\t\u0005\t\u0015!\u0003\u0002\\!1!(\tC\u0001\u0003CBq!!\u001a\"\t\u0003\t9G\u0001\u000eMK\u0006$WM]#q_\u000eD\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002(Q\u0005)Q\r]8dQ*\u0011\u0011FK\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003-\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001]Q\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0016\u0002\u0005i\\\u0017BA\u001a1\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tgB\u0011Q\u0007O\u0007\u0002m)\u0011qGK\u0001\u0006kRLGn]\u0005\u0003sY\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002yA\u0011Q\bA\u0007\u0002M\u00059!M]8lKJ\u001cX#\u0001!\u0011\u0007\u0005C%*D\u0001C\u0015\t\u0019E)A\u0004nkR\f'\r\\3\u000b\u0005\u00153\u0015AC2pY2,7\r^5p]*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\u0005\nQA*[:u\u0005V4g-\u001a:\u0011\u0005-cU\"\u0001\u0015\n\u00055C#aC&bM.\f7+\u001a:wKJ\f1B\u0019:pW\u0016\u00148o\u0018\u0013fcR\u0011\u0001\u000b\u0016\t\u0003#Jk\u0011AR\u0005\u0003'\u001a\u0013A!\u00168ji\"9QkAA\u0001\u0002\u0004\u0001\u0015a\u0001=%c\u0005A!M]8lKJ\u001c\b%\u0001\u0004u_BL7-M\u000b\u00023B\u0011!lX\u0007\u00027*\u0011A,X\u0001\u0005Y\u0006twMC\u0001_\u0003\u0011Q\u0017M^1\n\u0005\u0001\\&AB*ue&tw-A\u0004u_BL7-\r\u0011\u0002\rQ|\u0007/[23\u0003\u001d!x\u000e]5de\u0001\nA\u0001^\u0019qaU\ta\r\u0005\u0002h_6\t\u0001N\u0003\u0002jU\u000611m\\7n_:T!aK6\u000b\u00051l\u0017AB1qC\u000eDWMC\u0001o\u0003\ry'oZ\u0005\u0003a\"\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0003ucA\u0004\u0004%\u0001\u0003ucA\f\u0014!\u0002;2aF\u0002\u0013\u0001\u0002;2aJ\nQ\u0001^\u0019qe\u0001\nA\u0001\u001e\u001aqa\u0005)AO\r91A\u0005!AO\r93\u0003\u0015!(\u0007\u001d\u001a!\u0003\t!\b/A\u0002ua\u0002\n\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0002}B9q0a\u0002\u0002\f\u0005-QBAA\u0001\u0015\ra\u00181\u0001\u0006\u0004\u0003\u000bQ\u0017aB2mS\u0016tGo]\u0005\u0005\u0003\u0013\t\tAA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0006#\u00065\u0011\u0011C\u0005\u0004\u0003\u001f1%!B!se\u0006L\bcA)\u0002\u0014%\u0019\u0011Q\u0003$\u0003\t\tKH/Z\u0001\raJ|G-^2fe~#S-\u001d\u000b\u0004!\u0006m\u0001bB+\u0017\u0003\u0003\u0005\rA`\u0001\naJ|G-^2fe\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002!\"\u001a\u0001$!\n\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000bn\u0003\u0015QWO\\5u\u0013\u0011\ty#!\u000b\u0003\u000b\u00053G/\u001a:\u0002{MDw.\u001e7e\u0003\u0012$7)\u001e:sK:$H*Z1eKJ,\u0005o\\2i)>lUm]:bO\u0016\u001c\u0018i\u001d+iKf\f%/Z,sSR$XM\u001c+p\u0019\u0016\fG-\u001a:)\u0007e\t)\u0004\u0005\u0003\u0002(\u0005]\u0012\u0002BA\u001d\u0003S\u0011A\u0001V3ti\u0006Y3\u000f[8vY\u0012\u001cVM\u001c3MK\u0006$WM]#q_\u000eD'+Z9vKN$\u0018I\u001c3HKR\f%+Z:q_:\u001cX\rK\u0002\u001b\u0003k\taf\u001d5pk2$\u0017J\\2sK\u0006\u001cX\rT3bI\u0016\u0014X\t]8dQ\n+Go^3f]2+\u0017\rZ3s%\u0016\u001cH/\u0019:ug\"\u001a1$!\u000e\u0002YMDw.\u001e7e'V\u0004\bo\u001c:u%\u0016\fX/Z:ug\u001a{'/\u00129pG\"\u001chj\u001c;P]RCW\rT3bI\u0016\u0014Hc\u0001)\u0002H!9\u0011\u0011\n\u000fA\u0002\u0005-\u0013a\u00024fi\u000eDWM\u001d\t\u0004\u0003\u001b\nS\"\u0001\u0001\u0003#Q+7\u000f\u001e$fi\u000eDWM\u001d+ie\u0016\fGm\u0005\u0003\"\u0003'\"\u0004cA)\u0002V%\u0019\u0011q\u000b$\u0003\r\u0005s\u0017PU3g\u0003\u0019\u0019XM\u001c3feB\u00191*!\u0018\n\u0007\u0005}\u0003F\u0001\u0007CY>\u001c7.\u001b8h'\u0016tG\r\u0006\u0003\u0002L\u0005\r\u0004bBA-G\u0001\u0007\u00111L\u0001\u0011Y\u0016\fG-\u001a:PM\u001a\u001cX\r^:G_J$B!!\u001b\u0002~A9\u00111NA7M\u0006ET\"\u0001#\n\u0007\u0005=DIA\u0002NCB\u0004B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003oB\u0017\u0001\u0003:fcV,7\u000f^:\n\t\u0005m\u0014Q\u000f\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0011\u001d\ty\b\na\u0001\u0003\u0003\u000b!\u0002]1si&$\u0018n\u001c8t!\u001d\tY'!\u001cg\u0003\u0007\u00032!UAC\u0013\r\t9I\u0012\u0002\u0004\u0013:$HCBA.\u0003\u0017\u000by\t\u0003\u0004\u0002\u000ev\u0001\rAS\u0001\u0005MJ|W\u000e\u0003\u0004\u0002\u0012v\u0001\rAS\u0001\u0003i>\fAc^1ji\u001a{'/\u00129pG\"\u001c\u0005.\u00198hKR{Gc\u0002)\u0002\u0018\u0006=\u00161\u0017\u0005\b\u00033s\u0002\u0019AAN\u0003\u0015!x\u000e]5d!\u0011\ti*a+\u000f\t\u0005}\u0015q\u0015\t\u0004\u0003C3UBAAR\u0015\r\t)\u000bL\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%f)\u0001\u0004Qe\u0016$WMZ\u0005\u0004A\u00065&bAAU\r\"9\u0011\u0011\u0017\u0010A\u0002\u0005\r\u0015!\u00039beRLG/[8o\u0011\u00199c\u00041\u0001\u0002\u0004\u00069R.Z:tC\u001e,7\u000fS1wK2+\u0017\rZ3s\u000bB|7\r\u001b\u000b\t\u0003s\u000by,a1\u0002HB\u0019\u0011+a/\n\u0007\u0005ufIA\u0004C_>dW-\u00198\t\r\u0005\u0005w\u00041\u0001K\u0003\u0019\u0011'o\\6fe\"9\u0011QY\u0010A\u0002\u0005\r\u0015aE3ya\u0016\u001cG/\u001a3MK\u0006$WM]#q_\u000eD\u0007bBAe?\u0001\u0007\u00111Q\u0001\n[&twJ\u001a4tKR\f1d]3oI\u001a{WO]'fgN\fw-Z:U_\u0016\u000b7\r\u001b+pa&\u001c\u0007")
public class LeaderEpochIntegrationTest
extends ZooKeeperTestHarness {
    private ListBuffer<KafkaServer> brokers = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final String topic1;
    private final String topic2;
    private final TopicPartition t1p0 = new TopicPartition(this.topic1(), 0);
    private final TopicPartition t1p1 = new TopicPartition(this.topic1(), 1);
    private final TopicPartition t1p2 = new TopicPartition(this.topic1(), 2);
    private final TopicPartition t2p0 = new TopicPartition(this.topic2(), 0);
    private final TopicPartition t2p2 = new TopicPartition(this.topic2(), 2);
    private final TopicPartition tp = this.t1p0();
    private KafkaProducer<byte[], byte[]> producer = null;

    public ListBuffer<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(ListBuffer<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public TopicPartition t1p0() {
        return this.t1p0;
    }

    public TopicPartition t1p1() {
        return this.t1p1;
    }

    public TopicPartition t1p2() {
        return this.t1p2;
    }

    public TopicPartition t2p0() {
        return this.t2p0;
    }

    public TopicPartition t2p2() {
        return this.t2p2;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @After
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.brokers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldAddCurrentLeaderEpochToMessagesAsTheyAreWrittenToLeader() {
        void map_bf;
        void map_f;
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 1);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)id -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)id), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2());
        if (inclusive == null) {
            throw null;
        }
        this.brokers().$plus$plus$eq((TraversableOnce)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf));
        .colon.colon foreach_these = new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$));
        while (!foreach_these.isEmpty()) {
            String string = (String)foreach_these.head();
            LeaderEpochIntegrationTest.$anonfun$shouldAddCurrentLeaderEpochToMessagesAsTheyAreWrittenToLeader$2(this, string);
            foreach_these = (List)foreach_these.tail();
        }
        this.sendFourMessagesToEachTopic();
        IntRef expectedLeaderEpoch = IntRef.create((int)0);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.messagesHaveLeaderEpoch((KafkaServer)this.brokers().apply(0), expectedLeaderEpoch.elem, 0)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LeaderEpochIntegrationTest.$anonfun$shouldAddCurrentLeaderEpochToMessagesAsTheyAreWrittenToLeader$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        ((KafkaServer)this.brokers().apply(0)).startup();
        expectedLeaderEpoch.elem = 1;
        this.waitForEpochChangeTo(this.topic1(), 0, expectedLeaderEpoch.elem);
        this.waitForEpochChangeTo(this.topic2(), 0, expectedLeaderEpoch.elem);
        this.sendFourMessagesToEachTopic();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!this.messagesHaveLeaderEpoch((KafkaServer)this.brokers().apply(0), expectedLeaderEpoch.elem, 4)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LeaderEpochIntegrationTest.$anonfun$shouldAddCurrentLeaderEpochToMessagesAsTheyAreWrittenToLeader$6(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldSendLeaderEpochRequestAndGetAResponse() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void map_bf;
        void map_f;
        int n = 100;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, 102);
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)id -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)id), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2());
        if (inclusive == null) {
            throw null;
        }
        this.brokers().$plus$plus$eq((TraversableOnce)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf));
        Tuple2[] tuple2Array = new Tuple2[2];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        GenTraversable genTraversable2 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101}));
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        Map assignment1 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic1(), (Map<Object, Seq<Object>>)assignment1, (Seq<KafkaServer>)this.brokers());
        Tuple2[] tuple2Array2 = new Tuple2[1];
        GenTraversable genTraversable3 = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100}));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        Map assignment2 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic2(), (Map<Object, Seq<Object>>)assignment2, (Seq<KafkaServer>)this.brokers());
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), -1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15()));
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n2, 10);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                LeaderEpochIntegrationTest.$anonfun$shouldSendLeaderEpochRequestAndGetAResponse$2(this, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        int n3 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range2 = RichInt$.MODULE$.until$extension0(n3, 20);
        if (range2 == null) {
            throw null;
        }
        Range foreach_this2 = range2;
        if (!foreach_this2.isEmpty()) {
            int foreach_i = foreach_this2.start();
            while (true) {
                LeaderEpochIntegrationTest.$anonfun$shouldSendLeaderEpochRequestAndGetAResponse$3(this, foreach_i);
                if (foreach_i == foreach_this2.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this2.step();
            }
        }
        int n4 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range3 = RichInt$.MODULE$.until$extension0(n4, 30);
        if (range3 == null) {
            throw null;
        }
        Range foreach_this3 = range3;
        if (!foreach_this3.isEmpty()) {
            int foreach_i = foreach_this3.start();
            while (true) {
                LeaderEpochIntegrationTest.$anonfun$shouldSendLeaderEpochRequestAndGetAResponse$4(this, foreach_i);
                if (foreach_i == foreach_this3.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this3.step();
            }
        }
        this.producer().flush();
        TestFetcherThread fetcher0 = new TestFetcherThread(this, this.sender((KafkaServer)this.brokers().apply(2), (KafkaServer)this.brokers().apply(0)));
        Tuple2[] tuple2Array3 = new Tuple2[4];
        Integer n5 = BoxesRunTime.boxToInteger((int)0);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Integer n6 = BoxesRunTime.boxToInteger((int)0);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Integer n7 = BoxesRunTime.boxToInteger((int)0);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)this.t2p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[2] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Integer n8 = BoxesRunTime.boxToInteger((int)0);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)this.t2p2());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[3] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map epochsRequested = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3));
        Map<TopicPartition, EpochEndOffset> offsetsForEpochs = fetcher0.leaderOffsetsFor((Map<TopicPartition, Object>)epochsRequested);
        Assert.assertEquals((long)10L, (long)((EpochEndOffset)offsetsForEpochs.apply((Object)this.t1p0())).endOffset());
        Assert.assertEquals((long)30L, (long)((EpochEndOffset)offsetsForEpochs.apply((Object)this.t2p0())).endOffset());
        Assert.assertTrue((boolean)((EpochEndOffset)offsetsForEpochs.apply((Object)this.t1p1())).hasError());
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)((EpochEndOffset)offsetsForEpochs.apply((Object)this.t1p1())).error());
        Assert.assertEquals((long)-1L, (long)((EpochEndOffset)offsetsForEpochs.apply((Object)this.t1p1())).endOffset());
        Map<TopicPartition, EpochEndOffset> offsetsForEpochs1 = new TestFetcherThread(this, this.sender((KafkaServer)this.brokers().apply(2), (KafkaServer)this.brokers().apply(1))).leaderOffsetsFor((Map<TopicPartition, Object>)epochsRequested);
        Assert.assertEquals((long)20L, (long)((EpochEndOffset)offsetsForEpochs1.apply((Object)this.t1p1())).endOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldIncreaseLeaderEpochBetweenLeaderRestarts() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_$this8;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_$this9;
        this.brokers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(100, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2()));
        Assert.assertEquals((long)100L, (long)TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2()));
        this.brokers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(101, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2()));
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.tp().partition()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y9);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.tp().topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)this.brokers());
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), -1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15()));
        this.producer().send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"IHeartLogs".getBytes())).get();
        TestFetcherThread fetcher = new TestFetcherThread(this, this.sender((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1)));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Integer n = BoxesRunTime.boxToInteger((int)0);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.tp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        EpochEndOffset epochEndOffset = (EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)))).apply((Object)this.tp());
        Assert.assertEquals((long)0L, (long)epochEndOffset.leaderEpoch());
        Assert.assertEquals((long)1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)1L, (long)this.leo$1());
        ((KafkaServer)this.brokers().apply(1)).shutdown();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.producer().send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"IHeartLogs".getBytes())).get();
        fetcher = new TestFetcherThread(this, this.sender((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1)));
        Tuple2[] tuple2Array3 = new Tuple2[1];
        Integer n2 = BoxesRunTime.boxToInteger((int)0);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.tp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        epochEndOffset = (EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3)))).apply((Object)this.tp());
        Assert.assertEquals((long)1L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)0L, (long)epochEndOffset.leaderEpoch());
        Tuple2[] tuple2Array4 = new Tuple2[1];
        Integer n3 = BoxesRunTime.boxToInteger((int)1);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)this.tp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        epochEndOffset = (EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4)))).apply((Object)this.tp());
        Assert.assertEquals((long)0L, (long)epochEndOffset.leaderEpoch());
        Assert.assertEquals((long)1L, (long)epochEndOffset.endOffset());
        Tuple2[] tuple2Array5 = new Tuple2[1];
        Integer n4 = BoxesRunTime.boxToInteger((int)2);
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)this.tp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array5[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        epochEndOffset = (EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array5)))).apply((Object)this.tp());
        Assert.assertEquals((long)2L, (long)epochEndOffset.leaderEpoch());
        Assert.assertEquals((long)2L, (long)epochEndOffset.endOffset());
        Assert.assertEquals((long)2L, (long)this.leo$1());
        ((KafkaServer)this.brokers().apply(1)).shutdown();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.producer().send(new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), null, (Object)"IHeartLogs".getBytes())).get();
        fetcher = new TestFetcherThread(this, this.sender((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1)));
        Tuple2[] tuple2Array6 = new Tuple2[1];
        Integer n5 = BoxesRunTime.boxToInteger((int)0);
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)this.tp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array6[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Assert.assertEquals((long)1L, (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array6)))).apply((Object)this.tp())).endOffset());
        Tuple2[] tuple2Array7 = new Tuple2[1];
        Integer n6 = BoxesRunTime.boxToInteger((int)2);
        Object object7 = Predef$.MODULE$.ArrowAssoc((Object)this.tp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array7[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Assert.assertEquals((long)2L, (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array7)))).apply((Object)this.tp())).endOffset());
        Tuple2[] tuple2Array8 = new Tuple2[1];
        Integer n7 = BoxesRunTime.boxToInteger((int)4);
        Object object8 = Predef$.MODULE$.ArrowAssoc((Object)this.tp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array8[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Assert.assertEquals((long)3L, (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array8)))).apply((Object)this.tp())).endOffset());
        Tuple2[] tuple2Array9 = new Tuple2[1];
        Integer n8 = BoxesRunTime.boxToInteger((int)4);
        Object object9 = Predef$.MODULE$.ArrowAssoc((Object)this.tp());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array9[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Assert.assertEquals((long)this.leo$1(), (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array9)))).apply((Object)this.tp())).endOffset());
        this.shouldSupportRequestsForEpochsNotOnTheLeader(fetcher);
    }

    /*
     * WARNING - void declaration
     */
    public void shouldSupportRequestsForEpochsNotOnTheLeader(TestFetcherThread fetcher) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        Tuple2[] tuple2Array = new Tuple2[1];
        Integer n = BoxesRunTime.boxToInteger((int)1);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        Map epoch1 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        Assert.assertEquals((long)1L, (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)epoch1).apply((Object)this.t1p0())).endOffset());
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Integer n2 = BoxesRunTime.boxToInteger((int)3);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Map epoch3 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
        Assert.assertEquals((long)2L, (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)epoch3).apply((Object)this.t1p0())).endOffset());
        Tuple2[] tuple2Array3 = new Tuple2[1];
        Integer n3 = BoxesRunTime.boxToInteger((int)5);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)this.t1p0());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        Map epoch5 = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3));
        Assert.assertEquals((long)-1L, (long)((EpochEndOffset)fetcher.leaderOffsetsFor((Map<TopicPartition, Object>)epoch5).apply((Object)this.t1p0())).endOffset());
    }

    private BlockingSend sender(KafkaServer from, KafkaServer to) {
        BrokerEndPoint endPoint = ((Broker)from.metadataCache().getAliveBrokers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochIntegrationTest.$anonfun$sender$1(to, x$4))).get()).brokerEndPoint(from.config().interBrokerListenerName());
        return new ReplicaFetcherBlockingSend(endPoint, from.config(), new Metrics(), (Time)new SystemTime(), 42, "TestFetcher", new LogContext());
    }

    /*
     * WARNING - void declaration
     */
    private void waitForEpochChangeTo(String topic, int partition, int epoch) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LeaderEpochIntegrationTest.$anonfun$waitForEpochChangeTo$1(this, topic, partition, epoch)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LeaderEpochIntegrationTest.$anonfun$waitForEpochChangeTo$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    private boolean messagesHaveLeaderEpoch(KafkaServer broker, int expectedLeaderEpoch, int minOffset) {
        BooleanRef result = BooleanRef.create((boolean)true);
        .colon.colon foreach_these = new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$));
        while (!foreach_these.isEmpty()) {
            String string = (String)foreach_these.head();
            LeaderEpochIntegrationTest.$anonfun$messagesHaveLeaderEpoch$1(this, broker, result, minOffset, expectedLeaderEpoch, string);
            foreach_these = (List)foreach_these.tail();
        }
        return result.elem;
    }

    /*
     * WARNING - void declaration
     */
    private void sendFourMessagesToEachTopic() {
        Object object;
        void map_bf;
        Object object2;
        void map_bf2;
        Object object3;
        void map_bf3;
        .colon.colon testMessageList1 = new .colon.colon((Object)"test1", (List)new .colon.colon((Object)"test2", (List)new .colon.colon((Object)"test3", (List)new .colon.colon((Object)"test4", (List)Nil$.MODULE$))));
        .colon.colon testMessageList2 = new .colon.colon((Object)"test5", (List)new .colon.colon((Object)"test6", (List)new .colon.colon((Object)"test7", (List)new .colon.colon((Object)"test8", (List)Nil$.MODULE$))));
        String x$12 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$122 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$12, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$2, x$3);
        CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable map_f = (Function1 & Serializable & scala.Serializable)m -> new ProducerRecord(this.topic1(), m, m);
        if (map_bf3 == List$.MODULE$.ReusableCBF()) {
            if (testMessageList1 == Nil$.MODULE$) {
                object3 = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                String string = (String)testMessageList1.head();
                .colon.colon map_t = map_h = new .colon.colon((Object)LeaderEpochIntegrationTest.$anonfun$sendFourMessagesToEachTopic$1(this, string), (List)Nil$.MODULE$);
                for (List map_rest = (List)testMessageList1.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    string = (String)map_rest.head();
                    .colon.colon map_nx = new .colon.colon((Object)LeaderEpochIntegrationTest.$anonfun$sendFourMessagesToEachTopic$1(this, string), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object3 = map_h;
            }
        } else {
            object3 = TraversableLike.map$((TraversableLike)testMessageList1, (Function1)map_f, (CanBuildFrom)map_bf3);
        }
        List list = (List)object3;
        CanBuildFrom canBuildFrom2 = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable map_f2 = (Function1 & Serializable & scala.Serializable)m -> new ProducerRecord(this.topic2(), m, m);
        if (map_bf2 == List$.MODULE$.ReusableCBF()) {
            if (testMessageList2 == Nil$.MODULE$) {
                object2 = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                String string = (String)testMessageList2.head();
                .colon.colon map_t = map_h = new .colon.colon((Object)LeaderEpochIntegrationTest.$anonfun$sendFourMessagesToEachTopic$2(this, string), (List)Nil$.MODULE$);
                for (List map_rest = (List)testMessageList2.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    string = (String)map_rest.head();
                    .colon.colon map_nx = new .colon.colon((Object)LeaderEpochIntegrationTest.$anonfun$sendFourMessagesToEachTopic$2(this, string), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object2 = map_h;
            }
        } else {
            object2 = TraversableLike.map$((TraversableLike)testMessageList2, (Function1)map_f2, (CanBuildFrom)map_bf2);
        }
        List records = (List)list.$plus$plus((GenTraversableOnce)object2, List$.MODULE$.canBuildFrom());
        CanBuildFrom canBuildFrom3 = List$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)x$1 -> producer.send(x$1);
        if (records == null) {
            throw null;
        }
        if (map_bf == List$.MODULE$.ReusableCBF()) {
            if (records == Nil$.MODULE$) {
                object = Nil$.MODULE$;
            } else {
                .colon.colon map_h;
                ProducerRecord producerRecord = (ProducerRecord)records.head();
                .colon.colon map_t = map_h = new .colon.colon((Object)producer.send(x$1), (List)Nil$.MODULE$);
                for (List map_rest = (List)records.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                    producerRecord = (ProducerRecord)map_rest.head();
                    .colon.colon map_nx = new .colon.colon((Object)producer.send(x$1), (List)Nil$.MODULE$);
                    map_t.tl_$eq((List)map_nx);
                    map_t = map_nx;
                }
                object = map_h;
            }
        } else {
            void map_f3;
            object = TraversableLike.map$((TraversableLike)records, (Function1)map_f3, (CanBuildFrom)map_bf);
        }
        List list2 = (List)object;
        if (list2 == null) {
            throw null;
        }
        List foreach_these = list2;
        while (!foreach_these.isEmpty()) {
            LeaderEpochIntegrationTest.$anonfun$sendFourMessagesToEachTopic$4((Future)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
        producer.close();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$shouldAddCurrentLeaderEpochToMessagesAsTheyAreWrittenToLeader$2(LeaderEpochIntegrationTest $this, String topic) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2[] tuple2Array = new Tuple2[1];
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        return TestUtils$.MODULE$.createTopic($this.zkClient(), topic, (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))), (Seq<KafkaServer>)$this.brokers());
    }

    public static final /* synthetic */ String $anonfun$shouldAddCurrentLeaderEpochToMessagesAsTheyAreWrittenToLeader$4() {
        return "Leader epoch should be 0";
    }

    public static final /* synthetic */ String $anonfun$shouldAddCurrentLeaderEpochToMessagesAsTheyAreWrittenToLeader$6() {
        return "Leader epoch should be 1";
    }

    public static final /* synthetic */ Future $anonfun$shouldSendLeaderEpochRequestAndGetAResponse$2(LeaderEpochIntegrationTest $this, int x$1) {
        return $this.producer().send(new ProducerRecord($this.topic1(), Predef$.MODULE$.int2Integer(0), null, (Object)"IHeartLogs".getBytes()));
    }

    public static final /* synthetic */ Future $anonfun$shouldSendLeaderEpochRequestAndGetAResponse$3(LeaderEpochIntegrationTest $this, int x$2) {
        return $this.producer().send(new ProducerRecord($this.topic1(), Predef$.MODULE$.int2Integer(1), null, (Object)"OhAreThey".getBytes()));
    }

    public static final /* synthetic */ Future $anonfun$shouldSendLeaderEpochRequestAndGetAResponse$4(LeaderEpochIntegrationTest $this, int x$3) {
        return $this.producer().send(new ProducerRecord($this.topic2(), Predef$.MODULE$.int2Integer(0), null, (Object)"IReallyDo".getBytes()));
    }

    private final long leo$1() {
        return ((Log)((KafkaServer)this.brokers().apply(1)).replicaManager().localLog(this.tp()).get()).logEndOffset();
    }

    public static final /* synthetic */ boolean $anonfun$sender$1(KafkaServer to$1, Broker x$4) {
        return x$4.id() == to$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$waitForEpochChangeTo$2(int epoch$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x$5) {
        return x$5.leaderEpoch() == epoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$waitForEpochChangeTo$1(LeaderEpochIntegrationTest $this, String topic$1, int partition$1, int epoch$1) {
        UpdateMetadataRequestData.UpdateMetadataPartitionState updateMetadataPartitionState;
        Option option = ((KafkaServer)$this.brokers().apply(0)).metadataCache().getPartitionInfo(topic$1, partition$1);
        if (option == null) {
            throw null;
        }
        Option exists_this = option;
        boolean bl = !exists_this.isEmpty() && LeaderEpochIntegrationTest.$anonfun$waitForEpochChangeTo$2(epoch$1, updateMetadataPartitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)exists_this.get());
        return bl;
    }

    public static final /* synthetic */ String $anonfun$waitForEpochChangeTo$3() {
        return "Epoch didn't change";
    }

    public static final /* synthetic */ boolean $anonfun$messagesHaveLeaderEpoch$4(int expectedLeaderEpoch$2, RecordBatch x$6) {
        return expectedLeaderEpoch$2 == x$6.partitionLeaderEpoch();
    }

    public static final /* synthetic */ boolean $anonfun$messagesHaveLeaderEpoch$3(int minOffset$1, int expectedLeaderEpoch$2, LogSegment segment) {
        if (segment.read((long)minOffset$1, Integer.MAX_VALUE, segment.read$default$3(), segment.read$default$4()) == null) {
            return false;
        }
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(segment.read((long)minOffset$1, Integer.MAX_VALUE, segment.read$default$3(), segment.read$default$4()).records().batches().iterator()).asScala()).forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochIntegrationTest.$anonfun$messagesHaveLeaderEpoch$4(expectedLeaderEpoch$2, x$6)));
    }

    public static final /* synthetic */ boolean $anonfun$messagesHaveLeaderEpoch$2(TopicPartition tp$1, int minOffset$1, int expectedLeaderEpoch$2, KafkaServer broker) {
        LogManager qual$2 = broker.getLogManager();
        boolean x$4 = qual$2.getLog$default$2();
        return ((Log)qual$2.getLog(tp$1, x$4).get()).logSegments().iterator().forall((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LeaderEpochIntegrationTest.$anonfun$messagesHaveLeaderEpoch$3(minOffset$1, expectedLeaderEpoch$2, segment)));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$messagesHaveLeaderEpoch$1(LeaderEpochIntegrationTest $this, KafkaServer broker$1, BooleanRef result$1, int minOffset$1, int expectedLeaderEpoch$2, String topic) {
        tp = new TopicPartition(topic, 0);
        qual$1 = broker$1.getLogManager();
        x$2 = qual$1.getLog$default$2();
        leo = ((Log)qual$1.getLog(tp, x$2).get()).logEndOffset();
        if (!result$1.elem || leo <= 0L) ** GOTO lbl-1000
        v0 = $this.brokers();
        var11_10 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$messagesHaveLeaderEpoch$2$adapted(org.apache.kafka.common.TopicPartition int int kafka.server.KafkaServer ), (Lkafka/server/KafkaServer;)Ljava/lang/Object;)((TopicPartition)tp, (int)minOffset$1, (int)expectedLeaderEpoch$2);
        if (v0 == null) {
            throw null;
        }
        if (v0.underlying().forall((Function1)forall_p)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        result$1.elem = v1;
    }

    public static final /* synthetic */ RecordMetadata $anonfun$sendFourMessagesToEachTopic$4(Future x$7) {
        return (RecordMetadata)x$7.get();
    }

    public LeaderEpochIntegrationTest() {
        this.topic1 = "foo";
        this.topic2 = "bar";
    }

    public static final /* synthetic */ Future $anonfun$shouldSendLeaderEpochRequestAndGetAResponse$2$adapted(LeaderEpochIntegrationTest $this, Object x$1) {
        return LeaderEpochIntegrationTest.$anonfun$shouldSendLeaderEpochRequestAndGetAResponse$2($this, BoxesRunTime.unboxToInt((Object)x$1));
    }

    public static final /* synthetic */ Future $anonfun$shouldSendLeaderEpochRequestAndGetAResponse$3$adapted(LeaderEpochIntegrationTest $this, Object x$2) {
        return LeaderEpochIntegrationTest.$anonfun$shouldSendLeaderEpochRequestAndGetAResponse$3($this, BoxesRunTime.unboxToInt((Object)x$2));
    }

    public static final /* synthetic */ Future $anonfun$shouldSendLeaderEpochRequestAndGetAResponse$4$adapted(LeaderEpochIntegrationTest $this, Object x$3) {
        return LeaderEpochIntegrationTest.$anonfun$shouldSendLeaderEpochRequestAndGetAResponse$4($this, BoxesRunTime.unboxToInt((Object)x$3));
    }

    public static final /* synthetic */ Object $anonfun$messagesHaveLeaderEpoch$1$adapted(LeaderEpochIntegrationTest $this, KafkaServer broker$1, BooleanRef result$1, int minOffset$1, int expectedLeaderEpoch$2, String topic) {
        LeaderEpochIntegrationTest.$anonfun$messagesHaveLeaderEpoch$1($this, broker$1, result$1, minOffset$1, expectedLeaderEpoch$2, topic);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$waitForEpochChangeTo$2$adapted(int epoch$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x$5) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochIntegrationTest.$anonfun$waitForEpochChangeTo$2(epoch$1, x$5));
    }

    public static final /* synthetic */ Object $anonfun$messagesHaveLeaderEpoch$2$adapted(TopicPartition tp$1, int minOffset$1, int expectedLeaderEpoch$2, KafkaServer broker) {
        return BoxesRunTime.boxToBoolean((boolean)LeaderEpochIntegrationTest.$anonfun$messagesHaveLeaderEpoch$2(tp$1, minOffset$1, expectedLeaderEpoch$2, broker));
    }

    public class TestFetcherThread
    implements Logging {
        private final BlockingSend sender;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;
        public final /* synthetic */ LeaderEpochIntegrationTest $outer;

        public String loggerName() {
            return Logging.loggerName$((Logging)this);
        }

        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$((Logging)this, (String)msg);
        }

        public void trace(Function0<String> msg) {
            Logging.trace$((Logging)this, msg);
        }

        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$((Logging)this, msg, e);
        }

        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$((Logging)this);
        }

        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$((Logging)this);
        }

        public void debug(Function0<String> msg) {
            Logging.debug$((Logging)this, msg);
        }

        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$((Logging)this, msg, e);
        }

        public void info(Function0<String> msg) {
            Logging.info$((Logging)this, msg);
        }

        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$((Logging)this, msg, e);
        }

        public void warn(Function0<String> msg) {
            Logging.warn$((Logging)this, msg);
        }

        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$((Logging)this, msg, e);
        }

        public void error(Function0<String> msg) {
            Logging.error$((Logging)this, msg);
        }

        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$((Logging)this, msg, e);
        }

        public void fatal(Function0<String> msg) {
            Logging.fatal$((Logging)this, msg);
        }

        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$((Logging)this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$((Logging)this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        public String logIdent() {
            return this.logIdent;
        }

        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public Map<TopicPartition, EpochEndOffset> leaderOffsetsFor(Map<TopicPartition, Object> partitions) {
            scala.collection.immutable.Map partitionData = partitions.mapValues((Function1 & Serializable & scala.Serializable)x$8 -> TestFetcherThread.$anonfun$leaderOffsetsFor$1(BoxesRunTime.unboxToInt((Object)x$8))).toMap(Predef$.MODULE$.$conforms());
            OffsetsForLeaderEpochRequest.Builder request = OffsetsForLeaderEpochRequest.Builder.forFollower((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionData).asJava()), (int)1);
            ClientResponse response = this.sender.sendRequest((AbstractRequest.Builder)request);
            return (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(((OffsetsForLeaderEpochResponse)response.responseBody()).responses()).asScala();
        }

        public /* synthetic */ LeaderEpochIntegrationTest kafka$server$epoch$LeaderEpochIntegrationTest$TestFetcherThread$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ OffsetsForLeaderEpochRequest.PartitionData $anonfun$leaderOffsetsFor$1(int x$8) {
            return new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), x$8);
        }

        public TestFetcherThread(LeaderEpochIntegrationTest $outer, BlockingSend sender) {
            this.sender = sender;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Logging.$init$((Logging)this);
        }
    }
}

