/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import javax.crypto.SecretKeyFactory;
import kafka.server.Defaults$;
import kafka.utils.CoreUtils$;
import kafka.utils.PasswordEncoder;
import kafka.utils.PasswordEncoder$;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.junit.Assert;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}2AAB\u0004\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)Q\u0005\u0001C\u00011!)q\u0005\u0001C\u00011!)\u0011\u0006\u0001C\u0005U\t\u0019\u0002+Y:to>\u0014H-\u00128d_\u0012,'\u000fV3ti*\u0011\u0001\"C\u0001\u0006kRLGn\u001d\u0006\u0002\u0015\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000e!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011aB\u0001\u0011i\u0016\u001cH/\u00128d_\u0012,G)Z2pI\u0016$\u0012!\u0007\t\u0003\u001diI!aG\b\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005u\u0001\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\u000b),h.\u001b;\u000b\u0003\t\n1a\u001c:h\u0013\t!sD\u0001\u0003UKN$\u0018a\u0006;fgR,enY8eKJ\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\t\u0019Q$\u0001\u000euKN$XI\\2pI\u0016$UmY8eK\u0006cwm\u001c:ji\"l7\u000f\u000b\u0002\u0005;\u0005)b/\u001a:jMf,enY8eK\u0012\u0004\u0016m]:x_J$G\u0003B\r,auBQ\u0001L\u0003A\u00025\nq!\u001a8d_\u0012,'\u000f\u0005\u0002\u0017]%\u0011qf\u0002\u0002\u0010!\u0006\u001c8o^8sI\u0016s7m\u001c3fe\")\u0011'\u0002a\u0001e\u0005A\u0001/Y:to>\u0014H\r\u0005\u00024u9\u0011A\u0007\u000f\t\u0003k=i\u0011A\u000e\u0006\u0003o-\ta\u0001\u0010:p_Rt\u0014BA\u001d\u0010\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ez\u0001\"\u0002 \u0006\u0001\u0004\u0011\u0014aB3oG>$W\r\u001a")
public class PasswordEncoderTest {
    @Test
    public void testEncodeDecode() {
        String string;
        PasswordEncoder encoder = new PasswordEncoder(new Password("password-encoder-secret"), (Option)None$.MODULE$, Defaults$.MODULE$.PasswordEncoderCipherAlgorithm(), Defaults$.MODULE$.PasswordEncoderKeyLength(), Defaults$.MODULE$.PasswordEncoderIterations());
        String password = "test-password";
        String encoded = encoder.encode(new Password(password));
        Map encodedMap = CoreUtils$.MODULE$.parseCsvMap(encoded);
        Assert.assertEquals((Object)"4096", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.IterationsProp()));
        Assert.assertEquals((Object)"128", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.KeyLengthProp()));
        try {
            SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            string = "PBKDF2WithHmacSHA512";
        }
        catch (Exception exception) {
            string = "PBKDF2WithHmacSHA1";
        }
        Assert.assertEquals((Object)string, (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp()));
        Assert.assertEquals((Object)"AES/CBC/PKCS5Padding", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.CipherAlgorithmProp()));
        this.verifyEncodedPassword(encoder, password, encoded);
    }

    @Test
    public void testEncoderConfigChange() {
        PasswordEncoder encoder = new PasswordEncoder(new Password("password-encoder-secret"), (Option)new Some((Object)"PBKDF2WithHmacSHA1"), "DES/CBC/PKCS5Padding", 64, 1024);
        String password = "test-password";
        String encoded = encoder.encode(new Password(password));
        Map encodedMap = CoreUtils$.MODULE$.parseCsvMap(encoded);
        Assert.assertEquals((Object)"1024", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.IterationsProp()));
        Assert.assertEquals((Object)"64", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.KeyLengthProp()));
        Assert.assertEquals((Object)"PBKDF2WithHmacSHA1", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.KeyFactoryAlgorithmProp()));
        Assert.assertEquals((Object)"DES/CBC/PKCS5Padding", (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.CipherAlgorithmProp()));
        PasswordEncoder decoder = new PasswordEncoder(new Password("password-encoder-secret"), (Option)new Some((Object)"PBKDF2WithHmacSHA1"), "AES/CBC/PKCS5Padding", 128, 2048);
        Assert.assertEquals((Object)password, (Object)decoder.decode(encoded).value());
        try {
            new PasswordEncoder(new Password("secret-2"), (Option)new Some((Object)"PBKDF2WithHmacSHA1"), "AES/CBC/PKCS5Padding", 128, 1024).decode(encoded);
            return;
        }
        catch (ConfigException configException) {
            return;
        }
    }

    @Test
    public void testEncodeDecodeAlgorithms() {
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "DES/CBC/PKCS5Padding", 64);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "DESede/CBC/PKCS5Padding", 192);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "AES/CBC/PKCS5Padding", 128);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "AES/CFB/PKCS5Padding", 128);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "AES/OFB/PKCS5Padding", 128);
        this.verifyEncodeDecode$1((Option)new Some((Object)"PBKDF2WithHmacSHA1"), Defaults$.MODULE$.PasswordEncoderCipherAlgorithm(), 128);
        this.verifyEncodeDecode$1((Option)None$.MODULE$, "AES/GCM/PKCS5Padding", 128);
        this.verifyEncodeDecode$1((Option)new Some((Object)"PBKDF2WithHmacSHA256"), Defaults$.MODULE$.PasswordEncoderCipherAlgorithm(), 128);
        this.verifyEncodeDecode$1((Option)new Some((Object)"PBKDF2WithHmacSHA512"), Defaults$.MODULE$.PasswordEncoderCipherAlgorithm(), 128);
    }

    private void verifyEncodedPassword(PasswordEncoder encoder, String password, String encoded) {
        Map encodedMap = CoreUtils$.MODULE$.parseCsvMap(encoded);
        Assert.assertEquals((Object)((Object)BoxesRunTime.boxToInteger((int)password.length())).toString(), (Object)encodedMap.apply((Object)PasswordEncoder$.MODULE$.PasswordLengthProp()));
        Assert.assertNotNull((String)"Invalid salt", (Object)encoder.base64Decode((String)encodedMap.apply((Object)"salt")));
        Assert.assertNotNull((String)"Invalid encoding parameters", (Object)encoder.base64Decode((String)encodedMap.apply((Object)PasswordEncoder$.MODULE$.InitializationVectorProp())));
        Assert.assertNotNull((String)"Invalid encoded password", (Object)encoder.base64Decode((String)encodedMap.apply((Object)PasswordEncoder$.MODULE$.EncyrptedPasswordProp())));
        Assert.assertEquals((Object)password, (Object)encoder.decode(encoded).value());
    }

    private final void verifyEncodeDecode$1(Option keyFactoryAlg, String cipherAlg, int keyLength) {
        PasswordEncoder encoder = new PasswordEncoder(new Password("password-encoder-secret"), keyFactoryAlg, cipherAlg, keyLength, Defaults$.MODULE$.PasswordEncoderIterations());
        String password = "test-password";
        String encoded = encoder.encode(new Password(password));
        this.verifyEncodedPassword(encoder, password, encoded);
    }
}

