/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionSpec;
import kafka.admin.ConfigCommand;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.Defaults$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.KafkaConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeqOptimized;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ConfigCommand$
implements kafka.common.Config {
    public static ConfigCommand$ MODULE$;
    private final String BrokerLoggerConfigType;
    private final Seq<String> BrokerSupportedConfigTypes;
    private final int DefaultScramIterations;
    private final Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ConfigCommand$();
    }

    @Override
    public void validateChars(String prop, String value) {
        kafka.common.Config.validateChars$(this, prop, value);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String BrokerLoggerConfigType() {
        return this.BrokerLoggerConfigType;
    }

    public Seq<String> BrokerSupportedConfigTypes() {
        return this.BrokerSupportedConfigTypes;
    }

    public int DefaultScramIterations() {
        return this.DefaultScramIterations;
    }

    public Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning() {
        return this.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning;
    }

    public void main(String[] args) {
        try {
            ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
            CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to manipulate and describe entity config for a topic, client, user or broker");
            opts.checkArgs();
            if (!opts.options().has(opts.zkConnectOpt())) {
                this.processBrokerConfig(opts);
                return;
            }
            this.processCommandWithZk((String)opts.options().valueOf(opts.zkConnectOpt()), opts);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalArgumentException ? true : (throwable instanceof InvalidConfigurationException ? true : throwable instanceof OptionException);
            if (bl) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(34).append("Failed config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString(), throwable);
                }
                System.err.println(throwable.getMessage());
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            if (throwable != null) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(49).append("Error while executing config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString(), throwable);
                }
                System.err.println(new StringBuilder(49).append("Error while executing config command with args '").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString(" ")).append("'").toString());
                throwable.printStackTrace(System.err);
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            throw null;
        }
    }

    private void processCommandWithZk(String zkConnectString, ConfigCommand.ConfigCommandOptions opts) {
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnectString, JaasUtils.isZkSecurityEnabled(), 30000, 30000, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8(), KafkaZkClient$.MODULE$.apply$default$9());
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfig(zkClient, opts, adminZkClient);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfig(zkClient, opts, adminZkClient);
            }
        }
        finally {
            zkClient.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alterConfig(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigCommand.ConfigEntity entity = this.parseEntity(opts);
        String entityType = entity.root().entityType();
        String entityName = entity.fullSanitizedName();
        String string = entityType;
        String string2 = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.preProcessScramCredentials(configsToBeAdded);
        } else {
            Set dynamicBrokerConfigs;
            String string3 = entityType;
            String string4 = ConfigType$.MODULE$.Broker();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null) && (dynamicBrokerConfigs = (Set)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$1(elem)))).nonEmpty()) {
                String string5 = entityName;
                String string6 = ConfigEntityName$.MODULE$.Default();
                boolean perBrokerConfig = string5 == null ? string6 != null : !string5.equals(string6);
                String errorMessage = new StringBuilder(70).append("--bootstrap-server option must be specified to update broker configs ").append(dynamicBrokerConfigs).append(".").toString();
                String info = "Broker configuration updates using ZooKeeper are supported for bootstrapping before brokers are started to enable encrypted password configs to be stored in ZooKeeper.";
                if (perBrokerConfig) {
                    Option<Object> option = adminZkClient.parseBroker(entityName);
                    if (option == null) {
                        throw null;
                    }
                    Option<Object> foreach_this = option;
                    if (!foreach_this.isEmpty()) {
                        int n = BoxesRunTime.unboxToInt((Object)foreach_this.get());
                        ConfigCommand$.$anonfun$alterConfig$2(zkClient, errorMessage, entityName, info, n);
                    }
                } else {
                    void require_requirement;
                    boolean bl = zkClient.getAllBrokersInCluster().isEmpty();
                    if (Predef$.MODULE$ == null) {
                        throw null;
                    }
                    if (require_requirement == false) {
                        throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$alterConfig$4(errorMessage, info)).toString());
                    }
                }
                this.preProcessBrokerConfigs(configsToBeAdded, perBrokerConfig);
            }
        }
        Properties configs = adminZkClient.fetchEntityConfig(entityType, entityName);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)configs.containsKey(x$1)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
        }
        Implicits$.MODULE$.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
        configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$2 -> configs.remove(x$2));
        adminZkClient.changeConfigs(entityType, entityName, configs);
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Completed Updating config for entity: ").append(entity).append(".").toString());
    }

    private void preProcessScramCredentials(Properties configsToBeAdded) {
        ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values()));
        int foreach_len = foreach_this.length();
        for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
            ScramMechanism scramMechanism = (ScramMechanism)foreach_this.apply(foreach_i);
            ConfigCommand$.$anonfun$preProcessScramCredentials$1(this, configsToBeAdded, scramMechanism);
        }
    }

    public PasswordEncoder createPasswordEncoder(Map<String, String> encoderConfigs) {
        encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
        String encoderSecret = (String)encoderConfigs.getOrElse((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Password encoder secret not specified");
        });
        Option option = encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp());
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? Defaults$.MODULE$.PasswordEncoderCipherAlgorithm() : getOrElse_this.get();
        Option option2 = encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp());
        if (option2 == null) {
            throw null;
        }
        Option map_this = option2;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$3((String)map_this.get())));
        if (object2 == null) {
            throw null;
        }
        Object object3 = object2.isEmpty() ? BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.PasswordEncoderKeyLength()) : object2.get();
        Option option3 = encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp());
        if (option3 == null) {
            throw null;
        }
        Option map_this2 = option3;
        Object object4 = map_this2.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$5((String)map_this2.get())));
        if (object4 == null) {
            throw null;
        }
        Object object5 = object4.isEmpty() ? BoxesRunTime.boxToInteger((int)Defaults$.MODULE$.PasswordEncoderIterations()) : object4.get();
        return new PasswordEncoder(new Password(encoderSecret), (Option<String>)None$.MODULE$, (String)object, BoxesRunTime.unboxToInt((Object)object3), BoxesRunTime.unboxToInt((Object)object5));
    }

    /*
     * WARNING - void declaration
     */
    private void preProcessBrokerConfigs(Properties configsToBeAdded, boolean perBrokerConfig) {
        Properties passwordEncoderConfigs = new Properties();
        Implicits$.MODULE$.PropertiesOps(passwordEncoderConfigs).$plus$plus$eq((Map<String, Object>)((Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$preProcessBrokerConfigs$1(x0$1)))));
        if (!passwordEncoderConfigs.isEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(ConfigCommand$.$anonfun$preProcessBrokerConfigs$2(passwordEncoderConfigs)));
            }
            ((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()).keySet().foreach((Function1 & Serializable & scala.Serializable)x$1 -> configsToBeAdded.remove(x$1));
        }
        DynamicBrokerConfig$.MODULE$.validateConfigs(configsToBeAdded, perBrokerConfig);
        Set passwordConfigs = (Set)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)));
        if (passwordConfigs.nonEmpty()) {
            void require_requirement;
            boolean bl = passwordEncoderConfigs.containsKey(KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            if (require_requirement == false) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$preProcessBrokerConfigs$5(passwordConfigs)).toString());
            }
            PasswordEncoder passwordEncoder = this.createPasswordEncoder((Map<String, String>)((Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()));
            passwordConfigs.foreach((Function1 & Serializable & scala.Serializable)configName -> {
                String encodedValue = passwordEncoder.encode(new Password(configsToBeAdded.getProperty((String)configName)));
                return configsToBeAdded.setProperty((String)configName, encodedValue);
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private void describeConfig(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        configEntity = this.parseEntity(opts);
        v0 = configEntity.root().entityType();
        var6_5 = ConfigType$.MODULE$.User();
        if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
        if (!configEntity.root().sanitizedName().isDefined() && !configEntity.child().isDefined()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        describeAllUsers = v1;
        configEntity.getAllEntities(zkClient).foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$describeConfig$1$adapted(kafka.zk.AdminZkClient boolean kafka.admin.ConfigCommand$ConfigEntity ), (Lkafka/admin/ConfigCommand$ConfigEntity;)Ljava/lang/Object;)((AdminZkClient)adminZkClient, (boolean)describeAllUsers));
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        void var2_2;
        Properties props = new Properties();
        if (opts.options().has(opts.addConfig())) {
            String pattern = "(?=[^\\]]*(?:\\[|$))";
            String[][] configsToBeAdded = (String[][])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)opts.options().valueOf(opts.addConfig())).split(new StringBuilder(1).append(",").append(pattern).toString()))), (Function1 & Serializable & scala.Serializable)x$6 -> x$6.split(new StringBuilder(7).append("\\s*=\\s*").append(pattern).toString(), -1), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
            boolean bl = IndexedSeqOptimized.forall$((IndexedSeqOptimized)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded)), (Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$parseConfigsToBeAdded$2(config)));
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            if (!bl) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$parseConfigsToBeAdded$3()).toString());
            }
            ArrayOps.ofRef foreach_this = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded));
            int foreach_len = foreach_this.length();
            for (int foreach_i = 0; foreach_i < foreach_len; ++foreach_i) {
                String[] stringArray = (String[])foreach_this.apply(foreach_i);
                props.setProperty(stringArray[0].trim(), stringArray[1].replaceAll("\\[?\\]?", "").trim());
            }
            if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
                Predef$.MODULE$.println((Object)new StringBuilder(165).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker.").toString());
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        if (opts.options().has(opts.deleteConfig())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.deleteConfig())).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.trim(), Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$8 -> propsToBeDeleted.setProperty((String)x$8, ""));
            return var2_2;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    private void processBrokerConfig(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        AdminClient adminClient = AdminClient.create((Properties)props);
        String entityName = opts.options().has(opts.entityName()) ? (String)opts.options().valueOf(opts.entityName()) : "";
        Buffer entityTypes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
        if (entityTypes.size() != 1) {
            throw new IllegalArgumentException(new StringBuilder(77).append("Exactly one --entity-type (out of ").append(this.BrokerSupportedConfigTypes().mkString(",")).append(") must be specified with --bootstrap-server").toString());
        }
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterBrokerConfig((Admin)adminClient, opts, (String)entityTypes.head(), entityName);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeBrokerConfig((Admin)adminClient, opts, (String)entityTypes.head(), entityName);
            }
        }
        finally {
            adminClient.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void alterBrokerConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts, String entityType, String entityName) {
        scala.collection.mutable.Map configsToBeAdded = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.parseConfigsToBeAdded(opts)).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)k, (Object)new ConfigEntry(k, v));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        String string = entityType;
        String string2 = ConfigType$.MODULE$.Broker();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            void $minus$greater$extension_$this;
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityName);
            scala.collection.immutable.Map oldConfig = ((TraversableOnce)this.brokerConfig(adminClient, entityName, false).map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)entry.name(), entry), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
            if (invalidConfigs.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
            }
            scala.collection.immutable.Map newEntries = (scala.collection.immutable.Map)oldConfig.$plus$plus((GenTraversableOnce)configsToBeAdded).$minus$minus(configsToBeDeleted);
            scala.collection.immutable.Map sensitiveEntries = (scala.collection.immutable.Map)newEntries.filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterBrokerConfig$4(x$9)));
            if (sensitiveEntries.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(84).append("All sensitive broker config entries must be specified for --alter, missing entries: ").append(sensitiveEntries.keySet()).toString());
            }
            Config newConfig = new Config(((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newEntries).asJava()).values());
            AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
            Tuple2[] tuple2Array = new Tuple2[1];
            Object object = Predef$.MODULE$.ArrowAssoc((Object)configResource);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)newConfig);
            adminClient.alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
        } else {
            String string3 = entityType;
            String string4 = this.BrokerLoggerConfigType();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                void $minus$greater$extension_$this;
                ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, entityName);
                Seq validLoggers = (Seq)this.brokerLoggerConfigs(adminClient, entityName).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.name(), Seq$.MODULE$.canBuildFrom());
                Seq invalidBrokerLoggers = (Seq)((TraversableLike)configsToBeDeleted.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem)))).$plus$plus((GenTraversableOnce)configsToBeAdded.keys().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem))), Seq$.MODULE$.canBuildFrom());
                if (invalidBrokerLoggers.nonEmpty()) {
                    throw new InvalidConfigurationException(new StringBuilder(26).append("Invalid broker logger(s): ").append(invalidBrokerLoggers.mkString(",")).toString());
                }
                AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                Collection alterLogLevelEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)((TraversableLike)configsToBeAdded.values().map((Function1 & Serializable & scala.Serializable)x$11 -> new AlterConfigOp(x$11, AlterConfigOp.OpType.SET), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)configsToBeDeleted.map((Function1 & Serializable & scala.Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).asJavaCollection();
                Tuple2[] tuple2Array = new Tuple2[1];
                Object object = Predef$.MODULE$.ArrowAssoc((Object)configResource);
                if (Predef.ArrowAssoc$.MODULE$ == null) {
                    throw null;
                }
                tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)alterLogLevelEntries);
                adminClient.incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
            }
        }
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (new StringOps(entityName).nonEmpty()) {
            Predef$.MODULE$.println((Object)new StringBuilder(39).append("Completed updating config for broker: ").append(entityName).append(".").toString());
            return;
        }
        Predef$.MODULE$.println((Object)"Completed updating default config for brokers in the cluster,");
    }

    private void describeBrokerConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts, String entityType, String entityName) {
        Seq<ConfigEntry> configs;
        String string = entityType;
        String string2 = ConfigType$.MODULE$.Broker();
        Seq<ConfigEntry> seq = !(string != null ? !string.equals(string2) : string2 != null) ? this.brokerConfig(adminClient, entityName, true) : (configs = this.brokerLoggerConfigs(adminClient, entityName));
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (new StringOps(entityName).nonEmpty()) {
            Predef$.MODULE$.println((Object)new StringBuilder(24).append("Configs for broker ").append(entityName).append(" are:").toString());
        } else {
            Predef$.MODULE$.println((Object)"Default config for brokers in the cluster are:");
        }
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            ConfigCommand$.$anonfun$describeBrokerConfig$1(config);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<ConfigEntry> brokerConfig(Admin adminClient, String entityName, boolean includeSynonyms) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityName);
        ConfigEntry.ConfigSource configSource = !entityName.isEmpty() ? ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG : ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
        DescribeConfigsOptions describeOpts = new DescribeConfigsOptions().includeSynonyms(includeSynonyms);
        java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource), describeOpts).all().get(30L, TimeUnit.SECONDS);
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)configs.get(configResource)).entries()).asScala()).filter((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$brokerConfig$1(configSource, entry)))).toSeq();
    }

    private Seq<ConfigEntry> brokerLoggerConfigs(Admin adminClient, String entityName) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, entityName);
        java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource)).all().get(30L, TimeUnit.SECONDS);
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)configs.get(configResource)).entries()).asScala()).toSeq();
    }

    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        Object object;
        Buffer entityTypes;
        block6: {
            block5: {
                entityTypes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
                Object object2 = entityTypes.head();
                String string = ConfigType$.MODULE$.User();
                if (!(object2 == null ? string != null : !object2.equals(string))) break block5;
                Object object3 = entityTypes.head();
                String string2 = ConfigType$.MODULE$.Client();
                if (object3 != null ? !object3.equals(string2) : string2 != null) break block6;
            }
            return this.parseQuotaEntity(opts);
        }
        if (opts.options().has(opts.entityName())) {
            object = new Some(opts.options().valueOf(opts.entityName()));
        } else {
            Object object4 = entityTypes.head();
            String string = ConfigType$.MODULE$.Broker();
            object = !(object4 != null ? !object4.equals(string) : string != null) && opts.options().has((OptionSpec)opts.entityDefault()) ? new Some((Object)ConfigEntityName$.MODULE$.Default()) : None$.MODULE$;
        }
        Some name = object;
        return new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)entityTypes.head(), (Option<String>)name), (Option<ConfigCommand.Entity>)None$.MODULE$);
    }

    private Seq<String> entityNames(ConfigCommand.ConfigCommandOptions opts) {
        java.util.Iterator namesIterator = opts.options().valuesOf(opts.entityName()).iterator();
        return (Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().specs()).asScala()).filter((Function1 & Serializable & scala.Serializable)spec -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$entityNames$1(spec)))).map((Function1 & Serializable & scala.Serializable)spec -> {
            if (spec.options().contains("entity-name")) {
                return (String)namesIterator.next();
            }
            return "";
        }, Buffer$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseQuotaEntity(ConfigCommand.ConfigCommandOptions opts) {
        types = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
        names = this.entityNames(opts);
        if (opts.options().has((OptionSpec)opts.alterOpt()) && names.size() != types.size()) {
            throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
        }
        if (types.size() != 2) ** GOTO lbl-1000
        v0 = types.head();
        var5_4 = ConfigType$.MODULE$.Client();
        if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? (Buffer)types.reverse() : types;
        sortedNames = ((IterableLike)(reverse != false && names.length() == 2 ? names.reverse() : names)).iterator();
        entities = (Buffer)entityTypes.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseQuotaEntity$1(scala.collection.Iterator java.lang.String ), (Ljava/lang/String;)Lkafka/admin/ConfigCommand$Entity;)((Iterator)sortedNames), Buffer$.MODULE$.canBuildFrom());
        return new ConfigCommand.ConfigEntity((ConfigCommand.Entity)entities.head(), (Option<ConfigCommand.Entity>)(entities.size() > 1 ? new Some(entities.apply(1)) : None$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$1(String elem) {
        return MODULE$.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning().contains((Object)elem);
    }

    public static final /* synthetic */ String $anonfun$alterConfig$3(String errorMessage$1, String entityName$1, String info$1) {
        return new StringBuilder(26).append(errorMessage$1).append(" when broker ").append(entityName$1).append(" is running. ").append(info$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$alterConfig$2(KafkaZkClient zkClient$1, String errorMessage$1, String entityName$1, String info$1, int brokerId) {
        void require_requirement;
        boolean bl = zkClient$1.getBroker(brokerId).isEmpty();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (require_requirement == false) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)ConfigCommand$.$anonfun$alterConfig$3(errorMessage$1, entityName$1, info$1)).toString());
        }
    }

    public static final /* synthetic */ String $anonfun$alterConfig$4(String errorMessage$1, String info$1) {
        return new StringBuilder(47).append(errorMessage$1).append(" for default cluster if any broker is running. ").append(info$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String scramCredential$1(ScramMechanism mechanism, String credentialStr) {
        void var5_6;
        int n;
        String string = "(?:iterations=([0-9]*),)?password=(.*)";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Option option = new StringOps(string).r().unapplySeq((CharSequence)credentialStr);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String iterations = (String)((LinearSeqOptimized)option.get()).apply(0);
            String password = (String)((LinearSeqOptimized)option.get()).apply(1);
            if (iterations != null) {
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                n = new StringOps(iterations).toInt();
            } else {
                n = this.DefaultScramIterations();
            }
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid credential property ").append(mechanism).append("=").append(credentialStr).toString());
        }
        int n2 = n;
        if (n2 < mechanism.minIterations()) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Iterations ").append(n2).append(" is less than the minimum ").append(mechanism.minIterations()).append(" required for ").append(mechanism).toString());
        }
        return ScramCredentialUtils.credentialToString((ScramCredential)new ScramFormatter(mechanism).generateCredential((String)var5_6, n2));
    }

    public static final /* synthetic */ Object $anonfun$preProcessScramCredentials$1(ConfigCommand$ $this, Properties configsToBeAdded$1, ScramMechanism mechanism) {
        String string = configsToBeAdded$1.getProperty(mechanism.mechanismName());
        Object object = string == null ? BoxedUnit.UNIT : configsToBeAdded$1.setProperty(mechanism.mechanismName(), $this.scramCredential$1(mechanism, string));
        return object;
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$3(String x$4) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(x$4).toInt();
    }

    public static final /* synthetic */ int $anonfun$createPasswordEncoder$5(String x$5) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(x$5).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$preProcessBrokerConfigs$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((String)x0$1._1()).startsWith("password.encoder.");
        return bl;
    }

    public static final /* synthetic */ String $anonfun$preProcessBrokerConfigs$2(Properties passwordEncoderConfigs$1) {
        return new StringBuilder(101).append("Password encoder configs ").append(passwordEncoderConfigs$1.keySet()).append(" will be used for encrypting").append(" passwords, but will not be stored in ZooKeeper.").toString();
    }

    public static final /* synthetic */ String $anonfun$preProcessBrokerConfigs$5(Set passwordConfigs$1) {
        return new StringBuilder(226).append(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()).append(" must be specified to update ").append(passwordConfigs$1).append(".").append(" Other password encoder configs like cipher algorithm and iterations may also be specified").append(" to override the default encoding parameters. Password encoder configs will not be persisted").append(" in ZooKeeper.").toString();
    }

    public static final /* synthetic */ void $anonfun$describeConfig$1(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        Properties configs = adminZkClient$1.fetchEntityConfig(entity.root().entityType(), entity.fullSanitizedName());
        if (!configs.isEmpty() || !describeAllUsers$1) {
            String string = "Configs for %s are %s";
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{entity, ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configs).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString(), scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).mkString(",")})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigsToBeAdded$2(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ String $anonfun$parseConfigsToBeAdded$3() {
        return "Invalid entity config: all configs to be added must be in the format \"key=val\".";
    }

    public static final /* synthetic */ boolean $anonfun$alterBrokerConfig$4(Tuple2 x$9) {
        return ((ConfigEntry)x$9._2()).value() == null;
    }

    public static final /* synthetic */ void $anonfun$describeBrokerConfig$1(ConfigEntry config) {
        String synonyms = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(config.synonyms()).asScala()).map((Function1 & Serializable & scala.Serializable)synonym -> new StringBuilder(2).append(synonym.source()).append(":").append(synonym.name()).append("=").append(synonym.value()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("  ").append(config.name()).append("=").append(config.value()).append(" sensitive=").append(config.isSensitive()).append(" synonyms={").append(synonyms).append("}").toString());
    }

    public static final /* synthetic */ boolean $anonfun$brokerConfig$1(ConfigEntry.ConfigSource configSource$1, ConfigEntry entry) {
        ConfigEntry.ConfigSource configSource = entry.source();
        return !(configSource != null ? !configSource.equals(configSource$1) : configSource$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$entityNames$1(OptionSpec spec) {
        return spec.options().contains("entity-name") || spec.options().contains("entity-default");
    }

    private static final String sanitizeName$1(String entityType, String name) {
        boolean bl;
        if (name.isEmpty()) {
            return ConfigEntityName$.MODULE$.Default();
        }
        String string = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            bl = true;
        } else {
            String string2 = ConfigType$.MODULE$.Client();
            bl = !(string2 != null ? !string2.equals(entityType) : entityType != null);
        }
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder(20).append("Invalid entity type ").append(entityType).toString());
        }
        String string3 = Sanitizer.sanitize((String)name);
        return string3;
    }

    public static final /* synthetic */ ConfigCommand.Entity $anonfun$parseQuotaEntity$1(Iterator sortedNames$1, String t) {
        return new ConfigCommand.Entity(t, (Option<String>)(sortedNames$1.hasNext() ? new Some((Object)ConfigCommand$.sanitizeName$1(t, (String)sortedNames$1.next())) : None$.MODULE$));
    }

    private ConfigCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        kafka.common.Config.$init$(this);
        this.BrokerLoggerConfigType = "broker-loggers";
        this.BrokerSupportedConfigTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Broker(), this.BrokerLoggerConfigType()}));
        this.DefaultScramIterations = 4096;
        this.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()}));
    }

    public static final /* synthetic */ Object $anonfun$createPasswordEncoder$3$adapted(String x$4) {
        return BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$3(x$4));
    }

    public static final /* synthetic */ Object $anonfun$createPasswordEncoder$5$adapted(String x$5) {
        return BoxesRunTime.boxToInteger((int)ConfigCommand$.$anonfun$createPasswordEncoder$5(x$5));
    }

    public static final /* synthetic */ Object $anonfun$describeConfig$1$adapted(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        ConfigCommand$.$anonfun$describeConfig$1(adminZkClient$1, describeAllUsers$1, entity);
        return BoxedUnit.UNIT;
    }
}

