/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t%xAB\u001f?\u0011\u0003qDI\u0002\u0004G}!\u0005ah\u0012\u0005\u0006\u001d\u0006!\t\u0001\u0015\u0005\u0006#\u0006!\tA\u0015\u0005\u0007#\u0006!\tAa'\t\u000f\t%\u0016\u0001\"\u0001\u0003,\"9!qW\u0001\u0005\u0002\te\u0006\"\u0003Ba\u0003\t\u0007I\u0011\u0002Bb\u0011!\u0011y-\u0001Q\u0001\n\t\u0015\u0007\"\u0003Bi\u0003E\u0005I\u0011\u0001Bj\r\u00151e\b\u0001 U\u0011!Y&B!b\u0001\n\u0003a\u0006\u0002\u00035\u000b\u0005\u0003\u0005\u000b\u0011B/\t\u0011%T!\u00111A\u0005\u0002)D\u0001B\u001c\u0006\u0003\u0002\u0004%\ta\u001c\u0005\tk*\u0011\t\u0011)Q\u0005W\"AaO\u0003BA\u0002\u0013\u0005q\u000f\u0003\u0005|\u0015\t\u0005\r\u0011\"\u0001}\u0011!q(B!A!B\u0013A\b\"C@\u000b\u0005\u0003\u0007I\u0011AA\u0001\u0011)\tIA\u0003BA\u0002\u0013\u0005\u00111\u0002\u0005\u000b\u0003\u001fQ!\u0011!Q!\n\u0005\r\u0001BCA\t\u0015\t\u0005\r\u0011\"\u0001\u0002\u0014!Q\u00111\u0004\u0006\u0003\u0002\u0004%\t!!\b\t\u0015\u0005\u0005\"B!A!B\u0013\t)\u0002\u0003\u0006\u0002$)\u0011)\u0019!C\u0001\u0003KA!\"!\u0014\u000b\u0005\u0003\u0005\u000b\u0011BA\u0014\u0011%\tyE\u0003BA\u0002\u0013\u0005!\u000e\u0003\u0006\u0002R)\u0011\t\u0019!C\u0001\u0003'B\u0011\"a\u0016\u000b\u0005\u0003\u0005\u000b\u0015B6\t\u0013\u0005\u0005$B!a\u0001\n\u0003Q\u0007BCA2\u0015\t\u0005\r\u0011\"\u0001\u0002f!I\u0011\u0011\u000e\u0006\u0003\u0002\u0003\u0006Ka\u001b\u0005\u0007\u001d*!\t!!\u001c\t\u0013\u0005}$\u00021A\u0005\u0002\u0005\u0005\u0005\"CAE\u0015\u0001\u0007I\u0011AAF\u0011!\tyI\u0003Q!\n\u0005\r\u0005BCAI\u0015\t\u0007I\u0011\u0001 \u0002\u0014\"A\u0011Q\u0016\u0006!\u0002\u0013\t)\nC\u0004\u00020*!\t!!-\t\u000f\u0005U'\u0002\"\u0001\u0002X\"9\u00111\u001d\u0006\u0005\u0002\u0005\u0015\bbBAv\u0015\u0011\u0005\u0011Q\u001e\u0005\b\u0003kTA\u0011AAw\u0011\u001d\t9P\u0003C\u0001\u0003sDqAa\u0001\u000b\t\u0003\u0011)\u0001C\u0004\u0003\u0010)!\tA!\u0005\t\u000f\t\r\"\u0002\"\u0001\u0003&!9!Q\u0006\u0006\u0005\u0002\t=\u0002b\u0002B\u001a\u0015\u0011\u0005\u0011Q\u001e\u0005\b\u0005kQA\u0011\u0001B\u001c\u0011\u001d\u0011yD\u0003C\u0005\u0005oAqA!\u0011\u000b\t\u0013\u0011\u0019\u0005C\u0004\u0003Z)!\tAa\u0017\t\u000f\t\u0005$\u0002\"\u0003\u0003d!9!q\r\u0006\u0005\n\t%\u0004b\u0002B7\u0015\u0011%!q\u000e\u0005\b\u0005kRA\u0011\u0001B\u001c\u0011\u001d\u00119H\u0003C!\u0005sBqAa\u001f\u000b\t\u0003\u0012i\bC\u0004\u0003\u0004*!\tE!\"\u0002'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u000b\u0005}\u0002\u0015a\u0003;sC:\u001c\u0018m\u0019;j_:T!!\u0011\"\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u0007\u0006)1.\u00194lCB\u0011Q)A\u0007\u0002}\t\u0019BK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCN\u0011\u0011\u0001\u0013\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012\u0001R\u0001\u0006CB\u0004H.\u001f\u000b\f'\n=%\u0011\u0013BJ\u0005+\u00139\n\u0005\u0002F\u0015M\u0019!\u0002S+\u0011\u0005YKV\"A,\u000b\u0005a\u0013\u0015!B;uS2\u001c\u0018B\u0001.X\u0005\u001daunZ4j]\u001e\fq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u000b\u0002;B\u0011a,\u001a\b\u0003?\u000e\u0004\"\u0001\u0019&\u000e\u0003\u0005T!AY(\u0002\rq\u0012xn\u001c;?\u0013\t!'*\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001e\u0014aa\u0015;sS:<'B\u00013K\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007%\u0001\u0006qe>$WoY3s\u0013\u0012,\u0012a\u001b\t\u0003\u00132L!!\u001c&\u0003\t1{gnZ\u0001\u000faJ|G-^2fe&#w\fJ3r)\t\u00018\u000f\u0005\u0002Jc&\u0011!O\u0013\u0002\u0005+:LG\u000fC\u0004u\u001d\u0005\u0005\t\u0019A6\u0002\u0007a$\u0013'A\u0006qe>$WoY3s\u0013\u0012\u0004\u0013!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007.F\u0001y!\tI\u00150\u0003\u0002{\u0015\n)1\u000b[8si\u0006\t\u0002O]8ek\u000e,'/\u00129pG\"|F%Z9\u0015\u0005Al\bb\u0002;\u0012\u0003\u0003\u0005\r\u0001_\u0001\u000faJ|G-^2fe\u0016\u0003xn\u00195!\u00031!\bP\u001c+j[\u0016|W\u000f^'t+\t\t\u0019\u0001E\u0002J\u0003\u000bI1!a\u0002K\u0005\rIe\u000e^\u0001\u0011ibtG+[7f_V$Xj]0%KF$2\u0001]A\u0007\u0011!!H#!AA\u0002\u0005\r\u0011!\u0004;y]RKW.Z8vi6\u001b\b%A\u0003ti\u0006$X-\u0006\u0002\u0002\u0016A\u0019Q)a\u0006\n\u0007\u0005eaH\u0001\tUe\u0006t7/Y2uS>t7\u000b^1uK\u0006I1\u000f^1uK~#S-\u001d\u000b\u0004a\u0006}\u0001\u0002\u0003;\u0018\u0003\u0003\u0005\r!!\u0006\u0002\rM$\u0018\r^3!\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cXCAA\u0014!\u0019\tI#a\r\u000285\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0004nkR\f'\r\\3\u000b\u0007\u0005E\"*\u0001\u0006d_2dWm\u0019;j_:LA!!\u000e\u0002,\t\u00191+\u001a;\u0011\t\u0005e\u0012\u0011J\u0007\u0003\u0003wQA!!\u0010\u0002@\u000511m\\7n_:T1aQA!\u0015\u0011\t\u0019%!\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t9%A\u0002pe\u001eLA!a\u0013\u0002<\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003E!\bP\\*uCJ$H+[7fgR\fW\u000e]\u0001\u0016ibt7\u000b^1siRKW.Z:uC6\u0004x\fJ3r)\r\u0001\u0018Q\u000b\u0005\bir\t\t\u00111\u0001l\u0003I!\bP\\*uCJ$H+[7fgR\fW\u000e\u001d\u0011)\u0007u\tY\u0006E\u0002J\u0003;J1!a\u0018K\u0005!1x\u000e\\1uS2,\u0017A\u0006;y]2\u000b7\u000f^+qI\u0006$X\rV5nKN$\u0018-\u001c9\u00025QDh\u000eT1tiV\u0003H-\u0019;f)&lWm\u001d;b[B|F%Z9\u0015\u0007A\f9\u0007C\u0004u?\u0005\u0005\t\u0019A6\u0002/QDh\u000eT1tiV\u0003H-\u0019;f)&lWm\u001d;b[B\u0004\u0003f\u0001\u0011\u0002\\Q\t2+a\u001c\u0002r\u0005M\u0014QOA<\u0003s\nY(! \t\u000bm\u000b\u0003\u0019A/\t\u000b%\f\u0003\u0019A6\t\u000bY\f\u0003\u0019\u0001=\t\r}\f\u0003\u0019AA\u0002\u0011\u001d\t\t\"\ta\u0001\u0003+Aq!a\t\"\u0001\u0004\t9\u0003\u0003\u0005\u0002P\u0005\u0002\n\u00111\u0001l\u0011\u0019\t\t'\ta\u0001W\u0006a\u0001/\u001a8eS:<7\u000b^1uKV\u0011\u00111\u0011\t\u0006\u0013\u0006\u0015\u0015QC\u0005\u0004\u0003\u000fS%AB(qi&|g.\u0001\tqK:$\u0017N\\4Ti\u0006$Xm\u0018\u0013fcR\u0019\u0001/!$\t\u0011Q\u001c\u0013\u0011!a\u0001\u0003\u0007\u000bQ\u0002]3oI&twm\u0015;bi\u0016\u0004\u0013\u0001\u00027pG.,\"!!&\u0011\t\u0005]\u0015\u0011V\u0007\u0003\u00033SA!a'\u0002\u001e\u0006)An\\2lg*!\u0011qTAQ\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003G\u000b)+\u0001\u0003vi&d'BAAT\u0003\u0011Q\u0017M^1\n\t\u0005-\u0016\u0011\u0014\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002\u000b1|7m\u001b\u0011\u0002\r%tGj\\2l+\u0011\t\u0019,!/\u0015\t\u0005U\u00161\u001a\t\u0005\u0003o\u000bI\f\u0004\u0001\u0005\u000f\u0005mvE1\u0001\u0002>\n\tA+\u0005\u0003\u0002@\u0006\u0015\u0007cA%\u0002B&\u0019\u00111\u0019&\u0003\u000f9{G\u000f[5oOB\u0019\u0011*a2\n\u0007\u0005%'JA\u0002B]fD\u0001\"!4(\t\u0003\u0007\u0011qZ\u0001\u0004MVt\u0007#B%\u0002R\u0006U\u0016bAAj\u0015\nAAHY=oC6,g(A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0004a\u0006e\u0007bBAnQ\u0001\u0007\u0011Q\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bCBAp\u0003C\f9$\u0004\u0002\u00020%!\u0011QGA\u0018\u0003=\u0011X-\\8wKB\u000b'\u000f^5uS>tGc\u00019\u0002h\"9\u0011\u0011^\u0015A\u0002\u0005]\u0012A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0011aJ,\u0007/\u0019:f\u001d>$&/\u00198tSR$\"!a<\u0011\u0007\u0015\u000b\t0C\u0002\u0002tz\u0012!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\u0006I\u0002O]3qCJ,g)\u001a8dKB\u0013x\u000eZ;dKJ,\u0005o\\2i\u0003u\u0001(/\u001a9be\u0016Len\u0019:f[\u0016tG\u000f\u0015:pIV\u001cWM]#q_\u000eDGCBAx\u0003w\fy\u0010C\u0004\u0002~2\u0002\r!a\u0001\u0002\u001f9,w\u000f\u0016=o)&lWm\\;u\u001bNDaA!\u0001-\u0001\u0004Y\u0017aD;qI\u0006$X\rV5nKN$\u0018-\u001c9\u00023A\u0014X\r]1sKB\u0013x\u000eZ;dKJLEMU8uCRLwN\u001c\u000b\t\u0003_\u00149Aa\u0003\u0003\u000e!1!\u0011B\u0017A\u0002-\fQB\\3x!J|G-^2fe&#\u0007bBA\u007f[\u0001\u0007\u00111\u0001\u0005\u0007\u0005\u0003i\u0003\u0019A6\u0002)A\u0014X\r]1sK\u0006#G\rU1si&$\u0018n\u001c8t)\u0019\tyOa\u0005\u0003\"!9!Q\u0003\u0018A\u0002\t]\u0011\u0001F1eI\u0016$Gk\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0003\u001a\t}\u0011qG\u0007\u0003\u00057QAA!\b\u00020\u0005I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0003k\u0011Y\u0002\u0003\u0004\u0003\u00029\u0002\ra[\u0001\u0015aJ,\u0007/\u0019:f\u0003\n|'\u000f^(s\u0007>lW.\u001b;\u0015\r\u0005=(q\u0005B\u0016\u0011\u001d\u0011Ic\fa\u0001\u0003+\t\u0001B\\3x'R\fG/\u001a\u0005\u0007\u0005\u0003y\u0003\u0019A6\u0002\u001fA\u0014X\r]1sK\u000e{W\u000e\u001d7fi\u0016$B!a<\u00032!1!\u0011\u0001\u0019A\u0002-\f1\u0002\u001d:fa\u0006\u0014X\rR3bI\u0006A\u0012n\u001d)s_\u0012,8-\u001a:Fa>\u001c\u0007.\u0012=iCV\u001cH/\u001a3\u0016\u0005\te\u0002cA%\u0003<%\u0019!Q\b&\u0003\u000f\t{w\u000e\\3b]\u0006)\u0002.Y:QK:$\u0017N\\4Ue\u0006t7/Y2uS>t\u0017a\u00059sKB\f'/\u001a+sC:\u001c\u0018\u000e^5p]R{G\u0003EAx\u0005\u000b\u00129E!\u0013\u0003N\t=#1\u000bB,\u0011\u001d\u0011I\u0003\u000ea\u0001\u0003+AaA!\u00035\u0001\u0004Y\u0007B\u0002B&i\u0001\u0007\u00010\u0001\u0005oK^,\u0005o\\2i\u0011\u001d\ti\u0010\u000ea\u0001\u0003\u0007AqA!\u00155\u0001\u0004\u00119\"\u0001\noK^$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bB\u0002B+i\u0001\u00071.\u0001\u000boK^$\u0006P\\*uCJ$H+[7fgR\fW\u000e\u001d\u0005\u0007\u0005\u0003!\u0004\u0019A6\u0002)\r|W\u000e\u001d7fi\u0016$&/\u00198tSRLwN\u001c+p)\r\u0001(Q\f\u0005\b\u0005?*\u0004\u0019AAx\u0003=!(/\u00198tSRlU\r^1eCR\f\u0017A\u0005<bY&$\u0007K]8ek\u000e,'/\u00129pG\"$BA!\u000f\u0003f!9!q\f\u001cA\u0002\u0005=\u0018A\u0006<bY&$\u0007K]8ek\u000e,'/\u00129pG\"\u0014U/\u001c9\u0015\t\te\"1\u000e\u0005\b\u0005?:\u0004\u0019AAx\u0003m!\bN]8x'R\fG/\u001a+sC:\u001c\u0018\u000e^5p]\u001a\u000b\u0017\u000e\\;sKR\u0019\u0001O!\u001d\t\u000f\tM\u0004\b1\u0001\u0002p\u0006\u0011B\u000f\u001f8Ue\u0006t7/\u001b;NKR\fG-\u0019;b\u0003m\u0001XM\u001c3j]\u001e$&/\u00198tSRLwN\\%o!J|wM]3tg\u0006AAo\\*ue&tw\rF\u0001^\u0003\u0019)\u0017/^1mgR!!\u0011\bB@\u0011\u001d\u0011\ti\u000fa\u0001\u0003\u000b\fA\u0001\u001e5bi\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u0004!\u001a!B!#\u0011\u0007Y\u0013Y)C\u0002\u0003\u000e^\u0013QB\\8oi\"\u0014X-\u00193tC\u001a,\u0007\"B.\u0004\u0001\u0004i\u0006\"B5\u0004\u0001\u0004Y\u0007\"\u0002<\u0004\u0001\u0004A\bBB@\u0004\u0001\u0004\t\u0019\u0001\u0003\u0004\u0003\u001a\u000e\u0001\ra[\u0001\ni&lWm\u001d;b[B$Rb\u0015BO\u0005?\u0013\tKa)\u0003&\n\u001d\u0006\"B.\u0005\u0001\u0004i\u0006\"B5\u0005\u0001\u0004Y\u0007\"\u0002<\u0005\u0001\u0004A\bBB@\u0005\u0001\u0004\t\u0019\u0001C\u0004\u0002\u0012\u0011\u0001\r!!\u0006\t\r\teE\u00011\u0001l\u0003-\u0011\u0017\u0010^3U_N#\u0018\r^3\u0015\t\u0005U!Q\u0016\u0005\b\u0005_+\u0001\u0019\u0001BY\u0003\u0011\u0011\u0017\u0010^3\u0011\u0007%\u0013\u0019,C\u0002\u00036*\u0013AAQ=uK\u0006\t\u0012n\u001d,bY&$GK]1og&$\u0018n\u001c8\u0015\r\te\"1\u0018B`\u0011\u001d\u0011iL\u0002a\u0001\u0003+\t\u0001b\u001c7e'R\fG/\u001a\u0005\b\u0005S1\u0001\u0019AA\u000b\u0003M1\u0018\r\\5e!J,g/[8vgN#\u0018\r^3t+\t\u0011)\rE\u0004_\u0005\u000f\f)Ba3\n\u0007\t%wMA\u0002NCB\u0004RA\u0018Bg\u0003+I1!!\u000eh\u0003Q1\u0018\r\\5e!J,g/[8vgN#\u0018\r^3tA\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"A!6+\u0007-\u00149n\u000b\u0002\u0003ZB!!1\u001cBs\u001b\t\u0011iN\u0003\u0003\u0003`\n\u0005\u0018!C;oG\",7m[3e\u0015\r\u0011\u0019OS\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bt\u0005;\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private short producerEpoch;
    private int txnTimeoutMs;
    private TransactionState state;
    private final scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private Option<TransactionState> pendingState;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$7() {
        return TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean isValidTransition(TransactionState transactionState, TransactionState transactionState2) {
        return TransactionMetadata$.MODULE$.isValidTransition(transactionState, transactionState2);
    }

    public static TransactionState byteToState(byte by) {
        return TransactionMetadata$.MODULE$.byteToState(by);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, TransactionState transactionState, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, transactionState, l2);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, l2);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    /*
     * WARNING - void declaration
     */
    public <T> T inLock(Function0<T> fun) {
        Object object;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        if (transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$)) {
            TransactionState transactionState2 = this.state();
            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
            if (transactionState2 == null ? prepareAbort$ != null : !transactionState2.equals(prepareAbort$)) {
                throw new IllegalStateException(new StringBuilder(154).append("Transaction metadata's current state is ").append(this.state()).append(", and its pending state is ").append(this.pendingState()).append(" ").append("while trying to remove partitions whose txn marker has been sent, this is not expected").toString());
            }
        }
        this.topicPartitions().$minus$eq((Object)topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MaxValue since this would overflow");
        }
        return this.prepareTransitionTo(PrepareEpochFence$.MODULE$, this.producerId(), (short)(this.producerEpoch() + 1), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareIncrementProducerEpoch(int newTxnTimeoutMs, long updateTimestamp) {
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException(new StringBuilder(56).append("Cannot allocate any more producer epochs for producerId ").append(this.producerId()).toString());
        }
        int nextEpoch = this.producerEpoch() == -1 ? 0 : this.producerEpoch() + 1;
        return this.prepareTransitionTo(Empty$.MODULE$, this.producerId(), (short)nextEpoch, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(Empty$.MODULE$, newProducerId, (short)0, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp) {
        TransactionState transactionState = this.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState));
        long l = bl ? updateTimestamp : this.txnStartTimestamp();
        return this.prepareTransitionTo(Ongoing$.MODULE$, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().$plus$plus(addedTopicPartitions).toSet(), l, updateTimestamp);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, long updateTimestamp) {
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        Product newState = !(transactionState != null ? !transactionState.equals(prepareCommit$) : prepareCommit$ != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        return this.prepareTransitionTo((TransactionState)newState, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(Dead$.MODULE$, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public boolean isProducerEpochExhausted() {
        return this.producerEpoch() >= 32766;
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        boolean bl = Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        return bl2;
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState newState, long newProducerId, short newEpoch, int newTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> newTopicPartitions, long newTxnStartTimestamp, long updateTimestamp) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException(new StringBuilder(76).append("Preparing transaction state transition to ").append(newState).append(" ").append("while it already a pending state ").append(this.pendingState().get()).toString());
        }
        if (newProducerId < 0L) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Illegal new producer id ").append(newProducerId).toString());
        }
        if (newEpoch < 0) {
            throw new IllegalArgumentException(new StringBuilder(27).append("Illegal new producer epoch ").append(newEpoch).toString());
        }
        if (((SetLike)TransactionMetadata$.MODULE$.kafka$coordinator$transaction$TransactionMetadata$$validPreviousStates().apply((Object)newState)).contains((Object)this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(newProducerId, newEpoch, newTxnTimeoutMs, newState, newTopicPartitions, newTxnStartTimestamp, updateTimestamp);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("TransactionalId ").append(this.transactionalId()).append(" prepare transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
            this.pendingState_$eq((Option<TransactionState>)new Some((Object)newState));
            return transitMetadata;
        }
        throw new IllegalStateException(new StringBuilder(125).append("Preparing transaction state transition to ").append(newState).append(" failed since the target state").append(" ").append(newState).append(" is not a valid previous state of the current state ").append(this.state()).toString());
    }

    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        TransactionState toState;
        Option<TransactionState> option = this.pendingState();
        if (option == null) {
            throw null;
        }
        Option<TransactionState> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw TransactionMetadata.$anonfun$completeTransitionTo$1(this, transitMetadata);
        }
        TransactionState transactionState = toState = (TransactionState)getOrElse_this.get();
        TransactionState transactionState2 = transitMetadata.txnState();
        if (transactionState == null ? transactionState2 != null : !transactionState.equals(transactionState2)) {
            this.throwStateTransitionFailure(transitMetadata);
            return;
        }
        if (Empty$.MODULE$.equals(toState)) {
            if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
                this.producerEpoch_$eq(transitMetadata.producerEpoch());
                this.producerId_$eq(transitMetadata.producerId());
            }
        } else if (Ongoing$.MODULE$.equals(toState)) {
            if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() > transitMetadata.txnStartTimestamp()) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                this.addPartitions((Set<TopicPartition>)transitMetadata.topicPartitions());
            }
        } else {
            boolean bl = PrepareAbort$.MODULE$.equals(toState) ? true : PrepareCommit$.MODULE$.equals(toState);
            if (bl) {
                if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().toSet().equals(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() != transitMetadata.txnStartTimestamp()) {
                    this.throwStateTransitionFailure(transitMetadata);
                }
            } else {
                boolean bl2 = CompleteAbort$.MODULE$.equals(toState) ? true : CompleteCommit$.MODULE$.equals(toState);
                if (bl2) {
                    if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                        this.throwStateTransitionFailure(transitMetadata);
                    } else {
                        this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                        this.topicPartitions().clear();
                    }
                } else if (PrepareEpochFence$.MODULE$.equals(toState)) {
                    this.throwStateTransitionFailure(transitMetadata);
                } else {
                    if (Dead$.MODULE$.equals(toState)) {
                        throw new IllegalStateException(new StringBuilder(250).append("TransactionalId ").append(this.transactionalId()).append(" is trying to complete a transition to ").append(toState).append(". This means that the transactionalId was being expired, and the only acceptable completion of ").append("this operation is to remove the transaction metadata from the cache, not to persist the ").append(toState).append(" in the log.").toString());
                    }
                    throw new MatchError((Object)toState);
                }
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("TransactionalId ").append(this.transactionalId()).append(" complete transition from ").append(this.state()).append(" to ").append(transitMetadata).toString());
        this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
        this.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
        this.state_$eq(toState);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append(this.toString()).append("'s transition to ").append(txnTransitMetadata).append(" failed: this should not happen").toString());
        throw new IllegalStateException(new StringBuilder(71).append("TransactionalId ").append(this.transactionalId()).append(" failed transition to state ").append(txnTransitMetadata).append(" ").append("due to unexpected metadata").toString());
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    public String toString() {
        return new StringBuilder(167).append("TransactionMetadata(").append("transactionalId=").append(this.transactionalId()).append(", ").append("producerId=").append(this.producerId()).append(", ").append("producerEpoch=").append(this.producerEpoch()).append(", ").append("txnTimeoutMs=").append(this.txnTimeoutMs()).append(", ").append("state=").append(this.state()).append(", ").append("pendingState=").append(this.pendingState()).append(", ").append("topicPartitions=").append(this.topicPartitions()).append(", ").append("txnStartTimestamp=").append(this.txnStartTimestamp()).append(", ").append("txnLastUpdateTimestamp=").append(this.txnLastUpdateTimestamp()).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!(that instanceof TransactionMetadata)) return false;
        TransactionMetadata transactionMetadata = (TransactionMetadata)that;
        String string = this.transactionalId();
        String string2 = transactionMetadata.transactionalId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.producerId() != transactionMetadata.producerId()) return false;
        if (this.producerEpoch() != transactionMetadata.producerEpoch()) return false;
        if (this.txnTimeoutMs() != transactionMetadata.txnTimeoutMs()) return false;
        if (!this.state().equals(transactionMetadata.state())) return false;
        if (!this.topicPartitions().equals(transactionMetadata.topicPartitions())) return false;
        if (this.txnStartTimestamp() != transactionMetadata.txnStartTimestamp()) return false;
        if (this.txnLastUpdateTimestamp() != transactionMetadata.txnLastUpdateTimestamp()) return false;
        return true;
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToShort((short)this.producerEpoch()), BoxesRunTime.boxToInteger((int)this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong((long)this.txnStartTimestamp()), BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp())}))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ Nothing$ $anonfun$completeTransitionTo$1(TransactionMetadata $this, TxnTransitMetadata transitMetadata$2) {
        $this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append($this).append("'s transition to ").append(transitMetadata$2).append(" failed since pendingState is not defined: this should not happen").toString());
        throw new IllegalStateException(new StringBuilder(95).append("TransactionalId ").append($this.transactionalId()).append(" ").append("completing transaction state transition while it does not have a pending state").toString());
    }

    public TransactionMetadata(String transactionalId, long producerId, short producerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        Logging.$init$(this);
        this.pendingState = None$.MODULE$;
        this.lock = new ReentrantLock();
    }
}

