/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import kafka.admin.AdminOperationException;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.utils.Exit$;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001}3A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!1a\u0004\u0001Q\u0001\n}Aaa\n\u0001!\u0002\u0013y\u0002\"\u0002\u0015\u0001\t\u0003I\u0003\"\u0002\u001e\u0001\t\u0003I\u0003\"\u0002\u001f\u0001\t\u0003I\u0003\"\u0002 \u0001\t\u0003I\u0003\"\u0002!\u0001\t\u0003I\u0003\"\u0002\"\u0001\t\u0003I\u0003\"\u0002#\u0001\t\u0003I\u0003\"\u0002$\u0001\t\u0003I\u0003B\u0002%\u0001A\u0013%\u0011J\u0001\tU_BL7mQ8n[\u0006tG\rV3ti*\u0011q\u0002E\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002#\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011AD\u0001\u000bEJ|7.\u001a:MSN$\bC\u0001\u0011&\u001b\u0005\t#B\u0001\u0012$\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\nAA[1wC&\u0011a%\t\u0002\u0007'R\u0014\u0018N\\4\u0002\u0013Q|\u0007/[2OC6,\u0017A\t;fgRL5OT8u+:$WM\u001d*fa2L7-\u0019;fI^CWM\\!eI&tw\rF\u0001+!\t)2&\u0003\u0002--\t!QK\\5uQ\t!a\u0006\u0005\u00020q5\t\u0001G\u0003\u00022e\u0005\u0019\u0011\r]5\u000b\u0005M\"\u0014a\u00026va&$XM\u001d\u0006\u0003kY\nQA[;oSRT\u0011aN\u0001\u0004_J<\u0017BA\u001d1\u0005\u0011!Vm\u001d;\u0002MQ,7\u000f^!mi\u0016\u0014x+\u001b;i+:\u001c\b/Z2jM&,G\rU1si&$\u0018n\u001c8D_VtG\u000f\u000b\u0002\u0006]\u0005\tC/Z:u\u0007>tg-[4PaR<\u0016\u000e\u001e5C_>$8\u000f\u001e:baN+'O^3sg\"\u0012aAL\u0001*i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001c3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;)\u0005\u001dq\u0013\u0001\f;fgR\u001c%/Z1uK^KG\u000f[!tg&<g.\\3oi\u0006sGMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8sQ\tAa&A\u0012uKN$\b+\u0019:tK\u0006\u001b8/[4o[\u0016tG\u000fR;qY&\u001c\u0017\r^3F]R\u0014\u0018.Z:)\u0005%q\u0013\u0001\f;fgR\u0004\u0016M]:f\u0003N\u001c\u0018n\u001a8nK:$\b+\u0019:uSRLwN\\:PM\u0012KgMZ3sK:$8+\u001b>fQ\tQa&A\nuKN$\b+\u0019:tK\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0002\f]\u00059\u0012m]:feR\u001c\u0005.Z2l\u0003J<7/\u0012=ji\u000e{G-\u001a\u000b\u0004U){\u0005\"B&\r\u0001\u0004a\u0015\u0001C3ya\u0016\u001cG/\u001a3\u0011\u0005Ui\u0015B\u0001(\u0017\u0005\rIe\u000e\u001e\u0005\u0006!2\u0001\r!U\u0001\b_B$\u0018n\u001c8t!\t\u0011FL\u0004\u0002T5:\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/J\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005=\u0001\u0012BA.\u000f\u00031!v\u000e]5d\u0007>lW.\u00198e\u0013\tifLA\nU_BL7mQ8n[\u0006tGm\u00149uS>t7O\u0003\u0002\\\u001d\u0001")
public class TopicCommandTest {
    private final String brokerList;
    private final String topicName;

    @Test
    public void testIsNotUnderReplicatedWhenAdding() {
        List replicaIds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        List replicas = (List)replicaIds.map((Function1 & Serializable & scala.Serializable)id -> TopicCommandTest.$anonfun$testIsNotUnderReplicatedWhenAdding$1(BoxesRunTime.unboxToInt((Object)id)), List$.MODULE$.canBuildFrom());
        Assertions.assertFalse((boolean)new TopicCommand.PartitionDescription("test-topic", new TopicPartitionInfo(0, new Node(1, "localhost", 9091), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new Node(1, "localhost", 9091), (List)Nil$.MODULE$)).asJava()), (Option)None$.MODULE$, false, (Option)new Some((Object)new PartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaIds.map((Function1 & Serializable & scala.Serializable)id -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), List$.MODULE$.canBuildFrom())).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava()))).isUnderReplicated());
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--alter", "--topic", this.topicName})));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--alter", "--topic", this.topicName, "--partitions", "3", "--config", "cleanup.policy=compact"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--alter", "--topic", this.topicName, "--partitions", "3", "--delete-config", "cleanup.policy"})));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--topic", this.topicName, "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"}));
        opts.checkArgs();
        Assertions.assertTrue((boolean)opts.hasCreateOption());
        Assertions.assertEquals((Object)this.brokerList, (Object)opts.bootstrapServer().get());
        Assertions.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        Assertions.assertThrows(AdminCommandFailedException.class, () -> TopicCommand$.MODULE$.parseReplicaAssignment("5:5"));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        Assertions.assertThrows(AdminOperationException.class, () -> TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1"));
    }

    @Test
    public void testParseAssignment() {
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        Assertions.assertEquals((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}))), (Object)actualAssignment);
    }

    /*
     * WARNING - void declaration
     */
    private void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(exitCode, x$1) -> TopicCommandTest.$anonfun$assertCheckArgsExitCode$1(expected, BoxesRunTime.unboxToInt((Object)exitCode), x$1);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Assertions.assertThrows(RuntimeException.class, () -> options.checkArgs());
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    public static final /* synthetic */ Node $anonfun$testIsNotUnderReplicatedWhenAdding$1(int id) {
        return new Node(id, "localhost", 9090 + id);
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertCheckArgsExitCode$1(int expected$1, int exitCode, Option x$1) {
        Assertions.assertEquals((int)expected$1, (int)exitCode);
        throw new RuntimeException();
    }

    public TopicCommandTest() {
        this.brokerList = "localhost:9092";
        this.topicName = "topicName";
    }
}

