/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.controller.AlterIsrReceived;
import kafka.controller.ApiPartitionReassignment;
import kafka.controller.ControlledShutdown;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerState;
import kafka.controller.ElectionTrigger;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ListPartitionReassignments;
import kafka.controller.MockEvent;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaLeaderElection;
import kafka.controller.ZkTriggered$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import kafka.utils.TestUtils$Checkpoint$;
import kafka.zk.AdminZkClient;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.PreferredReplicaElectionZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ControllerMovedException;
import org.apache.kafka.common.errors.StaleBrokerEpochException;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeqLike;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.VolatileBooleanRef;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r\u001da\u0001B%K\u0001=CQA\u0016\u0001\u0005\u0002]CqA\u0017\u0001A\u0002\u0013\u00051\fC\u0004k\u0001\u0001\u0007I\u0011A6\t\rI\u0004\u0001\u0015)\u0003]\u0011\u001d\u0019\bA1A\u0005\u0002QDa\u0001\u001f\u0001!\u0002\u0013)\bbB=\u0001\u0005\u0004%\t\u0001\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B;\t\u000bm\u0004A\u0011\t?\t\r\u0005U\u0001\u0001\"\u0011}\u0011\u0019\ty\u0002\u0001C\u0001y\"1\u0011\u0011\u0006\u0001\u0005\u0002qDa!!\f\u0001\t\u0003a\bBBA\u0019\u0001\u0011\u0005A\u0010\u0003\u0004\u00026\u0001!\t\u0001 \u0005\u0007\u0003s\u0001A\u0011\u0001?\t\r\u0005u\u0002\u0001\"\u0001}\u0011\u0019\t\t\u0005\u0001C\u0001y\"1\u0011Q\t\u0001\u0005\u0002qDa!!\u0013\u0001\t\u0003a\bBBA'\u0001\u0011\u0005A\u0010\u0003\u0004\u0002R\u0001!\t\u0001 \u0005\u0007\u0003+\u0002A\u0011\u0001?\t\r\u0005e\u0003\u0001\"\u0001}\u0011\u0019\ti\u0006\u0001C\u0001y\"1\u0011\u0011\r\u0001\u0005\u0002qDa!!\u001a\u0001\t\u0003a\bBBA5\u0001\u0011\u0005A\u0010\u0003\u0004\u0002n\u0001!\t\u0001 \u0005\u0007\u0003c\u0002A\u0011\u0001?\t\r\u0005U\u0004\u0001\"\u0001}\u0011\u0019\tI\b\u0001C\u0001y\"1\u0011Q\u0010\u0001\u0005\u0002qDa!!!\u0001\t\u0003a\bBBAC\u0001\u0011\u0005A\u0010\u0003\u0004\u0002\n\u0002!\t\u0001 \u0005\u0007\u0003\u001b\u0003A\u0011\u0001?\t\r\u0005E\u0005\u0001\"\u0001}\u0011\u0019\t)\n\u0001C\u0001y\"1\u0011\u0011\u0014\u0001\u0005\u0002qDa!!(\u0001\t\u0003a\bBBAQ\u0001\u0011\u0005A\u0010\u0003\u0004\u0002&\u0002!\t\u0001 \u0005\u0007\u0003S\u0003A\u0011\u0001?\t\r\u00055\u0006\u0001\"\u0001}\u0011\u001d\t\t\f\u0001C\u0005\u0003gCa!a5\u0001\t\u0003a\bBBAl\u0001\u0011\u0005A\u0010\u0003\u0004\u0002\\\u0002!\t\u0001 \u0005\u0007\u0003?\u0004A\u0011\u0001?\t\r\u0005\r\b\u0001\"\u0001}\u0011\u0019\t9\u000f\u0001C\u0001y\"1\u00111\u001e\u0001\u0005\u0002qDa!a<\u0001\t\u0003a\bBBAz\u0001\u0011\u0005A\u0010\u0003\u0004\u0002x\u0002!\t\u0001 \u0005\b\u0003w\u0004A\u0011BA\u007f\u0011\u001d\u0011I\u0001\u0001C\u0005\u0005\u0017AqA!\u0013\u0001\t\u0013\u0011Y\u0005C\u0004\u0003\\\u0001!IA!\u0018\t\u000f\t5\u0004\u0001\"\u0003\u0003p!9!q\u0011\u0001\u0005\n\t%\u0005\"\u0003BY\u0001E\u0005I\u0011\u0002BZ\u0011%\u0011I\rAI\u0001\n\u0013\u0011\u0019\fC\u0005\u0003L\u0002\t\n\u0011\"\u0003\u00034\"I!Q\u001a\u0001\u0012\u0002\u0013%!q\u001a\u0005\n\u0005'\u0004\u0011\u0013!C\u0005\u0005\u001fD\u0011B!6\u0001#\u0003%IAa4\t\u0013\t]\u0007!%A\u0005\n\te\u0007\"\u0003Bo\u0001E\u0005I\u0011\u0002Bp\u0011\u001d\u0011\u0019\u000f\u0001C\u0005\u0005KDqaa\u0001\u0001\t\u0013\u0019)AA\rD_:$(o\u001c7mKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$(BA&M\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u001b\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001Q!\t\tF+D\u0001S\u0015\t\u0019F*\u0001\u0002{W&\u0011QK\u0015\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005A\u0006CA-\u0001\u001b\u0005Q\u0015aB:feZ,'o]\u000b\u00029B\u0019QL\u00193\u000e\u0003yS!a\u00181\u0002\u0015\r|G\u000e\\3di&|gNC\u0001b\u0003\u0015\u00198-\u00197b\u0013\t\u0019gLA\u0002TKF\u0004\"!\u001a5\u000e\u0003\u0019T!a\u001a'\u0002\rM,'O^3s\u0013\tIgMA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018aC:feZ,'o]0%KF$\"\u0001\u001c9\u0011\u00055tW\"\u00011\n\u0005=\u0004'\u0001B+oSRDq!]\u0002\u0002\u0002\u0003\u0007A,A\u0002yIE\n\u0001b]3sm\u0016\u00148\u000fI\u0001\u0015M&\u00148\u000f^\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0016\u0003U\u0004\"!\u001c<\n\u0005]\u0004'aA%oi\u0006)b-\u001b:ti\u000e{g\u000e\u001e:pY2,'/\u00129pG\"\u0004\u0013!\b4jeN$8i\u001c8ue>dG.\u001a:Fa>\u001c\u0007NW6WKJ\u001c\u0018n\u001c8\u0002=\u0019L'o\u001d;D_:$(o\u001c7mKJ,\u0005o\\2i5.4VM]:j_:\u0004\u0013!B:fiV\u0003H#\u00017)\u0005%q\bcA@\u0002\u00125\u0011\u0011\u0011\u0001\u0006\u0005\u0003\u0007\t)!A\u0002ba&TA!a\u0002\u0002\n\u00059!.\u001e9ji\u0016\u0014(\u0002BA\u0006\u0003\u001b\tQA[;oSRT!!a\u0004\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0014\u0005\u0005!A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\u000b\u00033\u00012a`A\u000e\u0013\u0011\ti\"!\u0001\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\u0005;fgR,U\u000e\u001d;z\u00072,8\u000f^3sQ\rY\u00111\u0005\t\u0004\u007f\u0006\u0015\u0012\u0002BA\u0014\u0003\u0003\u0011A\u0001V3ti\u0006iC/Z:u\u0007>tGO]8mY\u0016\u0014X\t]8dQB+'o]5tiN<\u0006.\u001a8BY2\u0014%o\\6feN$un\u001e8)\u00071\t\u0019#A\u0016uKN$8i\u001c8ue>dG.\u001a:N_Z,\u0017J\\2sK6,g\u000e^:D_:$(o\u001c7mKJ,\u0005o\\2iQ\ri\u00111E\u0001&i\u0016\u001cH/T3uC\u0012\fG/\u0019)s_B\fw-\u0019;j_:|enQ8oiJ|G\u000e\u00157b]\u0016D3ADA\u0012\u0003\u0015\"Xm\u001d;NKR\fG-\u0019;b!J|\u0007/Y4bi&|gn\u00148Ce>\\WM]\"iC:<W\rK\u0002\u0010\u0003G\t\u0011\u0006^3ti6+G/\u00193bi\u0006\u0004&o\u001c9bO\u0006$\u0018n\u001c8G_J|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006\u001c\bf\u0001\t\u0002$\u0005\tB/Z:u)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8)\u0007E\t\u0019#A\u0012uKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:<\u0016\u000e\u001e5PM\u001ad\u0017N\\3SKBd\u0017nY1)\u0007I\t\u0019#A\u000euKN$Hk\u001c9jGB\u000b'\u000f^5uS>tW\t\u001f9b]NLwN\u001c\u0015\u0004'\u0005\r\u0012!\f;fgR$v\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0005\u0010]1og&|gnV5uQ>3g\r\\5oKJ+\u0007\u000f\\5dC\"\u001aA#a\t\u00023Q,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0004+\u0005\r\u0012A\r;fgR\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R$vN\u0011:pW\u0016\u0014x+\u001b;i\u001f\u001a4G.\u001b8f\u0019><G)\u001b:)\u0007Y\t\u0019#\u0001\u001euKN$\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$x+\u001b;i\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2b\u0011\u0006dG/\u001b8h!J|wM]3tg\"\u001aq#a\t\u0002oQ,7\u000f\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e*fgVlWm]!gi\u0016\u0014(+\u001a9mS\u000e\f7i\\7fg>sG.\u001b8fQ\rA\u00121E\u0001#i\u0016\u001cH\u000f\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1MK\u0006$WM]#mK\u000e$\u0018n\u001c8)\u0007e\t\u0019#A\u0017uKN$()Y2l)>\u0014\u0015mY6Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC2+\u0017\rZ3s\u000b2,7\r^5p]ND3AGA\u0012\u0003u\"Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC2+\u0017\rZ3s\u000b2,7\r^5p]^KG\u000f[(gM2Lg.\u001a)sK\u001a,'O]3e%\u0016\u0004H.[2bQ\rY\u00121E\u0001'i\u0016\u001cH/Q;u_B\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t\u0007f\u0001\u000f\u0002$\u0005!E/Z:u\u0019\u0016\fG-\u001a:B]\u0012L5O],iK:,e\u000e^5sK&\u001b(o\u00144gY&tW-\u00118e+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o\t&\u001c\u0018M\u00197fI\"\u001aQ$a\t\u0002\u0007R,7\u000f\u001e'fC\u0012,'/\u00118e\u0013N\u0014x\u000b[3o\u000b:$\u0018N]3JgJ|eM\u001a7j]\u0016\fe\u000eZ+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\\#oC\ndW\r\u001a\u0015\u0004=\u0005\r\u0012A\u0006;fgR\u001cuN\u001c;s_2dW\rZ*ikR$wn\u001e8)\u0007}\t\u0019#A!uKN$8i\u001c8ue>dG.\u001a:SK*,7\r^\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:\u0014V-];fgR<\u0016\u000e\u001e5Ti\u0006dWM\u0011:pW\u0016\u0014X\t]8dQ\"\u001a\u0001%a\t\u0002CQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe6{g/Z(o)>\u0004\u0018nY\"sK\u0006$\u0018n\u001c8)\u0007\u0005\n\u0019#A\u0011uKN$8i\u001c8ue>dG.\u001a:N_Z,wJ\u001c+pa&\u001cG)\u001a7fi&|g\u000eK\u0002#\u0003G\tA\u0006^3ti\u000e{g\u000e\u001e:pY2,'/T8wK>s\u0007K]3gKJ\u0014X\r\u001a*fa2L7-Y#mK\u000e$\u0018n\u001c8)\u0007\r\n\u0019#A\u0015uKN$8i\u001c8ue>dG.\u001a:N_Z,wJ\u001c)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0004I\u0005\r\u0012\u0001\u0017;fgR\u001cuN\u001c;s_2dWM\u001d$fCR,(/\u001a.O_\u0012,7+\u001a;va^CWM\u001c$fCR,(/\u001a,feNLwN\\5oO&\u001bXI\\1cY\u0016$w+\u001b;i\u001d>tW\t_5ti&twMR3biV\u0014XM\u0017(pI\u0016D3!JA\u0012\u0003u#Xm\u001d;D_:$(o\u001c7mKJ4U-\u0019;ve\u0016Tfj\u001c3f'\u0016$X\u000f],iK:4U-\u0019;ve\u00164VM]:j_:LgnZ%t\u000b:\f'\r\\3e/&$\b\u000eR5tC\ndW\rZ#ySN$\u0018N\\4GK\u0006$XO]3[\u001d>$W\rK\u0002'\u0003G\tA\f^3ti\u000e{g\u000e\u001e:pY2,'OR3biV\u0014XM\u0017(pI\u0016\u001cV\r^;q/\",gNR3biV\u0014XMV3sg&|g.\u001b8h\u0013N,e.\u00192mK\u0012<\u0016\u000e\u001e5F]\u0006\u0014G.\u001a3Fq&\u001cH/\u001b8h\r\u0016\fG/\u001e:f5:{G-\u001a\u0015\u0004O\u0005\r\u0012!\u0017;fgR\u001cuN\u001c;s_2dWM\u001d$fCR,(/\u001a.O_\u0012,7+\u001a;va^CWM\u001c$fCR,(/\u001a,feNLwN\\5oO&\u001bH)[:bE2,GmV5uQ:{g.\u0012=jgRLgn\u001a$fCR,(/\u001a.O_\u0012,\u0007f\u0001\u0015\u0002$\u0005qF/Z:u\u0007>tGO]8mY\u0016\u0014h)Z1ukJ,'LT8eKN+G/\u001e9XQ\u0016tg)Z1ukJ,g+\u001a:tS>t\u0017N\\4Jg\u0012K7/\u00192mK\u0012<\u0016\u000e\u001e5ESN\f'\r\\3e\u000bbL7\u000f^5oO\u001a+\u0017\r^;sKjsu\u000eZ3)\u0007%\n\u0019#A/uKN$8i\u001c8ue>dG.\u001a:GK\u0006$XO]3[\u001d>$WmU3ukB<\u0006.\u001a8GK\u0006$XO]3WKJ\u001c\u0018n\u001c8j]\u001eL5\u000fR5tC\ndW\rZ,ji\",e.\u00192mK\u0012,\u00050[:uS:<g)Z1ukJ,'LT8eK\"\u001a!&a\t\u0002GQ,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u0012+G/Z2ug\n{WO\\2fI\n\u0013xn[3sg\"\u001a1&a\t\u0002EQ,7\u000f\u001e)sK\u0016l\u0007\u000f^5p]>s7i\u001c8ue>dG.\u001a:TQV$Hm\\<oQ\ra\u00131E\u0001\u001ci\u0016\u001cH\u000f\u0015:fK6\u0004H/[8o/&$\bnQ1mY\n\f7m[:)\u00075\n\u0019#A\u0010uKN$8i\u001c8ue>dG.\u001a:GK\u0006$XO]3[\u001d>$WmU3ukB$R\u0001\\A[\u0003\u000bDq!a./\u0001\u0004\tI,\u0001\u0007j]&$\u0018.\u00197[\u001d>$W\rE\u0003n\u0003w\u000by,C\u0002\u0002>\u0002\u0014aa\u00149uS>t\u0007cA)\u0002B&\u0019\u00111\u0019*\u0003\u0019\u0019+\u0017\r^;sKjsu\u000eZ3\t\u000f\u0005\u001dg\u00061\u0001\u0002J\u0006Q\u0012N\u001c;fe\n\u0013xn[3s!J|Go\\2pYZ+'o]5p]B!\u00111ZAh\u001b\t\tiMC\u0002\u0002\u00041KA!!5\u0002N\nQ\u0011\t]5WKJ\u001c\u0018n\u001c8\u0002-Q,7\u000f^%eK6\u0004x\u000e^3oi\u0006cG/\u001a:JgJD3aLA\u0012\u0003Q!Xm\u001d;U_BL7-\u00133t\u0003J,\u0017\t\u001a3fI\"\u001a\u0001'a\t\u0002/Q,7\u000f\u001e+pa&\u001c\u0017\nZ:Be\u0016tu\u000e^!eI\u0016$\u0007fA\u0019\u0002$\u0005yB/Z:u)>\u0004\u0018nY%e\u001b&<'/\u0019;j_:\fe\u000e\u001a%b]\u0012d\u0017N\\4)\u0007I\n\u0019#A\u0018uKN$Hk\u001c9jG&#W*[4sCRLwN\\!oI\"\u000bg\u000e\u001a7j]\u001e<\u0016\u000e\u001e5PY\u0012,'OV3sg&|g\u000eK\u00024\u0003G\ta\u0006^3tiR{\u0007/[2JIB+'o]5tiN$\u0006N]8vO\"\u001cuN\u001c;s_2dWM\u001d*fK2,7\r^5p]\"\u001aA'a\t\u0002aQ,7\u000f\u001e(p)>\u0004\u0018nY%e!\u0016\u00148/[:ugRC'o\\;hQ\u000e{g\u000e\u001e:pY2,'OU3fY\u0016\u001cG/[8oQ\r)\u00141E\u0001,i\u0016\u001cH\u000fV8qS\u000eLE\rU3sg&\u001cHo\u001d+ie>,x\r[\"p]R\u0014x\u000e\u001c7feJ+7\u000f^1si\"\u001aa'a\t\u00027Q,7\u000f\u001e+pa&\u001c\u0017\nZ\"sK\u0006$X\rZ(o+B<'/\u00193fQ\r9\u00141E\u0001-i\u0016\u001cH\u000fV8qS\u000eLE-\u00169he\u0006$W-\u00114uKJ\u0014V-Y:tS\u001et\u0017N\\4QCJ$\u0018\u000e^5p]ND3\u0001OA\u0012\u0003I!Xm\u001d;D_:$(o\u001c7mKJluN^3\u0015\u00071\fy\u0010C\u0004\u0003\u0002e\u0002\rAa\u0001\u0002\u0007\u0019,h\u000e\u0005\u0003n\u0005\u000ba\u0017b\u0001B\u0004A\nIa)\u001e8di&|g\u000eM\u0001\u001faJ,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006dU-\u00193fe\u0016cWm\u0019;j_:$2\u0002\u001cB\u0007\u0005#\u0011)Ba\u000b\u0003F!1!q\u0002\u001eA\u0002U\fAbY8oiJ|G\u000e\\3s\u0013\u0012DaAa\u0005;\u0001\u0004!\u0017aC8uQ\u0016\u0014(I]8lKJDqAa\u0006;\u0001\u0004\u0011I\"\u0001\u0002uaB!!1\u0004B\u0014\u001b\t\u0011iB\u0003\u0003\u0003 \t\u0005\u0012AB2p[6|gNC\u0002N\u0005GQAA!\n\u0002\u000e\u00051\u0011\r]1dQ\u0016LAA!\u000b\u0003\u001e\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002B\u0017u\u0001\u0007!qF\u0001\te\u0016\u0004H.[2bgB)!\u0011\u0007B k:!!1\u0007B\u001e!\r\u0011)\u0004Y\u0007\u0003\u0005oQ1A!\u000fO\u0003\u0019a$o\\8u}%\u0019!Q\b1\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011\tEa\u0011\u0003\u0007M+GOC\u0002\u0003>\u0001DaAa\u0012;\u0001\u0004)\u0018a\u00037fC\u0012,'/\u00129pG\"\f\u0001d^1jiVsG/\u001b7D_:$(o\u001c7mKJ,\u0005o\\2i)\u0015a'Q\nB)\u0011\u0019\u0011ye\u000fa\u0001k\u0006)Q\r]8dQ\"9!1K\u001eA\u0002\tU\u0013aB7fgN\fw-\u001a\t\u0005\u0005c\u00119&\u0003\u0003\u0003Z\t\r#AB*ue&tw-A\u000bxC&$hi\u001c:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\u00171\u0014yF!\u0019\u0003f\t%$1\u000e\u0005\b\u0005/a\u0004\u0019\u0001B\r\u0011\u0019\u0011\u0019\u0007\u0010a\u0001k\u0006y1m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\u0003\u0004\u0003hq\u0002\r!^\u0001\u0007Y\u0016\fG-\u001a:\t\r\t\u001dC\b1\u0001v\u0011\u001d\u0011\u0019\u0006\u0010a\u0001\u0005+\n\u0001$[:FqB,7\r^3e!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f))\u0011\tHa\u001e\u0003\u0002\n\r%Q\u0011\t\u0004[\nM\u0014b\u0001B;A\n9!i\\8mK\u0006t\u0007b\u0002B={\u0001\u0007!1P\u0001\u001cY\u0016\fG-\u001a:JgJ\fe\u000eZ\"p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0011\u0007e\u0013i(C\u0002\u0003\u0000)\u00131\u0004T3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007B\u0002B2{\u0001\u0007Q\u000f\u0003\u0004\u0003hu\u0002\r!\u001e\u0005\u0007\u0005\u000fj\u0004\u0019A;\u0002\u00175\f7.Z*feZ,'o\u001d\u000b\u00149\n-%q\u0012BJ\u0005/\u0013YJ!)\u0003&\n%&Q\u0016\u0005\u0007\u0005\u001bs\u0004\u0019A;\u0002\u00159,XnQ8oM&<7\u000fC\u0005\u0003\u0012z\u0002\n\u00111\u0001\u0003r\u0005I\u0012-\u001e;p\u0019\u0016\fG-\u001a:SK\n\fG.\u00198dK\u0016s\u0017M\u00197f\u0011%\u0011)J\u0010I\u0001\u0002\u0004\u0011\t(A\u000ev]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8F]\u0006\u0014G.\u001a\u0005\n\u00053s\u0004\u0013!a\u0001\u0005c\n\u0001$\u001a8bE2,7i\u001c8ue>dG.\u001a3TQV$Hm\\<o\u0011%\u0011iJ\u0010I\u0001\u0002\u0004\u0011y*A\u0005mSN$XM\\3sgB)Q.a/\u0003V!I!1\u0015 \u0011\u0002\u0003\u0007!qT\u0001\u001cY&\u001cH/\u001a8feN+7-\u001e:jif\u0004&o\u001c;pG>dW*\u00199\t\u0013\t\u001df\b%AA\u0002\t}\u0015\u0001G2p]R\u0014x\u000e\u001c)mC:,G*[:uK:,'OT1nK\"I\u0011q\u0019 \u0011\u0002\u0003\u0007!1\u0016\t\u0006[\u0006m\u0016\u0011\u001a\u0005\t\u0005_s\u0004\u0013!a\u0001k\u0006YAn\\4ESJ\u001cu.\u001e8u\u0003Ui\u0017m[3TKJ4XM]:%I\u00164\u0017-\u001e7uII*\"A!.+\t\tE$qW\u0016\u0003\u0005s\u0003BAa/\u0003F6\u0011!Q\u0018\u0006\u0005\u0005\u007f\u0013\t-A\u0005v]\u000eDWmY6fI*\u0019!1\u00191\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003H\nu&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)R.Y6f'\u0016\u0014h/\u001a:tI\u0011,g-Y;mi\u0012\u001a\u0014!F7bW\u0016\u001cVM\u001d<feN$C-\u001a4bk2$H\u0005N\u0001\u0016[\u0006\\WmU3sm\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011\tN\u000b\u0003\u0003 \n]\u0016!F7bW\u0016\u001cVM\u001d<feN$C-\u001a4bk2$HEN\u0001\u0016[\u0006\\WmU3sm\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003Ui\u0017m[3TKJ4XM]:%I\u00164\u0017-\u001e7uIa*\"Aa7+\t\t-&qW\u0001\u0016[\u0006\\WmU3sm\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0011\tOK\u0002v\u0005o\u000bQ\u0001^5nKJ$BAa:\u0003\u0000B!!\u0011\u001eB~\u001b\t\u0011YO\u0003\u0003\u0003n\n=\u0018\u0001B2pe\u0016TAA!=\u0003t\u00069Q.\u001a;sS\u000e\u001c(\u0002\u0002B{\u0005o\fa!_1n[\u0016\u0014(B\u0001B}\u0003\r\u0019w.\\\u0005\u0005\u0005{\u0014YOA\u0003US6,'\u000fC\u0004\u0004\u0002\u001d\u0003\rA!\u0016\u0002\u00155,GO]5d\u001d\u0006lW-A\u0007hKR\u001cuN\u001c;s_2dWM\u001d\u000b\u0002I\u0002")
public class ControllerIntegrationTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final int firstControllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() + 1;
    private final int firstControllerEpochZkVersion = KafkaController$.MODULE$.InitialControllerEpochZkVersion() + 1;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int firstControllerEpoch() {
        return this.firstControllerEpoch;
    }

    public int firstControllerEpochZkVersion() {
        return this.firstControllerEpochZkVersion;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.servers_$eq((Seq<KafkaServer>)Nil$.MODULE$);
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEmptyCluster() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testEmptyCluster$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testEmptyCluster$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerEpochPersistsWhenAllBrokersDown() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerEpochPersistsWhenAllBrokersDown$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerEpochPersistsWhenAllBrokersDown$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerEpochPersistsWhenAllBrokersDown$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerEpochPersistsWhenAllBrokersDown$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "controller epoch was not persisted after broker failure");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveIncrementsControllerEpoch() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerMoveIncrementsControllerEpoch$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMoveIncrementsControllerEpoch$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch(), "broker failed to set controller epoch");
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        ((KafkaServer)this.servers().head()).startup();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerMoveIncrementsControllerEpoch$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMoveIncrementsControllerEpoch$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilControllerEpoch(this.firstControllerEpoch() + 1, "controller epoch was not incremented after controller move");
    }

    @Test
    public void testMetadataPropagationOnControlPlane() {
        int x$1 = 1;
        Some x$2 = new Some((Object)"PLAINTEXT://localhost:0,CONTROLLER://localhost:0");
        Some x$3 = new Some((Object)"PLAINTEXT:PLAINTEXT,CONTROLLER:PLAINTEXT");
        Some x$4 = new Some((Object)"CONTROLLER");
        boolean x$5 = this.makeServers$default$2();
        boolean x$6 = this.makeServers$default$3();
        boolean x$7 = this.makeServers$default$4();
        Option<ApiVersion> x$8 = this.makeServers$default$8();
        int x$9 = this.makeServers$default$9();
        this.servers_$eq(this.makeServers(x$1, x$5, x$6, x$7, (Option<String>)x$2, (Option<String>)x$3, (Option<String>)x$4, x$8, x$9));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        scala.collection.mutable.Map controlPlaneMetricMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Map dataPlaneMetricMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((KafkaServer)this.servers().head()).metrics().metrics().values().forEach(kafkaMetric -> {
            if (kafkaMetric.metricName().tags().values().contains("CONTROLLER")) {
                controlPlaneMetricMap.put((Object)kafkaMetric.metricName().name(), kafkaMetric);
            }
            if (kafkaMetric.metricName().tags().values().contains("PLAINTEXT")) {
                dataPlaneMetricMap.put((Object)kafkaMetric.metricName().name(), kafkaMetric);
            }
        });
        Assertions.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"response-total")).metricValue()), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"response-total")).metricValue()), (double)0.0);
        Assertions.assertEquals((double)1.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"request-total")).metricValue()), (double)0.0);
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"request-total")).metricValue()), (double)0.0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"incoming-byte-total")).metricValue()) > 1.0 ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"incoming-byte-total")).metricValue()) == 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)controlPlaneMetricMap.apply((Object)"network-io-total")).metricValue()) == 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((KafkaMetric)dataPlaneMetricMap.apply((Object)"network-io-total")).metricValue()) == 0.0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetadataPropagationOnBrokerChange() {
        this.servers_$eq(this.makeServers(3, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer testBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$1(controllerId, e)))).head();
        Seq remainingBrokers = (Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$2(testBroker, x$1)));
        String topic = "topic1";
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaServer)remainingBrokers.apply(0)).config().brokerId(), testBroker.config().brokerId()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), remainingBrokers.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$3(x$2)), Seq$.MODULE$.canBuildFrom()))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, this.servers());
        testBroker.shutdown();
        testBroker.awaitShutdown();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)remainingBrokers, TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        remainingBrokers.foreach((Function1 & Serializable & scala.Serializable)server -> {
            ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$4(topic, testBroker, assignment, remainingBrokers, server);
            return BoxedUnit.UNIT;
        });
        testBroker.startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$5(this, assignment, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testMetadataPropagationForOfflineReplicas() {
        this.servers_$eq(this.makeServers(3, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer replicaBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$1(controllerId, e)))).head();
        KafkaServer controllerBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$2(controllerId, e)))).head();
        KafkaServer otherBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$3(controllerId, replicaBroker, e)))).head();
        String topic = "topic1";
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaBroker.config().brokerId()})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)assignment, this.servers());
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        replicaBroker.shutdown();
        replicaBroker.awaitShutdown();
        controllerBroker.shutdown();
        controllerBroker.awaitShutdown();
        ControllerIntegrationTest.verifyMetadata$1(controllerBroker, topic);
        ControllerIntegrationTest.verifyMetadata$1(otherBroker, topic);
    }

    @Test
    public void testTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicCreationWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicCreationWithOfflineReplica$1(x$3)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != controllerId)).head());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)((Seq)this.servers().take(1)));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
    }

    @Test
    public void testTopicPartitionExpansion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Map expandedAssignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().setTopicAssignment(tp0.topic(), (Option)new Some((Object)Uuid.randomUuid()), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
    }

    @Test
    public void testTopicPartitionExpansionWithOfflineReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testTopicPartitionExpansionWithOfflineReplica$1(x$5)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 != controllerId)).head());
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp0.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        Map expandedAssignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp0.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().setTopicAssignment(tp0.topic(), (Option)new Some((Object)Uuid.randomUuid()), expandedAssignment, this.firstControllerEpochZkVersion());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic partition expansion");
        TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)new .colon.colon((Object)((KafkaServer)this.servers().apply(controllerId)), (List)Nil$.MODULE$), tp1.topic(), tp1.partition(), TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignment() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        String metricName = new StringBuilder(43).append("kafka.controller:type=ControllerStats,name=").append(ControllerState.AlterPartitionReassignment$.MODULE$.rateAndTimeMetricName().get()).toString();
        long timerCount = this.timer(metricName).count();
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignment$1(x$7)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().createPartitionReassignment((Map)reassignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.replicas());
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom()));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "failed to get expected partition state after partition reassignment");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignment$4(this, tp, reassignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignment$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignment$6(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignment$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long updatedTimerCount = this.timer(metricName).count();
        Assertions.assertTrue((updatedTimerCount > timerCount ? 1 : 0) != 0, (String)new StringBuilder(36).append("Timer count ").append(updatedTimerCount).append(" should be greater than ").append(timerCount).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentToBrokerWithOfflineLogDir() {
        int x$1 = 2;
        int x$2 = 2;
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        Option<ApiVersion> x$92 = this.makeServers$default$8();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$92, x$2));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        String metricName = new StringBuilder(43).append("kafka.controller:type=ControllerStats,name=").append(ControllerState.AlterPartitionReassignment$.MODULE$.rateAndTimeMetricName().get()).toString();
        long timerCount = this.timer(metricName).count();
        KafkaServer otherBroker = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$1(controllerId, x$9)))).head();
        int otherBrokerId = otherBroker.config().brokerId();
        TopicPartition topicPartitionToPutOffline = new TopicPartition("filler", 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topicPartitionToPutOffline.topic(), (Map<Object, Seq<Object>>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartitionToPutOffline.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}))), this.servers());
        TestUtils$.MODULE$.causeLogDirFailure(TestUtils$Checkpoint$.MODULE$, otherBroker, topicPartitionToPutOffline);
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.zkClient().createPartitionReassignment((Map)reassignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.replicas());
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom()));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 3, "with an offline log directory on the target broker, the partition reassignment stalls");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$3(this, tp, reassignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$5(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long updatedTimerCount = this.timer(metricName).count();
        Assertions.assertTrue((updatedTimerCount > timerCount ? 1 : 0) != 0, (String)new StringBuilder(36).append("Timer count ").append(updatedTimerCount).append(" should be greater than ").append(timerCount).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentWithOfflineReplicaHaltingProgress() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(x$10)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$11 -> x$11 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        KafkaServer controller = this.getController();
        this.zkClient().setOrCreatePartitionReassignment(reassignment, controller.kafkaController().controllerContext().epochZkVersion());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionReassignmentResumesAfterReplicaComesOnline() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(x$12)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$13 -> x$13 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPartitionReassignment((Map)reassignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition k = (TopicPartition)x0$1._1();
            ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.replicas());
            return tuple2;
        }, scala.collection.Map$.MODULE$.canBuildFrom()));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state during partition reassignment with offline replica");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 4, "failed to get expected partition state after partition reassignment");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$4(this, tp, reassignment)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$6(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElection$1(controllerId, x$14))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
    }

    @Test
    public void testBackToBackPreferredReplicaLeaderElections() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testBackToBackPreferredReplicaLeaderElections$1(controllerId, x$15))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch());
        this.preferredReplicaLeaderElection(controllerId, otherBroker, tp, (scala.collection.immutable.Set<Object>)((TraversableOnce)assignment.apply((Object)BoxesRunTime.boxToInteger((int)tp.partition()))).toSet(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreferredReplicaLeaderElectionWithOfflinePreferredReplica() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(x$16)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$17 -> x$17 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId, controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
    }

    @Test
    public void testAutoPreferredReplicaLeaderElection() {
        this.servers_$eq(this.makeServers(2, true, this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testAutoPreferredReplicaLeaderElection$1(x$18)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$19 -> x$19 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1, "failed to get expected partition state upon broker shutdown");
        ((KafkaServer)this.servers().apply(otherBrokerId)).startup();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 2, "failed to get expected partition state upon broker startup");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(x$20)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$21 -> x$21 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$3(this, tp, otherBrokerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled() {
        int x$1 = 2;
        boolean x$2 = true;
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$4();
        Option<String> x$5 = this.makeServers$default$5();
        Option<String> x$6 = this.makeServers$default$6();
        Option<String> x$7 = this.makeServers$default$7();
        Option<ApiVersion> x$8 = this.makeServers$default$8();
        int x$9 = this.makeServers$default$9();
        this.servers_$eq(this.makeServers(x$1, x$3, x$2, x$4, x$5, x$6, x$7, x$8, x$9));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int otherBrokerId = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToInteger((int)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(x$22)), Seq$.MODULE$.canBuildFrom())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$23 -> x$23 != controllerId)).head());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBrokerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        ((KafkaServer)this.servers().apply(otherBrokerId)).shutdown();
        ((KafkaServer)this.servers().apply(otherBrokerId)).awaitShutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$3(this, tp, otherBrokerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControlledShutdown() {
        void var14_17;
        Map expectedReplicaAssignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 0;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)serverConfigs.reverse()).map((Function1 & Serializable & scala.Serializable)s -> TestUtils$.MODULE$.createServer((KafkaConfig)s, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get());
        KafkaController controller = ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$3(controllerId, p))).get()).kafkaController();
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        Function1 & Serializable & scala.Serializable controlledShutdownCallback = (Function1 & Serializable & scala.Serializable)controlledShutdownResult -> {
            resultQueue.put(controlledShutdownResult);
            return BoxedUnit.UNIT;
        };
        controller.controlledShutdown(2, ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$5(x$24))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        Set partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        ObjectRef activeServers = ObjectRef.create((Object)((Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$6(s)))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControlledShutdown$7(activeServers, topic, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControlledShutdown$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)0, (int)partitionsRemaining.size());
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionStateInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)((Seq)activeServers.elem).head()).dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic, partition).get();
        int leaderAfterShutdown = partitionStateInfo.leader();
        Assertions.assertEquals((int)0, (int)leaderAfterShutdown);
        Assertions.assertEquals((int)2, (int)partitionStateInfo.isr().size());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo.isr()).asScala());
        controller.controlledShutdown(1, ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$10(x$26))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        Try try_ = (Try)resultQueue.take();
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                throw new AssertionError("Controlled shutdown failed due to error", exception);
            }
            throw new MatchError((Object)try_);
        }
        Set partitions = (Set)((Success)try_).value();
        partitionsRemaining = var14_17;
        Assertions.assertEquals((int)0, (int)partitionsRemaining.size());
        activeServers.elem = (Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$11(s)));
        partitionStateInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaServer)((Seq)activeServers.elem).head()).dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic, partition).get();
        leaderAfterShutdown = partitionStateInfo.leader();
        Assertions.assertEquals((int)0, (int)leaderAfterShutdown);
        Assertions.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$12(topic, partition, x$27))));
        controller.controlledShutdown(0, ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$13(x$28))).get()).kafkaController().brokerEpoch(), (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assertions.assertEquals((int)1, (int)partitionsRemaining.size());
        Assertions.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$14(topic, partition, x$29))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch() {
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)serverConfigs.reverse()).map((Function1 & Serializable & scala.Serializable)s -> TestUtils$.MODULE$.createServer((KafkaConfig)s, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        KafkaController controller = this.getController().kafkaController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$3(controller, e))).get();
        VolatileBooleanRef staleBrokerEpochDetected = VolatileBooleanRef.create((boolean)false);
        controller.controlledShutdown(otherBroker.config().brokerId(), otherBroker.kafkaController().brokerEpoch() - 1L, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ControllerIntegrationTest.$anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$4(staleBrokerEpochDetected, x0$1);
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!staleBrokerEpochDetected.elem) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveOnTopicCreation() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new MockEvent(null, testControllerMove_latch){
                private final CountDownLatch latch$6;

                public void process() {
                    this.latch$6.await();
                }

                public void preempt() {
                }
                {
                    this.latch$6 = latch$6;
                    super((ControllerState)ControllerState.TopicChange$.MODULE$);
                }
            });
            ControllerIntegrationTest.$anonfun$testControllerMoveOnTopicCreation$1(this, tp, assignment);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            testControllerMove_latch.countDown();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveOnTopicDeletion() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            ControllerIntegrationTest.$anonfun$testControllerMoveOnTopicDeletion$1(this, tp);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            testControllerMove_latch.countDown();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveOnPreferredReplicaElection() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            ControllerIntegrationTest.$anonfun$testControllerMoveOnPreferredReplicaElection$1(this, tp);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            testControllerMove_latch.countDown();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerMoveOnPartitionReassignment() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        KafkaController testControllerMove_controller = this.getController().kafkaController();
        LogCaptureAppender testControllerMove_appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level testControllerMove_previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.getClass(), Level.INFO);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            CountDownLatch testControllerMove_latch = new CountDownLatch(1);
            testControllerMove_controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            ControllerIntegrationTest.$anonfun$testControllerMoveOnPartitionReassignment$1(this, reassignment);
            this.zkClient().deleteController(testControllerMove_controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            testControllerMove_latch.countDown();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long testControllerMove_waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(testControllerMove_controller)) {
                void testControllerMove_waitUntilTrue_pause;
                void testControllerMove_waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > testControllerMove_waitUntilTrue_startTime2 + testControllerMove_waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)testControllerMove_waitUntilTrue_waitTimeMs), (long)testControllerMove_waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)testControllerMove_appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(testControllerMove_appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(testControllerMove_controller.eventManager().thread().getClass(), testControllerMove_previousLevel);
        }
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsEnabledWithNonExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)Option$.MODULE$.empty(), (ApiVersion)KAFKA_2_7_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsEnabledWithDisabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_7_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsEnabledWithEnabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_7_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsDisabledWithNonExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)Option$.MODULE$.empty(), (ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsDisabledWithDisabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    @Test
    public void testControllerFeatureZNodeSetupWhenFeatureVersioningIsDisabledWithEnabledExistingFeatureZNode() {
        this.testControllerFeatureZNodeSetup((Option<FeatureZNode>)new Some((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.emptyFinalizedFeatures())), (ApiVersion)KAFKA_2_6_IV0$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerDetectsBouncedBrokers() {
        int x$1 = 2;
        boolean x$2 = false;
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        Option<String> x$5 = this.makeServers$default$5();
        Option<String> x$6 = this.makeServers$default$6();
        Option<String> x$7 = this.makeServers$default$7();
        Option<ApiVersion> x$8 = this.makeServers$default$8();
        int x$9 = this.makeServers$default$9();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$2, x$5, x$6, x$7, x$8, x$9));
        KafkaController controller = this.getController().kafkaController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$1(controller, e))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$2(controller)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CountDownLatch latch = new CountDownLatch(1);
        controller.eventManager().put((ControllerEvent)new MockEvent(null, latch){
            private final CountDownLatch latch$1;

            public void process() {
                this.latch$1.await();
            }

            public void preempt() {
            }
            {
                this.latch$1 = latch$1;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        });
        otherBroker.shutdown();
        otherBroker.startup();
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)otherBroker.replicaManager().partitionCount().value()));
        latch.countDown();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$4(otherBroker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerDetectsBouncedBrokers$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPreemptionOnControllerShutdown() {
        int x$1 = 1;
        boolean x$2 = false;
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        Option<String> x$5 = this.makeServers$default$5();
        Option<String> x$6 = this.makeServers$default$6();
        Option<String> x$7 = this.makeServers$default$7();
        Option<ApiVersion> x$8 = this.makeServers$default$8();
        int x$9 = this.makeServers$default$9();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$2, x$5, x$6, x$7, x$8, x$9));
        KafkaController controller = this.getController().kafkaController();
        IntRef count = IntRef.create((int)2);
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventManager.ControllerEventThread spyThread = (ControllerEventManager.ControllerEventThread)Mockito.spy((Object)controller.eventManager().thread());
        controller.eventManager().thread_$eq(spyThread);
        MockEvent processedEvent = new MockEvent(null, latch){
            private final CountDownLatch latch$2;

            public void process() {
                this.latch$2.await();
            }

            public void preempt() {
            }
            {
                this.latch$2 = latch$2;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        };
        MockEvent preemptedEvent = new MockEvent(null, count){
            private final IntRef count$1;

            public void process() {
            }

            public void preempt() {
                --this.count$1.elem;
            }
            {
                this.count$1 = count$1;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        };
        controller.eventManager().put((ControllerEvent)processedEvent);
        controller.eventManager().put((ControllerEvent)preemptedEvent);
        controller.eventManager().put((ControllerEvent)preemptedEvent);
        ((ShutdownableThread)Mockito.doAnswer(x$30 -> {
            latch.countDown();
            return BoxedUnit.UNIT;
        }).doCallRealMethod().when((Object)spyThread)).awaitShutdown();
        controller.shutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testPreemptionOnControllerShutdown$2(count)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testPreemptionOnControllerShutdown$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((ShutdownableThread)Mockito.verify((Object)spyThread)).awaitShutdown();
    }

    @Test
    public void testPreemptionWithCallbacks() {
        int x$1 = 1;
        boolean x$2 = false;
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        Option<String> x$5 = this.makeServers$default$5();
        Option<String> x$6 = this.makeServers$default$6();
        Option<String> x$7 = this.makeServers$default$7();
        Option<ApiVersion> x$8 = this.makeServers$default$8();
        int x$9 = this.makeServers$default$9();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$2, x$5, x$6, x$7, x$8, x$9));
        KafkaController controller = this.getController().kafkaController();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventManager.ControllerEventThread spyThread = (ControllerEventManager.ControllerEventThread)Mockito.spy((Object)controller.eventManager().thread());
        controller.eventManager().thread_$eq(spyThread);
        MockEvent processedEvent = new MockEvent(null, latch){
            private final CountDownLatch latch$3;

            public void process() {
                this.latch$3.await();
            }

            public void preempt() {
            }
            {
                this.latch$3 = latch$3;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        };
        TopicPartition tp0 = new TopicPartition("t", 0);
        TopicPartition tp1 = new TopicPartition("t", 1);
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0, tp1}));
        ReplicaLeaderElection event1 = new ReplicaLeaderElection((Option)new Some((Object)partitions), ElectionType.PREFERRED, (ElectionTrigger)ZkTriggered$.MODULE$, (Function1 & Serializable & scala.Serializable)partitionsMap -> {
            partitionsMap.foreach((Function1 & Serializable & scala.Serializable)partition -> {
                ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$2(partition);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        ControlledShutdown event2 = new ControlledShutdown(0, 0L, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$3(x0$1);
            return BoxedUnit.UNIT;
        });
        ApiPartitionReassignment event3 = new ApiPartitionReassignment((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)None$.MODULE$)})), (Function1 & Serializable & scala.Serializable)x0$2 -> {
            ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$4(x0$2);
            return BoxedUnit.UNIT;
        });
        ListPartitionReassignments event4 = new ListPartitionReassignments((Option)new Some((Object)partitions), (Function1 & Serializable & scala.Serializable)x0$3 -> {
            ControllerIntegrationTest.$anonfun$testPreemptionWithCallbacks$5(x0$3);
            return BoxedUnit.UNIT;
        });
        controller.eventManager().put((ControllerEvent)processedEvent);
        controller.eventManager().put((ControllerEvent)event1);
        controller.eventManager().put((ControllerEvent)event2);
        controller.eventManager().put((ControllerEvent)event3);
        controller.eventManager().put((ControllerEvent)event4);
        ((ShutdownableThread)Mockito.doAnswer(x$31 -> {
            latch.countDown();
            return BoxedUnit.UNIT;
        }).doCallRealMethod().when((Object)spyThread)).awaitShutdown();
        controller.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private void testControllerFeatureZNodeSetup(Option<FeatureZNode> initialZNode, ApiVersion interBrokerProtocolVersion) {
        void var17_17;
        Option option;
        if (initialZNode instanceof Some) {
            FeatureZNode node = (FeatureZNode)((Some)initialZNode).value();
            this.zkClient().createFeatureZNode(node);
            option = new Some((Object)BoxesRunTime.boxToInteger((int)this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path())._2$mcI$sp()));
        } else if (None$.MODULE$.equals(initialZNode)) {
            option = Option$.MODULE$.empty();
        } else {
            throw new MatchError(initialZNode);
        }
        int x$1 = 1;
        Some x$2 = new Some((Object)interBrokerProtocolVersion);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        CountDownLatch latch = new CountDownLatch(1);
        controller.eventManager().put((ControllerEvent)new MockEvent(null, latch){
            private final CountDownLatch latch$4;

            public void process() {
                this.latch$4.countDown();
            }

            public void preempt() {
            }
            {
                this.latch$4 = latch$4;
                super((ControllerState)ControllerState.TopicChange$.MODULE$);
            }
        });
        latch.await();
        Tuple2 tuple2 = this.zkClient().getDataAndVersion(FeatureZNode$.MODULE$.path());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
        int n = tuple2._2$mcI$sp();
        FeatureZNode newZNode = FeatureZNode$.MODULE$.decode((byte[])var17_17.get());
        if (interBrokerProtocolVersion.$greater$eq((Object)KAFKA_2_7_IV0$.MODULE$)) {
            FeatureZNode emptyZNode = new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.emptyFinalizedFeatures());
            if (initialZNode instanceof Some) {
                FeatureZNode node = (FeatureZNode)((Some)initialZNode).value();
                FeatureZNodeStatus featureZNodeStatus = node.status();
                if (FeatureZNodeStatus.Enabled$.MODULE$.equals(featureZNodeStatus)) {
                    Assertions.assertEquals((int)BoxesRunTime.unboxToInt((Object)option.get()), (int)n);
                    Assertions.assertEquals((Object)node, (Object)newZNode);
                    return;
                }
                if (FeatureZNodeStatus.Disabled$.MODULE$.equals(featureZNodeStatus)) {
                    Assertions.assertEquals((int)(BoxesRunTime.unboxToInt((Object)option.get()) + 1), (int)n);
                    Assertions.assertEquals((Object)emptyZNode, (Object)newZNode);
                    return;
                }
                throw new MatchError((Object)featureZNodeStatus);
            }
            if (None$.MODULE$.equals(initialZNode)) {
                Assertions.assertEquals((int)0, (int)n);
                Assertions.assertEquals((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Enabled$.MODULE$, Features.emptyFinalizedFeatures()), (Object)newZNode);
                return;
            }
            throw new MatchError(initialZNode);
        }
        FeatureZNode emptyZNode = new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, Features.emptyFinalizedFeatures());
        if (initialZNode instanceof Some) {
            FeatureZNodeStatus featureZNodeStatus = ((FeatureZNode)((Some)initialZNode).value()).status();
            if (FeatureZNodeStatus.Enabled$.MODULE$.equals(featureZNodeStatus)) {
                Assertions.assertEquals((int)(BoxesRunTime.unboxToInt((Object)option.get()) + 1), (int)n);
                Assertions.assertEquals((Object)emptyZNode, (Object)newZNode);
                return;
            }
            if (FeatureZNodeStatus.Disabled$.MODULE$.equals(featureZNodeStatus)) {
                Assertions.assertEquals((int)BoxesRunTime.unboxToInt((Object)option.get()), (int)n);
                Assertions.assertEquals((Object)emptyZNode, (Object)newZNode);
                return;
            }
            throw new MatchError((Object)featureZNodeStatus);
        }
        if (None$.MODULE$.equals(initialZNode)) {
            Assertions.assertEquals((int)0, (int)n);
            Assertions.assertEquals((Object)new FeatureZNode((FeatureZNodeStatus)FeatureZNodeStatus.Disabled$.MODULE$, Features.emptyFinalizedFeatures()), (Object)newZNode);
            return;
        }
        throw new MatchError(initialZNode);
    }

    @Test
    public void testIdempotentAlterIsr() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testIdempotentAlterIsr$1(controllerId, x$33))).get();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBroker.config().brokerId(), controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        CountDownLatch latch = new CountDownLatch(1);
        KafkaController controller = this.getController().kafkaController();
        LeaderAndIsr newLeaderAndIsr = ((LeaderIsrAndControllerEpoch)this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).apply((Object)tp)).leaderAndIsr();
        Function1 & Serializable & scala.Serializable callback = (Function1 & Serializable & scala.Serializable)result -> {
            ControllerIntegrationTest.$anonfun$testIdempotentAlterIsr$2(tp, newLeaderAndIsr, latch, result);
            return BoxedUnit.UNIT;
        };
        long brokerEpoch = BoxesRunTime.unboxToLong((Object)controller.controllerContext().liveBrokerIdAndEpochs().get((Object)BoxesRunTime.boxToInteger((int)otherBroker.config().brokerId())).get());
        controller.eventManager().put((ControllerEvent)new AlterIsrReceived(otherBroker.config().brokerId(), brokerEpoch, (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)newLeaderAndIsr)})), (Function1)callback));
        latch.await();
    }

    @Test
    public void testTopicIdsAreAdded() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp1 = new TopicPartition("t1", 0);
        Map assignment1 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp1.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp1.topic(), (Map<Object, Seq<Object>>)assignment1, this.servers());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
        Uuid topicId1 = (Uuid)controller.controllerContext().topicIds().apply((Object)"t1");
        Assertions.assertEquals((Object)"t1", (Object)controller.controllerContext().topicNames().apply((Object)topicId1));
        TopicPartition tp2 = new TopicPartition("t2", 0);
        Map assignment2 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp2.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp2.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp2, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t2"));
        Uuid topicId2 = (Uuid)controller.controllerContext().topicIds().apply((Object)"t2");
        Assertions.assertEquals((Object)"t2", (Object)controller.controllerContext().topicNames().apply((Object)topicId2));
        Assertions.assertEquals((Object)topicId1, (Object)controller.controllerContext().topicIds().get((Object)"t1").get());
        Assertions.assertNotEquals((Object)topicId1, (Object)topicId2);
    }

    @Test
    public void testTopicIdsAreNotAdded() {
        int x$1 = 1;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9));
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp1 = new TopicPartition("t1", 0);
        Map assignment1 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp1.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp1.topic(), (Map<Object, Seq<Object>>)assignment1, this.servers());
        this.waitForPartitionState(tp1, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
        TopicPartition tp2 = new TopicPartition("t2", 0);
        Map assignment2 = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp2.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp2.topic(), (Map<Object, Seq<Object>>)assignment2, this.servers());
        this.waitForPartitionState(tp2, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t2"));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)controller.controllerContext().topicIds().get((Object)"t1"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdMigrationAndHandling() {
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        adminZkClient.createTopic(tp.topic(), 1, 1, adminZkClient.createTopic$default$4(), adminZkClient.createTopic$default$5(), adminZkClient.createTopic$default$6());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterCreate = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertTrue((boolean)topicIdAfterCreate.isDefined());
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"correct topic ID cannot be found in the controller context");
        adminZkClient.addPartitions(tp.topic(), assignment, adminZkClient.getBrokerMetadatas(adminZkClient.getBrokerMetadatas$default$1(), adminZkClient.getBrokerMetadatas$default$2()), 2, adminZkClient.addPartitions$default$5(), adminZkClient.addPartitions$default$6());
        Option topicIdAfterAddition = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)topicIdAfterAddition);
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"topic ID changed after partition additions");
        adminZkClient.deleteTopic(tp.topic());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdMigrationAndHandling$1(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdMigrationAndHandling$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdMigrationAndHandlingWithOlderVersion() {
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$))}));
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        int x$1 = 1;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9));
        adminZkClient.createTopic(tp.topic(), 1, 1, adminZkClient.createTopic$default$4(), adminZkClient.createTopic$default$5(), adminZkClient.createTopic$default$6());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterCreate = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)topicIdAfterCreate);
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"incorrect topic ID can be found in the controller context");
        adminZkClient.addPartitions(tp.topic(), assignment, adminZkClient.getBrokerMetadatas(adminZkClient.getBrokerMetadatas$default$1(), adminZkClient.getBrokerMetadatas$default$2()), 2, adminZkClient.addPartitions$default$5(), adminZkClient.addPartitions$default$6());
        Option topicIdAfterAddition = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)topicIdAfterAddition);
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"topic ID changed after partition additions");
        adminZkClient.deleteTopic(tp.topic());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdMigrationAndHandlingWithOlderVersion$1(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdMigrationAndHandlingWithOlderVersion$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdPersistsThroughControllerReelection() {
        this.servers_$eq(this.makeServers(2, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Uuid topicId = (Uuid)controller.controllerContext().topicIds().get((Object)"t").get();
        ((KafkaServer)this.servers().apply(controllerId)).shutdown();
        ((KafkaServer)this.servers().apply(controllerId)).awaitShutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdPersistsThroughControllerReelection$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdPersistsThroughControllerReelection$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaController controller2 = this.getController().kafkaController();
        Assertions.assertEquals((Object)topicId, (Object)controller2.controllerContext().topicIds().get((Object)"t").get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoTopicIdPersistsThroughControllerReelection() {
        int x$1 = 2;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option emptyTopicId = controller.controllerContext().topicIds().get((Object)"t");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)emptyTopicId);
        ((KafkaServer)this.servers().apply(controllerId)).shutdown();
        ((KafkaServer)this.servers().apply(controllerId)).awaitShutdown();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testNoTopicIdPersistsThroughControllerReelection$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testNoTopicIdPersistsThroughControllerReelection$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaController controller2 = this.getController().kafkaController();
        Assertions.assertEquals((Object)emptyTopicId, (Object)controller2.controllerContext().topicIds().get((Object)"t"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdPersistsThroughControllerRestart() {
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Uuid topicId = (Uuid)controller.controllerContext().topicIds().get((Object)"t").get();
        ((KafkaServer)this.servers().apply(controllerId)).shutdown();
        ((KafkaServer)this.servers().apply(controllerId)).awaitShutdown();
        ((KafkaServer)this.servers().apply(controllerId)).startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdPersistsThroughControllerRestart$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdPersistsThroughControllerRestart$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaController controller2 = this.getController().kafkaController();
        Assertions.assertEquals((Object)topicId, (Object)controller2.controllerContext().topicIds().get((Object)"t").get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdCreatedOnUpgrade() {
        int x$1 = 1;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9));
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        KafkaController controller = this.getController().kafkaController();
        TopicPartition tp = new TopicPartition("t", 0);
        Map assignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{controllerId})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)assignment, this.servers());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterCreate = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)topicIdAfterCreate);
        Option emptyTopicId = controller.controllerContext().topicIds().get((Object)"t");
        Assertions.assertEquals((Object)None$.MODULE$, (Object)emptyTopicId);
        ((KafkaServer)this.servers().apply(controllerId)).shutdown();
        ((KafkaServer)this.servers().apply(controllerId)).awaitShutdown();
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Option topicIdAfterUpgrade = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertNotEquals((Object)emptyTopicId, (Object)topicIdAfterUpgrade);
        KafkaController controller2 = this.getController().kafkaController();
        Assertions.assertNotEquals((Object)emptyTopicId, (Object)controller2.controllerContext().topicIds().get((Object)"t"));
        Uuid topicId = (Uuid)controller2.controllerContext().topicIds().get((Object)"t").get();
        Assertions.assertEquals((Object)topicIdAfterUpgrade.get(), (Object)topicId);
        Assertions.assertEquals((Object)"t", (Object)controller2.controllerContext().topicNames().apply((Object)topicId));
        this.adminZkClient().deleteTopic(tp.topic());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$3(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdCreatedOnUpgrade$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicIdUpgradeAfterReassigningPartitions() {
        TopicPartition tp = new TopicPartition("t", 0);
        Map reassignment = (Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))))}));
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        int x$1 = 1;
        Some x$2 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$3 = this.makeServers$default$2();
        boolean x$4 = this.makeServers$default$3();
        boolean x$5 = this.makeServers$default$4();
        Option<String> x$6 = this.makeServers$default$5();
        Option<String> x$7 = this.makeServers$default$6();
        Option<String> x$8 = this.makeServers$default$7();
        int x$9 = this.makeServers$default$9();
        this.servers_$eq(this.makeServers(x$1, x$3, x$4, x$5, x$6, x$7, x$8, (Option<ApiVersion>)x$2, x$9));
        adminZkClient.createTopic(tp.topic(), 1, 1, adminZkClient.createTopic$default$4(), adminZkClient.createTopic$default$5(), adminZkClient.createTopic$default$6());
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterCreate = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Option id = ((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic());
        Assertions.assertTrue((boolean)topicIdAfterCreate.isEmpty());
        Assertions.assertEquals((Object)topicIdAfterCreate, (Object)id, (String)"expected no topic ID, but one existed");
        ((KafkaServer)this.servers().apply(0)).shutdown();
        ((KafkaServer)this.servers().apply(0)).awaitShutdown();
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon controller restart");
        Option topicIdAfterUpgrade = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)topicIdAfterUpgrade, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"expected same topic ID but it can not be found");
        Assertions.assertEquals((Object)tp.topic(), (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicNames().apply(topicIdAfterUpgrade.get()), (String)"correct topic name expected but cannot be found in the controller context");
        ((KafkaServer)this.servers().apply(0)).shutdown();
        ((KafkaServer)this.servers().apply(0)).awaitShutdown();
        int x$10 = 1;
        Some x$11 = new Some((Object)KAFKA_2_7_IV0$.MODULE$);
        boolean x$12 = this.makeServers$default$2();
        boolean x$13 = this.makeServers$default$3();
        boolean x$14 = this.makeServers$default$4();
        Option<String> x$15 = this.makeServers$default$5();
        Option<String> x$16 = this.makeServers$default$6();
        Option<String> x$17 = this.makeServers$default$7();
        int x$18 = this.makeServers$default$9();
        this.servers_$eq(this.makeServers(x$10, x$12, x$13, x$14, x$15, x$16, x$17, (Option<ApiVersion>)x$11, x$18));
        this.waitForPartitionState(tp, this.firstControllerEpoch(), 0, LeaderAndIsr$.MODULE$.initialLeaderEpoch(), "failed to get expected partition state upon topic creation");
        Option topicIdAfterDowngrade = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertTrue((boolean)topicIdAfterDowngrade.isDefined());
        Assertions.assertEquals((Object)topicIdAfterUpgrade, (Object)topicIdAfterDowngrade, (String)"expected same topic ID but it can not be found after downgrade");
        Assertions.assertEquals((Object)topicIdAfterDowngrade, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"expected same topic ID in controller context but it is no longer found after downgrade");
        Assertions.assertEquals((Object)tp.topic(), (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicNames().apply(topicIdAfterUpgrade.get()), (String)"correct topic name expected but cannot be found in the controller context");
        ((KafkaServer)this.servers().apply(0)).kafkaController().eventManager().put((ControllerEvent)new ApiPartitionReassignment(reassignment, (Function1 & Serializable & scala.Serializable)x$34 -> {
            ControllerIntegrationTest.$anonfun$testTopicIdUpgradeAfterReassigningPartitions$1(x$34);
            return BoxedUnit.UNIT;
        }));
        this.waitForPartitionState(tp, 3, 0, 1, "failed to get expected partition state upon controller restart");
        Option topicIdAfterReassignment = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertTrue((boolean)topicIdAfterReassignment.isDefined());
        Assertions.assertEquals((Object)topicIdAfterUpgrade, (Object)topicIdAfterReassignment, (String)"expected same topic ID but it can not be found after reassignment");
        Assertions.assertEquals((Object)topicIdAfterUpgrade, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"expected same topic ID in controller context but is no longer found after reassignment");
        Assertions.assertEquals((Object)tp.topic(), (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicNames().apply(topicIdAfterUpgrade.get()), (String)"correct topic name expected but cannot be found in the controller context");
        ((KafkaServer)this.servers().apply(0)).shutdown();
        ((KafkaServer)this.servers().apply(0)).awaitShutdown();
        this.servers_$eq(this.makeServers(1, this.makeServers$default$2(), this.makeServers$default$3(), this.makeServers$default$4(), this.makeServers$default$5(), this.makeServers$default$6(), this.makeServers$default$7(), this.makeServers$default$8(), this.makeServers$default$9()));
        this.waitForPartitionState(tp, 3, 0, 1, "failed to get expected partition state upon controller restart");
        Option topicIdAfterReUpgrade = this.zkClient().getTopicIdsForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp.topic()}))).get((Object)tp.topic());
        Assertions.assertEquals((Object)topicIdAfterUpgrade, (Object)topicIdAfterReUpgrade, (String)"expected same topic ID but it can not be found after re-upgrade");
        Assertions.assertEquals((Object)topicIdAfterReUpgrade, (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp.topic()), (String)"topic ID can not be found in controller context after re-upgrading IBP");
        Assertions.assertEquals((Object)tp.topic(), (Object)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicNames().apply(topicIdAfterReUpgrade.get()), (String)"correct topic name expected but cannot be found in the controller context");
        adminZkClient.deleteTopic(tp.topic());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testTopicIdUpgradeAfterReassigningPartitions$2(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testTopicIdUpgradeAfterReassigningPartitions$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicNames().get(topicIdAfterUpgrade.get()).isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private void testControllerMove(Function0<BoxedUnit> fun) {
        KafkaController controller = this.getController().kafkaController();
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.getClass(), Level.INFO);
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$1(controller)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            CountDownLatch latch = new CountDownLatch(1);
            controller.eventManager().put((ControllerEvent)new /* invalid duplicate definition of identical inner class */);
            fun.apply$mcV$sp();
            this.zkClient().deleteController(controller.controllerContext().epochZkVersion());
            this.zkClient().registerControllerAndIncrementControllerEpoch(this.servers().size());
            latch.countDown();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!ControllerIntegrationTest.$anonfun$testControllerMove$3(controller)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ControllerIntegrationTest.$anonfun$testControllerMove$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertTrue((boolean)appender.getMessages().find((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControllerMove$5(e))).isDefined());
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(controller.eventManager().thread().getClass(), previousLevel);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void preferredReplicaLeaderElection(int controllerId, KafkaServer otherBroker, TopicPartition tp, scala.collection.immutable.Set<Object> replicas, int leaderEpoch) {
        otherBroker.shutdown();
        otherBroker.awaitShutdown();
        this.waitForPartitionState(tp, this.firstControllerEpoch(), controllerId, leaderEpoch + 1, "failed to get expected partition state upon broker shutdown");
        otherBroker.startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$preferredReplicaLeaderElection$1(this, tp, replicas)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$preferredReplicaLeaderElection$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$preferredReplicaLeaderElection$3(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$preferredReplicaLeaderElection$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitForPartitionState(tp, this.firstControllerEpoch(), otherBroker.config().brokerId(), leaderEpoch + 2, "failed to get expected partition state upon broker startup");
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilControllerEpoch(int epoch, String message) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$waitUntilControllerEpoch$1(this, epoch)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)message);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForPartitionState(TopicPartition tp, int controllerEpoch, int leader, int leaderEpoch, String message) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$waitForPartitionState$1(this, tp, controllerEpoch, leader, leaderEpoch)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)message);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private boolean isExpectedPartitionState(LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, int controllerEpoch, int leader, int leaderEpoch) {
        return leaderIsrAndControllerEpoch.controllerEpoch() == controllerEpoch && leaderIsrAndControllerEpoch.leaderAndIsr().leader() == leader && leaderIsrAndControllerEpoch.leaderAndIsr().leaderEpoch() == leaderEpoch;
    }

    private Seq<KafkaServer> makeServers(int numConfigs, boolean autoLeaderRebalanceEnable, boolean uncleanLeaderElectionEnable, boolean enableControlledShutdown, Option<String> listeners, Option<String> listenerSecurityProtocolMap, Option<String> controlPlaneListenerName, Option<ApiVersion> interBrokerProtocolVersion, int logDirCount) {
        String x$2 = this.zkConnect();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        Map<Object, String> x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$12();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$15();
        short x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$16();
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(numConfigs, x$2, enableControlledShutdown, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, logDirCount, x$14, x$15, x$16);
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            ControllerIntegrationTest.$anonfun$makeServers$1(autoLeaderRebalanceEnable, uncleanLeaderElectionEnable, listeners, listenerSecurityProtocolMap, controlPlaneListenerName, interBrokerProtocolVersion, config);
            return BoxedUnit.UNIT;
        });
        return (Seq)configs.map((Function1 & Serializable & scala.Serializable)config -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
    }

    private boolean makeServers$default$2() {
        return false;
    }

    private boolean makeServers$default$3() {
        return false;
    }

    private boolean makeServers$default$4() {
        return true;
    }

    private Option<String> makeServers$default$5() {
        return None$.MODULE$;
    }

    private Option<String> makeServers$default$6() {
        return None$.MODULE$;
    }

    private Option<String> makeServers$default$7() {
        return None$.MODULE$;
    }

    private Option<ApiVersion> makeServers$default$8() {
        return None$.MODULE$;
    }

    private int makeServers$default$9() {
        return 1;
    }

    private Timer timer(String metricName) {
        return (Timer)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$timer$1(metricName, x0$1)))).values().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(22).append("Unable to find metric ").append(metricName).toString());
        });
    }

    private KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$getController$1(controllerId, s)))).head();
    }

    public static final /* synthetic */ boolean $anonfun$testEmptyCluster$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testEmptyCluster$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerEpochPersistsWhenAllBrokersDown$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerEpochPersistsWhenAllBrokersDown$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerEpochPersistsWhenAllBrokersDown$3(ControllerIntegrationTest $this) {
        return !$this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerEpochPersistsWhenAllBrokersDown$4() {
        return "failed to kill controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMoveIncrementsControllerEpoch$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerMoveIncrementsControllerEpoch$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMoveIncrementsControllerEpoch$3(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testControllerMoveIncrementsControllerEpoch$4() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$1(int controllerId$1, KafkaServer e) {
        return e.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$2(KafkaServer testBroker$1, KafkaServer x$1) {
        return x$1.config().brokerId() != testBroker$1.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testMetadataPropagationOnBrokerChange$3(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testMetadataPropagationOnBrokerChange$4(String topic$1, KafkaServer testBroker$1, Map assignment$1, Seq remainingBrokers$1, KafkaServer server) {
        UpdateMetadataRequestData.UpdateMetadataPartitionState offlineReplicaPartitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)server.metadataCache().getPartitionInfo(topic$1, 0).get();
        Assertions.assertEquals((int)1, (int)offlineReplicaPartitionInfo.offlineReplicas().size());
        Assertions.assertEquals((int)testBroker$1.config().brokerId(), (Integer)((Integer)offlineReplicaPartitionInfo.offlineReplicas().get(0)));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).asJava(), (Object)offlineReplicaPartitionInfo.replicas());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaServer)remainingBrokers$1.head()).config().brokerId()}))).asJava(), (Object)offlineReplicaPartitionInfo.isr());
        UpdateMetadataRequestData.UpdateMetadataPartitionState onlinePartitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)server.metadataCache().getPartitionInfo(topic$1, 1).get();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)assignment$1.apply((Object)BoxesRunTime.boxToInteger((int)1))).asJava(), (Object)onlinePartitionInfo.replicas());
        Assertions.assertTrue((boolean)onlinePartitionInfo.offlineReplicas().isEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$7(KafkaServer server$1, String topic$1, Tuple2 x0$1) {
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionInfo;
        Seq replicas;
        int partitionId;
        if (x0$1 != null) {
            partitionId = x0$1._1$mcI$sp();
            replicas = (Seq)x0$1._2();
        } else {
            throw new MatchError(null);
        }
        Option partitionInfoOpt = server$1.metadataCache().getPartitionInfo(topic$1, partitionId);
        boolean bl = partitionInfoOpt.isDefined() ? !(partitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get()).offlineReplicas().isEmpty() || !((GenSeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionInfo.replicas()).asScala()).equals((Object)replicas) : true;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationOnBrokerChange$5(ControllerIntegrationTest $this, Map assignment$1, String topic$1) {
        return !$this.servers().exists((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)assignment$1.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testMetadataPropagationOnBrokerChange$7(server, topic$1, x0$1)))));
    }

    public static final /* synthetic */ String $anonfun$testMetadataPropagationOnBrokerChange$8() {
        return "Inconsistent metadata after broker startup";
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$1(int controllerId$2, KafkaServer e) {
        return e.config().brokerId() != controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$2(int controllerId$2, KafkaServer e) {
        return e.config().brokerId() == controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$3(int controllerId$2, KafkaServer replicaBroker$1, KafkaServer e) {
        return e.config().brokerId() != controllerId$2 && e.config().brokerId() != replicaBroker$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataPropagationForOfflineReplicas$4(KafkaServer broker$1, String topic$2) {
        Option partitionInfoOpt = broker$1.metadataCache().getPartitionInfo(topic$2, 0);
        if (partitionInfoOpt.isDefined()) {
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionInfo = (UpdateMetadataRequestData.UpdateMetadataPartitionState)partitionInfoOpt.get();
            return !partitionInfo.offlineReplicas().isEmpty() && partitionInfo.leader() == -1 && !partitionInfo.replicas().isEmpty() && !partitionInfo.isr().isEmpty();
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testMetadataPropagationForOfflineReplicas$5() {
        return "Inconsistent metadata after broker startup";
    }

    /*
     * WARNING - void declaration
     */
    private static final void verifyMetadata$1(KafkaServer broker, String topic$2) {
        broker.startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$4(broker, topic$2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ControllerIntegrationTest.$anonfun$testMetadataPropagationForOfflineReplicas$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ int $anonfun$testTopicCreationWithOfflineReplica$1(KafkaServer x$3) {
        return x$3.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testTopicPartitionExpansionWithOfflineReplica$1(KafkaServer x$5) {
        return x$5.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignment$1(KafkaServer x$7) {
        return x$7.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignment$4(ControllerIntegrationTest $this, TopicPartition tp$1, Map reassignment$1) {
        Map map = $this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp$1.topic()})));
        return !(map != null ? !map.equals(reassignment$1) : reassignment$1 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignment$5() {
        return "failed to get updated partition assignment on topic znode after partition reassignment";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignment$6(ControllerIntegrationTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignment$7() {
        return "failed to remove reassign partitions path after completion";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$1(int controllerId$6, KafkaServer x$9) {
        return x$9.config().brokerId() != controllerId$6;
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$3(ControllerIntegrationTest $this, TopicPartition tp$2, Map reassignment$2) {
        Map map = $this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp$2.topic()})));
        return !(map != null ? !map.equals(reassignment$2) : reassignment$2 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$4() {
        return "failed to get updated partition assignment on topic znode after partition reassignment";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$5(ControllerIntegrationTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentToBrokerWithOfflineLogDir$6() {
        return "failed to remove reassign partitions path after completion";
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$1(KafkaServer x$10) {
        return x$10.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$3(ControllerIntegrationTest $this) {
        return $this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentWithOfflineReplicaHaltingProgress$4() {
        return "partition reassignment path should remain while reassignment in progress";
    }

    public static final /* synthetic */ int $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$1(KafkaServer x$12) {
        return x$12.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$4(ControllerIntegrationTest $this, TopicPartition tp$3, Map reassignment$3) {
        Map map = $this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tp$3.topic()})));
        return !(map != null ? !map.equals(reassignment$3) : reassignment$3 != null);
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$5() {
        return "failed to get updated partition assignment on topic znode after partition reassignment";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$6(ControllerIntegrationTest $this) {
        return !$this.zkClient().reassignPartitionsInProgress();
    }

    public static final /* synthetic */ String $anonfun$testPartitionReassignmentResumesAfterReplicaComesOnline$7() {
        return "failed to remove reassign partitions path after completion";
    }

    public static final /* synthetic */ boolean $anonfun$testPreferredReplicaLeaderElection$1(int controllerId$9, KafkaServer x$14) {
        return x$14.config().brokerId() != controllerId$9;
    }

    public static final /* synthetic */ boolean $anonfun$testBackToBackPreferredReplicaLeaderElections$1(int controllerId$10, KafkaServer x$15) {
        return x$15.config().brokerId() != controllerId$10;
    }

    public static final /* synthetic */ int $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$1(KafkaServer x$16) {
        return x$16.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$3(ControllerIntegrationTest $this) {
        return !$this.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path());
    }

    public static final /* synthetic */ String $anonfun$testPreferredReplicaLeaderElectionWithOfflinePreferredReplica$4() {
        return "failed to remove preferred replica leader election path after giving up";
    }

    public static final /* synthetic */ int $anonfun$testAutoPreferredReplicaLeaderElection$1(KafkaServer x$18) {
        return x$18.config().brokerId();
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$1(KafkaServer x$20) {
        return x$20.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$3(ControllerIntegrationTest $this, TopicPartition tp$4, int otherBrokerId$1) {
        Map leaderIsrAndControllerEpochMap = $this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp$4, (List)Nil$.MODULE$));
        if (leaderIsrAndControllerEpochMap.contains((Object)tp$4) && $this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$4), $this.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) {
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$4)).leaderAndIsr().isr();
            List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId$1}));
            if (!(list != null ? !list.equals(list2) : list2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionDisabled$4() {
        return "failed to get expected partition state after entire isr went offline";
    }

    public static final /* synthetic */ int $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$1(KafkaServer x$22) {
        return x$22.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$3(ControllerIntegrationTest $this, TopicPartition tp$5, int otherBrokerId$2) {
        Map leaderIsrAndControllerEpochMap = $this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp$5, (List)Nil$.MODULE$));
        if (leaderIsrAndControllerEpochMap.contains((Object)tp$5) && $this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$5), $this.firstControllerEpoch(), LeaderAndIsr$.MODULE$.NoLeader(), LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1)) {
            List list = ((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$5)).leaderAndIsr().isr();
            List list2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId$2}));
            if (!(list != null ? !list.equals(list2) : list2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testLeaderAndIsrWhenEntireIsrOfflineAndUncleanLeaderElectionEnabled$4() {
        return "failed to get expected partition state after entire isr went offline";
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$3(int controllerId$15, KafkaServer p) {
        return p.config().brokerId() == controllerId$15;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$5(KafkaServer x$24) {
        return x$24.config().brokerId() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$6(KafkaServer s) {
        return s.config().brokerId() != 2;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$8(String topic$3, int partition$1, KafkaServer x$25) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$25.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$3, partition$1).get()).isr().size() != 3;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$7(ObjectRef activeServers$1, String topic$3, int partition$1) {
        return ((Seq)activeServers$1.elem).forall((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)ControllerIntegrationTest.$anonfun$testControlledShutdown$8(topic$3, partition$1, x$25)));
    }

    public static final /* synthetic */ String $anonfun$testControlledShutdown$9() {
        return "Topic test not created after timeout";
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$10(KafkaServer x$26) {
        return x$26.config().brokerId() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$11(KafkaServer s) {
        return s.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$12(String topic$3, int partition$1, KafkaServer x$27) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$27.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$3, partition$1).get()).leader() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$13(KafkaServer x$28) {
        return x$28.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControlledShutdown$14(String topic$3, int partition$1, KafkaServer x$29) {
        return ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x$29.dataPlaneRequestProcessor().metadataCache().getPartitionInfo(topic$3, partition$1).get()).leader() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$3(KafkaController controller$1, KafkaServer e) {
        return e.config().brokerId() != controller$1.config().brokerId();
    }

    public static final /* synthetic */ void $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$4(VolatileBooleanRef staleBrokerEpochDetected$1, Try x0$1) {
        if (x0$1 instanceof Failure && ((Failure)x0$1).exception() instanceof StaleBrokerEpochException) {
            staleBrokerEpochDetected$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$testControllerRejectControlledShutdownRequestWithStaleBrokerEpoch$6() {
        return "Fail to detect stale broker epoch";
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnTopicCreation$1(ControllerIntegrationTest $this, TopicPartition tp$6, Map assignment$2) {
        AdminZkClient adminZkClient = new AdminZkClient($this.zkClient());
        adminZkClient.createTopicWithAssignment(tp$6.topic(), new Properties(), assignment$2, adminZkClient.createTopicWithAssignment$default$4(), adminZkClient.createTopicWithAssignment$default$5());
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnTopicDeletion$1(ControllerIntegrationTest $this, TopicPartition tp$7) {
        new AdminZkClient($this.zkClient()).deleteTopic(tp$7.topic());
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnPreferredReplicaElection$1(ControllerIntegrationTest $this, TopicPartition tp$8) {
        $this.zkClient().createPreferredReplicaElection((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp$8})));
    }

    public static final /* synthetic */ void $anonfun$testControllerMoveOnPartitionReassignment$1(ControllerIntegrationTest $this, Map reassignment$4) {
        $this.zkClient().createPartitionReassignment(reassignment$4);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$1(KafkaController controller$2, KafkaServer e) {
        return e.config().brokerId() != controller$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$2(KafkaController controller$2) {
        ControllerState controllerState = controller$2.eventManager().state();
        ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
        return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
    }

    public static final /* synthetic */ String $anonfun$testControllerDetectsBouncedBrokers$3() {
        return "Controller event thread is still busy";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerDetectsBouncedBrokers$4(KafkaServer otherBroker$1) {
        return BoxesRunTime.unboxToInt((Object)otherBroker$1.replicaManager().partitionCount().value()) == 1 && otherBroker$1.replicaManager().metadataCache().getAllTopics().size() == 1 && otherBroker$1.replicaManager().metadataCache().getAliveBrokers().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$testControllerDetectsBouncedBrokers$5() {
        return "Broker fail to initialize after restart";
    }

    public static final /* synthetic */ boolean $anonfun$testPreemptionOnControllerShutdown$2(IntRef count$1) {
        return count$1.elem == 0;
    }

    public static final /* synthetic */ String $anonfun$testPreemptionOnControllerShutdown$3() {
        return "preemption was not fully completed before shutdown";
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$2(Tuple2 partition) {
        Either either = (Either)partition._2();
        if (either instanceof Left) {
            ApiError e = (ApiError)((Left)either).value();
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)e.error());
            return;
        }
        if (either instanceof Right) {
            throw new AssertionError((Object)"replica leader election should error");
        }
        throw new MatchError((Object)either);
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$3(Try x0$1) {
        if (x0$1 instanceof Success) {
            throw new AssertionError((Object)"controlled shutdown should error");
        }
        if (x0$1 instanceof Failure) {
            Throwable e = ((Failure)x0$1).exception();
            Assertions.assertEquals(ControllerMovedException.class, e.getClass());
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$4(Either x0$2) {
        if (x0$2 instanceof Left) {
            throw new AssertionError((Object)"api partition reassignment should error");
        }
        if (x0$2 instanceof Right) {
            ApiError e = (ApiError)((Right)x0$2).value();
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)e.error());
            return;
        }
        throw new MatchError((Object)x0$2);
    }

    public static final /* synthetic */ void $anonfun$testPreemptionWithCallbacks$5(Either x0$3) {
        if (x0$3 instanceof Left) {
            throw new AssertionError((Object)"api partition reassignment should error");
        }
        if (x0$3 instanceof Right) {
            ApiError e = (ApiError)((Right)x0$3).value();
            Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)e.error());
            return;
        }
        throw new MatchError((Object)x0$3);
    }

    public static final /* synthetic */ boolean $anonfun$testIdempotentAlterIsr$1(int controllerId$16, KafkaServer x$33) {
        return x$33.config().brokerId() != controllerId$16;
    }

    public static final /* synthetic */ void $anonfun$testIdempotentAlterIsr$2(TopicPartition tp$9, LeaderAndIsr newLeaderAndIsr$1, CountDownLatch latch$5, Either result) {
        LeaderAndIsr leaderAndIsr;
        Map partitionResults;
        if (result instanceof Left && (partitionResults = (Map)((Left)result).value()) != null) {
            Either either;
            boolean bl = false;
            Some some = null;
            Option option = partitionResults.get((Object)tp$9);
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Either either2 = (Either)some.value();
                if (either2 instanceof Left && (Errors)((Left)either2).value() != null) {
                    throw new AssertionError((Object)new StringBuilder(31).append("Should not have seen error for ").append(tp$9).toString());
                }
            }
            if (!bl || !((either = (Either)some.value()) instanceof Right) || (leaderAndIsr = (LeaderAndIsr)((Right)either).value()) == null) {
                if (None$.MODULE$.equals(option)) {
                    throw new AssertionError((Object)new StringBuilder(27).append("Should have seen ").append(tp$9).append(" in result").toString());
                }
                throw new MatchError((Object)option);
            }
        } else {
            if (result instanceof Right && ((Right)result).value() != null) {
                throw new AssertionError((Object)"Should not have had top-level error here");
            }
            throw new MatchError((Object)result);
        }
        Assertions.assertEquals((Object)leaderAndIsr, (Object)newLeaderAndIsr$1, (String)"ISR should remain unchanged");
        latch$5.countDown();
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdMigrationAndHandling$1(ControllerIntegrationTest $this, TopicPartition tp$10) {
        return ((KafkaServer)$this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp$10.topic()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdMigrationAndHandling$2() {
        return "topic ID for topic should have been removed from controller context after deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdMigrationAndHandlingWithOlderVersion$1(ControllerIntegrationTest $this, TopicPartition tp$11) {
        return !((KafkaServer)$this.servers().head()).kafkaController().controllerContext().allTopics().contains((Object)tp$11.topic());
    }

    public static final /* synthetic */ String $anonfun$testTopicIdMigrationAndHandlingWithOlderVersion$2() {
        return "topic should have been removed from controller context after deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdPersistsThroughControllerReelection$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdPersistsThroughControllerReelection$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testNoTopicIdPersistsThroughControllerReelection$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testNoTopicIdPersistsThroughControllerReelection$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdPersistsThroughControllerRestart$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdPersistsThroughControllerRestart$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdCreatedOnUpgrade$1(ControllerIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdCreatedOnUpgrade$2() {
        return "failed to elect a controller";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdCreatedOnUpgrade$3(ControllerIntegrationTest $this, TopicPartition tp$12) {
        return !((KafkaServer)$this.servers().head()).kafkaController().controllerContext().allTopics().contains((Object)tp$12.topic());
    }

    public static final /* synthetic */ String $anonfun$testTopicIdCreatedOnUpgrade$4() {
        return "topic should have been removed from controller context after deletion";
    }

    public static final /* synthetic */ void $anonfun$testTopicIdUpgradeAfterReassigningPartitions$1(Either x$34) {
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdUpgradeAfterReassigningPartitions$2(ControllerIntegrationTest $this, TopicPartition tp$13) {
        return ((KafkaServer)$this.servers().head()).kafkaController().controllerContext().topicIds().get((Object)tp$13.topic()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTopicIdUpgradeAfterReassigningPartitions$3() {
        return "topic ID for topic should have been removed from controller context after deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMove$1(KafkaController controller$3) {
        ControllerState controllerState = controller$3.eventManager().state();
        ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
        return !(controllerState != null ? !controllerState.equals(idle$) : idle$ != null);
    }

    public static final /* synthetic */ String $anonfun$testControllerMove$2() {
        return "Controller event thread is still busy";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMove$3(KafkaController controller$3) {
        return !controller$3.isActive();
    }

    public static final /* synthetic */ String $anonfun$testControllerMove$4() {
        return "Controller fails to resign";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerMove$5(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.INFO;
        if (!(level != null ? !level.equals(level2) : level2 != null)) {
            if (e.getThrowableInformation() != null && e.getThrowableInformation().getThrowable().getClass().getName().equals(ControllerMovedException.class.getName())) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$preferredReplicaLeaderElection$1(ControllerIntegrationTest $this, TopicPartition tp$14, scala.collection.immutable.Set replicas$1) {
        scala.collection.immutable.Set set = ((TraversableOnce)$this.zkClient().getInSyncReplicasForPartition(new TopicPartition(tp$14.topic(), tp$14.partition())).get()).toSet();
        return !(set != null ? !set.equals(replicas$1) : replicas$1 != null);
    }

    public static final /* synthetic */ String $anonfun$preferredReplicaLeaderElection$2() {
        return "restarted broker failed to join in-sync replicas";
    }

    public static final /* synthetic */ boolean $anonfun$preferredReplicaLeaderElection$3(ControllerIntegrationTest $this) {
        return !$this.zkClient().pathExists(PreferredReplicaElectionZNode$.MODULE$.path());
    }

    public static final /* synthetic */ String $anonfun$preferredReplicaLeaderElection$4() {
        return "failed to remove preferred replica leader election path after completion";
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilControllerEpoch$1(ControllerIntegrationTest $this, int epoch$1) {
        return $this.zkClient().getControllerEpoch().map((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToInteger((int)x$35._1$mcI$sp())).contains((Object)BoxesRunTime.boxToInteger((int)epoch$1));
    }

    public static final /* synthetic */ boolean $anonfun$waitForPartitionState$1(ControllerIntegrationTest $this, TopicPartition tp$15, int controllerEpoch$1, int leader$1, int leaderEpoch$1) {
        Map leaderIsrAndControllerEpochMap = $this.zkClient().getTopicPartitionStates((Seq)new .colon.colon((Object)tp$15, (List)Nil$.MODULE$));
        return leaderIsrAndControllerEpochMap.contains((Object)tp$15) && $this.isExpectedPartitionState((LeaderIsrAndControllerEpoch)leaderIsrAndControllerEpochMap.apply((Object)tp$15), controllerEpoch$1, leader$1, leaderEpoch$1);
    }

    public static final /* synthetic */ void $anonfun$makeServers$1(boolean autoLeaderRebalanceEnable$1, boolean uncleanLeaderElectionEnable$1, Option listeners$1, Option listenerSecurityProtocolMap$1, Option controlPlaneListenerName$1, Option interBrokerProtocolVersion$1, Properties config) {
        config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(autoLeaderRebalanceEnable$1));
        config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(uncleanLeaderElectionEnable$1));
        config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1");
        listeners$1.foreach((Function1 & Serializable & scala.Serializable)listener -> config.setProperty(KafkaConfig$.MODULE$.ListenersProp(), (String)listener));
        listenerSecurityProtocolMap$1.foreach((Function1 & Serializable & scala.Serializable)listenerMap -> config.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (String)listenerMap));
        controlPlaneListenerName$1.foreach((Function1 & Serializable & scala.Serializable)controlPlaneListener -> config.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), (String)controlPlaneListener));
        interBrokerProtocolVersion$1.foreach((Function1 & Serializable & scala.Serializable)ibp -> config.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ibp.toString()));
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getMBeanName();
        boolean bl = !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$17, KafkaServer s) {
        return s.config().brokerId() == controllerId$17;
    }
}

