/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConcurrencyTest$FetchedBatch$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t}d\u0001B\u001c9\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015Cq\u0001\u0013\u0001C\u0002\u0013%\u0011\n\u0003\u0004Q\u0001\u0001\u0006IA\u0013\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019I\u0006\u0001)A\u0005'\"9!\f\u0001b\u0001\n\u0013Y\u0006B\u00022\u0001A\u0003%A\fC\u0004d\u0001\t\u0007I\u0011\u00023\t\r5\u0004\u0001\u0015!\u0003f\u0011\u001dq\u0007A1A\u0005\n\u0011Daa\u001c\u0001!\u0002\u0013)\u0007\"\u00029\u0001\t\u0003\t\bBBA\u0003\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0002\u0010\u0001!\t!\u001d\u0005\u0007\u00033\u0001A\u0011A9\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u001e\u00191\u0011q\u0005\u0001\u0005\u0003SA\u0011\"O\t\u0003\u0002\u0003\u0006I!!\t\t\u0015\u0005\u0015\u0013C!A!\u0002\u0013\t9\u0005\u0003\u0004E#\u0011\u0005\u0011Q\n\u0005\n\u0003/\n\"\u0019!C\u0001\u00033B\u0001Ba\u0004\u0012A\u0003%\u00111\f\u0005\u0007\u0005#\tB\u0011I9\u0007\r\tM\u0001\u0001\u0002B\u000b\u0011%I\u0004D!A!\u0002\u0013\t\t\u0003\u0003\u0006\u0002Fa\u0011\t\u0011)A\u0005\u0003\u0003Ca\u0001\u0012\r\u0005\u0002\t]\u0001B\u0002B\t1\u0011\u0005\u0013\u000fC\u0004\u0003 \u0001!IA!\t\t\u0013\t5\u0002!%A\u0005\n\t=\u0002b\u0002B\u001a\u0001\u0011%!Q\u0007\u0004\u0007\u0003[\u0002A)a\u001c\t\u0015\u0005u\u0004E!f\u0001\n\u0003\ty\b\u0003\u0006\u0002\b\u0002\u0012\t\u0012)A\u0005\u0003\u0003C!\"!#!\u0005+\u0007I\u0011AAF\u0011)\ti\t\tB\tB\u0003%\u0011q\t\u0005\u0007\t\u0002\"\t!a$\t\u000f\u0005U\u0005\u0005\"\u0011\u0002\u0018\"I\u0011q\u0016\u0011\u0002\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003o\u0003\u0013\u0013!C\u0001\u0003sC\u0011\"a4!#\u0003%\t!!5\t\u0013\u0005U\u0007%!A\u0005B\u0005]\u0007\"CAoA\u0005\u0005I\u0011AAF\u0011%\ty\u000eIA\u0001\n\u0003\t\t\u000fC\u0005\u0002n\u0002\n\t\u0011\"\u0011\u0002p\"I\u0011\u0011 \u0011\u0002\u0002\u0013\u0005\u00111 \u0005\n\u0005\u000b\u0001\u0013\u0011!C!\u0005\u000fA\u0011B!\u0003!\u0003\u0003%\tEa\u0003\b\u0013\t5\u0003!!A\t\n\t=c!CA7\u0001\u0005\u0005\t\u0012\u0002B)\u0011\u0019!%\u0007\"\u0001\u0003`!I\u0011Q\u0013\u001a\u0002\u0002\u0013\u0015#\u0011\r\u0005\n\u0005G\u0012\u0014\u0011!CA\u0005KB\u0011Ba\u001b3\u0003\u0003%\tI!\u001c\u0003%1{wmQ8oGV\u0014(/\u001a8dsR+7\u000f\u001e\u0006\u0003si\n1\u0001\\8h\u0015\u0005Y\u0014!B6bM.\f7\u0001A\n\u0003\u0001y\u0002\"a\u0010\"\u000e\u0003\u0001S\u0011!Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0007\u0002\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001G!\t9\u0005!D\u00019\u0003A\u0011'o\\6feR{\u0007/[2Ti\u0006$8/F\u0001K!\tYe*D\u0001M\u0015\ti%(\u0001\u0004tKJ4XM]\u0005\u0003\u001f2\u0013\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0002#\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001c\b%\u0001\u0004sC:$w.\\\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011a\u000bQ\u0001\u0005kRLG.\u0003\u0002Y+\n1!+\u00198e_6\fqA]1oI>l\u0007%A\u0005tG\",G-\u001e7feV\tA\f\u0005\u0002^A6\taL\u0003\u0002`u\u0005)Q\u000f^5mg&\u0011\u0011M\u0018\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0007i6\u0004H)\u001b:\u0016\u0003\u0015\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\u0005%|'\"\u00016\u0002\t)\fg/Y\u0005\u0003Y\u001e\u0014AAR5mK\u00069A/\u001c9ESJ\u0004\u0013A\u00027pO\u0012K'/A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u000bM,G/\u001e9\u0015\u0003I\u0004\"aP:\n\u0005Q\u0004%\u0001B+oSRD#\u0001\u0004<\u0011\u0007]\f\t!D\u0001y\u0015\tI(0A\u0002ba&T!a\u001f?\u0002\u000f),\b/\u001b;fe*\u0011QP`\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u007f\u0006\u0019qN]4\n\u0007\u0005\r\u0001P\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001b\u001d5vi\u0012|wO\u001c\u0015\u0004\u001b\u0005%\u0001cA<\u0002\f%\u0019\u0011Q\u0002=\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\b;fgR,fnY8n[&$H/\u001a3ECR\fgj\u001c;D_:\u001cX/\\3eQ\rq\u00111\u0003\t\u0004o\u0006U\u0011bAA\fq\n!A+Z:u\u0003I\"Xm\u001d;V]\u000e|W.\\5ui\u0016$G)\u0019;b\u001d>$8i\u001c8tk6,GM\u0012:fcV,g\u000e^*fO6,g\u000e\u001e*pY2\u001c\bfA\b\u0002\u0014Q\u0019!/a\b\t\re\u0002\u0002\u0019AA\u0011!\r9\u00151E\u0005\u0004\u0003KA$a\u0001'pO\na1i\u001c8tk6,'\u000fV1tWN)\u0011#a\u000b\u00028A!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022%\fA\u0001\\1oO&!\u0011QGA\u0018\u0005\u0019y%M[3diB)\u0011\u0011HA!e6\u0011\u00111\b\u0006\u0005\u0003{\ty$\u0001\u0006d_:\u001cWO\u001d:f]RT!AV5\n\t\u0005\r\u00131\b\u0002\t\u0007\u0006dG.\u00192mK\u0006QA.Y:u\u001f\u001a47/\u001a;\u0011\u0007}\nI%C\u0002\u0002L\u0001\u00131!\u00138u)\u0019\ty%a\u0015\u0002VA\u0019\u0011\u0011K\t\u000e\u0003\u0001Aa!\u000f\u000bA\u0002\u0005\u0005\u0002bBA#)\u0001\u0007\u0011qI\u0001\u0010G>t7/^7fI\n\u000bGo\u00195fgV\u0011\u00111\f\t\u0007\u0003;\n9'a\u001b\u000e\u0005\u0005}#\u0002BA1\u0003G\nq!\\;uC\ndWMC\u0002\u0002f\u0001\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI'a\u0018\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000fE\u0002\u0002R\u0001\u0012ABR3uG\",GMQ1uG\"\u001cb\u0001\t \u0002r\u0005]\u0004cA \u0002t%\u0019\u0011Q\u000f!\u0003\u000fA\u0013x\u000eZ;diB\u0019q(!\u001f\n\u0007\u0005m\u0004I\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0006cCN,wJ\u001a4tKR,\"!!!\u0011\u0007}\n\u0019)C\u0002\u0002\u0006\u0002\u0013A\u0001T8oO\u0006Y!-Y:f\u001f\u001a47/\u001a;!\u0003\u0015)\u0007o\\2i+\t\t9%\u0001\u0004fa>\u001c\u0007\u000e\t\u000b\u0007\u0003W\n\t*a%\t\u000f\u0005uT\u00051\u0001\u0002\u0002\"9\u0011\u0011R\u0013A\u0002\u0005\u001d\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0005\u0003BAN\u0003SsA!!(\u0002&B\u0019\u0011q\u0014!\u000e\u0005\u0005\u0005&bAARy\u00051AH]8pizJ1!a*A\u0003\u0019\u0001&/\u001a3fM&!\u00111VAW\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0015!\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003W\n\u0019,!.\t\u0013\u0005ut\u0005%AA\u0002\u0005\u0005\u0005\"CAEOA\u0005\t\u0019AA$\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a/+\t\u0005\u0005\u0015QX\u0016\u0003\u0003\u007f\u0003B!!1\u0002L6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u001a!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002N\u0006\r'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAjU\u0011\t9%!0\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u000e\u0005\u0003\u0002.\u0005m\u0017\u0002BAV\u0003_\tA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002d\u0006%\bcA \u0002f&\u0019\u0011q\u001d!\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002l2\n\t\u00111\u0001\u0002H\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!=\u0011\r\u0005M\u0018Q_Ar\u001b\t\t\u0019'\u0003\u0003\u0002x\u0006\r$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!@\u0003\u0004A\u0019q(a@\n\u0007\t\u0005\u0001IA\u0004C_>dW-\u00198\t\u0013\u0005-h&!AA\u0002\u0005\r\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u001d\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002~\n5\u0001\"CAva\u0005\u0005\t\u0019AAr\u0003A\u0019wN\\:v[\u0016$')\u0019;dQ\u0016\u001c\b%\u0001\u0003dC2d'!\u0004'pO\u0006\u0003\b/\u001a8e)\u0006\u001c8nE\u0003\u0019\u0003W\t9\u0004\u0006\u0004\u0003\u001a\tm!Q\u0004\t\u0004\u0003#B\u0002BB\u001d\u001c\u0001\u0004\t\t\u0003C\u0004\u0002Fm\u0001\r!!!\u0002\u0013\r\u0014X-\u0019;f\u0019><G\u0003BA\u0011\u0005GA\u0011B!\n\u001e!\u0003\u0005\rAa\n\u0002\r\r|gNZ5h!\r9%\u0011F\u0005\u0004\u0005WA$!\u0003'pO\u000e{gNZ5h\u0003M\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\tD\u000b\u0003\u0003(\u0005u\u0016\u0001\u0006<bY&$\u0017\r^3D_:\u001cX/\\3e\t\u0006$\u0018\rF\u0003s\u0005o\u0011I\u0004\u0003\u0004:?\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003/z\u0002\u0019\u0001B\u001e!\u0019\u0011iDa\u0012\u0002l9!!q\bB\"\u001d\u0011\tyJ!\u0011\n\u0003\u0005K1A!\u0012A\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0013\u0003L\tA\u0011\n^3sC\ndWMC\u0002\u0003F\u0001\u000bABR3uG\",GMQ1uG\"\u00042!!\u00153'\u0015\u0011$1KA<!)\u0011)Fa\u0017\u0002\u0002\u0006\u001d\u00131N\u0007\u0003\u0005/R1A!\u0017A\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0018\u0003X\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\t=CCAAm\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\tYGa\u001a\u0003j!9\u0011QP\u001bA\u0002\u0005\u0005\u0005bBAEk\u0001\u0007\u0011qI\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yGa\u001f\u0011\u000b}\u0012\tH!\u001e\n\u0007\tM\u0004I\u0001\u0004PaRLwN\u001c\t\b\u007f\t]\u0014\u0011QA$\u0013\r\u0011I\b\u0011\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\tud'!AA\u0002\u0005-\u0014a\u0001=%a\u0001")
public class LogConcurrencyTest {
    private volatile LogConcurrencyTest$FetchedBatch$ FetchedBatch$module;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Random kafka$log$LogConcurrencyTest$$random = new Random();
    private final KafkaScheduler scheduler = new KafkaScheduler(1, KafkaScheduler$.MODULE$.$lessinit$greater$default$2(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());

    private LogConcurrencyTest$FetchedBatch$ FetchedBatch() {
        if (this.FetchedBatch$module == null) {
            this.FetchedBatch$lzycompute$1();
        }
        return this.FetchedBatch$module;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Random kafka$log$LogConcurrencyTest$$random() {
        return this.kafka$log$LogConcurrencyTest$$random;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File tmpDir() {
        return this.tmpDir;
    }

    private File logDir() {
        return this.logDir;
    }

    @BeforeEach
    public void setup() {
        this.scheduler().startup();
    }

    @AfterEach
    public void shutdown() {
        this.scheduler().shutdown();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testUncommittedDataNotConsumed() {
        this.testUncommittedDataNotConsumed(this.createLog(this.createLog$default$1()));
    }

    @Test
    public void testUncommittedDataNotConsumedFrequentSegmentRolls() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(237));
        LogConfig logConfig = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        this.testUncommittedDataNotConsumed(this.createLog(logConfig));
    }

    public void testUncommittedDataNotConsumed(Log log) {
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            int maxOffset = 5000;
            ConsumerTask consumer = new ConsumerTask(this, log, maxOffset);
            LogAppendTask appendTask = new LogAppendTask(this, log, maxOffset);
            Future<BoxedUnit> consumerFuture = executor.submit(consumer);
            executor.submit(appendTask).get();
            consumerFuture.get();
            this.validateConsumedData(log, (Iterable<FetchedBatch>)consumer.consumedBatches());
        }
        finally {
            executor.shutdownNow();
        }
    }

    private Log createLog(LogConfig config) {
        return Log$.MODULE$.apply(this.logDir(), config, 0L, 0L, (Scheduler)this.scheduler(), this.brokerTopicStats(), Time.SYSTEM, 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(10), Log$.MODULE$.apply$default$11(), Log$.MODULE$.apply$default$12());
    }

    private LogConfig createLog$default$1() {
        return new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
    }

    private void validateConsumedData(Log log, Iterable<FetchedBatch> consumedBatches) {
        Iterator iter = consumedBatches.iterator();
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogConcurrencyTest.$anonfun$validateConsumedData$1(iter, segment);
            return BoxedUnit.UNIT;
        });
    }

    private final void FetchedBatch$lzycompute$1() {
        synchronized (this) {
            if (this.FetchedBatch$module == null) {
                this.FetchedBatch$module = new LogConcurrencyTest$FetchedBatch$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$validateConsumedData$1(Iterator iter$1, LogSegment segment) {
        segment.log().batches().forEach(batch -> {
            if (iter$1.hasNext()) {
                FetchedBatch consumedBatch = (FetchedBatch)iter$1.next();
                try {
                    Assertions.assertEquals((int)batch.partitionLeaderEpoch(), (int)consumedBatch.epoch(), (String)"Consumed batch with unexpected leader epoch");
                    Assertions.assertEquals((long)batch.baseOffset(), (long)consumedBatch.baseOffset(), (String)"Consumed batch with unexpected base offset");
                    return;
                }
                catch (Throwable t) {
                    throw new AssertionError(new StringBuilder(58).append("Consumed batch ").append(consumedBatch).append(" ").append("does not match next expected batch in log ").append(batch).toString(), t);
                }
            }
        });
    }

    private class ConsumerTask
    implements Callable<BoxedUnit> {
        private final Log log;
        private final int lastOffset;
        private final ListBuffer<FetchedBatch> consumedBatches;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public ListBuffer<FetchedBatch> consumedBatches() {
            return this.consumedBatches;
        }

        @Override
        public void call() {
            LongRef fetchOffset = LongRef.create((long)0L);
            while (this.log.highWatermark() < (long)this.lastOffset) {
                this.log.read(fetchOffset.elem, 1, (FetchIsolation)FetchHighWatermark$.MODULE$, true).records().batches().forEach(batch -> {
                    this.consumedBatches().$plus$eq((Object)new FetchedBatch(this.kafka$log$LogConcurrencyTest$ConsumerTask$$$outer(), batch.baseOffset(), batch.partitionLeaderEpoch()));
                    fetchOffset$1.elem = batch.lastOffset() + 1L;
                });
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$ConsumerTask$$$outer() {
            return this.$outer;
        }

        public ConsumerTask(LogConcurrencyTest $outer, Log log, int lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.consumedBatches = (ListBuffer)ListBuffer$.MODULE$.empty();
        }
    }

    private class FetchedBatch
    implements Product,
    scala.Serializable {
        private final long baseOffset;
        private final int epoch;
        public final /* synthetic */ LogConcurrencyTest $outer;

        public long baseOffset() {
            return this.baseOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        public String toString() {
            return new StringBuilder(33).append("FetchedBatch(baseOffset=").append(this.baseOffset()).append(", epoch=").append(this.epoch()).append(")").toString();
        }

        public FetchedBatch copy(long baseOffset, int epoch) {
            return new FetchedBatch(this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer(), baseOffset, epoch);
        }

        public long copy$default$1() {
            return this.baseOffset();
        }

        public int copy$default$2() {
            return this.epoch();
        }

        public String productPrefix() {
            return "FetchedBatch";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.baseOffset());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.epoch());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FetchedBatch;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.baseOffset())), (int)this.epoch()), (int)2);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof FetchedBatch && ((FetchedBatch)x$1).kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() == this.kafka$log$LogConcurrencyTest$FetchedBatch$$$outer();
                    if (!bl) break block3;
                    FetchedBatch fetchedBatch = (FetchedBatch)x$1;
                    if (!(this.baseOffset() == fetchedBatch.baseOffset() && this.epoch() == fetchedBatch.epoch() && fetchedBatch.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$FetchedBatch$$$outer() {
            return this.$outer;
        }

        public FetchedBatch(LogConcurrencyTest $outer, long baseOffset, int epoch) {
            this.baseOffset = baseOffset;
            this.epoch = epoch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class LogAppendTask
    implements Callable<BoxedUnit> {
        private final Log log;
        private final long lastOffset;
        public final /* synthetic */ LogConcurrencyTest $outer;

        @Override
        public void call() {
            int leaderEpoch = 1;
            boolean isLeader = true;
            block4: while (this.log.highWatermark() < this.lastOffset) {
                int n = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(2);
                switch (n) {
                    case 0: {
                        LogOffsetMetadata logEndOffsetMetadata = this.log.logEndOffsetMetadata();
                        long logEndOffset = logEndOffsetMetadata.messageOffset();
                        int batchSize = this.kafka$log$LogConcurrencyTest$LogAppendTask$$$outer().kafka$log$LogConcurrencyTest$$random().nextInt(9) + 1;
                        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), batchSize).map((Function1 & Serializable & scala.Serializable)i -> LogAppendTask.$anonfun$call$2(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                        if (isLeader) {
                            this.log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), leaderEpoch, this.log.appendAsLeader$default$3(), this.log.appendAsLeader$default$4());
                            this.log.maybeIncrementHighWatermark(logEndOffsetMetadata);
                            continue block4;
                        }
                        byte x$4 = TestUtils$.MODULE$.records$default$2();
                        CompressionType x$5 = TestUtils$.MODULE$.records$default$3();
                        long x$6 = TestUtils$.MODULE$.records$default$4();
                        short x$7 = TestUtils$.MODULE$.records$default$5();
                        int x$8 = TestUtils$.MODULE$.records$default$6();
                        this.log.appendAsFollower(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, x$4, x$5, x$6, x$7, x$8, logEndOffset, leaderEpoch));
                        this.log.updateHighWatermark(logEndOffset);
                        continue block4;
                    }
                    case 1: {
                        isLeader = !isLeader;
                        ++leaderEpoch;
                        if (isLeader) continue block4;
                        this.log.truncateTo(this.log.highWatermark());
                        continue block4;
                    }
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }

        public /* synthetic */ LogConcurrencyTest kafka$log$LogConcurrencyTest$LogAppendTask$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ SimpleRecord $anonfun$call$2(int i) {
            return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
        }

        public LogAppendTask(LogConcurrencyTest $outer, Log log, long lastOffset) {
            this.log = log;
            this.lastOffset = lastOffset;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

