/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson$;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.DescribeAclsRequestData;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.RequestHeaderDataJsonConverter;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterIsrRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3AAC\u0006\u0001!!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)Q\u0006\u0001C\u00019!)q\u0006\u0001C\u00019!)\u0011\u0007\u0001C\u00019!)1\u0007\u0001C\u00019!)Q\u0007\u0001C\u00019!)q\u0007\u0001C\u0001q!)Q\n\u0001C\u0005\u001d\nA\"+Z9vKN$8i\u001c8wKJ$Hk\u001c&t_:$Vm\u001d;\u000b\u00051i\u0011a\u00028fi^|'o\u001b\u0006\u0002\u001d\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0012!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011aC\u0001\u001bi\u0016\u001cH/\u00117m%\u0016\fX/Z:u)f\u0004Xm\u001d%b]\u0012dW\r\u001a\u000b\u0002;A\u0011!CH\u0005\u0003?M\u0011A!\u00168ji\"\u0012!!\t\t\u0003E-j\u0011a\t\u0006\u0003I\u0015\n1!\u00199j\u0015\t1s%A\u0004kkBLG/\u001a:\u000b\u0005!J\u0013!\u00026v]&$(\"\u0001\u0016\u0002\u0007=\u0014x-\u0003\u0002-G\t!A+Z:u\u0003m!Xm\u001d;BY2\u0014Vm\u001d9p]N,G+\u001f9fg\"\u000bg\u000e\u001a7fI\"\u00121!I\u0001\u0016i\u0016\u001cHOU3rk\u0016\u001cH\u000fS3bI\u0016\u0014hj\u001c3fQ\t!\u0011%\u0001\nuKN$8\t\\5f]RLeNZ8O_\u0012,\u0007FA\u0003\"\u0003=!Xm\u001d;SKF,Xm\u001d;EKN\u001c\u0007F\u0001\u0004\"\u0003Y!Xm\u001d;SKF,Xm\u001d;EKN\u001cW*\u001a;sS\u000e\u001c\bFA\u0004\"\u0003\u001d\u0011X-];fgR$\"!\u000f!\u0011\u0005ijdB\u0001\u000e<\u0013\ta4\"\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005yz$a\u0002*fcV,7\u000f\u001e\u0006\u0003y-AQ!\u0011\u0005A\u0002\t\u000b1A]3r!\t\u00195*D\u0001E\u0015\t)e)\u0001\u0005sKF,Xm\u001d;t\u0015\t9\u0005*\u0001\u0004d_6lwN\u001c\u0006\u0003\u001d%S!AS\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0013\taEIA\bBEN$(/Y2u%\u0016\fX/Z:u\u0003EqWm\u001e*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u000b\u0003\u001fJ\u0003\"a\u0011)\n\u0005E#%A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0005\u0006'&\u0001\r\u0001V\u0001\u0007EV4g-\u001a:\u0011\u0005USV\"\u0001,\u000b\u0005]C\u0016a\u00018j_*\t\u0011,\u0001\u0003kCZ\f\u0017BA.W\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d")
public class RequestConvertToJsonTest {
    @Test
    public void testAllRequestTypesHandled() {
        ArrayBuffer unhandledKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values())).foreach((Function1 & Serializable & scala.Serializable)key -> {
            short version = key.latestVersion();
            ObjectSerializationCache cache = new ObjectSerializationCache();
            Object object = ApiKeys.DESCRIBE_ACLS.equals(key) ? ((DescribeAclsRequestData)ApiMessageType.fromApiKey((short)key.id).newRequest()).setPatternTypeFilter((byte)1).setResourceTypeFilter((byte)1).setPermissionType((byte)1).setOperation((byte)1) : ApiMessageType.fromApiKey((short)key.id).newRequest();
            int messageSize = object.size(cache, version);
            ByteBufferAccessor bytes = new ByteBufferAccessor(ByteBuffer.allocate(messageSize));
            object.write((Writable)bytes, cache, version);
            bytes.flip();
            AbstractRequest req = AbstractRequest.parseRequest((ApiKeys)key, (short)version, (ByteBuffer)bytes.buffer()).request;
            try {
                return RequestConvertToJson$.MODULE$.request(req);
            }
            catch (IllegalStateException illegalStateException) {
                return unhandledKeys.$plus$eq((Object)key.toString());
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledKeys, (String)"Unhandled request keys");
    }

    @Test
    public void testAllResponseTypesHandled() {
        ArrayBuffer unhandledKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ApiKeys.values())).foreach((Function1 & Serializable & scala.Serializable)key -> {
            short version = key.latestVersion();
            ObjectSerializationCache cache = new ObjectSerializationCache();
            ApiMessage message = ApiMessageType.fromApiKey((short)key.id).newResponse();
            int messageSize = message.size(cache, version);
            ByteBufferAccessor bytes = new ByteBufferAccessor(ByteBuffer.allocate(messageSize));
            message.write((Writable)bytes, cache, version);
            bytes.flip();
            AbstractResponse res = AbstractResponse.parseResponse((ApiKeys)key, (ByteBuffer)bytes.buffer(), (short)version);
            try {
                return RequestConvertToJson$.MODULE$.response(res, version);
            }
            catch (IllegalStateException illegalStateException) {
                return unhandledKeys.$plus$eq((Object)key.toString());
            }
        });
        Assertions.assertEquals((Object)ArrayBuffer$.MODULE$.empty(), (Object)unhandledKeys, (String)"Unhandled response keys");
    }

    @Test
    public void testRequestHeaderNode() {
        AlterIsrRequest alterIsrRequest = new AlterIsrRequest(new AlterIsrRequestData(), 0);
        RequestHeader header = this.request((AbstractRequest)alterIsrRequest).header();
        ObjectNode expectedNode = (ObjectNode)RequestHeaderDataJsonConverter.write((RequestHeaderData)header.data(), (short)header.headerVersion(), (boolean)false);
        expectedNode.set("requestApiKeyName", (JsonNode)new TextNode(header.apiKey().toString()));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestHeaderNode(header);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testClientInfoNode() {
        ClientInformation clientInfo = new ClientInformation("name", "1");
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("softwareName", (JsonNode)new TextNode(clientInfo.softwareName()));
        expectedNode.set("softwareVersion", (JsonNode)new TextNode(clientInfo.softwareVersion()));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.clientInfoNode(clientInfo);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDesc() {
        AlterIsrRequest alterIsrRequest = new AlterIsrRequest(new AlterIsrRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        ObjectNode expectedNode = new ObjectNode(JsonNodeFactory.instance);
        expectedNode.set("isForwarded", (JsonNode)(req.isForwarded() ? BooleanNode.TRUE : BooleanNode.FALSE));
        expectedNode.set("requestHeader", RequestConvertToJson$.MODULE$.requestHeaderNode(req.header()));
        expectedNode.set("request", (JsonNode)req.requestLog().getOrElse((Function0 & Serializable & scala.Serializable)() -> new TextNode("")));
        JsonNode actualNode = RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    @Test
    public void testRequestDescMetrics() {
        AlterIsrRequest alterIsrRequest = new AlterIsrRequest(new AlterIsrRequestData(), 0);
        RequestChannel.Request req = this.request((AbstractRequest)alterIsrRequest);
        NetworkSend send = new NetworkSend(req.context().connectionId, alterIsrRequest.toSend(req.header()));
        JsonNode headerLog = RequestConvertToJson$.MODULE$.requestHeaderNode(req.header());
        RequestChannel.SendResponse res = new RequestChannel.SendResponse(req, (Send)send, (Option)new Some((Object)headerLog), (Option)None$.MODULE$);
        boolean totalTimeMs = true;
        int requestQueueTimeMs = 2;
        int apiLocalTimeMs = 3;
        int apiRemoteTimeMs = 4;
        int apiThrottleTimeMs = 5;
        int responseQueueTimeMs = 6;
        int responseSendTimeMs = 7;
        int temporaryMemoryBytes = 8;
        int messageConversionsTimeMs = 9;
        ObjectNode expectedNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDesc(req.header(), req.requestLog(), req.isForwarded());
        expectedNode.set("response", (JsonNode)res.responseLog().getOrElse((Function0 & Serializable & scala.Serializable)() -> new TextNode("")));
        expectedNode.set("connection", (JsonNode)new TextNode(req.context().connectionId));
        expectedNode.set("totalTimeMs", (JsonNode)new DoubleNode((double)totalTimeMs));
        expectedNode.set("requestQueueTimeMs", (JsonNode)new DoubleNode((double)requestQueueTimeMs));
        expectedNode.set("localTimeMs", (JsonNode)new DoubleNode((double)apiLocalTimeMs));
        expectedNode.set("remoteTimeMs", (JsonNode)new DoubleNode((double)apiRemoteTimeMs));
        expectedNode.set("throttleTimeMs", (JsonNode)new LongNode((long)apiThrottleTimeMs));
        expectedNode.set("responseQueueTimeMs", (JsonNode)new DoubleNode((double)responseQueueTimeMs));
        expectedNode.set("sendTimeMs", (JsonNode)new DoubleNode((double)responseSendTimeMs));
        expectedNode.set("securityProtocol", (JsonNode)new TextNode(req.context().securityProtocol.toString()));
        expectedNode.set("principal", (JsonNode)new TextNode(req.session().principal().toString()));
        expectedNode.set("listener", (JsonNode)new TextNode(req.context().listenerName.value()));
        expectedNode.set("clientInformation", RequestConvertToJson$.MODULE$.clientInfoNode(req.context().clientInformation));
        expectedNode.set("temporaryMemoryBytes", (JsonNode)new LongNode((long)temporaryMemoryBytes));
        expectedNode.set("messageConversionsTime", (JsonNode)new DoubleNode((double)messageConversionsTimeMs));
        ObjectNode actualNode = (ObjectNode)RequestConvertToJson$.MODULE$.requestDescMetrics(req.header(), req.requestLog(), res.responseLog(), req.context(), req.session(), req.isForwarded(), (double)totalTimeMs, (double)requestQueueTimeMs, (double)apiLocalTimeMs, (double)apiRemoteTimeMs, (long)apiThrottleTimeMs, (double)responseQueueTimeMs, (double)responseSendTimeMs, (long)temporaryMemoryBytes, (double)messageConversionsTimeMs);
        Assertions.assertEquals((Object)expectedNode, (Object)actualNode);
    }

    public RequestChannel.Request request(AbstractRequest req) {
        ByteBuffer buffer = RequestTestUtils.serializeRequestWithHeader((RequestHeader)new RequestHeader(req.apiKey(), req.version(), "client-id", 1), (AbstractRequest)req);
        RequestContext requestContext = this.newRequestContext(buffer);
        return new RequestChannel.Request(1, requestContext, 0L, (MemoryPool)EasyMock.createNiceMock(MemoryPool.class), buffer, (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class), RequestChannel.Request$.MODULE$.$lessinit$greater$default$7());
    }

    private RequestContext newRequestContext(ByteBuffer buffer) {
        return new RequestContext(RequestHeader.parse((ByteBuffer)buffer), "connection-id", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, new ClientInformation("name", "version"), false);
    }
}

