/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import integration.kafka.server.IntegrationTestUtils$;
import java.io.Serializable;
import java.net.Socket;
import java.util.Collection;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterInstance;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import scala.Function1;
import scala.Predef;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3Q\u0001C\u0005\u0002\u00029A\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IA\u0006\u0005\u00069\u0001!\t!\b\u0005\u0006C\u0001!\tA\t\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\u0006\u001d\u0002!\ta\u0014\u0005\u0006#\u0002!\tA\u0015\u0002\u001f\u0003\n\u001cHO]1di\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgRT!AC\u0006\u0002\rM,'O^3s\u0015\u0005a\u0011!B6bM.\f7\u0001A\n\u0003\u0001=\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0017aB2mkN$XM\u001d\t\u0003/ii\u0011\u0001\u0007\u0006\u00033-\tA\u0001^3ti&\u00111\u0004\u0007\u0002\u0010\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK\u00061A(\u001b8jiz\"\"A\b\u0011\u0011\u0005}\u0001Q\"A\u0005\t\u000bU\u0011\u0001\u0019\u0001\f\u0002-M,g\u000eZ!qSZ+'o]5p]N\u0014V-];fgR$2a\t\u00196!\t!c&D\u0001&\u0015\t1s%\u0001\u0005sKF,Xm\u001d;t\u0015\tA\u0013&\u0001\u0004d_6lwN\u001c\u0006\u0003\u0019)R!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sO&\u0011q&\n\u0002\u0014\u0003BLg+\u001a:tS>t7OU3ta>t7/\u001a\u0005\u0006c\r\u0001\rAM\u0001\be\u0016\fX/Z:u!\t!3'\u0003\u00025K\t\u0011\u0012\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u\u0011\u001514\u00011\u00018\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\tA4(D\u0001:\u0015\tQt%A\u0004oKR<xN]6\n\u0005qJ$\u0001\u0004'jgR,g.\u001a:OC6,\u0017\u0001G2p]R\u0014x\u000e\u001c)mC:,G*[:uK:,'OT1nKV\tq'A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011\u0011\t\u0012\t\u0003!\tK!aQ\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u000b\u0016\u0001\rAR\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bCA$M\u001b\u0005A%BA%K\u0003\u0011)H/\u001b7\u000b\u0003-\u000bAA[1wC&\u0011Q\n\u0013\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001I:f]\u0012,fn];qa>\u0014H/\u001a3Ba&4VM]:j_:\u0014V-];fgR$\"a\t)\t\u000bE2\u0001\u0019\u0001\u001a\u00027Y\fG.\u001b3bi\u0016\f\u0005/\u001b,feNLwN\\:SKN\u0004xN\\:f)\t\t5\u000bC\u0003U\u000f\u0001\u00071%A\nba&4VM]:j_:\u001c(+Z:q_:\u001cX\r")
public abstract class AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    public ApiVersionsResponse sendApiVersionsRequest(ApiVersionsRequest request, ListenerName listenerName) {
        return (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, (SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head(), listenerName, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public ListenerName controlPlaneListenerName() {
        return new ListenerName("CONTROLLER");
    }

    public void brokerPropertyOverrides(Properties properties) {
        SecurityProtocol securityProtocol = this.cluster.config().securityProtocol();
        properties.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), this.controlPlaneListenerName().value());
        properties.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(3).append(this.controlPlaneListenerName().value()).append(":").append(securityProtocol).append(",").append(securityProtocol).append(":").append(securityProtocol).toString());
        properties.setProperty("listeners", new StringBuilder(29).append(securityProtocol).append("://localhost:0,").append(this.controlPlaneListenerName().value()).append("://localhost:0").toString());
        properties.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(29).append(securityProtocol).append("://localhost:0,").append(this.controlPlaneListenerName().value()).append("://localhost:0").toString());
    }

    public ApiVersionsResponse sendUnsupportedApiVersionRequest(ApiVersionsRequest request) {
        ApiVersionsResponse apiVersionsResponse;
        RequestHeader overrideHeader = IntegrationTestUtils$.MODULE$.nextRequestHeader(ApiKeys.API_VERSIONS, (short)Short.MAX_VALUE, IntegrationTestUtils$.MODULE$.nextRequestHeader$default$3(), IntegrationTestUtils$.MODULE$.nextRequestHeader$default$4());
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head(), this.cluster.clientListener());){
            IntegrationTestUtils$.MODULE$.sendWithHeader((AbstractRequest)request, overrideHeader, socket);
            apiVersionsResponse = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.receive(socket, ApiKeys.API_VERSIONS, (short)0, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        }
        return apiVersionsResponse;
    }

    public void validateApiVersionsResponse(ApiVersionsResponse apiVersionsResponse) {
        Assertions.assertEquals((int)ApiKeys.zkBrokerApis().size(), (int)apiVersionsResponse.data().apiKeys().size(), (String)"API keys in ApiVersionsResponse must match API keys supported by broker.");
        ApiVersionsResponse defaultApiVersionsResponse = ApiVersionsResponse.defaultApiVersionsResponse((ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER);
        ((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)defaultApiVersionsResponse.data().apiKeys()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)expectedApiVersion -> {
            AbstractApiVersionsRequestTest.$anonfun$validateApiVersionsResponse$2(apiVersionsResponse, expectedApiVersion);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$validateApiVersionsResponse$2(ApiVersionsResponse apiVersionsResponse$1, ApiVersionsResponseData.ApiVersion expectedApiVersion) {
        ApiVersionsResponseData.ApiVersion actualApiVersion = apiVersionsResponse$1.apiVersion(expectedApiVersion.apiKey());
        Assertions.assertNotNull((Object)actualApiVersion, (String)new StringBuilder(73).append("API key ").append(actualApiVersion.apiKey()).append(" is supported by broker, but not received in ApiVersionsResponse.").toString());
        Assertions.assertEquals((short)expectedApiVersion.apiKey(), (short)actualApiVersion.apiKey(), (String)"API key must be supported by the broker.");
        Assertions.assertEquals((short)expectedApiVersion.minVersion(), (short)actualApiVersion.minVersion(), (String)new StringBuilder(45).append("Received unexpected min version for API key ").append(actualApiVersion.apiKey()).append(".").toString());
        Assertions.assertEquals((short)expectedApiVersion.maxVersion(), (short)actualApiVersion.maxVersion(), (String)new StringBuilder(45).append("Received unexpected max version for API key ").append(actualApiVersion.apiKey()).append(".").toString());
    }

    public AbstractApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

