/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaServer;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterBrokerReplicaExclusionsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.ExclusionOp;
import org.apache.kafka.clients.admin.ExclusionOpResult;
import org.apache.kafka.clients.admin.ExclusionOperationError;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidBrokerReplicaExclusionException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.UnrepresentableBrokerIdException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Matchers$;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001\u0002\u000e\u001c\u0001\tBQ!\u000b\u0001\u0005\u0002)BQ!\f\u0001\u0005R9Bq!\u000e\u0001A\u0002\u0013\u0005a\u0007C\u0004E\u0001\u0001\u0007I\u0011A#\t\r-\u0003\u0001\u0015)\u00038\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015A\u0006\u0001\"\u0001N\u0011\u0015i\u0006\u0001\"\u0001N\u0011\u0015y\u0006\u0001\"\u0001N\u0011\u0015\t\u0007\u0001\"\u0001N\u0011\u0015\u0019\u0007\u0001\"\u0001N\u0011\u0015)\u0007\u0001\"\u0001N\u0011\u00159\u0007\u0001\"\u0001i\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007Bq!a \u0001\t\u0013\t\t\tC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002H\"9\u0011Q\u0019\u0001\u0005\u0002\u0005U\u0007bBAF\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0003W\u0004A\u0011AAw\u0011\u001d\t)\u0010\u0001C\u0001\u0003oDq!!>\u0001\t\u0003\u0011\u0019\u0001C\u0004\u0003\u0014\u0001!IA!\u0006\t\u000f\tU\u0002\u0001\"\u0001\u00038!9!\u0011\n\u0001\u0005\n\t-#a\b*fa2L7-Y#yG2,8/[8o\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011A$H\u0001\u0004CBL'B\u0001\u0010 \u0003\u0015Y\u0017MZ6b\u0015\u0005\u0001\u0013aC5oi\u0016<'/\u0019;j_:\u001c\u0001a\u0005\u0002\u0001GA\u0011AeJ\u0007\u0002K)\u0011AD\n\u0006\u0002=%\u0011\u0001&\n\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012a\u000b\t\u0003Y\u0001i\u0011aG\u0001\fEJ|7.\u001a:D_VtG/F\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\rIe\u000e^\u0001\fC\u0012l\u0017N\\\"mS\u0016tG/F\u00018!\tA$)D\u0001:\u0015\tQ4(A\u0003bI6LgN\u0003\u0002={\u000591\r\\5f]R\u001c(B\u0001\u0010?\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rK$AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0010C\u0012l\u0017N\\\"mS\u0016tGo\u0018\u0013fcR\u0011a)\u0013\t\u0003a\u001dK!\u0001S\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b\u0015\u0012\t\t\u00111\u00018\u0003\rAH%M\u0001\rC\u0012l\u0017N\\\"mS\u0016tG\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\r\"\u0012aa\u0014\t\u0003!Zk\u0011!\u0015\u0006\u00039IS!a\u0015+\u0002\u000f),\b/\u001b;fe*\u0011Q\u000bQ\u0001\u0006UVt\u0017\u000e^\u0005\u0003/F\u0013!BQ3g_J,W)Y2i\u0003\t\"Xm\u001d;Fq\u000edWo]5p]\u000e\u0013X-\u0019;f)>\u0004\u0018n\u0019,bY&$\u0017\r^5p]\"\u0012qA\u0017\t\u0003!nK!\u0001X)\u0003\tQ+7\u000f^\u0001(i\u0016\u001cH/\u0012=dYV\u001c\u0018n\u001c8De\u0016\fG/\u001a)beRLG/[8ogZ\u000bG.\u001b3bi&|g\u000e\u000b\u0002\t5\u0006IB/Z:u\u000bb\u001cG.^:j_:\u0014V-Y:tS\u001etW.\u001a8uQ\tI!,A\ruKN$X\t_2mkNLwN\\!qSN+W.\u00198uS\u000e\u001c\bF\u0001\u0006[\u0003\r\"Xm\u001d;Fq\u000edWo]5p]\u0006#x.\\5dSRL\u0018I\u001c3FeJ|'oQ1tKND#a\u0003.\u0002+Q,7\u000f^#yG2,8/[8o\r\u0006LGn\u001c<fe\"\u0012ABW\u0001\u0018CN\u001cXM\u001d;BI6Lgn\u00117jK:$H\u000b\u001b:poN,2![A\u0006)\rQ\u0017\u0011\u0007\u000b\u0005Wn\fi\u0002\u0005\u0002mq:\u0011Q.\u001e\b\u0003]Nt!a\u001c:\u000e\u0003AT!!]\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0015B\u0001;A\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002wo\u00069\u0001/Y2lC\u001e,'B\u0001;A\u0013\tI(PA\u0005BgN,'\u000f^5p]*\u0011ao\u001e\u0005\u0006y6\u0001\u001d!`\u0001\tG2\f7o\u001d+bOB)a0a\u0001\u0002\b5\tqPC\u0002\u0002\u0002E\nqA]3gY\u0016\u001cG/C\u0002\u0002\u0006}\u0014\u0001b\u00117bgN$\u0016m\u001a\t\u0005\u0003\u0013\tY\u0001\u0004\u0001\u0005\u000f\u00055QB1\u0001\u0002\u0010\t\tA+\u0005\u0003\u0002\u0012\u0005]\u0001c\u0001\u0019\u0002\u0014%\u0019\u0011QC\u0019\u0003\u000f9{G\u000f[5oOB\u0019\u0001'!\u0007\n\u0007\u0005m\u0011G\u0001\u0004B]f\u0014VM\u001a\u0005\b\u0003?i\u00019AA\u0011\u0003\r\u0001xn\u001d\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003\u0019\u0019x.\u001e:dK*\u0019\u00111\u0006!\u0002\u0013M\u001c\u0017\r\\1di&\u001c\u0017\u0002BA\u0018\u0003K\u0011\u0001\u0002U8tSRLwN\u001c\u0005\t\u0003giA\u00111\u0001\u00026\u0005\ta\rE\u00031\u0003o\tY$C\u0002\u0002:E\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0004a\u0005u\u0012bAA c\t\u0019\u0011I\\=\u0002/Y,'/\u001b4z\u000bb\u0004Xm\u0019;fI\u0016C8-\u001a9uS>tGc\u0002$\u0002F\u0005\u001d\u00141\u000e\u0005\b\u0003\u000fr\u0001\u0019AA%\u0003=)\u0007p\u00197vg&|gNU3tk2$\b\u0003BA&\u0003CrA!!\u0014\u0002^9!\u0011qJA.\u001d\u0011\t\t&!\u0017\u000f\t\u0005M\u0013q\u000b\b\u0004]\u0006U\u0013BA A\u0013\tqb(\u0003\u0002={%\u0011!hO\u0005\u0004\u0003?J\u0014AI!mi\u0016\u0014(I]8lKJ\u0014V\r\u001d7jG\u0006,\u0005p\u00197vg&|gn\u001d*fgVdG/\u0003\u0003\u0002d\u0005\u0015$\u0001E#yG2,8/[8ogJ+7/\u001e7u\u0015\r\ty&\u000f\u0005\u0007\u0003Sr\u0001\u0019A\u0018\u0002\u0011\t\u0014xn[3s\u0013\u0012Dq!!\u001c\u000f\u0001\u0004\ty'A\u0003feJ|'\u000f\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0011A\u0014x\u000e^8d_2T1!!\u001f>\u0003\u0019\u0019w.\\7p]&!\u0011QPA:\u0005\u0019)%O]8sg\u0006Y\u0012m]:feR\u001cVoY2fgN4W\u000f\\!mi\u0016\u0014(+Z:vYR$2ARAB\u0011\u001d\t)i\u0004a\u0001\u0003\u000f\u000baA]3tk2$\b\u0003BAE\u0003Cr1\u0001OA/\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u000f\u0019\u000by)a&\u0002,\"1Q\u0007\u0005a\u0001\u0003#\u00032\u0001OAJ\u0013\r\t)*\u000f\u0002\u0006\u0003\u0012l\u0017N\u001c\u0005\b\u00033\u0003\u0002\u0019AAN\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0003\u0002\u001e\u0006\u0015f\u0002BAP\u0003C\u0003\"a\\\u0019\n\u0007\u0005\r\u0016'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003O\u000bIK\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003G\u000b\u0004bBAW!\u0001\u0007\u0011qV\u0001\u0010i>\u0004\u0018nY!tg&<g.\\3oiB9\u0011\u0011WA^_\u0005}VBAAZ\u0015\u0011\t),a.\u0002\u0013%lW.\u001e;bE2,'bAA]c\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u00161\u0017\u0002\u0004\u001b\u0006\u0004\b#BAY\u0003\u0003|\u0013\u0002BAb\u0003g\u0013A\u0001T5ti\u0006\u00012M]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\n\r\u0006%\u00171ZAg\u0003#Da!N\tA\u0002\u0005E\u0005bBAM#\u0001\u0007\u00111\u0014\u0005\u0007\u0003\u001f\f\u0002\u0019A\u0018\u0002/9,w\u000fV8uC2\u001cu.\u001e8u!\u0006\u0014H/\u001b;j_:\u001c\bbBAj#\u0001\u0007\u0011qV\u0001\u0014a\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u000b\b\r\u0006]\u0017\u0011\\An\u0011\u0019)$\u00031\u0001\u0002\u0012\"9\u0011\u0011\u0014\nA\u0002\u0005m\u0005BBAh%\u0001\u0007q\u0006F\u0005G\u0003?\f\t/a9\u0002h\"1Qg\u0005a\u0001\u0003#Cq!!'\u0014\u0001\u0004\tY\n\u0003\u0004\u0002fN\u0001\raL\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\r\u0005%8\u00031\u00010\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]\u0001\u0018m\u0006d\u0017\u000eZ1uKR{\u0007/[2BgNLwM\\7f]R$RARAx\u0003cDq!!'\u0015\u0001\u0004\tY\nC\u0004\u0002tR\u0001\r!a,\u0002'\u0015D\b/Z2uK\u0012\f5o]5h]6,g\u000e^:\u00027Y\fG.\u001b3bi\u0016\u0004\u0016M\u001d;ji&|g.Q:tS\u001etW.\u001a8u)\u001d1\u0015\u0011`A~\u0003\u007fDq!!'\u0016\u0001\u0004\tY\n\u0003\u0004\u0002~V\u0001\raL\u0001\na\u0006\u0014H/\u001b;j_:DqA!\u0001\u0016\u0001\u0004\ty,\u0001\nfqB,7\r^3e\u0003N\u001c\u0018n\u001a8nK:$Hc\u0002$\u0003\u0006\t=!\u0011\u0003\u0005\b\u0005\u000f1\u0002\u0019\u0001B\u0005\u0003A!x\u000e]5d\t\u0016\u001c8M]5qi&|g\u000eE\u00029\u0005\u0017I1A!\u0004:\u0005A!v\u000e]5d\t\u0016\u001c8M]5qi&|g\u000e\u0003\u0004\u0002~Z\u0001\ra\f\u0005\b\u0005\u00031\u0002\u0019AA`\u000359\u0018-\u001b;G_J\f5o]3siR9aIa\u0006\u0003(\tE\u0002b\u0002B\r/\u0001\u0007!1D\u0001\u000ei\u0016\u001cHoQ8oI&$\u0018n\u001c8\u0011\t\tu!1E\u0007\u0003\u0005?Q1A!\t>\u0003\u0011!Xm\u001d;\n\t\t\u0015\"q\u0004\u0002\u000e)\u0016\u001cHoQ8oI&$\u0018n\u001c8\t\u000f\t%r\u00031\u0001\u0003,\u0005IQ.\u0019=XC&$Xj\u001d\t\u0004a\t5\u0012b\u0001B\u0018c\t!Aj\u001c8h\u0011\u001d\u0011\u0019d\u0006a\u0001\u00037\u000b\u0001cY8oI&$\u0018n\u001c8EKR\f\u0017\u000e\\:\u0002KY\fG.\u001b3bi\u0016$v\u000e]5d\t>,7O\u001c;Ta\u0006tW\t_2mk\u0012,GM\u0011:pW\u0016\u0014Hc\u0002$\u0003:\tm\"Q\t\u0005\b\u00033C\u0002\u0019AAN\u0011\u001d\u0011i\u0004\u0007a\u0001\u0005\u007f\t\u0011#\u001a=dYV$W\r\u001a\"s_.,'/\u00133t!\u0015\tiJ!\u00110\u0013\u0011\u0011\u0019%!+\u0003\u0007M+G\u000f\u0003\u0004\u0003Ha\u0001\raL\u0001\u0016Kb\u0004Xm\u0019;fI:+X\u000eU1si&$\u0018n\u001c8t\u0003!\u0011X-Y:tS\u001etG#\u0002$\u0003N\te\u0003b\u0002B(3\u0001\u0007!\u0011K\u0001\u0003iB\u0004BAa\u0015\u0003V5\u0011\u0011qO\u0005\u0005\u0005/\n9H\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\tm\u0013\u00041\u0001\u0003^\u0005qA/\u0019:hKR\u0014V\r\u001d7jG\u0006\u001c\b#\u0002B0\u0005Ozc\u0002\u0002B1\u0005Kr1a\u001cB2\u0013\u0005\u0011\u0014B\u0001<2\u0013\u0011\t\u0019M!\u001b\u000b\u0005Y\f\u0004")
public class ReplicaExclusionIntegrationTest
extends IntegrationTestHarness {
    private ConfluentAdmin adminClient = null;

    @Override
    public int brokerCount() {
        return 3;
    }

    public ConfluentAdmin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(ConfluentAdmin x$1) {
        this.adminClient = x$1;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.adminClient_$eq(this.createAdminClient(this.createAdminClient$default$1()));
    }

    @Test
    public void testExclusionCreateTopicValidation() {
        String topicName = "topic";
        int p0 = 0;
        int p1 = 1;
        int p2 = 2;
        int excludedBrokerId = 0;
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result);
        scala.collection.immutable.Map invalidAssignment = (scala.collection.immutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{excludedBrokerId, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, excludedBrokerId}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, excludedBrokerId, 1})))}));
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createTopic((Admin)this.adminClient(), topicName, (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        scala.collection.immutable.Map validAssignment = (scala.collection.immutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1})))}));
        this.createTopic((Admin)this.adminClient(), topicName, (scala.collection.immutable.Map<Object, List<Object>>)validAssignment);
        this.validateTopicAssignment(topicName, (scala.collection.immutable.Map<Object, List<Object>>)validAssignment);
        String secondTopic = new StringBuilder(2).append(topicName).append("-2").toString();
        this.createTopic((Admin)this.adminClient(), secondTopic, 5, 2);
        this.validateTopicDoesntSpanExcludedBroker(secondTopic, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{excludedBrokerId}))), 5);
        String thirdTopic = new StringBuilder(2).append(topicName).append("-3").toString();
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createTopic((Admin)this.adminClient(), thirdTopic, 5, this.brokerCount()), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult deleteResult = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(deleteResult);
        this.createTopic((Admin)this.adminClient(), thirdTopic, 5, this.brokerCount());
        this.createTopic((Admin)this.adminClient(), "fourthTopic", (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment);
    }

    @Test
    public void testExclusionCreatePartitionsValidation() {
        String rf3Topic = "rf-3-topic";
        String rf2Topic = "rf-2-topic";
        int newP3 = 3;
        int newP4 = 4;
        int newPartitionCount = 5;
        int excludedBrokerId = 0;
        this.createTopic((Admin)this.adminClient(), rf3Topic, 3, 3);
        this.createTopic((Admin)this.adminClient(), rf2Topic, 3, 2);
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result);
        scala.collection.immutable.Map invalidAssignment = (scala.collection.immutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)newP3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{excludedBrokerId, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)newP4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createPartitions((Admin)this.adminClient(), rf2Topic, newPartitionCount, (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.createTopic((Admin)this.adminClient(), "rf-2-topic-2", 3, 2);
        this.validateTopicDoesntSpanExcludedBroker("rf-2-topic-2", (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{excludedBrokerId}))), 3);
        this.createPartitions((Admin)this.adminClient(), "rf-2-topic-2", 20);
        this.validateTopicDoesntSpanExcludedBroker("rf-2-topic-2", (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{excludedBrokerId}))), 20);
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.createPartitions((Admin)this.adminClient(), rf3Topic, newPartitionCount), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult deleteResult = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(deleteResult);
        this.createPartitions((Admin)this.adminClient(), rf3Topic, newPartitionCount);
        this.createPartitions((Admin)this.adminClient(), rf2Topic, newPartitionCount, (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment);
    }

    @Test
    public void testExclusionReassignment() {
        String topic = "reassignment-topic";
        int excludedBrokerId = 0;
        TopicPartition tp = new TopicPartition(topic, 0);
        this.createTopic((Admin)this.adminClient(), topic, (scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{excludedBrokerId, 1})))}))));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result);
        ObjectRef newAssignment = ObjectRef.create((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, excludedBrokerId})));
        this.reassign(tp, (List<Object>)((List)newAssignment.elem));
        this.waitForAssert(() -> {
            this.validatePartitionAssignment(tp.topic(), tp.partition(), (List<Object>)((List)newAssignment$1.elem));
            return true;
        }, 10000L, new StringBuilder(31).append("Partition ").append(tp).append(" was not assigned to ").append((List)newAssignment.elem).toString());
        newAssignment.elem = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        this.reassign(tp, (List<Object>)((List)newAssignment.elem));
        this.waitForAssert(() -> {
            this.validatePartitionAssignment(tp.topic(), tp.partition(), (List<Object>)((List)newAssignment$1.elem));
            return true;
        }, 10000L, new StringBuilder(31).append("Partition ").append(tp).append(" was not assigned to ").append((List)newAssignment.elem).toString());
        List invalidAssignment = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, excludedBrokerId}));
        this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.reassign(tp, (List<Object>)invalidAssignment), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        AlterBrokerReplicaExclusionsResult.ExclusionsResult deletionResult = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)excludedBrokerId)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(deletionResult);
        this.reassign(tp, (List<Object>)invalidAssignment);
        this.waitForAssert(() -> {
            this.validatePartitionAssignment(tp.topic(), tp.partition(), (List<Object>)invalidAssignment);
            return true;
        }, 10000L, new StringBuilder(31).append("Partition ").append(tp).append(" was not assigned to ").append(invalidAssignment).toString());
    }

    @Test
    public void testExclusionApiSemantics() {
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4101)), (Object)new ExclusionOp(ExclusionOp.OpType.SET)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result);
        java.util.List describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4101})), (Object)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(describedExclusions).asScala()).map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)), (Object)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(describedExclusions).asScala()).map((Function1 & Serializable & scala.Serializable)a -> a.reason(), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$));
        this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4101)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance-2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance-3"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result);
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(describedExclusions).asScala()).map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"maintenance-2", (List)new .colon.colon((Object)"maintenance-3", (List)Nil$.MODULE$)), (Object)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(describedExclusions).asScala()).map((Function1 & Serializable & scala.Serializable)a -> a.reason(), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$));
        this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance-2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance-3")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result);
        this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result);
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(describedExclusions).asScala()).map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"maintenance-2", (List)new .colon.colon((Object)"maintenance-3", (List)Nil$.MODULE$)), (Object)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(describedExclusions).asScala()).map((Function1 & Serializable & scala.Serializable)a -> a.reason(), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$));
    }

    @Test
    public void testExclusionAtomicityAndErrorCases() {
        this.assertAdminClientThrows((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-10)), (Object)new ExclusionOp(ExclusionOp.OpType.SET)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get(), ClassTag$.MODULE$.apply(UnrepresentableBrokerIdException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        java.util.List describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertTrue((boolean)describedExclusions.isEmpty(), (String)new StringBuilder(65).append("Expected no broker replica exclusions to be present, instead got ").append(describedExclusions).toString());
        this.assertAdminClientThrows((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ExclusionOp(ExclusionOp.OpType.SET)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance=maintenance=][]asmaintenancemaintenancemaintenance"))}))).asJava()).result().get(), ClassTag$.MODULE$.apply(InvalidBrokerReplicaExclusionException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertTrue((boolean)describedExclusions.isEmpty(), (String)new StringBuilder(65).append("Expected no broker replica exclusions to be present, instead got ").append(describedExclusions).toString());
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected replica exclusion alteration with an exception to not be applied");
        Assertions.assertEquals((int)2, (int)result.exclusionResultByBroker().size());
        Assertions.assertTrue((boolean)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(((ExclusionOpResult)result.exclusionResultByBroker().get(BoxesRunTime.boxToInteger((int)2))).errorOpt())).isEmpty(), (String)"Expected broker 2 to not have an exception with its exclusion");
        this.verifyExpectedException(result, 1, Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND);
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertTrue((boolean)describedExclusions.isEmpty(), (String)new StringBuilder(65).append("Expected no broker replica exclusions to be present, instead got ").append(describedExclusions).toString());
        result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        Assertions.assertTrue((boolean)result.isSuccessful(), (String)"Expected replica exclusion to be applied");
        result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)new ExclusionOp(ExclusionOp.OpType.DELETE))}))).asJava()).result().get();
        Assertions.assertFalse((boolean)result.isSuccessful(), (String)"Expected replica exclusion alteration with an exception to not be applied");
        Assertions.assertEquals((int)3, (int)result.exclusionResultByBroker().size());
        Assertions.assertTrue((boolean)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(((ExclusionOpResult)result.exclusionResultByBroker().get(BoxesRunTime.boxToInteger((int)2))).errorOpt())).isEmpty(), (String)"Expected broker 2 to not have an exception with its exclusion");
        this.verifyExpectedException(result, 10, Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND);
        this.verifyExpectedException(result, 11, Errors.BROKER_REPLICA_PLACEMENT_EXCLUSION_NOT_FOUND);
    }

    @Test
    public void testExclusionFailover() {
        int b1 = this.getController().config().brokerId();
        int b2 = ((KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionIntegrationTest.$anonfun$testExclusionFailover$1(b1, s)))).head()).config().brokerId();
        List excludedBrokers = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{b1, b2})).sorted((Ordering)Ordering.Int$.MODULE$);
        AlterBrokerReplicaExclusionsResult.ExclusionsResult result = (AlterBrokerReplicaExclusionsResult.ExclusionsResult)this.adminClient().alterBrokerReplicaExclusions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)b1)), (Object)new ExclusionOp(ExclusionOp.OpType.SET)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)b2)), (Object)new ExclusionOp(ExclusionOp.OpType.SET, "maintenance"))}))).asJava()).result().get();
        this.assertSuccessfulAlterResult(result);
        java.util.List describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)excludedBrokers, (Object)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(describedExclusions).asScala()).map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)), (Object)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(describedExclusions).asScala()).map((Function1 & Serializable & scala.Serializable)a -> a.reason(), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$));
        this.getController().shutdown();
        describedExclusions = (java.util.List)this.adminClient().describeBrokerReplicaExclusions().descriptions().get();
        Assertions.assertEquals((int)2, (int)describedExclusions.size());
        Assertions.assertEquals((Object)excludedBrokers, (Object)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(describedExclusions).asScala()).map((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToInteger((int)a.brokerId()), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Int$.MODULE$));
        Assertions.assertEquals((Object)new .colon.colon((Object)"", (List)new .colon.colon((Object)"maintenance", (List)Nil$.MODULE$)), (Object)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(describedExclusions).asScala()).map((Function1 & Serializable & scala.Serializable)a -> a.reason(), Buffer$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$));
        excludedBrokers.foreach((Function1 & Serializable & scala.Serializable)excludedBroker -> ReplicaExclusionIntegrationTest.$anonfun$testExclusionFailover$6(this, BoxesRunTime.unboxToInt((Object)excludedBroker)));
    }

    public <T> Assertion assertAdminClientThrows(Function0<Object> f, ClassTag<T> classTag, Position pos) {
        return Matchers$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> {
            try {
                return f.apply();
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }, classTag, pos);
    }

    private void verifyExpectedException(AlterBrokerReplicaExclusionsResult.ExclusionsResult exclusionResult, int brokerId, Errors error) {
        java.util.Map exclusionsByBroker = exclusionResult.exclusionResultByBroker();
        Assertions.assertTrue((boolean)exclusionsByBroker.containsKey(BoxesRunTime.boxToInteger((int)brokerId)), (String)new StringBuilder(44).append("Expected exclusions by broker (").append(exclusionsByBroker).append(") to contain ").append(brokerId).toString());
        Optional brokerErrorOpt = ((ExclusionOpResult)exclusionsByBroker.get(BoxesRunTime.boxToInteger((int)brokerId))).errorOpt();
        Assertions.assertTrue((boolean)brokerErrorOpt.isPresent(), (String)new StringBuilder(56).append("Expected broker ").append(brokerId).append(" to have an exception with its exclusion").toString());
        Exception receivedException = ((ExclusionOperationError)brokerErrorOpt.get()).exception();
        ApiException expectedException = error.exception();
        Assertions.assertTrue((boolean)expectedException.getClass().isInstance(receivedException), (String)new StringBuilder(60).append("Expected broker ").append(brokerId).append("'s exception to be of type ").append(expectedException.getClass()).append(", instead it was ").append(receivedException).toString());
    }

    private void assertSuccessfulAlterResult(AlterBrokerReplicaExclusionsResult.ExclusionsResult result) {
        Assertions.assertTrue((boolean)result.isSuccessful(), (String)new StringBuilder(53).append("Expected result ").append(result).append(" to have been applied, but it was not").toString());
        scala.collection.mutable.Map resultByBroker = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result.exclusionResultByBroker()).asScala();
        Assertions.assertTrue((boolean)resultByBroker.values().forall((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ReplicaExclusionIntegrationTest.$anonfun$assertSuccessfulAlterResult$1(r))), (String)new StringBuilder(69).append("Expected no exclusion results to have errors, but instead found some ").append(resultByBroker).toString());
    }

    public void createTopic(Admin adminClient, String topicName, scala.collection.immutable.Map<Object, List<Object>> topicAssignment) {
        java.util.Map replicasAssignments = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int key = x0$1._1$mcI$sp();
            List value = (List)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)value.map((Function1 & Serializable & scala.Serializable)x -> ReplicaExclusionIntegrationTest.$anonfun$createTopic$2(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom())).asJava();
        adminClient.createTopics(Collections.singletonList(new NewTopic(topicName, replicasAssignments))).all().get();
    }

    public void createPartitions(Admin adminClient, String topicName, int newTotalCountPartitions, scala.collection.immutable.Map<Object, List<Object>> partitionAssignment) {
        java.util.List newAssignments = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)partitionAssignment.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$2 -> (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)x$2._2()).map((Function1 & Serializable & scala.Serializable)x -> ReplicaExclusionIntegrationTest.$anonfun$createPartitions$3(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava(), Seq$.MODULE$.canBuildFrom())).asJava();
        adminClient.createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)NewPartitions.increaseTo((int)newTotalCountPartitions, (java.util.List)newAssignments))}))).asJava()).all().get();
    }

    public void createPartitions(Admin adminClient, String topicName, int newTotalCountPartitions) {
        adminClient.createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicName), (Object)NewPartitions.increaseTo((int)newTotalCountPartitions))}))).asJava()).all().get();
    }

    public void createTopic(Admin adminClient, String topicName, int numPartitions, int replicationFactor) {
        adminClient.createTopics(Collections.singletonList(new NewTopic(topicName, numPartitions, (short)replicationFactor))).all().get();
    }

    public void validateTopicAssignment(String topicName, scala.collection.immutable.Map<Object, List<Object>> expectedAssignments) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(topicName)).values().get(topicName)).get();
        Assertions.assertEquals((int)topicDescription.partitions().size(), (int)expectedAssignments.size());
        expectedAssignments.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            ReplicaExclusionIntegrationTest.$anonfun$validateTopicAssignment$2(this, topicDescription, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public void validatePartitionAssignment(String topicName, int partition, List<Object> expectedAssignment) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(topicName)).values().get(topicName)).get();
        this.validatePartitionAssignment(topicDescription, partition, expectedAssignment);
    }

    public void validatePartitionAssignment(TopicDescription topicDescription, int partition, List<Object> expectedAssignment) {
        Assertions.assertTrue((topicDescription.partitions().size() > partition ? 1 : 0) != 0, (String)new StringBuilder(83).append("Topic description for topic ").append(topicDescription.name()).append(" did not have enough partitions - wanted ").append(partition).append(" but had only ").append(topicDescription.partitions().size()).toString());
        Assertions.assertEquals(expectedAssignment, (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)topicDescription.partitions().get(partition)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom())).toList());
    }

    private void waitForAssert(TestCondition testCondition, long maxWaitMs, String conditionDetails) {
        AtomicReference<String> failureReason = new AtomicReference<String>("");
        Supplier<String> waitForCondition_conditionDetailsSupplier = () -> new StringBuilder(28).append(conditionDetails).append(" ; last reason for failure: ").append((Object)(((String)failureReason.get()).isEmpty() ? "<empty>" : failureReason.get())).toString();
        TestUtils.waitForCondition(() -> {
            try {
                return testCondition.conditionMet();
            }
            catch (AssertionError err) {
                failureReason.set(((Throwable)((Object)err)).toString());
                return false;
            }
        }, (long)maxWaitMs, (long)100L, waitForCondition_conditionDetailsSupplier);
    }

    public void validateTopicDoesntSpanExcludedBroker(String topicName, Set<Object> excludedBrokerIds, int expectedNumPartitions) {
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(topicName)).values().get(topicName)).get();
        Assertions.assertEquals((int)expectedNumPartitions, (int)topicDescription.partitions().size(), (String)new StringBuilder(41).append("Expected topic ").append(topicName).append(" to").append(" have ").append(expectedNumPartitions).append(" but instead got ").append(topicDescription.partitions().size()).toString());
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicDescription.partitions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)pInfo -> {
            ReplicaExclusionIntegrationTest.$anonfun$validateTopicDoesntSpanExcludedBroker$1(excludedBrokerIds, topicName, pInfo);
            return BoxedUnit.UNIT;
        });
    }

    private void reassign(TopicPartition tp, List<Object> targetReplicas) {
        NewPartitionReassignment reassignment = new NewPartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)targetReplicas.map((Function1 & Serializable & scala.Serializable)x -> ReplicaExclusionIntegrationTest.$anonfun$reassign$1(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(reassignment))).all().get();
    }

    public static final /* synthetic */ boolean $anonfun$testExclusionFailover$1(int b1$1, KafkaServer s) {
        return s.config().brokerId() != b1$1;
    }

    public static final /* synthetic */ Assertion $anonfun$testExclusionFailover$6(ReplicaExclusionIntegrationTest $this, int excludedBroker) {
        scala.collection.immutable.Map invalidAssignment = (scala.collection.immutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{excludedBroker})))}));
        return $this.assertAdminClientThrows((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.createTopic((Admin)$this.adminClient(), "topic", (scala.collection.immutable.Map<Object, List<Object>>)invalidAssignment), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("ReplicaExclusionIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
    }

    public static final /* synthetic */ boolean $anonfun$assertSuccessfulAlterResult$1(ExclusionOpResult r) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(r.errorOpt())).isEmpty();
    }

    public static final /* synthetic */ Integer $anonfun$createTopic$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$createPartitions$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ void $anonfun$validateTopicAssignment$2(ReplicaExclusionIntegrationTest $this, TopicDescription topicDescription$1, Tuple2 x$3) {
        if (x$3 != null) {
            int partition = x$3._1$mcI$sp();
            List expectedAssignment = (List)x$3._2();
            $this.validatePartitionAssignment(topicDescription$1, partition, (List<Object>)expectedAssignment);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$validateTopicDoesntSpanExcludedBroker$1(Set excludedBrokerIds$1, String topicName$2, TopicPartitionInfo pInfo) {
        Buffer replicas = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(pInfo.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Buffer$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)replicas.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)r -> !excludedBrokerIds$1.contains((Object)BoxesRunTime.boxToInteger((int)r))), (String)new StringBuilder(93).append("Expected replicas for ").append(topicName$2).append("-").append(pInfo.partition()).append(" to not include excluded brokers ").append(excludedBrokerIds$1).append(" but instead it had a replica set of ").append(replicas).toString());
    }

    public static final /* synthetic */ Integer $anonfun$reassign$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

