/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.link;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.link.AbstractClusterLinkIntegrationTest;
import kafka.log.Defaults$;
import kafka.log.LogConfig$;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001u3Aa\u0003\u0007\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003?\u0001\u0011\u0005!\u0006C\u0003@\u0001\u0011\u0005!\u0006C\u0003A\u0001\u0011\u0005!\u0006C\u0003B\u0001\u0011\u0005!\u0006C\u0003C\u0001\u0011%1\tC\u0003T\u0001\u0011%AK\u0001\u0010NSJ\u0014xN\u001d+pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2Sk2,7\u000fV3ti*\u0011QBD\u0001\u0005Y&t7N\u0003\u0002\u0010!\u0005)1.\u00194lC*\t\u0011#A\u0006j]R,wM]1uS>t7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!!D\f\u000b\u0003=I!!\u0007\f\u0003E\u0005\u00137\u000f\u001e:bGR\u001cE.^:uKJd\u0015N\\6J]R,wM]1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u001e\u00015\tA\"A\nu_BL7mU=oG&sG/\u001a:wC2l5/F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0017\u0001\u0006;pa&\u001c7+\u001f8d\u0013:$XM\u001d<bY6\u001b\b%\u0001\u000euKN$Hk\u001c9jG\u000e{gNZ5h'ft7-\u00138dYV$W\rF\u0001,!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0011)f.\u001b;)\u0005\u0011\u0011\u0004CA\u001a=\u001b\u0005!$BA\u001b7\u0003\r\t\u0007/\u001b\u0006\u0003oa\nqA[;qSR,'O\u0003\u0002:u\u0005)!.\u001e8ji*\t1(A\u0002pe\u001eL!!\u0010\u001b\u0003\tQ+7\u000f^\u0001\u0013m\u0016\u0014\u0018NZ=J]Z\fG.\u001b3WC2,X-A\u001awKJLg-_'jeJ|'\u000fV8qS\u000e\u001c%/Z1uS>twJ^3se&$Wm]!mo\u0006L8oU=oG\u000e{gNZ5hg\u0006qa/\u001a:jMf|e/\u001a:sS\u0012,\u0017!\u0004<fe&4\u0017\u0010R3gCVdG/\u0001\u0007d_:4\u0017n\u001a'jgR|e\r\u0006\u0002E\u001dB\u0011Q\t\u0014\b\u0003\r*\u0003\"aR\u0017\u000e\u0003!S!!\u0013\n\u0002\rq\u0012xn\u001c;?\u0013\tYU&\u0001\u0004Qe\u0016$WMZ\u0005\u0003O5S!aS\u0017\t\u000b=K\u0001\u0019\u0001)\u0002\u000b\u0015dW-\\:\u0011\u00071\nF)\u0003\u0002S[\tQAH]3qK\u0006$X\r\u001a \u0002\u0019\u0005\u0004\b/\u001a8e\u00032<\u0018-_:\u0015\u0005\u0011+\u0006\"\u0002,\u000b\u0001\u0004!\u0015A\u0001;pQ\u0011\u0001\u0001l\u0017/\u0011\u0005MJ\u0016B\u0001.5\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0002#\u0001")
public class MirrorTopicConfigSyncRulesTest
extends AbstractClusterLinkIntegrationTest {
    private final String topicSyncIntervalMs;

    public String topicSyncIntervalMs() {
        return this.topicSyncIntervalMs;
    }

    @Test
    public void testTopicConfigSyncInclude() {
        this.verifyInvalidValue();
        this.verifyMirrorTopicCreationOverridesAlwaysSyncConfigs();
        this.verifyOverride();
        this.verifyDefault();
    }

    public void verifyInvalidValue() {
        String linkName = UUID.randomUUID().toString();
        new .colon.colon((Object)this.configListOf((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.RetentionBytesProp()})), (List)new .colon.colon((Object)this.appendAlways(this.configListOf((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"confluent.tier.enable"}))), (List)new .colon.colon((Object)"", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties linkConfigOverrides = new Properties(this, (String)value){
                {
                    this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), value$1);
                    this.putAll((java.util.Map<?, ?>)$outer.destLinkProps($outer.destLinkProps$default$1()));
                }
            };
            return (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> this.createClusterLink(linkName, linkConfigOverrides, this.createClusterLink$default$3(), this.createClusterLink$default$4()));
        });
    }

    public void verifyMirrorTopicCreationOverridesAlwaysSyncConfigs() {
        String topic = UUID.randomUUID().toString();
        String linkName = UUID.randomUUID().toString();
        String topicConfigSyncInclude = this.appendAlways(this.configListOf((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.FlushMsProp()})));
        Properties linkConfigOverrides = new Properties(null, topicConfigSyncInclude){
            {
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncInclude$1);
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), "100");
            }
        };
        linkConfigOverrides.putAll((java.util.Map<?, ?>)this.destLinkProps(this.destLinkProps$default$1()));
        this.createClusterLink(linkName, linkConfigOverrides, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        scala.collection.immutable.Map mirrorTopicConfigsOverride = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.FlushMsProp()), (Object)"14141414")}));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.destCluster().linkTopic(topic, this.replicationFactor(), linkName, (Map<String, String>)mirrorTopicConfigsOverride));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyOverride() {
        String topic = UUID.randomUUID().toString();
        String linkName = UUID.randomUUID().toString();
        String topicConfigSyncInclude = this.appendAlways(this.configListOf((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.MinCompactionLagMsProp(), LogConfig$.MODULE$.FlushMsProp()})));
        Properties linkConfigOverrides = new Properties(null, topicConfigSyncInclude){
            {
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncInclude$2);
                this.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncMsProp(), "100");
            }
        };
        linkConfigOverrides.putAll((java.util.Map<?, ?>)this.destLinkProps(this.destLinkProps$default$1()));
        String minCompactionLagMs = "2222";
        String flushMs = "4444";
        String retentionBytesOverride = "3333333333";
        String tierEnable = "true";
        Properties topicConfigs = new Properties(null, minCompactionLagMs, flushMs, retentionBytesOverride, tierEnable){
            {
                this.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), minCompactionLagMs$1);
                this.put(LogConfig$.MODULE$.FlushMsProp(), flushMs$1);
                this.put(LogConfig$.MODULE$.RetentionBytesProp(), retentionBytesOverride$1);
                this.put(LogConfig$.MODULE$.TierEnableProp(), tierEnable$1);
            }
        };
        this.createClusterLink(linkName, linkConfigOverrides, this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.sourceCluster().createTopic(topic, this.numPartitions(), this.replicationFactor(), topicConfigs);
        this.destCluster().linkTopic(topic, this.replicationFactor(), linkName, this.destCluster().linkTopic$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MirrorTopicConfigSyncRulesTest.$anonfun$verifyOverride$1(this, topic, retentionBytesOverride)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MirrorTopicConfigSyncRulesTest.$anonfun$verifyOverride$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        scala.collection.immutable.Map expect = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MinCompactionLagMsProp()), (Object)minCompactionLagMs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.FlushMsProp()), (Object)flushMs), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TierEnableProp()), (Object)Boolean.toString(Defaults$.MODULE$.TierEnable()))}));
        Assertions.assertTrue((boolean)this.destCluster().describeTopicConfigEquals(topic, (Map<String, String>)expect), (String)"min.compaction.lag.ms should sync, flush.ms should sync, confluent.tier.enable shouldn't sync");
    }

    /*
     * WARNING - void declaration
     */
    public void verifyDefault() {
        String topic = UUID.randomUUID().toString();
        String linkName = UUID.randomUUID().toString();
        String minCompactionLagMs = "3333333333";
        String flushMs = "11111111";
        Properties topicConfigs = new Properties(null, minCompactionLagMs, flushMs){
            {
                this.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), minCompactionLagMs$2);
                this.put(LogConfig$.MODULE$.FlushMsProp(), flushMs$2);
            }
        };
        this.createClusterLink(linkName, this.createClusterLink$default$2(), this.createClusterLink$default$3(), this.createClusterLink$default$4());
        this.sourceCluster().createTopic(topic, this.numPartitions(), this.replicationFactor(), topicConfigs);
        this.destCluster().linkTopic(topic, this.replicationFactor(), linkName, this.destCluster().linkTopic$default$4());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MirrorTopicConfigSyncRulesTest.$anonfun$verifyDefault$1(this, topic, minCompactionLagMs)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MirrorTopicConfigSyncRulesTest.$anonfun$verifyDefault$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)this.destCluster().describeTopicConfigEquals(topic, LogConfig$.MODULE$.FlushMsProp(), Long.toString(Defaults$.MODULE$.FlushMs())), (String)"flush.ms shouldn't sync");
    }

    private String configListOf(Seq<String> elems) {
        return elems.mkString(",");
    }

    private String appendAlways(String to) {
        List elems = (List)new .colon.colon((Object)to, (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().toList(), List$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("elems = ").append(elems).toString());
        return elems.mkString(",");
    }

    public static final /* synthetic */ boolean $anonfun$verifyOverride$1(MirrorTopicConfigSyncRulesTest $this, String topic$2, String retentionBytesOverride$1) {
        return $this.destCluster().describeTopicConfigEquals(topic$2, LogConfig$.MODULE$.RetentionBytesProp(), retentionBytesOverride$1);
    }

    public static final /* synthetic */ String $anonfun$verifyOverride$2() {
        return "retention.bytes should sync";
    }

    public static final /* synthetic */ boolean $anonfun$verifyDefault$1(MirrorTopicConfigSyncRulesTest $this, String topic$3, String minCompactionLagMs$2) {
        return $this.destCluster().describeTopicConfigEquals(topic$3, LogConfig$.MODULE$.MinCompactionLagMsProp(), minCompactionLagMs$2);
    }

    public static final /* synthetic */ String $anonfun$verifyDefault$2() {
        return "min.compaction.lag.ms should sync by default";
    }

    public MirrorTopicConfigSyncRulesTest() {
        this.numPartitions_$eq(1);
        this.topicSyncIntervalMs = "1000";
    }
}

