/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.network;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001\u0002\u0011\"\u0001!BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013%Q\u0007\u0003\u0004=\u0001\u0001\u0006IA\u000e\u0005\b{\u0001\u0011\r\u0011\"\u00036\u0011\u0019q\u0004\u0001)A\u0005m!9q\b\u0001b\u0001\n\u0013)\u0004B\u0002!\u0001A\u0003%a\u0007C\u0004B\u0001\t\u0007I\u0011B\u001b\t\r\t\u0003\u0001\u0015!\u00037\u0011\u001d\u0019\u0005A1A\u0005\nUBa\u0001\u0012\u0001!\u0002\u00131\u0004bB#\u0001\u0005\u0004%I!\u000e\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\u001c\t\u000b\u001d\u0003A\u0011\u000b%\t\u0013Y\u0003\u0001\u0019!a\u0001\n\u00139\u0006\"\u00036\u0001\u0001\u0004\u0005\r\u0011\"\u0003l\u0011%q\u0007\u00011A\u0001B\u0003&\u0001\fC\u0004p\u0001\t\u0007I\u0011\u00029\t\r}\u0004\u0001\u0015!\u0003r\u0011!\t\t\u0001\u0001b\u0001\n\u0013)\u0004bBA\u0002\u0001\u0001\u0006IA\u000e\u0005\n\u0003\u000b\u0001!\u0019!C\t\u0003\u000fA\u0001\"!\u0007\u0001A\u0003%\u0011\u0011\u0002\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!a\u000f\u0001\t\u0003\n)\u0003C\u0004\u0002F\u0001!\t\"a\u0012\t\u0013\u0005-\u0004!%A\u0005\u0012\u00055\u0004\"CAB\u0001E\u0005I\u0011CA7\u0011\u001d\t)\t\u0001C\t\u0003\u000fCq!a#\u0001\t\u0003\t)C\u0001\u000bD_:tWm\u0019;j_:l\u0015\r_!hKR+7\u000f\u001e\u0006\u0003E\r\nqA\\3uo>\u00148N\u0003\u0002%K\u0005)1.\u00194lC*\ta%A\u0006j]R,wM]1uS>t7\u0001A\n\u0003\u0001%\u0002\"A\u000b\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u0007\u0005\u0004\u0018NC\u0001%\u0013\ty3F\u0001\u000bBEN$(/Y2u\u0007>t7/^7feR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0002\"a\r\u0001\u000e\u0003\u0005\na\u0003^3ti\u000e{gN\\3di&|g.T1y\u0003\u001e,Wj]\u000b\u0002mA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t\u0019\u0011J\u001c;\u0002/Q,7\u000f^\"p]:,7\r^5p]6\u000b\u00070Q4f\u001bN\u0004\u0013a\u0006;fgR\u001cuN\u001c8fGRLwN\\'bq&#G.Z't\u0003a!Xm\u001d;D_:tWm\u0019;j_:l\u0015\r_%eY\u0016l5\u000fI\u0001\"i\u0016\u001cHoQ8o]\u0016\u001cG/[8o\u001b&tW\t\u001f9je\u0016Le\u000e^3sm\u0006dWj]\u0001#i\u0016\u001cHoQ8o]\u0016\u001cG/[8o\u001b&tW\t\u001f9je\u0016Le\u000e^3sm\u0006dWj\u001d\u0011\u0002\u001bQ,7\u000f\u001e'p_B\u001cu.\u001e8u\u00039!Xm\u001d;M_>\u00048i\\;oi\u0002\nA\u0003^3tiJ+\u0017/^3tiRKW.Z8vi6\u001b\u0018!\u0006;fgR\u0014V-];fgR$\u0016.\\3pkRl5\u000fI\u0001\u0016i\u0016\u001cH\u000fR3mSZ,'/\u001f+j[\u0016|W\u000f^'t\u0003Y!Xm\u001d;EK2Lg/\u001a:z)&lWm\\;u\u001bN\u0004\u0013a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\tIE\n\u0005\u00028\u0015&\u00111\n\u000f\u0002\u0005+:LG\u000fC\u0003N\u001d\u0001\u0007a*\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\tU$\u0018\u000e\u001c\u0006\u0002'\u0006!!.\u0019<b\u0013\t)\u0006K\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001bY8ogVlWM]\u000b\u00021B!\u0011L\u00193e\u001b\u0005Q&B\u0001,\\\u0015\taV,A\u0004dY&,g\u000e^:\u000b\u0005\u0011r&BA0a\u0003\u0019\t\u0007/Y2iK*\t\u0011-A\u0002pe\u001eL!a\u0019.\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\r9TmZ\u0005\u0003Mb\u0012Q!\u0011:sCf\u0004\"a\u000e5\n\u0005%D$\u0001\u0002\"zi\u0016\fAbY8ogVlWM]0%KF$\"!\u00137\t\u000f5\u0004\u0012\u0011!a\u00011\u0006\u0019\u0001\u0010J\u0019\u0002\u0013\r|gn];nKJ\u0004\u0013!\u00039s_\u0012,8-\u001a:t+\u0005\t\bc\u0001:xs6\t1O\u0003\u0002uk\u00069Q.\u001e;bE2,'B\u0001<9\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003qN\u0014aAQ;gM\u0016\u0014\b\u0003\u0002>~I\u0012l\u0011a\u001f\u0006\u0003yn\u000b\u0001\u0002\u001d:pIV\u001cWM]\u0005\u0003}n\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\u0018A\u00039s_\u0012,8-\u001a:tA\u0005Qa.^7SK\u000e|'\u000fZ:\u0002\u00179,XNU3d_J$7\u000fI\u0001\u0005i&lW-\u0006\u0002\u0002\nA!\u00111BA\u000b\u001b\t\tiA\u0003\u0003\u0002\u0010\u0005E\u0011!B;uS2\u001c(bAA\n;\u000611m\\7n_:LA!a\u0006\u0002\u000e\t!A+[7f\u0003\u0015!\u0018.\\3!\u0003)\u0011'o\\6feRKW.\u001a\u000b\u0005\u0003\u0013\ty\u0002\u0003\u0004\u0002\"a\u0001\rAN\u0001\tEJ|7.\u001a:JI\u0006)1/\u001a;VaR\t\u0011\nK\u0002\u001a\u0003S\u0001B!a\u000b\u000285\u0011\u0011Q\u0006\u0006\u0004Y\u0005=\"\u0002BA\u0019\u0003g\tqA[;qSR,'OC\u0002\u00026\u0001\fQA[;oSRLA!!\u000f\u0002.\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3AGA !\u0011\tY#!\u0011\n\t\u0005\r\u0013Q\u0006\u0002\n\u0003\u001a$XM]#bG\"\f!c\u0019:fCR,G+Z:u!J|G-^2feR9\u00110!\u0013\u0002d\u0005\u001d\u0004bBA&7\u0001\u0007\u0011QJ\u0001\u000bEJ|7.\u001a:MSN$\b\u0003BA(\u0003;rA!!\u0015\u0002ZA\u0019\u00111\u000b\u001d\u000e\u0005\u0005U#bAA,O\u00051AH]8pizJ1!a\u00179\u0003\u0019\u0001&/\u001a3fM&!\u0011qLA1\u0005\u0019\u0019FO]5oO*\u0019\u00111\f\u001d\t\u0011\u0005\u00154\u0004%AA\u0002Y\n\u0011\u0003Z3mSZ,'/\u001f+j[\u0016|W\u000f^'t\u0011!\tIg\u0007I\u0001\u0002\u00041\u0014\u0001\u0005:fcV,7\u000f\u001e+j[\u0016|W\u000f^'t\u0003q\u0019'/Z1uKR+7\u000f\u001e)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uII*\"!a\u001c+\u0007Y\n\th\u000b\u0002\u0002tA!\u0011QOA@\u001b\t\t9H\u0003\u0003\u0002z\u0005m\u0014!C;oG\",7m[3e\u0015\r\ti\bO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAA\u0003o\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003q\u0019'/Z1uKR+7\u000f\u001e)s_\u0012,8-\u001a:%I\u00164\u0017-\u001e7uIM\n\u0001C]3hSN$XM\u001d)s_\u0012,8-\u001a:\u0015\u0007e\fI\tC\u0003}=\u0001\u0007\u00110\u0001\u000buKN$8+\u001a8e\u0003\u000e\u0014xn]:NCb\fu-\u001a\u0015\b?\u0005=\u0015QSAL!\u0011\tY#!%\n\t\u0005M\u0015Q\u0006\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005a\u0004fA\u0010\u0002\u001cB!\u00111FAO\u0013\u0011\ty*!\f\u0003\tQ+7\u000f\u001e")
public class ConnectionMaxAgeTest
extends AbstractConsumerTest {
    private final int testConnectionMaxAgeMs;
    private final int testConnectionMaxIdleMs;
    private final int testConnectionMinExpireIntervalMs;
    private final int testLoopCount;
    private final int testRequestTimeoutMs;
    private final int testDeliveryTimeoutMs;
    private KafkaConsumer<byte[], byte[]> consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final int numRecords;
    private final Time time = new MockTime();

    private int testConnectionMaxAgeMs() {
        return this.testConnectionMaxAgeMs;
    }

    private int testConnectionMaxIdleMs() {
        return this.testConnectionMaxIdleMs;
    }

    private int testConnectionMinExpireIntervalMs() {
        return this.testConnectionMinExpireIntervalMs;
    }

    private int testLoopCount() {
        return this.testLoopCount;
    }

    private int testRequestTimeoutMs() {
        return this.testRequestTimeoutMs;
    }

    private int testDeliveryTimeoutMs() {
        return this.testDeliveryTimeoutMs;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        super.brokerPropertyOverrides(properties);
        properties.put(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp(), Integer.toString(this.testConnectionMaxIdleMs()));
        properties.put(KafkaConfig$.MODULE$.ConnectionsMaxAgeMsProp(), Integer.toString(this.testConnectionMaxAgeMs()));
        properties.put(KafkaConfig$.MODULE$.ConnectionMinExpireIntervalMsProp(), Integer.toString(this.testConnectionMinExpireIntervalMs()));
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    private int numRecords() {
        return this.numRecords;
    }

    public Time time() {
        return this.time;
    }

    @Override
    public Time brokerTime(int brokerId) {
        return this.time();
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$2 = SecurityProtocol.PLAINTEXT;
        String x$3 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$4 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$5 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$6 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$7 = TestUtils$.MODULE$.createConsumer$default$6();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$3, x$4, x$5, x$6, x$7, x$2, x$8, x$9, x$10, x$11));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.consumer().close(Duration.ZERO);
        this.producers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close(Duration.ZERO);
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createTestProducer(String brokerList, int deliveryTimeoutMs, int requestTimeoutMs) {
        SecurityProtocol x$2 = this.securityProtocol();
        Option<File> x$3 = this.trustStoreFile();
        Option<Properties> x$4 = this.clientSaslProperties();
        int x$7 = TestUtils$.MODULE$.createProducer$default$2();
        long x$8 = TestUtils$.MODULE$.createProducer$default$3();
        long x$9 = TestUtils$.MODULE$.createProducer$default$4();
        int x$10 = TestUtils$.MODULE$.createProducer$default$5();
        int x$11 = TestUtils$.MODULE$.createProducer$default$7();
        int x$12 = TestUtils$.MODULE$.createProducer$default$8();
        String x$13 = TestUtils$.MODULE$.createProducer$default$9();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(brokerList, x$7, x$8, x$9, x$10, deliveryTimeoutMs, x$11, x$12, x$13, requestTimeoutMs, x$2, x$3, x$4, x$14, x$15, x$16);
        return this.registerProducer(producer);
    }

    public int createTestProducer$default$2() {
        return this.testDeliveryTimeoutMs();
    }

    public int createTestProducer$default$3() {
        return this.testRequestTimeoutMs();
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    @Test
    @Timeout(value=60L)
    public void testSendAcrossMaxAge() {
        KafkaProducer<byte[], byte[]> producer = this.createTestProducer(this.brokerList(), this.createTestProducer$default$2(), this.createTestProducer$default$3());
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)this.consumer().assignment().size());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.testLoopCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)loopCounter -> {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Loop count ").append(loopCounter).append(", start message is ").append(loopCounter * this.numRecords()).toString());
            int startingTimestamp = loopCounter * this.numRecords();
            this.sendRecords(producer, this.numRecords(), this.tp(), loopCounter * this.numRecords());
            this.time().sleep((long)(this.testConnectionMaxAgeMs() + 1));
            KafkaConsumer<byte[], byte[]> x$1 = this.consumer();
            int x$2 = this.numRecords();
            int x$3 = this.numRecords();
            int x$4 = loopCounter * this.numRecords();
            long x$5 = startingTimestamp;
            int x$6 = this.consumeAndVerifyRecords$default$4();
            TimestampType x$7 = this.consumeAndVerifyRecords$default$6();
            TopicPartition x$8 = this.consumeAndVerifyRecords$default$7();
            this.consumeAndVerifyRecords((Consumer<byte[], byte[]>)x$1, x$2, x$4, x$6, x$5, x$7, x$8, x$3);
        });
        Assertions.assertTrue((BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToLong((long)TestUtils$.MODULE$.totalMetricValue(server, "aged-connections-killed-count")), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) > 0L ? 1 : 0) != 0, (String)"Connections should have been expired due to excessive age");
    }

    public ConnectionMaxAgeTest() {
        this.testConnectionMaxAgeMs = 2000;
        this.testConnectionMaxIdleMs = -1;
        this.testConnectionMinExpireIntervalMs = 100;
        this.testLoopCount = 3;
        this.testRequestTimeoutMs = 120000;
        this.testDeliveryTimeoutMs = 120000;
        this.numRecords = 10;
    }
}

