/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import javax.imageio.ImageIO;
import kafka.ReplicationQuotasTestRig$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.controller.ReplicaAssignment;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.junit.jupiter.api.Assertions;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rEw!B.]\u0011\u0003yf!B1]\u0011\u0003\u0011\u0007\"B5\u0002\t\u0003Q\u0007bB6\u0002\u0005\u0004%I\u0001\u001c\u0005\u0007k\u0006\u0001\u000b\u0011B7\t\u000fY\f!\u0019!C\u0001o\"110\u0001Q\u0001\naDQ\u0001`\u0001\u0005\u0002uDq!!\t\u0002\t\u0003\t\u0019C\u0002\u0004\u0002.\u0005\u0001\u0015q\u0006\u0005\u000b\u0003{I!Q3A\u0005\u0002\u0005}\u0002BCA!\u0013\tE\t\u0015!\u0003\u0002\u000e!I\u00111I\u0005\u0003\u0016\u0004%\ta\u001e\u0005\n\u0003\u000bJ!\u0011#Q\u0001\naD\u0011\"a\u0012\n\u0005+\u0007I\u0011A<\t\u0013\u0005%\u0013B!E!\u0002\u0013A\bBCA&\u0013\tU\r\u0011\"\u0001\u0002N!Q\u0011QK\u0005\u0003\u0012\u0003\u0006I!a\u0014\t\u0013\u0005]\u0013B!f\u0001\n\u00039\b\"CA-\u0013\tE\t\u0015!\u0003y\u0011%\tY&\u0003BK\u0002\u0013\u0005q\u000fC\u0005\u0002^%\u0011\t\u0012)A\u0005q\"1\u0011.\u0003C\u0001\u0003?B\u0011\"!\u001c\n\u0005\u0004%\t!!\u0014\t\u0011\u0005=\u0014\u0002)A\u0005\u0003\u001fB\u0011\"!\u001d\n\u0003\u0003%\t!a\u001d\t\u0013\u0005\u0005\u0015\"%A\u0005\u0002\u0005\r\u0005\"CAM\u0013E\u0005I\u0011AAN\u0011%\ty*CI\u0001\n\u0003\tY\nC\u0005\u0002\"&\t\n\u0011\"\u0001\u0002$\"I\u0011qU\u0005\u0012\u0002\u0013\u0005\u00111\u0014\u0005\n\u0003SK\u0011\u0013!C\u0001\u00037C\u0001\"a+\n\u0003\u0003%\t\u0005\u001c\u0005\t\u0003[K\u0011\u0011!C\u0001o\"I\u0011qV\u0005\u0002\u0002\u0013\u0005\u0011\u0011\u0017\u0005\n\u0003{K\u0011\u0011!C!\u0003\u007fC\u0011\"!4\n\u0003\u0003%\t!a4\t\u0013\u0005e\u0017\"!A\u0005B\u0005m\u0007\"CAo\u0013\u0005\u0005I\u0011IAp\u0011%\t\t/CA\u0001\n\u0003\n\u0019oB\u0005\u0003,\u0005\t\t\u0011#\u0001\u0003.\u0019I\u0011QF\u0001\u0002\u0002#\u0005!q\u0006\u0005\u0007S&\"\tA!\u0010\t\u0013\u0005u\u0017&!A\u0005F\u0005}\u0007\"\u0003B S\u0005\u0005I\u0011\u0011B!\u0011%\u0011y%KA\u0001\n\u0003\u0013\t\u0006C\u0005\u0003d%\n\t\u0011\"\u0003\u0003f\u00191!QN\u0001\u0001\u0005_Ba![\u0018\u0005\u0002\t%\u0005\u0002\u0003BG_\t\u0007I\u0011\u00017\t\u000f\t=u\u0006)A\u0005[\"A!\u0011S\u0018A\u0002\u0013\u0005A\u000eC\u0005\u0003\u0014>\u0002\r\u0011\"\u0001\u0003\u0016\"9!\u0011T\u0018!B\u0013i\u0007\u0002\u0003BN_\t\u0007I\u0011A<\t\u000f\tuu\u0006)A\u0005q\"I!qT\u0018A\u0002\u0013\u0005!\u0011\u0015\u0005\n\u0005k{\u0003\u0019!C\u0001\u0005oC\u0001Ba/0A\u0003&!1\u0015\u0005\n\u0005{{#\u0019!C\u0001\u0005\u007fC\u0001B!60A\u0003%!\u0011\u0019\u0005\n\u0005/|#\u0019!C\u0001\u0005\u007fC\u0001B!70A\u0003%!\u0011\u0019\u0005\n\u00057|\u0003\u0019!C\u0001\u0005;D\u0011B!?0\u0001\u0004%\tAa?\t\u0011\t}x\u0006)Q\u0005\u0005?Dqa!\u00010\t\u0003\u0019\u0019\u0001C\u0004\u0004\f=\"\tE!\u0007\t\u000f\u0005\u0005r\u0006\"\u0001\u0004\u000e!91QC\u0018\u0005\u0002\r]\u0001bBB\u000e_\u0011\u00051Q\u0004\u0005\b\u0007\u001bzC\u0011\u0001B\r\u0011\u001d\u0019ye\fC\u0001\u0007#Bqa!\u00180\t\u0003\u0019y\u0006C\u0004\u0004v=\"\taa\u001e\t\u000f\r}t\u0006\"\u0001\u0004\u0002\"91qS\u0018\u0005\u0002\re\u0005bBBO_\u0011\u00051q\u0014\u0005\b\u0007_{C\u0011\u0001B\r\u0011\u001d\u0019\tl\fC\u0005\u0007gCqaa10\t\u0003\u0019)M\u0002\u0004\u0002n\u0006\u0001\u0011q\u001e\u0005\u0007SF#\t!!=\t\u0013\u0005M\u0018K1A\u0005\n\u0005U\b\u0002\u0003B\u0002#\u0002\u0006I!a>\t\u000f\t\u0015\u0011\u000b\"\u0001\u0003\b!9!1B)\u0005\u0002\t5\u0001b\u0002B\f#\u0012\u0005!\u0011\u0004\u0005\b\u00057\tF\u0011\u0001B\r\u0011\u001d\u0011i\"\u0015C\u0001\u0005?AqA!\u0005R\t\u0003\u0011)#\u0001\rSKBd\u0017nY1uS>t\u0017+^8uCN$Vm\u001d;SS\u001eT\u0011!X\u0001\u0006W\u000647.Y\u0002\u0001!\t\u0001\u0017!D\u0001]\u0005a\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018m\u001d+fgR\u0014\u0016nZ\n\u0003\u0003\r\u0004\"\u0001Z4\u000e\u0003\u0015T\u0011AZ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0016\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001`\u0003\r!\u0017N]\u000b\u0002[B\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\u0005Y\u0006twMC\u0001s\u0003\u0011Q\u0017M^1\n\u0005Q|'AB*ue&tw-\u0001\u0003eSJ\u0004\u0013!A6\u0016\u0003a\u0004\"\u0001Z=\n\u0005i,'aA%oi\u0006\u00111\u000eI\u0001\u0005[\u0006Lg\u000eF\u0002\u007f\u0003\u0007\u0001\"\u0001Z@\n\u0007\u0005\u0005QM\u0001\u0003V]&$\bbBA\u0003\u000f\u0001\u0007\u0011qA\u0001\u0005CJ<7\u000fE\u0003e\u0003\u0013\ti!C\u0002\u0002\f\u0015\u0014Q!\u0011:sCf\u0004B!a\u0004\u0002\u001e9!\u0011\u0011CA\r!\r\t\u0019\"Z\u0007\u0003\u0003+Q1!a\u0006_\u0003\u0019a$o\\8u}%\u0019\u00111D3\u0002\rA\u0013X\rZ3g\u0013\r!\u0018q\u0004\u0006\u0004\u00037)\u0017a\u0001:v]R9a0!\n\u0002h\n\u001d\u0002bBA\u0014\u0011\u0001\u0007\u0011\u0011F\u0001\u0007G>tg-[4\u0011\u0007\u0005-\u0012\"D\u0001\u0002\u00055)\u0005\u0010]3sS6,g\u000e\u001e#fMN1\u0011bYA\u0019\u0003o\u00012\u0001ZA\u001a\u0013\r\t)$\u001a\u0002\b!J|G-^2u!\r!\u0017\u0011H\u0005\u0004\u0003w)'\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00028b[\u0016,\"!!\u0004\u0002\u000b9\fW.\u001a\u0011\u0002\u000f\t\u0014xn[3sg\u0006A!M]8lKJ\u001c\b%\u0001\u0006qCJ$\u0018\u000e^5p]N\f1\u0002]1si&$\u0018n\u001c8tA\u0005AA\u000f\u001b:piRdW-\u0006\u0002\u0002PA\u0019A-!\u0015\n\u0007\u0005MSM\u0001\u0003M_:<\u0017!\u0003;ie>$H\u000f\\3!\u0003Ai7oZ:QKJ\u0004\u0016M\u001d;ji&|g.A\tng\u001e\u001c\b+\u001a:QCJ$\u0018\u000e^5p]\u0002\nq!\\:h'&TX-\u0001\u0005ng\u001e\u001c\u0016N_3!)9\tI#!\u0019\u0002d\u0005\u0015\u0014qMA5\u0003WBq!!\u0010\u0017\u0001\u0004\ti\u0001\u0003\u0004\u0002DY\u0001\r\u0001\u001f\u0005\u0007\u0003\u000f2\u0002\u0019\u0001=\t\u000f\u0005-c\u00031\u0001\u0002P!1\u0011q\u000b\fA\u0002aDa!a\u0017\u0017\u0001\u0004A\u0018A\u0006;be\u001e,GOQ=uKN\u0004VM\u001d\"s_.,'/\u0014\"\u0002/Q\f'oZ3u\u0005f$Xm\u001d)fe\n\u0013xn[3s\u001b\n\u0003\u0013\u0001B2paf$b\"!\u000b\u0002v\u0005]\u0014\u0011PA>\u0003{\ny\bC\u0005\u0002>e\u0001\n\u00111\u0001\u0002\u000e!A\u00111I\r\u0011\u0002\u0003\u0007\u0001\u0010\u0003\u0005\u0002He\u0001\n\u00111\u0001y\u0011%\tY%\u0007I\u0001\u0002\u0004\ty\u0005\u0003\u0005\u0002Xe\u0001\n\u00111\u0001y\u0011!\tY&\u0007I\u0001\u0002\u0004A\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bSC!!\u0004\u0002\b.\u0012\u0011\u0011\u0012\t\u0005\u0003\u0017\u000b)*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0014\u0016\f!\"\u00198o_R\fG/[8o\u0013\u0011\t9*!$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u%f\u0001=\u0002\b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003KSC!a\u0014\u0002\b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*\u0014AD2paf$C-\u001a4bk2$HEN\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111WA]!\r!\u0017QW\u0005\u0004\u0003o+'aA!os\"A\u00111\u0018\u0012\u0002\u0002\u0003\u0007\u00010A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0003\u0004b!a1\u0002J\u0006MVBAAc\u0015\r\t9-Z\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAf\u0003\u000b\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011[Al!\r!\u00171[\u0005\u0004\u0003+,'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003w#\u0013\u0011!a\u0001\u0003g\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002q\u0006AAo\\*ue&tw\rF\u0001n\u0003\u0019)\u0017/^1mgR!\u0011\u0011[As\u0011%\tYlJA\u0001\u0002\u0004\t\u0019\fC\u0004\u0002j\"\u0001\r!a;\u0002\u000f)|WO\u001d8bYB\u0019\u00111F)\u0003\u000f){WO\u001d8bYN\u0011\u0011k\u0019\u000b\u0003\u0003W\f1\u0001\\8h+\t\t9\u0010\u0005\u0003\u0002z\u0006}XBAA~\u0015\r\ti0]\u0001\u0003S>LAA!\u0001\u0002|\n!a)\u001b7f\u0003\u0011awn\u001a\u0011\u0002\u001f\u0005\u0004\b/\u001a8e)>Tu.\u001e:oC2$2A B\u0005\u0011\u001d\t9#\u0016a\u0001\u0003S\t1\"\u00199qK:$7\t[1siR)aPa\u0004\u0003\u0014!9!\u0011\u0003,A\u0002\u00055\u0011\u0001\u00029bi\"DqA!\u0006W\u0001\u0004\t\t.A\u0003gSJ\u001cH/\u0001\u0004iK\u0006$WM\u001d\u000b\u0002}\u00061am\\8uKJ\fa!\u00199qK:$Gc\u0001@\u0003\"!9!1E-A\u0002\u00055\u0011aB7fgN\fw-\u001a\u000b\u0003\u0003\u001bAqA!\u000b\t\u0001\u0004\t\t.A\u000beSN\u0004H.Y=DQ\u0006\u0014Ho](o'\u000e\u0014X-\u001a8\u0002\u001b\u0015C\b/\u001a:j[\u0016tG\u000fR3g!\r\tY#K\n\u0006S\tE\u0012q\u0007\t\u000f\u0005g\u0011I$!\u0004yq\u0006=\u0003\u0010_A\u0015\u001b\t\u0011)DC\u0002\u00038\u0015\fqA];oi&lW-\u0003\u0003\u0003<\tU\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8omQ\u0011!QF\u0001\u0006CB\u0004H.\u001f\u000b\u000f\u0003S\u0011\u0019E!\u0012\u0003H\t%#1\nB'\u0011\u001d\ti\u0004\fa\u0001\u0003\u001bAa!a\u0011-\u0001\u0004A\bBBA$Y\u0001\u0007\u0001\u0010C\u0004\u0002L1\u0002\r!a\u0014\t\r\u0005]C\u00061\u0001y\u0011\u0019\tY\u0006\fa\u0001q\u00069QO\\1qa2LH\u0003\u0002B*\u0005?\u0002R\u0001\u001aB+\u00053J1Aa\u0016f\u0005\u0019y\u0005\u000f^5p]BYAMa\u0017\u0002\u000eaD\u0018q\n=y\u0013\r\u0011i&\u001a\u0002\u0007)V\u0004H.\u001a\u001c\t\u0013\t\u0005T&!AA\u0002\u0005%\u0012a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u00119\u0007E\u0002o\u0005SJ1Aa\u001bp\u0005\u0019y%M[3di\nQQ\t\u001f9fe&lWM\u001c;\u0014\u000b=\u0012\tH! \u0011\t\tM$\u0011P\u0007\u0003\u0005kR1Aa\u001e]\u0003\tQ8.\u0003\u0003\u0003|\tU$\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0003\u0003\u0000\t\u0015UB\u0001BA\u0015\r\u0011\u0019\tX\u0001\u0006kRLGn]\u0005\u0005\u0005\u000f\u0013\tIA\u0004M_\u001e<\u0017N\\4\u0015\u0005\t-\u0005cAA\u0016_\u0005IAo\u001c9jG:\u000bW.Z\u0001\u000bi>\u0004\u0018n\u0019(b[\u0016\u0004\u0013AD3ya\u0016\u0014\u0018.\\3oi:\u000bW.Z\u0001\u0013Kb\u0004XM]5nK:$h*Y7f?\u0012*\u0017\u000fF\u0002\u007f\u0005/C\u0001\"a/5\u0003\u0003\u0005\r!\\\u0001\u0010Kb\u0004XM]5nK:$h*Y7fA\u0005Y\u0001/\u0019:uSRLwN\\%e\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u0003\u001d\u0019XM\u001d<feN,\"Aa)\u0011\r\u0005\r'Q\u0015BU\u0013\u0011\u00119+!2\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003,\nEVB\u0001BW\u0015\r\u0011y\u000bX\u0001\u0007g\u0016\u0014h/\u001a:\n\t\tM&Q\u0016\u0002\f\u0017\u000647.Y*feZ,'/A\u0006tKJ4XM]:`I\u0015\fHc\u0001@\u0003:\"I\u00111X\u001d\u0002\u0002\u0003\u0007!1U\u0001\tg\u0016\u0014h/\u001a:tA\u0005YA.Z1eKJ\u0014\u0016\r^3t+\t\u0011\t\rE\u0004\u0003D\n%\u0007P!4\u000e\u0005\t\u0015'\u0002\u0002Bd\u0003\u000b\fq!\\;uC\ndW-\u0003\u0003\u0003L\n\u0015'aA'baB)A-!\u0003\u0003PB\u0019AM!5\n\u0007\tMWM\u0001\u0004E_V\u0014G.Z\u0001\rY\u0016\fG-\u001a:SCR,7\u000fI\u0001\u000eM>dGn\\<feJ\u000bG/Z:\u0002\u001d\u0019|G\u000e\\8xKJ\u0014\u0016\r^3tA\u0005Y\u0011\rZ7j]\u000ec\u0017.\u001a8u+\t\u0011y\u000e\u0005\u0003\u0003b\nUXB\u0001Br\u0015\u0011\u0011)Oa:\u0002\u000b\u0005$W.\u001b8\u000b\t\t%(1^\u0001\bG2LWM\u001c;t\u0015\ri&Q\u001e\u0006\u0005\u0005_\u0014\t0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0005g\f1a\u001c:h\u0013\u0011\u00119Pa9\u0003\u000b\u0005#W.\u001b8\u0002\u001f\u0005$W.\u001b8DY&,g\u000e^0%KF$2A B\u007f\u0011%\tY\fQA\u0001\u0002\u0004\u0011y.\u0001\u0007bI6Lgn\u00117jK:$\b%\u0001\u0007ti\u0006\u0014HO\u0011:pW\u0016\u00148\u000fF\u0002\u007f\u0007\u000bAqaa\u0002C\u0001\u0004\u0019I!A\u0005ce>\\WM]%egB)\u00111\u0019BSq\u0006AA/Z1s\t><h\u000eF\u0004\u007f\u0007\u001f\u0019\tba\u0005\t\u000f\u0005\u001dB\t1\u0001\u0002*!9\u0011\u0011\u001e#A\u0002\u0005-\bb\u0002B\u0015\t\u0002\u0007\u0011\u0011[\u0001\u0018m\u0006d\u0017\u000eZ1uK\u0006cGn\u00144gg\u0016$8/T1uG\"$2A`B\r\u0011\u001d\t9#\u0012a\u0001\u0003S\t\u0011\u0002\\8h\u001fV$\b/\u001e;\u0015\u000fy\u001cyb!\t\u0004*!9\u0011q\u0005$A\u0002\u0005%\u0002bBB\u0012\r\u0002\u00071QE\u0001\te\u0016\u0004H.[2bgB9\u00111YB\u0014q\u000e%\u0011\u0002\u0002Bf\u0003\u000bDqaa\u000bG\u0001\u0004\u0019i#A\u0007oK^\f5o]5h]6,g\u000e\u001e\t\t\u0003\u0007\u001c9ca\f\u0004<A!1\u0011GB\u001c\u001b\t\u0019\u0019D\u0003\u0003\u00046\t-\u0018AB2p[6|g.\u0003\u0003\u0004:\rM\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0007{\u00199E\u0004\u0003\u0004@\r\rSBAB!\u0015\r\u0011)\u000fX\u0005\u0005\u0007\u000b\u001a\t%A\rSK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:\u001c8i\\7nC:$\u0017\u0002BB%\u0007\u0017\u0012!\"Q:tS\u001etW.\u001a8u\u0015\u0011\u0019)e!\u0011\u0002;]\f\u0017\u000e\u001e$peJ+\u0017m]:jO:lWM\u001c;U_\u000e{W\u000e\u001d7fi\u0016\f1B]3oI\u0016\u00148\t[1siRIapa\u0015\u0004X\re31\f\u0005\b\u0007+B\u0005\u0019\u0001Ba\u0003\u0011!\u0017\r^1\t\u000f\u0005u\u0002\n1\u0001\u0002\u000e!9\u0011\u0011\u001e%A\u0002\u0005-\bb\u0002B\u0015\u0011\u0002\u0007\u0011\u0011[\u0001\u0015[\u0006L(-\u001a#jgBd\u0017-_(o'\u000e\u0014X-\u001a8\u0015\u000by\u001c\tga\u0019\t\u000f\t%\u0012\n1\u0001\u0002R\"91QM%A\u0002\r\u001d\u0014!B2iCJ$\b\u0003BB5\u0007cj!aa\u001b\u000b\t\r\u00154Q\u000e\u0006\u0005\u0007_\u0012\t0A\u0003kMJ,W-\u0003\u0003\u0004t\r-$A\u0003&Ge\u0016,7\t[1si\u0006YqO]5uKR{g)\u001b7f)\u001dq8\u0011PB>\u0007{Bq!!\u0010K\u0001\u0004\ti\u0001C\u0004\u0002j*\u0003\r!a;\t\u000f\r\u0015$\n1\u0001\u0004h\u0005Y1M]3bi\u0016\u001c\u0005.\u0019:u)\u0019\u00199ga!\u0004\u0006\"9\u0011QH&A\u0002\u00055\u0001bBBD\u0017\u0002\u00071\u0011R\u0001\bI\u0006$\u0018m]3u!\u0011\u0019Yia%\u000e\u0005\r5%\u0002BBH\u0007#\u000b!\u0001_=\u000b\t\rU3QN\u0005\u0005\u0007+\u001biI\u0001\nY3N+'/[3t\u0007>dG.Z2uS>t\u0017AD1eI\u0012\u000bG/\u0019+p\u0007\"\f'\u000f\u001e\u000b\u0005\u0007\u0013\u001bY\nC\u0004\u0004V1\u0003\rA!1\u0002\rI,7m\u001c:e)!\u0019\tka)\u0004(\u000e-\u0006#\u00023\u0003V\t5\u0007bBBS\u001b\u0002\u0007!\u0011Y\u0001\u0006e\u0006$Xm\u001d\u0005\u0007\u0007Sk\u0005\u0019\u0001=\u0002\u0011\t\u0014xn[3s\u0013\u0012Dqa!,N\u0001\u0004\u0011y-A\u0006dkJ\u0014XM\u001c;SCR,\u0017\u0001\u00059sS:$(+\u0019;f\u001b\u0016$(/[2t\u00031iW-Y:ve\u0016$'+\u0019;f)\u0019\u0011ym!.\u0004:\"91qW(A\u0002\t%\u0016A\u00022s_.,'\u000fC\u0004\u0004<>\u0003\ra!0\u0002\u000fI,\u0007\u000fV=qKB!!1VB`\u0013\u0011\u0019\tM!,\u0003\u0013E+x\u000e^1UsB,\u0017\u0001\u00026t_:$B!!\u0004\u0004H\"91\u0011\u001a)A\u0002\r-\u0017!\u0002;pa&\u001c\u0007#\u00023\u0004N\u00065\u0011bABhK\nQAH]3qK\u0006$X\r\u001a ")
public final class ReplicationQuotasTestRig {
    public static void run(ExperimentDef experimentDef, Journal journal, boolean bl) {
        ReplicationQuotasTestRig$.MODULE$.run(experimentDef, journal, bl);
    }

    public static void main(String[] stringArray) {
        ReplicationQuotasTestRig$.MODULE$.main(stringArray);
    }

    public static int k() {
        return ReplicationQuotasTestRig$.MODULE$.k();
    }

    public static class Experiment
    extends ZooKeeperTestHarness {
        private final String topicName;
        private String experimentName = "unset";
        private final int partitionId;
        private Seq<KafkaServer> servers = null;
        private final scala.collection.mutable.Map<Object, double[]> leaderRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final scala.collection.mutable.Map<Object, double[]> followerRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private Admin adminClient = null;

        public String topicName() {
            return this.topicName;
        }

        public String experimentName() {
            return this.experimentName;
        }

        public void experimentName_$eq(String x$1) {
            this.experimentName = x$1;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public Seq<KafkaServer> servers() {
            return this.servers;
        }

        public void servers_$eq(Seq<KafkaServer> x$1) {
            this.servers = x$1;
        }

        public scala.collection.mutable.Map<Object, double[]> leaderRates() {
            return this.leaderRates;
        }

        public scala.collection.mutable.Map<Object, double[]> followerRates() {
            return this.followerRates;
        }

        public Admin adminClient() {
            return this.adminClient;
        }

        public void adminClient_$eq(Admin x$1) {
            this.adminClient = x$1;
        }

        public void startBrokers(Seq<Object> brokerIds) {
            Predef$.MODULE$.println((Object)"Starting Brokers");
            this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)brokerIds.map((Function1 & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)i), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
            TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
            String brokerList = TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
            this.adminClient_$eq(Admin.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)brokerList)}))).asJava())));
        }

        @Override
        public void tearDown() {
            Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"adminClient");
            TestUtils$.MODULE$.shutdownServers(this.servers());
            super.tearDown();
        }

        /*
         * WARNING - void declaration
         */
        public void run(ExperimentDef config, Journal journal, boolean displayChartsOnScreen) {
            void var10_10;
            this.experimentName_$eq(config.name());
            Range.Inclusive brokers = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 100 + config.brokers());
            IntRef count = IntRef.create((int)0);
            int shift = Math.round((float)config.brokers() / 2.0f);
            scala.collection.immutable.Map replicas = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), config.partitions()).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)partition))), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Experiment.nextReplicaRoundRobin$1(count, shift, config)}))), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            this.startBrokers((Seq<Object>)brokers);
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)replicas, this.servers());
            Predef$.MODULE$.println((Object)"Writing Data");
            KafkaProducer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 0, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.msgsPerPartition()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.partitions()).foreach((Function1 & Serializable & scala.Serializable)partition -> producer.send(new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)partition)), null, (Object)new byte[config.msgSize()]))));
            Predef$.MODULE$.println((Object)"Generating Reassignment");
            Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment(this.adminClient(), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), brokers.mkString(","), true);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map newAssignment = (Map)tuple2._1();
            Predef$.MODULE$.println((Object)"Starting Reassignment");
            long start = System.currentTimeMillis();
            ReassignPartitionsCommand$.MODULE$.executeAssignment(this.adminClient(), false, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson((Map)var10_10, (Map)scala.collection.Map$.MODULE$.empty()), config.throttle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$6(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$7());
            this.waitForReassignmentToComplete();
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(19).append("Reassignment took ").append((System.currentTimeMillis() - start) / 1000L).append("s").toString());
            this.validateAllOffsetsMatch(config);
            journal.appendToJournal(config);
            this.renderChart(this.leaderRates(), "Leader", journal, displayChartsOnScreen);
            this.renderChart(this.followerRates(), "Follower", journal, displayChartsOnScreen);
            this.logOutput(config, (Map<Object, Seq<Object>>)replicas, (Map<TopicPartition, ReassignPartitionsCommand.Assignment>)var10_10);
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(26).append("Output can be found here: ").append(journal.path()).toString());
        }

        public void validateAllOffsetsMatch(ExperimentDef config) {
            this.servers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                Experiment.$anonfun$validateAllOffsetsMatch$1(this, config, broker);
                return BoxedUnit.UNIT;
            });
        }

        public void logOutput(ExperimentDef config, Map<Object, Seq<Object>> replicas, Map<TopicPartition, ReassignPartitionsCommand.Assignment> newAssignment) {
            Map actual = (Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(17).append("The replicas are ").append(((TraversableLike)replicas.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable & scala.Serializable)x$4 -> new java.lang.StringBuilder(1).append("\n").append(x$4).toString(), Seq$.MODULE$.canBuildFrom())).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(40).append("This is the current replica assignment:\n").append(actual.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int k = x0$1._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom())).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(25).append("proposed assignment is: \n").append(newAssignment).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(39).append("This is the assignment we ended up with").append(actual.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                int k = x0$2._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
                return tuple2;
            }, scala.collection.Map$.MODULE$.canBuildFrom())).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(12).append("numBrokers: ").append(config.brokers()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(15).append("numPartitions: ").append(config.partitions()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(10).append("throttle: ").append(config.throttle()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(25).append("numMessagesPerPartition: ").append(config.msgsPerPartition()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(9).append("msgSize: ").append(config.msgSize()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(35).append("We will write ").append(config.targetBytesPerBrokerMB()).append("MB of data per broker").toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(23).append("Worst case duration is ").append(config.targetBytesPerBrokerMB() * 1000L * 1000L / config.throttle()).toString());
        }

        /*
         * WARNING - void declaration
         */
        public void waitForReassignmentToComplete() {
            long l = 1000L;
            long l2 = 3600000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!Experiment.$anonfun$waitForReassignmentToComplete$1(this)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)Experiment.$anonfun$waitForReassignmentToComplete$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }

        public void renderChart(scala.collection.mutable.Map<Object, double[]> data, String name, Journal journal, boolean displayChartsOnScreen) {
            XYSeriesCollection dataset = this.addDataToChart(data);
            JFreeChart chart = this.createChart(name, dataset);
            this.writeToFile(name, journal, chart);
            this.maybeDisplayOnScreen(displayChartsOnScreen, chart);
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(20).append("Chart generated for ").append(name).toString());
        }

        public void maybeDisplayOnScreen(boolean displayChartsOnScreen, JFreeChart chart) {
            if (displayChartsOnScreen) {
                ChartFrame frame = new ChartFrame(this.experimentName(), chart);
                frame.pack();
                frame.setVisible(true);
            }
        }

        public void writeToFile(String name, Journal journal, JFreeChart chart) {
            File file = new File(ReplicationQuotasTestRig$.MODULE$.kafka$ReplicationQuotasTestRig$$dir(), new java.lang.StringBuilder(5).append(this.experimentName()).append("-").append(name).append(".png").toString());
            ImageIO.write((RenderedImage)chart.createBufferedImage(1000, 700), "png", file);
            journal.appendChart(file.getAbsolutePath(), name == "Leader");
        }

        public JFreeChart createChart(String name, XYSeriesCollection dataset) {
            return ChartFactory.createXYLineChart((String)new java.lang.StringBuilder(26).append(this.experimentName()).append(" - ").append(name).append(" Throttling Performance").toString(), (String)"Time (s)", (String)"Throttle Throughput (B/s)", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        }

        /*
         * WARNING - void declaration
         */
        public XYSeriesCollection addDataToChart(scala.collection.mutable.Map<Object, double[]> data) {
            void var2_2;
            XYSeriesCollection dataset = new XYSeriesCollection();
            data.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Experiment.$anonfun$addDataToChart$1(dataset, x0$1);
                return BoxedUnit.UNIT;
            });
            return var2_2;
        }

        public Option<double[]> record(scala.collection.mutable.Map<Object, double[]> rates, int brokerId, double currentRate) {
            double[] leaderRatesBroker = (double[])rates.getOrElse((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable & scala.Serializable)() -> (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double()));
            leaderRatesBroker = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(leaderRatesBroker)).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(new double[]{currentRate})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            return rates.put((Object)BoxesRunTime.boxToInteger((int)brokerId), (Object)leaderRatesBroker);
        }

        public void printRateMetrics() {
            this.servers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
                Experiment.$anonfun$printRateMetrics$1(this, broker);
                return BoxedUnit.UNIT;
            });
        }

        private double measuredRate(KafkaServer broker, QuotaType repType) {
            MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
            if (((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).contains((Object)metricName)) {
                return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).apply((Object)metricName)).metricValue());
            }
            return -1.0;
        }

        public String json(Seq<String> topic) {
            String topicStr = ((TraversableOnce)topic.map((Function1 & Serializable & scala.Serializable)t -> new java.lang.StringBuilder(13).append("{\"topic\": \"").append((String)t).append("\"}").toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
            return new java.lang.StringBuilder(26).append("{\"topics\": [").append(topicStr).append("],\"version\":1}").toString();
        }

        private static final int nextReplicaRoundRobin$1(IntRef count$1, int shift$1, ExperimentDef config$1) {
            ++count$1.elem;
            return 100 + (count$1.elem + shift$1) % config$1.brokers();
        }

        public static final /* synthetic */ void $anonfun$validateAllOffsetsMatch$1(Experiment $this, ExperimentDef config$2, KafkaServer broker) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config$2.partitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
                boolean x$22;
                TopicPartition x$1;
                LogManager qual$1 = broker.getLogManager();
                long offset = BoxesRunTime.unboxToLong((Object)qual$1.getLog(x$1 = new TopicPartition($this.topicName(), partitionId), x$22 = qual$1.getLog$default$2()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.logEndOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
                if (offset >= 0L && offset != (long)config$2.msgsPerPartition()) {
                    throw new RuntimeException(new java.lang.StringBuilder(82).append("Run failed as offsets did not match for partition ").append(partitionId).append(" on broker ").append(broker.config().brokerId()).append(". Expected ").append(config$2.msgsPerPartition()).append(" but was ").append(offset).append(".").toString());
                }
            });
        }

        public static final /* synthetic */ boolean $anonfun$waitForReassignmentToComplete$1(Experiment $this) {
            $this.printRateMetrics();
            return ((java.util.Map)$this.adminClient().listPartitionReassignments().reassignments().get()).isEmpty();
        }

        public static final /* synthetic */ String $anonfun$waitForReassignmentToComplete$2() {
            return "Partition reassignments didn't complete.";
        }

        public static final /* synthetic */ void $anonfun$addDataToChart$1(XYSeriesCollection dataset$1, Tuple2 x0$1) {
            if (x0$1 != null) {
                int broker = x0$1._1$mcI$sp();
                double[] values = (double[])x0$1._2();
                XYSeries series = new XYSeries((Comparable)((Object)new java.lang.StringBuilder(7).append("Broker:").append(broker).toString()));
                IntRef x = IntRef.create((int)0);
                new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values)).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)value -> {
                    series.add((double)x$5.elem, value);
                    ++x$5.elem;
                });
                dataset$1.addSeries(series);
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printRateMetrics$1(Experiment $this, KafkaServer broker) {
            double leaderRate = $this.measuredRate(broker, (QuotaType)QuotaType.LeaderReplication$.MODULE$);
            if (broker.config().brokerId() == 100) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(33).append("waiting... Leader rate on 101 is ").append(leaderRate).toString());
            }
            $this.record($this.leaderRates(), broker.config().brokerId(), leaderRate);
            if (leaderRate > 0.0) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(19).append("Leader Rate on ").append(broker.config().brokerId()).append(" is ").append(leaderRate).toString());
            }
            double followerRate = $this.measuredRate(broker, (QuotaType)QuotaType.FollowerReplication$.MODULE$);
            $this.record($this.followerRates(), broker.config().brokerId(), followerRate);
            if (followerRate > 0.0) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(21).append("Follower Rate on ").append(broker.config().brokerId()).append(" is ").append(followerRate).toString());
            }
        }

        public Experiment() {
            this.topicName = "my-topic";
            this.partitionId = 0;
        }
    }

    public static class ExperimentDef
    implements Product,
    scala.Serializable {
        private final String name;
        private final int brokers;
        private final int partitions;
        private final long throttle;
        private final int msgsPerPartition;
        private final int msgSize;
        private final long targetBytesPerBrokerMB;

        public String name() {
            return this.name;
        }

        public int brokers() {
            return this.brokers;
        }

        public int partitions() {
            return this.partitions;
        }

        public long throttle() {
            return this.throttle;
        }

        public int msgsPerPartition() {
            return this.msgsPerPartition;
        }

        public int msgSize() {
            return this.msgSize;
        }

        public long targetBytesPerBrokerMB() {
            return this.targetBytesPerBrokerMB;
        }

        public ExperimentDef copy(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            return new ExperimentDef(name, brokers, partitions, throttle, msgsPerPartition, msgSize);
        }

        public String copy$default$1() {
            return this.name();
        }

        public int copy$default$2() {
            return this.brokers();
        }

        public int copy$default$3() {
            return this.partitions();
        }

        public long copy$default$4() {
            return this.throttle();
        }

        public int copy$default$5() {
            return this.msgsPerPartition();
        }

        public int copy$default$6() {
            return this.msgSize();
        }

        public String productPrefix() {
            return "ExperimentDef";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.brokers());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this.partitions());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this.throttle());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this.msgsPerPartition());
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this.msgSize());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExperimentDef;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.name())), (int)this.brokers()), (int)this.partitions()), (int)Statics.longHash((long)this.throttle())), (int)this.msgsPerPartition()), (int)this.msgSize()), (int)6);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ExperimentDef)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExperimentDef experimentDef = (ExperimentDef)x$1;
            String string = this.name();
            String string2 = experimentDef.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.brokers() != experimentDef.brokers()) return false;
            if (this.partitions() != experimentDef.partitions()) return false;
            if (this.throttle() != experimentDef.throttle()) return false;
            if (this.msgsPerPartition() != experimentDef.msgsPerPartition()) return false;
            if (this.msgSize() != experimentDef.msgSize()) return false;
            if (!experimentDef.canEqual(this)) return false;
            return true;
        }

        public ExperimentDef(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            this.name = name;
            this.brokers = brokers;
            this.partitions = partitions;
            this.throttle = throttle;
            this.msgsPerPartition = msgsPerPartition;
            this.msgSize = msgSize;
            Product.$init$((Product)this);
            this.targetBytesPerBrokerMB = (long)msgsPerPartition * (long)msgSize * (long)partitions / (long)brokers / 1000000L;
        }
    }

    public static class Journal {
        private final File log = new File(ReplicationQuotasTestRig$.MODULE$.kafka$ReplicationQuotasTestRig$$dir(), "Log.html");

        private File log() {
            return this.log;
        }

        public void appendToJournal(ExperimentDef config) {
            double arg$macro$1 = config.throttle();
            double arg$macro$2 = config.msgsPerPartition();
            double arg$macro$3 = config.msgSize();
            String message = new java.lang.StringBuilder(82).append("\n\n<h3>").append(config.name()).append("</h3>").append("<p>- BrokerCount: ").append(config.brokers()).append("<p>- PartitionCount: ").append(config.partitions()).append(new StringOps("<p>- Throttle: %,.0f MB/s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}))).append(new StringOps("<p>- MsgCount: %,.0f ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$2)}))).append(new StringOps("<p>- MsgSize: %,.0f").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}))).append("<p>- TargetBytesPerBrokerMB: ").append(config.targetBytesPerBrokerMB()).append("<p>").toString();
            this.append(message);
        }

        public void appendChart(String path, boolean first) {
            StringBuilder message = new StringBuilder();
            if (first) {
                message.append("<p><p>");
            }
            message.append(new java.lang.StringBuilder(72).append("<img src=\"").append(path).append("\" alt=\"Chart\" style=\"width:600px;height:400px;align=\"middle\"\">").toString());
            if (!first) {
                message.append("<p><p>");
            }
            this.append(message.toString());
        }

        public void header() {
            this.append("<html><head><h1>Replication Quotas Test Rig</h1></head><body>");
        }

        public void footer() {
            this.append("</body></html>");
        }

        public void append(String message) {
            OutputStream stream = Files.newOutputStream(this.log().toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            new PrintWriter(null, stream, message){
                {
                    this.append(message$1);
                    this.close();
                }
            };
        }

        public String path() {
            return this.log().getAbsolutePath();
        }

        public Journal() {
            this.header();
        }
    }
}

