/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import joptsimple.OptionException;
import kafka.admin.ClusterLinkCommand$;
import kafka.admin.ClusterLinkCommandOptions;
import kafka.server.link.ClusterLinkConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.CreateClusterLinksOptions;
import org.apache.kafka.clients.admin.CreateClusterLinksResult;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.clients.admin.ListClusterLinksResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0014)\u00055BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011\b\u0003\u0004C\u0001\u0001\u0006IA\u000f\u0005\b\u0007\u0002\u0011\r\u0011\"\u0001:\u0011\u0019!\u0005\u0001)A\u0005u!9Q\t\u0001b\u0001\n\u00031\u0005BB)\u0001A\u0003%q\tC\u0004S\u0001\t\u0007I\u0011\u0001$\t\rM\u0003\u0001\u0015!\u0003H\u0011\u001d!\u0006A1A\u0005\u0002\u0019Ca!\u0016\u0001!\u0002\u00139\u0005\"\u0002,\u0001\t\u00139\u0006B\u0002=\u0001\t\u0013\t)\u0005C\u0005\u0002l\u0001\t\n\u0011\"\u0003\u0002n!I\u00111\u0011\u0001\u0012\u0002\u0013%\u0011Q\u000e\u0005\n\u0003\u000b\u0003\u0011\u0013!C\u0005\u0003\u000fC\u0011\"a#\u0001#\u0003%I!a\"\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\"9\u0011q\u0015\u0001\u0005\u0002\u0005=\u0005bBAV\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003_\u0003A\u0011AAH\u0011\u001d\t\u0019\f\u0001C\u0001\u0003\u001fCq!a\u0007\u0001\t\u0013\t9\fC\u0004\u0002D\u0002!\t!a$\t\u000f\u00055\u0002\u0001\"\u0003\u0002H\"I\u0011\u0011\u001b\u0001\u0012\u0002\u0013%\u0011Q\u000e\u0005\n\u0003'\u0004\u0011\u0013!C\u0005\u0003[Bq!!6\u0001\t\u0003\ty\tC\u0004\u0002Z\u0002!\t!a$\t\u000f\u0005u\u0007\u0001\"\u0001\u0002\u0010\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005=\u0005bBAs\u0001\u0011\u0005\u0011q\u0012\u0004\u0005C\u0002\u0001!\r\u0003\u0005pC\t\u0005\t\u0015!\u0003q\u0011\u0015!\u0014\u0005\"\u0001w\u0011\u0015A\u0018\u0005\"\u0011z\u0011\u001d\tY\"\tC!\u0003;Aq!!\f\"\t\u0003\nyC\u0001\fDYV\u001cH/\u001a:MS:\\7i\\7nC:$G+Z:u\u0015\tI#&A\u0003bI6LgNC\u0001,\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0007\u0005\u00028\u00015\t\u0001&A\u0005d_6\u0004H.\u001a;fIV\t!\b\u0005\u0002<\u00016\tAH\u0003\u0002>}\u0005!A.\u00198h\u0015\u0005y\u0014\u0001\u00026bm\u0006L!!\u0011\u001f\u0003\rM#(/\u001b8h\u0003)\u0019w.\u001c9mKR,G\rI\u0001\nm\u0006d\u0017\u000eZ1uK\u0012\f!B^1mS\u0012\fG/\u001a3!\u0003)ygMZ:fi*\u001bxN\\\u000b\u0002\u000fB\u0011\u0001j\u0014\b\u0003\u00136\u0003\"A\u0013\u0019\u000e\u0003-S!\u0001\u0014\u0017\u0002\rq\u0012xn\u001c;?\u0013\tq\u0005'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0003BS!A\u0014\u0019\u0002\u0017=4gm]3u\u0015N|g\u000eI\u0001\bC\u000ed'j]8o\u0003!\t7\r\u001c&t_:\u0004\u0013A\u0003;pa&\u001c7OS:p]\u0006YAo\u001c9jGNT5o\u001c8!\u0003)\u0011XO\\\"p[6\fg\u000e\u001a\u000b\u0004\u000fbk\u0006\"B-\r\u0001\u0004Q\u0016\u0001B1sON\u00042aL.H\u0013\ta\u0006GA\u0003BeJ\f\u0017\u0010C\u0003_\u0019\u0001\u0007q,A\bn_\u000e\\\u0017\tZ7j]\u000ec\u0017.\u001a8u!\t\u0001\u0017%D\u0001\u0001\u0005=!Vm\u001d;BI6Lgn\u00117jK:$8CA\u0011d!\t!W.D\u0001f\u0015\tIcM\u0003\u0002hQ\u000691\r\\5f]R\u001c(BA\u0016j\u0015\tQ7.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0006\u0019qN]4\n\u00059,'aD'pG.\fE-\\5o\u00072LWM\u001c;\u0002\t9|G-\u001a\t\u0003cRl\u0011A\u001d\u0006\u0003g\"\faaY8n[>t\u0017BA;s\u0005\u0011qu\u000eZ3\u0015\u0005};\b\"B8$\u0001\u0004\u0001\u0018AE2sK\u0006$Xm\u00117vgR,'\u000fT5oWN$BA_?\u0002\u0012A\u0011Am_\u0005\u0003y\u0016\u0014\u0001d\u0011:fCR,7\t\\;ti\u0016\u0014H*\u001b8lgJ+7/\u001e7u\u0011\u0015qH\u00051\u0001\u0000\u00031\u0019G.^:uKJd\u0015N\\6t!\u0019\t\t!a\u0002\u0002\f5\u0011\u00111\u0001\u0006\u0004\u0003\u000bq\u0014\u0001B;uS2LA!!\u0003\u0002\u0004\tQ1i\u001c7mK\u000e$\u0018n\u001c8\u0011\u0007\u0011\fi!C\u0002\u0002\u0010\u0015\u0014aBT3x\u00072,8\u000f^3s\u0019&t7\u000eC\u0004\u0002\u0014\u0011\u0002\r!!\u0006\u0002\u000f=\u0004H/[8ogB\u0019A-a\u0006\n\u0007\u0005eQMA\rDe\u0016\fG/Z\"mkN$XM\u001d'j].\u001cx\n\u001d;j_:\u001c\u0018\u0001\u00057jgR\u001cE.^:uKJd\u0015N\\6t)\u0011\ty\"!\n\u0011\u0007\u0011\f\t#C\u0002\u0002$\u0015\u0014a\u0003T5ti\u000ecWo\u001d;fe2Kgn[:SKN,H\u000e\u001e\u0005\b\u0003')\u0003\u0019AA\u0014!\r!\u0017\u0011F\u0005\u0004\u0003W)'a\u0006'jgR\u001cE.^:uKJd\u0015N\\6t\u001fB$\u0018n\u001c8t\u0003I!W\r\\3uK\u000ecWo\u001d;fe2Kgn[:\u0015\r\u0005E\u0012qGA\u001f!\r!\u00171G\u0005\u0004\u0003k)'\u0001\u0007#fY\u0016$Xm\u00117vgR,'\u000fT5oWN\u0014Vm];mi\"9\u0011\u0011\b\u0014A\u0002\u0005m\u0012!\u00037j].t\u0015-\\3t!\u0015\t\t!a\u0002H\u0011\u001d\t\u0019B\na\u0001\u0003\u007f\u00012\u0001ZA!\u0013\r\t\u0019%\u001a\u0002\u001a\t\u0016dW\r^3DYV\u001cH/\u001a:MS:\\7o\u00149uS>t7\u000f\u0006\u0007\u0002H\u00055\u0013qJA-\u0003;\n9\u0007E\u00020\u0003\u0013J1!a\u00131\u0005\u0011)f.\u001b;\t\u000bek\u0001\u0019\u0001.\t\u0013\u0005ES\u0002%AA\u0002\u0005M\u0013AE3ya\u0016\u001cGOV1mS\u0012\fG/Z(oYf\u00042aLA+\u0013\r\t9\u0006\r\u0002\b\u0005>|G.Z1o\u0011%\tY&\u0004I\u0001\u0002\u0004\t\u0019&\u0001\nfqB,7\r\u001e,bY&$\u0017\r^3MS:\\\u0007\"CA0\u001bA\u0005\t\u0019AA1\u0003E\tG\rZ5uS>t\u0017\r\\\"p]\u001aLwm\u001d\t\u0006\u0011\u0006\rtiR\u0005\u0004\u0003K\u0002&aA'ba\"I\u0011\u0011N\u0007\u0011\u0002\u0003\u0007\u0011\u0011M\u0001\u0010Kb\u0004Xm\u0019;fI\u000e{gNZ5hg\u0006a2M]3bi\u0016\u001cE.^:uKJd\u0015N\\6tI\u0011,g-Y;mi\u0012\u0012TCAA8U\u0011\t\u0019&!\u001d,\u0005\u0005M\u0004\u0003BA;\u0003\u007fj!!a\u001e\u000b\t\u0005e\u00141P\u0001\nk:\u001c\u0007.Z2lK\u0012T1!! 1\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\u000b9HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAd\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8lg\u0012\"WMZ1vYR$3'\u0001\u000fde\u0016\fG/Z\"mkN$XM\u001d'j].\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005%%\u0006BA1\u0003c\nAd\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8lg\u0012\"WMZ1vYR$S'A\u0016uKN$8I]3bi\u0016\u001cE.^:uKJd\u0015N\\6t/&$\bn\u00144gg\u0016$8+\u001f8d\u0007>tg-[4t)\t\t9\u0005K\u0002\u0013\u0003'\u0003B!!&\u0002$6\u0011\u0011q\u0013\u0006\u0005\u00033\u000bY*A\u0002ba&TA!!(\u0002 \u00069!.\u001e9ji\u0016\u0014(bAAQW\u0006)!.\u001e8ji&!\u0011QUAL\u0005\u0011!Vm\u001d;\u0002QQ,7\u000f^\"sK\u0006$Xm\u00117vgR,'\u000fT5oWN<\u0016\u000e\u001e5BG2\u001c\u0016P\\2D_:4\u0017nZ:)\u0007M\t\u0019*\u0001\u0018uKN$8I]3bi\u0016\u001cE.^:uKJd\u0015N\\6t/&$\b.Q;u_6K'O]8sS:<7i\u001c8gS\u001e\u001c\bf\u0001\u000b\u0002\u0014\u0006\tD/Z:u\u0007J,\u0017\r^3DYV\u001cH/\u001a:MS:\\7oV5uQ>3gm]3u\u0003:$\u0017i\u00197Ts:\u001c7i\u001c8gS\u001e\u001c\bfA\u000b\u0002\u0014\u00061B/Z:u\u0007J,\u0017\r^3DYV\u001cH/\u001a:MS:\\7\u000fK\u0002\u0017\u0003'#\u0002\"a\u0012\u0002:\u0006m\u0016q\u0018\u0005\u00063^\u0001\rA\u0017\u0005\b\u0003{;\u0002\u0019AA*\u0003-A\u0017m\u001d'j].t\u0015-\\3\t\u000f\u0005\u0005w\u00031\u0001\u0002T\u0005i\u0011N\\2mk\u0012,Gk\u001c9jGN\fA\u0003^3ti2K7\u000f^\"mkN$XM\u001d'j].\u001c\bf\u0001\r\u0002\u0014RA\u0011qIAe\u0003\u0017\fi\rC\u0003Z3\u0001\u0007!\fC\u0005\u0002Re\u0001\n\u00111\u0001\u0002T!I\u0011qZ\r\u0011\u0002\u0003\u0007\u00111K\u0001\fKb\u0004Xm\u0019;G_J\u001cW-\u0001\u000feK2,G/Z\"mkN$XM\u001d'j].\u001cH\u0005Z3gCVdG\u000f\n\u001a\u00029\u0011,G.\u001a;f\u00072,8\u000f^3s\u0019&t7n\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u00051B/Z:u\t\u0016dW\r^3DYV\u001cH/\u001a:MS:\\7\u000fK\u0002\u001d\u0003'\u000bq\u0002^3ti\n\u000bGmQ8n[\u0006tGm\u001d\u0015\u0004;\u0005M\u0015A\u0004;fgR\u0014\u0015\rZ\"p]\u001aLwm\u001d\u0015\u0004=\u0005M\u0015a\u0006;fgRl\u0015n]:j]\u001e\u0014V-];je\u0016$\u0017I]4tQ\ry\u00121S\u0001\u0010i\u0016\u001cH/\u00138wC2LG-\u0011:hg\"\u001a\u0001%a%")
public final class ClusterLinkCommandTest {
    private final String completed;
    private final String validated;
    private final String offsetJson = new StringOps(Predef$.MODULE$.augmentString("{\n      |\"groupFilters\": [{\n      |     \"name\": \"*\",\n      |     \"patternType\": \"LITERAL\",\n      |     \"filterType\": \"INCLUDE\"\n      |  },\n      |  {\n      |     \"name\": \"excluded\",\n      |     \"patternType\": \"PREFIXED\",\n      |     \"filterType\": \"EXCLUDE\"\n      |  }]\n      | }")).stripMargin();
    private final String aclJson = new StringOps(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\"\n      |    }\n      |  }]\n      | }")).stripMargin();
    private final String topicsJson = new StringOps(Predef$.MODULE$.augmentString("{\n      |\"topicFilters\": [{\n      |     \"name\": \"*\",\n      |     \"patternType\": \"LITERAL\",\n      |     \"filterType\": \"INCLUDE\"\n      |  },\n      |  {\n      |     \"name\": \"excluded\",\n      |     \"patternType\": \"PREFIXED\",\n      |     \"filterType\": \"EXCLUDE\"\n      |  }]\n      | }")).stripMargin();

    public String completed() {
        return this.completed;
    }

    public String validated() {
        return this.validated;
    }

    public String offsetJson() {
        return this.offsetJson;
    }

    public String aclJson() {
        return this.aclJson;
    }

    public String topicsJson() {
        return this.topicsJson;
    }

    /*
     * WARNING - void declaration
     */
    private String runCommand(String[] args, TestAdminClient mockAdminClient) {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ClusterLinkCommand$.MODULE$.run((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", "localhost:9092"})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), (Option)new Some((Object)mockAdminClient));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    private void createClusterLinks(String[] args, boolean expectValidateOnly, boolean expectValidateLink, scala.collection.immutable.Map<String, String> additionalConfigs, scala.collection.immutable.Map<String, String> expectedConfigs) {
        String linkName = "test-link";
        String clusterId = "test-cluster-id";
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(null);
        CreateClusterLinksResult result = (CreateClusterLinksResult)EasyMock.createNiceMock(CreateClusterLinksResult.class);
        EasyMock.expect((Object)result.all()).andReturn((Object)future).once();
        scala.collection.immutable.Map configs = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"10.20.30.40:9092"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request.timeout.ms"), (Object)"100000")}))).$plus$plus(additionalConfigs);
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedCommand, linkName, clusterId, configs, expectedConfigs, expectValidateOnly, expectValidateLink, result){
            private final BooleanRef issuedCommand$1;
            private final String linkName$1;
            private final String clusterId$1;
            private final scala.collection.immutable.Map configs$1;
            private final scala.collection.immutable.Map expectedConfigs$1;
            private final boolean expectValidateOnly$1;
            private final boolean expectValidateLink$1;
            private final CreateClusterLinksResult result$1;

            public CreateClusterLinksResult createClusterLinks(Collection<NewClusterLink> clusterLinks, CreateClusterLinksOptions options) {
                this.issuedCommand$1.elem = true;
                Assertions.assertEquals((int)1, (int)clusterLinks.size());
                NewClusterLink newClusterLink = clusterLinks.iterator().next();
                Assertions.assertEquals((Object)this.linkName$1, (Object)newClusterLink.linkName());
                Assertions.assertEquals((Object)this.clusterId$1, (Object)newClusterLink.clusterId());
                Assertions.assertEquals((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)this.configs$1.$plus$plus((GenTraversableOnce)this.expectedConfigs$1)).asJava(), (Object)newClusterLink.configs());
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.expectValidateOnly$1), (Object)BoxesRunTime.boxToBoolean((boolean)options.validateOnly()));
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.expectValidateLink$1), (Object)BoxesRunTime.boxToBoolean((boolean)options.validateLink()));
                return this.result$1;
            }
            {
                this.issuedCommand$1 = issuedCommand$1;
                this.linkName$1 = linkName$1;
                this.clusterId$1 = clusterId$1;
                this.configs$1 = configs$1;
                this.expectedConfigs$1 = expectedConfigs$1;
                this.expectValidateOnly$1 = expectValidateOnly$1;
                this.expectValidateLink$1 = expectValidateLink$1;
                this.result$1 = result$1;
                super(node$1);
            }
        };
        EasyMock.replay((Object[])new Object[]{result});
        String output = this.runCommand((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--create", "--link", linkName, "--cluster-id", clusterId, "--config", ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString(), Iterable$.MODULE$.canBuildFrom())).mkString(",")})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        EasyMock.reset((Object[])new Object[]{result});
        String expectedOutput = expectValidateOnly ? this.validated() : this.completed();
        Assertions.assertTrue((boolean)output.contains(expectedOutput));
    }

    private boolean createClusterLinks$default$2() {
        return false;
    }

    private boolean createClusterLinks$default$3() {
        return true;
    }

    private scala.collection.immutable.Map<String, String> createClusterLinks$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    private scala.collection.immutable.Map<String, String> createClusterLinks$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    @Test
    public void testCreateClusterLinksWithOffsetSyncConfigs() {
        String[] x$1 = (String[])((Object[])new String[]{"--consumer-group-filters-json", this.offsetJson()});
        scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.offsetJson())}));
        boolean x$4 = this.createClusterLinks$default$2();
        boolean x$5 = this.createClusterLinks$default$3();
        this.createClusterLinks(x$1, x$4, x$5, (scala.collection.immutable.Map<String, String>)x$2, (scala.collection.immutable.Map<String, String>)x$3);
        String[] x$6 = (String[])((Object[])new String[]{"--consumer-group-filters-json", this.offsetJson(), "--validate-only"});
        scala.collection.immutable.Map x$7 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Map x$8 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.offsetJson())}));
        boolean x$9 = true;
        boolean x$10 = this.createClusterLinks$default$3();
        this.createClusterLinks(x$6, x$9, x$10, (scala.collection.immutable.Map<String, String>)x$7, (scala.collection.immutable.Map<String, String>)x$8);
        String[] x$11 = (String[])((Object[])new String[]{"--consumer-group-filters-json", this.offsetJson(), "--exclude-validate-link"});
        scala.collection.immutable.Map x$12 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Map x$13 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.offsetJson())}));
        boolean x$14 = false;
        boolean x$15 = this.createClusterLinks$default$2();
        this.createClusterLinks(x$11, x$15, x$14, (scala.collection.immutable.Map<String, String>)x$12, (scala.collection.immutable.Map<String, String>)x$13);
    }

    @Test
    public void testCreateClusterLinksWithAclSyncConfigs() {
        String[] x$1 = (String[])((Object[])new String[]{"--acl-filters-json", this.aclJson()});
        scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.aclJson())}));
        boolean x$4 = this.createClusterLinks$default$2();
        boolean x$5 = this.createClusterLinks$default$3();
        this.createClusterLinks(x$1, x$4, x$5, (scala.collection.immutable.Map<String, String>)x$2, (scala.collection.immutable.Map<String, String>)x$3);
        String[] x$6 = (String[])((Object[])new String[]{"--acl-filters-json", this.aclJson(), "--validate-only"});
        scala.collection.immutable.Map x$7 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Map x$8 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.aclJson())}));
        boolean x$9 = true;
        boolean x$10 = this.createClusterLinks$default$3();
        this.createClusterLinks(x$6, x$9, x$10, (scala.collection.immutable.Map<String, String>)x$7, (scala.collection.immutable.Map<String, String>)x$8);
        String[] x$11 = (String[])((Object[])new String[]{"--acl-filters-json", this.aclJson(), "--exclude-validate-link"});
        scala.collection.immutable.Map x$12 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Map x$13 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.aclJson())}));
        boolean x$14 = false;
        boolean x$15 = this.createClusterLinks$default$2();
        this.createClusterLinks(x$11, x$15, x$14, (scala.collection.immutable.Map<String, String>)x$12, (scala.collection.immutable.Map<String, String>)x$13);
    }

    @Test
    public void testCreateClusterLinksWithAutoMirroringConfigs() {
        String[] x$1 = (String[])((Object[])new String[]{"--topic-filters-json", this.topicsJson()});
        scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true")}));
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicsJson())}));
        boolean x$4 = this.createClusterLinks$default$2();
        boolean x$5 = this.createClusterLinks$default$3();
        this.createClusterLinks(x$1, x$4, x$5, (scala.collection.immutable.Map<String, String>)x$2, (scala.collection.immutable.Map<String, String>)x$3);
        String[] x$6 = (String[])((Object[])new String[]{"--topic-filters-json", this.topicsJson(), "--validate-only"});
        scala.collection.immutable.Map x$7 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true")}));
        scala.collection.immutable.Map x$8 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicsJson())}));
        boolean x$9 = true;
        boolean x$10 = this.createClusterLinks$default$3();
        this.createClusterLinks(x$6, x$9, x$10, (scala.collection.immutable.Map<String, String>)x$7, (scala.collection.immutable.Map<String, String>)x$8);
        String[] x$11 = (String[])((Object[])new String[]{"--topic-filters-json", this.topicsJson(), "--exclude-validate-link"});
        scala.collection.immutable.Map x$12 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true")}));
        scala.collection.immutable.Map x$13 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)this.topicsJson())}));
        boolean x$14 = false;
        boolean x$15 = this.createClusterLinks$default$2();
        this.createClusterLinks(x$11, x$15, x$14, (scala.collection.immutable.Map<String, String>)x$12, (scala.collection.immutable.Map<String, String>)x$13);
    }

    @Test
    public void testCreateClusterLinksWithOffsetAndAclSyncConfigs() {
        String[] x$1 = (String[])((Object[])new String[]{"--acl-filters-json", this.aclJson(), "--consumer-group-filters-json", this.offsetJson()});
        scala.collection.immutable.Map x$2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.aclJson()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.offsetJson())}));
        boolean x$4 = this.createClusterLinks$default$2();
        boolean x$5 = this.createClusterLinks$default$3();
        this.createClusterLinks(x$1, x$4, x$5, (scala.collection.immutable.Map<String, String>)x$2, (scala.collection.immutable.Map<String, String>)x$3);
        String[] x$6 = (String[])((Object[])new String[]{"--acl-filters-json", this.aclJson(), "--consumer-group-filters-json", this.offsetJson(), "--validate-only"});
        scala.collection.immutable.Map x$7 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Map x$8 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.aclJson()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.offsetJson())}));
        boolean x$9 = true;
        boolean x$10 = this.createClusterLinks$default$3();
        this.createClusterLinks(x$6, x$9, x$10, (scala.collection.immutable.Map<String, String>)x$7, (scala.collection.immutable.Map<String, String>)x$8);
        String[] x$11 = (String[])((Object[])new String[]{"--acl-filters-json", this.aclJson(), "--consumer-group-filters-json", this.offsetJson(), "--exclude-validate-link"});
        scala.collection.immutable.Map x$12 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}));
        scala.collection.immutable.Map x$13 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.aclJson()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)this.offsetJson())}));
        boolean x$14 = false;
        boolean x$15 = this.createClusterLinks$default$2();
        this.createClusterLinks(x$11, x$15, x$14, (scala.collection.immutable.Map<String, String>)x$12, (scala.collection.immutable.Map<String, String>)x$13);
    }

    @Test
    public void testCreateClusterLinks() {
        this.createClusterLinks((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), this.createClusterLinks$default$2(), this.createClusterLinks$default$3(), this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        this.createClusterLinks((String[])((Object[])new String[]{"--validate-only"}), true, this.createClusterLinks$default$3(), this.createClusterLinks$default$4(), this.createClusterLinks$default$5());
        String[] x$1 = (String[])((Object[])new String[]{"--exclude-validate-link"});
        boolean x$2 = false;
        boolean x$3 = this.createClusterLinks$default$2();
        scala.collection.immutable.Map<String, String> x$4 = this.createClusterLinks$default$4();
        scala.collection.immutable.Map<String, String> x$5 = this.createClusterLinks$default$5();
        this.createClusterLinks(x$1, x$3, x$2, x$4, x$5);
    }

    /*
     * WARNING - void declaration
     */
    private void listClusterLinks(String[] args, boolean hasLinkName, boolean includeTopics) {
        void var8_11;
        void var7_10;
        void var6_9;
        void var5_8;
        Optional optional;
        Optional optional2;
        Optional optional3;
        Optional optional4;
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        if (includeTopics) {
            optional4 = ClusterLinkCommandTest.toTopics$1((Option)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic-1", "topic-2", "topic-3"}))));
            optional3 = ClusterLinkCommandTest.toTopics$1((Option)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic-4", "topic-5", "topic-6"}))));
            optional2 = ClusterLinkCommandTest.toTopics$1((Option)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic-7", "topic-8", "topic-9"}))));
            optional = ClusterLinkCommandTest.toTopics$1((Option)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic-10", "topic-11", "topic-12"}))));
        } else {
            optional4 = ClusterLinkCommandTest.toTopics$1((Option)None$.MODULE$);
            optional3 = ClusterLinkCommandTest.toTopics$1((Option)None$.MODULE$);
            optional2 = ClusterLinkCommandTest.toTopics$1((Option)None$.MODULE$);
            optional = ClusterLinkCommandTest.toTopics$1((Option)None$.MODULE$);
        }
        Optional optional5 = optional;
        Optional optional6 = optional2;
        Optional optional7 = optional3;
        Optional topics1 = optional4;
        Optional topics2 = optional7;
        Optional topics3 = optional6;
        Optional topics4 = optional5;
        void topics12 = var5_8;
        void topics22 = var6_9;
        void topics32 = var7_10;
        void topics42 = var8_11;
        ClusterLinkListing link1 = new ClusterLinkListing("link-1", UUID.randomUUID(), "cluster-id-1", "cluster-id-2", (Optional)topics12, true);
        ClusterLinkListing link2 = new ClusterLinkListing("link-2", UUID.randomUUID(), null, "cluster-id-2", (Optional)topics22, true);
        ClusterLinkListing link3 = new ClusterLinkListing("link-3", UUID.randomUUID(), "cluster-id-3", null, (Optional)topics32, true);
        ClusterLinkListing link4 = new ClusterLinkListing("link-4", UUID.randomUUID(), null, null, (Optional)topics42, true);
        scala.collection.immutable.Set listing = hasLinkName ? (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClusterLinkListing[]{link1})) : (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClusterLinkListing[]{link1, link2, link3, link4}));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)listing).asJava());
        ListClusterLinksResult result = (ListClusterLinksResult)EasyMock.createNiceMock(ListClusterLinksResult.class);
        EasyMock.expect((Object)result.result()).andReturn((Object)future).once();
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedCommand, hasLinkName, link1, includeTopics, result){
            private final BooleanRef issuedCommand$2;
            private final boolean hasLinkName$1;
            private final ClusterLinkListing link1$1;
            private final boolean includeTopics$1;
            private final ListClusterLinksResult result$2;

            public ListClusterLinksResult listClusterLinks(ListClusterLinksOptions options) {
                this.issuedCommand$2.elem = true;
                if (this.hasLinkName$1) {
                    Assertions.assertTrue((boolean)options.linkNames().isPresent());
                    Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.link1$1.linkName()})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)options.linkNames().get()).asScala()).toSet());
                } else {
                    Assertions.assertFalse((boolean)options.linkNames().isPresent());
                }
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.includeTopics$1), (Object)BoxesRunTime.boxToBoolean((boolean)options.includeTopics()));
                return this.result$2;
            }
            {
                this.issuedCommand$2 = issuedCommand$2;
                this.hasLinkName$1 = hasLinkName$1;
                this.link1$1 = link1$1;
                this.includeTopics$1 = includeTopics$1;
                this.result$2 = result$2;
                super(node$2);
            }
        };
        EasyMock.replay((Object[])new Object[]{result});
        String output = this.runCommand((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--list"})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        EasyMock.reset((Object[])new Object[]{result});
        listing.foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ClusterLinkCommandTest.$anonfun$listClusterLinks$1(output, includeTopics, entry);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testListClusterLinks() {
        this.listClusterLinks((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), false, false);
        this.listClusterLinks((String[])((Object[])new String[]{"--include-topics"}), false, true);
        this.listClusterLinks((String[])((Object[])new String[]{"--link", "link-1"}), true, false);
        this.listClusterLinks((String[])((Object[])new String[]{"--link", "link-1", "--include-topics"}), true, true);
    }

    private void deleteClusterLinks(String[] args, boolean expectValidateOnly, boolean expectForce) {
        String linkName = "test-link";
        BooleanRef issuedCommand = BooleanRef.create((boolean)false);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(null);
        DeleteClusterLinksResult result = (DeleteClusterLinksResult)EasyMock.createNiceMock(DeleteClusterLinksResult.class);
        EasyMock.expect((Object)result.all()).andReturn((Object)future).once();
        Node node = new Node(1, "localhost", 9092);
        TestAdminClient mockAdminClient = new TestAdminClient(this, node, issuedCommand, linkName, expectValidateOnly, expectForce, result){
            private final BooleanRef issuedCommand$3;
            private final String linkName$2;
            private final boolean expectValidateOnly$2;
            private final boolean expectForce$1;
            private final DeleteClusterLinksResult result$3;

            public DeleteClusterLinksResult deleteClusterLinks(Collection<String> linkNames, DeleteClusterLinksOptions options) {
                this.issuedCommand$3.elem = true;
                Assertions.assertEquals((int)1, (int)linkNames.size());
                Assertions.assertEquals((Object)this.linkName$2, (Object)linkNames.iterator().next());
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.expectValidateOnly$2), (Object)BoxesRunTime.boxToBoolean((boolean)options.validateOnly()));
                Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.expectForce$1), (Object)BoxesRunTime.boxToBoolean((boolean)options.force()));
                return this.result$3;
            }
            {
                this.issuedCommand$3 = issuedCommand$3;
                this.linkName$2 = linkName$2;
                this.expectValidateOnly$2 = expectValidateOnly$2;
                this.expectForce$1 = expectForce$1;
                this.result$3 = result$3;
                super(node$3);
            }
        };
        EasyMock.replay((Object[])new Object[]{result});
        String output = this.runCommand((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--delete", "--link", linkName})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), mockAdminClient);
        Assertions.assertTrue((boolean)issuedCommand.elem);
        EasyMock.reset((Object[])new Object[]{result});
        String expectedOutput = expectValidateOnly ? this.validated() : this.completed();
        Assertions.assertTrue((boolean)output.contains(expectedOutput));
    }

    private boolean deleteClusterLinks$default$2() {
        return false;
    }

    private boolean deleteClusterLinks$default$3() {
        return false;
    }

    @Test
    public void testDeleteClusterLinks() {
        this.deleteClusterLinks((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), this.deleteClusterLinks$default$2(), this.deleteClusterLinks$default$3());
        this.deleteClusterLinks((String[])((Object[])new String[]{"--validate-only"}), true, this.deleteClusterLinks$default$3());
        String[] x$1 = (String[])((Object[])new String[]{"--force"});
        boolean x$2 = true;
        boolean x$3 = this.deleteClusterLinks$default$2();
        this.deleteClusterLinks(x$1, x$3, x$2);
    }

    @Test
    public void testBadCommands() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--not-a-command"})).verifyArgs(), ClassTag$.MODULE$.apply(OptionException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--create", "--list"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
    }

    @Test
    public void testBadConfigs() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--create", "--link", "test-link"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--create", "--link", "test-link", "--config", "bootstrap.servers=10.20.30.40:9092", "--config-file", "cluster-link.properties"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
    }

    @Test
    public void testMissingRequiredArgs() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--list"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--create", "--config", "bootstrap.servers=10.20.30.40"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--create", "--link", "test-link"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--delete"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--create", "test-link", "--exclude-validate-link"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
    }

    @Test
    public void testInvalidArgs() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--create", "--link", "test-link", "--config", "bootstrap.servers=10.20.30.40:9092", "--force"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--list", "--force"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--list", "--cluster-id", "123"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--list", "--config", "bootstrap.servers=10.20.30.40:9092"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--delete", "--link", "test-link", "--cluster-id", "123"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--delete", "--link", "test-link", "--config", "bootstrap.servers=10.20.30.40:9092"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--delete", "--link", "test-link", "--exclude-validate-link"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--create", "--link", "test-link", "--config", "bootstrap.servers=10.20.30.40:9092", "--include-topics"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ClusterLinkCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--delete", "--link", "test-link", "--include-topics"})).verifyArgs(), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ClusterLinkCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
    }

    private static final Optional toTopics$1(Option topics) {
        Optional<Object> optional;
        if (topics instanceof Some) {
            scala.collection.immutable.Set t = (scala.collection.immutable.Set)((Some)topics).value();
            optional = Optional.of(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)t).asJavaCollection());
        } else if (None$.MODULE$.equals(topics)) {
            optional = Optional.empty();
        } else {
            throw new MatchError((Object)topics);
        }
        return optional;
    }

    public static final /* synthetic */ void $anonfun$listClusterLinks$2(String output$1, String t) {
        Assertions.assertTrue((boolean)output$1.contains(t));
    }

    public static final /* synthetic */ void $anonfun$listClusterLinks$1(String output$1, boolean includeTopics$1, ClusterLinkListing entry) {
        if (entry.localClusterId() == null) {
            Assertions.assertTrue((boolean)output$1.contains(new StringBuilder(79).append("Link name: '").append(entry.linkName()).append("', link ID: '").append(entry.linkId()).append("', remote cluster ID: '").append(entry.remoteClusterId()).append("', ").append("remote cluster available: '").append(entry.available()).append("'").toString()));
        } else {
            Assertions.assertTrue((boolean)output$1.contains(new StringBuilder(101).append("Link name: '").append(entry.linkName()).append("', link ID: '").append(entry.linkId()).append("', remote cluster ID: '").append(entry.remoteClusterId()).append("', ").append("local cluster ID: '").append(entry.localClusterId()).append("', remote cluster available: '").append(entry.available()).append("'").toString()));
        }
        if (includeTopics$1) {
            ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)entry.topics().get()).asScala()).foreach((Function1 & Serializable & scala.Serializable)t -> {
                ClusterLinkCommandTest.$anonfun$listClusterLinks$2(output$1, t);
                return BoxedUnit.UNIT;
            });
        }
    }

    public ClusterLinkCommandTest() {
        this.completed = "successfully completed";
        this.validated = "successfully validated";
    }

    public class TestAdminClient
    extends MockAdminClient {
        public CreateClusterLinksResult createClusterLinks(Collection<NewClusterLink> clusterLinks, CreateClusterLinksOptions options) {
            return (CreateClusterLinksResult)EasyMock.createNiceMock(CreateClusterLinksResult.class);
        }

        public ListClusterLinksResult listClusterLinks(ListClusterLinksOptions options) {
            return (ListClusterLinksResult)EasyMock.createNiceMock(ListClusterLinksResult.class);
        }

        public DeleteClusterLinksResult deleteClusterLinks(Collection<String> linkNames, DeleteClusterLinksOptions options) {
            return (DeleteClusterLinksResult)EasyMock.createNiceMock(DeleteClusterLinksResult.class);
        }

        public /* synthetic */ ClusterLinkCommandTest kafka$admin$ClusterLinkCommandTest$TestAdminClient$$$outer() {
            return ClusterLinkCommandTest.this;
        }

        public TestAdminClient(Node node) {
            if (ClusterLinkCommandTest.this == null) {
                throw null;
            }
            super(Collections.singletonList(node), node);
        }
    }
}

