/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tue\u0001B$I\u00015CQA\u0018\u0001\u0005\u0002}CQ!\u0019\u0001\u0005B\tDq!\u001d\u0001C\u0002\u0013%!\u000f\u0003\u0004x\u0001\u0001\u0006Ia\u001d\u0005\bq\u0002\u0011\r\u0011\"\u0003z\u0011\u0019i\b\u0001)A\u0005u\"Ia\u0010\u0001a\u0001\u0002\u0004%Ia \u0005\f\u0003;\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0002C\u0006\u0002,\u0001\u0001\r\u0011!Q!\n\u0005\u0005\u0001bCA\u0017\u0001\u0001\u0007\t\u0019!C\u0005\u0003_A1\"!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L!Y\u0011q\n\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0019\u0011-\t\t\u0006\u0001a\u0001\u0002\u0004%I!a\u0015\t\u0017\u0005\u0015\u0004\u00011AA\u0002\u0013%\u0011q\r\u0005\f\u0003W\u0002\u0001\u0019!A!B\u0013\t)\u0006\u0003\u0005\u0002n\u0001\u0001K\u0011BA8\u0011!\tY\b\u0001Q\u0005\n\u0005u\u0004\"CAD\u0001E\u0005I\u0011BAE\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!a1\u0001\t\u0003\t)\rC\u0004\u0002P\u0002!\t!!2\t\u000f\u0005e\u0007\u0001\"\u0001\u0002F\"9\u0011Q\u001c\u0001\u0005\u0002\u0005\u0015\u0007bBAq\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0003K\u0004A\u0011AAc\u0011\u001d\tI\u000f\u0001C\u0001\u0003\u000bDq!!<\u0001\t\u0003\t)\rC\u0004\u0002r\u0002!\t!!2\t\u000f\u0005U\b\u0001\"\u0001\u0002F\"9\u0011\u0011 \u0001\u0005\u0002\u0005\u0015\u0007bBA\u007f\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005\u0003\u0001A\u0011AAc\u0011\u001d\u0011)\u0001\u0001C\u0001\u0003\u000bDqA!\u0003\u0001\t\u0003\t)\rC\u0004\u0003\u000e\u0001!\t!!2\t\u000f\tE\u0001\u0001\"\u0001\u0002F\"9!Q\u0003\u0001\u0005\u0002\u0005\u0015\u0007b\u0002B\r\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005;\u0001A\u0011AAc\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0003\u000bDqA!\n\u0001\t\u0003\t)\rC\u0004\u0003*\u0001!\t!!2\t\u000f\t5\u0002\u0001\"\u0001\u0002F\"9!\u0011\u0007\u0001\u0005\u0002\u0005\u0015\u0007b\u0002B\u001b\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005s\u0001A\u0011AAc\u0011\u001d\u0011i\u0004\u0001C\u0001\u0003\u000bDqA!\u0011\u0001\t\u0003\t)\rC\u0004\u0003F\u0001!\t!!2\t\u000f\t%\u0003\u0001\"\u0001\u0002F\"9!Q\n\u0001\u0005\u0002\u0005\u0015\u0007b\u0002B)\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005+\u0002A\u0011AAc\u0011\u001d\u0011I\u0006\u0001C\u0001\u0003\u000bDqA!\u0018\u0001\t\u0003\t)\rC\u0004\u0003b\u0001!\t!!2\t\u000f\t\u0015\u0004\u0001\"\u0001\u0002F\"9!\u0011\u000e\u0001\u0005\u0002\u0005\u0015\u0007b\u0002B7\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005c\u0002A\u0011AAc\u0011\u001d\u0011)\b\u0001C\u0001\u0003\u000bDqA!\u001f\u0001\t\u0003\t)\rC\u0004\u0003~\u0001!\t!!2\t\u000f\t\u0005\u0005\u0001\"\u0001\u0002F\"9!Q\u0011\u0001\u0005\u0002\u0005\u0015\u0007b\u0002BE\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0005\u001b\u0003A\u0011AAc\u0011\u001d\u0011\t\n\u0001C\u0001\u0003\u000bDqA!&\u0001\t\u0003\t)\rC\u0004\u0003\u001a\u0002!\t!!2\u00037Q{\u0007/[2D_6l\u0017M\u001c3J]R,wM]1uS>tG+Z:u\u0015\tI%*A\u0003bI6LgNC\u0001L\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001(U5B\u0011qJU\u0007\u0002!*\u0011\u0011KS\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002T!\n12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002V16\taK\u0003\u0002X\u0015\u0006)Q\u000f^5mg&\u0011\u0011L\u0016\u0002\b\u0019><w-\u001b8h!\tYF,D\u0001I\u0013\ti\u0006JA\u0007SC\u000e\\\u0017i^1sKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0004\"a\u0017\u0001\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012a\u0019\t\u0004I&\\W\"A3\u000b\u0005\u0019<\u0017AC2pY2,7\r^5p]*\t\u0001.A\u0003tG\u0006d\u0017-\u0003\u0002kK\n\u00191+Z9\u0011\u00051|W\"A7\u000b\u00059T\u0015AB:feZ,'/\u0003\u0002q[\nY1*\u00194lC\u000e{gNZ5h\u00035qW/\u001c)beRLG/[8ogV\t1\u000f\u0005\u0002uk6\tq-\u0003\u0002wO\n\u0019\u0011J\u001c;\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005AB-\u001a4bk2$(+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0016\u0003i\u0004\"\u0001^>\n\u0005q<'!B*i_J$\u0018!\u00073fM\u0006,H\u000e\u001e*fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\nA\u0002^8qS\u000e\u001cVM\u001d<jG\u0016,\"!!\u0001\u0011\t\u0005\r\u0011q\u0003\b\u0005\u0003\u000b\t\u0019B\u0004\u0003\u0002\b\u0005Ea\u0002BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055A*\u0001\u0004=e>|GOP\u0005\u0002\u0017&\u0011\u0011JS\u0005\u0004\u0003+A\u0015\u0001\u0004+pa&\u001c7i\\7nC:$\u0017\u0002BA\r\u00037\u0011A\u0002V8qS\u000e\u001cVM\u001d<jG\u0016T1!!\u0006I\u0003A!x\u000e]5d'\u0016\u0014h/[2f?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0005\u001d\u0002c\u0001;\u0002$%\u0019\u0011QE4\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003SA\u0011\u0011!a\u0001\u0003\u0003\t1\u0001\u001f\u00132\u00035!x\u000e]5d'\u0016\u0014h/[2fA\u0005Y\u0011\rZ7j]\u000ec\u0017.\u001a8u+\t\t\t\u0004\u0005\u0003\u00024\u0005\u0015SBAA\u001b\u0015\rI\u0015q\u0007\u0006\u0005\u0003s\tY$A\u0004dY&,g\u000e^:\u000b\u0007-\u000biD\u0003\u0003\u0002@\u0005\u0005\u0013AB1qC\u000eDWM\u0003\u0002\u0002D\u0005\u0019qN]4\n\t\u0005\u001d\u0013Q\u0007\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u0010C\u0012l\u0017N\\\"mS\u0016tGo\u0018\u0013fcR!\u0011\u0011EA'\u0011%\tIcCA\u0001\u0002\u0004\t\t$\u0001\u0007bI6Lgn\u00117jK:$\b%A\u0007uKN$Hk\u001c9jG:\u000bW.Z\u000b\u0003\u0003+\u0002B!a\u0016\u0002`9!\u0011\u0011LA.!\r\tIaZ\u0005\u0004\u0003;:\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002b\u0005\r$AB*ue&twMC\u0002\u0002^\u001d\f\u0011\u0003^3tiR{\u0007/[2OC6,w\fJ3r)\u0011\t\t#!\u001b\t\u0013\u0005%b\"!AA\u0002\u0005U\u0013A\u0004;fgR$v\u000e]5d\u001d\u0006lW\rI\u0001\u0013GJ,\u0017\r^3B]\u0012<\u0016-\u001b;U_BL7\r\u0006\u0003\u0002\"\u0005E\u0004bBA:!\u0001\u0007\u0011QO\u0001\u0005_B$8\u000f\u0005\u0003\u0002\u0004\u0005]\u0014\u0002BA=\u00037\u00111\u0003V8qS\u000e\u001cu.\\7b]\u0012|\u0005\u000f^5p]N\f1c^1ji\u001a{'\u000fV8qS\u000e\u001c%/Z1uK\u0012$b!!\t\u0002\u0000\u0005\r\u0005bBAA#\u0001\u0007\u0011QK\u0001\ni>\u0004\u0018n\u0019(b[\u0016D\u0001\"!\"\u0012!\u0003\u0005\ra]\u0001\bi&lWm\\;u\u0003u9\u0018-\u001b;G_J$v\u000e]5d\u0007J,\u0017\r^3eI\u0011,g-Y;mi\u0012\u0012TCAAFU\r\u0019\u0018QR\u0016\u0003\u0003\u001f\u0003B!!%\u0002\u001c6\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9*A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011T4\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001e\u0006M%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006)1/\u001a;vaR!\u0011\u0011EAR\u0011\u001d\t)k\u0005a\u0001\u0003O\u000bA!\u001b8g_B!\u0011\u0011VA\\\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016aA1qS*!\u0011\u0011WAZ\u0003\u001dQW\u000f]5uKJTA!!.\u0002B\u0005)!.\u001e8ji&!\u0011\u0011XAV\u0005!!Vm\u001d;J]\u001a|\u0007fA\n\u0002>B!\u0011\u0011VA`\u0013\u0011\t\t-a+\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0003dY>\u001cX\r\u0006\u0002\u0002\"!\u001aA#!3\u0011\t\u0005%\u00161Z\u0005\u0005\u0003\u001b\fYKA\u0005BMR,'/R1dQ\u0006QA/Z:u\u0007J,\u0017\r^3)\u0007U\t\u0019\u000e\u0005\u0003\u0002*\u0006U\u0017\u0002BAl\u0003W\u0013A\u0001V3ti\u00061B/Z:u\u0007J,\u0017\r^3XSRDG)\u001a4bk2$8\u000fK\u0002\u0017\u0003'\f\u0001\u0005^3ti\u000e\u0013X-\u0019;f/&$\b\u000eR3gCVdGOU3qY&\u001c\u0017\r^5p]\"\u001aq#a5\u0002?Q,7\u000f^\"sK\u0006$XmV5uQ\u0012+g-Y;miB\u000b'\u000f^5uS>t7\u000fK\u0002\u0019\u0003'\fQ\u0003^3ti\u000e\u0013X-\u0019;f/&$\bnQ8oM&<7\u000fK\u0002\u001a\u0003'\f1\u0004^3ti\u000e\u0013X-\u0019;f/\",g.\u00117sK\u0006$\u00170\u0012=jgR\u001c\bf\u0001\u000e\u0002T\u0006QC/Z:u\u0007J,\u0017\r^3XQ\u0016t\u0017\t\u001c:fC\u0012LX\t_5tiN<\u0016\u000e\u001e5JM:{G/\u0012=jgR\u001c\bfA\u000e\u0002T\u0006yB/Z:u\u0007J,\u0017\r^3XSRD'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;)\u0007q\t\u0019.\u0001\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5J]Z\fG.\u001b3SKBd\u0017nY1uS>tg)Y2u_JD3!HAj\u0003\u001d\"Xm\u001d;De\u0016\fG/Z,ji\"tUmZ1uSZ,'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:)\u0007y\t\u0019.\u0001\u0013uKN$8I]3bi\u0016<\u0016\u000e\u001e5OK\u001e\fG/\u001b<f!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\ry\u00121[\u0001\u001ci\u0016\u001cH/\u00138wC2LG\rV8qS\u000edUM^3m\u0007>tg-[4)\u0007\u0001\n\u0019.\u0001\buKN$H*[:u)>\u0004\u0018nY:)\u0007\u0005\n\u0019.A\u000fuKN$H*[:u)>\u0004\u0018nY:XSRD\u0017J\\2mk\u0012,G*[:uQ\r\u0011\u00131[\u0001\"i\u0016\u001cH\u000fT5tiR{\u0007/[2t/&$\b.\u0012=dYV$W-\u00138uKJt\u0017\r\u001c\u0015\u0004G\u0005M\u0017a\u0006;fgR\fE\u000e^3s!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\r!\u00131[\u0001\u0014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e\u001e\u0015\u0004K\u0005M\u0017a\r;fgR\fE\u000e^3s\u0003N\u001c\u0018n\u001a8nK:$x+\u001b;i\u001b>\u0014X-Q:tS\u001etW.\u001a8u)\"\fg\u000eU1si&$\u0018n\u001c8tQ\r1\u00131[\u00014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e^,ji\"luN]3QCJ$\u0018\u000e^5p]N$\u0006.\u00198BgNLwM\\7f]RD3aJAj\u0003\t\"Xm\u001d;BYR,'oV5uQ&sg/\u00197jIB\u000b'\u000f^5uS>t7i\\;oi\"\u001a\u0001&a5\u0002;Q,7\u000f^!mi\u0016\u0014x\u000b[3o)>\u0004\u0018n\u0019#pKNtG/\u0012=jgRD3!KAj\u0003%\"Xm\u001d;BYR,'o\u00165f]R{\u0007/[2E_\u0016\u001ch\u000e^#ySN$x+\u001b;i\u0013\u001a,\u00050[:ug\"\u001a!&a5\u0002CQ,7\u000f^\"sK\u0006$X-\u00117uKJ$v\u000e]5d/&$\bNU1dW\u0006;\u0018M]3)\u0007-\n\u0019.A\u0018uKN$8i\u001c8gS\u001e\u0004&/Z:feZ\fG/[8o\u0003\u000e\u0014xn]:QCJ$\u0018\u000e^5p]\u0006cG/\u001a:bi&|g\u000eK\u0002-\u0003'\f\u0011\u0003^3tiR{\u0007/[2EK2,G/[8oQ\ri\u00131[\u0001\u0018i\u0016\u001cH\u000fR3mKR,\u0017J\u001c;fe:\fG\u000eV8qS\u000eD3ALAj\u0003y!Xm\u001d;EK2,G/Z,iK:$v\u000e]5d\t>,7O\u001c;Fq&\u001cH\u000fK\u00020\u0003'\f!\u0006^3ti\u0012+G.\u001a;f/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;XSRD\u0017JZ#ySN$8\u000fK\u00021\u0003'\fA\u0002^3ti\u0012+7o\u0019:jE\u0016D3!MAj\u0003\u0001\"Xm\u001d;EKN\u001c'/\u001b2f/\",g\u000eV8qS\u000e$u.Z:oi\u0016C\u0018n\u001d;)\u0007I\n\u0019.\u0001\u0017uKN$H)Z:de&\u0014Wm\u00165f]R{\u0007/[2E_\u0016\u001ch\u000e^#ySN$x+\u001b;i\u0013\u001a,\u00050[:ug\"\u001a1'a5\u0002CQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u00064\u0018-\u001b7bE2,\u0007+\u0019:uSRLwN\\:)\u0007Q\n\u0019.A\u0013uKN$H)Z:de&\u0014W-\u00168eKJ\u0014V\r\u001d7jG\u0006$X\r\u001a)beRLG/[8og\"\u001aQ'a5\u0002CQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u0012,'/T5o\u0013N\u0014\b+\u0019:uSRLwN\\:)\u0007Y\n\u0019.\u0001\u0013uKN$H)Z:de&\u0014WmV5uQ&sg/\u00197jI>\u00137/\u001a:wKJ\u001cu.\u001e8uQ\r9\u00141[\u0001(i\u0016\u001cH\u000fR3tGJL'-Z,ji\"LeN^1mS\u0012\u001c\u0016P\\2SKBd\u0017nY1D_VtG\u000fK\u00029\u0003'\fa\u0005^3ti\u0012+7o\u0019:jE\u0016<\u0016\u000e\u001e5J]Z\fG.\u001b3Ts:\u001c'+\u001a9mS\u000e\f'+Y2lQ\rI\u00141[\u0001$i\u0016\u001cH\u000fR3tGJL'-Z,ji\"LeN^1mS\u0012|%m]3sm\u0016\u0014(+Y2lQ\rQ\u00141[\u0001#i\u0016\u001cH\u000fR3tGJL'-Z,ji\"\u001c\u0016P\\2SKBd\u0017nY1PM\u001ad\u0017N\\3)\u0007m\n\u0019.A\u0010uKN$H)Z:de&\u0014WmV5uQ>\u00137/\u001a:wKJ|eM\u001a7j]\u0016D3\u0001PAj\u0003%\"Xm\u001d;EKN\u001c'/\u001b2f/&$\bnQ8se\u0016\u001cG\u000f\\=QY\u0006\u001cW\r\u001a)beRLG/[8og\"\u001aQ(a5\u0002\u0003R,7\u000f\u001e#fg\u000e\u0014\u0018NY3V]\u0012,'OU3qY&\u001c\u0017\r^3e!\u0006\u0014H/\u001b;j_:\u001cx\u000b[3o%\u0016\f7o]5h]6,g\u000e^%t\u0013:\u0004&o\\4sKN\u001c\bf\u0001 \u0002T\u0006qB/Z:u\t\u0016\u001c8M]5cK\u0006#X*\u001b8JgJ\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004\u007f\u0005M\u0017A\n;fgR$Um]2sS\n,WK\u001c3fe6Kg.S:s!\u0006\u0014H/\u001b;j_:\u001cX*\u001b=fI\"\u001a\u0001)a5\u0002GQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3SKB|'\u000f^(wKJ\u0014\u0018\u000e\u001a3f]\u000e{gNZ5hg\"\u001a\u0011)a5\u0002]Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3B]\u0012d\u0015n\u001d;U_BL7m],ji\"|W\u000f^%oi\u0016\u0014h.\u00197U_BL7m\u001d\u0015\u0004\u0005\u0006M\u0017\u0001\u0010;fgR$Um]2sS\n,Gi\\3t\u001d>$h)Y5m/\",g\u000eT5ti&twMU3bgNLwM\\7f]RL5/\u00168bkRDwN]5{K\u0012D3aQAj\u0003m\"Xm\u001d;De\u0016\fG/\u001a+pa&\u001cGi\\3t\u001d>$(+\u001a;ssRC'o\u001c;uY&tw-U;pi\u0006,\u0005pY3fI\u0016$W\t_2faRLwN\u001c\u0015\u0004\t\u0006M\u0017a\u000f;fgR$U\r\\3uKR{\u0007/[2E_\u0016\u001chj\u001c;SKR\u0014\u0018\u0010\u00165s_R$H.\u001b8h#V|G/Y#yG\u0016,G-\u001a3Fq\u000e,\u0007\u000f^5p]\"\u001aQ)a5\u0002\u0001R,7\u000f^\"sK\u0006$X\rU1si&$\u0018n\u001c8t\t>,7OT8u%\u0016$(/\u001f+ie>$H\u000f\\5oOF+x\u000e^1Fq\u000e,W\rZ3e\u000bb\u001cW\r\u001d;j_:D3ARAj\u0001")
public class TopicCommandIntegrationTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor;
    private TopicCommand.TopicService topicService;
    private Admin adminClient;
    private String testTopicName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = 6;
        String x$2 = this.zkConnect();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$15 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$16 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        int x$17 = TestUtils$.MODULE$.createBrokerConfigs$default$17();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, (Map<Object, String>)x$3, x$15, x$16, x$4, x$5, x$17).map((Function1 & Serializable & scala.Serializable)props -> {
            props.put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "1");
            return KafkaConfig$.MODULE$.fromProps(props);
        }, Seq$.MODULE$.canBuildFrom());
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private TopicCommand.TopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.TopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), this.waitForTopicCreated$default$2());
    }

    private void waitForTopicCreated(String topicName, int timeout) {
        TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)this.servers(), topicName, 0, timeout);
    }

    private int waitForTopicCreated$default$2() {
        return 10000;
    }

    @BeforeEach
    public void setup(TestInfo info) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        this.adminClient_$eq(Admin.create((Properties)props));
        this.topicService_$eq(TopicCommand.TopicService$.MODULE$.apply(this.adminClient()));
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @AfterEach
    public void close() {
        if (this.topicService() != null) {
            this.topicService().close();
        }
    }

    @Test
    public void testCreate() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()})));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @Test
    public void testCreateWithDefaults() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultReplication() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "2"})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)2);
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultPartitions() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"})));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)2);
    }

    @Test
    public void testCreateWithConfigs() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"})));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertEquals((int)1000, (Integer)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @Test
    public void testCreateWhenAlreadyExists() {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Assertions.assertThrows(TopicExistsException.class, () -> this.topicService().createTopic(createOpts));
    }

    @Test
    public void testCreateWhenAlreadyExistsWithIfNotExists() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-not-exists"}));
        this.createAndWaitTopic(createOpts);
        this.topicService().createTopic(createOpts);
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)3, (int)partitions.size());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", Integer.toString(32768), "--topic", this.testTopicName()}))));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()}))));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()}))));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"}));
        Assertions.assertThrows(ConfigException.class, () -> this.topicService().createTopic(createOpts));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopicsWithIncludeList() {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic2, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic3, 2, (short)2), (List)Nil$.MODULE$)))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic2, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic3, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)string.contains(topic1));
        Assertions.assertTrue((boolean)string.contains(topic2));
        Assertions.assertFalse((boolean)string.contains(topic3));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListTopicsWithExcludeInternal() {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic("__consumer_offsets", 2, (short)2), (List)Nil$.MODULE$))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)string.contains(topic1));
        Assertions.assertFalse((boolean)string.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"})));
        Assertions.assertTrue((((TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get()).partitions().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testAlterAssignment() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get();
        Assertions.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testAlterAssignmentWithMoreAssignmentThanPartitions() {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"}))));
    }

    @Test
    public void testAlterAssignmentWithMorePartitionsThanAssignment() {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"}))));
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.testTopicName()}))));
    }

    @Test
    public void testAlterWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1"}));
        TopicCommand.TopicService topicService = TopicCommand.TopicService$.MODULE$.apply(this.adminClient());
        Assertions.assertThrows(IllegalArgumentException.class, () -> topicService.alterTopic(alterOpts));
    }

    @Test
    public void testAlterWhenTopicDoesntExistWithIfExists() {
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"})));
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", Integer.toString(replicationFactor), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Map assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(alteredNumPartitions), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Seq replicas = (Seq)x0$2._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assertions.assertTrue((boolean)props.containsKey(cleanupKey), (String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString());
        Assertions.assertTrue((boolean)props.getProperty(cleanupKey).equals(cleanupVal), (String)"Properties after creation have incorrect value");
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", Integer.toString(numPartitionsModified), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assertions.assertTrue((boolean)newProps.containsKey(cleanupKey), (String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString());
        Assertions.assertTrue((boolean)newProps.getProperty(cleanupKey).equals(cleanupVal), (String)"Updated properties have incorrect value");
    }

    @Test
    public void testTopicDeletion() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assertions.assertFalse((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic shouldn't exist before deletion.");
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), this.testTopicName(), 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteInternalTopic() {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assertions.assertFalse((boolean)this.zkClient().pathExists(deleteOffsetTopicPath), (String)"Delete path for topic shouldn't exist before deletion.");
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "__consumer_offsets", 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().deleteTopic(deleteOpts));
    }

    @Test
    public void testDeleteWhenTopicDoesntExistWithIfExists() {
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribe() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)3, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
    }

    @Test
    public void testDescribeWhenTopicDoesntExist() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
    }

    @Test
    public void testDescribeWhenTopicDoesntExistWithIfExists() {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--if-exists"})));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnavailablePartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            TopicDescription testTopicDescription = (TopicDescription)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).asScala()).apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(testTopicDescription.partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$1(x$5))).get()).partition();
            this.killBroker(0);
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$2(this, partitionOnBroker0)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$7(this));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderReplicatedPartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitions$1(x$9)));
            TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$1(x$10)));
            TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithInvalidObserverCount() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack3\"\n        |    }\n        |  }]\n        |}")).stripMargin();
        String placementJson2 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack3\"\n        |    }\n        |  }]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", placementJson2);
        TestUtils$.MODULE$.incrementalAlterTopicConfigs(this.adminClient(), this.testTopicName(), configUpdate, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4()).all().get();
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithInvalidSyncReplicaCount() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack3\"\n        |    }\n        |  }]\n        |}")).stripMargin();
        String placementJson2 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack3\"\n        |    }\n        |  }]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", placementJson2);
        TestUtils$.MODULE$.incrementalAlterTopicConfigs(this.adminClient(), this.testTopicName(), configUpdate, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4()).all().get();
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithInvalidSyncReplicaRack() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        String placementJson2 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", placementJson2);
        TestUtils$.MODULE$.incrementalAlterTopicConfigs(this.adminClient(), this.testTopicName(), configUpdate, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4()).all().get();
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithInvalidObserverRack() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack2\"\n        |     }\n        |   },\n        |    {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack3\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        String placementJson2 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack2\"\n        |     }\n        |   },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack3\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", placementJson2);
        TestUtils$.MODULE$.incrementalAlterTopicConfigs(this.adminClient(), this.testTopicName(), configUpdate, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4()).all().get();
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithSyncReplicaOffline() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithObserverOffline() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack2\"\n        |     }\n        |   },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack3\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(5);
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeWithCorrectlyPlacedPartitions() {
        String placementJson1 = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack2\"\n        |     }\n        |   },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack3\"\n        |      }\n        |    }\n        |  ]\n        |}")).stripMargin();
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--invalid-replica-placement-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((Object)"", (Object)rows[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress() {
        HashMap configMap = new HashMap();
        short replicationFactor = 1;
        int partitions = 1;
        TopicPartition tp = new TopicPartition(this.testTopicName(), 0);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), partitions, replicationFactor).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.testTopicName(), 10, -1);
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.testTopicName(), 10, -1);
        Buffer brokerIds = (Buffer)this.servers().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(x$11)), Buffer$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.setReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 1);
        TopicDescription testTopicDesc = (TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singleton(this.testTopicName())).all().get()).get(this.testTopicName());
        TopicPartitionInfo firstPartition = (TopicPartitionInfo)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(testTopicDesc.partitions()).asScala()).head();
        Buffer replicasOfFirstPartition = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(firstPartition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.id()), Buffer$.MODULE$.canBuildFrom());
        int targetReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)brokerIds.diff((GenSeq)replicasOfFirstPartition)).head());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(targetReplica)))))).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] simpleDescribeOutputRows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertTrue((boolean)simpleDescribeOutputRows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
        Assertions.assertEquals((int)2, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])simpleDescribeOutputRows)).size());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out2.toString();
        Assertions.assertEquals((Object)"", (Object)string, (String)new StringBuilder(59).append("--under-replicated-partitions shouldn't return anything: '").append(string).append("'").toString());
        PartitionReassignment reassignments = (PartitionReassignment)((java.util.Map)this.adminClient().listPartitionReassignments(Collections.singleton(tp)).reassignments().get()).get(tp);
        Assertions.assertFalse((boolean)Option$.MODULE$.apply((Object)reassignments).forall((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(x$13))));
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), TestUtils$.MODULE$.waitForAllReassignmentsToComplete$default$2());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeAtMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            this.killBroker(1);
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--at-min-isr-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertEquals((int)1, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderMinIsrPartitionsMixed() {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Collections.singletonList(Predef$.MODULE$.int2Integer(0)))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)})))})).all().get();
        this.waitForTopicCreated(underMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(notUnderMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(offlineTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(fullyReplicatedTopic, this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(x$14)));
            TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)aliveServers, underMinIsrTopic, 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
            JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"})));
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                void grabConsoleOutput_f;
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assertions.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
            Assertions.assertEquals((int)2, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeReportOverriddenConfigs() {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(config), (String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)string.contains(this.testTopicName()), (String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString());
        Assertions.assertFalse((boolean)string.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = grabConsoleOutput_out2.toString();
        Assertions.assertTrue((boolean)string2.contains(this.testTopicName()));
        Assertions.assertFalse((boolean)string2.contains("__consumer_offsets"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeDoesNotFailWhenListingReassignmentIsUnauthorized() {
        this.adminClient_$eq((Admin)Mockito.spy((Object)this.adminClient()));
        this.topicService_$eq(TopicCommand.TopicService$.MODULE$.apply(this.adminClient()));
        ((Admin)Mockito.doReturn((Object)AdminClientTestUtils.listPartitionReassignmentsResult((Throwable)new ClusterAuthorizationException("Unauthorized")), (Object[])new Object[]{null}).when((Object)this.adminClient())).listPartitionReassignments((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.testTopicName(), 0)}))).asJava());
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()})));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            void grabConsoleOutput_f;
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)2, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
    }

    @Test
    public void testCreateTopicDoesNotRetryThrottlingQuotaExceededException() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.TopicService topicService = TopicCommand.TopicService$.MODULE$.apply(adminClient);
        CreateTopicsResult result = AdminClientTestUtils.createTopicsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.createTopics((Collection)ArgumentMatchers.any(), (CreateTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertThrows(ThrottlingQuotaExceededException.class, () -> topicService.createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
        NewTopic expectedNewTopic = new NewTopic(this.testTopicName(), Optional.empty(), Optional.empty()).configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).createTopics((Collection)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{expectedNewTopic}))).asJava()), (CreateTopicsOptions)ArgumentMatchers.argThat(x$15 -> !x$15.shouldRetryOnQuotaViolation()));
    }

    @Test
    public void testDeleteTopicDoesNotRetryThrottlingQuotaExceededException() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.TopicService topicService = TopicCommand.TopicService$.MODULE$.apply(adminClient);
        ListTopicsResult listResult = AdminClientTestUtils.listTopicsResult((String)this.testTopicName());
        Mockito.when((Object)adminClient.listTopics((ListTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
        DeleteTopicsResult result = AdminClientTestUtils.deleteTopicsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.deleteTopics((Collection)ArgumentMatchers.any(), (DeleteTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> topicService.deleteTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))))).getCause() instanceof ThrottlingQuotaExceededException));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).deleteTopics((Collection)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)this.testTopicName(), (List)Nil$.MODULE$)).asJavaCollection()), (DeleteTopicsOptions)ArgumentMatchers.argThat(x$16 -> !x$16.shouldRetryOnQuotaViolation()));
    }

    @Test
    public void testCreatePartitionsDoesNotRetryThrottlingQuotaExceededException() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.TopicService topicService = TopicCommand.TopicService$.MODULE$.apply(adminClient);
        ListTopicsResult listResult = AdminClientTestUtils.listTopicsResult((String)this.testTopicName());
        Mockito.when((Object)adminClient.listTopics((ListTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
        TopicPartitionInfo topicPartitionInfo = new TopicPartitionInfo(0, new Node(0, "", 0), Collections.emptyList(), Collections.emptyList());
        DescribeTopicsResult describeResult = AdminClientTestUtils.describeTopicsResult((String)this.testTopicName(), (TopicDescription)new TopicDescription(this.testTopicName(), false, Collections.singletonList(topicPartitionInfo)));
        Mockito.when((Object)adminClient.describeTopics((Collection)ArgumentMatchers.any())).thenReturn((Object)describeResult);
        CreatePartitionsResult result = AdminClientTestUtils.createPartitionsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.createPartitions((java.util.Map)ArgumentMatchers.any(), (CreatePartitionsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> topicService.alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"}))))).getCause() instanceof ThrottlingQuotaExceededException));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).createPartitions((java.util.Map)ArgumentMatchers.argThat(x$17 -> ((NewPartitions)x$17.get(this.testTopicName())).totalCount() == 3), (CreatePartitionsOptions)ArgumentMatchers.argThat(x$18 -> !x$18.shouldRetryOnQuotaViolation()));
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$5) {
        return x$5.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaServer x$6) {
        return x$6.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandIntegrationTest $this, MetadataResponseData.MetadataResponseTopic x$7) {
        return x$7.name().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponseData.MetadataResponsePartition x$8) {
        return x$8.partitionIndex() == partitionOnBroker0$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandIntegrationTest $this, int partitionOnBroker0$1, boolean result, KafkaServer server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        scala.collection.immutable.Set x$1;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)(x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()}))), x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((MetadataResponseData.MetadataResponseTopic)topicMetadatas.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$7))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$8)));
        if (None$.MODULE$.equals(testPartitionMetadata)) {
            throw new AssertionError((Object)"Partition metadata is not found in metadata cache");
        }
        if (!(testPartitionMetadata instanceof Some)) {
            throw new MatchError((Object)testPartitionMetadata);
        }
        MetadataResponseData.MetadataResponsePartition metadata = (MetadataResponseData.MetadataResponsePartition)((Some)testPartitionMetadata).value();
        boolean bl = result && metadata.errorCode() == Errors.LEADER_NOT_AVAILABLE.code();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$2(TopicCommandIntegrationTest $this, int partitionOnBroker0$1) {
        return BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)$this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$3(x$6)))).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$4($this, partitionOnBroker0$1, BoxesRunTime.unboxToBoolean((Object)result), server))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnavailablePartitions$7(TopicCommandIntegrationTest $this) {
        return new StringBuilder(41).append("Partition metadata for ").append($this.testTopicName()).append(" is not propagated").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitions$1(KafkaServer x$9) {
        return x$9.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(KafkaServer x$10) {
        return x$10.config().brokerId() == 0;
    }

    public static final /* synthetic */ int $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(KafkaServer x$11) {
        return x$11.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(TopicCommandIntegrationTest $this, TopicPartition tp$1) {
        return !((PartitionReassignment)((java.util.Map)$this.adminClient().listPartitionReassignments(Collections.singleton(tp$1)).reassignments().get()).get(tp$1)).addingReplicas().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4() {
        return "Reassignment didn't add the second node";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(PartitionReassignment x$13) {
        return x$13.addingReplicas().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(KafkaServer x$14) {
        return x$14.config().brokerId() == 0;
    }

    public TopicCommandIntegrationTest() {
        RackAwareTest.$init$(this);
        this.numPartitions = 1;
        this.defaultReplicationFactor = (short)1;
    }
}

