/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import kafka.admin.AdminOperationException;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.utils.Exit$;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0005\n\u0001/!)a\u0004\u0001C\u0001?!1!\u0005\u0001Q\u0001\n\rBaa\u000b\u0001!\u0002\u0013\u0019\u0003\"\u0002\u0017\u0001\t\u0003i\u0003\"\u0002 \u0001\t\u0003i\u0003\"\u0002!\u0001\t\u0003i\u0003\"\u0002\"\u0001\t\u0003i\u0003\"\u0002#\u0001\t\u0003i\u0003\"\u0002$\u0001\t\u0003i\u0003\"\u0002%\u0001\t\u0003i\u0003\"\u0002&\u0001\t\u0003i\u0003\"\u0002'\u0001\t\u0003i\u0003\"\u0002(\u0001\t\u0003i\u0003\"\u0002)\u0001\t\u0003i\u0003\"\u0002*\u0001\t\u0003i\u0003B\u0002+\u0001A\u0013%QK\u0001\tU_BL7mQ8n[\u0006tG\rV3ti*\u00111\u0003F\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002+\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\t\t\u0003C\u0001i\u0011AE\u0001\u000bEJ|7.\u001a:MSN$\bC\u0001\u0013*\u001b\u0005)#B\u0001\u0014(\u0003\u0011a\u0017M\\4\u000b\u0003!\nAA[1wC&\u0011!&\n\u0002\u0007'R\u0014\u0018N\\4\u0002\u0013Q|\u0007/[2OC6,\u0017A\t;fgRL5OT8u+:$WM\u001d*fa2L7-\u0019;fI^CWM\\!eI&tw\rF\u0001/!\tIr&\u0003\u000215\t!QK\\5uQ\t!!\u0007\u0005\u00024y5\tAG\u0003\u00026m\u0005\u0019\u0011\r]5\u000b\u0005]B\u0014a\u00026va&$XM\u001d\u0006\u0003si\nQA[;oSRT\u0011aO\u0001\u0004_J<\u0017BA\u001f5\u0005\u0011!Vm\u001d;\u0002MQ,7\u000f^!mi\u0016\u0014x+\u001b;i+:\u001c\b/Z2jM&,G\rU1si&$\u0018n\u001c8D_VtG\u000f\u000b\u0002\u0006e\u0005\tC/Z:u\u0007>tg-[4PaR<\u0016\u000e\u001e5C_>$8\u000f\u001e:baN+'O^3sg\"\u0012aAM\u0001Bi\u0016\u001cHo\u0011:fCR,w+\u001b;i!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u/&$\bn\\;u%\u0016\u0004H.[2bi&|gNR1di>\u00148\u000b[8vY\u0012\u001cVoY2fK\u0012D#a\u0002\u001a\u0002\u0003R,7\u000f^\"sK\u0006$XmV5uQJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'oV5uQ>,H\u000fU1si&$\u0018n\u001c8D_VtGo\u00155pk2$7+^2dK\u0016$\u0007F\u0001\u00053\u0003%\"Xm\u001d;De\u0016\fG/Z,ji\"\f5o]5h]6,g\u000e^!oIB\u000b'\u000f^5uS>t7i\\;oi\"\u0012\u0011BM\u0001-i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001c3SKBd\u0017nY1uS>tg)Y2u_JD#A\u0003\u001a\u0002\u0001R,7\u000f^\"sK\u0006$XmV5uQ>,H\u000fU1si&$\u0018n\u001c8D_VtG/\u00118e%\u0016\u0004H.[2bi&|gNR1di>\u00148\u000b[8vY\u0012\u001cVoY2fK\u0012D#a\u0003\u001a\u00023Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3TQ>,H\u000eZ*vG\u000e,W\r\u001a\u0015\u0003\u0019I\n1\u0005^3tiB\u000b'o]3BgNLwM\\7f]R$U\u000f\u001d7jG\u0006$X-\u00128ue&,7\u000f\u000b\u0002\u000ee\u0005aC/Z:u!\u0006\u00148/Z!tg&<g.\\3oiB\u000b'\u000f^5uS>t7o\u00144ES\u001a4WM]3oiNK'0\u001a\u0015\u0003\u001dI\n1\u0003^3tiB\u000b'o]3BgNLwM\\7f]RD#a\u0004\u001a\u0002/\u0005\u001c8/\u001a:u\u0007\",7m[!sON,\u00050\u001b;D_\u0012,Gc\u0001\u0018W7\")q\u000b\u0005a\u00011\u0006AQ\r\u001f9fGR,G\r\u0005\u0002\u001a3&\u0011!L\u0007\u0002\u0004\u0013:$\b\"\u0002/\u0011\u0001\u0004i\u0016aB8qi&|gn\u001d\t\u0003=\"t!a\u00184\u000f\u0005\u0001,gBA1e\u001b\u0005\u0011'BA2\u0017\u0003\u0019a$o\\8u}%\tQ#\u0003\u0002\u0014)%\u0011qME\u0001\r)>\u0004\u0018nY\"p[6\fg\u000eZ\u0005\u0003S*\u00141\u0003V8qS\u000e\u001cu.\\7b]\u0012|\u0005\u000f^5p]NT!a\u001a\n")
public class TopicCommandTest {
    private final String brokerList;
    private final String topicName;

    @Test
    public void testIsNotUnderReplicatedWhenAdding() {
        List replicaIds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        List replicas = (List)replicaIds.map((Function1 & Serializable & scala.Serializable)id -> TopicCommandTest.$anonfun$testIsNotUnderReplicatedWhenAdding$1(BoxesRunTime.unboxToInt((Object)id)), List$.MODULE$.canBuildFrom());
        Assertions.assertFalse((boolean)new TopicCommand.PartitionDescription("test-topic", new TopicPartitionInfo(0, new Node(1, "localhost", 9091), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new Node(1, "localhost", 9091), (List)Nil$.MODULE$)).asJava()), (Option)None$.MODULE$, false, (Option)new Some((Object)new PartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaIds.map((Function1 & Serializable & scala.Serializable)id -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), List$.MODULE$.canBuildFrom())).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava())), (Set)replicaIds.toSet()).isUnderReplicated());
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--alter", "--topic", this.topicName})));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--alter", "--topic", this.topicName, "--partitions", "3", "--config", "cleanup.policy=compact"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--alter", "--topic", this.topicName, "--partitions", "3", "--delete-config", "cleanup.policy"})));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--topic", this.topicName, "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"}));
        opts.checkArgs();
        Assertions.assertTrue((boolean)opts.hasCreateOption());
        Assertions.assertEquals((Object)this.brokerList, (Object)opts.bootstrapServer().get());
        Assertions.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreateWithPartitionCountWithoutReplicationFactorShouldSucceed() {
        new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--partitions", "2", "--topic", this.topicName})).checkArgs();
    }

    @Test
    public void testCreateWithReplicationFactorWithoutPartitionCountShouldSucceed() {
        new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--replication-factor", "3", "--topic", this.topicName})).checkArgs();
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", this.topicName})));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", this.topicName})));
    }

    @Test
    public void testCreateWithoutPartitionCountAndReplicationFactorShouldSucceed() {
        new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--topic", this.topicName})).checkArgs();
    }

    @Test
    public void testDescribeShouldSucceed() {
        new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--describe", "--topic", this.topicName})).checkArgs();
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        Assertions.assertThrows(AdminCommandFailedException.class, () -> TopicCommand$.MODULE$.parseReplicaAssignment("5:5"));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        Assertions.assertThrows(AdminOperationException.class, () -> TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1"));
    }

    @Test
    public void testParseAssignment() {
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        Assertions.assertEquals((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}))), (Object)actualAssignment);
    }

    /*
     * WARNING - void declaration
     */
    private void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(exitCode, x$1) -> TopicCommandTest.$anonfun$assertCheckArgsExitCode$1(expected, BoxesRunTime.unboxToInt((Object)exitCode), x$1);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Assertions.assertThrows(RuntimeException.class, () -> options.checkArgs());
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    public static final /* synthetic */ Node $anonfun$testIsNotUnderReplicatedWhenAdding$1(int id) {
        return new Node(id, "localhost", 9090 + id);
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertCheckArgsExitCode$1(int expected$1, int exitCode, Option x$1) {
        Assertions.assertEquals((int)expected$1, (int)exitCode);
        throw new RuntimeException();
    }

    public TopicCommandTest() {
        this.brokerList = "localhost:9092";
        this.topicName = "topicName";
    }
}

