/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.KafkaSasl$;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=g\u0001B\u0013'\u0001-BQa\r\u0001\u0005\u0002QBqA\u000e\u0001C\u0002\u0013\u0005s\u0007\u0003\u0004?\u0001\u0001\u0006I\u0001\u000f\u0005\u0006\u007f\u0001!\t\u0006\u0011\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u0019A\u0006\u0001)A\u0005!\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006BB2\u0001A\u0003%1\fC\u0004e\u0001\t\u0007I\u0011B3\t\rA\u0004\u0001\u0015!\u0003g\u0011\u0015\t\b\u0001\"\u0015s\u0011\u001dY\bA1A\u0005RqDq!!\u0004\u0001A\u0003%Q\u0010\u0003\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0015}\u0011\u001d\t\t\u0002\u0001Q\u0001\nuDq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u00022\u0001!\t%!\u0006\t\u000f\u0005m\u0002\u0001\"\u0001\u0002\u0016!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u0003\u0003\u0003A\u0011BAB\u0011\u001d\t)\n\u0001C\u0005\u0003/Cq!!2\u0001\t\u0013\t9\rC\u0004\u0002X\u0002!I!!7\t\u000f\u0005\u0005\b\u0001\"\u0003\u0002d\"9\u00111\u001e\u0001\u0005\n\u00055\bbBAy\u0001\u0011%\u00111\u001f\u0005\n\u0005\u007f\u0001\u0011\u0013!C\u0005\u0005\u0003BqAa\u0017\u0001\t\u0013\u0011i\u0006C\u0004\u0003x\u0001!IA!\u001f\t\u0013\t5\u0005!%A\u0005\n\t\r\u0003b\u0002BH\u0001\u0011%!\u0011\u0013\u0005\b\u0005+\u0003A\u0011\u0002BL\u0011\u001d\u0011\t\f\u0001C\u0005\u0005gC\u0011B!1\u0001#\u0003%IAa1\t\u000f\t\u001d\u0007\u0001\"\u0003\u0003J\nYQ*\u001a;sS\u000e\u001cH+Z:u\u0015\t9\u0003&A\u0002ba&T\u0011!K\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001A\u0006\r\t\u0003[9j\u0011AJ\u0005\u0003_\u0019\u0012a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o\u001d\t\u0003[EJ!A\r\u0014\u0003\u0013M\u000b7\u000f\\*fiV\u0004\u0018A\u0002\u001fj]&$h\bF\u00016!\ti\u0003!A\u0006ce>\\WM]\"pk:$X#\u0001\u001d\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u0007%sG/\u0001\u0007ce>\\WM]\"pk:$\b%\u0001\u0007mSN$XM\\3s\u001d\u0006lW-F\u0001B!\t\u0011E*D\u0001D\u0015\t!U)A\u0004oKR<xN]6\u000b\u0005\u0019;\u0015AB2p[6|gN\u0003\u0002*\u0011*\u0011\u0011JS\u0001\u0007CB\f7\r[3\u000b\u0003-\u000b1a\u001c:h\u0013\ti5I\u0001\u0007MSN$XM\\3s\u001d\u0006lW-\u0001\rlC\u001a\\\u0017m\u00117jK:$8+Y:m\u001b\u0016\u001c\u0007.\u00198jg6,\u0012\u0001\u0015\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000bA\u0001\\1oO*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005\u0019\u0019FO]5oO\u0006I2.\u00194lC\u000ec\u0017.\u001a8u'\u0006\u001cH.T3dQ\u0006t\u0017n]7!\u0003eY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:\u0016\u0003m\u00032\u0001X1Q\u001b\u0005i&B\u00010`\u0003%IW.\\;uC\ndWM\u0003\u0002au\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\tl&\u0001\u0002'jgR\f!d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ng\u0002\n\u0001d[1gW\u0006\u001cVM\u001d<fe*\u000b\u0017m]#oiJLh*Y7f+\u00051\u0007CA4o\u001d\tAG\u000e\u0005\u0002ju5\t!N\u0003\u0002lU\u00051AH]8pizJ!!\u001c\u001e\u0002\rA\u0013X\rZ3g\u0013\t9vN\u0003\u0002nu\u0005I2.\u00194lCN+'O^3s\u0015\u0006\f7/\u00128ueft\u0015-\\3!\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001t!\t!\u00180D\u0001v\u0015\t1x/\u0001\u0003bkRD'B\u0001=F\u0003!\u0019XmY;sSRL\u0018B\u0001>v\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.\u0001\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm]\u000b\u0002{B!\u0011H`A\u0001\u0013\ty(H\u0001\u0003T_6,\u0007\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dA+\u0001\u0003vi&d\u0017\u0002BA\u0006\u0003\u000b\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003U\u0019XM\u001d<feN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0002\nAc\u00197jK:$8+Y:m!J|\u0007/\u001a:uS\u0016\u001c\u0018!F2mS\u0016tGoU1tYB\u0013x\u000e]3si&,7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003/\u00012!OA\r\u0013\r\tYB\u000f\u0002\u0005+:LG\u000fK\u0002\u0011\u0003?\u0001B!!\t\u0002.5\u0011\u00111\u0005\u0006\u0004O\u0005\u0015\"\u0002BA\u0014\u0003S\tqA[;qSR,'OC\u0002\u0002,)\u000bQA[;oSRLA!a\f\u0002$\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3!EA\u001b!\u0011\t\t#a\u000e\n\t\u0005e\u00121\u0005\u0002\n\u0003\u001a$XM]#bG\"\f1\u0002^3ti6+GO]5dg\"\u001a!#a\u0010\u0011\t\u0005\u0005\u0012\u0011I\u0005\u0005\u0003\u0007\n\u0019C\u0001\u0003UKN$\u0018aC:f]\u0012\u0014VmY8sIN$\"\"a\u0006\u0002J\u0005\u001d\u00141NA8\u0011\u001d\tYe\u0005a\u0001\u0003\u001b\n\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0003\u001f\n9&a\u0017\u0002\\5\u0011\u0011\u0011\u000b\u0006\u0005\u0003\u0017\n\u0019FC\u0002\u0002V\u001d\u000bqa\u00197jK:$8/\u0003\u0003\u0002Z\u0005E#!D&bM.\f\u0007K]8ek\u000e,'\u000fE\u0003:\u0003;\n\t'C\u0002\u0002`i\u0012Q!\u0011:sCf\u00042!OA2\u0013\r\t)G\u000f\u0002\u0005\u0005f$X\r\u0003\u0004\u0002jM\u0001\r\u0001O\u0001\u000b]Vl'+Z2pe\u0012\u001c\bBBA7'\u0001\u0007\u0001(\u0001\u0006sK\u000e|'\u000fZ*ju\u0016Dq!!\u001d\u0014\u0001\u0004\t\u0019(\u0001\u0002uaB!\u0011QOA<\u001b\u0005)\u0015bAA=\u000b\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017!H4f]\u0016\u0014\u0018\r^3BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3\u0015\t\u0005]\u0011q\u0010\u0005\b\u0003c\"\u0002\u0019AA:\u0003%2XM]5gs.\u000bgm[1SCR,W*\u001a;sS\u000e\u001c\b*\u0019<f\u0007VlW\u000f\\1uSZ,7i\\;oiR1\u0011qCAC\u0003\u000fCq!a\u0013\u0016\u0001\u0004\ti\u0005C\u0004\u0002\nV\u0001\r!a#\u0002\u0011\r|gn];nKJ\u0004\u0002\"!$\u0002\u0012\u0006m\u00131L\u0007\u0003\u0003\u001fSA!!#\u0002T%!\u00111SAH\u00055Y\u0015MZ6b\u0007>t7/^7fe\u0006Qb/\u001a:jMf\u001cE.[3oiZ+'o]5p]6+GO]5dgR1\u0011qCAM\u0003\u0003Dq!a'\u0017\u0001\u0004\ti*A\u0004nKR\u0014\u0018nY:1\t\u0005}\u0015q\u0016\t\t\u0003\u0007\t\t+!*\u0002,&!\u00111UA\u0003\u0005\ri\u0015\r\u001d\t\u0005\u0003k\n9+C\u0002\u0002*\u0016\u0013!\"T3ue&\u001cg*Y7f!\u0011\ti+a,\r\u0001\u0011a\u0011\u0011WAM\u0003\u0003\u0005\tQ!\u0001\u00024\n\u0019q\fJ\u0019\u0012\t\u0005U\u00161\u0018\t\u0004s\u0005]\u0016bAA]u\t9aj\u001c;iS:<\u0007\u0003BA;\u0003{K1!a0F\u0005\u0019iU\r\u001e:jG\"1\u00111\u0019\fA\u0002\u0019\fa!\u001a8uSRL\u0018!\t<fe&4\u0017P\u0011:pW\u0016\u0014\u0018)\u001e;iK:$\u0018nY1uS>tW*\u001a;sS\u000e\u001cH\u0003BA\f\u0003\u0013Dq!a3\u0018\u0001\u0004\ti-\u0001\u0004tKJ4XM\u001d\t\u0005\u0003\u001f\f\u0019.\u0004\u0002\u0002R*\u0019\u00111\u001a\u0015\n\t\u0005U\u0017\u0011\u001b\u0002\f\u0017\u000647.Y*feZ,'/\u0001\u0013wKJLg-\u001f\"s_.,'/T3tg\u0006<WmQ8om\u0016\u00148/[8o\u001b\u0016$(/[2t)!\t9\"a7\u0002^\u0006}\u0007bBAf1\u0001\u0007\u0011Q\u001a\u0005\u0007\u0003[B\u0002\u0019\u0001\u001d\t\u000f\u0005E\u0004\u00041\u0001\u0002t\u0005)b/\u001a:jMf\u0014%o\\6fej[W*\u001a;sS\u000e\u001cHCBA\f\u0003K\f9\u000fC\u0004\u0002Lf\u0001\r!!4\t\r\u0005%\u0018\u00041\u0001g\u0003\u0015!x\u000e]5d\u0003a1XM]5gs\n\u0013xn[3s\u000bJ\u0014xN]'fiJL7m\u001d\u000b\u0005\u0003/\ty\u000fC\u0004\u0002Lj\u0001\r!!4\u0002#Y,'/\u001b4z\u0017\u000647.Y'fiJL7-\u0006\u0003\u0002v\u0006mHCCA|\u0005G\u00119Ca\r\u00036Q!\u0011\u0011 B\u0004!\u0011\ti+a?\u0005\u000f\u0005u8D1\u0001\u0002\u0000\n\tA+\u0005\u0003\u00026\n\u0005\u0001cA\u001d\u0003\u0004%\u0019!Q\u0001\u001e\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003\nm\u0001\rAa\u0003\u0002\rY,'/\u001b4z!\u001dI$Q\u0002B\t\u0003sL1Aa\u0004;\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0004\u0003\u0014\tu\u00111\u0018\b\u0005\u0005+\u0011IBD\u0002j\u0005/I\u0011aO\u0005\u0004\u00057Q\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005?\u0011\tC\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0011YB\u000f\u0005\u0007\u0005KY\u0002\u0019\u00014\u0002\t9\fW.\u001a\u0005\b\u00037[\u0002\u0019\u0001B\u0015a\u0011\u0011YCa\f\u0011\u0011\u0005\r\u0011\u0011UAS\u0005[\u0001B!!,\u00030\u0011a!\u0011\u0007B\u0014\u0003\u0003\u0005\tQ!\u0001\u00024\n\u0019q\f\n\u001a\t\r\u0005\r7\u00041\u0001g\u0011%\u00119d\u0007I\u0001\u0002\u0004\u0011I$A\u0003he>,\b\u000f\u0005\u0003:\u0005w1\u0017b\u0001B\u001fu\t1q\n\u001d;j_:\f1D^3sS\u001aL8*\u00194lC6+GO]5dI\u0011,g-Y;mi\u0012\"T\u0003\u0002B\"\u00053*\"A!\u0012+\t\te\"qI\u0016\u0003\u0005\u0013\u0002BAa\u0013\u0003V5\u0011!Q\n\u0006\u0005\u0005\u001f\u0012\t&A\u0005v]\u000eDWmY6fI*\u0019!1\u000b\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003X\t5#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00129\u0011Q \u000fC\u0002\u0005}\u0018aE7bq.\u000bgm[1NKR\u0014\u0018n\u0019,bYV,GC\u0003B0\u0005K\u00129Ga\u001d\u0003vA\u0019\u0011H!\u0019\n\u0007\t\r$H\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u0005Ki\u0002\u0019\u00014\t\u000f\u0005mU\u00041\u0001\u0003jA\"!1\u000eB8!!\t\u0019!!)\u0002&\n5\u0004\u0003BAW\u0005_\"AB!\u001d\u0003h\u0005\u0005\t\u0011!B\u0001\u0003g\u00131a\u0018\u00134\u0011\u0019\t\u0019-\ba\u0001M\"9!qG\u000fA\u0002\te\u0012!\u0007<fe&4\u0017pS1gW\u0006lU\r\u001e:jGJ+7m\u001c:eK\u0012$\"\"a\u0006\u0003|\tu$\u0011\u0012BF\u0011\u0019\u0011)C\ba\u0001M\"9\u00111\u0014\u0010A\u0002\t}\u0004\u0007\u0002BA\u0005\u000b\u0003\u0002\"a\u0001\u0002\"\u0006\u0015&1\u0011\t\u0005\u0003[\u0013)\t\u0002\u0007\u0003\b\nu\u0014\u0011!A\u0001\u0006\u0003\t\u0019LA\u0002`IQBa!a1\u001f\u0001\u00041\u0007\"\u0003B\u001c=A\u0005\t\u0019\u0001B\u001d\u0003\r2XM]5gs.\u000bgm[1NKR\u0014\u0018n\u0019*fG>\u0014H-\u001a3%I\u00164\u0017-\u001e7uIQ\n\u0011#_1n[\u0016\u0014X*\u001a;sS\u000e4\u0016\r\\;f)\u0011\u0011\tAa%\t\r\t\u0015\u0002\u00051\u0001g\u0003=I\u0018-\\7fe\"K7\u000f^8he\u0006lG\u0003\u0002BM\u0005_\u0003BAa'\u0003,6\u0011!Q\u0014\u0006\u0005\u0005?\u0013\t+\u0001\u0003d_J,'\u0002BAN\u0005GSAA!*\u0003(\u00061\u00110Y7nKJT!A!+\u0002\u0007\r|W.\u0003\u0003\u0003.\nu%!\u0003%jgR|wM]1n\u0011\u0019\u0011)#\ta\u0001M\u0006Qb/\u001a:jMfL\u0016-\\7fe6+GO]5d%\u0016\u001cwN\u001d3fIR1!q\fB[\u0005oCaA!\n#\u0001\u00041\u0007\"\u0003B\u0005EA\u0005\t\u0019\u0001B]!\u001dI$Q\u0002B0\u0005w\u00032!\u000fB_\u0013\r\u0011yL\u000f\u0002\b\u0005>|G.Z1o\u0003\u00112XM]5gsf\u000bW.\\3s\u001b\u0016$(/[2SK\u000e|'\u000fZ3eI\u0011,g-Y;mi\u0012\u0012TC\u0001BcU\u0011\u0011ILa\u0012\u0002-Y,'/\u001b4z\u001d>\u0014V-];fgRlU\r\u001e:jGN$B!a\u0006\u0003L\"1!Q\u001a\u0013A\u0002\u0019\fA\"\u001a:s_JlUm]:bO\u0016\u0004")
public class MetricsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final int brokerCount;
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final String kafkaServerJaasEntryName;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final File kafka$api$SaslSetup$$workDir;
    private final Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public String jaasScramClientLoginModule(String clientSaslScramMechanism, String scramUser, String scramPassword) {
        return SaslSetup.jaasScramClientLoginModule$(this, clientSaslScramMechanism, scramUser, scramPassword);
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return SaslSetup.createPrivilegedAdminClient$(this);
    }

    @Override
    public Admin createAdminClient(String brokerList, SecurityProtocol securityProtocol, Option<File> trustStoreFile, Option<Properties> clientSaslProperties, String scramMechanism, String user, String password) {
        return SaslSetup.createAdminClient$(this, brokerList, securityProtocol, trustStoreFile, clientSaslProperties, scramMechanism, user, password);
    }

    @Override
    public void createScramCredentialsViaPrivilegedAdminClient(String userName, String password) {
        SaslSetup.createScramCredentialsViaPrivilegedAdminClient$(this, userName, password);
    }

    @Override
    public void createScramCredentials(Admin adminClient, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, adminClient, userName, password);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$((SaslSetup)this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    private String kafkaServerJaasEntryName() {
        return this.kafkaServerJaasEntryName;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.SASL_PLAINTEXT;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.verifyNoRequestMetrics("Request metrics not removed in a previous test");
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), KafkaSasl$.MODULE$, this.kafkaServerJaasEntryName()));
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
        this.verifyNoRequestMetrics("Request metrics not removed in this test");
    }

    @Test
    public void testMetrics() {
        String topic = "topicWithOldMessageFormat";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic, 1, 1, props);
        TopicPartition tp = new TopicPartition(topic, 0);
        int numRecords = 10;
        int recordSize = 100000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, numRecords, recordSize, tp);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp, (List)Nil$.MODULE$)).asJava());
        consumer.seek(tp, 0L);
        TestUtils$.MODULE$.consumeRecords(consumer, numRecords, TestUtils$.MODULE$.consumeRecords$default$3());
        this.verifyKafkaRateMetricsHaveCumulativeCount(producer, consumer);
        this.verifyClientVersionMetrics(consumer.metrics(), "Consumer");
        this.verifyClientVersionMetrics(producer.metrics(), "Producer");
        KafkaServer server = (KafkaServer)this.servers().head();
        this.verifyBrokerMessageConversionMetrics(server, recordSize, tp);
        this.verifyBrokerErrorMetrics((KafkaServer)this.servers().head());
        this.verifyBrokerZkMetrics(server, topic);
        this.generateAuthenticationFailure(tp);
        this.verifyBrokerAuthenticationMetrics(server);
    }

    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, int recordSize, TopicPartition tp) {
        byte[] bytes = new byte[recordSize];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), Predef$.MODULE$.long2Long((long)BoxesRunTime.unboxToInt((Object)i)), (Object)new StringBuilder(4).append("key ").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(), (Object)bytes)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
    }

    private void generateAuthenticationFailure(TopicPartition tp) {
        Properties saslProps = new Properties();
        saslProps.put("sasl.mechanism", this.kafkaClientSaslMechanism());
        saslProps.put("sasl.jaas.config", TestJaasConfig.jaasConfigProperty((String)this.kafkaClientSaslMechanism(), (String)"badUser", (String)"badPass"));
        String x$1 = this.brokerList();
        int x$2 = 0;
        int x$3 = 1000;
        long x$4 = 1000L;
        SecurityProtocol x$5 = this.securityProtocol();
        Option<File> x$6 = this.trustStoreFile();
        Some x$7 = new Some((Object)saslProps);
        long x$8 = TestUtils$.MODULE$.createProducer$default$4();
        int x$9 = TestUtils$.MODULE$.createProducer$default$5();
        int x$10 = TestUtils$.MODULE$.createProducer$default$6();
        int x$11 = TestUtils$.MODULE$.createProducer$default$7();
        int x$12 = TestUtils$.MODULE$.createProducer$default$8();
        String x$13 = TestUtils$.MODULE$.createProducer$default$9();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, x$2, x$4, x$8, x$9, x$10, x$11, x$12, x$13, x$3, x$5, x$6, (Option<Properties>)x$7, x$14, x$15, x$16);){
            try {
                producer.send(new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
            }
            catch (Exception exception) {}
        }
    }

    private void verifyKafkaRateMetricsHaveCumulativeCount(KafkaProducer<byte[], byte[]> producer, KafkaConsumer<byte[], byte[]> consumer) {
        Set consumerMetricNames = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(consumer.metrics().keySet()).asScala()).toSet();
        ((IterableLike)consumerMetricNames.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(x$1)))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            MetricsTest.verify$1(x$2, consumerMetricNames);
            return BoxedUnit.UNIT;
        });
        Set producerMetricNames = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(producer.metrics().keySet()).asScala()).toSet();
        Set producerExclusions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression-rate"}));
        ((IterableLike)((TraversableLike)producerMetricNames.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(x$3)))).filterNot((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToBoolean((boolean)producerExclusions.contains((Object)metricName.name())))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            MetricsTest.verify$1(x$4, producerMetricNames);
            return BoxedUnit.UNIT;
        });
        this.verifyKafkaMetricRecorded("records-consumed-rate", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("records-consumed-total", consumer.metrics(), "Consumer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-rate", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
        this.verifyKafkaMetricRecorded("record-send-total", producer.metrics(), "Producer", this.verifyKafkaMetricRecorded$default$4());
    }

    private void verifyClientVersionMetrics(Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity) {
        new .colon.colon((Object)"commit-id", (List)new .colon.colon((Object)"version", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)name -> {
            MetricsTest.$anonfun$verifyClientVersionMetrics$1(this, metrics, entity, name);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void verifyBrokerAuthenticationMetrics(KafkaServer server) {
        Map metrics = server.metrics().metrics();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$1(this, metrics)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)MetricsTest.$anonfun$verifyBrokerAuthenticationMetrics$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.verifyKafkaMetricRecorded("successful-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("successful-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-rate", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
        this.verifyKafkaMetricRecorded("failed-authentication-total", metrics, "Broker", (Option<String>)new Some((Object)"socket-server-metrics"));
    }

    private void verifyBrokerMessageConversionMetrics(KafkaServer server, int recordSize, TopicPartition tp) {
        String requestMetricsPrefix = "kafka.network:type=RequestMetrics";
        double requestBytes = this.verifyYammerMetricRecorded(new StringBuilder(34).append(requestMetricsPrefix).append(",name=RequestBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        double tempBytes = this.verifyYammerMetricRecorded(new StringBuilder(42).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Produce").toString(), this.verifyYammerMetricRecorded$default$2());
        Assertions.assertTrue((tempBytes >= (double)recordSize ? 1 : 0) != 0, (String)new StringBuilder(57).append("Unexpected temporary memory size requestBytes ").append(requestBytes).append(" tempBytes ").append(tempBytes).toString());
        this.verifyYammerMetricRecorded("kafka.server:type=BrokerTopicMetrics,name=ProduceMessageConversionsPerSec", this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name = new StringBuilder(46).append(requestMetricsPrefix).append(",name=MessageConversionsTimeMs,request=Produce").toString();
        double verifyYammerMetricRecorded_metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$1(verifyYammerMetricRecorded_metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name).append(" value ").append(verifyYammerMetricRecorded_metricValue).toString());
        this.verifyYammerMetricRecorded(new StringBuilder(32).append(requestMetricsPrefix).append(",name=RequestBytes,request=Fetch").toString(), this.verifyYammerMetricRecorded$default$2());
        String verifyYammerMetricRecorded_name2 = new StringBuilder(40).append(requestMetricsPrefix).append(",name=TemporaryMemoryBytes,request=Fetch").toString();
        double verifyYammerMetricRecorded_metricValue2 = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(verifyYammerMetricRecorded_name2));
        Assertions.assertTrue((boolean)MetricsTest.$anonfun$verifyBrokerMessageConversionMetrics$2(verifyYammerMetricRecorded_metricValue2), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(verifyYammerMetricRecorded_name2).append(" value ").append(verifyYammerMetricRecorded_metricValue2).toString());
        this.verifyYammerMetricRecorded(new StringBuilder(35).append(requestMetricsPrefix).append(",name=RequestBytes,request=Metadata").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private void verifyBrokerZkMetrics(KafkaServer server, String topic) {
        Histogram histogram = this.yammerHistogram("kafka.server:type=ZooKeeperClientMetrics,name=ZooKeeperRequestLatencyMs");
        long initialCount = histogram.count();
        ((KafkaServer)this.servers().head()).zkClient().getLeaderForPartition(new TopicPartition(topic, 0));
        Assertions.assertTrue((histogram.count() > initialCount ? 1 : 0) != 0, (String)"ZooKeeper latency not recorded");
        double min = histogram.min();
        Assertions.assertTrue((min >= 0.0 ? 1 : 0) != 0, (String)new StringBuilder(36).append("Min latency should not be negative: ").append(min).toString());
        Assertions.assertEquals((Object)"CONNECTED", (Object)this.yammerMetricValue("SessionState"), (String)"Unexpected ZK state");
    }

    private void verifyBrokerErrorMetrics(KafkaServer server) {
        int startErrorMetricCount = MetricsTest.errorMetricCount$1();
        String errorMetricPrefix = "kafka.network:type=RequestMetrics,name=ErrorsPerSec";
        this.verifyYammerMetricRecorded(new StringBuilder(28).append(errorMetricPrefix).append(",request=Metadata,error=NONE").toString(), this.verifyYammerMetricRecorded$default$2());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        try {
            consumer.partitionsFor("12{}!");
        }
        catch (InvalidTopicException invalidTopicException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(47).append(errorMetricPrefix).append(",request=Metadata,error=INVALID_TOPIC_EXCEPTION").toString(), this.verifyYammerMetricRecorded$default$2());
        int currentErrorMetricCount = MetricsTest.errorMetricCount$1();
        Assertions.assertEquals((int)(startErrorMetricCount + 1), (int)currentErrorMetricCount);
        Assertions.assertTrue((currentErrorMetricCount < 10 ? 1 : 0) != 0, (String)new StringBuilder(23).append("Too many error metrics ").append(currentErrorMetricCount).toString());
        try {
            consumer.partitionsFor("non-existing-topic");
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {}
        this.verifyYammerMetricRecorded(new StringBuilder(50).append(errorMetricPrefix).append(",request=Metadata,error=UNKNOWN_TOPIC_OR_PARTITION").toString(), this.verifyYammerMetricRecorded$default$2());
    }

    private <T> T verifyKafkaMetric(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group, Function1<Iterable<org.apache.kafka.common.Metric>, T> verify) {
        scala.collection.mutable.Map matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, verifyKafkaMetric_group, x0$1)));
        Assertions.assertTrue((boolean)matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return (T)verify.apply((Object)matchingMetrics.values());
    }

    private <T> Option<String> verifyKafkaMetric$default$4() {
        return None$.MODULE$;
    }

    private double maxKafkaMetricValue(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, verifyKafkaMetric_group, x0$1)));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        return MetricsTest.$anonfun$maxKafkaMetricValue$1(verifyKafkaMetric_matchingMetrics.values());
    }

    private void verifyKafkaMetricRecorded(String name, Map<MetricName, ? extends org.apache.kafka.common.Metric> metrics, String entity, Option<String> group) {
        double value = this.maxKafkaMetricValue(name, metrics, entity, group);
        Assertions.assertTrue((value > 0.0 ? 1 : 0) != 0, (String)new StringBuilder(42).append(entity).append(" metric not recorded correctly for ").append(name).append(" value ").append(value).toString());
    }

    private Option<String> verifyKafkaMetricRecorded$default$4() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private Object yammerMetricValue(String name) {
        void var5_4;
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerMetricValue$1(name, x0$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getMBeanName(), Set$.MODULE$.canBuildFrom())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        Object object = var5_4 instanceof Meter ? BoxesRunTime.boxToDouble((double)((Meter)var5_4).count()) : (var5_4 instanceof Histogram ? BoxesRunTime.boxToDouble((double)((Histogram)var5_4).max()) : (var5_4 instanceof Gauge ? ((Gauge)var5_4).value() : Assertions.fail((String)new StringBuilder(34).append("Unexpected broker metric of class ").append(var5_4.getClass()).toString())));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private Histogram yammerHistogram(String name) {
        void var4_4;
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala();
        Tuple2 tuple2 = (Tuple2)allMetrics.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$yammerHistogram$1(name, x0$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(43).append("Unable to find broker metric ").append(name).append(": allMetrics: ").append(allMetrics.keySet().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getMBeanName(), Set$.MODULE$.canBuildFrom())).toString()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Metric metric = (Metric)tuple2._2();
        if (!(var4_4 instanceof Histogram)) {
            throw new AssertionError((Object)new StringBuilder(34).append("Unexpected broker metric of class ").append(var4_4.getClass()).toString());
        }
        Histogram histogram = (Histogram)var4_4;
        return histogram;
    }

    /*
     * WARNING - void declaration
     */
    private double verifyYammerMetricRecorded(String name, Function1<Object, Object> verify) {
        void var3_3;
        double metricValue = BoxesRunTime.unboxToDouble((Object)this.yammerMetricValue(name));
        Assertions.assertTrue((boolean)verify.apply$mcZD$sp(metricValue), (String)new StringBuilder(48).append("Broker metric not recorded correctly for ").append(name).append(" value ").append(metricValue).toString());
        return (double)var3_3;
    }

    private Function1<Object, Object> verifyYammerMetricRecorded$default$2() {
        return (JFunction1.mcZD.sp & Serializable & scala.Serializable)d -> d > 0.0;
    }

    private void verifyNoRequestMetrics(String errorMessage) {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyNoRequestMetrics$1(x0$1)));
        Assertions.assertTrue((boolean)metrics.isEmpty(), (String)new StringBuilder(2).append(errorMessage).append(": ").append(metrics.keys()).toString());
    }

    private static final boolean exists$1(String name, MetricName rateMetricName, Set allMetricNames) {
        return allMetricNames.contains((Object)new MetricName(name, rateMetricName.group(), "", rateMetricName.tags()));
    }

    private static final void verify$1(MetricName rateMetricName, Set allMetricNames) {
        String name = rateMetricName.name();
        boolean totalExists = MetricsTest.exists$1(name.replace("-rate", "-total"), rateMetricName, allMetricNames);
        boolean totalTimeExists = MetricsTest.exists$1(name.replace("-rate", "-time"), rateMetricName, allMetricNames);
        Assertions.assertTrue((totalExists || totalTimeExists ? 1 : 0) != 0, (String)new StringBuilder(48).append("No cumulative count/time metric for rate metric ").append(rateMetricName).toString());
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$1(MetricName x$1) {
        return x$1.name().endsWith("-rate");
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaRateMetricsHaveCumulativeCount$3(MetricName x$3) {
        return x$3.name().endsWith("-rate");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$2(String entity$1, String name$1, Iterable matchingMetrics) {
        Assertions.assertEquals((int)1, (int)matchingMetrics.size());
        org.apache.kafka.common.Metric metric = (org.apache.kafka.common.Metric)matchingMetrics.head();
        Object value = metric.metricValue();
        Assertions.assertNotNull((Object)value, (String)new StringBuilder(21).append(entity$1).append(" metric not recorded ").append(name$1).toString());
        Assertions.assertNotNull((Object)BoxesRunTime.boxToBoolean((value instanceof String && new StringOps(Predef$.MODULE$.augmentString((String)value)).nonEmpty() ? 1 : 0) != 0), (String)new StringBuilder(37).append(entity$1).append(" metric ").append(name$1).append(" should be a non-empty String").toString());
        Assertions.assertTrue((boolean)metric.metricName().tags().containsKey("client-id"), (String)"Client-id not specified");
    }

    public static final /* synthetic */ void $anonfun$verifyClientVersionMetrics$1(MetricsTest $this, Map metrics$1, String entity$1, String name) {
        Option<String> verifyKafkaMetric_group = $this.verifyKafkaMetric$default$4();
        scala.collection.mutable.Map verifyKafkaMetric_matchingMetrics = (scala.collection.mutable.Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics$1).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$1(name, verifyKafkaMetric_group, x0$1)));
        Assertions.assertTrue((boolean)verifyKafkaMetric_matchingMetrics.nonEmpty(), (String)new StringBuilder(17).append("Metric not found ").append(name).toString());
        Iterable iterable = verifyKafkaMetric_matchingMetrics.values();
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name, iterable);
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerAuthenticationMetrics$1(MetricsTest $this, Map metrics$2) {
        return $this.maxKafkaMetricValue("failed-authentication-total", metrics$2, "Broker", (Option<String>)new Some((Object)"socket-server-metrics")) > 0.0;
    }

    public static final /* synthetic */ String $anonfun$verifyBrokerAuthenticationMetrics$2() {
        return "failed-authentication-total not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$1(double value) {
        return value > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMessageConversionMetrics$2(double value) {
        return value == 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerErrorMetrics$1(com.yammer.metrics.core.MetricName x$5) {
        String string = x$5.getName();
        String string2 = "ErrorsPerSec";
        return string != null && string.equals(string2);
    }

    private static final int errorMetricCount$1() {
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyBrokerErrorMetrics$1(x$5)))).size();
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$2(MetricName metricName$1, String x$6) {
        String string = x$6;
        String string2 = metricName$1.group();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$verifyKafkaMetric$1(String name$2, Option group$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        MetricName metricName = (MetricName)x0$1._1();
        String string = metricName.name();
        boolean bl = !(string != null ? !string.equals(name$2) : name$2 != null) && group$1.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsTest.$anonfun$verifyKafkaMetric$2(metricName, x$6)));
        return bl;
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$2(double max, org.apache.kafka.common.Metric metric) {
        return Math.max(max, BoxesRunTime.unboxToDouble((Object)metric.metricValue()));
    }

    public static final /* synthetic */ double $anonfun$maxKafkaMetricValue$1(Iterable matchingMetrics) {
        return BoxesRunTime.unboxToDouble((Object)matchingMetrics.foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, metric) -> BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$2(BoxesRunTime.unboxToDouble((Object)max), metric))));
    }

    public static final /* synthetic */ boolean $anonfun$yammerMetricValue$1(String name$3, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$3);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$yammerHistogram$1(String name$4, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().endsWith(name$4);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$verifyNoRequestMetrics$1(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((com.yammer.metrics.core.MetricName)x0$1._1()).getMBeanName().startsWith("kafka.network:type=RequestMetrics");
        return bl;
    }

    public MetricsTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 1;
        this.kafkaClientSaslMechanism = "PLAIN";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.kafkaServerJaasEntryName = new StringBuilder(1).append(this.listenerName().value().toLowerCase(Locale.ROOT)).append(".").append(JaasTestUtils$.MODULE$.KafkaServerContextName()).toString();
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.8");
        this.producerConfig().setProperty("linger.ms", "10");
        this.producerConfig().setProperty("compression.type", "gzip");
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    }

    public static final /* synthetic */ Object $anonfun$maxKafkaMetricValue$1$adapted(Iterable matchingMetrics) {
        return BoxesRunTime.boxToDouble((double)MetricsTest.$anonfun$maxKafkaMetricValue$1(matchingMetrics));
    }

    public static final /* synthetic */ Object $anonfun$verifyClientVersionMetrics$2$adapted(String entity$1, String name$1, Iterable matchingMetrics) {
        MetricsTest.$anonfun$verifyClientVersionMetrics$2(entity$1, name$1, matchingMetrics);
        return BoxedUnit.UNIT;
    }
}

