/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBqA\n\u0001C\u0002\u0013\u0005q\u0005\u0003\u0004/\u0001\u0001\u0006I\u0001\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u0019I\u0004\u0001)A\u0005c!9!\b\u0001b\u0001\n\u0003\u0001\u0004BB\u001e\u0001A\u0003%\u0011\u0007C\u0004=\u0001\t\u0007I\u0011A\u0014\t\ru\u0002\u0001\u0015!\u0003)\u0011\u001dq\u0004A1A\u0005\u0002}Baa\u0017\u0001!\u0002\u0013\u0001\u0005b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007K\u0002\u0001\u000b\u0011\u00020\t\u000b\u0019\u0004A\u0011I4\t\u000bI\u0004A\u0011I:\t\r\u0005\r\u0001\u0001\"\u0011t\u0011\u0019\ti\u0001\u0001C\u0001g\"9\u0011q\u0003\u0001\u0005\n\u0005e\u0001bBA\u0014\u0001\u0011%\u0011\u0011\u0006\u0005\b\u0003\u0007\u0002A\u0011BA#\u0005\t\"&/\u00198tC\u000e$\u0018n\u001c8t/&$\b.T1y\u0013:4E.[4ii>sW\rV3ti*\u0011q\u0003G\u0001\u0004CBL'\"A\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0003?a\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011\u0011E\b\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\n\t\u0003K\u0001i\u0011AF\u0001\u000b]Vl7+\u001a:wKJ\u001cX#\u0001\u0015\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\u0007%sG/A\u0006ok6\u001cVM\u001d<feN\u0004\u0013A\u0002;pa&\u001c\u0017'F\u00012!\t\u0011t'D\u00014\u0015\t!T'\u0001\u0003mC:<'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012aa\u0015;sS:<\u0017a\u0002;pa&\u001c\u0017\u0007I\u0001\u0007i>\u0004\u0018n\u0019\u001a\u0002\u000fQ|\u0007/[23A\u0005ia.^7QCJ$\u0018\u000e^5p]N\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\fue\u0006t7/Y2uS>t\u0017\r\u001c)s_\u0012,8-\u001a:t+\u0005\u0001\u0005cA!G\u00116\t!I\u0003\u0002D\t\u00069Q.\u001e;bE2,'BA#+\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u000f\n\u0013aAQ;gM\u0016\u0014\b\u0003B%T+Vk\u0011A\u0013\u0006\u0003\u00172\u000b\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0003\u001b:\u000bqa\u00197jK:$8O\u0003\u0002\u001a\u001f*\u0011\u0001+U\u0001\u0007CB\f7\r[3\u000b\u0003I\u000b1a\u001c:h\u0013\t!&JA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0004SYC\u0016BA,+\u0005\u0015\t%O]1z!\tI\u0013,\u0003\u0002[U\t!!)\u001f;f\u0003]!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001c\b%\u0001\fue\u0006t7/Y2uS>t\u0017\r\\\"p]N,X.\u001a:t+\u0005q\u0006cA!G?B!\u0001mY+V\u001b\u0005\t'B\u00012M\u0003!\u0019wN\\:v[\u0016\u0014\u0018B\u00013b\u00055Y\u0015MZ6b\u0007>t7/^7fe\u00069BO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148\u000fI\u0001\u0010O\u0016tWM]1uK\u000e{gNZ5hgV\t\u0001\u000eE\u0002jU2l\u0011\u0001R\u0005\u0003W\u0012\u00131aU3r!\ti\u0007/D\u0001o\u0015\ty\u0007$\u0001\u0004tKJ4XM]\u0005\u0003c:\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006)1/\u001a;VaR\tA\u000f\u0005\u0002*k&\u0011aO\u000b\u0002\u0005+:LG\u000f\u000b\u0002\u0010qB\u0011\u0011p`\u0007\u0002u*\u0011qc\u001f\u0006\u0003yv\fqA[;qSR,'O\u0003\u0002\u007f#\u0006)!.\u001e8ji&\u0019\u0011\u0011\u0001>\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r\u0001\u0012q\u0001\t\u0004s\u0006%\u0011bAA\u0006u\nI\u0011I\u001a;fe\u0016\u000b7\r[\u00014i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'oU5oO2,'I]8lKJl\u0015\r_%o\r2Lw\r\u001b;P]\u0016D3!EA\t!\rI\u00181C\u0005\u0004\u0003+Q(\u0001\u0002+fgR\f1b]3sm\u0016\u0014\bK]8qgR\u0011\u00111\u0004\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011E\u001b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003K\tyB\u0001\u0006Qe>\u0004XM\u001d;jKN\f1d\u0019:fCR,'+Z1e\u0007>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014HcA0\u0002,!9\u0011QF\nA\u0002\u0005=\u0012!B4s_V\u0004\b\u0003BA\u0019\u0003\u007fqA!a\r\u0002<A\u0019\u0011Q\u0007\u0016\u000e\u0005\u0005]\"bAA\u001d5\u00051AH]8pizJ1!!\u0010+\u0003\u0019\u0001&/\u001a3fM&\u0019\u0001(!\u0011\u000b\u0007\u0005u\"&A\u000ede\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM\u001d\u000b\u0004\u0011\u0006\u001d\u0003bBA%)\u0001\u0007\u0011qF\u0001\u0010iJ\fgn]1di&|g.\u00197JI\u0002")
public class TransactionsWithMaxInFlightOneTest
extends KafkaServerTestHarness {
    private final int numServers;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public int numServers() {
        return this.numServers;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.serverProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(1));
        this.createTopic(this.topic1(), this.numPartitions(), this.numServers(), topicConfig);
        this.createTopic(this.topic2(), this.numPartitions(), this.numServers(), topicConfig);
        this.createTransactionalProducer("transactional-producer");
        this.createReadCommittedConsumer("transactional-group");
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Test
    public void testTransactionalProducerSingleBrokerMaxInFlightOne() {
        Assertions.assertEquals((int)1, (int)this.servers().size());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", true));
        producer.commitTransaction();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    private Properties serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), Integer.toString(1));
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), Boolean.toString(true));
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), Boolean.toString(false));
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createReadCommittedConsumer(String group) {
        void var2_12;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        boolean x$3 = false;
        boolean x$4 = true;
        String x$5 = TestUtils$.MODULE$.createConsumer$default$3();
        int x$6 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$5, x$3, x$4, x$6, x$7, x$8, x$9, x$10, x$11);
        this.transactionalConsumers().$plus$eq(consumer);
        return var2_12;
    }

    /*
     * WARNING - void declaration
     */
    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId) {
        void var2_9;
        Buffer<KafkaServer> x$2 = this.servers();
        int x$3 = 1;
        int x$4 = TestUtils$.MODULE$.createTransactionalProducer$default$3();
        long x$5 = TestUtils$.MODULE$.createTransactionalProducer$default$4();
        long x$6 = TestUtils$.MODULE$.createTransactionalProducer$default$5();
        int x$7 = TestUtils$.MODULE$.createTransactionalProducer$default$6();
        int x$8 = TestUtils$.MODULE$.createTransactionalProducer$default$7();
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, (Seq<KafkaServer>)x$2, x$4, x$5, x$6, x$7, x$8, x$3);
        this.transactionalProducers().$plus$eq(producer);
        return var2_9;
    }

    public TransactionsWithMaxInFlightOneTest() {
        this.numServers = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }
}

