/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.cluster.AbstractPartitionTest$;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.Partition;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.AlterIsrManager;
import kafka.server.AlterIsrManager$;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.tier.TierReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r=q!\u0002'N\u0011\u0003\u0011f!\u0002+N\u0011\u0003)\u0006\"\u0002/\u0002\t\u0003i\u0006b\u00020\u0002\u0005\u0004%\ta\u0018\u0005\u0007G\u0006\u0001\u000b\u0011\u00021\u0007\tQk\u0005\u0001\u001a\u0005\u00069\u0016!\t!\u001a\u0005\b=\u0016\u0011\r\u0011\"\u0001`\u0011\u0019\u0019W\u0001)A\u0005A\"9q-\u0002b\u0001\n\u0003A\u0007B\u0002;\u0006A\u0003%\u0011\u000eC\u0004v\u000b\t\u0007I\u0011\u0001<\t\ru,\u0001\u0015!\u0003x\u0011%qX\u00011AA\u0002\u0013\u0005q\u0010C\u0006\u0002\u0012\u0015\u0001\r\u00111A\u0005\u0002\u0005M\u0001bCA\u0010\u000b\u0001\u0007\t\u0011)Q\u0005\u0003\u0003A!\"!\t\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0000\u0011-\t\u0019#\u0002a\u0001\u0002\u0004%\t!!\n\t\u0017\u0005%R\u00011A\u0001B\u0003&\u0011\u0011\u0001\u0005\u000b\u0003W)\u0001\u0019!a\u0001\n\u0003y\bbCA\u0017\u000b\u0001\u0007\t\u0019!C\u0001\u0003_A1\"a\r\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0002!Q\u0011QG\u0003A\u0002\u0003\u0007I\u0011A@\t\u0017\u0005]R\u00011AA\u0002\u0013\u0005\u0011\u0011\b\u0005\f\u0003{)\u0001\u0019!A!B\u0013\t\t\u0001C\u0006\u0002@\u0015\u0001\r\u00111A\u0005\u0002\u0005\u0005\u0003bCA(\u000b\u0001\u0007\t\u0019!C\u0001\u0003#B1\"!\u0016\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002D!Y\u0011qK\u0003A\u0002\u0003\u0007I\u0011AA-\u0011-\t9(\u0002a\u0001\u0002\u0004%\t!!\u001f\t\u0017\u0005uT\u00011A\u0001B\u0003&\u00111\f\u0005\f\u0003\u007f*\u0001\u0019!a\u0001\n\u0003\t\t\tC\u0006\u0002\n\u0016\u0001\r\u00111A\u0005\u0002\u0005-\u0005bCAH\u000b\u0001\u0007\t\u0011)Q\u0005\u0003\u0007C1\"!%\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0014\"Y\u00111T\u0003A\u0002\u0003\u0007I\u0011AAO\u0011-\t\t+\u0002a\u0001\u0002\u0003\u0006K!!&\t\u0017\u0005\rV\u00011AA\u0002\u0013\u0005\u0011Q\u0015\u0005\f\u0003o+\u0001\u0019!a\u0001\n\u0003\tI\fC\u0006\u0002>\u0016\u0001\r\u0011!Q!\n\u0005\u001d\u0006\"CA`\u000b\t\u0007I\u0011AAa\u0011!\tI-\u0002Q\u0001\n\u0005\r\u0007\"CAf\u000b\t\u0007I\u0011AAg\u0011!\t9.\u0002Q\u0001\n\u0005=\u0007\"CAm\u000b\t\u0007I\u0011AAn\u0011!\tI/\u0002Q\u0001\n\u0005u\u0007bCAv\u000b\u0001\u0007\t\u0019!C\u0001\u0003[D1\"!>\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002x\"Y\u00111`\u0003A\u0002\u0003\u0005\u000b\u0015BAx\u0011!\ti0\u0002b\u0001\n\u0003A\u0007bBA\u0000\u000b\u0001\u0006I!\u001b\u0005\n\u0005\u0003)!\u0019!C\u0001\u0005\u0007A\u0001B!\u0005\u0006A\u0003%!Q\u0001\u0005\f\u0005')\u0001\u0019!a\u0001\n\u0003\t\t\u0005C\u0006\u0003\u0016\u0015\u0001\r\u00111A\u0005\u0002\t]\u0001b\u0003B\u000e\u000b\u0001\u0007\t\u0011)Q\u0005\u0003\u0007B\u0011B!\b\u0006\u0005\u0004%\tAa\b\t\u0011\t\u001dR\u0001)A\u0005\u0005CA\u0011B!\u000b\u0006\u0005\u0004%\tAa\u000b\t\u0011\tMR\u0001)A\u0005\u0005[A\u0011B!\u000e\u0006\u0005\u0004%\tAa\u000e\t\u0011\t\u0015S\u0001)A\u0005\u0005sA\u0011Ba\u0012\u0006\u0005\u0004%\tA!\u0013\t\u0011\t]S\u0001)A\u0005\u0005\u0017B1B!\u0017\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0014\"Y!1L\u0003A\u0002\u0003\u0007I\u0011\u0001B/\u0011-\u0011\t'\u0002a\u0001\u0002\u0003\u0006K!!&\t\u000f\t\rT\u0001\"\u0001\u0003f!9!QP\u0003\u0005\u0002\t}\u0004\"\u0003BU\u000bE\u0005I\u0011\u0001BV\u0011%\u0011\t-BI\u0001\n\u0003\u0011\u0019\rC\u0005\u0003H\u0016\t\n\u0011\"\u0001\u0003J\"9!1Q\u0003\u0005\u0012\t5\u0007b\u0002Bh\u000b\u0011\u0005!\u0011\u001b\u0005\b\u0005g,A\u0011\u0001B3\u0011\u001d\u0011i0\u0002C\t\u0005\u007f\fQ#\u00112tiJ\f7\r\u001e)beRLG/[8o)\u0016\u001cHO\u0003\u0002O\u001f\u000691\r\\;ti\u0016\u0014(\"\u0001)\u0002\u000b-\fgm[1\u0004\u0001A\u00111+A\u0007\u0002\u001b\n)\u0012IY:ue\u0006\u001cG\u000fU1si&$\u0018n\u001c8UKN$8CA\u0001W!\t9&,D\u0001Y\u0015\u0005I\u0016!B:dC2\f\u0017BA.Y\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AU\u0001\tEJ|7.\u001a:JIV\t\u0001\r\u0005\u0002XC&\u0011!\r\u0017\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!'\t)a\u000bF\u0001g!\t\u0019V!\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003%\u0004\"A\u001b:\u000e\u0003-T!\u0001\\7\u0002\r\r|W.\\8o\u0015\t\u0001fN\u0003\u0002pa\u00061\u0011\r]1dQ\u0016T\u0011!]\u0001\u0004_J<\u0017BA:l\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0005i&lW-F\u0001x!\tA80D\u0001z\u0015\tQx*A\u0003vi&d7/\u0003\u0002}s\nAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\u0004u[B$\u0015N]\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\u000e5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0002j_*\u0011\u00111B\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0010\u0005\u0015!\u0001\u0002$jY\u0016\f!\u0002^7q\t&\u0014x\fJ3r)\u0011\t)\"a\u0007\u0011\u0007]\u000b9\"C\u0002\u0002\u001aa\u0013A!\u00168ji\"I\u0011Q\u0004\b\u0002\u0002\u0003\u0007\u0011\u0011A\u0001\u0004q\u0012\n\u0014a\u0002;na\u0012K'\u000fI\u0001\bY><G)\u001b:2\u0003-awn\u001a#jeFzF%Z9\u0015\t\u0005U\u0011q\u0005\u0005\n\u0003;\t\u0012\u0011!a\u0001\u0003\u0003\t\u0001\u0002\\8h\t&\u0014\u0018\u0007I\u0001\bY><G)\u001b:3\u0003-awn\u001a#jeJzF%Z9\u0015\t\u0005U\u0011\u0011\u0007\u0005\n\u0003;!\u0012\u0011!a\u0001\u0003\u0003\t\u0001\u0002\\8h\t&\u0014(\u0007I\u0001\bY><G)\u001b:4\u0003-awn\u001a#jeNzF%Z9\u0015\t\u0005U\u00111\b\u0005\n\u0003;9\u0012\u0011!a\u0001\u0003\u0003\t\u0001\u0002\\8h\t&\u00148\u0007I\u0001\u000bY><W*\u00198bO\u0016\u0014XCAA\"!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%\u001f\u0006\u0019An\\4\n\t\u00055\u0013q\t\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003+\t\u0019\u0006C\u0005\u0002\u001ei\t\t\u00111\u0001\u0002D\u0005YAn\\4NC:\fw-\u001a:!\u0003=\tG\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014XCAA.!\u0011\ti&!\u001d\u000f\t\u0005}\u0013Q\u000e\b\u0005\u0003C\nYG\u0004\u0003\u0002d\u0005%TBAA3\u0015\r\t9'U\u0001\u0007yI|w\u000e\u001e \n\u0003AK!A_(\n\u0007\u0005=\u00140A\u0005UKN$X\u000b^5mg&!\u00111OA;\u0005MiunY6BYR,'/S:s\u001b\u0006t\u0017mZ3s\u0015\r\ty'_\u0001\u0014C2$XM]%te6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003+\tY\bC\u0005\u0002\u001eu\t\t\u00111\u0001\u0002\\\u0005\u0001\u0012\r\u001c;fe&\u001b(/T1oC\u001e,'\u000fI\u0001\u0012SN\u00148\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014XCAAB!\u0011\ti&!\"\n\t\u0005\u001d\u0015Q\u000f\u0002\u0016\u001b>\u001c7.S:s\u0007\"\fgnZ3MSN$XM\\3s\u0003UI7O]\"iC:<W\rT5ti\u0016tWM]0%KF$B!!\u0006\u0002\u000e\"I\u0011Q\u0004\u0011\u0002\u0002\u0003\u0007\u00111Q\u0001\u0013SN\u00148\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014\b%A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u0011Q\u0013\t\u0005\u0003\u000b\n9*\u0003\u0003\u0002\u001a\u0006\u001d#!\u0003'pO\u000e{gNZ5h\u00035awnZ\"p]\u001aLwm\u0018\u0013fcR!\u0011QCAP\u0011%\tibIA\u0001\u0002\u0004\t)*\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\n\u0001cY8oM&<'+\u001a9pg&$xN]=\u0016\u0005\u0005\u001d\u0006\u0003BAU\u0003gk!!a+\u000b\t\u00055\u0016qV\u0001\t[\u0016$\u0018\rZ1uC*\u0019\u0011\u0011W(\u0002\rM,'O^3s\u0013\u0011\t),a+\u0003)5{7m[\"p]\u001aLwMU3q_NLGo\u001c:z\u0003Q\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018p\u0018\u0013fcR!\u0011QCA^\u0011%\tiBJA\u0001\u0002\u0004\t9+A\td_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0002\n\u0011\u0003Z3mCf,Gm\u00149fe\u0006$\u0018n\u001c8t+\t\t\u0019\rE\u0002T\u0003\u000bL1!a2N\u0005E!U\r\\1zK\u0012|\u0005/\u001a:bi&|gn]\u0001\u0013I\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u001c\b%A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003\u001f\u0004B!!5\u0002T6\u0011\u0011qV\u0005\u0005\u0003+\fyKA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003EygMZ:fi\u000eCWmY6q_&tGo]\u000b\u0003\u0003;\u0004B!a8\u0002f6\u0011\u0011\u0011\u001d\u0006\u0005\u0003G\fy+A\u0006dQ\u0016\u001c7\u000e]8j]R\u001c\u0018\u0002BAt\u0003C\u0014\u0011c\u00144gg\u0016$8\t[3dWB|\u0017N\u001c;t\u0003IygMZ:fi\u000eCWmY6q_&tGo\u001d\u0011\u0002\u0013A\f'\u000f^5uS>tWCAAx!\r\u0019\u0016\u0011_\u0005\u0004\u0003gl%!\u0003)beRLG/[8o\u00035\u0001\u0018M\u001d;ji&|gn\u0018\u0013fcR!\u0011QCA}\u0011%\tibLA\u0001\u0002\u0004\ty/\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\nA\u0003^5fe\u0016$Gk\u001c9jGB\u000b'\u000f^5uS>t\u0017!\u0006;jKJ,G\rV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0017i&,'/\u001a3U_BL7-\u00133QCJ$\u0018\u000e^5p]V\u0011!Q\u0001\t\u0005\u0005\u000f\u0011i!\u0004\u0002\u0003\n)\u0019!1B(\u0002\tQLWM]\u0005\u0005\u0005\u001f\u0011IA\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\u00069B/[3sK\u0012$v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0016i&,'/\u00128bE2,G\rT8h\u001b\u0006t\u0017mZ3s\u0003e!\u0018.\u001a:F]\u0006\u0014G.\u001a3M_\u001el\u0015M\\1hKJ|F%Z9\u0015\t\u0005U!\u0011\u0004\u0005\n\u0003;1\u0014\u0011!a\u0001\u0003\u0007\na\u0003^5fe\u0016s\u0017M\u00197fI2{w-T1oC\u001e,'\u000fI\u0001\u0013i&,'OU3qY&\u001c\u0017-T1oC\u001e,'/\u0006\u0002\u0003\"A!!q\u0001B\u0012\u0013\u0011\u0011)C!\u0003\u0003%QKWM\u001d*fa2L7-Y'b]\u0006<WM]\u0001\u0014i&,'OU3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u0012i&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001cXC\u0001B\u0017!\u0011\t)Ea\f\n\t\tE\u0012q\t\u0002\u0012)&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001c\u0018A\u0005;jKJdunZ\"p[B|g.\u001a8ug\u0002\nQb\u00197vgR,'\u000fT5oW&#WC\u0001B\u001d!\u0011\u0011YD!\u0011\u000e\u0005\tu\"\u0002\u0002B \u0003\u0013\tA!\u001e;jY&!!1\tB\u001f\u0005\u0011)V+\u0013#\u0002\u001d\rdWo\u001d;fe2Kgn[%eA\u0005AQ\r_3dkR|'/\u0006\u0002\u0003LA!!Q\nB*\u001b\t\u0011yE\u0003\u0003\u0003R\tu\u0012AC2p]\u000e,(O]3oi&!!Q\u000bB(\u0005=)\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!C3yK\u000e,Ho\u001c:!\u0003=!\u0018.\u001a:fI2{wmQ8oM&<\u0017a\u0005;jKJ,G\rT8h\u0007>tg-[4`I\u0015\fH\u0003BA\u000b\u0005?B\u0011\"!\bB\u0003\u0003\u0005\r!!&\u0002!QLWM]3e\u0019><7i\u001c8gS\u001e\u0004\u0013!B:fiV\u0004HCAA\u000bQ\r\u0019%\u0011\u000e\t\u0005\u0005W\u0012I(\u0004\u0002\u0003n)!!q\u000eB9\u0003\r\t\u0007/\u001b\u0006\u0005\u0005g\u0012)(A\u0004kkBLG/\u001a:\u000b\u0007\t]\u0004/A\u0003kk:LG/\u0003\u0003\u0003|\t5$A\u0003\"fM>\u0014X-R1dQ\u0006\u0019R.Y6f)&,'/\u001a3QCJ$\u0018\u000e^5p]RA\u0011q\u001eBA\u0005\u001f\u0013y\nC\u0005\u0003\u0004\u0012\u0003\n\u00111\u0001\u0003\u0006\u0006Q\u0012N\u001c;fe\n\u0013xn[3s!J|Go\\2pYZ+'o]5p]B!!q\u0011BF\u001b\t\u0011IIC\u0002\u0003p=KAA!$\u0003\n\nQ\u0011\t]5WKJ\u001c\u0018n\u001c8\t\u0013\tEE\t%AA\u0002\tM\u0015\u0001\u0003>l\u00072LWM\u001c;\u0011\t\tU%1T\u0007\u0003\u0005/S1A!'P\u0003\tQ8.\u0003\u0003\u0003\u001e\n]%!D&bM.\f'l[\"mS\u0016tG\u000fC\u0005\u0003\"\u0012\u0003\n\u00111\u0001\u0003$\u0006I1o\u00195fIVdWM\u001d\t\u0004q\n\u0015\u0016b\u0001BTs\nq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\u0018!H7bW\u0016$\u0016.\u001a:fIB\u000b'\u000f^5uS>tG\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t5&\u0006\u0002BC\u0005_[#A!-\u0011\t\tM&QX\u0007\u0003\u0005kSAAa.\u0003:\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005wC\u0016AC1o]>$\u0018\r^5p]&!!q\u0018B[\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001e[\u0006\\W\rV5fe\u0016$\u0007+\u0019:uSRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0019\u0016\u0005\u0005'\u0013y+A\u000fnC.,G+[3sK\u0012\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YM\u000b\u0003\u0003$\n=VC\u0001BC\u0003M\u0019'/Z1uK2{w\r\u0015:pa\u0016\u0014H/[3t)\u0011\u0011\u0019N!7\u0011\t\tm\"Q[\u0005\u0005\u0005/\u0014iD\u0001\u0006Qe>\u0004XM\u001d;jKNDqAa7J\u0001\u0004\u0011i.A\u0005pm\u0016\u0014(/\u001b3fgBA!q\u001cBt\u0005[\u0014iO\u0004\u0003\u0003b\n\r\bcAA21&\u0019!Q\u001d-\u0002\rA\u0013X\rZ3g\u0013\u0011\u0011IOa;\u0003\u00075\u000b\u0007OC\u0002\u0003fb\u0003BAa8\u0003p&!!\u0011\u001fBv\u0005\u0019\u0019FO]5oO\u0006AA/Z1s\t><h\u000eK\u0002K\u0005o\u0004BAa\u001b\u0003z&!!1 B7\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\ftKR,\b\u000fU1si&$\u0018n\u001c8XSRDWj\\2lgR1\u0011q^B\u0001\u0007\u000bAaaa\u0001L\u0001\u0004\u0001\u0017a\u00037fC\u0012,'/\u00129pG\"Dqaa\u0002L\u0001\u0004\u0019I!\u0001\u0005jg2+\u0017\rZ3s!\r961B\u0005\u0004\u0007\u001bA&a\u0002\"p_2,\u0017M\u001c")
public class AbstractPartitionTest {
    private final int brokerId = AbstractPartitionTest$.MODULE$.brokerId();
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private File logDir3;
    private LogManager logManager;
    private TestUtils.MockAlterIsrManager alterIsrManager;
    private TestUtils.MockIsrChangeListener isrChangeListener;
    private LogConfig logConfig;
    private MockConfigRepository configRepository;
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;
    private final TopicPartition tieredTopicPartition = new TopicPartition("tiered-test-topic", 0);
    private final TopicIdPartition tieredTopicIdPartition = new TopicIdPartition("tiered-test-topic", UUID.randomUUID(), 0);
    private LogManager tierEnabledLogManager;
    private final TierReplicaManager tierReplicaManager = (TierReplicaManager)Mockito.mock(TierReplicaManager.class);
    private final TierLogComponents tierLogComponents = TierLogComponents$.MODULE$.EMPTY();
    private final UUID clusterLinkId = UUID.randomUUID();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private LogConfig tieredLogConfig;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public File logDir3() {
        return this.logDir3;
    }

    public void logDir3_$eq(File x$1) {
        this.logDir3 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public TestUtils.MockAlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    public void alterIsrManager_$eq(TestUtils.MockAlterIsrManager x$1) {
        this.alterIsrManager = x$1;
    }

    public TestUtils.MockIsrChangeListener isrChangeListener() {
        return this.isrChangeListener;
    }

    public void isrChangeListener_$eq(TestUtils.MockIsrChangeListener x$1) {
        this.isrChangeListener = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public MockConfigRepository configRepository() {
        return this.configRepository;
    }

    public void configRepository_$eq(MockConfigRepository x$1) {
        this.configRepository = x$1;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    public TopicPartition tieredTopicPartition() {
        return this.tieredTopicPartition;
    }

    public TopicIdPartition tieredTopicIdPartition() {
        return this.tieredTopicIdPartition;
    }

    public LogManager tierEnabledLogManager() {
        return this.tierEnabledLogManager;
    }

    public void tierEnabledLogManager_$eq(LogManager x$1) {
        this.tierEnabledLogManager = x$1;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public UUID clusterLinkId() {
        return this.clusterLinkId;
    }

    public ExecutorService executor() {
        return this.executor;
    }

    public LogConfig tieredLogConfig() {
        return this.tieredLogConfig;
    }

    public void tieredLogConfig_$eq(LogConfig x$1) {
        this.tieredLogConfig = x$1;
    }

    @BeforeEach
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.configRepository_$eq(MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProps));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        int x$9 = CleanerConfig$.MODULE$.apply$default$9();
        String x$10 = CleanerConfig$.MODULE$.apply$default$10();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), this.logConfig(), this.configRepository(), new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9, x$10), this.time(), this.interBrokerProtocolVersion(), TestUtils$.MODULE$.createLogManager$default$7()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.alterIsrManager_$eq(TestUtils$.MODULE$.createAlterIsrManager());
        this.isrChangeListener_$eq(TestUtils$.MODULE$.createIsrChangeListener());
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.interBrokerProtocolVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (Option)new Some((Object)this.tierReplicaManager()), (Option)None$.MODULE$, (Option)None$.MODULE$, (AlterIsrManager)this.alterIsrManager()));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
        Properties tieredLogProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TierEnableProp()), (Object)"true")}))));
        this.tieredLogConfig_$eq(new LogConfig((Map)tieredLogProps, LogConfig$.MODULE$.apply$default$2()));
        this.logDir3_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        .colon.colon x$21 = new .colon.colon((Object)this.logDir3(), (List)Nil$.MODULE$);
        LogConfig x$22 = this.tieredLogConfig();
        MockConfigRepository x$23 = this.configRepository();
        boolean x$11 = false;
        int x$12 = CleanerConfig$.MODULE$.apply$default$1();
        long x$13 = CleanerConfig$.MODULE$.apply$default$2();
        double x$14 = CleanerConfig$.MODULE$.apply$default$3();
        int x$15 = CleanerConfig$.MODULE$.apply$default$4();
        int x$16 = CleanerConfig$.MODULE$.apply$default$5();
        double x$17 = CleanerConfig$.MODULE$.apply$default$6();
        long x$18 = CleanerConfig$.MODULE$.apply$default$7();
        int x$19 = CleanerConfig$.MODULE$.apply$default$9();
        String x$20 = CleanerConfig$.MODULE$.apply$default$10();
        CleanerConfig x$24 = new CleanerConfig(x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$11, x$19, x$20);
        MockTime x$25 = this.time();
        TierLogComponents x$26 = new TierLogComponents((Option)None$.MODULE$, (Option)None$.MODULE$, new TierPartitionStateFactory(true, false));
        ApiVersion x$27 = TestUtils$.MODULE$.createLogManager$default$6();
        this.tierEnabledLogManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)x$21, x$22, x$23, x$24, x$25, x$27, x$26));
        this.tierEnabledLogManager().startup((Set)Predef$.MODULE$.Set().empty());
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.tieredTopicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    public Partition makeTieredPartition(ApiVersion interBrokerProtocolVersion, KafkaZkClient zkClient, KafkaScheduler scheduler) {
        TestUtils.MockAlterIsrManager isrManager;
        if (interBrokerProtocolVersion.$greater((Object)KAFKA_2_6_IV0$.MODULE$)) {
            isrManager = this.alterIsrManager();
        } else {
            Predef$.MODULE$.assert(zkClient != null && scheduler != null);
            isrManager = AlterIsrManager$.MODULE$.apply((Scheduler)scheduler, (Time)this.time(), zkClient);
        }
        return new Partition(this.tieredTopicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), interBrokerProtocolVersion, this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.tierEnabledLogManager(), (Option)new Some((Object)this.tierReplicaManager()), (Option)None$.MODULE$, (Option)new Some((Object)this.executor()), (AlterIsrManager)isrManager);
    }

    public ApiVersion makeTieredPartition$default$1() {
        return ApiVersion$.MODULE$.latestVersion();
    }

    public KafkaZkClient makeTieredPartition$default$2() {
        return null;
    }

    public KafkaScheduler makeTieredPartition$default$3() {
        return null;
    }

    public ApiVersion interBrokerProtocolVersion() {
        return ApiVersion$.MODULE$.latestVersion();
    }

    /*
     * WARNING - void declaration
     */
    public Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    @AfterEach
    public void tearDown() {
        if (this.tmpDir().exists()) {
            this.logManager().shutdown();
            Utils.delete((File)this.tmpDir());
            TestUtils$.MODULE$.clearYammerMetrics();
        }
    }

    public Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader) {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        int controllerEpoch = 0;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        } else {
            Assertions.assertTrue((boolean)this.partition().makeFollower(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId() + 1).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become follower transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }
}

